/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.MetadataBuilder;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.servers.ServersUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public abstract class LibraryBuilder<B extends LibraryBuilder<B>>
extends MetadataBuilder<SASLibraryInterface, SASLibrary, B> {
    protected String folderPath = null;
    protected FolderInterface folder = null;
    protected String libref = null;
    protected String engine = null;
    protected String dataProviderLibraryPath = null;
    protected SASLibraryInterface dataProviderLibrary = null;
    protected boolean isDBMSLibrary = false;
    protected String dataServerName = null;
    protected ServerComponentInterface dataServer = null;
    protected String dataServerPublicType = null;
    protected String schema = null;
    protected String connectionName = null;
    protected SASClientConnectionInterface connection = null;
    protected String defaultLoginUserId = null;
    protected LoginInterface defaultLogin = null;
    protected Preassigned preassigned = Preassigned.NONE;
    protected Collection<String> serverContextNames = new ArrayList<String>();
    protected Collection<ServerContextInterface> serverContexts = new ArrayList<ServerContextInterface>();

    LibraryBuilder() {
        super(SASLibrary.class, "Library", 1000000.0);
    }

    public B folder(String folderPath) {
        this.folderPath = folderPath;
        this.folder = null;
        return (B)this;
    }

    public B folder(FolderInterface folder) {
        this.folder = folder;
        this.folderPath = null;
        return (B)this;
    }

    public B libref(String libref) {
        if (libref.length() > 8) {
            throw new IllegalArgumentException("Invalid libref");
        }
        this.libref = libref;
        return (B)this;
    }

    public B preassignedNative() {
        this.preassigned = Preassigned.NATIVE;
        return (B)this;
    }

    public B preassignedMLE() {
        this.preassigned = Preassigned.MLE;
        return (B)this;
    }

    public B preassignedExternal() {
        this.preassigned = Preassigned.EXTERNAL;
        return (B)this;
    }

    public B assignedServer(String contextName) {
        Names.validateOMRObjectName(contextName, true);
        this.serverContextNames.add(contextName);
        return (B)this;
    }

    public B assignedServer(ServerContextInterface context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.serverContexts.add(context);
        return (B)this;
    }

    public B dataProviderLibrary(String libraryPath) {
        this.dataProviderLibraryPath = libraryPath;
        return (B)this;
    }

    public B dataProviderLibrary(SASLibraryInterface library) {
        this.dataProviderLibrary = library;
        return (B)this;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        super.validate(user);
        try {
            RootFolderInterface rootFolder;
            if (this.folder == null) {
                if (this.folderPath == null) {
                    throw new IllegalStateException("Folder must be specified");
                }
                rootFolder = this.metadataServer.getRootFolder();
                this.folder = (FolderInterface)this.metadataServer.getObjectByPath(new PathUrl(rootFolder.getPathUrl(), this.folderPath));
                if (this.folder == null) {
                    throw new IllegalArgumentException("Folder \"" + this.folderPath + "\" not found");
                }
            }
            if (this.libref == null) {
                throw new IllegalStateException("Libref must be specified");
            }
            if (this.folder.hasDuplicate(this.name, "Library")) {
                throw new ItemAlreadyExistsException("Folder " + this.folder.getPathUrl().getDisplayPath() + " already contains a library named \"" + this.name + "\"");
            }
            if (this.isDBMSLibrary) {
                if (this.connection != null) {
                    this.connectionName = this.connection.getName();
                    this.dataServer = (ServerComponentInterface)this.connection.getSource();
                    this.dataServerName = this.dataServer.getName();
                } else {
                    if (this.dataServer == null && this.dataServerName == null) {
                        throw new IllegalStateException("Database server must be specified");
                    }
                    if (this.dataServer == null) {
                        ServerInterface dataServerTemp = ServersUtil.getServer(user, this.dataServerName);
                        if (dataServerTemp == null) {
                            throw new IllegalArgumentException("Server " + this.dataServerName + " does not exist");
                        }
                        if (!(dataServerTemp instanceof ServerComponentInterface) || this.dataServerPublicType != null && !dataServerTemp.getType().equalsIgnoreCase(this.dataServerPublicType)) {
                            throw new IllegalArgumentException("Server " + this.dataServerName + " is not a " + this.dataServerPublicType);
                        }
                        this.dataServer = (ServerComponentInterface)dataServerTemp;
                    } else {
                        this.dataServerName = this.dataServer.getName();
                    }
                    List connections = this.dataServer.getSourceConnections();
                    if (connections.isEmpty()) {
                        throw new IllegalArgumentException("Server " + this.dataServerName + " has no connections");
                    }
                    if (this.connectionName == null) {
                        this.connection = (SASClientConnectionInterface)connections.get(0);
                        this.connectionName = this.connection.getName();
                    } else {
                        for (SASClientConnectionInterface conn : connections) {
                            if (!this.connectionName.equalsIgnoreCase(conn.getName())) continue;
                            this.connection = conn;
                            break;
                        }
                        if (this.connection == null) {
                            throw new IllegalArgumentException("Connection \"" + this.connectionName + " does not exist for server " + this.dataServerName);
                        }
                    }
                }
                if (this.defaultLoginUserId != null && this.defaultLogin == null) {
                    String authDomain = this.connection.getDomain();
                    Login loginObject = this.findMetadata("*[@Userid='" + StringEscapeUtils.escapeXml11((String)this.defaultLoginUserId) + "][Domain/AuthenticationDomain[@Name='" + StringEscapeUtils.escapeXml11((String)authDomain) + "']]", Login.class);
                    if (loginObject == null) {
                        throw new IllegalArgumentException("Login " + this.defaultLoginUserId + " not found for domain " + authDomain);
                    }
                    this.defaultLogin = (LoginInterface)this.metadataServer.factoryProcess(loginObject);
                }
                if (this.dataProviderLibrary == null && this.dataProviderLibraryPath != null) {
                    rootFolder = this.metadataServer.getRootFolder();
                    this.dataProviderLibrary = (SASLibraryInterface)this.metadataServer.getObjectByPath(new PathUrl(rootFolder.getPathUrl(), this.dataProviderLibraryPath));
                    if (this.dataProviderLibrary == null) {
                        throw new IllegalArgumentException("Data provider library \"" + this.dataProviderLibraryPath + "\" not found");
                    }
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public SASLibraryInterface build(UserContextInterface user) throws ItemAlreadyExistsException, IllegalArgumentException, IllegalStateException, ServiceException {
        return (SASLibraryInterface)this.buildInternal(user);
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        if (this.name == null) {
            throw new IllegalStateException("Name must be specified");
        }
        super.createObject();
        if (this.libref != null) {
            ((SASLibrary)this.built).setLibref(this.libref);
        }
        if (this.engine != null) {
            ((SASLibrary)this.built).setEngine(this.engine);
        }
        ((SASLibrary)this.built).getTrees().add(this.folder.getRepositoryEntity());
        if (this.preassigned != Preassigned.NONE) {
            ((SASLibrary)this.built).setIsPreassigned(1);
            PropertySet propSet = this.createMetadata("PreAssignedLibrarySet", PropertySet.class);
            propSet.setOwningObject((Root)this.built);
            Property preassignProp = this.createMetadata("PreAssignedLibraryTypePanel.PreAssignedType.Name.txt", Property.class);
            preassignProp.setPropertyName("PreAssignmentType");
            preassignProp.setSQLType(12);
            if (this.preassigned == Preassigned.NATIVE) {
                preassignProp.setDefaultValue("Native");
            } else if (this.preassigned == Preassigned.MLE) {
                preassignProp.setDefaultValue("MLE");
            } else {
                preassignProp.setDefaultValue("External");
            }
            preassignProp.setAssociatedPropertySet(propSet);
        }
        if (this.isDBMSLibrary) {
            ((SASLibrary)this.built).setIsDBMSLibname(1);
            ((SASLibrary)this.built).setLibraryConnection((SASClientConnection)this.connection.getRepositoryEntity());
            if (this.schema != null) {
                DatabaseSchema schemaObject = this.createMetadata(this.name, DatabaseSchema.class);
                schemaObject.setSchemaName(this.schema);
                schemaObject.getDeployedComponents().add(this.dataServer.getRepositoryEntity());
                schemaObject.getUsedByPackages().add((Object)this.built);
            }
            if (this.defaultLogin != null) {
                ((SASLibrary)this.built).setDefaultLogin((Login)this.defaultLogin.getRepositoryEntity());
            }
        }
        for (ServerContextInterface serverContext : this.serverContexts) {
            ((SASLibrary)this.built).getDeployedComponents().add(serverContext.getRepositoryEntity());
        }
        for (String serverContextName : this.serverContextNames) {
            ServerContext serverContext = this.findMetadataByName(serverContextName, ServerContext.class);
            if (serverContext == null) continue;
            ((SASLibrary)this.built).getDeployedComponents().add((Object)serverContext);
        }
        if (this.dataProviderLibrary != null) {
            this.builtSmartObject = (SASLibraryInterface)this.metadataServer.factoryProcess(this.built);
        }
    }

    protected static enum Preassigned {
        NONE,
        NATIVE,
        MLE,
        EXTERNAL;

    }
}

