/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.dav.DAVFolder;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVPackage
extends DAVFolder {
    private static final String P_CREATIONDATETIME = "{http://www.sas.com/rnd/itech/WebDAV}creationDatetime";
    private static final String P_EXPIRATIONDATETIME = "{http://www.sas.com/rnd/itech/WebDAV}expirationDatetime";
    private static final String P_ABSTRACT = "{http://www.sas.com/rnd/itech/WebDAV}abstract";
    private static final String P_DESCRIPTION = "{http://www.sas.com/rnd/itech/WebDAV}description";
    private static final String P_PUBLISHERURL = "{http://www.sas.com/rnd/itech/WebDAV}publisherURI";
    private static final String P_PUBLISHERALIAS = "{http://www.sas.com/rnd/itech/WebDAV}publisherAlias";
    private static final String P_CREATIONDATETIMENUMERIC = "{http://www.sas.com/rnd/itech/WebDAV}creationDatetimeNumeric";
    private static final String P_EXPIRATIONDATETIMENUMERIC = "{http://www.sas.com/rnd/itech/WebDAV}expirationDatetimeNumeric";

    public DAVPackage(RepositoryInterface repos, String reposId) {
        super(repos, reposId);
        this._objectClass = "package";
    }

    public DAVPackage(RepositoryData entity) {
        super(entity);
        this._objectClass = "package";
    }

    public String getCreationDate() {
        return this.getAttribute(P_CREATIONDATETIME);
    }

    public String getExpirationDate() {
        return this.getAttribute(P_EXPIRATIONDATETIME);
    }

    public String getCreationDateNumeric() {
        return this.getAttribute(P_CREATIONDATETIMENUMERIC);
    }

    public String getExpirationDateNumeric() {
        return this.getAttribute(P_EXPIRATIONDATETIMENUMERIC);
    }

    public String getAbstract() {
        return this.getAttribute(P_ABSTRACT);
    }

    public Map getUserProperties() {
        Map allprops = this.getProperties();
        HashMap userprops = new HashMap();
        for (Map.Entry me : allprops.entrySet()) {
            String key = (String)me.getKey();
            if (!key.startsWith("{}")) continue;
            userprops.put(key, me.getValue());
        }
        return userprops;
    }

    @Override
    public String getObjectClass() {
        return "package";
    }

    @Override
    public String getType() {
        return "package";
    }

    @Override
    public String getDescription() {
        return this.getAttribute(P_DESCRIPTION);
    }

    public String getPublisherURI() {
        return this.getAttribute(P_PUBLISHERURL);
    }

    public String getPublisherAlias() {
        return this.getAttribute(P_PUBLISHERALIAS);
    }
}

