/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.AccessControlEntryInterface;
import com.sas.services.information.metadata.AllUsersIdentity;
import com.sas.services.information.metadata.AuthenticatedIdentity;
import com.sas.services.information.metadata.DAVAccessControlEntry;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyIdentity;
import com.sas.services.information.metadata.ReferenceIdentity;
import com.sas.services.information.metadata.UnauthenticatedIdentity;
import com.sas.services.information.metadata.VirtualMetadata;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.security.Permission;
import com.sas.services.security.PermissionInterface;
import com.sas.services.util.XMLUtil;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.NamespaceMap;
import com.sas.services.webdav.TransformerFactoryFactory;
import com.sas.services.webdav.Utils;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVEntity
implements DAVEntityInterface,
Serializable {
    private static final long serialVersionUID = -2893752019278758267L;
    protected Map _properties = null;
    protected Map _schemaProperties = null;
    protected RepositoryInterface _repos;
    protected DAVResource _resource;
    protected String _name;
    protected String _fullUrl;
    protected String _reposId;
    protected byte[] content;
    protected String _acl = null;
    protected List aclList = null;
    private boolean _hasACLUpdates = false;
    private int _ACLstatus = 0;
    protected boolean hasBeenFetched = false;
    private static final String P_GUID = "{http://www.sas.com/xml/namespace/services.webdav-1.1}guid";
    private static final String P_DESCRIPTION = "{http://www.sas.com/xml/namespace/services.webdav-1.1}description";
    private static final String P_REMARKS = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}remarks";
    private static final String P_NUM_REMARKS = "{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}numRemarks";
    public static final int UNSET = 0;
    public static final int LOCAL = 1;
    public static final int STORE = 2;
    protected String _nameAttribute;
    protected String _descAttribute;
    protected String _objectClass;
    private HashMap _setUpdates = new HashMap();
    private HashMap _removeUpdates = new HashMap();
    private String _contentClass = null;
    private boolean _isDeleted = false;

    public DAVEntity(String url, Map properties) {
        this.hasBeenFetched = false;
        this._resource = null;
        this._properties = properties;
        this._fullUrl = url;
        this._objectClass = (String)this._properties.get("{http://www.sas.com/rnd/itech/WebDAV}type");
        if (this._objectClass == null) {
            this._objectClass = "unknown";
        }
        this._name = Utils.getRelativePath((String)this._fullUrl);
    }

    public DAVEntity(RepositoryData entity) {
        this.hasBeenFetched = true;
        this._repos = entity.getRepository();
        this._reposId = entity.getReposId();
        this._resource = null;
        this._properties = entity;
        try {
            String reposUrl = ((DAVRepositoryInterface)this._repos).getHttpUrl();
            int p = this._reposId.lastIndexOf(47);
            this._fullUrl = reposUrl;
            if (p > 0) {
                this._fullUrl = Utils.addSegment((String)reposUrl, (String)this._reposId.substring(0, this._reposId.lastIndexOf("/")));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this._objectClass = (String)this._properties.get("{http://www.sas.com/rnd/itech/WebDAV}type");
        if (this._objectClass == null) {
            this._objectClass = "unknown";
        }
        this._name = Utils.getRelativePath((String)this._fullUrl);
    }

    public DAVEntity(RepositoryInterface repos, String reposId) {
        this._repos = repos;
        this._reposId = reposId;
        try {
            String reposUrl = ((DAVRepositoryInterface)this._repos).getHttpUrl();
            this._fullUrl = Utils.addSegment((String)reposUrl, (String)this._reposId.substring(0, this._reposId.lastIndexOf("/")));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this._name = Utils.getRelativePath((String)this._fullUrl);
        this.hasBeenFetched = false;
        this._properties = new HashMap();
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        try {
            if (this._repos != null) {
                this._repos.deleteEntity(new Metadata(this));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DAVEntityInterface copy(DAVFolderInterface folder) {
        try {
            if (this._repos == null) {
                return null;
            }
            String resName = this.getName();
            String targetPath = Utils.addSegment((String)folder.getUrl(), (String)resName);
            this._resource.copy(targetPath);
            try {
                MetadataInterface mi = this._repos.fetch(targetPath);
                if (mi != null) {
                    return (DAVEntityInterface)mi.getRepositoryEntity();
                }
            }
            catch (ServiceException serviceException) {}
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DAVEntityInterface move(DAVFolderInterface folder) {
        try {
            if (this._repos == null) {
                return null;
            }
            String resName = this.getName();
            String targetPath = Utils.addSegment((String)folder.getUrl(), (String)resName);
            this._resource.move(targetPath);
            try {
                MetadataInterface mi = this._repos.fetch(targetPath);
                if (mi != null) {
                    return (DAVEntityInterface)mi.getRepositoryEntity();
                }
            }
            catch (ServiceException serviceException) {}
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getUrl() {
        return this._fullUrl;
    }

    @Override
    public DAVFolderInterface getFolder() {
        return null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getAttribute(String key) {
        if (!this.isUpdatePending() && !this.hasBeenFetched) {
            this.fetchEntity();
        }
        return (String)this._properties.get(key);
    }

    @Override
    public Map getAttributes() {
        return this._properties;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this._properties.put(key, value);
        this._setUpdates.put(key, value);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this._properties.put(key, value);
        this._setUpdates.put(key, value);
    }

    @Override
    public void deleteAttribute(String key) {
        this._properties.remove(key);
        this._removeUpdates.put(key, "irrelevant");
    }

    @Override
    public void setAttributes(Map attributeMap) {
        if (attributeMap != null) {
            for (Map.Entry entry : attributeMap.entrySet()) {
                this._properties.put(entry.getKey(), entry.getValue());
                this._setUpdates.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void addAttributes(Map attributeMap) {
        if (attributeMap != null) {
            for (Map.Entry entry : attributeMap.entrySet()) {
                this._properties.put(entry.getKey(), entry.getValue());
                this._setUpdates.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void deleteAttributes(List attributes) {
        if (attributes != null) {
            for (String attributeName : attributes) {
                this._properties.remove(attributeName);
                this._removeUpdates.put(attributeName, "irrelevant");
            }
        }
    }

    @Override
    public String getType() {
        return this._objectClass;
    }

    @Override
    public void setReposId(String reposId) {
        this._reposId = reposId;
    }

    @Override
    public String getReposId() {
        if (this._repos == null) {
            return this._fullUrl + "/entity";
        }
        try {
            URI uri = new URI(null, null, this._reposId, null);
            return uri.getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return this._reposId;
        }
    }

    public void setRepository(RepositoryInterface repos) {
        this._repos = repos;
    }

    @Override
    public boolean isCollection() {
        return Utils.isCollection((Map)this._properties);
    }

    @Override
    public boolean isUpdatePending() {
        return this._setUpdates.size() > 0 || this._removeUpdates.size() > 0 || this._hasACLUpdates;
    }

    public void clearLocalLists() {
        this._setUpdates.clear();
        this._removeUpdates.clear();
        this._hasACLUpdates = false;
    }

    @Override
    public void refresh(DAVEntityInterface entity) {
        this._properties = entity.getProperties();
        if (entity.isDeleted()) {
            this.setDeleted();
        }
        this.clearLocalLists();
    }

    @Override
    public void refresh() {
        if (this._repos == null) {
            return;
        }
        try {
            MetadataInterface mi = this._repos.fetch(this._reposId);
            if (mi != null) {
                this.refresh((DAVEntityInterface)mi.getRepositoryEntity());
            }
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.hasBeenFetched = true;
    }

    public String toString() {
        return this._objectClass + ":   ";
    }

    protected void addUpdateSingle(String attributeName, String newValue) {
        this._setUpdates.put(attributeName, newValue);
    }

    protected void addUpdateMultiple(String attributeName, ArrayList newValue) {
        if (newValue.size() == 0) {
            newValue = null;
        }
    }

    public void commitUpdates() throws ServiceException, RemoteException {
        ((DAVRepositoryInterface)this._repos).updateEntity(this);
    }

    @Override
    public void update() throws ServiceException, RemoteException {
        this.commitUpdates();
        this.clearLocalLists();
    }

    @Override
    public void setContentClass(String contentClass) {
        if (this._contentClass == null) {
            this._contentClass = contentClass;
        }
        this._objectClass = this._contentClass;
    }

    @Override
    public RepositoryInterface getRepository() {
        return this._repos;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getDescription() {
        return (String)this._properties.get(P_DESCRIPTION);
    }

    @Override
    public void setDescription(String desc) {
        this.setAttribute(P_DESCRIPTION, desc);
    }

    public String getObjectClass() {
        return this._objectClass;
    }

    @Override
    public String getURL() {
        return this._fullUrl;
    }

    @Override
    public Map getProperties() {
        return this._properties;
    }

    private void setProperties(Map propertyMap) {
        this._properties = propertyMap;
    }

    @Override
    public Map getSetUpdates() {
        return this._setUpdates;
    }

    @Override
    public Map getRemoveUpdates() {
        return this._removeUpdates;
    }

    @Override
    public DAVResource getDAVResource() {
        return this._resource;
    }

    public void fetchEntity() {
        try {
            MetadataInterface mi = this._repos.fetch(this._reposId, true);
            if (mi != null) {
                DAVEntityInterface d = (DAVEntityInterface)mi.getRepositoryEntity();
                this.setProperties(d.getAttributes());
                this.setACL(d.getACL());
            }
            this.hasBeenFetched = true;
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public String getCreateDate() {
        return this.getAttribute("{DAV:}creationdate");
    }

    @Override
    public String getModifyDate() {
        return this.getAttribute("{DAV:}getlastmodified");
    }

    @Override
    public String[] getRemarksKeys() {
        int nkeys = 0;
        boolean hasNKeys = true;
        try {
            nkeys = Integer.parseInt(this.getAttribute(P_NUM_REMARKS));
        }
        catch (NumberFormatException e) {
            hasNKeys = false;
        }
        if (hasNKeys) {
            String[] keys = new String[nkeys];
            for (int i = 0; i < nkeys; ++i) {
                keys[i] = this.getAttribute("{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}remarks_" + i);
            }
            return keys;
        }
        ArrayList<String> _keysList = new ArrayList<String>();
        String _keys = this.getAttribute(P_REMARKS);
        if (_keys != null) {
            StringTokenizer st = new StringTokenizer(_keys, "|");
            while (st.hasMoreTokens()) {
                _keysList.add(st.nextToken());
            }
        }
        return _keysList.toArray(new String[0]);
    }

    @Override
    public void setRemarksKeys(String[] keys) {
        this.setAttribute(P_NUM_REMARKS, Integer.toString(keys.length));
        for (int i = 0; i < keys.length; ++i) {
            this.setAttribute("{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}remarks_" + i, keys[i]);
        }
        if (this.getAttribute(P_REMARKS) != null) {
            this.deleteAttribute(P_REMARKS);
        }
    }

    @Override
    public void setACL(String acl) {
        this._acl = acl;
        this.aclList = this.getAccessControls();
        this._ACLstatus = 1;
    }

    @Override
    public String getACL() {
        if (!this.hasBeenFetched) {
            this.fetchEntity();
        }
        if (this._ACLstatus == 0) {
            try {
                ((DAVRepositoryInterface)this._repos).setACLFromStore(this);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this._ACLstatus = 2;
        }
        return this._acl;
    }

    @Override
    public List getAccessControlList() {
        if (!this.hasBeenFetched) {
            this.fetchEntity();
        }
        if (this._ACLstatus == 0) {
            try {
                ((DAVRepositoryInterface)this._repos).setACLFromStore(this);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this._ACLstatus = 2;
        }
        return this.aclList;
    }

    public void setAccessControls(List aclList) {
        this.aclList = aclList;
        this._ACLstatus = 1;
    }

    private List getAccessControls() {
        ArrayList<DAVAccessControlEntry> results = new ArrayList<DAVAccessControlEntry>();
        if (this._acl == null) {
            return results;
        }
        Document doc = null;
        try {
            doc = XMLUtil.convertStringToDocument(this._acl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doc == null) {
            return results;
        }
        Element _aclElement = (Element)doc.getFirstChild();
        VirtualMetadata principalIdentity = null;
        NodeList acelist = _aclElement.getChildNodes();
        String inheritedfrom = null;
        int aceNo = 0;
        Node n = null;
        Element ace = null;
        NodeList nl = null;
        String type = null;
        for (int i = 0; i < acelist.getLength(); ++i) {
            Element inherited;
            NodeList nl2;
            boolean isinherited;
            principalIdentity = null;
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            n = acelist.item(i);
            if (!(n instanceof Element) || !"ace".equals((ace = (Element)n).getLocalName())) continue;
            ++aceNo;
            nl = ace.getElementsByTagNameNS("DAV:", "grant");
            if (nl.getLength() > 0) {
                type = "grant";
            } else {
                nl = ace.getElementsByTagNameNS("DAV:", "deny");
                if (nl.getLength() > 0) {
                    type = "deny";
                }
            }
            nl = ace.getElementsByTagNameNS("DAV:", "privilege");
            for (int j = 0; j < nl.getLength(); ++j) {
                Element privilege = (Element)nl.item(j);
                NodeList nl22 = privilege.getChildNodes();
                for (int k = 0; k < nl22.getLength(); ++k) {
                    if (!(nl22.item(k) instanceof Element)) continue;
                    String action = '{' + nl22.item(k).getNamespaceURI() + '}' + nl22.item(k).getLocalName();
                    Permission p = new Permission(type, action, null);
                    permissions.add(p);
                }
            }
            nl = ace.getElementsByTagNameNS("DAV:", "protected");
            boolean isprotected = nl.getLength() > 0;
            nl = ace.getElementsByTagNameNS("DAV:", "inherited");
            boolean bl = isinherited = nl.getLength() > 0;
            if (isinherited && (nl2 = (inherited = (Element)nl.item(0)).getElementsByTagNameNS("DAV:", "href")).getLength() > 0) {
                Element href = (Element)nl2.item(0);
                Node hrefVal = href.getFirstChild();
                inheritedfrom = hrefVal.getNodeValue();
            }
            if ((nl = ace.getElementsByTagNameNS("DAV:", "invert")).getLength() > 0) {
                // empty if block
            }
            if ((nl = ace.getElementsByTagNameNS("DAV:", "principal")).getLength() > 0) {
                NodeList nl23 = nl.item(0).getChildNodes();
                for (int j = 0; j < nl23.getLength(); ++j) {
                    if (!(nl23.item(j) instanceof Element)) {
                        String text;
                        if (!(nl23.item(j) instanceof Text) || !(text = ((Text)nl23.item(j)).getNodeValue()).startsWith("http")) continue;
                        principalIdentity = new ReferenceIdentity(text);
                        continue;
                    }
                    Element principal = (Element)nl23.item(j);
                    if ("all".equals(principal.getLocalName())) {
                        principalIdentity = new AllUsersIdentity();
                        continue;
                    }
                    if ("authenticated".equals(principal.getLocalName())) {
                        principalIdentity = new AuthenticatedIdentity();
                        continue;
                    }
                    if ("unauthenticated".equals(principal.getLocalName())) {
                        principalIdentity = new UnauthenticatedIdentity();
                        continue;
                    }
                    if ("href".equals(principal.getLocalName())) {
                        NodeList _nl = principal.getChildNodes();
                        String reference = null;
                        for (int k = 0; k < _nl.getLength(); ++k) {
                            if (!(_nl.item(k) instanceof Text)) continue;
                            reference = _nl.item(k).getNodeValue();
                        }
                        principalIdentity = new ReferenceIdentity(reference);
                        continue;
                    }
                    if (!"property".equals(principal.getLocalName())) continue;
                    String property = null;
                    String ns = null;
                    NodeList _nl = principal.getChildNodes();
                    for (int k = 0; k < _nl.getLength(); ++k) {
                        if (!(_nl.item(k) instanceof Element)) continue;
                        property = _nl.item(k).getLocalName();
                        ns = _nl.item(k).getNamespaceURI();
                    }
                    principalIdentity = new PropertyIdentity(ns, property);
                }
            }
            DAVAccessControlEntry _ace = new DAVAccessControlEntry((IdentityInterface)((Object)principalIdentity), permissions, isprotected, isinherited);
            if (isinherited) {
                _ace.setInheritedFrom(inheritedfrom);
            }
            results.add(_ace);
        }
        return results;
    }

    @Override
    public String getUpdateableACL() {
        Document doc = null;
        NamespaceMap nsMap = new NamespaceMap();
        nsMap.addNSPrefix("d", "DAV:");
        String PREFIX = "d:";
        if (!this._hasACLUpdates) {
            return null;
        }
        if (this.aclList == null) {
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = TransformerFactoryFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            doc = documentBuilder.newDocument();
            Iterator aceItems = this.aclList.iterator();
            Element aclE = doc.createElementNS("DAV:", PREFIX + "acl");
            while (aceItems.hasNext()) {
                AccessControlEntryInterface ace = (AccessControlEntryInterface)aceItems.next();
                if (ace instanceof DAVAccessControlEntry && (((DAVAccessControlEntry)ace).isProtected() || ((DAVAccessControlEntry)ace).isInherited())) continue;
                List identities = ace.getIdentities();
                IdentityInterface identity = (IdentityInterface)identities.get(0);
                Element principalE = doc.createElementNS("DAV:", PREFIX + "principal");
                Element identityE = null;
                if (identity instanceof AllUsersIdentity) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "all");
                } else if (identity instanceof AuthenticatedIdentity) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "authenticated");
                } else if (identity instanceof UnauthenticatedIdentity) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "unauthenticated");
                } else if (identity instanceof ReferenceIdentity) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "href");
                    identityE.appendChild(doc.createTextNode(identity.getName()));
                } else if (identity instanceof PropertyIdentity) {
                    identityE = doc.createElementNS("DAV:", PREFIX + "property");
                    String namespaceURI = ((PropertyIdentity)identity).getNamespaceURI();
                    String propertyName = ((PropertyIdentity)identity).getPropertyName();
                    String nsprefix = nsMap.getPrefixforURI(namespaceURI);
                    identityE.appendChild(doc.createElementNS(namespaceURI, nsprefix + ':' + propertyName));
                }
                principalE.appendChild(identityE);
                Element privilegeE = null;
                Element privE = null;
                List permissions = ace.getPermissions();
                Iterator permissionList = permissions.iterator();
                Element grantdenyE = doc.createElementNS("DAV:", PREFIX + "grant");
                while (permissionList.hasNext()) {
                    int ptr1;
                    String privilege;
                    int ptr2;
                    PermissionInterface permission = (PermissionInterface)permissionList.next();
                    if (grantdenyE == null) {
                        if (permission.getType() == "DENY") {
                            grantdenyE = doc.createElementNS("DAV:", PREFIX + "deny");
                        } else if (permission.getType() == "GRANT") {
                            grantdenyE = doc.createElementNS("DAV:", PREFIX + "grant");
                        }
                    }
                    if ((ptr2 = (privilege = permission.getAction()).indexOf(125)) > 0 && (ptr1 = privilege.indexOf(123)) < ptr2) {
                        String ns = privilege.substring(ptr1 + 1, ptr2);
                        String nsprefix = nsMap.getPrefixforURI(ns);
                        String priv = privilege.substring(ptr2 + 1);
                        privE = doc.createElementNS(ns, nsprefix + ':' + priv);
                    }
                    if (privE == null) continue;
                    privilegeE = doc.createElementNS("DAV:", PREFIX + "privilege");
                    privilegeE.appendChild(privE);
                    grantdenyE.appendChild(privilegeE);
                }
                Element aceE = doc.createElementNS("DAV:", PREFIX + "ace");
                aceE.appendChild(principalE);
                if (grantdenyE != null) {
                    aceE.appendChild(grantdenyE);
                }
                aclE.appendChild(aceE);
            }
            doc.appendChild(aclE);
            if (aclE.hasChildNodes()) {
                return XMLUtil.node2String(doc);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isDeleted() {
        return this._isDeleted;
    }

    @Override
    public void setDeleted() {
        this._isDeleted = true;
    }

    @Override
    public String getGUID() {
        return this.getAttribute(P_GUID);
    }

    @Override
    public void setGUID(String guid) {
        this.setAttribute(P_GUID, guid);
    }

    @Override
    public void addAccessControlEntry(AccessControlEntryInterface ace) {
        if (this._ACLstatus == 0) {
            this.getACL();
        }
        if (this.aclList != null) {
            this.aclList.add(ace);
            this._hasACLUpdates = true;
            this._ACLstatus = 1;
        }
    }

    @Override
    public void removeAccessControlEntry(AccessControlEntryInterface ace) {
        if (this.aclList != null) {
            this.aclList.remove(ace);
            this._hasACLUpdates = true;
            this._ACLstatus = 1;
        }
    }
}

