/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dataexplorer;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.dataexplorer.BookmarkEntryInterface;
import com.sas.services.information.metadata.dataexplorer.DataExplorationEntryInterface;
import com.sas.services.information.metadata.dataexplorer.OMRUtils;
import com.sas.services.information.metadata.lookup.LookupResultsInterface;
import com.sas.services.information.metadata.lookup.LookupServiceFactory;
import com.sas.services.util.UpgradeInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SASScope
public class OMRDataExplorationEntry
extends Metadata
implements DataExplorationEntryInterface,
UpgradeInterface {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "OMRDataExplorationEntry.";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private transient String imapName = null;
    private transient PathUrl imapPath = null;
    private boolean inUpgrade = false;
    private static final String SBIP_URL_SUFFIX = "\"";
    private static final String SBIP_URL_PREFIX = "\"SBIP://";

    public OMRDataExplorationEntry() throws RemoteException {
        super(OMRDataExplorationEntry.class);
    }

    public OMRDataExplorationEntry(Transformation o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        String roleType = o.getTransformRole();
        if (!roleType.equals(this.getType())) {
            throw new IllegalArgumentException(Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource(RB_KEY, "unableToCreate.fmt.txt"), (Object)o.toString()));
        }
    }

    public OMRDataExplorationEntry(TransformationImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        String roleType = o.getTransformRole();
        if (!roleType.equals(this.getType())) {
            throw new IllegalArgumentException(Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource(RB_KEY, "unableToCreate.fmt.txt"), (Object)o.toString()));
        }
    }

    public OMRDataExplorationEntry(TransformationImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        String roleType = o.getTransformRole();
        if (!roleType.equals(this.getType())) {
            throw new IllegalArgumentException(Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource(RB_KEY, "unableToCreate.fmt.txt"), (Object)o.toString()));
        }
    }

    public OMRDataExplorationEntry(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRDataExplorationEntry.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            Transformation transform = (Transformation)omirepository.createMetadata(name, "Transformation");
            transform.setPublicType("DataExploration");
            transform.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            transform.setTransformRole(this.getType());
            this._repositoryObject = transform;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), (Throwable)((Object)ex));
                }
            }
        }
        catch (ServiceException ex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() {
        return "DataExploration";
    }

    @Override
    public FolderInterface getParent() throws ServiceException, RemoteException {
        FolderInterface result = super.getParent();
        if (null == result) {
            try {
                result = OMRUtils.getFolderForPath(this.getRepository(), new PathUrl(this.getLocation()), false);
            }
            catch (MdException mde) {
                result = null;
            }
            catch (NullPointerException npe) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (this.isDeleted()) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        OMRUtils.checkPermissions(this, "WriteMetadata", this.getParent());
        try {
            ArrayList<Transformation> omrObjectsToDelete = new ArrayList<Transformation>();
            CMetadata omrObject = (CMetadata)this.getRepositoryEntity();
            if (omrObject != null && omrObject instanceof Transformation) {
                Transformation transform = (Transformation)omrObject;
                omrObjectsToDelete.addAll((Collection<Transformation>)transform.getProperties());
                omrObjectsToDelete.addAll((Collection<Transformation>)transform.getKeywords());
                AssociationList notes = transform.getNotes();
                if (notes != null) {
                    for (Text text : notes) {
                        Transformation bk = (Transformation)text.getAssociatedTransformation();
                        if (bk == null) continue;
                        omrObjectsToDelete.addAll((Collection<Transformation>)bk.getProperties());
                        omrObjectsToDelete.addAll((Collection<Transformation>)bk.getSourceCodes());
                        omrObjectsToDelete.add(bk);
                    }
                }
                omrObjectsToDelete.add(transform);
            }
            OMIRepositoryInterface repos = (OMIRepositoryInterface)this.getRepository();
            repos.deleteEntities(omrObjectsToDelete);
            super.delete();
            this.destroy();
        }
        catch (MdException e) {
            throw new ServiceException(e, null);
        }
    }

    @Override
    public synchronized void update() throws ServiceException, RemoteException {
        try {
            if (this.shouldConvert()) {
                this.upgradeFromPreviousVersion();
            }
        }
        catch (MdException mde) {
            throw new ServiceException(mde);
        }
        super.update();
    }

    private String getAttributeValue(NodeList nList, String[] attrList) {
        if (null == nList) {
            return null;
        }
        if (null == attrList) {
            return null;
        }
        for (int i = 0; i < nList.getLength(); ++i) {
            Element elem = (Element)nList.item(i);
            for (int a = 0; a < attrList.length; ++a) {
                String val = elem.getAttribute(attrList[a]);
                if (null == val || val.trim().length() == 0) continue;
                return val;
            }
        }
        return null;
    }

    @Override
    public boolean addBookmark(BookmarkEntryInterface bookmark) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null == bookmark) {
            return false;
        }
        try {
            Object deiObj = this.getRepositoryEntity();
            Object bkmObj = bookmark.getRepositoryEntity();
            if (null == bkmObj) {
                return false;
            }
            if (null == deiObj) {
                return false;
            }
            TextStore txt = bookmark.getTextStore();
            if (null != txt && this.getTextStoreById(txt.getId()) != null) {
                return false;
            }
            if (deiObj instanceof Transformation && bkmObj instanceof Transformation) {
                Transformation deiTrans = (Transformation)deiObj;
                Transformation bkmTrans = (Transformation)bkmObj;
                this.updateBookmarkNotes(deiTrans, bkmTrans);
            }
            return true;
        }
        catch (Exception e) {
            this.logMessage(Level.ERROR, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.BookmarkAddError2.fmt.txt"), (Object)bookmark.toString(), (Object)this.toString()), OMRDataExplorationEntry.class.getName(), e);
            return false;
        }
    }

    private void updateBookmarkNotes(Transformation deiTrans, Transformation bkmTrans) throws MdException, RemoteException, ServiceException {
        if (!this.inUpgrade) {
            OMRUtils.checkPermissions(this, "WriteMetadata", this.getParent());
        }
        AssociationList bkmNotesList = deiTrans.getNotes();
        AssociationList bkmSrcList = bkmTrans.getSourceCodes();
        if (null != bkmSrcList) {
            bkmNotesList.addAll((Collection)bkmSrcList);
        }
    }

    @Override
    public List getBookmarks() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<BookmarkEntryInterface> bookmarkList = new ArrayList<BookmarkEntryInterface>();
        try {
            Object omrObj = this.getRepositoryEntity();
            if (null == omrObj) {
                return Collections.EMPTY_LIST;
            }
            if (omrObj instanceof Transformation) {
                Transformation trans = (Transformation)omrObj;
                AssociationList list = trans.getNotes();
                for (TextStore textstore : list) {
                    BookmarkEntryInterface bkmei = this.textStore2Bookmark(textstore);
                    if (null == bkmei) {
                        this.logMessage(Level.WARN, "getBookmarks: The TextStore " + textstore.getId() + " is not associated with a Bookmark.  It is being skipped");
                        continue;
                    }
                    bookmarkList.add(bkmei);
                }
            }
        }
        catch (Exception e) {
            this.logMessage(Level.ERROR, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.GetBookmarkError.fmt.txt"), (Object)this.toString()), OMRDataExplorationEntry.class.getName(), e);
        }
        return bookmarkList;
    }

    @Override
    public List getBookmarkIDList() throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<String> result = new ArrayList<String>();
        Object omrObj = this.getRepositoryEntity();
        if (null == omrObj) {
            return result;
        }
        if (omrObj instanceof Transformation) {
            Transformation trans = (Transformation)omrObj;
            AssociationList list = trans.getNotes();
            for (TextStore textstore : list) {
                AbstractTransformation abstran = textstore.getAssociatedTransformation();
                if (null == abstran) {
                    this.logMessage(Level.WARN, "getBookmarkIDList: The TextStore " + textstore.getId() + " is not associated with a Bookmark.  It is being skipped");
                    continue;
                }
                result.add(abstran.getId());
            }
        }
        return result;
    }

    private TextStore getTextStoreById(String txtId) throws RemoteException, MdException {
        return this.getTextStoreById(txtId, false);
    }

    private TextStore getTextStoreById(String txtId, boolean checkAssocBkm) throws RemoteException, MdException {
        Object omrObj = this.getRepositoryEntity();
        if (null == omrObj) {
            return null;
        }
        if (null == txtId) {
            return null;
        }
        if (omrObj instanceof Transformation) {
            Transformation trans = (Transformation)omrObj;
            AssociationList list = trans.getNotes();
            for (TextStore textstore : list) {
                if (textstore.getId().equals(txtId)) {
                    return textstore;
                }
                AbstractTransformation abstran = textstore.getAssociatedTransformation();
                if (null == abstran || !checkAssocBkm || !txtId.equals(abstran.getId())) continue;
                return textstore;
            }
        }
        return null;
    }

    private BookmarkEntryInterface textStore2Bookmark(TextStore text) throws RemoteException, ServiceException, MdException {
        if (null == text) {
            return null;
        }
        AbstractTransformation abstran = text.getAssociatedTransformation();
        if (null == abstran) {
            return null;
        }
        return (BookmarkEntryInterface)OMRUtils.getMetaDataObjectFromId(abstran.getId(), this.getRepository());
    }

    private TextStore getDefaultTextStore() throws MdException, RemoteException {
        AssociationList list = ((Transformation)this.getRepositoryEntity()).getNotes();
        TextStore first = null;
        if (list.size() > 0) {
            first = (TextStore)list.get(0);
        }
        if ("default".equals(first.getDesc())) {
            return first;
        }
        for (TextStore item : list) {
            if ("default".equals(item.getDesc())) {
                return item;
            }
            item.setDesc("");
        }
        first.setDesc("default");
        return first;
    }

    private void setDefaultTextStore(TextStore newdflt) throws MdException, RemoteException {
        if (null == newdflt) {
            return;
        }
        TextStore olddflt = this.getDefaultTextStore();
        if (newdflt.equals((Object)olddflt)) {
            return;
        }
        olddflt.setDesc("");
        newdflt.setDesc("default");
    }

    @Override
    public void setDefaultBookmark(BookmarkEntryInterface bookmark) throws RemoteException, MdException, ServiceException {
        if (null == bookmark) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Object mdObj = this.getRepositoryEntity();
        if (null == mdObj) {
            return;
        }
        if (!this.inUpgrade) {
            OMRUtils.checkPermissions(this, "WriteMetadata", this.getParent());
        }
        try {
            TextStore txt = bookmark.getTextStore();
            if (null == txt) {
                this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.NoTextStore.fmt.txt"), (Object)bookmark.toString(), (Object)this.toString()));
                return;
            }
            this.setDefaultTextStore(txt);
        }
        catch (Exception e) {
            this.logMessage(Level.ERROR, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.BookmarkDefaultError2.fmt.txt"), (Object)bookmark.toString(), (Object)this.toString()), OMRDataExplorationEntry.class.getName(), e);
        }
    }

    @Override
    public String getInformationMapId() throws RemoteException, MdException, ServiceException {
        PathUrl path = null;
        path = this.getInformationMapURL();
        if (null == path) {
            return null;
        }
        MetadataInterface mdata = this.getRepository().getObjectByPath(path);
        if (null == mdata) {
            return null;
        }
        this.imapName = mdata.getName();
        return mdata.getReposId();
    }

    public PathUrl getInformationMapURL() throws RemoteException, MdException, ServiceException {
        block26: {
            this.checkPulse(true);
            if (!this._isReadCompatible) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            try {
                if (this.shouldConvert()) {
                    this.upgradeFromPreviousVersion();
                }
            }
            catch (MdException mde) {
                throw new ServiceException(mde);
            }
            if (!this.inUpgrade) {
                OMRUtils.checkPermissions(this, "ReadMetadata", this.getParent());
            }
            Object ee = null;
            try {
                Transformation trans;
                AssociationList list;
                Property prop = OMRUtils.getPropertyByName((Transformation)this.getRepositoryEntity(), "informationMapURL");
                if (null == prop) break block26;
                String path = prop.getDefaultValue();
                if (null == path || path.trim().length() == 0) {
                    PathUrl pathUrl = null;
                    return pathUrl;
                }
                this.imapPath = PathUrl.newPathUrlFromAbsolutePath(this.getRepository().getServer(), prop.getDefaultValue());
                this.imapName = this.imapPath.getName();
                MetadataInterface mdi = this.getRepository().getObjectByPath(this.imapPath);
                if (null == mdi && null != (list = (trans = (Transformation)this.getRepositoryEntity()).getNotes())) {
                    for (TextStore textStore : list) {
                        try {
                            Element elem;
                            String reportXML = textStore.getStoredText();
                            Document doc = OMRUtils.XMLString2Doc(reportXML);
                            NodeList nl920 = doc.getElementsByTagName("InformationMap");
                            NodeList nl913 = doc.getElementsByTagName("BusinessModelReferenceInformation");
                            if (null != nl920 && nl920.getLength() > 0) {
                                elem = (Element)nl920.item(0);
                                path = elem.getAttribute("absolutePathLocation");
                            } else if (null != nl913 && nl913.getLength() > 0) {
                                elem = (Element)nl913.item(0);
                                path = elem.getAttribute("location");
                            }
                            if (null == path || path.trim().length() <= 0) continue;
                            this.imapPath = path.startsWith("SBIP://") ? new PathUrl(path) : PathUrl.newPathUrlFromAbsolutePath(this.getRepository().getServer(), path);
                            this.imapName = this.imapPath.getName();
                            mdi = this.getRepository().getObjectByPath(this.imapPath);
                            if (null == mdi) {
                                PathUrl pathUrl = null;
                                return pathUrl;
                            }
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                }
                if (null == mdi) {
                    this.imapPath = null;
                } else {
                    this.imapPath = mdi.getPathUrl();
                    this.imapName = this.imapPath.getName();
                }
            }
            catch (RemoteException e) {
                ee = e;
                throw e;
            }
            catch (MdException e) {
                ee = e;
                throw e;
            }
            catch (ServiceException e) {
                ee = e;
                throw e;
            }
            finally {
                if (null != ee) {
                    this.logMessage(Level.ERROR, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.InfomapIDError2.fmt.txt"), (Object)this.toString()), OMRDataExplorationEntry.class.getName(), (Throwable)ee);
                }
            }
        }
        return this.imapPath;
    }

    @Override
    public String getLocation() throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Transformation trans = (Transformation)this.getRepositoryEntity();
        AssociationList trees = trans.getTrees();
        return OMRUtils.getLocationString(trees, this.getRepository().getServer());
    }

    @Override
    public void removeBookmark(BookmarkEntryInterface bookmark) throws RemoteException, MdException, ServiceException {
        if (null == bookmark) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Transformation trans = (Transformation)bookmark.getRepositoryEntity();
        AssociationList bkmSrcList = trans.getSourceCodes();
        Iterator iter = bkmSrcList.iterator();
        while (iter.hasNext()) {
            this.removeTextStore((TextStore)iter.next());
        }
    }

    @Override
    public void removeBookmark(String id) throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore text = this.getTextStoreById(id, true);
        this.removeTextStore(text);
    }

    private void removeTextStore(TextStore text) throws RemoteException, MdException, ServiceException {
        if (null == text) {
            return;
        }
        if (!this.inUpgrade) {
            OMRUtils.checkPermissions(this, "WriteMetadata", this.getParent());
        }
        Transformation deiTrans = (Transformation)this.getRepositoryEntity();
        AssociationList bkmNotesList = deiTrans.getNotes();
        bkmNotesList.remove((Object)text);
        if ("default".equals(text.getDesc()) && bkmNotesList.size() > 0) {
            TextStore newdflt = (TextStore)bkmNotesList.get(0);
            newdflt.setDesc("default");
        }
    }

    @Override
    public void setInformationMapPath(String imapPath) throws RemoteException, ServiceException, MdException {
        if (null == imapPath || imapPath.trim().length() < 1) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!this.inUpgrade) {
            OMRUtils.checkPermissions(this, "WriteMetadata", this.getParent());
        }
        Object ee = null;
        try {
            String userName = this.getRepository().getUserContext().getName();
            Transformation trans = (Transformation)this.getRepositoryEntity();
            Property prop = OMRUtils.getPropertyByName(trans, "informationMapURL", true, this.getRepository());
            PathUrl path = null;
            path = imapPath.startsWith("SBIP://") ? new PathUrl(imapPath) : PathUrl.newPathUrlFromAbsolutePath(this.getRepository().getServer(), imapPath);
            prop.setDefaultValue(path.getAbsolutePath());
            prop.setDesc(userName);
            AssociationList list = trans.getNotes();
            if (null != list) {
                for (TextStore textStore : list) {
                    try {
                        Element elem;
                        String reportXML = textStore.getStoredText();
                        Document doc = OMRUtils.XMLString2Doc(reportXML);
                        NodeList nl920 = doc.getElementsByTagName("InformationMap");
                        NodeList nl913 = doc.getElementsByTagName("BusinessModelReferenceInformation");
                        boolean modified = false;
                        if (null != nl920 && nl920.getLength() > 0) {
                            elem = (Element)nl920.item(0);
                            elem.setAttribute("absolutePathLocation", path.getAbsolutePath());
                            modified = true;
                        } else if (null != nl913 && nl913.getLength() > 0) {
                            elem = (Element)nl913.item(0);
                            elem.setAttribute("location", path.toString());
                            modified = true;
                        }
                        if (!modified) continue;
                        textStore.setStoredText(OMRUtils.XMLDoc2String(doc));
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (RemoteException e) {
            ee = e;
            throw e;
        }
        catch (MdException e) {
            ee = e;
            throw e;
        }
        catch (ServiceException e) {
            ee = e;
            throw e;
        }
        catch (Exception e) {
            ee = e;
            throw new ServiceException(e);
        }
        finally {
            if (null != ee) {
                this.logMessage(Level.ERROR, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.InfomapPathError.fmt.txt"), (Object)this.toString(), (Object)imapPath), OMRDataExplorationEntry.class.getName(), (Throwable)ee);
            }
        }
    }

    @Override
    public void setInformationMapId(String id) throws RemoteException, MdException, ServiceException {
        if (null == id || id.trim().length() < 1) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Object ee = null;
        try {
            MetadataInterface mdata = OMRUtils.getMetaDataObjectFromId(id, this.getRepository());
            if (null == mdata) {
                this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.InfomapIDError.fmt.txt"), (Object)this.toString(), (Object)id));
                return;
            }
            this.setInformationMapPath(mdata.getPathUrl().toString());
        }
        catch (RemoteException e) {
            ee = e;
            throw e;
        }
        catch (MdException e) {
            ee = e;
            throw e;
        }
        catch (ServiceException e) {
            ee = e;
            throw e;
        }
        finally {
            if (null != ee) {
                this.logMessage(Level.ERROR, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.InfomapIDError.fmt.txt"), (Object)this.toString(), (Object)id), OMRDataExplorationEntry.class.getName(), (Throwable)ee);
            }
        }
    }

    @Override
    public void setLocation(String location) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        PathUrl path = null;
        path = location.startsWith("SBIP://") ? new PathUrl(location) : PathUrl.newPathUrlFromAbsolutePath(this.getRepository().getServer(), location);
        FolderInterface folder = OMRUtils.getFolderForPath(this.getRepository(), path, true);
        if (folder != null) {
            Object entity = folder.getRepositoryEntity();
            CMetadata tree = (CMetadata)entity;
            Transformation trans = (Transformation)this.getRepositoryEntity();
            AssociationList al = trans.getTrees();
            al.removeAllElements();
            al.add((Object)tree);
            trans.setTrees(al);
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        try {
            if (obj instanceof DataExplorationEntryInterface) {
                DataExplorationEntryInterface dei = (DataExplorationEntryInterface)obj;
                result = this.getReposId().equals(dei.getReposId());
            } else {
                result = super.equals(obj);
            }
        }
        catch (Exception e) {
            result = super.equals(obj);
        }
        return result;
    }

    @Override
    public String getInformationMapPath() throws RemoteException, ServiceException, MdException {
        this.getInformationMapName();
        if (null == this.imapPath) {
            return null;
        }
        return this.imapPath.toString();
    }

    @Override
    public String getInformationMapName() throws RemoteException, ServiceException, MdException {
        if (null != this.imapName) {
            return this.imapName;
        }
        PathUrl url = this.getInformationMapURL();
        if (null == url) {
            return null;
        }
        return this.imapName;
    }

    @Override
    public void setInformationMapName(String name) throws RemoteException, ServiceException, MdException {
        if (null != name && name.startsWith("SBIP://")) {
            this.setInformationMapPath(name);
        }
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this.inUpgrade) {
            return;
        }
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.inUpgrade = true;
        try {
            Transformation transform = (Transformation)this.getRepositoryEntity();
            if (this.ensureUpdatedProperties(transform, this.getRepository())) {
                this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("Transformation.convert3.fmt.txt"), (Object)transform.getRepositoryID(), (Object)"DataExploration", (Object)String.valueOf(CURRENT_VERSION.encode())));
                Property prop = OMRUtils.getPropertyByName(transform, "informationMapURL");
                this.setInformationMapPath(prop.getDefaultValue());
            } else {
                this.findMapInNotes(transform);
            }
            transform.setPublicType("DataExploration");
            transform.setUsageVersion(CURRENT_VERSION.encode());
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            this.inUpgrade = false;
        }
    }

    protected AssociationList getTextStoreList() throws MdException, RemoteException {
        Object omrObj = this.getRepositoryEntity();
        if (null == omrObj) {
            return null;
        }
        if (omrObj instanceof Transformation) {
            Transformation trans = (Transformation)omrObj;
            AssociationList list = trans.getNotes();
            return list;
        }
        return null;
    }

    private boolean shouldConvert() throws RemoteException, MdException, ServiceException {
        boolean convert = false;
        if (OMRUtils.isTempObj(this)) {
            return false;
        }
        Object omrObj = this.getRepositoryEntity();
        if (null == omrObj) {
            return false;
        }
        Transformation trans = (Transformation)omrObj;
        convert = convert || CURRENT_VERSION.compareTo((Object)UsageVersion.decode((double)trans.getUsageVersion())) > 0;
        convert = convert || !"DataExploration".equals(trans.getPublicType());
        convert = convert || null == OMRUtils.getPropertyByName(trans, "informationMapURL");
        return convert;
    }

    private boolean ensureUpdatedProperties(Transformation trans, RepositoryInterface repository) throws RemoteException, ServiceException, MdException {
        Property propWithURL = OMRUtils.getPropertyByName(trans, "informationMapURL");
        if (null == propWithURL) {
            propWithURL = OMRUtils.getPropertyByName(trans, "informationMapURL", true, repository);
            Property propWithId = OMRUtils.getPropertyByName(trans, "informationMapId");
            if (null == propWithId) {
                propWithURL.setDefaultValue(this.findMapInBookmarks());
            } else {
                String id = propWithId.getDefaultValue();
                MetadataInterface metadata = null;
                try {
                    metadata = OMRUtils.getMetaDataObjectFromId(id, repository);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                if (null == metadata) {
                    propWithURL.setDefaultValue(this.findMapInBookmarks());
                } else {
                    propWithURL.setDefaultValue(metadata.getPathUrl().getAbsolutePath());
                }
            }
        }
        return null != propWithURL.getDefaultValue();
    }

    private void findMapInNotes(Transformation trans) throws RemoteException, MdException {
        AssociationList list = trans.getNotes();
        for (TextStore textstore : list) {
            Document doc = null;
            try {
                doc = OMRUtils.XMLString2Doc(textstore.getStoredText());
                NodeList nList1 = doc.getElementsByTagName("BusinessModelReferenceInformation");
                String[] attrList = new String[]{"location", "absolutePathLocation"};
                String infoMapLocation = this.getAttributeValue(nList1, attrList);
                if (null == infoMapLocation) {
                    NodeList nList2 = doc.getElementsByTagName("InformationMap");
                    infoMapLocation = this.getAttributeValue(nList2, attrList);
                }
                if (null == infoMapLocation) continue;
                String userName = this.getRepository().getUserContext().getName();
                Property prop = OMRUtils.getPropertyByName(trans, "informationMapURL", true, this.getRepository());
                PathUrl path = null;
                path = infoMapLocation.startsWith("SBIP://") ? new PathUrl(infoMapLocation) : PathUrl.newPathUrlFromAbsolutePath(this.getRepository().getServer(), infoMapLocation);
                prop.setDefaultValue(path.getAbsolutePath());
                prop.setDesc(userName);
                trans.setPublicType("DataExploration");
                trans.setUsageVersion(CURRENT_VERSION.encode());
                this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("Transformation.convert3.fmt.txt"), (Object)trans.getRepositoryID(), (Object)"DataExploration", (Object)String.valueOf(CURRENT_VERSION.encode())));
                MetadataInterface mdata = this.getInfoMapMetadata(path);
                if (null == mdata) {
                    this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.InfomapPathError.fmt.txt"), (Object)trans.getRepositoryID(), (Object)path));
                    break;
                }
                String imapPath = mdata.getPathUrl().getAbsolutePath();
                prop.setDefaultValue(imapPath);
                this.setInformationMapPath(imapPath);
                this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("Transformation.convert.property.fmt.txt"), (Object)trans.getRepositoryID(), (Object)"informationMapId", (Object)mdata.getReposId(), (Object)"informationMapURL", (Object)imapPath));
                break;
            }
            catch (Exception e) {
                this.logMessage(Level.WARN, Message.format((String)com.sas.services.information.metadata.dataexplorer.RB.getStringResource("OMRDataExplorationEntry.XMLParseingError.fmt.txt"), (Object)textstore.getId()), this.getClass().getName(), e);
            }
        }
    }

    private String findMapInBookmarks() throws RemoteException, ServiceException, MdException {
        String rval = null;
        List bookmarks = this.getBookmarks();
        if (null == bookmarks || bookmarks.isEmpty()) {
            rval = null;
        } else {
            block0: for (BookmarkEntryInterface bk : bookmarks) {
                if (null == bk.getDataExplorationURL()) {
                    bk.setDataExplorationURL(this.getPathUrl());
                }
                String dataModelState = bk.getDataModelState();
                StringBuffer buf = new StringBuffer(dataModelState);
                int openingQuote = buf.indexOf(SBIP_URL_PREFIX);
                while (openingQuote > -1) {
                    int startOfUrl = openingQuote + 1;
                    int closingQuote = buf.indexOf(SBIP_URL_SUFFIX, startOfUrl);
                    if (closingQuote > openingQuote) {
                        rval = buf.substring(startOfUrl, closingQuote);
                        PathUrl path = new PathUrl(rval);
                        MetadataInterface mdata = this.getInfoMapMetadata(path);
                        if (null == mdata) continue block0;
                        rval = mdata.getPathUrl().getAbsolutePath();
                        continue block0;
                    }
                    openingQuote = buf.indexOf(SBIP_URL_PREFIX, startOfUrl);
                }
            }
        }
        return rval;
    }

    @Deprecated
    private MetadataInterface getInfoMapMetadata(PathUrl path) throws ServiceException, RemoteException {
        LookupResultsInterface results;
        MetadataInterface mdata = this.getRepository().getObjectByPath(path);
        if (null == mdata && LookupServiceFactory.getService().hasStarted() && (results = LookupServiceFactory.getService().lookup(path)).success()) {
            path = new PathUrl(results.getNewValue());
            mdata = this.getRepository().getObjectByPath(path);
        }
        return mdata;
    }
}

