/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.businessruleflow;

import java.util.ArrayList;
import java.util.List;

public class TermUtil {
    public static List<String> getsupportedDataTypes() {
        ArrayList<String> dataTypeList = new ArrayList<String>();
        for (DataType dataType : DataType.values()) {
            dataTypeList.add(dataType.getDataType());
        }
        return dataTypeList;
    }

    public static boolean isStringDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_STRING.getDataType().equals(dataType);
    }

    public static boolean isDatagridDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_DATAGRID.getDataType().equals(dataType);
    }

    public static boolean isBooleanDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_BOOLEAN.getDataType().equals(dataType);
    }

    public static boolean isDateDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_DATE.getDataType().equals(dataType);
    }

    public static boolean isDatetimeDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_DATETIME.getDataType().equals(dataType);
    }

    public static boolean isIntegerDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_INTEGER.getDataType().equals(dataType);
    }

    public static boolean isRealDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_REAL.getDataType().equals(dataType);
    }

    public static boolean isUnknownDataType(String dataType) {
        return dataType != null && DataType.DATATYPE_UNKNOWN.getDataType().equals(dataType);
    }

    public static enum DataType {
        DATATYPE_UNKNOWN("Unknown"),
        DATATYPE_STRING("String"),
        DATATYPE_DATAGRID("Datagrid"),
        DATATYPE_BOOLEAN("Boolean"),
        DATATYPE_INTEGER("Integer"),
        DATATYPE_REAL("Decimal"),
        DATATYPE_DATE("Date"),
        DATATYPE_DATETIME("Datetime");

        private final String dataType;

        private DataType(String dataType) {
            this.dataType = dataType;
        }

        public String getDataType() {
            return this.dataType;
        }
    }
}

