/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.ServerVirtualFolder;
import com.sas.services.information.metadata.VirtualFolder;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFactory;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class VirtualFolderManager {
    private static final String ID_PREFIX = "#VF";
    private static final String SYSTEM_FOLDER_NAME = "System";
    private static final String VIRTUAL_FOLDER_SECURITY = "Security";
    private static final String VIRTUAL_FOLDER_SERVERS = "Servers";
    private static final String VIRTUAL_FOLDER_ACTS = "Access Control Templates";
    private static final String VIRTUAL_FOLDER_AUTHDOMAINS = "Authentication Domains";
    private static final String VIRTUAL_FOLDER_ROLES = "Roles";
    private static final String VIRTUAL_FOLDER_USERGROUPS = "User Groups";
    private static final String VIRTUAL_FOLDER_USERS = "Users";
    private static final String DEFAULT_LOCATION = "/System/";
    private static final String DEFAULT_SECURITY_LOCATION = "/System/Security/";
    private static Map<String, VirtualFolderDefinition> _folderCache = new HashMap<String, VirtualFolderDefinition>(15);
    private static Map<ServerInterface, VirtualFolderManager> _instanceCache;
    private Map<String, List<VirtualFolderInterface>> _systemVirtualFolders = new HashMap<String, List<VirtualFolderInterface>>(5);
    private Map<OMIRepositoryInterface, Map<String, VirtualFolderInterface>> _virtualFolderCache = new HashMap<OMIRepositoryInterface, Map<String, VirtualFolderInterface>>(5);
    private Map<String, VirtualFolderInterface> _idCache = new HashMap<String, VirtualFolderInterface>();
    private int _idCounter = 0;
    private ServerInterface _server;
    private boolean _isDestroyed = false;

    private VirtualFolderManager(ServerInterface server) throws ServiceException, RemoteException {
        this._server = server;
    }

    public static boolean instanceCreated(ServerInterface server) throws ServiceException, RemoteException {
        if (server == null) {
            throw new IllegalArgumentException(RB.getStringResource("VirtualFolderManager.InvalidServer.txt"));
        }
        return _instanceCache.containsKey(server);
    }

    public static VirtualFolderManager getInstance(ServerInterface server) throws ServiceException, RemoteException {
        if (VirtualFolderManager.instanceCreated(server)) {
            return _instanceCache.get(server);
        }
        VirtualFolderManager instance = new VirtualFolderManager(server);
        _instanceCache.put(server, instance);
        return instance;
    }

    public static boolean isVirtualFolderPath(PathUrl url, ServerInterface server) throws ServiceException, RemoteException {
        String topLevelFolder = url.getRootTree();
        if (SYSTEM_FOLDER_NAME.equalsIgnoreCase(topLevelFolder)) {
            return VirtualFolderManager.isFoundationVirtualFolderPath(url);
        }
        return VirtualFolderManager.isCustomVirtualFolderPath(url);
    }

    private static boolean isFoundationVirtualFolderPath(PathUrl url) {
        String path = url.getPath();
        String childFolder = null;
        childFolder = path == null || path.length() == 0 ? url.getName() : (path.indexOf("/") > 0 ? path.substring(0, path.indexOf("/")) : path);
        return VIRTUAL_FOLDER_SECURITY.equalsIgnoreCase(childFolder) || VIRTUAL_FOLDER_SERVERS.equalsIgnoreCase(childFolder);
    }

    private static boolean isCustomVirtualFolderPath(PathUrl url) {
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        String childFolder = st.nextToken();
        if (SYSTEM_FOLDER_NAME.equalsIgnoreCase(childFolder)) {
            String grandChildFolder = null;
            grandChildFolder = st.hasMoreTokens() ? st.nextToken() : url.getName();
            return VIRTUAL_FOLDER_SECURITY.equalsIgnoreCase(grandChildFolder) || VIRTUAL_FOLDER_SERVERS.equalsIgnoreCase(grandChildFolder);
        }
        return false;
    }

    public static boolean isContainedByVirtualFolder(String publicType) throws ServiceException, RemoteException {
        return VirtualFolderManager.isContainedByVirtualFolder(publicType, null);
    }

    public static boolean isContainedByVirtualFolder(String publicType, OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        VirtualFolderDefinition def = VirtualFolderManager.getVirtualFolderDefinition(publicType);
        return def == null ? false : def.isSupported(publicType, repos);
    }

    private static VirtualFolderDefinition getVirtualFolderDefinition(String publicType) {
        VirtualFolderDefinition def = _folderCache.get(publicType);
        if (def == null && publicType != null && publicType.indexOf(".") > -1) {
            String parentType = publicType.substring(0, publicType.indexOf("."));
            def = _folderCache.get(parentType);
        }
        return def;
    }

    public static String getDefaultPath(String publicType) throws ServiceException, RemoteException {
        return VirtualFolderManager.getDefaultPath(publicType, null);
    }

    public static String getDefaultPath(String publicType, OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        VirtualFolderDefinition def = VirtualFolderManager.getVirtualFolderDefinition(publicType);
        return def == null ? "" : def.getDefaultLocation(repos);
    }

    public static boolean isVirtualFolderId(String id) throws ServiceException, RemoteException {
        if (id == null || id.length() != 17) {
            return false;
        }
        String shortID = id.substring(9);
        return shortID.indexOf(ID_PREFIX) == 0;
    }

    public ServerInterface getServer() {
        return this._server;
    }

    public void destroy() throws ServiceException, RemoteException {
        if (this._isDestroyed) {
            return;
        }
        this._isDestroyed = true;
        if (_instanceCache.containsKey(this._server)) {
            _instanceCache.remove(this._server);
            if (this._systemVirtualFolders != null) {
                this._systemVirtualFolders.clear();
                this._systemVirtualFolders = null;
            }
            if (this._virtualFolderCache != null) {
                this._virtualFolderCache.clear();
                this._virtualFolderCache = null;
            }
            if (this._idCache != null) {
                this._idCache.clear();
                this._idCache = null;
            }
            this._server = null;
        }
    }

    public void reset() throws ServiceException, RemoteException {
        if (this._idCache == null || this._idCache.isEmpty()) {
            return;
        }
        for (VirtualFolderInterface folder : this._idCache.values()) {
            if (!(folder instanceof VirtualFolder)) continue;
            folder.refresh();
            List<SearchFilter> filters = ((VirtualFolder)folder).getOriginalFilters();
            Search originalSearch = folder.getSearchManager();
            if (originalSearch == null) continue;
            Search search = SearchFactory.createSearch(this._server);
            for (SearchFilter sf : filters) {
                search.addFilter(sf);
            }
            OMIRepositoryInterface repos = originalSearch.getRepository();
            search.setRepository(repos);
            ((VirtualFolder)folder).setSearchManager(search);
        }
    }

    public boolean containsVirtualFolder(String id) throws ServiceException, RemoteException {
        if (this._idCache.isEmpty()) {
            this.initializeVirtualFolders(id);
        }
        return this._idCache.containsKey(id);
    }

    public VirtualFolderInterface getVirtualFolder(String id) throws ServiceException, RemoteException {
        VirtualFolderInterface folder;
        if (this._idCache.isEmpty()) {
            this.initializeVirtualFolders(id);
        }
        if ((folder = this._idCache.get(id)) != null) {
            return folder;
        }
        return null;
    }

    public VirtualFolderInterface getOwningVirtualFolder(Metadata metadata) throws ServiceException, RemoteException {
        if (metadata instanceof VirtualFolderInterface) {
            return (VirtualFolderInterface)metadata.getContainer();
        }
        if (VirtualFolderManager.isContainedByVirtualFolder(metadata.getType(), (OMIRepositoryInterface)metadata.getRepository())) {
            FolderInterface systemFolder = FolderUtil.makeSystemFolder(metadata);
            if (systemFolder != null && !this._systemVirtualFolders.containsKey(systemFolder.getIdentifier())) {
                this.createSystemVirtualFolders(systemFolder);
            }
            Map<String, VirtualFolderInterface> typeMap = this._virtualFolderCache.get((OMIRepositoryInterface)metadata.getRepository());
            String type = metadata.getType();
            if (typeMap != null) {
                if (typeMap.containsKey(type)) {
                    return typeMap.get(type);
                }
                int index = type.indexOf(".");
                if (index > -1) {
                    type = type.substring(0, index);
                    return typeMap.get(type);
                }
            }
        }
        return null;
    }

    private void initializeVirtualFolders(String objectID) throws ServiceException, RemoteException {
        if (objectID == null) {
            return;
        }
        String reposID = "A0000001." + objectID.substring(0, 8);
        String name = this._server.getRepositoryName(reposID);
        if (name == null) {
            throw new IllegalStateException("Invalid repository id: " + reposID);
        }
        RepositoryInterface repos = this._server.getRepository(name);
        if (repos instanceof OMIRepositoryInterface) {
            this.initializeVirtualFolders((OMIRepositoryInterface)repos);
        }
    }

    private void initializeVirtualFolders(OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        FolderInterface mi = null;
        String reposType = repos.getRepositoryType();
        if (reposType.equalsIgnoreCase("FOUNDATION")) {
            mi = this._server.getRootFolder();
        } else if (reposType.equalsIgnoreCase("CUSTOM")) {
            List folders = repos.getRootFolders();
            if (folders.size() <= 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"VirtualFolderManager.NoRootFolder.fmt.txt", (Object)repos.getDefaultRepositoryName()));
            }
            mi = (FolderInterface)folders.get(0);
        } else {
            throw new ServiceException(RB.getStringResource("VirtualFolderManager.ProjectRepos.txt"));
        }
        FolderInterface systemFolder = FolderUtil.getSystemFolder(mi);
        if (systemFolder != null && !this._systemVirtualFolders.containsKey(systemFolder.getIdentifier())) {
            this.createSystemVirtualFolders(systemFolder);
        }
    }

    public List<VirtualFolderInterface> getSystemVirtualFolders(FolderInterface systemFolder) throws ServiceException, RemoteException {
        ArrayList<VirtualFolderInterface> subFolders = new ArrayList<VirtualFolderInterface>(2);
        if (!FolderUtil.isSystemFolder(systemFolder)) {
            return subFolders;
        }
        List<VirtualFolderInterface> folders = this.createSystemVirtualFolders(systemFolder);
        if (folders == null) {
            return Collections.emptyList();
        }
        return new ArrayList<VirtualFolderInterface>(folders);
    }

    public boolean hasDuplicateSubfolder(String name, FolderInterface systemFolder) throws ServiceException, RemoteException {
        if (!FolderUtil.isSystemFolder(systemFolder)) {
            return false;
        }
        List<VirtualFolderInterface> virtualFolders = this.getSystemVirtualFolders(systemFolder);
        for (VirtualFolderInterface folder : virtualFolders) {
            if (!folder.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private List<VirtualFolderInterface> createSystemVirtualFolders(FolderInterface systemFolder) throws ServiceException, RemoteException {
        List<VirtualFolderInterface> folders = this._systemVirtualFolders.get(systemFolder.getIdentifier());
        if (folders == null || folders.isEmpty()) {
            folders = new ArrayList<VirtualFolderInterface>(2);
            this._systemVirtualFolders.put(systemFolder.getIdentifier(), folders);
            this._idCounter = 0;
            boolean isCustom = this.isCustomRepository(systemFolder);
            VirtualFolderInterface securityVirtualFolder = this.createVirtualFolder(VIRTUAL_FOLDER_SECURITY, systemFolder);
            this.createTypeBasedVirtualFolder(VIRTUAL_FOLDER_ACTS, (FolderInterface)securityVirtualFolder, "ACT");
            if (!isCustom) {
                this.createTypeBasedVirtualFolder(VIRTUAL_FOLDER_AUTHDOMAINS, (FolderInterface)securityVirtualFolder, "AuthenticationDomain");
            }
            this.createTypeBasedVirtualFolder(VIRTUAL_FOLDER_ROLES, (FolderInterface)securityVirtualFolder, "Role");
            this.createTypeBasedVirtualFolder(VIRTUAL_FOLDER_USERGROUPS, (FolderInterface)securityVirtualFolder, "UserGroup");
            if (!isCustom) {
                this.createTypeBasedVirtualFolder(VIRTUAL_FOLDER_USERS, (FolderInterface)securityVirtualFolder, "User");
            }
            VirtualFolderInterface serverVirtualFolder = this.createServerVirtualFolder(VIRTUAL_FOLDER_SERVERS, systemFolder);
            folders.add(securityVirtualFolder);
            folders.add(serverVirtualFolder);
        }
        return folders;
    }

    private VirtualFolderInterface createServerVirtualFolder(String name, FolderInterface parentFolder) throws ServiceException, RemoteException {
        HashSet<String> serverTypes = new HashSet<String>();
        serverTypes.add("ApplicationServer");
        serverTypes.add("Spawner.IOM");
        serverTypes.add("Spawner.Connect");
        serverTypes.add("ProxyList");
        serverTypes.add("LogicalServer.Federation");
        Collection<TypeDescriptorInterface> types = this._server.getTypeDescriptors();
        if (types != null && !types.isEmpty()) {
            String serverPrefix = "Server.";
            for (TypeDescriptorInterface type : types) {
                String typeName = type.getTypeName();
                if (typeName == null || !typeName.startsWith("Server.")) continue;
                serverTypes.add(typeName);
            }
        }
        return this.createTypeBasedVirtualFolder(name, parentFolder, ServerVirtualFolder.class, false, serverTypes.toArray(new String[serverTypes.size()]));
    }

    private VirtualFolderInterface createTypeBasedVirtualFolder(String name, FolderInterface parentFolder, String ... supportedTypes) throws ServiceException, RemoteException {
        return this.createTypeBasedVirtualFolder(name, parentFolder, null, false, supportedTypes);
    }

    private VirtualFolderInterface createTypeBasedVirtualFolder(String name, FolderInterface parentFolder, Class<? extends VirtualFolder> folderClass, boolean includeSubTypes, String ... supportedTypes) throws ServiceException, RemoteException {
        List<SearchFilter> filters = this.createTypeFilterList(supportedTypes, includeSubTypes);
        VirtualFolderInterface virtualFolder = this.createVirtualFolder(name, parentFolder, folderClass, filters);
        OMIRepositoryInterface repos = (OMIRepositoryInterface)virtualFolder.getRepository();
        Map<String, VirtualFolderInterface> typeMap = this._virtualFolderCache.get(repos);
        if (typeMap == null) {
            typeMap = new HashMap<String, VirtualFolderInterface>(8);
            this._virtualFolderCache.put(repos, typeMap);
        }
        for (int index = 0; index < supportedTypes.length; ++index) {
            typeMap.put(supportedTypes[index], virtualFolder);
        }
        return virtualFolder;
    }

    private List<SearchFilter> createTypeFilterList(String[] supportedTypes, boolean includeSubTypes) {
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>(1);
        filters.add(new PublicTypeFilter(Arrays.asList(supportedTypes), includeSubTypes));
        return filters;
    }

    private VirtualFolderInterface createVirtualFolder(String name, FolderInterface parentFolder) throws ServiceException, RemoteException {
        return this.createVirtualFolder(name, parentFolder, null, null);
    }

    private VirtualFolderInterface createVirtualFolder(String name, FolderInterface parentFolder, Class<? extends VirtualFolder> folderClass, List<SearchFilter> filters) throws ServiceException, RemoteException {
        OMIRepositoryInterface repos = (OMIRepositoryInterface)parentFolder.getRepository();
        String id = this.generateId(repos);
        VirtualFolder folder = null;
        if (folderClass == null) {
            folder = new VirtualFolder(id, name, parentFolder);
        } else {
            try {
                Constructor<? extends VirtualFolder> cons = folderClass.getConstructor(String.class, String.class, FolderInterface.class);
                folder = cons.newInstance(id, name, parentFolder);
            }
            catch (Exception e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"VirtualFolderManager.FolderLoadError.fmt.txt", (Object)name);
                throw new ServiceException(e, msg);
            }
        }
        this._idCache.put(id, folder);
        if (parentFolder instanceof VirtualFolderInterface) {
            ((VirtualFolderInterface)parentFolder).addSubfolder(folder);
        }
        folder.setRepository(repos);
        if (filters != null && filters.size() > 0 && repos != null) {
            ServerInterface server = repos.getServer();
            Search search = SearchFactory.createSearch(server);
            search.setValidateCriteria(false);
            for (SearchFilter sf : filters) {
                search.addFilter(sf);
            }
            search.setRepository(repos);
            folder.setSearchManager(search);
        }
        return folder;
    }

    private synchronized String generateId(OMIRepositoryInterface repos) throws RemoteException {
        String reposID = repos.getDefaultRepositoryId().substring(9);
        int zero = 48;
        StringBuilder id = new StringBuilder(String.valueOf(this._idCounter));
        int iLength = id.length();
        for (int i = 5; i > iLength; --i) {
            id.insert(0, '0');
        }
        id.insert(0, ".#VF");
        id.insert(0, reposID);
        ++this._idCounter;
        if (this._idCounter > 99999) {
            this._idCounter = 0;
        }
        return id.toString();
    }

    private boolean isCustomRepository(FolderInterface systemFolder) throws RemoteException {
        RepositoryInterface repos = systemFolder.getRepository();
        if (repos instanceof OMIRepositoryInterface) {
            return "CUSTOM".equalsIgnoreCase(((OMIRepositoryInterface)repos).getRepositoryType());
        }
        return false;
    }

    static {
        VirtualFolderDefinition actDef = new VirtualFolderDefinition("/System/Security/Access Control Templates", true);
        _folderCache.put("ACT", actDef);
        VirtualFolderDefinition domainDef = new VirtualFolderDefinition("/System/Security/Authentication Domains", false);
        _folderCache.put("AuthenticationDomain", domainDef);
        VirtualFolderDefinition roleDef = new VirtualFolderDefinition("/System/Security/Roles", true);
        _folderCache.put("Role", roleDef);
        ServerVirtualFolderDefinition serverDef = new ServerVirtualFolderDefinition("/System/Servers", true);
        _folderCache.put("ApplicationServer", serverDef);
        _folderCache.put("Spawner.IOM", serverDef);
        _folderCache.put("Spawner.Connect", serverDef);
        _folderCache.put("ProxyList", serverDef);
        _folderCache.put("Server", serverDef);
        _folderCache.put("LogicalServer.Federation", serverDef);
        VirtualFolderDefinition userDef = new VirtualFolderDefinition("/System/Security/Users", false);
        _folderCache.put("User", userDef);
        VirtualFolderDefinition groupDef = new VirtualFolderDefinition("/System/Security/User Groups", true);
        _folderCache.put("UserGroup", groupDef);
        _instanceCache = new ConcurrentHashMap<ServerInterface, VirtualFolderManager>(5);
    }

    @SASScope
    static class VirtualFolderDefinition {
        String _defaultPath = "";
        boolean _supportedInCustomRepos = true;

        public VirtualFolderDefinition(String defaultPath, boolean supportedInCustomRepos) {
            this._defaultPath = defaultPath;
            this._supportedInCustomRepos = supportedInCustomRepos;
        }

        public String getDefaultLocation(OMIRepositoryInterface repos) throws ServiceException, RemoteException {
            RootFolderInterface rootFolder;
            List topLevelFolders;
            if (repos != null && "CUSTOM".equals(repos.getRepositoryType()) && (topLevelFolders = (rootFolder = repos.getServer().getRootFolder()).getSASFolders(repos)) != null && !topLevelFolders.isEmpty()) {
                FolderInterface topLevelFolder = (FolderInterface)topLevelFolders.get(0);
                String startingPath = topLevelFolder.getPath();
                if (startingPath.endsWith("/")) {
                    startingPath = startingPath + "/";
                }
                return startingPath + this._defaultPath;
            }
            return this._defaultPath;
        }

        public boolean isSupported(String publicType, OMIRepositoryInterface repos) throws ServiceException, RemoteException {
            if (repos != null && "CUSTOM".equals(repos.getRepositoryType())) {
                return this._supportedInCustomRepos;
            }
            return true;
        }
    }

    static class ServerVirtualFolderDefinition
    extends VirtualFolderDefinition {
        public ServerVirtualFolderDefinition(String defaultPath, boolean supportedInCustomRepos) {
            super(defaultPath, supportedInCustomRepos);
        }

        @Override
        public boolean isSupported(String publicType, OMIRepositoryInterface repos) throws ServiceException, RemoteException {
            boolean supported = super.isSupported(publicType, repos);
            if (supported) {
                if (repos == null) {
                    if (publicType.indexOf(".") > -1) {
                        supported = false;
                    }
                } else {
                    ServerInterface server = repos.getServer();
                    TypeDescriptorInterface tdi = server.getTypeDescriptor(publicType);
                    String containerType = tdi.getContainerType();
                    if (!"Folder.Virtual".equalsIgnoreCase(containerType)) {
                        supported = false;
                    }
                }
            }
            return supported;
        }
    }
}

