/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Factory;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MyDocuments;
import com.sas.services.information.metadata.MyInbox;
import com.sas.services.information.metadata.MyResults;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.dav.DAVFolder;
import com.sas.services.information.metadata.dav.DAVItemInterface;
import com.sas.services.information.metadata.dav.DAVPersonalrepository;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PersonalRepository
extends Folder
implements PersonalRepositoryInterface {
    static final long serialVersionUID = 5617949846206515365L;
    private static final int APPL_LIST_INIT = 8;
    public static final int INBOX = 1;
    public static final int DOCUMENTS = 2;
    public static final int RESULTS = 3;
    private static final String INBOX_CLASS = "com.sas.services.information.metadata.MyInbox";
    public static final String INBOX_PATH = "MyInbox";
    private static final String RESULTS_CLASS = "com.sas.services.information.metadata.MyResults";
    public static final String RESULTS_PATH = "MyResults";
    private static final String DOC_CLASS = "com.sas.services.information.metadata.MyDocuments";
    public static final String DOC_PATH = "MyDocuments";
    DAVFolder rootFolder = null;
    DAVFolder applFolder = null;
    Map applList = new HashMap(8);

    public PersonalRepository() throws RemoteException {
        this(PersonalRepository.class);
    }

    public PersonalRepository(DAVPersonalrepository o) throws RemoteException {
        this(o, PersonalRepository.class);
    }

    protected PersonalRepository(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected PersonalRepository(DAVPersonalrepository o, Class theClass) throws RemoteException {
        super(o, theClass);
        this.loadApplicationList();
    }

    @Override
    public FolderInterface getApplicationManager(String applname) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (!this.applList.containsKey(applname)) break;
                Object o = this.applList.get(applname);
                if (o instanceof String) {
                    FolderInterface fMgr = null;
                    String loaderClassName = (String)o;
                    try {
                        Class loaderClass = Factory.getInstance().loadClass(loaderClassName);
                        Field field = loaderClass.getDeclaredField("applicationExtension");
                        String ext = (String)field.get(null);
                        fMgr = this.getSubfolder(ext);
                        if (fMgr == null) {
                            fMgr = this.makeSubfolder(ext);
                        }
                    }
                    catch (Throwable t) {
                        throw new ServiceException(t, RB.getStringResource("PersonalRepository.loaderr.ex.txt"));
                    }
                    this.applList.put(applname, fMgr);
                    return fMgr;
                }
                return (FolderInterface)o;
            }
        }
        return null;
    }

    @Override
    public FolderInterface getApplicationManager(int applId) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                switch (applId) {
                    case 1: {
                        return this.getApplicationManager(MyInbox.applicationExtension);
                    }
                    case 2: {
                        return this.getApplicationManager(MyDocuments.applicationExtension);
                    }
                    case 3: {
                        return this.getApplicationManager(MyResults.applicationExtension);
                    }
                }
                break;
            }
        }
        return null;
    }

    @Override
    public boolean registerApplication(String applname, String FolderManagerClassName) throws RemoteException {
        if (!this.applList.containsKey(applname)) {
            this.applList.put(applname, FolderManagerClassName);
            this.saveApplicationList();
        }
        return true;
    }

    @Override
    public List getSupportedApplications() throws RemoteException {
        return new ArrayList(this.applList.keySet());
    }

    private void saveApplicationList() throws RemoteException {
        if (this.applFolder == null) {
            return;
        }
        try {
            for (Map.Entry me : this.applList.entrySet()) {
                DAVItemInterface applItem = (DAVItemInterface)this.applFolder.getItem((String)me.getKey());
                if (applItem != null) {
                    applItem.delete();
                }
                applItem = this.applFolder.createItem((String)me.getKey(), "applitem");
                applItem.setAttribute("{http://www.sas.com/rnd/itech/WebDAV}FolderManagerClass", me.getValue());
                applItem.update();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void loadApplicationList() throws RemoteException {
        this.registerApplication(INBOX_PATH, INBOX_CLASS);
        this.registerApplication(DOC_PATH, DOC_CLASS);
        this.registerApplication(RESULTS_PATH, RESULTS_CLASS);
    }

    @Override
    public String getType() throws RemoteException {
        return "PersonalRepository";
    }
}

