/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.ITChannel;
import com.sas.metadata.remote.ITSubscriber;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.ITSubscriberImpl;
import com.sas.metadata.remote.impl.ITSubscriberImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MessageQueueInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRPerson;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.SubscriberInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public abstract class OMRSubscriber
extends Metadata
implements SubscriberInterface,
LocalizableProperties {
    private boolean _refreshChannels = true;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRSubscriber() throws RemoteException {
        this(OMRSubscriber.class);
    }

    public OMRSubscriber(ITSubscriber o) throws RemoteException {
        this(o, OMRSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSubscriber(ITSubscriberImpl o) throws RemoteException {
        this(o, OMRSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSubscriber(ITSubscriberImpl_Stub o) throws RemoteException {
        this(o, OMRSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRSubscriber(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRSubscriber(ITSubscriber o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRSubscriber(ITSubscriberImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRSubscriber(ITSubscriberImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    @Override
    public String getType() throws RemoteException {
        return "Subscriber";
    }

    @Override
    public PersonInterface getPerson() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        try {
            Person o = sub.getProfileOwner();
            if (o == null) {
                return null;
            }
            OMRPerson op = new OMRPerson(o);
            op.setRepository(this._repository);
            return op;
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, OMRSubscriber.getMetadataAccessExceptionMsg(), OMRSubscriber.class.getName(), ex);
            return null;
        }
    }

    @Override
    public void setPerson(PersonInterface person) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        sub.setProfileOwner((Person)person.getRepositoryEntity());
    }

    @Override
    public String getDeliveryTransport() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = (ITSubscriber)this._repositoryObject;
        return sub.getDeliveryTransport();
    }

    @Override
    public void setDeliveryTransport(String deliveryTransport) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        sub.setDeliveryTransport(deliveryTransport);
    }

    @Override
    public MessageQueueInterface getMessageQueue() throws ServiceException, RemoteException {
        return this.getMessageQueue(false);
    }

    @Override
    public MessageQueueInterface getMessageQueue(boolean goToServer) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        Transformation queueTransformation = null;
        try {
            Iterator iter = null;
            iter = !goToServer ? sub.getTargetTransformations().iterator() : sub.getTargetTransformations(true).iterator();
            String messageQueueTransformRole = "SASMessageQueue";
            Transformation transformation = null;
            while (iter.hasNext()) {
                transformation = (Transformation)iter.next();
                if (!"SASMessageQueue".equals(transformation.getTransformRole())) continue;
                queueTransformation = transformation;
                break;
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"OMRSubscriber.getQueue.ex.fmt.txt", (Object)this.getName()));
        }
        MessageQueueInterface queue = null;
        if (queueTransformation != null) {
            queue = (MessageQueueInterface)this._repository.factoryProcess(queueTransformation);
        }
        return queue;
    }

    @Override
    public void setMessageQueue(MessageQueueInterface queue) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        String queueName = queue.getQueueURI();
        try {
            AssociationList targetTransformations = sub.getTargetTransformations();
            Iterator iter = targetTransformations.iterator();
            Transformation transformation = null;
            String messageQueueTransformRole = "SASMessageQueue";
            while (iter.hasNext()) {
                transformation = (Transformation)iter.next();
                if (!"SASMessageQueue".equals(transformation.getTransformRole())) continue;
                iter.remove();
            }
            transformation = (Transformation)queue.getRepositoryEntity();
            if (targetTransformations.add(transformation)) {
                this.setQueueName(queueName);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"OMRSubscriber.setQueue.ex.fmt.txt", (Object)queueName, (Object)this.getName()));
        }
    }

    @Override
    public String getQueueName() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber subscriber = this.getSubscriber();
        String queueName = null;
        try {
            int index;
            String queueTransportType;
            MessageQueueInterface queue = this.getMessageQueue();
            boolean is92 = queue != null;
            String queueNameSub = subscriber.getQueueName();
            String string = queueName = is92 ? queue.getQueueURI() : queueNameSub;
            if (is92 && queueName.startsWith("MQSERIES") && (queueTransportType = OMRSubscriber.getWebsphereQueueTransportType(queueNameSub)) != null && !queueName.startsWith(queueTransportType) && (index = queueName.indexOf(58)) > 0) {
                queueName = queueTransportType + queueName.substring(index);
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRSubscriber.getQueue.ex.fmt.txt", (Object)this.getName()), (Throwable)((Object)e));
        }
        return queueName;
    }

    @Override
    public void setQueueName(String queueName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        sub.setQueueName(queueName);
    }

    @Override
    public ContentDestination getContentDestination() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        ServerInterface si = null;
        String relPath = null;
        String basePath = null;
        DirectoryInterface baseDir = null;
        DirectoryInterface dir = null;
        try {
            Directory cd = sub.getContentDestination();
            if (cd != null) {
                Directory parentDir = cd.getParent();
                if (parentDir != null) {
                    dir = (DirectoryInterface)this._repository.factoryProcess(cd);
                    baseDir = (DirectoryInterface)this._repository.factoryProcess(parentDir);
                    relPath = cd.getDirectoryName();
                    basePath = parentDir.getDirectoryName();
                    AssociationList servers = parentDir.getDeployedComponents();
                    if (servers != null && servers.size() > 0) {
                        ServerComponent sc = this.getServerComponent((List)servers);
                        si = (ServerInterface)this._repository.factoryProcess(sc);
                    }
                } else {
                    baseDir = (DirectoryInterface)this._repository.factoryProcess(cd);
                    basePath = cd.getDirectoryName();
                    AssociationList servers = cd.getDeployedComponents();
                    if (servers != null && servers.size() > 0) {
                        ServerComponent sc = this.getServerComponent((List)servers);
                        si = (ServerInterface)this._repository.factoryProcess(sc);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, OMRSubscriber.getMetadataAccessExceptionMsg(), OMRSubscriber.class.getName(), ex);
        }
        return new ContentDestination(dir, relPath, basePath, si, baseDir);
    }

    @Override
    public void setContentDestination(DirectoryInterface basePathDirectory, String relativePath) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        try {
            DirectoryInterface current;
            ContentDestination dest = this.getContentDestination();
            if (dest != null && (current = dest.getDirectory()) != null && !current.isBasePath()) {
                Directory d = (Directory)current.getRepositoryEntity();
                d.delete();
            }
            if (relativePath == null || relativePath.length() == 0) {
                Directory dir = (Directory)basePathDirectory.getRepositoryEntity();
                sub.setContentDestination(dir);
            } else {
                MdObjectStore store = (MdObjectStore)sub.getObjectStore();
                MdFactory factory = store.getFactory();
                Directory relDir = (Directory)factory.createComplexMetadataObject(store, null, this.getName() + "BasePath", "Directory", sub.getRepositoryID());
                relDir.setIsRelative(1);
                relDir.setDirectoryName(relativePath);
                relDir.setParent((Directory)basePathDirectory.getRepositoryEntity());
                sub.setContentDestination(relDir);
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, OMRSubscriber.getMetadataAccessExceptionMsg(), OMRSubscriber.class.getName(), ex);
        }
    }

    @Override
    public List getSubscribedChannels() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        ArrayList<MetadataInterface> results = null;
        HashSet<String> ids = null;
        try {
            AssociationList channels = null;
            if (this._refreshChannels) {
                channels = sub.getSubscribedChannels(true);
                this._refreshChannels = false;
            } else {
                channels = sub.getSubscribedChannels();
            }
            results = new ArrayList<MetadataInterface>(channels.size());
            ids = new HashSet<String>(channels.size());
            for (Object o : channels) {
                MetadataInterface mi = this._repository.factoryProcess(o);
                results.add(mi);
                ids.add(mi.getReposId());
            }
            AssociationList groups = sub.getGroups();
            for (Object o : groups) {
                if (!(o instanceof Group)) continue;
                Group g = (Group)o;
                channels = g.getGroupSubscriptions();
                for (ITChannel ch : channels) {
                    if (!ids.add(ch.getId())) continue;
                    MetadataInterface mi = this._repository.factoryProcess(ch);
                    results.add(mi);
                }
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, OMRSubscriber.getMetadataAccessExceptionMsg(), OMRSubscriber.class.getName(), ex);
        }
        return results;
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        super.refresh();
        this._refreshChannels = true;
    }

    protected abstract ServerComponent getServerComponent(List var1);

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITSubscriber sub = this.getSubscriber();
        try {
            ContentDestination cd = this.getContentDestination();
            ServerInterface server = cd.getServer();
            String relPath = cd.getPath();
            if (server != null && relPath != null) {
                Directory dir = sub.getContentDestination();
                MetadataInterface mi = this._repository.factoryProcess(dir);
                mi.delete();
            }
        }
        catch (MdException mdex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.retrvErr.msg.txt"), "com.sas.services.information.metadata.OMRSubscriber", mdex);
        }
        super.delete();
    }

    @Override
    public ServiceException validate(FolderInterface folder) throws RemoteException {
        ServiceException exception = null;
        try {
            String name;
            String string = name = this.getName() == null ? "" : this.getName().trim();
            if (name != null) {
                exception = this.validate(folder, name);
            }
        }
        catch (IllegalArgumentException e) {
            exception = new ServiceException(e);
        }
        return exception;
    }

    public ServiceException validate(FolderInterface folder, String subscriberName) throws RemoteException {
        if (subscriberName == null) {
            throw new IllegalArgumentException();
        }
        ServiceException exception = null;
        try {
            Filter filter = this.createFilter();
            filter.setName(subscriberName);
            filter.setFilterComponent(new FilterComponent("Id", 11, this.getReposId()));
            ArrayList subscribers = new ArrayList(5);
            this.querySubscriberResults(subscribers, filter, folder);
            if (subscribers.size() > 0) {
                exception = new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRSubscriber.subscriberNameMustBeUnique.ex.fmt.txt", (Object)subscriberName));
            }
        }
        catch (IllegalArgumentException e) {
            exception = new ServiceException(e);
        }
        catch (ServiceException e) {
            exception = e;
        }
        return exception;
    }

    protected abstract Filter createFilter();

    private void querySubscriberResults(List queryResultsList, FilterInterface filter, FolderInterface folder) throws ServiceException, RemoteException {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.metadata.OMRSubscriber");
        try {
            String repositoryURL = this._repository.getUrl();
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMRSubscriber.querying.fmt.txt", (Object)repositoryURL));
            }
            long timeStart = System.currentTimeMillis();
            ArrayList list = null;
            if (folder == null) {
                list = this._repository.search(filter);
            } else {
                FilteredFolderInterface filteredFolder = this._repository.searchTreeFromBase(folder, filter);
                if (filteredFolder != null) {
                    list = filteredFolder.getItems();
                }
            }
            if (list == null) {
                list = new ArrayList(0);
            }
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMRSubscriber.queryTook.fmt.txt", (Object)repositoryURL, (Object)list.size(), (Object)(System.currentTimeMillis() - timeStart)));
            }
            queryResultsList.addAll(list);
        }
        catch (RemoteException e) {
            if (logger != null) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (ServiceException e) {
            if (logger != null) {
                logger.error(e.getMessage(), (Throwable)((Object)e));
            }
            throw e;
        }
    }

    private ITSubscriber getSubscriber() {
        return (ITSubscriber)this._repositoryObject;
    }

    private static final String getWebsphereQueueTransportType(String queueURI) throws ServiceException, RemoteException {
        String protocol;
        String websphereQTransportType = null;
        int index = queueURI.indexOf(58);
        if (index > 0 && ("MQSERIES".equals(protocol = queueURI.substring(0, index)) || "MQSERIES-C".equals(protocol))) {
            websphereQTransportType = protocol;
        }
        return websphereQTransportType;
    }

    private static final String getMetadataAccessExceptionMsg() {
        return RB.getStringResource("Metadata.accessexcept.msg.txt");
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }
}

