/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.impl.DeployedComponentImpl;
import com.sas.metadata.remote.impl.DeployedComponentImpl_Stub;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.DeployedDataPackageInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.OMRSoftwareComponent;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.ServiceTypeInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.UniqueNameValidator;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRServer
extends OMRSoftwareComponent
implements ServerInterface,
Serializable {
    static final long serialVersionUID = -1844720018565837832L;
    private static final int EMPTY_LIST_INIT = 1;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRServer() throws RemoteException {
        super(OMRServer.class);
    }

    public OMRServer(DeployedComponent o) throws RemoteException {
        super(o, OMRServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServer(DeployedComponentImpl o) throws RemoteException {
        super(o, OMRServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServer(DeployedComponentImpl_Stub o) throws RemoteException {
        super(o, OMRServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServer(ServerComponentImpl o) throws RemoteException {
        super(o, OMRServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServer(ServerComponentImpl_Stub o) throws RemoteException {
        super(o, OMRServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRServer.class);
    }

    protected OMRServer(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRServer(DeployedComponent o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRServer(DeployedComponentImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRServer(DeployedComponentImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRServer(ServerComponentImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRServer(ServerComponentImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRServer(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        super(theClass);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        ServerComponent dc = null;
        try {
            dc = (ServerComponent)((OMIRepositoryInterface)repos).createMetadata(name, "ServerComponent");
            dc.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
        }
        catch (ServiceException ex) {
            throw new RuntimeException((Throwable)((Object)ex));
        }
        this._repositoryObject = dc;
        this._repositoryFlag = 2;
        this.setRepository(repos);
        if (parent != null) {
            try {
                parent.addItem(this);
            }
            catch (ServiceException ex) {
                dc.delete();
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        DeployedComponent dc;
        if (this._repositoryObject != null && (dc = (DeployedComponent)this._repositoryObject).getPublicType() != null && dc.getPublicType().trim().length() > 0) {
            return dc.getPublicType();
        }
        return "Server";
    }

    @Override
    public String getHost() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        String result = "";
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Connection con : ass) {
                if (!(con instanceof TCPIPConnection ? !(result = ((TCPIPConnection)con).getHostName()).equals("localhost") : con instanceof SASClientConnection && !(result = ((SASClientConnection)con).getRemoteAddress()).equals("localhost"))) continue;
                return result;
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", ex);
        }
        return result;
    }

    @Override
    public void setHost(String host) throws ServiceException, RemoteException {
        this.checkPulse(true);
        String result = "";
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections(true);
            for (Connection con : ass) {
                if (con instanceof TCPIPConnection) {
                    ((TCPIPConnection)con).setHostName(host);
                    continue;
                }
                if (con instanceof SASClientConnection) {
                    ((SASClientConnection)con).setRemoteAddress(host);
                    continue;
                }
                if (!(con instanceof COMConnection)) continue;
                ((COMConnection)con).setHostName(host);
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", ex);
        }
    }

    @Override
    public int getTcpPort() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Connection con : ass) {
                if (con instanceof TCPIPConnection) {
                    return ((TCPIPConnection)con).getPort();
                }
                if (!(con instanceof SASClientConnection)) continue;
                return ((SASClientConnection)con).getPort();
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", ex);
        }
        return -1;
    }

    @Override
    public void setTcpPort(int port) throws ServiceException, RemoteException {
        this.checkPulse(true);
    }

    @Override
    public List getDomains() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<String> result = null;
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList connList = server.getSourceConnections();
            result = new ArrayList(connList.size());
            for (Connection connection : connList) {
                AuthenticationDomain dom = connection.getDomain();
                if (dom == null) continue;
                result.add(dom.getName());
            }
        }
        catch (MdException e) {
            result = new ArrayList<String>(1);
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", e);
        }
        return result;
    }

    @Override
    public String getApplicationProtocol() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            Iterator enumeration = ass.iterator();
            if (enumeration.hasNext()) {
                Connection connection = (Connection)enumeration.next();
                return connection.getApplicationProtocol();
            }
        }
        catch (MdException e) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", e);
        }
        return null;
    }

    @Override
    public void setApplicationProtocol(String protocol) throws ServiceException, RemoteException {
        this.checkPulse(true);
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Connection connection : ass) {
                connection.setApplicationProtocol(protocol);
            }
        }
        catch (MdException e) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", e);
        }
    }

    @Override
    public List getProperties() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            DeployedComponent server = (DeployedComponent)this._repositoryObject;
            AssociationList propList = server.getProperties();
            ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(propList.size());
            for (Property prop : propList) {
                MetadataInterface mi = this._repository.factoryProcess(prop);
                if (mi == null) {
                    mi = new Metadata(prop);
                    mi.setRepository(this._repository);
                }
                results.add(mi);
            }
            return results;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMRServer.propertyerror.ex.txt"));
        }
    }

    @Override
    public PropertyInterface getProperty(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            DeployedComponent server = (DeployedComponent)this._repositoryObject;
            AssociationList propList = server.getProperties();
            for (Property prop : propList) {
                if (!name.equalsIgnoreCase(prop.getPropertyName())) continue;
                OMRProperty mi = new OMRProperty(prop);
                return mi;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMRServer.propertyerror.ex.txt"));
        }
        return null;
    }

    @Override
    public List getProperties(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            DeployedComponent server = (DeployedComponent)this._repositoryObject;
            AssociationList propList = server.getProperties();
            ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(propList.size());
            for (Property prop : propList) {
                if (!name.equalsIgnoreCase(prop.getPropertyName())) continue;
                MetadataInterface mi = this._repository.factoryProcess(prop);
                if (mi == null) {
                    mi = new Metadata(prop);
                    mi.setRepository(this._repository);
                }
                results.add(mi);
            }
            return results;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMRServer.propertyerror.ex.txt"));
        }
    }

    @Override
    public void addProperty(PropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        try {
            DeployedComponent server = (DeployedComponent)this._repositoryObject;
            AssociationList props = server.getProperties();
            props.add(property.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeProperty(PropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        try {
            DeployedComponent server = (DeployedComponent)this._repositoryObject;
            AssociationList props = server.getProperties();
            for (Property nextProp : props) {
                if (!nextProp.getFQID().equals(property.getReposId())) continue;
                props.remove((Object)nextProp);
                return;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getServers() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        try {
            DeployedComponent server = (DeployedComponent)this._repositoryObject;
            AssociationList usingList = server.getUsingComponents();
            results = new ArrayList(usingList.size());
            for (DeployedComponent nextServer : usingList) {
                MetadataInterface mi = this._repository.factoryProcess(nextServer);
                if (mi == null) {
                    mi = new Metadata(nextServer);
                    mi.setRepository(this._repository);
                }
                results.add(mi);
            }
            if (results == null) {
                results = new ArrayList(1);
            }
        }
        catch (MdException ex) {
            try {
                throw new ServiceException(ex, RB.getStringResource("OMRServer.servererror.ex.txt"));
            }
            catch (Throwable throwable) {
                if (results == null) {
                    results = new ArrayList<MetadataInterface>(1);
                }
                throw throwable;
            }
        }
        return results;
    }

    @Override
    public void addServer(ServerInterface server) throws ServiceException, RemoteException {
        this.checkPulse(true);
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList usingList = dserver.getUsingComponents();
            usingList.add(server.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMRServer.servererror.ex.txt"));
        }
    }

    @Override
    public void removeServer(ServerInterface server) throws ServiceException, RemoteException {
        this.checkPulse(true);
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList usingList = dserver.getUsingComponents();
            for (CMetadata cm : usingList) {
                if (!cm.getFQID().equals(server.getReposId())) continue;
                usingList.remove((Object)cm);
                return;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMRServer.servererror.ex.txt"));
        }
    }

    @Override
    public List getServed() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        try {
            DeployedComponent server = (DeployedComponent)this._repositoryObject;
            AssociationList usingList = server.getUsedByComponents();
            results = new ArrayList(usingList.size());
            for (DeployedComponent nextServer : usingList) {
                MetadataInterface mi = this._repository.factoryProcess(nextServer);
                if (mi == null) {
                    mi = new Metadata(nextServer);
                    mi.setRepository(this._repository);
                }
                results.add(mi);
            }
            if (results == null) {
                results = new ArrayList(1);
            }
        }
        catch (MdException ex) {
            try {
                throw new ServiceException(ex, RB.getStringResource("OMRServer.servererror.ex.txt"));
            }
            catch (Throwable throwable) {
                if (results == null) {
                    results = new ArrayList<MetadataInterface>(1);
                }
                throw throwable;
            }
        }
        return results;
    }

    @Override
    public void addServed(ServerInterface server) throws ServiceException, RemoteException {
        this.checkPulse(true);
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList usingList = dserver.getUsedByComponents();
            usingList.add(server.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMRServer.servererror.ex.txt"));
        }
    }

    @Override
    public void removeServed(ServerInterface server) throws ServiceException, RemoteException {
        this.checkPulse(true);
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList usingList = dserver.getUsedByComponents();
            for (CMetadata cm : usingList) {
                if (!cm.getFQID().equals(server.getReposId())) continue;
                usingList.remove((Object)cm);
                return;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMRServer.servererror.ex.txt"));
        }
    }

    @Override
    public List getServiceTypes() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<String> result = null;
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList typeList = dserver.getServiceTypes();
            result = new ArrayList(typeList.size());
            for (ServiceType nextType : typeList) {
                result.add(nextType.getName());
            }
            if (result == null) {
                result = new ArrayList(1);
            }
        }
        catch (MdException ex) {
            try {
                throw new ServiceException(ex, RB.getStringResource("Metadata.accessexcept.msg.txt"));
            }
            catch (Throwable throwable) {
                if (result == null) {
                    result = new ArrayList<String>(1);
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public List getDataPackages() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> result = null;
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList packages = dserver.getDataPackages();
            result = new ArrayList(packages.size());
            for (Root root : packages) {
                MetadataInterface nextPackage = this._repository.factoryProcess(root);
                result.add(nextPackage);
            }
            if (result == null) {
                result = new ArrayList(1);
            }
        }
        catch (MdException ex) {
            try {
                throw new ServiceException(ex, RB.getStringResource("Metadata.accessexcept.msg.txt"));
            }
            catch (Throwable throwable) {
                if (result == null) {
                    result = new ArrayList<MetadataInterface>(1);
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public void addDataPackage(DeployedDataPackageInterface dataPackage) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList packages = dserver.getDataPackages();
            packages.add(dataPackage.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("Metadata.accessexcept.msg.txt"));
        }
    }

    @Override
    public void removeDataPackage(DeployedDataPackageInterface dataPackage) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            DeployedComponent dserver = (DeployedComponent)this._repositoryObject;
            AssociationList packages = dserver.getDataPackages();
            packages.remove(dataPackage.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("Metadata.accessexcept.msg.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List getConnectionProperties() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Object result = null;
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Connection con : ass) {
                if (con instanceof TCPIPConnection) {
                    AssociationList properties = con.getProperties();
                    result = new ArrayList(properties.size());
                    Iterator propIt = properties.iterator();
                    while (true) {
                        Property prop;
                        if (!propIt.hasNext()) {
                            prop = result;
                            if (result != null) return prop;
                            result = new ArrayList(1);
                            return prop;
                        }
                        prop = (Property)propIt.next();
                        MetadataInterface mi = this._repository.factoryProcess(prop);
                        result.add(mi);
                    }
                }
                if (!(con instanceof SASClientConnection)) continue;
                AssociationList properties = con.getProperties();
                Iterator propIt = properties.iterator();
                result = new ArrayList(properties.size());
                while (true) {
                    if (!propIt.hasNext()) {
                        Property property = result;
                        if (result != null) return property;
                        result = new ArrayList(1);
                        return property;
                    }
                    Property prop = (Property)propIt.next();
                    MetadataInterface mi = this._repository.factoryProcess(prop);
                    result.add(mi);
                }
            }
        }
        catch (MdException ex) {
            try {
                this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", ex);
                if (result != null) return result;
                return new ArrayList(1);
            }
            catch (Throwable throwable) {
                if (result != null) throw throwable;
                result = new ArrayList(1);
                throw throwable;
            }
        }
        if (result != null) return result;
        return new ArrayList(1);
    }

    @Override
    public SoftwareComponentInterface getDescriptiveComponent() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            SoftwareComponent softCom = server.getDescriptiveComponent();
            return (SoftwareComponentInterface)this._repository.factoryProcess(softCom);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setMachine(String machineName) throws RemoteException {
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent("Name", 0, machineName);
            filter.setType("Machine");
            filter.setFilterComponent(fc);
            List machineList = this._repository.search(filter);
            if (machineList != null && machineList.size() > 0) {
                MetadataInterface mi = (MetadataInterface)machineList.get(0);
                Machine machine = (Machine)mi.getRepositoryEntity();
                server.setAssociatedMachine(machine);
            } else {
                Machine machine = (Machine)((OMIRepositoryInterface)this._repository).createMetadata(machineName, "Machine");
                server.setAssociatedMachine(machine);
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", ex);
        }
    }

    @Override
    public String getMachine() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            Machine machine = server.getAssociatedMachine();
            if (machine != null) {
                return machine.getName();
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRServer", ex);
        }
        return null;
    }

    @Override
    public List getSourceConnections() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = Collections.EMPTY_LIST;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList connList = server.getSourceConnections(true);
            if (connList.size() > 0) {
                results = new ArrayList<MetadataInterface>(connList.size());
                for (Object o : connList) {
                    MetadataInterface mi = this._repository.factoryProcess(o);
                    results.add(mi);
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addSourceConnection(ConnectionInterface connection) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList connList = server.getSourceConnections();
            connList.add(connection.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeSourceConnection(ConnectionInterface connection) throws ServiceException, RemoteException {
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            AssociationList connList = server.getSourceConnections();
            connList.remove(connection.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public boolean getIsLicensed() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        int value = softcom.getIsLicensed();
        return value != 0;
    }

    @Override
    public void setIsLicensed(boolean value) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        softcom.setIsLicensed(value ? 1 : 0);
    }

    @Override
    public List getServiceTypeObjects() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList typeList = softcom.getServiceTypes();
            if (typeList.size() > 0) {
                results = new ArrayList<MetadataInterface>(typeList.size());
                for (Object o : typeList) {
                    results.add(this._repository.factoryProcess(o));
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addServiceType(ServiceTypeInterface serviceType) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList typeList = softcom.getServiceTypes();
            ServiceType st = (ServiceType)serviceType.getRepositoryEntity();
            typeList.add(st);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeServiceType(ServiceTypeInterface serviceType) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList typeList = softcom.getServiceTypes();
            ServiceType st = (ServiceType)serviceType.getRepositoryEntity();
            typeList.remove(st);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getComputeTasks(boolean gotoServer) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList taskList = null;
            taskList = gotoServer ? softcom.getComputeTasks(true) : softcom.getComputeTasks();
            if (taskList.size() > 0) {
                results = new ArrayList<MetadataInterface>(taskList.size());
                for (Object o : taskList) {
                    MetadataInterface mi = this._repository.factoryProcess(o);
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addComputeTask(MetadataInterface task) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList taskList = softcom.getComputeTasks();
            AbstractTransformation at = (AbstractTransformation)task.getRepositoryEntity();
            taskList.add(at);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeComputeTask(MetadataInterface task) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList taskList = softcom.getComputeTasks();
            AbstractTransformation at = (AbstractTransformation)task.getRepositoryEntity();
            taskList.remove(at);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public String getInstallationLocation() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        return softcom.getInstallationLocation();
    }

    @Override
    public void setInstallationLocation(String location) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent softcom = (DeployedComponent)this._repositoryObject;
        softcom.setInstallationLocation(location);
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.checkPulse(true);
        String myName = this.getName();
        switch (this._repositoryFlag) {
            case 2: {
                UniqueNameValidator nameValidator = UniqueNameValidator.getRepositoryNameValidator();
                try {
                    if (!nameValidator.validateName(this, name)) {
                        throw new IllegalArgumentException(Message.format((String)RB.getStringResource("OMRServer.DuplicateName.fmt.txt"), (Object)name));
                    }
                    super.setName(name);
                    break;
                }
                catch (ServiceException se) {
                    throw new RuntimeException(se.getMessage(), (Throwable)((Object)se));
                }
            }
        }
    }
}

