/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.UniqueKey;
import com.sas.metadata.remote.impl.DataTableImpl;
import com.sas.metadata.remote.impl.RelationalTableImpl;
import com.sas.metadata.remote.impl.RelationalTableImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.ForeignKeyInterface;
import com.sas.services.information.metadata.IndexAttribute;
import com.sas.services.information.metadata.IndexInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRDataTable;
import com.sas.services.information.metadata.OMRForeignKey;
import com.sas.services.information.metadata.OMRRelationalKey;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalKeyInterface;
import com.sas.services.information.metadata.RelationalTableInterface;
import com.sas.services.information.metadata.SmartUtils;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRRelationalTable
extends OMRDataTable
implements RelationalTableInterface {
    private static final long serialVersionUID = -1239491480902097016L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRRelationalTable(Class c) throws RemoteException {
        super(c);
    }

    public OMRRelationalTable() throws RemoteException {
        this(OMRRelationalTable.class);
    }

    protected OMRRelationalTable(RelationalTable o, Class c) throws RemoteException {
        super((DataTable)o, c);
    }

    public OMRRelationalTable(RelationalTable o) throws RemoteException {
        this(o, OMRRelationalTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRRelationalTable(RelationalTableImpl o, Class c) throws RemoteException {
        super((DataTableImpl)o, c);
    }

    public OMRRelationalTable(RelationalTableImpl o) throws RemoteException {
        this(o, OMRRelationalTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRRelationalTable(RelationalTableImpl_Stub o, Class c) throws RemoteException {
        super((DataTable)o, c);
    }

    public OMRRelationalTable(RelationalTableImpl_Stub o) throws RemoteException {
        this(o, OMRRelationalTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRRelationalTable(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRRelationalTable.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                RelationalTable dataTable = (RelationalTable)omirepository.createMetadata(name, "RelationalTable");
                dataTable.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = dataTable;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    dataTable.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDataTable", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "RelationalTable";
    }

    @Override
    public ForeignKeyInterface addForeignKey(String name, RelationalKeyInterface smartUKey) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        OMRForeignKey smartFKey = null;
        RelationalTable relationalTable = (RelationalTable)this.getRepositoryEntity();
        try {
            SmartUtils.validateDuplicates(name, this.getForeignKeys());
            smartFKey = new OMRForeignKey(this.getRepository(), name, null);
            ForeignKey fk = (ForeignKey)smartFKey.getRepositoryEntity();
            fk.setPartnerUniqueKey((UniqueKey)smartUKey.getRepositoryEntity());
            relationalTable.getForeignKeys().add((Object)fk);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return smartFKey;
    }

    @Override
    public RelationalKeyInterface addUniqueKey(String name, List<ColumnInterface> listColumn) throws ServiceException, RemoteException {
        SmartUtils.validateDuplicates(name, this.getUniqueKeys());
        SmartUtils.validateMatchingPrimaryKeyExist(this, listColumn);
        return this.addRelationalKey(name, listColumn, RelationalKeyInterface.KeyType.UNIQUE);
    }

    @Override
    public RelationalKeyInterface addPrimaryKey(String name, List<ColumnInterface> listColumn) throws ServiceException, RemoteException {
        try {
            SmartUtils.validatePrimaryKeyExist(this);
            SmartUtils.validateMatchingUniqueKeyExist(this, listColumn);
            return this.addRelationalKey(name, listColumn, RelationalKeyInterface.KeyType.PRIMARY);
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private RelationalKeyInterface addRelationalKey(String name, List<ColumnInterface> listColumn, RelationalKeyInterface.KeyType keyType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        OMRRelationalKey relationalKey = null;
        RelationalTable relationalTable = (RelationalTable)this.getRepositoryEntity();
        try {
            switch (keyType) {
                case UNIQUE: 
                case PRIMARY: {
                    SmartUtils.validateDuplicates(listColumn);
                    relationalKey = new OMRRelationalKey(this.getRepository(), name, null);
                    relationalKey.setKeyType(keyType);
                    relationalKey.addColumns(listColumn);
                    UniqueKey uk = (UniqueKey)relationalKey.getRepositoryEntity();
                    relationalTable.getUniqueKeys().add((Object)uk);
                    PhysicalTableInterface physicalTable = (PhysicalTableInterface)((Object)this);
                    IndexInterface index = SmartUtils.searchIndex(physicalTable, listColumn);
                    if (index == null) {
                        index = listColumn.size() == 1 ? physicalTable.addSimpleIndex(listColumn.get(0)) : physicalTable.addIndex(SmartUtils.generateIndexName(physicalTable), listColumn);
                    }
                    IndexAttribute isUnique = IndexAttribute.ISUNIQUE;
                    isUnique.setValue(Boolean.TRUE);
                    HashSet<IndexAttribute> setIndexAttribute = new HashSet<IndexAttribute>();
                    setIndexAttribute.add(isUnique);
                    index.setIndexAttributes(setIndexAttribute);
                    relationalKey.setAssociatedIndex(index);
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return relationalKey;
    }

    @Override
    public List<ForeignKeyInterface> getForeignKeys() throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        ArrayList<ForeignKeyInterface> listFK = new ArrayList<ForeignKeyInterface>();
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        RelationalTable relationalTable = (RelationalTable)this.getRepositoryEntity();
        try {
            Iterator iterFKeys = relationalTable.getForeignKeys().iterator();
            while (iterFKeys.hasNext()) {
                mi = this._repository.factoryProcess(iterFKeys.next());
                if (!(mi instanceof ForeignKeyInterface)) continue;
                listFK.add((ForeignKeyInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listFK;
    }

    @Override
    public List<RelationalKeyInterface> getUniqueKeys() throws ServiceException, RemoteException {
        return this.getRelationalKeys(RelationalKeyInterface.KeyType.UNIQUE);
    }

    @Override
    public RelationalKeyInterface getPrimaryKey() throws ServiceException, RemoteException {
        List<RelationalKeyInterface> listPrimaryKeys = this.getRelationalKeys(RelationalKeyInterface.KeyType.PRIMARY);
        if (listPrimaryKeys.size() > 0) {
            return listPrimaryKeys.get(0);
        }
        return null;
    }

    private List<RelationalKeyInterface> getRelationalKeys(RelationalKeyInterface.KeyType keyType) throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        RelationalKeyInterface rk = null;
        IndexInterface index = null;
        ArrayList<RelationalKeyInterface> listRK = new ArrayList<RelationalKeyInterface>();
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        RelationalTable relationalTable = (RelationalTable)this.getRepositoryEntity();
        try {
            Iterator iterUKeys = relationalTable.getUniqueKeys().iterator();
            while (iterUKeys.hasNext()) {
                mi = this._repository.factoryProcess(iterUKeys.next());
                if (!(mi instanceof RelationalKeyInterface) || keyType != (rk = (RelationalKeyInterface)mi).getKeyType()) continue;
                index = SmartUtils.searchIndex((PhysicalTableInterface)((Object)this), rk.getColumns());
                rk.setAssociatedIndex(index);
                listRK.add(rk);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listRK;
    }

    @Override
    public void removeForeignKey(ForeignKeyInterface relationalKey) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        RelationalTable relationalTable = (RelationalTable)this.getRepositoryEntity();
        try {
            ForeignKey fk = (ForeignKey)relationalKey.getRepositoryEntity();
            relationalTable.getForeignKeys().remove((Object)fk);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeUniqueKey(RelationalKeyInterface relationalKey) throws ServiceException, RemoteException {
        this.removeRelationalKey(relationalKey, RelationalKeyInterface.KeyType.UNIQUE);
    }

    @Override
    public void removePrimaryKey(RelationalKeyInterface relationalKey) throws ServiceException, RemoteException {
        this.removeRelationalKey(relationalKey, RelationalKeyInterface.KeyType.PRIMARY);
    }

    private void removeRelationalKey(RelationalKeyInterface relationalKey, RelationalKeyInterface.KeyType keyType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        RelationalTable relationalTable = (RelationalTable)this.getRepositoryEntity();
        try {
            switch (keyType) {
                case UNIQUE: 
                case PRIMARY: {
                    IndexInterface index = relationalKey.getAssociatedIndex();
                    IndexAttribute isUnique = IndexAttribute.ISUNIQUE;
                    isUnique.setValue(Boolean.FALSE);
                    HashSet<IndexAttribute> setIndexAttribute = new HashSet<IndexAttribute>();
                    setIndexAttribute.add(isUnique);
                    index.setIndexAttributes(setIndexAttribute);
                    UniqueKey uk = (UniqueKey)relationalKey.getRepositoryEntity();
                    relationalTable.getUniqueKeys().remove((Object)uk);
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }
}

