/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.UniqueKey;
import com.sas.metadata.remote.impl.UniqueKeyImpl;
import com.sas.metadata.remote.impl.UniqueKeyImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.ForeignKeyInterface;
import com.sas.services.information.metadata.IndexInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalKeyInterface;
import com.sas.services.information.metadata.RelationalTableInterface;
import com.sas.services.information.metadata.SmartUtils;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRRelationalKey
extends Metadata
implements RelationalKeyInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private IndexInterface index;

    public OMRRelationalKey() throws RemoteException {
        this(OMRRelationalKey.class);
    }

    protected OMRRelationalKey(Class c) throws RemoteException {
        super(c);
        this.index = null;
    }

    public OMRRelationalKey(UniqueKey o) throws RemoteException {
        this(o, OMRRelationalKey.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRRelationalKey(UniqueKey o, Class c) throws RemoteException {
        super(o, c);
        this.index = null;
    }

    public OMRRelationalKey(UniqueKeyImpl o) throws RemoteException {
        this(o, OMRRelationalKey.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRRelationalKey(UniqueKeyImpl o, Class c) throws RemoteException {
        super(o, c);
        this.index = null;
    }

    public OMRRelationalKey(UniqueKeyImpl_Stub o) throws RemoteException {
        this(o, OMRRelationalKey.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRRelationalKey(UniqueKeyImpl_Stub o, Class c) throws RemoteException {
        super(o, c);
        this.index = null;
    }

    public OMRRelationalKey(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRRelationalKey.class);
            this.index = null;
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                UniqueKey key = (UniqueKey)omirepository.createMetadata(name, "UniqueKey");
                key.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = key;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                this.setKeyType(RelationalKeyInterface.KeyType.UNIQUE);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    key.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRRelationalKey", t);
            }
        }
    }

    @Override
    public RelationalKeyInterface.KeyType getKeyType() throws ServiceException, RemoteException {
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        if (uniqueKey.getIsPrimary() == 1) {
            return RelationalKeyInterface.KeyType.PRIMARY;
        }
        return RelationalKeyInterface.KeyType.UNIQUE;
    }

    @Override
    public void setKeyType(RelationalKeyInterface.KeyType keyType) throws ServiceException, RemoteException {
        if (keyType != null) {
            UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
            if (keyType == RelationalKeyInterface.KeyType.PRIMARY) {
                if (null != this.getOwningTable()) {
                    SmartUtils.validatePrimaryKeyExist((RelationalTableInterface)this.getOwningTable());
                }
                SmartUtils.validatePrimaryKeyColumns(this.getColumns());
                uniqueKey.setIsPrimary(1);
            } else if (keyType == RelationalKeyInterface.KeyType.UNIQUE) {
                uniqueKey.setIsPrimary(0);
            }
        }
    }

    @Override
    public void addColumn(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<ColumnInterface> listColumn = new ArrayList<ColumnInterface>(1);
        listColumn.add(column);
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            if (RelationalKeyInterface.KeyType.PRIMARY == this.getKeyType()) {
                SmartUtils.validatePrimaryKeyColumns(listColumn);
            }
            List<ColumnInterface> listKeyColumns = this.getColumns();
            SmartUtils.validateDuplicates(column.getName(), listKeyColumns);
            uniqueKey.getKeyedColumns().add(column.getRepositoryEntity());
            PhysicalTableInterface table = (PhysicalTableInterface)this.getOwningTable();
            if (null != this.index) {
                Index jomaIndex = (Index)this.index.getRepositoryEntity();
                jomaIndex.setIsUnique(0);
                if (this.index.isSimpleIndex()) {
                    listKeyColumns.add(column);
                    this.index.convertToCompositeIndex(SmartUtils.generateIndexName(table), listKeyColumns);
                } else {
                    this.index.addColumn(column);
                }
                jomaIndex.setIsUnique(1);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public void addColumns(List<ColumnInterface> columns) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            if (RelationalKeyInterface.KeyType.PRIMARY == this.getKeyType()) {
                SmartUtils.validatePrimaryKeyColumns(columns);
            }
            List<ColumnInterface> listKeyColumns = this.getColumns();
            AssociationList alColumn = uniqueKey.getKeyedColumns();
            for (ColumnInterface ci : columns) {
                SmartUtils.validateDuplicates(ci.getName(), listKeyColumns);
                Column c = (Column)ci.getRepositoryEntity();
                alColumn.add((Object)c);
            }
            PhysicalTableInterface table = (PhysicalTableInterface)this.getOwningTable();
            if (null != this.index) {
                Index jomaIndex = (Index)this.index.getRepositoryEntity();
                jomaIndex.setIsUnique(0);
                if (this.index.isSimpleIndex()) {
                    listKeyColumns.addAll(columns);
                    this.index.convertToCompositeIndex(SmartUtils.generateIndexName(table), listKeyColumns);
                } else {
                    this.index.addColumns(columns);
                }
                jomaIndex.setIsUnique(1);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void addColumnAt(ColumnInterface column, int pos) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<ColumnInterface> listColumn = new ArrayList<ColumnInterface>(1);
        listColumn.add(column);
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            if (RelationalKeyInterface.KeyType.PRIMARY == this.getKeyType()) {
                SmartUtils.validatePrimaryKeyColumns(listColumn);
            }
            List<ColumnInterface> listKeyColumns = this.getColumns();
            SmartUtils.validateDuplicates(column.getName(), listKeyColumns);
            uniqueKey.getKeyedColumns().add(pos, column.getRepositoryEntity());
            PhysicalTableInterface table = (PhysicalTableInterface)this.getOwningTable();
            if (null != this.index) {
                Index jomaIndex = (Index)this.index.getRepositoryEntity();
                jomaIndex.setIsUnique(0);
                if (this.index.isSimpleIndex()) {
                    listKeyColumns.add(pos, column);
                    this.index.convertToCompositeIndex(SmartUtils.generateIndexName(table), listKeyColumns);
                } else {
                    this.index.addColumnAt(column, pos);
                }
                jomaIndex.setIsUnique(1);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public void removeColumn(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            List<ColumnInterface> listKeyColumns = this.getColumns();
            AssociationList alColumns = uniqueKey.getKeyedColumns();
            SmartUtils.validateRemoveObject(listKeyColumns);
            alColumns.remove(column.getRepositoryEntity());
            listKeyColumns.remove(column);
            if (null != this.index) {
                Index jomaIndex = (Index)this.index.getRepositoryEntity();
                jomaIndex.setIsUnique(0);
                if (listKeyColumns.size() == 1) {
                    this.index.convertToSimpleIndex(listKeyColumns.get(0));
                } else {
                    this.index.removeColumn(column);
                }
                jomaIndex.setIsUnique(1);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public void removeColumns(List<ColumnInterface> columns) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            List<ColumnInterface> listKeyColumns = this.getColumns();
            AssociationList alColumns = uniqueKey.getKeyedColumns();
            SmartUtils.validateRemoveObject(listKeyColumns, columns);
            for (ColumnInterface column : columns) {
                alColumns.remove(column.getRepositoryEntity());
            }
            listKeyColumns.removeAll(columns);
            if (null != this.index) {
                Index jomaIndex = (Index)this.index.getRepositoryEntity();
                jomaIndex.setIsUnique(0);
                if (listKeyColumns.size() == 1) {
                    this.index.convertToSimpleIndex(listKeyColumns.get(0));
                } else {
                    this.index.removeColumns(columns);
                }
                jomaIndex.setIsUnique(1);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public void removeColumn(int pos) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            List<ColumnInterface> listKeyColumns = this.getColumns();
            AssociationList alColumns = uniqueKey.getKeyedColumns();
            SmartUtils.validateRemoveObject(listKeyColumns);
            alColumns.remove(pos);
            listKeyColumns.remove(pos);
            if (null != this.index) {
                Index jomaIndex = (Index)this.index.getRepositoryEntity();
                jomaIndex.setIsUnique(0);
                if (listKeyColumns.size() == 1) {
                    this.index.convertToSimpleIndex(listKeyColumns.get(0));
                } else {
                    this.index.removeColumn(pos);
                }
                jomaIndex.setIsUnique(1);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public List<ColumnInterface> getColumns() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<ColumnInterface> columns = new ArrayList<ColumnInterface>();
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            AssociationList Al = uniqueKey.getKeyedColumns();
            Iterator it = Al.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                if (!(mi instanceof ColumnInterface)) continue;
                columns.add((ColumnInterface)mi);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
        return columns;
    }

    @Override
    public DataTableInterface getOwningTable() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            DataTable dt = uniqueKey.getTable();
            DataTableInterface dti = (DataTableInterface)this._repository.factoryProcess(dt);
            return dti;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public List<ForeignKeyInterface> getForeignKeys() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        MetadataInterface mi = null;
        ArrayList<ForeignKeyInterface> listForeignKeys = null;
        UniqueKey uniqueKey = (UniqueKey)this.getRepositoryEntity();
        try {
            AssociationList alForeignKeys = uniqueKey.getForeignKeys();
            listForeignKeys = new ArrayList<ForeignKeyInterface>(alForeignKeys.size());
            for (Object fkey : alForeignKeys) {
                mi = this._repository.factoryProcess(fkey);
                if (!(mi instanceof ForeignKeyInterface)) continue;
                listForeignKeys.add((ForeignKeyInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listForeignKeys;
    }

    @Override
    public IndexInterface getAssociatedIndex() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        return this.index;
    }

    @Override
    public void setAssociatedIndex(IndexInterface index) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.index = index;
    }
}

