/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.HostInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRHost;
import com.sas.services.information.metadata.OMRProxy;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.information.metadata.ProxyInterface;
import com.sas.services.information.metadata.ProxyListInterface;
import com.sas.services.information.metadata.RB;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OMRProxyList
extends OMRServerComponent
implements ProxyListInterface,
SubstitutionProperties {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final String PROPERTY_PROXYMACHINE_LIST = "ProxiedMachineList";
    private int m_nextProxyID;

    public OMRProxyList() throws RemoteException {
        super(OMRProxyList.class);
    }

    public OMRProxyList(Class theClass) throws RemoteException {
        super(theClass);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRProxyList(ServerComponent o, Class theClass) throws RemoteException {
        super(o, theClass);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRProxyList(ServerComponentImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRProxyList(ServerComponent component) throws RemoteException {
        super(component, OMRProxyList.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    @Override
    public List<String> getProxiedMachines() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<String> results = null;
        ServerComponent proxyList = (ServerComponent)this._repositoryObject;
        try {
            AssociationList machines = proxyList.getImplementedObjects();
            results = new ArrayList<String>(machines.size());
            for (int i = 0; i < machines.size(); ++i) {
                results.add(((Machine)machines.get(i)).getName());
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, RB.getStringResource("ProxyList.machineerror.ex.txt"));
        }
        finally {
            if (results == null) {
                results = new ArrayList(1);
            }
        }
        return results;
    }

    @Override
    public List<ProxyInterface> getProxies() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<ProxyInterface> results = null;
        try {
            ServerComponent proxyList = (ServerComponent)this._repositoryObject;
            AssociationList proxies = proxyList.getSourceConnections();
            results = new ArrayList(proxies.size());
            for (int i = 0; i < proxies.size(); ++i) {
                TCPIPConnection proxy = (TCPIPConnection)proxies.get(i);
                MetadataInterface mi = this._repository.factoryProcess(proxy);
                if (mi == null) {
                    mi = new OMRProxy(proxy);
                    mi.setRepository(this._repository);
                }
                results.add((ProxyInterface)mi);
            }
            if (results == null) {
                results = new ArrayList(1);
            }
        }
        catch (MdException ex) {
            try {
                throw new ServiceException(ex, RB.getStringResource("ProxyList.proxyerror.ex.txt"));
            }
            catch (Throwable throwable) {
                if (results == null) {
                    results = new ArrayList<ProxyInterface>(1);
                }
                throw throwable;
            }
        }
        return results;
    }

    @Override
    public List<String> getProxyURIs() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        List<ProxyInterface> proxies = this.getProxies();
        ArrayList<String> results = new ArrayList<String>(proxies.size());
        for (int i = 0; i < proxies.size(); ++i) {
            results.add(proxies.get(i).getURI());
        }
        return results;
    }

    @Override
    public void setProxiedMachines(List<String> machines) throws IllegalArgumentException, ServiceException, RemoteException {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void setProxies(List<ProxyInterface> proxies) throws RemoteException, ServiceException {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void setProxyURIs(List<String> uris) throws RemoteException, ServiceException {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public String generateNextProxyName() throws RemoteException, ServiceException {
        this.m_nextProxyID = -1;
        ServerComponent proxyList = (ServerComponent)this._repositoryObject;
        try {
            AssociationList proxyConns = proxyList.getSourceConnections();
            for (int i = 0; i < proxyConns.size(); ++i) {
                TCPIPConnection proxyConn = (TCPIPConnection)proxyConns.get(i);
                String[] tokens = proxyConn.getName().split("_");
                if (tokens.length != 3 || Integer.valueOf(tokens[2]) <= this.m_nextProxyID) continue;
                this.m_nextProxyID = Integer.valueOf(tokens[2]);
            }
            ++this.m_nextProxyID;
            return proxyList.getName() + "_Proxy_" + String.valueOf(this.m_nextProxyID);
        }
        catch (MdException e) {
            throw new ServiceException(RB.getStringResource("ProxyList.proxyerror.ex.txt"));
        }
    }

    @Override
    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        try {
            PropertyList srvProperties = new PropertyList();
            ServerComponent proxyList = (ServerComponent)this._repositoryObject;
            AssociationList machines = proxyList.getImplementedObjects();
            for (int i = 0; i < machines.size(); ++i) {
                srvProperties.addProperty(PROPERTY_PROXYMACHINE_LIST, i, ((Machine)machines.get(i)).getName());
            }
            return srvProperties;
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (MdException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
    }

    @Override
    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            ServerComponent proxyList = (ServerComponent)this._repositoryObject;
            String[] properties = map.getPropertiesBySuffix(PROPERTY_PROXYMACHINE_LIST);
            if (properties != null) {
                for (String entry : properties) {
                    HostInterface machine;
                    String machineName = map.getProperty(entry);
                    Filter filter = new Filter("Name", 0, machineName);
                    filter.setType("Machine");
                    List objects = this._repository.search(filter);
                    if (objects != null && objects.size() > 0) {
                        machine = (HostInterface)objects.get(0);
                    } else {
                        machine = new OMRHost(this._repository, machineName);
                        machine.update();
                    }
                    proxyList.getImplementedObjects().add(machine.getRepositoryEntity());
                }
            }
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (MdException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
    }

    @Override
    public String getHost() throws ServiceException, RemoteException {
        return "";
    }

    @Override
    public void setHost(String host) throws ServiceException, RemoteException {
    }

    @Override
    public int getTcpPort() throws ServiceException, RemoteException {
        return 0;
    }

    @Override
    public void setTcpPort(int port) throws ServiceException, RemoteException {
    }

    @Override
    public List getDomains() throws ServiceException, RemoteException {
        return new ArrayList();
    }

    @Override
    public List getConnectionProperties() throws ServiceException, RemoteException {
        return new ArrayList();
    }

    @Override
    public List getSourceConnections() throws ServiceException, RemoteException {
        return new ArrayList();
    }

    @Override
    public void addSourceConnection(ConnectionInterface connection) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void removeSourceConnection(ConnectionInterface connection) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException("Method not implemented");
    }
}

