/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Phone;
import com.sas.metadata.remote.impl.PhoneImpl;
import com.sas.metadata.remote.impl.PhoneImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.PhoneNumberInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRPhone
extends Metadata
implements PhoneNumberInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRPhone(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRPhone() throws RemoteException {
        this(OMRPhone.class);
    }

    protected OMRPhone(Phone o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRPhone(Phone o) throws RemoteException {
        super(o, OMRPhone.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPhone(PhoneImpl o) throws RemoteException {
        super(o, OMRPhone.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPhone(PhoneImpl_Stub o) throws RemoteException {
        super(o, OMRPhone.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPhone(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRPhone.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Phone phone = (Phone)omirepository.createMetadata(name, "Phone");
                phone.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = phone;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    phone.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPhysicalTable", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getNumber() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Phone phone = (Phone)this._repositoryObject;
        return phone.getNumber();
    }

    @Override
    public String getPhoneType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Phone phone = (Phone)this._repositoryObject;
        return phone.getPhoneType();
    }

    @Override
    public void setNumber(String number) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Phone phone = (Phone)this._repositoryObject;
        phone.setNumber(number);
    }

    @Override
    public void setPhoneType(String type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Phone phone = (Phone)this._repositoryObject;
        phone.setPhoneType(type);
    }
}

