/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.impl.IndexImpl;
import com.sas.metadata.remote.impl.IndexImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IndexAttribute;
import com.sas.services.information.metadata.IndexInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SmartUtils;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRIndex
extends Metadata
implements IndexInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRIndex() throws RemoteException {
        this(OMRIndex.class);
    }

    protected OMRIndex(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRIndex(Index index) throws RemoteException {
        this(index, OMRIndex.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRIndex(Index index, Class theClass) throws RemoteException {
        super(index, theClass);
    }

    public OMRIndex(IndexImpl index) throws RemoteException {
        this(index, OMRIndex.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRIndex(IndexImpl index, Class theClass) throws RemoteException {
        super(index, theClass);
    }

    public OMRIndex(IndexImpl_Stub index) throws RemoteException {
        this(index, OMRIndex.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRIndex(IndexImpl_Stub index, Class theClass) throws RemoteException {
        super(index, theClass);
    }

    public OMRIndex(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRIndex.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Index index = (Index)omirepository.createMetadata(name, "Index");
                index.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = index;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    index.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRIndex", t);
            }
        }
    }

    @Override
    public void addColumn(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.addColumn.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            SmartUtils.validateAddColumnToSimpleIndex(this);
            SmartUtils.validateDuplicates(column.getName(), this.getColumns());
            Column c = (Column)column.getRepositoryEntity();
            index.getColumns().add((Object)c);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void addColumnAt(ColumnInterface column, int pos) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.addColumn.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            SmartUtils.validateAddColumnToSimpleIndex(this);
            SmartUtils.validateDuplicates(column.getName(), this.getColumns());
            Column c = (Column)column.getRepositoryEntity();
            index.getColumns().add(pos, (Object)c);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void addColumns(List<ColumnInterface> columns) throws ServiceException, RemoteException {
        Column c = null;
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.addColumn.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            SmartUtils.validateAddColumnToSimpleIndex(this);
            AssociationList alColumns = index.getColumns();
            for (ColumnInterface ci : columns) {
                SmartUtils.validateDuplicates(ci.getName(), this.getColumns());
                c = (Column)ci.getRepositoryEntity();
                alColumns.add((Object)c);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public List<ColumnInterface> getColumns() throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        ArrayList<ColumnInterface> listColumn = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            AssociationList alColumn = index.getColumns();
            listColumn = new ArrayList<ColumnInterface>(alColumn.size());
            Iterator it = alColumn.iterator();
            while (it.hasNext()) {
                mi = this._repository.factoryProcess(it.next());
                if (!(mi instanceof ColumnInterface)) continue;
                listColumn.add((ColumnInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listColumn;
    }

    @Override
    public DataTableInterface getOwningTable() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            PhysicalTable dt = index.getOwningPhysicalTable();
            DataTableInterface dti = (DataTableInterface)this._repository.factoryProcess(dt);
            return dti;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeColumn(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this._repositoryObject;
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.removeColumn.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            SmartUtils.validateRemoveColumnsFromIndex(this, 1);
            AssociationList alColumns = index.getColumns();
            Column c = (Column)column.getRepositoryEntity();
            alColumns.remove((Object)c);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeColumn(int pos) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this._repositoryObject;
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.removeColumn.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            SmartUtils.validateRemoveColumnsFromIndex(this, 1);
            AssociationList alColumns = index.getColumns();
            alColumns.remove(pos);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeColumns(List<ColumnInterface> columns) throws ServiceException, RemoteException {
        Column c = null;
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this._repositoryObject;
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.removeColumn.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            SmartUtils.validateRemoveColumnsFromIndex(this, columns.size());
            AssociationList alColumns = index.getColumns();
            for (ColumnInterface ci : columns) {
                c = (Column)ci.getRepositoryEntity();
                alColumns.remove((Object)c);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void setIndexAttributes(Set<IndexAttribute> setIndexAttribute) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this._repositoryObject;
        try {
            for (IndexAttribute indexAttribute : setIndexAttribute) {
                switch (indexAttribute) {
                    case NAME: {
                        index.setName((String)indexAttribute.getValue());
                        break;
                    }
                    case DESC: {
                        index.setDesc((String)indexAttribute.getValue());
                        break;
                    }
                    case ID: {
                        index.setId((String)indexAttribute.getValue());
                        break;
                    }
                    case METADATACREATED: {
                        index.setMetadataCreated((String)indexAttribute.getValue());
                        break;
                    }
                    case METADATAUPDATED: {
                        index.setMetadataUpdated((String)indexAttribute.getValue());
                        break;
                    }
                    case INDEXNAME: {
                        index.setIndexName((String)indexAttribute.getValue());
                        break;
                    }
                    case PUBLICTYPE: {
                        index.setPublicType((String)indexAttribute.getValue());
                        break;
                    }
                    case LOCKEDBY: {
                        index.setLockedBy((String)indexAttribute.getValue());
                        break;
                    }
                    case CHANGESTATE: {
                        index.setChangeState((String)indexAttribute.getValue());
                        break;
                    }
                    case ISCLUSTERED: {
                        index.setIsClustered(this.convertBooleanToInt((Boolean)indexAttribute.getValue()));
                        break;
                    }
                    case ISUNIQUE: {
                        index.setIsUnique(this.convertBooleanToInt((Boolean)indexAttribute.getValue()));
                        break;
                    }
                    case ISNOMISS: {
                        index.setIsNoMiss(this.convertBooleanToInt((Boolean)indexAttribute.getValue()));
                        break;
                    }
                    case ISHIDDEN: {
                        index.setIsHidden(this.convertBooleanToInt((Boolean)indexAttribute.getValue()));
                        break;
                    }
                    case USAGEVERSION: {
                        index.setUsageVersion(((Double)indexAttribute.getValue()).doubleValue());
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public Set<IndexAttribute> getIndexAttributes() throws ServiceException, RemoteException {
        HashSet<IndexAttribute> setIndexAttribute = new HashSet<IndexAttribute>(IndexAttribute.values().length);
        IndexAttribute indexAttribute = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            IndexAttribute[] arrIndexAttribute = IndexAttribute.values();
            for (int i = 0; i < arrIndexAttribute.length; ++i) {
                switch (arrIndexAttribute[i]) {
                    case NAME: {
                        indexAttribute = IndexAttribute.NAME;
                        indexAttribute.setValue(index.getName());
                        break;
                    }
                    case ID: {
                        indexAttribute = IndexAttribute.ID;
                        indexAttribute.setValue(index.getId());
                        break;
                    }
                    case DESC: {
                        indexAttribute = IndexAttribute.DESC;
                        indexAttribute.setValue(index.getDesc());
                        break;
                    }
                    case METADATACREATED: {
                        indexAttribute = IndexAttribute.METADATACREATED;
                        indexAttribute.setValue(index.getMetadataCreated());
                        break;
                    }
                    case METADATAUPDATED: {
                        indexAttribute = IndexAttribute.METADATAUPDATED;
                        indexAttribute.setValue(index.getMetadataUpdated());
                        break;
                    }
                    case INDEXNAME: {
                        indexAttribute = IndexAttribute.INDEXNAME;
                        indexAttribute.setValue(index.getIndexName());
                        break;
                    }
                    case PUBLICTYPE: {
                        indexAttribute = IndexAttribute.PUBLICTYPE;
                        indexAttribute.setValue(index.getPublicType());
                        break;
                    }
                    case LOCKEDBY: {
                        indexAttribute = IndexAttribute.LOCKEDBY;
                        indexAttribute.setValue(index.getLockedBy());
                        break;
                    }
                    case CHANGESTATE: {
                        indexAttribute = IndexAttribute.CHANGESTATE;
                        indexAttribute.setValue(index.getChangeState());
                        break;
                    }
                    case ISCLUSTERED: {
                        indexAttribute = IndexAttribute.ISCLUSTERED;
                        indexAttribute.setValue(this.convertIntToBoolean(index.getIsClustered()));
                        break;
                    }
                    case ISUNIQUE: {
                        indexAttribute = IndexAttribute.ISUNIQUE;
                        indexAttribute.setValue(this.convertIntToBoolean(index.getIsUnique()));
                        break;
                    }
                    case ISNOMISS: {
                        indexAttribute = IndexAttribute.ISNOMISS;
                        indexAttribute.setValue(this.convertIntToBoolean(index.getIsNoMiss()));
                        break;
                    }
                    case ISHIDDEN: {
                        indexAttribute = IndexAttribute.ISHIDDEN;
                        indexAttribute.setValue(this.convertIntToBoolean(index.getIsHidden()));
                        break;
                    }
                    case USAGEVERSION: {
                        indexAttribute = IndexAttribute.USAGEVERSION;
                        indexAttribute.setValue(index.getUsageVersion());
                    }
                }
                setIndexAttribute.add(indexAttribute);
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return setIndexAttribute;
    }

    public int convertBooleanToInt(Boolean b) {
        if (b.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public Boolean convertIntToBoolean(int i) {
        if (i == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public IndexInterface convertToCompositeIndex(String name, List<ColumnInterface> listColumn) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.convertToCompositeIndex.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            DataTableInterface table = this.getOwningTable();
            SmartUtils.validateDuplicates(name, ((PhysicalTableInterface)table).getIndexes());
            SmartUtils.validateDuplicates(listColumn);
            index.setName(name);
            index.getColumns().clear();
            AssociationList alColumns = index.getColumns();
            for (ColumnInterface column : listColumn) {
                alColumns.add(column.getRepositoryEntity());
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return this;
    }

    @Override
    public IndexInterface convertToSimpleIndex(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        try {
            if (this.isAssociatedWithKey()) {
                throw new MdException(Message.format((String)RB.getStringResource("OMRIndex.convertToSimpleIndex.validateKeyAssociation.txt"), (Object)index.getName()));
            }
            DataTableInterface table = this.getOwningTable();
            SmartUtils.validateDuplicates(column.getName(), ((PhysicalTableInterface)table).getIndexes());
            index.setName(column.getName());
            index.getColumns().clear();
            index.getColumns().add(column.getRepositoryEntity());
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return this;
    }

    @Override
    public boolean isSimpleIndex() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        return this.getColumns().size() == 1;
    }

    @Override
    public boolean isAssociatedWithKey() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Index index = (Index)this.getRepositoryEntity();
        return index.getIsUnique() == 1;
    }
}

