/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.IdentityGroupImpl;
import com.sas.metadata.remote.impl.IdentityGroupImpl_Stub;
import com.sas.metadata.remote.impl.IdentityImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRIdentity;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RoleInterface;
import com.sas.services.information.publicobject.DetailsProcessor;
import com.sas.services.information.publicobject.ProcessorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRIdentityGroup
extends OMRIdentity
implements IdentityGroupInterface {
    private static final long serialVersionUID = -7337930556034598855L;
    private boolean refreshIdentities = false;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRIdentityGroup() throws RemoteException {
        this(OMRIdentityGroup.class);
    }

    public OMRIdentityGroup(IdentityGroup o) throws RemoteException {
        this(o, OMRIdentityGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRIdentityGroup(IdentityGroupImpl o) throws RemoteException {
        this(o, OMRIdentityGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRIdentityGroup(IdentityGroupImpl_Stub o) throws RemoteException {
        this(o, OMRIdentityGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRIdentityGroup(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRIdentityGroup.class);
    }

    protected OMRIdentityGroup(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRIdentityGroup(IdentityGroup o, Class theClass) throws RemoteException {
        super((Identity)o, theClass);
    }

    protected OMRIdentityGroup(IdentityGroupImpl o, Class theClass) throws RemoteException {
        super((IdentityImpl)o, theClass);
    }

    protected OMRIdentityGroup(IdentityGroupImpl_Stub o, Class theClass) throws RemoteException {
        super((Identity)o, theClass);
    }

    protected OMRIdentityGroup(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        super(theClass);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            IdentityGroup idGroup = (IdentityGroup)omirepository.createMetadata(name, "IdentityGroup");
            idGroup.setPublicType("UserGroup");
            idGroup.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = idGroup;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                if (parent != null) {
                    parent.addItem(this);
                }
            }
            catch (ServiceException ex) {
                idGroup.delete();
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
        catch (ServiceException t) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", (Throwable)((Object)t));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "UserGroup";
    }

    @Override
    public List getMembers() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = null;
        IdentityGroup idGroup = (IdentityGroup)this._repositoryObject;
        try {
            AssociationList members = null;
            if (this.refreshIdentities) {
                members = idGroup.getMemberIdentities(true);
                this.refreshIdentities = false;
            } else {
                members = idGroup.getMemberIdentities();
            }
            results = new ArrayList<MetadataInterface>(members.size());
            Iterator it = members.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                results.add(mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addIdentity(IdentityInterface identity) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        IdentityGroup idGroup = (IdentityGroup)this._repositoryObject;
        try {
            String idFQID = identity.getReposId();
            AssociationList members = idGroup.getMemberIdentities();
            for (Root root : members) {
                if (!root.getFQID().equals(idFQID)) continue;
                return;
            }
            members.add(identity.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeIdentity(IdentityInterface identity) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        IdentityGroup idGroup = (IdentityGroup)this._repositoryObject;
        try {
            AssociationList members = idGroup.getMemberIdentities();
            members.remove(identity.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setMembers(List members) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        IdentityGroup idGroup = (IdentityGroup)this._repositoryObject;
        try {
            AssociationList memberList = idGroup.getMemberIdentities();
            memberList.clear();
            for (IdentityInterface member : members) {
                memberList.add(member.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    public List getAssociatedOMRLogins() throws RemoteException, ServiceException {
        Iterator membersI;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<String> logins = new ArrayList<String>();
        IdentityGroup Role2 = (IdentityGroup)this._repositoryObject;
        try {
            membersI = Role2.getMemberIdentities().iterator();
        }
        catch (MdException e) {
            this.logMessage(Level.ERROR, "", "", e);
            throw new ServiceException(e, RB.getStringResource("OMRGroup.cantgetmembers.ex.txt"));
        }
        while (membersI.hasNext()) {
            Identity individual = (Identity)membersI.next();
            try {
                for (Login login : individual.getLogins()) {
                    logins.add(login.getUserID());
                }
            }
            catch (MdException e) {
                this.logMessage(Level.ERROR, "", "", e);
            }
        }
        return logins;
    }

    @Override
    public boolean isMember(UserContextInterface user) throws RemoteException, ServiceException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        List allLogins = this.getAssociatedOMRLogins();
        for (UserIdentityInterface uii : user.getIdentities()) {
            String login = (String)uii.getPrincipal();
            if (!allLogins.contains(login)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMember(String name) throws RemoteException, ServiceException {
        AssociationList members;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        IdentityGroup Role2 = (IdentityGroup)this._repositoryObject;
        try {
            members = Role2.getMemberIdentities();
        }
        catch (MdException e) {
            this.logMessage(Level.ERROR, "", "", e);
            throw new ServiceException(e, RB.getStringResource("OMRGroup.cantgetpropsets.ex.txt"));
        }
        for (int i = 0; i < members.size(); ++i) {
            Identity person = (Identity)members.get(i);
            if (!person.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getUsers() throws RemoteException, ServiceException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<String> userList = new ArrayList<String>();
        IdentityGroup role = (IdentityGroup)this._repositoryObject;
        try {
            for (Identity member : role.getMemberIdentities(true)) {
                if (!(member instanceof Person)) continue;
                userList.add(member.getName());
            }
            List roles = this.getNestedRoles();
            for (RoleInterface ri : roles) {
                userList.addAll(ri.getUsers());
            }
        }
        catch (ServiceException svcEx) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), (Throwable)((Object)svcEx));
            throw svcEx;
        }
        catch (MdException e) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), e);
            throw new ServiceException(e, e.getMessage());
        }
        return userList;
    }

    private List getNestedRoles() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<IdentityGroupInterface> roleList = new ArrayList<IdentityGroupInterface>();
        IdentityGroup role = (IdentityGroup)this._repositoryObject;
        try {
            for (Identity member : role.getMemberIdentities()) {
                if (!(member instanceof IdentityGroup) || !((IdentityGroup)member).getGroupType().equals("Role")) continue;
                IdentityGroupInterface ri = (IdentityGroupInterface)this._repository.factoryProcess(member);
                if (ri == null) {
                    ri = new OMRIdentityGroup((IdentityGroup)member);
                }
                ri.setRepository(this._repository);
                roleList.add(ri);
            }
            return roleList;
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        IdentityGroup role = (IdentityGroup)this._repositoryObject;
        try {
            MdObjectStore store = (MdObjectStore)role.getObjectStore();
            if (store == null || store.isDisposed()) {
                this._repository.browseFetch("AccessControlEntry+omi://host:port", null);
            }
            store.refreshObjectFromServer((CMetadata)role, false, false);
            role.getLogins(true);
            role.getIdentityGroups(true);
            role.getAccessControlEntries(true);
            this.refreshIdentities = true;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public FolderInterface getHomeFolder() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        FolderInterface result = null;
        IdentityGroup role = (IdentityGroup)this._repositoryObject;
        try {
            Tree tree = role.getAssociatedHomeFolder();
            if (tree != null) {
                result = (FolderInterface)this._repository.factoryProcess(tree);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public ProcessorInterface getProcessorInterface(String interfaceClassName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        ProcessorInterface returnValue = null;
        if ("com.sas.services.information.publicobject.DetailsProcessorInterface".equals(interfaceClassName)) {
            Object action = this._actionInterfaces.get(interfaceClassName);
            if (action != null && action instanceof ProcessorInterface) {
                returnValue = (ProcessorInterface)action;
            } else {
                returnValue = new UserGroupDetailsProcessor(this);
                this.addProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface", returnValue);
            }
        } else {
            returnValue = super.getProcessorInterface(interfaceClassName);
        }
        return returnValue;
    }

    @SASScope
    protected class UserGroupDetailsProcessor
    extends DetailsProcessor {
        public UserGroupDetailsProcessor(IdentityGroupInterface publicObject) {
            super(publicObject);
        }

        @Override
        public String getDisplayName() throws ServiceException, RemoteException {
            return ((IdentityGroupInterface)this._publicObject).getEffectiveDisplayName();
        }
    }
}

