/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GridApplicationInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.OMRGridServer;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class OMRGridApplication
extends Metadata
implements GridApplicationInterface {
    public static final String GRIDAPP_REQUIRED_RESOURCES_PROPERTY_NAME = "Grid.Application.Required.Resources";
    public static final String GRIDAPP_GRID_OPTIONS_PROPERTY_NAME = "Grid.Application.Grid.Options";
    public static final String GRIDAPP_SAS_OPTIONS_PROPERTY_NAME = "Grid.Application.SAS.Options";
    public static final String GRIDAPP_USER_MAPPING_NAME = "Grid.Application.User.Mapping";
    public static final String GRIDGOSPUBLICTYPE = "GridOptionsSet";
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRGridApplication() throws RemoteException {
    }

    public OMRGridApplication(Transformation o) throws RemoteException {
        super(o, OMRGridApplication.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGridApplication(TransformationImpl o) throws RemoteException {
        super(o, OMRGridApplication.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGridApplication(TransformationImpl_Stub o) throws RemoteException {
        super(o, OMRGridApplication.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRGridApplication(Transformation o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRGridApplication(TransformationImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRGridApplication(TransformationImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRGridApplication(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRGridApplication(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRGridApplication.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRGridApplication(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        block5: {
            super(theClass);
            if (repos == null || name == null || parent == null) {
                throw new IllegalArgumentException();
            }
            try {
                Transformation transformation = (Transformation)((OMIRepositoryInterface)repos).createMetadata(name, "Transformation");
                transformation.setUsageVersion(CURRENT_VERSION.encode());
                transformation.setPublicType(GRIDGOSPUBLICTYPE);
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = transformation;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    transformation.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return GRIDGOSPUBLICTYPE;
    }

    @Override
    public String getName() {
        Transformation transformation = (Transformation)this._repositoryObject;
        try {
            return transformation.getName();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public List<String> getRequiredResources() throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String propertyValue = this.getPropertyValue(transformation, GRIDAPP_REQUIRED_RESOURCES_PROPERTY_NAME);
        return this.parseStringIntoList(propertyValue, " ");
    }

    @Override
    public void setRequiredResources(List<String> resources) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String value = this.makePropertyValue(resources, " ");
        this.setPropertyValue(transformation, GRIDAPP_REQUIRED_RESOURCES_PROPERTY_NAME, value);
    }

    @Override
    public List<String> getGridOptions() throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String propertyValue = this.getPropertyValue(transformation, GRIDAPP_GRID_OPTIONS_PROPERTY_NAME);
        return this.parseStringIntoList(propertyValue, " ");
    }

    @Override
    public void setGridOptions(List<String> gridOptions) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String value = this.makePropertyValue(gridOptions, " ");
        this.setPropertyValue(transformation, GRIDAPP_GRID_OPTIONS_PROPERTY_NAME, value);
    }

    @Override
    public List<String> getSASOptions() throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String propertyValue = this.getPropertyValue(transformation, GRIDAPP_SAS_OPTIONS_PROPERTY_NAME);
        return this.parseStringIntoList(propertyValue, " ");
    }

    @Override
    public void setSASOptions(List<String> SASOptions) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String value = this.makePropertyValue(SASOptions, " ");
        this.setPropertyValue(transformation, GRIDAPP_SAS_OPTIONS_PROPERTY_NAME, value);
    }

    @Override
    public List<String> getUserMappings() throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String propertyValue = this.getPropertyValue(transformation, GRIDAPP_USER_MAPPING_NAME);
        return this.parseStringIntoList(propertyValue, ";");
    }

    @Override
    public void setUserMappings(List<String> users) throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        String value = this.makePropertyValue(users, ";");
        this.setPropertyValue(transformation, GRIDAPP_USER_MAPPING_NAME, value);
    }

    private String getPropertyValue(Transformation transformation, String propertyName) throws ServiceException, RemoteException {
        try {
            AssociationList properties = transformation.getProperties();
            for (Property property : properties) {
                if (!propertyName.equals(property.getPropertyName())) continue;
                return property.getDefaultValue();
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return "";
    }

    private void setPropertyValue(Transformation transformation, String propertyName, String propertyValue) throws ServiceException, RemoteException {
        try {
            AssociationList properties = transformation.getProperties();
            for (Property property : properties) {
                if (!propertyName.equals(property.getPropertyName())) continue;
                property.setDefaultValue(propertyValue);
                return;
            }
            MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
            MdFactory factory = store.getFactory();
            Property newProperty = (Property)factory.createComplexMetadataObject(store, null, propertyName + ".xmlKey.txt", "Property", transformation.getRepositoryID());
            newProperty.setPropertyName(propertyName);
            newProperty.setDefaultValue(propertyValue);
            transformation.getProperties().add((Object)newProperty);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private List<String> parseStringIntoList(String propertyValue, String delimiter) {
        if (propertyValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(propertyValue, delimiter);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            result.add(nextToken);
        }
        return result;
    }

    private String makePropertyValue(List<String> valueList, String delimiter) {
        if (valueList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String nextValue : valueList) {
            if (!isFirst) {
                sb.append(delimiter);
            }
            sb.append(nextValue);
            isFirst = false;
        }
        return sb.toString();
    }

    public void validateGridOptionsSet() throws RemoteException, MdException {
        Transformation transformation = (Transformation)this._repositoryObject;
        AssociationList identityList = transformation.getTransformationSources();
        for (Property p : identityList) {
            PropertySet ps;
            if (p == null || (ps = p.getAssociatedPropertySet()) != null) continue;
            identityList.remove((Object)p);
        }
    }

    @Override
    public List<ServerComponent> getGOSRelatedServers() throws RemoteException, MdException {
        ArrayList<ServerComponent> serverList = new ArrayList<ServerComponent>();
        Transformation transformation = (Transformation)this._repositoryObject;
        AssociationList iList = transformation.getTransformationSources();
        for (Property p : iList) {
            ServerComponent s;
            AssociationList aList;
            PropertySet ps;
            if (p == null || (ps = p.getAssociatedPropertySet()) == null || (aList = ps.getOwningObjects()) == null || aList.size() <= 0 || aList.get(0) == null || serverList.contains(s = (ServerComponent)aList.get(0))) continue;
            serverList.add(s);
        }
        return serverList;
    }

    @Override
    public List<HashMap<String, String>> getGOSRelatedObjects() throws RemoteException, MdException, ServiceException {
        ArrayList objectList = new ArrayList();
        ArrayList<HashMap<String, String>> serverBasedList = new ArrayList<HashMap<String, String>>();
        ArrayList<String> serverList = new ArrayList<String>();
        Transformation transformation = (Transformation)this._repositoryObject;
        AssociationList iList = transformation.getTransformationSources();
        Iterator iterator2 = iList.iterator();
        while (iterator2.hasNext()) {
            PropertySet ps;
            HashMap<String, String> objMap = new HashMap<String, String>();
            Property p = (Property)iterator2.next();
            if (p != null && (ps = p.getAssociatedPropertySet()) != null) {
                objMap.put("SASAPPLICATION", ps.getId() + "_" + ps.getName());
                AssociationList aList = ps.getOwningObjects();
                if (aList != null && aList.size() > 0 && aList.get(0) != null) {
                    LogicalServer ls;
                    AssociationList sxList;
                    ServerComponent s = (ServerComponent)aList.get(0);
                    OMRGridServer gridServer = new OMRGridServer(s);
                    List<String> userList = gridServer.getUserMappings(ps.getName(), transformation.getName());
                    String users = this.makePropertyValue(userList, ";");
                    objMap.put("IDENTITYLIST", users);
                    AssociationList lsList = s.getUsedByComponents();
                    if (lsList != null && lsList.size() > 0 && (sxList = (ls = (LogicalServer)lsList.get(0)).getUsedByComponents()) != null && sxList.size() > 0) {
                        ServerContext sx = (ServerContext)sxList.get(0);
                        objMap.put("GRIDSERVER", sx.getId() + "_" + sx.getName());
                        if (serverList.contains(sx.getName())) {
                            serverList.add(sx.getName());
                        }
                    }
                }
            }
            objectList.add(objMap);
        }
        for (String string : serverList) {
        }
        return serverBasedList;
    }
}

