/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.impl.ExtensionImpl;
import com.sas.metadata.remote.impl.ExtensionImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ExtensionInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRExtension
extends Metadata
implements ExtensionInterface {
    private static final long serialVersionUID = -8847088254369559693L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRExtension() throws RemoteException {
        super(OMRExtension.class);
    }

    public OMRExtension(Extension o) throws RemoteException {
        super(o, OMRExtension.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExtension(ExtensionImpl o) throws RemoteException {
        super(o, OMRExtension.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExtension(ExtensionImpl_Stub o) throws RemoteException {
        super(o, OMRExtension.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExtension(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRExtension.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                Extension extension = (Extension)omirepository.createMetadata(name, "Extension");
                extension.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = extension;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    extension.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Exception e) {
                this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", e);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Extension";
    }

    @Override
    public String getValue() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Extension ext = (Extension)this._repositoryObject;
            return ext.getValue();
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            return null;
        }
    }

    @Override
    public void setValue(String value) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Extension ext = (Extension)this._repositoryObject;
            ext.setValue(value);
            return;
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            return;
        }
    }

    @Override
    public String getValueType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Extension ext = (Extension)this._repositoryObject;
            return ext.getExtensionType();
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            return null;
        }
    }

    @Override
    public void setValueType(String type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Extension ext = (Extension)this._repositoryObject;
            ext.setExtensionType(type);
            return;
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            return;
        }
    }
}

