/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerSubPropsHandler;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;

public class OMRDatabaseServer
extends OMRServerComponent {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRDatabaseServer() throws RemoteException {
    }

    public OMRDatabaseServer(ServerComponent o) throws RemoteException {
        this(o, OMRDatabaseServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDatabaseServer(ServerComponentImpl o) throws RemoteException {
        this(o, OMRDatabaseServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDatabaseServer(ServerComponentImpl_Stub o) throws RemoteException {
        this(o, OMRDatabaseServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDatabaseServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRDatabaseServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDatabaseServer(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRDatabaseServer(ServerComponent o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRDatabaseServer(ServerComponentImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRDatabaseServer(ServerComponentImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRDatabaseServer(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        super(repos, name, parent, theClass);
    }

    @Override
    public PropertyList getSubstitutionProperties() {
        try {
            PropertyList srvProperties = new PropertyList();
            srvProperties = super.getSubstitutionProperties();
            if (this.getTypeDescriptor() != null) {
                String serverName = this.getName();
                List _lstCon = this.getSourceConnections();
                if (_lstCon != null && _lstCon.size() > 0) {
                    for (int i = 0; i < _lstCon.size(); ++i) {
                        ConnectionInterface con = (ConnectionInterface)_lstCon.get(i);
                        List<MetadataInterface> lstProp = con.getProperties();
                        if (lstProp == null || lstProp.size() <= 0) continue;
                        for (int j = 0; j < lstProp.size(); ++j) {
                            String path;
                            PropertyInterface prop = (PropertyInterface)lstProp.get(j);
                            String propertyName = prop.getKey();
                            String consrc = ServerSubPropsHandler.getConnectionStrPropertyName(this.getType());
                            if (consrc != null && consrc.equalsIgnoreCase(propertyName)) {
                                if (_lstCon.size() > 1) {
                                    String contextValue = con.getName() + ":" + serverName;
                                    srvProperties.addBlankLine();
                                    srvProperties.addProperty("ConnectionString[" + (i + 1) + "]", prop.getValue());
                                    srvProperties.addComment(RB.getStringResource("OMRServerComponent.connectionPropertiesWarning1.txt"));
                                    srvProperties.addComment(RB.getStringResource("OMRServerComponent.connectionPropertiesWarning2.txt"));
                                    srvProperties.addComment(RB.getStringResource("OMRServerComponent.connectionPropertiesWarning3.txt"));
                                    srvProperties.addProperty("ConnectionString." + con.getType() + "[" + (i + 1) + "]", contextValue);
                                } else {
                                    srvProperties.addBlankLine();
                                    srvProperties.addProperty("ConnectionString", prop.getValue());
                                }
                            }
                            if ((path = ServerSubPropsHandler.getPathPropertyName(this.getType())) == null || !path.equalsIgnoreCase(propertyName)) continue;
                            if (_lstCon.size() > 1) {
                                String contextValue = con.getName() + ":" + serverName;
                                srvProperties.addBlankLine();
                                srvProperties.addProperty("DirPath[" + (i + 1) + "]", prop.getValue());
                                srvProperties.addComment(RB.getStringResource("OMRServerComponent.DirPathPropertiesWarning1.txt"));
                                srvProperties.addComment(RB.getStringResource("OMRServerComponent.DirPathPropertiesWarning2.txt"));
                                srvProperties.addComment(RB.getStringResource("OMRServerComponent.DirPathPropertiesWarning3.txt"));
                                srvProperties.addProperty("DirPath." + con.getType() + "[" + (i + 1) + "]", contextValue);
                                continue;
                            }
                            srvProperties.addBlankLine();
                            srvProperties.addProperty("DirPath", prop.getValue());
                        }
                    }
                }
            }
            return srvProperties;
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
    }

    @Override
    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            List _lstCon;
            super.setSubstitutionProperties(map);
            if (this.getTypeDescriptor() != null && (_lstCon = this.getSourceConnections()) != null && _lstCon.size() > 0) {
                for (int i = 0; i < _lstCon.size(); ++i) {
                    String PropName;
                    ConnectionInterface objCon = (ConnectionInterface)_lstCon.get(i);
                    String connectionString = null;
                    String path = null;
                    if (_lstCon.size() == 1) {
                        connectionString = map.getProperty("ConnectionString");
                        path = map.getProperty("DirPath");
                    } else {
                        connectionString = map.getProperty("ConnectionString", i + 1);
                        path = map.getProperty("DirPath", i + 1);
                    }
                    if (connectionString != null) {
                        PropName = ServerSubPropsHandler.getConnectionStrPropertyName(this.getType());
                        objCon.setProperty(objCon, connectionString, PropName);
                    }
                    if (path == null) continue;
                    PropName = ServerSubPropsHandler.getPathPropertyName(this.getType());
                    objCon.setProperty(objCon, path, PropName);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

