/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.impl.DatabaseSchemaImpl;
import com.sas.metadata.remote.impl.DatabaseSchemaImpl_Stub;
import com.sas.metadata.remote.impl.RelationalSchemaImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DatabaseSchemaInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRRelationalSchema;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRDatabaseSchema
extends OMRRelationalSchema
implements DatabaseSchemaInterface {
    private static final long serialVersionUID = -8251874176500507559L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRDatabaseSchema(Class c) throws RemoteException {
        super(c);
    }

    public OMRDatabaseSchema() throws RemoteException {
    }

    protected OMRDatabaseSchema(DatabaseSchema o, Class c) throws RemoteException {
        super((RelationalSchema)o, c);
    }

    public OMRDatabaseSchema(DatabaseSchema o) throws RemoteException {
        super((RelationalSchema)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDatabaseSchema(DatabaseSchemaImpl o, Class c) throws RemoteException {
        super((RelationalSchemaImpl)o, c);
    }

    public OMRDatabaseSchema(DatabaseSchemaImpl o) throws RemoteException {
        super((RelationalSchemaImpl)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDatabaseSchema(DatabaseSchemaImpl_Stub o, Class c) throws RemoteException {
        super((RelationalSchema)o, c);
    }

    public OMRDatabaseSchema(DatabaseSchemaImpl_Stub o) throws RemoteException {
        super((RelationalSchema)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDatabaseSchema(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRDatabaseSchema.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                DatabaseSchema relationalSchema = (DatabaseSchema)omirepository.createMetadata(name, "DatabaseSchema");
                relationalSchema.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = relationalSchema;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    relationalSchema.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRRelationalSchema", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "DatabaseSchema";
    }

    @Override
    public String getSchemaName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DatabaseSchema ds = (DatabaseSchema)this._repositoryObject;
        return ds.getSchemaName();
    }
}

