/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.impl.RoleImpl;
import com.sas.metadata.remote.impl.RoleImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.DataTableRoleInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRDataTableRole
extends Metadata
implements DataTableRoleInterface {
    private static final long serialVersionUID = -758735803691156222L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRDataTableRole() throws RemoteException {
        super(OMRDataTableRole.class);
    }

    public OMRDataTableRole(Role o) throws RemoteException {
        super(o, OMRDataTableRole.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDataTableRole(RoleImpl o) throws RemoteException {
        super(o, OMRDataTableRole.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDataTableRole(RoleImpl_Stub o) throws RemoteException {
        super(o, OMRDataTableRole.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDataTableRole(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRDataTableRole.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Role role = (Role)omirepository.createMetadata(name, "Role");
                role.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = role;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    role.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDatabaseCatalog", t);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "DatabaseCatalog";
    }

    @Override
    public String getContext() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Role role = (Role)this._repositoryObject;
        return role.getContext();
    }

    @Override
    public String getObjectRole() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Role role = (Role)this._repositoryObject;
        return role.getObjectRole();
    }

    @Override
    public DataTableInterface getRoleObject() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DataTableInterface result = null;
        try {
            Role role = (Role)this._repositoryObject;
            DataTable dt = role.getRoleObject();
            result = (DataTableInterface)this._repository.factoryProcess(dt);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public void setContext(String context) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Role role = (Role)this._repositoryObject;
        role.setContext(context);
    }

    @Override
    public void setObjectRole(String role) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Role mrole = (Role)this._repositoryObject;
        mrole.setObjectRole(role);
    }
}

