/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Email;
import com.sas.metadata.remote.ITContentSubscriber;
import com.sas.metadata.remote.ITFilter;
import com.sas.metadata.remote.ITSubscriber;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.impl.ITContentSubscriberImpl;
import com.sas.metadata.remote.impl.ITContentSubscriberImpl_Stub;
import com.sas.metadata.remote.impl.ITSubscriberImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ContentSubscriberFilter;
import com.sas.services.information.metadata.ContentSubscriberInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRSubscriber;
import com.sas.services.information.metadata.RB;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class OMRContentSubscriber
extends OMRSubscriber
implements ContentSubscriberInterface {
    private static final long serialVersionUID = 3329204133272152413L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final String FILTER_EXCLUSION_ENTRY = "entryexclusionfilter";
    public static final String FILTER_INCLUSION_ENTRY = "entryinclusionfilter";
    public static final String FILTER_EXCLUSION_FILEMIMETYPE = "filemimetypeexclusionfilter";
    public static final String FILTER_INCLUSION_FILEMIMETYPE = "filemimetypeinclusionfilter";
    public static final String FILTER_EXCLUSION_NAMEVALUE = "namevalueexclusionfilter";
    public static final String FILTER_INCLUSION_NAMEVALUE = "namevalueinclusionfilter";
    private static final int FILTER_DESC_LENGTH = 10;

    public OMRContentSubscriber() throws RemoteException {
        super(OMRContentSubscriber.class);
    }

    public OMRContentSubscriber(ITContentSubscriber o) throws RemoteException {
        super((ITSubscriber)o, OMRContentSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRContentSubscriber(ITContentSubscriberImpl o) throws RemoteException {
        super((ITSubscriberImpl)o, OMRContentSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRContentSubscriber(ITContentSubscriberImpl_Stub o) throws RemoteException {
        super((ITSubscriber)o, OMRContentSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMRContentSubscriber(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block21: {
            super(OMRContentSubscriber.class);
            if (repos == null || name == null || parent == null) {
                throw new IllegalArgumentException();
            }
            ITContentSubscriber subscriber = null;
            ServiceException exception = null;
            boolean isOK = false;
            try {
                subscriber = (ITContentSubscriber)((OMIRepositoryInterface)repos).createMetadata(name, "ITContentSubscriber");
                subscriber.setPublicType("ContentSubscriber");
                subscriber.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = subscriber;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                parent.addItem(this);
                isOK = true;
            }
            catch (ServiceException e) {
                exception = e;
                return exception;
            }
            finally {
                if (isOK) break block21;
                try {
                    if (subscriber != null) {
                        subscriber.delete();
                    }
                }
                catch (RemoteException remoteException) {
                    if (exception != null) {
                        throw new IllegalArgumentException((Throwable)((Object)exception));
                    }
                }
                finally {
                    if (exception == null) break block21;
                    throw new IllegalArgumentException((Throwable)((Object)exception));
                }
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "ContentSubscriber";
    }

    @Override
    public String getMail() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (this._repositoryFlag == 0) {
            return null;
        }
        String emailAddress = null;
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            Email email = sub.getSubscriberEmail();
            if (email != null) {
                emailAddress = email.getAddress();
            }
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
        return emailAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMail(String mail) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (this._repositoryFlag == 0) {
            return;
        }
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        Object exception = null;
        try {
            Email email = sub.getSubscriberEmail();
            if (email == null) {
                this.newEmail(sub, this.getName(), mail);
            } else if (mail != null) {
                email.setAddress(mail);
                if (!Strings.equal((String)"Subscriber", (String)email.getEmailType(), (boolean)false, (boolean)false)) {
                    email.setEmailType("Subscriber");
                }
            }
        }
        catch (ServiceException e) {
            exception = e;
        }
        catch (MdException e) {
            exception = e;
        }
        finally {
            UserContextInterface uc;
            if (exception != null && (uc = this._repository.getUserContext()) != null) {
                Logger logger = LogManager.getLogger((String)"com.sas.services.information.metadata.OMRContentSubscriber");
                logger.warn(RB.getStringResource("Metadata.accessexcept.msg.txt"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Email newEmail(ITContentSubscriber subscriber, String emailName, String emailAddress) throws ServiceException {
        Email email;
        block8: {
            email = null;
            Throwable exception = null;
            try {
                email = (Email)((OMIRepositoryInterface)this._repository).createMetadata(emailName + "_email", "Email");
                email.setAddress(emailAddress);
                email.setEmailType("Subscriber");
                AssociationList subscribedEmails = subscriber.getSubscriberEmails();
                if (!subscribedEmails.contains(email)) {
                    subscribedEmails.add(email);
                }
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block8;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"OMRContentSubscriber.newEmail.ex.fmt.txt", (Object)emailAddress, (Object)emailName));
            }
        }
        return email;
    }

    @Override
    public String getEmailFormat() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            return sub.getEmailFormat();
        }
        catch (RemoteException ex) {
            this.logWarning(ex);
            return null;
        }
    }

    @Override
    public void setEmailFormat(String emailFormat) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            sub.setEmailFormat(emailFormat);
        }
        catch (RemoteException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public String getArchiveReceiveBy() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        return sub.getArchiveReceiveBy();
    }

    @Override
    public void setArchiveReceiveBy(String receiveBy) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        sub.setArchiveReceiveBy(receiveBy);
    }

    @Override
    public List nameValueInclusionFilters() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            Iterator e = al.iterator();
            ArrayList<String> list = new ArrayList<String>(al.size());
            while (e.hasNext()) {
                ITFilter f = (ITFilter)e.next();
                if (!f.getFilterRole().equalsIgnoreCase(FILTER_INCLUSION_NAMEVALUE)) continue;
                list.add(f.getFilterString());
            }
            return list;
        }
        catch (MdException ex) {
            this.logWarning(ex);
            return null;
        }
    }

    @Override
    public void addNameValueInclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            MdObjectStore store = (MdObjectStore)sub.getObjectStore();
            MdFactory factory = store.getFactory();
            String filterName = OMRContentSubscriber.getFilterName(this.getName(), filter, "nvincfilter");
            ITFilter f = (ITFilter)factory.createComplexMetadataObject(store, null, filterName, "ITFilter", sub.getRepositoryID());
            f.setFilterRole(FILTER_INCLUSION_NAMEVALUE);
            f.setFilterString(filter);
            al.add(f);
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public void removeNameValueInclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.removeSubscriberFilter(filter, FILTER_INCLUSION_NAMEVALUE);
    }

    @Override
    public List nameValueExclusionFilters() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            Iterator e = al.iterator();
            ArrayList<String> list = new ArrayList<String>(al.size());
            while (e.hasNext()) {
                ITFilter f = (ITFilter)e.next();
                if (!f.getFilterRole().equalsIgnoreCase(FILTER_EXCLUSION_NAMEVALUE)) continue;
                list.add(f.getFilterString());
            }
            return list;
        }
        catch (MdException ex) {
            this.logWarning(ex);
            return null;
        }
    }

    @Override
    public void addNameValueExclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            MdObjectStore store = (MdObjectStore)sub.getObjectStore();
            MdFactory factory = store.getFactory();
            String filterName = OMRContentSubscriber.getFilterName(this.getName(), filter, "nvexcfilter");
            ITFilter f = (ITFilter)factory.createComplexMetadataObject(store, null, filterName, "ITFilter", sub.getRepositoryID());
            f.setFilterRole(FILTER_EXCLUSION_NAMEVALUE);
            f.setFilterString(filter);
            al.add(f);
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public void removeNameValueExclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.removeSubscriberFilter(filter, FILTER_EXCLUSION_NAMEVALUE);
    }

    @Override
    public List entryExclusionFilters() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            Iterator e = al.iterator();
            ArrayList<String> list = new ArrayList<String>(al.size());
            while (e.hasNext()) {
                ITFilter f = (ITFilter)e.next();
                if (!f.getFilterRole().equalsIgnoreCase(FILTER_EXCLUSION_ENTRY)) continue;
                list.add(f.getFilterString());
            }
            return list;
        }
        catch (MdException ex) {
            this.logWarning(ex);
            return null;
        }
    }

    @Override
    public void addEntryExclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            MdObjectStore store = (MdObjectStore)sub.getObjectStore();
            MdFactory factory = store.getFactory();
            String filterName = OMRContentSubscriber.getFilterName(this.getName(), filter, "entexcfilter");
            ITFilter f = (ITFilter)factory.createComplexMetadataObject(store, null, filterName, "ITFilter", sub.getRepositoryID());
            f.setFilterRole(FILTER_EXCLUSION_ENTRY);
            f.setFilterString(filter);
            al.add(f);
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public void removeEntryExclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.removeSubscriberFilter(filter, FILTER_EXCLUSION_ENTRY);
    }

    @Override
    public List entryInclusionFilters() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            Iterator e = al.iterator();
            ArrayList<String> list = new ArrayList<String>(al.size());
            while (e.hasNext()) {
                ITFilter f = (ITFilter)e.next();
                if (!f.getFilterRole().equalsIgnoreCase(FILTER_INCLUSION_ENTRY)) continue;
                list.add(f.getFilterString());
            }
            return list;
        }
        catch (MdException ex) {
            this.logWarning(ex);
            return null;
        }
    }

    @Override
    public void addEntryInclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            MdObjectStore store = (MdObjectStore)sub.getObjectStore();
            MdFactory factory = store.getFactory();
            String filterName = OMRContentSubscriber.getFilterName(this.getName(), filter, "entincfilter");
            ITFilter f = (ITFilter)factory.createComplexMetadataObject(store, null, filterName, "ITFilter", sub.getRepositoryID());
            f.setFilterRole(FILTER_INCLUSION_ENTRY);
            f.setFilterString(filter);
            al.add(f);
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public void removeEntryInclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.removeSubscriberFilter(filter, FILTER_INCLUSION_ENTRY);
    }

    @Override
    public List fileMimeTypeExclusionFilters() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            Iterator e = al.iterator();
            ArrayList<String> list = new ArrayList<String>(al.size());
            while (e.hasNext()) {
                ITFilter f = (ITFilter)e.next();
                if (!f.getFilterRole().equalsIgnoreCase(FILTER_EXCLUSION_FILEMIMETYPE)) continue;
                list.add(f.getFilterString());
            }
            return list;
        }
        catch (MdException ex) {
            this.logWarning(ex);
            return null;
        }
    }

    @Override
    public void addFileMimeTypeExclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            MdObjectStore store = (MdObjectStore)sub.getObjectStore();
            MdFactory factory = store.getFactory();
            String filterName = OMRContentSubscriber.getFilterName(this.getName(), filter, "fmtexcfilter");
            ITFilter f = (ITFilter)factory.createComplexMetadataObject(store, null, filterName, "ITFilter", sub.getRepositoryID());
            f.setFilterRole(FILTER_EXCLUSION_FILEMIMETYPE);
            f.setFilterString(filter);
            al.add(f);
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public void removeFileMimeTypeExclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.removeSubscriberFilter(filter, FILTER_EXCLUSION_FILEMIMETYPE);
    }

    @Override
    public List fileMimeTypeInclusionFilters() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            Iterator e = al.iterator();
            ArrayList<String> list = new ArrayList<String>(al.size());
            while (e.hasNext()) {
                ITFilter f = (ITFilter)e.next();
                if (!f.getFilterRole().equalsIgnoreCase(FILTER_INCLUSION_FILEMIMETYPE)) continue;
                list.add(f.getFilterString());
            }
            return list;
        }
        catch (MdException ex) {
            this.logWarning(ex);
            return null;
        }
    }

    @Override
    public void addFileMimeTypeInclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            AssociationList al = sub.getFilters();
            MdObjectStore store = (MdObjectStore)sub.getObjectStore();
            MdFactory factory = store.getFactory();
            String filterName = OMRContentSubscriber.getFilterName(this.getName(), filter, "fmtincfilter");
            ITFilter f = (ITFilter)factory.createComplexMetadataObject(store, null, filterName, "ITFilter", sub.getRepositoryID());
            f.setFilterRole(FILTER_INCLUSION_FILEMIMETYPE);
            f.setFilterString(filter);
            al.add(f);
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public void removeFileMimeTypeInclusionFilter(String filter) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.removeSubscriberFilter(filter, FILTER_INCLUSION_FILEMIMETYPE);
    }

    @Override
    public String getDavUrlType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String result = "parent";
        ITSubscriber sub = (ITSubscriber)this._repositoryObject;
        try {
            AssociationList ass = sub.getProperties();
            for (Property prop : ass) {
                String name = prop.getPropertyName();
                if (name == null) {
                    name = prop.getName();
                }
                if (!name.equalsIgnoreCase("DavURLType")) continue;
                return prop.getDefaultValue();
            }
        }
        catch (Exception ex) {
            this.logWarning(ex);
        }
        return result;
    }

    @Override
    public void setDavUrlType(String type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITSubscriber sub = (ITSubscriber)this._repositoryObject;
        try {
            boolean found_property = false;
            AssociationList ass = sub.getProperties();
            for (Property prop : ass) {
                String name = prop.getPropertyName();
                if (name == null) {
                    name = prop.getName();
                }
                if (!name.equalsIgnoreCase("DavURLType")) continue;
                found_property = true;
                prop.setDefaultValue(type);
                return;
            }
            if (!found_property) {
                MdObjectStore store = (MdObjectStore)sub.getObjectStore();
                MdFactory factory = store.getFactory();
                Property prop = (Property)factory.createComplexMetadataObject(store, null, "DavURLType", "Property", sub.getRepositoryID());
                prop.setName("DavURLType");
                prop.setPropertyName("DavURLType");
                prop.setDefaultValue(type);
                PropertyType propType = (PropertyType)factory.createComplexMetadataObject(store, null, "StringType", "PropertyType", sub.getRepositoryID());
                propType.setSQLType(12);
                prop.setOwningType(propType);
                ass.add(prop);
            }
        }
        catch (Exception ex) {
            this.logWarning(ex);
        }
    }

    private static final String getFilterName(String subscriberName, String filter, String filterRoleDescriptor) {
        String filterName = null;
        if (filter != null && filterRoleDescriptor != null) {
            int endIndex = Math.min(filter.length(), 10);
            String filterSubstring = filter.substring(0, endIndex);
            filterName = Message.format((String)"{0}-{1}-{2}", (Object)subscriberName, (Object)filterRoleDescriptor, (Object)filterSubstring);
        } else {
            filterName = Message.format((String)"{0}-{1}", (Object)subscriberName, (Object)filterRoleDescriptor);
        }
        return filterName;
    }

    private final void removeSubscriberFilter(String filter, String theFilterRole) throws RemoteException {
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            ArrayList al = new ArrayList(sub.getFilters());
            Iterator filterIt = al.iterator();
            String filterString = null;
            String filterRole = null;
            boolean isTrimWhitespace = true;
            boolean isIgnoreCase = true;
            while (filterIt.hasNext()) {
                ITFilter f = (ITFilter)filterIt.next();
                filterString = f.getFilterString();
                filterRole = f.getFilterRole();
                if (!Strings.equal((String)filter, (String)filterString, (boolean)true, (boolean)false) || !Strings.equal((String)theFilterRole, (String)filterRole, (boolean)true, (boolean)true)) continue;
                f.delete();
                break;
            }
        }
        catch (MdException ex) {
            this.logWarning(ex);
        }
    }

    @Override
    public final void removeFilters() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ITContentSubscriber sub = (ITContentSubscriber)this._repositoryObject;
        try {
            Iterator filterIt = new ArrayList(sub.getFilters()).iterator();
            ITFilter filter = null;
            while (filterIt.hasNext()) {
                filter = (ITFilter)filterIt.next();
                filter.delete();
            }
        }
        catch (MdException ex) {
            this.logWarning(ex);
            throw new ServiceException(ex, RB.getStringResource("OMRContentSubscriber.removeFilters.ex.txt"));
        }
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        super.refresh();
        if (this._repositoryObject instanceof ITContentSubscriber) {
            ITContentSubscriber subscriber = (ITContentSubscriber)this._repositoryObject;
            try {
                subscriber.getSubscriberEmails(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshEmail.ex.txt"));
            }
            try {
                subscriber.getProperties(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshProperties.ex.txt"));
            }
            try {
                subscriber.getContentDestinations(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshContentDestinations.ex.txt"));
            }
            try {
                subscriber.getProfileOwners(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshProfileOwners.ex.txt"));
            }
            try {
                subscriber.getTrees(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshTrees.ex.txt"));
            }
            try {
                subscriber.getFilters(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRContentSubscriber.refreshFilters.ex.txt"));
            }
        }
    }

    @Override
    protected final ServerComponent getServerComponent(List servers) {
        ServerComponent httpServerComponent;
        block3: {
            this.checkPulse(true);
            httpServerComponent = null;
            try {
                if (servers == null || servers.size() <= 0) break block3;
                Object o2 = null;
                ServerComponent serverComponent = null;
                for (Object o2 : servers) {
                    if (!(o2 instanceof ServerComponent) || !Strings.equal((String)"DAC0D7F0-10DA-11D6-8816-AA0004006D06", (String)(serverComponent = (ServerComponent)o2).getClassIdentifier(), (boolean)false, (boolean)false)) continue;
                    httpServerComponent = serverComponent;
                    break;
                }
            }
            catch (RemoteException e) {
                httpServerComponent = null;
            }
        }
        return httpServerComponent;
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ITContentSubscriber subscriber = (ITContentSubscriber)this._repositoryObject;
        try {
            this.deleteEmailAddresses(subscriber);
            Iterator it = new ArrayList(subscriber.getFilters()).iterator();
            while (it.hasNext()) {
                ((ITFilter)it.next()).delete();
            }
        }
        catch (MdException mdex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.retrvErr.msg.txt"), "com.sas.services.information.metadata.OMRContentSubscriber", mdex);
        }
        super.delete();
    }

    private void deleteEmailAddresses(ITContentSubscriber subscriber) throws MdException, RemoteException, ServiceException {
        if (subscriber != null) {
            AssociationList emailAddresses = subscriber.getSubscriberEmails();
            Iterator iter = emailAddresses.iterator();
            Email email = null;
            AssociationList emailSubscribers = null;
            boolean isDeleteEmail = true;
            int numSubscribers = 0;
            Iterator subscribers = null;
            while (iter.hasNext()) {
                email = (Email)iter.next();
                isDeleteEmail = true;
                emailSubscribers = email.getEmailSubscriber();
                numSubscribers = emailSubscribers.size();
                if (numSubscribers > 1) {
                    subscribers = emailSubscribers.iterator();
                    ITSubscriber itSubscriber = null;
                    while (subscribers.hasNext()) {
                        itSubscriber = (ITSubscriber)subscribers.next();
                        if (subscriber.equals((Object)itSubscriber)) continue;
                        isDeleteEmail = false;
                        break;
                    }
                }
                if (!isDeleteEmail || email.getPersons().size() != 0) continue;
                iter.remove();
                email.delete();
            }
        }
    }

    private final void logWarning(Throwable throwable) {
        try {
            UserContextInterface uc = this._repository.getUserContext();
            if (uc != null) {
                Logger logger = LogManager.getLogger((String)"com.sas.services.information.metadata.OMRSubscriber");
                logger.warn(RB.getStringResource("Metadata.accessexcept.msg.txt"), throwable);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    protected Filter createFilter() {
        return new ContentSubscriberFilter();
    }
}

