/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.impl.ConnectionImpl;
import com.sas.metadata.remote.impl.ConnectionImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRConnection
extends Metadata
implements ConnectionInterface {
    private static final long serialVersionUID = -6018511830265964979L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRConnection() throws RemoteException {
        super(OMRConnection.class);
    }

    public OMRConnection(Connection o) throws RemoteException {
        super(o, OMRConnection.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConnection(ConnectionImpl o) throws RemoteException {
        super(o, OMRConnection.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConnection(ConnectionImpl_Stub o) throws RemoteException {
        super(o, OMRConnection.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRConnection(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRConnection.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Connection connection = (Connection)omirepository.createMetadata(name, "Connection");
                connection.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = connection;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    connection.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", t);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Connection";
    }

    @Override
    public String getAuthenticationType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        return conn.getAuthenticationType();
    }

    @Override
    public void setAuthenticationType(String authType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        conn.setAuthenticationType(authType);
    }

    @Override
    public String getCommunicationProtocol() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        return conn.getCommunicationProtocol();
    }

    @Override
    public void setCommunicationProtocol(String commProtocol) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        conn.setCommunicationProtocol(commProtocol);
    }

    @Override
    public String getApplicationProtocol() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        return conn.getApplicationProtocol();
    }

    @Override
    public void setApplicationProtocol(String appProtocol) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        conn.setApplicationProtocol(appProtocol);
    }

    @Override
    public List<MetadataInterface> getProperties() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = null;
        Connection conn = (Connection)this._repositoryObject;
        try {
            AssociationList propList = conn.getProperties();
            if (propList.size() > 0) {
                results = new ArrayList<MetadataInterface>(propList.size());
                Iterator it = propList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    results.add(mi);
                }
            }
            return results;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public String getDomain() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        try {
            AuthenticationDomain domain = conn.getDomain();
            return domain.getName();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setDomain(String domain) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        Filter filter = new Filter("Name", 0, domain);
        filter.setType("AuthenticationDomain");
        RepositoryInterface ri = this._repository;
        List domainList = ri.search(filter);
        if (domainList.size() > 0) {
            MetadataInterface mi = (MetadataInterface)domainList.get(0);
            AuthenticationDomain adomain = (AuthenticationDomain)mi.getRepositoryEntity();
            conn.setDomain(adomain);
        } else {
            AuthenticationDomain adomain = (AuthenticationDomain)((OMIRepositoryInterface)this._repository).createMetadata(domain, "AuthenticationDomain");
            conn.setDomain(adomain);
        }
    }

    @Override
    public ServerInterface getSource() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        try {
            DeployedComponent dc = conn.getSource();
            ServerInterface si = (ServerInterface)this._repository.factoryProcess(dc);
            return si;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setSource(ServerInterface server) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        DeployedComponent dc = (DeployedComponent)server.getRepositoryEntity();
        conn.setSource(dc);
    }

    @Override
    public List getProviders() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList providerList = conn.getProviders();
            if (providerList.size() > 0) {
                results = new ArrayList<MetadataInterface>(providerList.size());
                Iterator it = providerList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    results.add(mi);
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addProvider(ServerInterface provider) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        try {
            AssociationList providerList = conn.getProviders();
            providerList.add((DeployedComponent)provider.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeProvider(ServerInterface provider) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        try {
            AssociationList providerList = conn.getProviders();
            providerList.remove((DeployedComponent)provider.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setProviders(List providers) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        try {
            AssociationList providerList = conn.getProviders();
            providerList.clear();
            for (ServerInterface si : providers) {
                DeployedComponent dc = (DeployedComponent)si.getRepositoryEntity();
                providerList.add(dc);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setProperty(ConnectionInterface objCon, String value, String PropName) throws RemoteException {
        this.checkPulse(true);
        Connection conn = (Connection)this._repositoryObject;
        try {
            AssociationList lstProp = conn.getProperties();
            if (lstProp != null && lstProp.size() > 0) {
                for (int j = 0; j < lstProp.size(); ++j) {
                    Property prop = (Property)lstProp.get(j);
                    if (!prop.getPropertyName().equalsIgnoreCase(PropName)) continue;
                    prop.setDefaultValue(value);
                }
            }
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
    }
}

