/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryClause;
import com.sas.metadata.remote.impl.ColumnImpl;
import com.sas.metadata.remote.impl.ColumnImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IndexInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.QueryClauseInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalKeyInterface;
import com.sas.services.util.Names;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRColumn
extends Metadata
implements ColumnInterface,
LocalizableProperties {
    private static final long serialVersionUID = 5292810071379677233L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final String AGGREGATION = "Aggregation";
    private static final String HIERARCHY_ROLE = "HierarchyRole";

    public OMRColumn() throws RemoteException {
        this(OMRColumn.class);
    }

    protected OMRColumn(Class c) throws RemoteException {
        super(c);
    }

    public OMRColumn(Column o) throws RemoteException {
        this(o, OMRColumn.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRColumn(Column o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRColumn(ColumnImpl o) throws RemoteException {
        this(o, OMRColumn.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRColumn(ColumnImpl o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRColumn(ColumnImpl_Stub o) throws RemoteException {
        this(o, OMRColumn.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRColumn(ColumnImpl_Stub o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRColumn(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRColumn.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Column column = (Column)omirepository.createMetadata(name, "Column");
                column.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                column.setPublicType("Column");
                this._repositoryObject = column;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    column.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (Throwable t) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", t);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Column";
    }

    @Override
    public ColumnAttributes getColumnAttributes() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            return new ColumnAttributes(column.getDesc(), column.getSortOrder(), column.getIsNullable() != 0, column.getIsDiscrete() != 0, column.getSASColumnLength(), column.getSummaryRole(), column.getSASColumnType(), column.getSASColumnName(), column.getSASExtendedColumnType(), column.getSASAttribute(), column.getSASPrecision(), column.getSASScale(), column.getSASExtendedLength(), column.getBeginPosition(), column.getEndPosition(), column.getSASInformat(), column.getSASFormat(), column.getColumnLength(), column.getColumnType(), column.getColumnName(), this.getAggregation(), this.getHierarchyRole());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setColumnAttributes(ColumnAttributes attributes) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            column.setDesc(attributes.getDescription());
            column.setSortOrder(attributes.getSortOrder());
            column.setIsNullable(attributes.isNullable() ? 1 : 0);
            column.setIsDiscrete(attributes.isDiscrete() ? 1 : 0);
            column.setSASColumnLength(attributes.getSasColumnLength());
            column.setSummaryRole(attributes.getSummaryRole());
            column.setSASColumnType(attributes.getSasColumnType());
            column.setSASColumnName(attributes.getSasColumnName());
            column.setSASExtendedColumnType(attributes.getSasExtendedColumnType());
            column.setSASAttribute(attributes.getSasAttribute());
            column.setSASPrecision(attributes.getSasPrecision());
            column.setSASScale(attributes.getSasScale());
            column.setSASExtendedLength(attributes.getSasExtendedLength());
            column.setBeginPosition(attributes.getBeginPosition());
            column.setEndPosition(attributes.getEndPosition());
            column.setSASFormat(attributes.getSasFormat());
            column.setSASInformat(attributes.getSasInformat());
            column.setColumnLength(attributes.getColumnLength());
            column.setColumnType(attributes.getColumnType());
            column.setColumnName(attributes.getColumnName());
            if (attributes.getAggregation() != null && !attributes.getAggregation().isEmpty()) {
                this.setAggregation(attributes.getAggregation());
            }
            if (attributes.getHierarchyRole() != null && !attributes.getHierarchyRole().isEmpty()) {
                this.setHierarchyRole(attributes.getHierarchyRole());
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getQueryClauses() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        Column column = (Column)this.getRepositoryEntity();
        try {
            AssociationList clauses = column.getQueryClauses();
            for (QueryClause qc : clauses) {
                MetadataInterface qci = this._repository.factoryProcess(qc);
                result.add(qci);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void addQueryClause(QueryClauseInterface clause) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            QueryClause qc = (QueryClause)clause.getRepositoryEntity();
            column.getQueryClauses().add((Object)qc);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeQueryClause(QueryClauseInterface clause) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            QueryClause qc = (QueryClause)clause.getRepositoryEntity();
            column.getQueryClauses().remove((Object)qc);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public DataTableInterface getTable() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            DataTable dt = column.getTable();
            DataTableInterface dti = (DataTableInterface)this._repository.factoryProcess(dt);
            return dti;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void setTable(DataTableInterface table) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            DataTable dt = (DataTable)table.getRepositoryEntity();
            column.setTable(dt);
        }
        catch (Exception mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    public PropertyList getLocalizableProperties() {
        if (!this._isCompatible) {
            return null;
        }
        PropertyList list = this.getDefaultLocalizableProperties();
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) {
        if (!this._isCompatible) {
            return;
        }
        this.setDefaultLocalizableProperties(map);
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.checkPulse(true);
        String myName = this.getName();
        if (myName != null && myName.equals(name)) {
            return;
        }
        switch (this._repositoryFlag) {
            case 2: {
                boolean bValidName = Names.validateOMRObjectName(name, false);
                if (!bValidName) {
                    this.logMessage(Level.WARN, "Column \"" + name + "\" may not be a valid metadata name. Allowing to continue");
                }
                CMetadata c = (CMetadata)this._repositoryObject;
                c.setName(name);
                break;
            }
        }
    }

    @Override
    public List<IndexInterface> getOwningIndexes() throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        ArrayList<IndexInterface> listIndex = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            AssociationList alIndex = column.getIndexes();
            listIndex = new ArrayList<IndexInterface>(alIndex.size());
            Iterator iterIndex = alIndex.iterator();
            while (iterIndex.hasNext()) {
                mi = this._repository.factoryProcess(iterIndex.next());
                if (!(mi instanceof IndexInterface)) continue;
                listIndex.add((IndexInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listIndex;
    }

    @Override
    public List<RelationalKeyInterface> getOwningKeys() throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        ArrayList<RelationalKeyInterface> listKeys = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Column column = (Column)this.getRepositoryEntity();
        try {
            AssociationList alKey = column.getKeys();
            listKeys = new ArrayList<RelationalKeyInterface>(alKey.size());
            Iterator iterKeys = alKey.iterator();
            while (iterKeys.hasNext()) {
                mi = this._repository.factoryProcess(iterKeys.next());
                if (!(mi instanceof RelationalKeyInterface)) continue;
                listKeys.add((RelationalKeyInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return listKeys;
    }

    @Override
    public boolean isPartOfAnyIndex() throws ServiceException, RemoteException {
        return this.getOwningIndexes().size() > 0;
    }

    @Override
    public boolean isPartOfAnyKey() throws ServiceException, RemoteException {
        return this.getOwningKeys().size() > 0;
    }

    private String getAggregation() throws ServiceException, RemoteException {
        List objectProperties = this.getObjectProperties();
        for (PropertyInterface property : objectProperties) {
            if (!property.getName().equals(AGGREGATION)) continue;
            return property.getValue();
        }
        return "";
    }

    private void setAggregation(String value) throws ServiceException, RemoteException {
        this.addObjectProperty(AGGREGATION, AGGREGATION, value, "String");
    }

    private String getHierarchyRole() throws ServiceException, RemoteException {
        List objectProperties = this.getObjectProperties();
        for (PropertyInterface property : objectProperties) {
            if (!property.getName().equals(HIERARCHY_ROLE)) continue;
            return property.getValue();
        }
        return "";
    }

    private void setHierarchyRole(String value) throws ServiceException, RemoteException {
        this.addObjectProperty(HIERARCHY_ROLE, HIERARCHY_ROLE, value, "String");
    }
}

