/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.ClassifierImpl;
import com.sas.metadata.remote.impl.ClassifierImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ClassifierInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRClassifier
extends Metadata
implements ClassifierInterface {
    private static final long serialVersionUID = 581539892170676225L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRClassifier(Class c) throws RemoteException {
        super(c);
    }

    public OMRClassifier() throws RemoteException {
        this(OMRClassifier.class);
    }

    protected OMRClassifier(Classifier o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRClassifier(Classifier o) throws RemoteException {
        this(o, OMRClassifier.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRClassifier(ClassifierImpl o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRClassifier(ClassifierImpl o) throws RemoteException {
        this(o, OMRClassifier.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRClassifier(ClassifierImpl_Stub o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRClassifier(ClassifierImpl_Stub o) throws RemoteException {
        this(o, OMRClassifier.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRClassifier(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRClassifier.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Classifier classifier = (Classifier)omirepository.createMetadata(name, "Classifier");
                classifier.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = classifier;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    classifier.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRClassifier", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Classifier";
    }

    @Override
    public List getTargetClassifierMaps() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        Classifier classifier = (Classifier)this.getRepositoryEntity();
        try {
            AssociationList list = classifier.getTargetClassifierMaps();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public List getSourceClassifierMaps() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        Classifier classifier = (Classifier)this.getRepositoryEntity();
        try {
            AssociationList list = classifier.getSourceClassifierMaps();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }
}

