/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AnalyticTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.impl.AnalyticTableImpl;
import com.sas.metadata.remote.impl.AnalyticTableImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.AnalyticTableAttributes;
import com.sas.services.information.metadata.AnalyticTableInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalTableInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRAnalyticTable
extends Metadata
implements AnalyticTableInterface {
    private static final long serialVersionUID = 1953831888502681563L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRAnalyticTable(Class c) throws RemoteException {
        super(c);
    }

    public OMRAnalyticTable() throws RemoteException {
        this(OMRAnalyticTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRAnalyticTable(AnalyticTable o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRAnalyticTable(AnalyticTable o) throws RemoteException {
        this(o, OMRAnalyticTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRAnalyticTable(AnalyticTableImpl o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRAnalyticTable(AnalyticTableImpl o) throws RemoteException {
        this(o, OMRAnalyticTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRAnalyticTable(AnalyticTableImpl_Stub o, Class c) throws RemoteException {
        super(o, c);
    }

    public OMRAnalyticTable(AnalyticTableImpl_Stub o) throws RemoteException {
        this(o, OMRAnalyticTable.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAnalyticTable(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRAnalyticTable.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                AnalyticTable analyticTable = (AnalyticTable)omirepository.createMetadata(name, "AnalyticTable");
                analyticTable.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = analyticTable;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    analyticTable.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRAnalyticTable", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "AnalyticTable";
    }

    @Override
    public AnalyticTableAttributes getAnalyticTableAttributes() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AnalyticTable at = (AnalyticTable)this._repositoryObject;
        boolean useExternalData = at.getUseExternalData() != 0;
        double samplingRate = at.getSamplingRate();
        String segment = at.getSegment();
        String analyticTableRole = at.getAnalyticTableRole();
        String analyticTableType = at.getAnalyticTableType();
        return new AnalyticTableAttributes(useExternalData, samplingRate, segment, analyticTableRole, analyticTableType);
    }

    @Override
    public void setAnalyticTableAttributes(AnalyticTableAttributes attributes) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AnalyticTable at = (AnalyticTable)this._repositoryObject;
        at.setUseExternalData(attributes.isUseExternalData() ? 1 : 0);
        at.setSamplingRate(attributes.getSamplingRate());
        at.setAnalyticTableRole(attributes.getAnalyticTableRole());
        at.setAnalyticTableType(attributes.getAnalyticTableType());
    }

    @Override
    public RelationalTableInterface getTrainingTable() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AnalyticTable at = (AnalyticTable)this._repositoryObject;
        try {
            RelationalTable rt = at.getAnalyticTrainingTable();
            if (rt == null) {
                return null;
            }
            RelationalTableInterface rti = (RelationalTableInterface)this._repository.factoryProcess(rt);
            return rti;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void setTrainingTable(RelationalTableInterface table) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AnalyticTable at = (AnalyticTable)this._repositoryObject;
        if (table == null) {
            at.setAnalyticTrainingTable(null);
        } else {
            RelationalTable rt = (RelationalTable)table.getRepositoryEntity();
            at.setAnalyticTrainingTable(rt);
        }
    }
}

