/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AbstractPrompt;
import com.sas.metadata.remote.AccessControl;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.ExternalIdentity;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.Authorization;
import com.sas.services.information.ChildRepositoryInterface;
import com.sas.services.information.DAVRepository;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.EntityHasChangedException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.InformationService;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.AccessControlEntryInterface;
import com.sas.services.information.metadata.AuthorizationUtil;
import com.sas.services.information.metadata.AuthorizationUtilInterface;
import com.sas.services.information.metadata.DocumentInterface;
import com.sas.services.information.metadata.ExtensionInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.IdFilter;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.OMRAccessControlEntry;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PropertyGroupInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RemarksInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.TextStoreInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.metadata.dav.DAVEntity;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.propertybag.PropertyBag;
import com.sas.services.information.metadata.propertybag.PropertyBagInterface;
import com.sas.services.information.metadata.propertybag.PropertyBagValue;
import com.sas.services.information.publicobject.DetailsProcessor;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.DisplayAdapter;
import com.sas.services.information.publicobject.DisplayProcessorInterface;
import com.sas.services.information.publicobject.ProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.Responsibility;
import com.sas.services.information.publicobject.SecurityAdapter;
import com.sas.services.information.publicobject.SecurityProcessorInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.security.PermissionInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.webdav.DAVConstants;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResourceInterface;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.SharedResourceInterface;
import com.sas.services.webdav.Utils;
import com.sas.services.webdav.XMLUtil;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.UsageVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Metadata
extends UnicastRemoteObject
implements PublicObjectInterface,
MetadataInterface,
Serializable {
    private static final long serialVersionUID = -4548827317552417076L;
    private static final double SecondsInTheSixties = 3.156192E8;
    private static final String EX_MSG_CONNECTIONABORT = "connection abort";
    private static final String EX_MSG_EOFEXCEPTION = "EOFException";
    private static final String EX_MSG_SOCKETEXCEPTION = "SocketException";
    static final long METADATA_TREE_REFRESH_INTERVAL = 0L;
    static long treeRefreshInterval = 0L;
    private static final String METADATA_CONTEXT = "com.sas.services.information.metadata.Metadata";
    private static final String METADATA_DESTROY_CONTEXT = "com.sas.services.information.metadata.Metadata.destroy";
    private static final int ENTITY_KEY_BUFFER_INIT = 64;
    private static final int KEYWORD_LIST_INIT = 4;
    private static final int PATH_LIST_INIT = 4;
    private static final int PATH_BUFFER_INIT = 48;
    private static final int PARENT_LIST_INIT = 4;
    private static final int REMARKS_LIST_INIT = 4;
    private static final int PERMILST_INIT = 8;
    private static final int ACILIST_INIT = 8;
    private static final int EXTENSION_RESULT_INIT = 4;
    private static final int SLEEP_HALF_SECOND = 500;
    private static final int TOSTRING_BUFFER_INIT = 64;
    private static final int HASH_INIT = 17;
    private static final int HASH_FACTOR = 37;
    private static final int KEYWORD_BUFFER_INIT = 32;
    public static final int REPOSITORY_NONE = 0;
    public static final int REPOSITORY_OMR = 2;
    public static final int REPOSITORY_DAV = 3;
    public static final int REPOSITORY_LOMR = 4;
    private static InformationServiceInterface _informationService = null;
    public static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private static final long TREEREFRESH_INTERVAL = 15000L;
    private static final int CHILDRENLIST_INIT = 8;
    private static final int LISTENERLIST_INIT = 8;
    protected static final String OMSOBJ_STRING = "OMSOBJ:";
    protected static final String SLASH = "/";
    protected int _repositoryFlag = 0;
    protected Object _repositoryObject = null;
    protected RepositoryInterface _repository;
    private ArrayList _transactionListeners = new ArrayList(8);
    protected ArrayList _children = new ArrayList(8);
    protected long _treeRefreshTime = 15000L;
    protected long _myRefreshInterval = -1L;
    protected Date _omrCreateDate = null;
    protected Date _omrModifyDate = null;
    protected int _myState = 1;
    protected boolean _isDestroyPending = false;
    protected Map _actionInterfaces = new HashMap(3);
    protected boolean _isCompatible = false;
    protected boolean _isReadCompatible = false;
    private AuthorizationUtil ObjectAuthorization = null;

    public static void setTreeRefresh(long interval) {
        treeRefreshInterval = interval;
    }

    public static long getTreeRefresh() {
        return treeRefreshInterval;
    }

    protected Metadata(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
        this._myRefreshInterval = treeRefreshInterval;
    }

    public Metadata() throws RemoteException {
        this(Metadata.class);
    }

    protected Metadata(Object o, Class theClass) throws RemoteException {
        this(theClass);
        if (o == null) {
            return;
        }
        this._repositoryObject = o;
        this._repositoryFlag = this._repositoryObject instanceof Root ? 2 : (this._repositoryObject instanceof DAVEntityInterface ? 3 : 0);
        this._myState = 2;
    }

    public Metadata(Object o) throws RemoteException {
        this(o, Metadata.class);
    }

    public static InformationServiceInterface getInformationService() throws ServiceException {
        if (_informationService == null) {
            try {
                _informationService = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
            }
            catch (ServiceException t) {
                _informationService = null;
            }
            catch (RemoteException t) {
                _informationService = null;
            }
        }
        if (_informationService == null) {
            throw new ServiceException(RB.getStringResource("Metadata.noinfosrvc.ex.txt"));
        }
        return _informationService;
    }

    public static void clearInformationService() {
        _informationService = null;
    }

    @Override
    public int getState() throws RemoteException {
        return this._myState;
    }

    @Override
    public boolean isDeleted() throws RemoteException {
        return this._myState == 3;
    }

    @Override
    public void setDeleted() throws RemoteException {
        this._myState = 3;
    }

    @Override
    public boolean isDestroyed() throws RemoteException {
        return this._myState == 4;
    }

    @Override
    public void destroy() throws RemoteException {
        if (this.isDestroyed()) {
            return;
        }
        try {
            this.logFormat(Level.DEBUG, METADATA_DESTROY_CONTEXT, RB.getResources(), "Metadata.destroying.fmt.txt", this.toString());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this._myState = 4;
        this._repositoryFlag = 0;
        this._repositoryObject = null;
        this._repository = null;
        if (this._children != null) {
            ArrayList tlist = new ArrayList(this._children);
            for (MetadataInterface mi : tlist) {
                try {
                    mi.rollback();
                }
                catch (ServiceException ex) {
                    mi = null;
                }
            }
            this._children.clear();
            this._children = null;
        }
        if (this._actionInterfaces != null) {
            for (Map.Entry entry : this._actionInterfaces.entrySet()) {
                ProcessorInterface processor = (ProcessorInterface)entry.getValue();
                try {
                    processor.destroy();
                }
                catch (ServiceException serviceException) {}
            }
        }
        this._actionInterfaces.clear();
        this._omrCreateDate = null;
        this._omrModifyDate = null;
        try {
            Metadata.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Override
    public String getLockedBy() throws ServiceException, RemoteException {
        this.checkPulse(false);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root c = (Root)this._repositoryObject;
                return c.getLockedBy();
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getName() throws RemoteException {
        this.checkPulse(false);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                CMetadata c = (CMetadata)this._repositoryObject;
                return c.getName();
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                return d.getName();
            }
        }
        return null;
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.checkPulse(true);
        String myName = this.getName();
        if (myName != null && myName.equals(name)) {
            return;
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                String cmtype = root.getCMetadataType();
                if (InformationService.IDENTITY_TYPES.contains(cmtype)) {
                    Names.validateIdentityName(name, true);
                } else {
                    Names.validateOMRObjectName(name, true);
                }
                if (!name.equalsIgnoreCase(myName)) {
                    try {
                        String type = this.getType();
                        List parentList = this.getParents();
                        for (FolderInterface folder : parentList) {
                            if (!folder.hasDuplicate(name, type)) continue;
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.dupitem.ex.fmt.txt", (Object)name, (Object)type));
                        }
                    }
                    catch (ServiceException ex) {
                        throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
                    }
                }
                CMetadata c = (CMetadata)this._repositoryObject;
                c.setName(name);
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                d.setName(name);
            }
        }
    }

    @Override
    public String getDescription() throws RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                CMetadata c = (CMetadata)this._repositoryObject;
                return c.getDesc();
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                return d.getDescription();
            }
        }
        return null;
    }

    @Override
    public void setDescription(String description) throws RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                CMetadata c = (CMetadata)this._repositoryObject;
                c.setDesc(description);
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                d.setDescription(description);
            }
        }
    }

    @Override
    public String getGUID() throws RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    Root c = (Root)this._repositoryObject;
                    AssociationList extIds = c.getExternalIdentities();
                    for (ExternalIdentity exid : extIds) {
                        String context = exid.getContext();
                        if (!"GUID".equalsIgnoreCase(context)) continue;
                        return exid.getIdentifier();
                    }
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            return this.getGUID();
                        }
                        catch (ServiceException serviceException) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                catch (RemoteException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                return d.getGUID();
            }
        }
        return null;
    }

    @Override
    public void setGUID(String guid) throws RemoteException, IllegalStateException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    ExternalIdentity exid2;
                    OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
                    Root c = (Root)this._repositoryObject;
                    AssociationList extIds = c.getExternalIdentities();
                    for (ExternalIdentity exid2 : extIds) {
                        String context = exid2.getContext();
                        if (!"GUID".equalsIgnoreCase(context)) continue;
                        throw new IllegalStateException(RB.getStringResource("Metadata.gotguid.ex.txt"));
                    }
                    exid2 = (ExternalIdentity)omirepos.createMetadata("guid", "ExternalIdentity");
                    exid2.setContext("GUID");
                    exid2.setIdentifier(guid);
                    exid2.setOwningObject(c);
                    c.touch();
                    exid2.updateMetadataAll();
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, (Throwable)((Object)ex));
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            this.setGUID(guid);
                            return;
                        }
                        catch (ServiceException serviceException) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                d.setGUID(guid);
            }
        }
    }

    @Override
    public String getReposId() throws RemoteException {
        this.checkPulse(false);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return ((Root)this._repositoryObject).getFQID();
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                return d.getReposId();
            }
        }
        return null;
    }

    @Override
    public String getRepositoryName() throws RemoteException {
        this.checkPulse(false);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                String fqid = "A0000001." + ((Root)this._repositoryObject).getRepositoryID();
                UserContextInterface uci = this._repository.getUserContext();
                List servers = uci.getServers();
                for (ServerInterface server : servers) {
                    String reposName = server.getRepositoryName(fqid);
                    if (reposName == null) continue;
                    return reposName;
                }
            }
            case 3: {
                return this._repository.getISName();
            }
        }
        return null;
    }

    @Override
    public String getReposKey() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                CMetadata c = (CMetadata)this._repositoryObject;
                String result = c.getFQID() + '/' + c.getCMetadataType();
                return result;
            }
            case 3: {
                DAVEntity d = (DAVEntity)this._repositoryObject;
                String result = d.getReposId();
                return result;
            }
        }
        return null;
    }

    @Override
    public String getType() throws RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                PrimaryType pt;
                String ptype;
                CMetadata c = (CMetadata)this._repositoryObject;
                if (c instanceof PrimaryType && (ptype = (pt = (PrimaryType)c).getPublicType()) != null && ptype.length() > 0) {
                    return ptype;
                }
                return c.getCMetadataType();
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                return d.getType();
            }
        }
        return null;
    }

    @Override
    public void add() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this._repository.addEntity(this);
    }

    @Override
    public synchronized void update() throws ServiceException, RemoteException {
        try {
            this.checkPulse(false);
        }
        catch (IllegalStateException iaex) {
            return;
        }
        if (this._children.size() > 0) {
            throw new ServiceException(RB.getStringResource("Metadata.outstchild.ex.txt"));
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                ServerInterface server = this._repository.getServer();
                server.flush();
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                try {
                    d.update();
                    break;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (this._isDestroyPending) {
            this.destroy();
        }
    }

    protected void reset() throws ServiceException, RemoteException {
        this._omrCreateDate = null;
        this._omrModifyDate = null;
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        Root root;
        Map assocMap;
        List promptList;
        this.checkPulse(true);
        this.reset();
        this._repository.refreshEntity(this);
        if (this._repositoryFlag == 2 && (promptList = (List)(assocMap = (root = (Root)this._repositoryObject).getAssocs()).get("Prompts")) != null) {
            try {
                root.getPrompts(true);
                promptList = this.getPrompts();
                for (MetadataInterface prompt : promptList) {
                    prompt.refresh();
                }
            }
            catch (MdException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        this.checkPulse(false);
        if (this.isDeleted()) {
            return;
        }
        if (this._repositoryFlag == 0) {
            return;
        }
        if (this._repositoryFlag == 2) {
            if (this.isObjectAlive()) {
                Root root = (Root)this._repositoryObject;
                String publicType = null;
                if (root instanceof PrimaryType) {
                    publicType = ((PrimaryType)root).getPublicType();
                }
                if (publicType == null || publicType.trim().length() == 0) {
                    this.deletePrompts();
                    this.deleteExtensions();
                    this.deleteKeywords();
                    this.deleteProperties();
                }
                this.deleteRootAndACE();
            }
        } else {
            this._repository.deleteEntity(this);
        }
        this._myState = 3;
    }

    private void deleteRootAndACE() throws ServiceException, RemoteException {
        Root root = (Root)this._repositoryObject;
        OMIRepositoryInterface ri = (OMIRepositoryInterface)this._repository;
        try {
            String publicType = null;
            if (root instanceof PrimaryType) {
                publicType = ((PrimaryType)root).getPublicType();
            }
            ArrayList aceList = new ArrayList(8);
            if (publicType == null || publicType.trim().length() == 0) {
                AssociationList aces = root.getAccessControls(true);
                Iterator it = aces.iterator();
                while (it.hasNext()) {
                    aceList.add(it.next());
                }
            }
            this._repository.deleteEntity(this);
            for (AccessControl ac : aceList) {
                if (!(ac instanceof AccessControlEntry)) continue;
                try {
                    AssociationList al = ac.getObjects();
                    AssociationList acts = ac.getAccessControlTemplates(true);
                    if (al.size() != 0 || acts.size() != 0) continue;
                    try {
                        ri.deleteEntity((CMetadata)ac);
                    }
                    catch (ServiceException serviceException) {
                    }
                    catch (RemoteException remoteException) {
                    }
                }
                catch (MdException mdException) {}
            }
        }
        catch (MdException mdex) {
            if (this.isConnectionException(mdex)) {
                try {
                    this._repository.getServer().reconnect();
                    this.deleteRootAndACE();
                    return;
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    private void deletePrompts() throws ServiceException {
        try {
            List promptList = this.getPrompts();
            for (BaseOMRPromptInterface prompt : promptList) {
                this.removePrompt(prompt);
            }
            for (BaseOMRPromptInterface prompt : promptList) {
                try {
                    prompt.delete();
                }
                catch (ServiceException serviceException) {}
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void deleteExtensions() {
        Root root = (Root)this._repositoryObject;
        OMIRepositoryInterface ri = (OMIRepositoryInterface)this._repository;
        try {
            ArrayList extensions = new ArrayList(root.getExtensions(true));
            for (Extension extension : extensions) {
                ri.deleteEntity((CMetadata)extension);
            }
        }
        catch (RemoteException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (ServiceException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, (Throwable)((Object)ex));
            }
            catch (RemoteException remoteException) {}
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this._repository.getServer().reconnect();
                    this.deleteExtensions();
                    return;
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void deleteKeywords() {
        Root root = (Root)this._repositoryObject;
        OMIRepositoryInterface ri = (OMIRepositoryInterface)this._repository;
        try {
            ArrayList keywords = new ArrayList(root.getKeywords(true));
            for (Keyword keyword : keywords) {
                AssociationList owners = keyword.getObjects();
                if (owners.size() != 1) continue;
                ri.deleteEntity((CMetadata)keyword);
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this._repository.getServer().reconnect();
                    this.deleteKeywords();
                    return;
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (ServiceException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, (Throwable)((Object)ex));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void deleteResponsibleParties() {
        Root root = (Root)this._repositoryObject;
        OMIRepositoryInterface ri = (OMIRepositoryInterface)this._repository;
        try {
            ArrayList parties = new ArrayList(root.getResponsibleParties(true));
            for (ResponsibleParty party : parties) {
                AssociationList objAss = party.getObjects();
                if (objAss.size() > 1) continue;
                ri.deleteEntity((CMetadata)party);
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this._repository.getServer().reconnect();
                    this.deleteResponsibleParties();
                    return;
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (ServiceException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, (Throwable)((Object)ex));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void deleteProperties() {
        Root root = (Root)this._repositoryObject;
        try {
            ArrayList properties = new ArrayList(root.getProperties(true));
            for (Property prop : properties) {
                this.deleteProperty(prop);
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this._repository.getServer().reconnect();
                    this.deleteProperties();
                    return;
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void deleteProperty(Property prop) {
        try {
            PropertyType type = prop.getOwningType();
            if (this.isOkToDeleteProperty(prop)) {
                prop.getObjectStore().getFactory().deleteMetadataObject((CMetadata)prop);
                if (type != null) {
                    AssociationList owners = type.getTypedProperties();
                    AssociationList groups = type.getGroups();
                    if (owners.size() == 0 && groups.size() == 0) {
                        type.getObjectStore().getFactory().deleteMetadataObject((CMetadata)type);
                    }
                }
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this._repository.getServer().reconnect();
                    this.deleteProperty(prop);
                    return;
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (ServiceException ex) {
            try {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, (Throwable)((Object)ex));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void deleteRootObject(Root object) throws ServiceException, RemoteException {
        if (!object.delete()) {
            this.logMessage(Level.DEBUG, RB.getStringResource("Metadata.delerror.ex.txt"), METADATA_CONTEXT, null);
        }
    }

    @Override
    public final int getTrackingId() throws RemoteException {
        this.checkPulse(true);
        return -1;
    }

    @Override
    public final Object getRepositoryEntity() throws RemoteException {
        this.checkPulse(true);
        return this._repositoryObject;
    }

    @Override
    public String getEntityKey() throws IllegalStateException, ServiceException, RemoteException {
        String reposUrl;
        this.checkPulse(true);
        RepositoryInterface repos = this.getRepository();
        if (repos == null) {
            throw new IllegalStateException();
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.getType());
        buffer.append("+");
        String reposName = repos.getISName();
        if (reposName == null) {
            reposUrl = null;
            String domain = null;
            try {
                reposUrl = repos.getUrl();
                domain = repos.getDomain();
            }
            catch (RemoteException rex) {
                throw new ServiceException(rex, RB.getStringResource("Metadata.geturlerror.ex.txt"));
            }
            try {
                URI uri = new URI(reposUrl);
                reposUrl = "";
                StringBuffer urlBuffer = new StringBuffer(uri.getScheme() + "://" + uri.getAuthority() + (domain != null ? ";domain=" + domain : ""));
                if (uri.getRawPath().length() > 1) {
                    urlBuffer.append(uri.getRawPath());
                }
                reposUrl = urlBuffer.toString();
            }
            catch (URISyntaxException ex) {
                this.logFormat(Level.WARN, METADATA_CONTEXT, RB.getResources(), "Metadata.badreposurl.fmt.txt", reposUrl);
            }
            buffer.append(reposUrl);
        } else {
            reposUrl = repos.getUrl();
            int index = reposUrl.indexOf(":");
            String protocol = reposUrl.substring(0, index);
            try {
                buffer.append(protocol + "://" + URLEncoder.encode(reposName, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                buffer.append(protocol + "://" + reposName);
            }
        }
        switch (this._repositoryFlag) {
            case 0: {
                throw new IllegalStateException();
            }
            case 2: {
                CMetadata c = (CMetadata)this._repositoryObject;
                buffer.append(SLASH);
                reposName = ((OMIRepositoryInterface)this._repository).getDefaultRepositoryName();
                if (reposName != null) {
                    try {
                        buffer.append("reposname=" + URLEncoder.encode(reposName, "UTF-8") + '/');
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ServiceException(ex, RB.getStringResource("Metadata.geturlerror.ex.txt"));
                    }
                }
                buffer.append(c.getCMetadataType() + ";id=");
                buffer.append(this.getReposId());
                break;
            }
            case 3: {
                int ptr;
                String reposId = this.getReposId();
                buffer.append(SLASH);
                try {
                    URI uri = new URI(null, null, reposId, null);
                    buffer.append(uri.toASCIIString());
                }
                catch (URISyntaxException use) {
                    buffer.append(reposId);
                }
                for (ptr = buffer.length() - 1; ptr > 0 && buffer.charAt(ptr) != '/'; --ptr) {
                    buffer.deleteCharAt(ptr);
                }
                buffer.append(this.getType());
                int initptr = buffer.indexOf("://");
                if (initptr == -1) break;
                while ((ptr = buffer.indexOf("//", initptr + 3)) != -1) {
                    buffer.deleteCharAt(ptr);
                }
                break;
            }
        }
        return buffer.toString();
    }

    @Override
    public String getEntityURL() throws ServiceException, RemoteException {
        this.checkPulse(true);
        RepositoryInterface repos = this.getRepository();
        StringBuffer buffer = new StringBuffer(64);
        if (repos == null) {
            throw new IllegalStateException();
        }
        switch (this._repositoryFlag) {
            case 0: {
                throw new IllegalStateException();
            }
            case 2: {
                CMetadata c = (CMetadata)this._repositoryObject;
                buffer.append("sas-oma://" + this._repository.getHost() + ':' + this._repository.getPort() + "/reposid=" + c.getFQID().substring(0, 8) + '/' + c.getCMetadataType() + ";id=" + c.getFQID());
                return buffer.toString();
            }
            case 3: {
                String reposId = this.getReposId();
                DAVRepositoryInterface dr = (DAVRepositoryInterface)this._repository;
                int p = reposId.lastIndexOf(SLASH);
                reposId = p > 0 ? reposId.substring(0, p) : "";
                String scheme = dr.getHttps() ? "https" : "http";
                String path = Utils.addSegment((String)"", (String)dr.getBase());
                path = Utils.addSegment((String)path, (String)reposId);
                URI uri = null;
                try {
                    uri = new URI(scheme, null, dr.getHost(), dr.getPort(), path, null, null);
                }
                catch (URISyntaxException iuse) {
                    return null;
                }
                return uri.toASCIIString();
            }
        }
        return null;
    }

    @Override
    public PathUrl getPathUrl() throws IllegalStateException, ServiceException, RemoteException {
        return this.getPathUrl(null);
    }

    public PathUrl getPathUrl(String rootTreeName) throws IllegalStateException, ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                throw new IllegalStateException();
            }
            case 2: {
                return this.getOMRPathUrl(rootTreeName);
            }
            case 3: {
                PathUrl result = null;
                String reposName = this._repository.getISName();
                if (reposName != null) {
                    String typeString;
                    int index;
                    String path = this.getReposId();
                    int p = path.lastIndexOf(SLASH);
                    String string = path = p == -1 ? "" : path.substring(0, path.lastIndexOf(47));
                    if (path.length() > 0 && path.charAt(0) == '/') {
                        path = path.substring(path.indexOf(47) + 1);
                    }
                    String rootfolder = "";
                    String name = null;
                    if (path.indexOf(47) > 0) {
                        rootfolder = path.substring(0, path.indexOf(47));
                        path = path.substring(path.indexOf(47) + 1);
                    }
                    if (path.lastIndexOf(47) > 0) {
                        name = path.substring(path.lastIndexOf(47) + 1);
                        path = path.substring(0, path.lastIndexOf(47));
                    }
                    if (path.endsWith(SLASH)) {
                        path = path.substring(0, path.lastIndexOf(47));
                    }
                    if ((index = (typeString = this.getType()).indexOf(46)) > -1) {
                        typeString = typeString.substring(0, index);
                    }
                    result = new PathUrl(reposName, rootfolder, path, name, typeString);
                    result.setUnwritable();
                    return result;
                }
                return null;
            }
        }
        return null;
    }

    private PathUrl getOMRPathUrl(String rootTreeName) throws ServiceException, RemoteException {
        StringBuffer buffer = new StringBuffer(48);
        buffer.append("SBIP://");
        String bipPath = null;
        if (VirtualFolderManager.isContainedByVirtualFolder(this.getType(), (OMIRepositoryInterface)this._repository)) {
            bipPath = VirtualFolderManager.getDefaultPath(this.getType(), (OMIRepositoryInterface)this._repository);
            if (bipPath != null && bipPath.startsWith(SLASH)) {
                bipPath = bipPath.substring(1);
            }
            if (bipPath != null && !bipPath.endsWith(SLASH)) {
                bipPath = bipPath + SLASH;
            }
        } else {
            bipPath = this.getParentPath(rootTreeName);
        }
        if (bipPath == null) {
            this.logMessage(Level.DEBUG, RB.getStringResource("Metadata.notree1.ex.txt"), METADATA_CONTEXT, null);
            return null;
        }
        String reposName = this._repository.getServer().getName();
        if (SLASH.equals(bipPath)) {
            PathUrl result = null;
            result = new PathUrl(reposName, this.getName(), null, null, this.getType());
            result.setUnwritable();
            return result;
        }
        buffer.append(reposName + '/');
        buffer.append(bipPath);
        String typeString = this.getType();
        int index = typeString.indexOf(46);
        if (index > -1) {
            typeString = typeString.substring(0, index);
        }
        buffer.append(this.getName() + '(' + typeString + ')');
        PathUrl result = null;
        result = new PathUrl(buffer.toString());
        result.setUnwritable();
        return result;
    }

    @Override
    public void setRepository(RepositoryInterface repository) throws IllegalStateException, RemoteException {
        this.checkPulse(true);
        if (this._repository != null) {
            if (this._repository != repository) {
                throw new IllegalStateException();
            }
            return;
        }
        this._repository = repository;
        switch (this._repositoryFlag) {
            case 2: {
                OMIRepositoryInterface ori = (OMIRepositoryInterface)this._repository;
                long refresh = ori.getParentRefreshInterval();
                if (refresh > -1L) {
                    this._myRefreshInterval = refresh;
                }
                try {
                    ori.addToCache(this);
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                try {
                    Root root = (Root)this._repositoryObject;
                    Map map = root.getAssocs();
                    AssociationList trees = (AssociationList)map.get("Trees");
                    if (trees != null && trees.size() > 0) {
                        this._treeRefreshTime = System.currentTimeMillis();
                    }
                    MapPool.returnMap((Map)map);
                }
                catch (RemoteException mdex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, mdex);
                }
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    public RepositoryInterface getRepository() throws RemoteException {
        this.checkPulse(false);
        if (this._repository != null) {
            return this._repository;
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                return d.getRepository();
            }
        }
        return null;
    }

    @Override
    public List getKeywords() throws RemoteException {
        this.checkPulse(true);
        ArrayList<String> result = new ArrayList<String>(4);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root c = (Root)this._repositoryObject;
                try {
                    AssociationList ass = c.getKeywords();
                    for (Keyword keyword : ass) {
                        result.add(keyword.getName());
                    }
                    return result;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            return this.getKeywords();
                        }
                        catch (ServiceException it) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                    break;
                }
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                String keywords = d.getAttribute("{http://www.sas.com/rnd/itech/WebDAV}saskeyword");
                if (keywords != null) {
                    StringTokenizer st = new StringTokenizer(keywords, " ");
                    while (st.hasMoreTokens()) {
                        result.add(st.nextToken());
                    }
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public void addKeyword(String keyword) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root c = (Root)this._repositoryObject;
                try {
                    AssociationList keyList = c.getKeywords();
                    Keyword mkeyword = (Keyword)((OMIRepositoryInterface)this._repository).createMetadata(keyword, "Keyword");
                    this.addToList((List)keyList, mkeyword);
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            this.addKeyword(keyword);
                            return;
                        }
                        catch (ServiceException mkeyword) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
            case 3: {
                if (keyword == null) {
                    return;
                }
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                String keywords = d.getAttribute("{http://www.sas.com/rnd/itech/WebDAV}saskeyword");
                if (keywords != null && keywords.indexOf(keyword) != -1) break;
                keywords = keywords == null ? keyword : keywords + ' ' + keyword;
                d.setAttribute("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", keywords);
            }
        }
    }

    @Override
    public void removeKeyword(String keyword) throws RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root c = (Root)this._repositoryObject;
                try {
                    AssociationList keyList = c.getKeywords();
                    for (Keyword key : keyList) {
                        if (!key.getName().equals(keyword)) continue;
                        AssociationList objects = key.getObjects();
                        if (objects.size() > 1) {
                            this.removeFromList((List)keyList, key);
                        } else {
                            this.deleteRootObject((Root)key);
                        }
                        return;
                    }
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            this.removeKeyword(keyword);
                            return;
                        }
                        catch (ServiceException it) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, (Throwable)((Object)ex));
                }
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                String keywords = d.getAttribute("{http://www.sas.com/rnd/itech/WebDAV}saskeyword");
                if (keywords == null || keyword == null) break;
                StringTokenizer st = new StringTokenizer(keywords, " ");
                StringBuffer keywordBuffer = new StringBuffer(32);
                boolean keywordFound = false;
                while (st.hasMoreTokens()) {
                    String currKeyword = st.nextToken();
                    if (!keyword.equals(currKeyword)) {
                        if (keywordBuffer.length() > 0) {
                            keywordBuffer.append(" ");
                        }
                        keywordBuffer.append(currKeyword);
                        continue;
                    }
                    keywordFound = true;
                }
                if (!keywordFound) break;
                d.setAttribute("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", keywordBuffer.toString());
            }
        }
    }

    @Override
    public void setKeywords(List keywords) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root c = (Root)this._repositoryObject;
                OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
                try {
                    AssociationList keyList = c.getKeywords();
                    ArrayList oldList = new ArrayList(c.getKeywords());
                    int oldListSize = oldList.size();
                    for (int i = 0; i < oldListSize; ++i) {
                        Keyword oldKey = (Keyword)oldList.get(i);
                        AssociationList list = oldKey.getObjects();
                        if (list.size() > 1) {
                            this.removeFromList((List)oldKey.getObjects(), c);
                            continue;
                        }
                        this.deleteRootObject((Root)oldKey);
                    }
                    for (String nextKeyword : keywords) {
                        Keyword cKeyword = (Keyword)omirepos.createMetadata(nextKeyword, "Keyword");
                        this.addToList((List)keyList, cKeyword);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            this.setKeywords(keywords);
                            return;
                        }
                        catch (ServiceException oldList) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                    break;
                }
            }
            case 3: {
                Iterator it = keywords.iterator();
                StringBuffer keywordBuffer = new StringBuffer(32);
                while (it.hasNext()) {
                    String nextKeyword = (String)it.next();
                    if (keywordBuffer.length() > 0) {
                        keywordBuffer.append(" ");
                    }
                    keywordBuffer.append(nextKeyword);
                }
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                d.setAttribute("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", keywordBuffer.toString());
            }
        }
    }

    @Override
    public List getObjectProperties() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(4);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root c = (Root)this._repositoryObject;
                try {
                    AssociationList ass = c.getProperties();
                    for (Property property : ass) {
                        MetadataInterface mi = this._repository.factoryProcess(property);
                        result.add(mi);
                    }
                    return result;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            return this.getObjectProperties();
                        }
                        catch (ServiceException serviceException) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                    break;
                }
            }
            case 3: {
                return Collections.EMPTY_LIST;
            }
        }
        return null;
    }

    @Override
    public void addObjectProperty(PropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList propertyList = cm.getProperties();
                    this.addToList((List)propertyList, property.getRepositoryEntity());
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addObjectProperty(property);
                        return;
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
        }
    }

    @Override
    public void addObjectProperty(String name, String propertyName, String value, String type) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    OMRProperty property = new OMRProperty(this._repository, name, propertyName, value, type);
                    AssociationList propertyList = cm.getProperties();
                    this.addToList((List)propertyList, property.getRepositoryEntity());
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            this.addObjectProperty(name, propertyName, value, type);
                            return;
                        }
                        catch (ServiceException serviceException) {
                            // empty catch block
                        }
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removeObjectProperty(PropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                Property jProperty = (Property)property.getRepositoryEntity();
                try {
                    AssociationList propertyList = cm.getProperties();
                    this.removeFromList((List)propertyList, jProperty);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeObjectProperty(property);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void setObjectProperties(List propertyList) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    ArrayList<Property> jprops = new ArrayList<Property>(propertyList.size());
                    for (PropertyInterface pi : propertyList) {
                        Property p = (Property)pi.getRepositoryEntity();
                        jprops.add(p);
                    }
                    AssociationList properties = new ArrayList(cm.getProperties());
                    for (Property prop : properties) {
                        if (jprops.contains(prop)) continue;
                        this.deleteProperty(prop);
                    }
                    properties = cm.getProperties();
                    properties.clear();
                    Iterator it = jprops.iterator();
                    while (it.hasNext()) {
                        this.addToList((List)properties, it.next());
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.setObjectProperties(propertyList);
                        return;
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                    break;
                }
            }
        }
    }

    @Override
    public List getPropertySets() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(4);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root c = (Root)this._repositoryObject;
                try {
                    AssociationList ass = c.getPropertySets();
                    for (PropertySet propertyset : ass) {
                        MetadataInterface mi = this._repository.factoryProcess(propertyset);
                        result.add(mi);
                    }
                    return result;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getPropertySets();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
            case 3: {
                return Collections.EMPTY_LIST;
            }
        }
        return null;
    }

    @Override
    public void addPropertySet(PropertySetInterface propertySet) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList propertyList = cm.getPropertySets();
                    this.addToList((List)propertyList, propertySet.getRepositoryEntity());
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addPropertySet(propertySet);
                        return;
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
        }
    }

    @Override
    public void removePropertySet(PropertySetInterface propertySet) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                PropertySet jPropertySet = (PropertySet)propertySet.getRepositoryEntity();
                try {
                    AssociationList propertyList = cm.getProperties();
                    this.removeFromList((List)propertyList, jPropertySet);
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removePropertySet(propertySet);
                        return;
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
        }
    }

    @Override
    public String getPath(String rootFolderName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: 
            case 2: {
                String path = this.getParentPath(rootFolderName);
                if (path != null) {
                    return path + this.getName();
                }
                return path;
            }
            case 3: {
                String reposId = '/' + this.getReposId();
                String path = reposId.substring(0, reposId.lastIndexOf(47));
                return rootFolderName == null ? path : (path.startsWith(rootFolderName) ? path.substring(rootFolderName.length() + 1) : null);
            }
        }
        return null;
    }

    @Override
    public String getParentPath(String rootFolderName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getOMRParentPath(rootFolderName);
            }
            case 3: {
                String reposId = '/' + this.getReposId();
                String path = reposId.substring(0, reposId.lastIndexOf(47));
                String parentPath = path.substring(0, path.lastIndexOf(47)) + '/';
                return parentPath;
            }
        }
        return null;
    }

    private String getOMRParentPath(String rootFolderName) throws ServiceException, RemoteException {
        this.logFormat(Level.DEBUG, METADATA_CONTEXT, RB.getResources(), "Metadata.lookpath.msg.fmt.txt", rootFolderName);
        Root c = (Root)this._repositoryObject;
        if ((rootFolderName == null || rootFolderName.equals(this.getName())) && this.isRootFolder(c)) {
            return SLASH;
        }
        try {
            StringBuffer path = new StringBuffer(48);
            Iterator it = null;
            if (c instanceof Tree) {
                ArrayList<Tree> al = new ArrayList<Tree>(2);
                Tree parent = ((Tree)c).getParentTree();
                if (parent != null) {
                    al.add(parent);
                }
                it = al.iterator();
            } else {
                AssociationList ass = null;
                if (System.currentTimeMillis() - this._treeRefreshTime > this._myRefreshInterval) {
                    ass = c.getTrees(true);
                    this._treeRefreshTime = System.currentTimeMillis();
                } else {
                    ass = c.getTrees();
                }
                it = ass.iterator();
            }
            while (it.hasNext()) {
                Tree tree;
                path = new StringBuffer(48);
                Tree lastTree = null;
                this.logFormat(Level.DEBUG, METADATA_CONTEXT, RB.getResources(), "Metadata.chkpath.msg.fmt.txt", tree);
                for (tree = (Tree)it.next(); tree != null; tree = tree.getParentTree()) {
                    path = path.insert(0, tree.getName() + '/');
                    this.logFormat(Level.DEBUG, METADATA_CONTEXT, RB.getResources(), "Metadata.setpath.msg.fmt.txt", path.toString());
                    lastTree = tree;
                }
                if (lastTree == null) {
                    this.logFormat(Level.INFO, METADATA_CONTEXT, RB.getResources(), "Metadata.notree2.ex.fmt.txt", c.toString());
                    return "";
                }
                if (!this.isRootFolder((Root)lastTree) || rootFolderName != null && !lastTree.getName().equals(rootFolderName)) continue;
                String result = path.toString();
                if (result == null) {
                    return "";
                }
                return result;
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this._repository.getServer().reconnect();
                return this.getOMRParentPath(rootFolderName);
            }
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
        }
        return null;
    }

    private boolean isRootFolder(Root object) throws ServiceException, RemoteException {
        ServerInterface si = this._repository.getServer();
        RootFolderInterface fi = si.getRootFolder();
        SoftwareComponent scom = (SoftwareComponent)fi.getRepositoryEntity();
        String rootId = scom.getFQID();
        if (!(object instanceof Tree)) {
            return false;
        }
        Tree tree = (Tree)object;
        try {
            if (tree.getParentTree() != null) {
                return false;
            }
            AssociationList list = tree.getSoftwareComponents(true);
            for (SoftwareComponent sc : list) {
                String scid = sc.getFQID();
                if (!scid.equals(rootId)) continue;
                return true;
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (MdException mdException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List getPaths(String rootFolderName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<String> results = new ArrayList<String>(4);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                String path = this.getPath(null);
                if (path == null) break;
                results.add(path);
                break;
            }
            case 3: {
                results.add(this.getReposId());
            }
        }
        return results;
    }

    @Override
    public Object newServiceObject() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public List getParents() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(4);
                Root cm = (Root)this._repositoryObject;
                try {
                    if (this._repositoryObject instanceof Tree) {
                        Tree tree = (Tree)this._repositoryObject;
                        Tree parent = tree.getParentTree();
                        if (parent != null) {
                            MetadataInterface mf = this._repository.factoryProcess(parent);
                            try {
                                Folder parentFolder = (Folder)mf;
                                result.add(parentFolder);
                                return result;
                            }
                            catch (ClassCastException ccex) {
                                this.logFormat(Level.WARN, this.getClass().getName(), RB.getResources(), "Metadata.notfolder.ex.fmt.txt", mf.getName(), mf.getClass().getName());
                            }
                        }
                    } else {
                        AssociationList trees = cm.getTrees();
                        for (CMetadata nextCm : trees) {
                            MetadataInterface mcm = this._repository.factoryProcess(nextCm);
                            result.add(mcm);
                        }
                    }
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getParents();
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                return result;
            }
            case 3: {
                ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
                String s = this.getReposId();
                s = s.substring(0, s.lastIndexOf(SLASH));
                if (s.length() > 0) {
                    if (s.indexOf(SLASH) == -1) {
                        s = SLASH + s;
                    }
                    MetadataInterface mi = this._repository.fetch(s);
                    result.add(mi);
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public FolderInterface getParent() throws ServiceException, RemoteException {
        List parentList = this.getParents();
        if (parentList != null && parentList.size() > 0) {
            return (FolderInterface)parentList.get(0);
        }
        return null;
    }

    private Date makeDateFromString(String dateString) throws ParseException {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        double time = nf.parse(dateString).doubleValue();
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        long javaDate = (long)((time - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
        Date result = new Date(javaDate);
        return result;
    }

    @Override
    public Date getCreateDate() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                if (this._repository == null) {
                    return null;
                }
                String dateString = ((Root)this._repositoryObject).getMetadataCreated();
                if (dateString.length() > 0 && dateString.indexOf(58) == -1) {
                    try {
                        Date returnDate = this.makeDateFromString(dateString);
                        return returnDate;
                    }
                    catch (ParseException returnDate) {
                        // empty catch block
                    }
                }
                if (this._omrCreateDate != null) {
                    return this._omrCreateDate;
                }
                OMIRepositoryInterface repos = (OMIRepositoryInterface)this._repository;
                this._omrCreateDate = repos.getCreateDate(this);
                return this._omrCreateDate;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                String dateString = d.getCreateDate();
                if (dateString == null) {
                    return null;
                }
                SimpleDateFormat[] sdfs = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ")};
                Date date = null;
                sdfs[0].setTimeZone(TimeZone.getTimeZone("UTC"));
                sdfs[2].setTimeZone(TimeZone.getTimeZone("UTC"));
                for (int i = 0; date == null && i < sdfs.length; ++i) {
                    try {
                        date = sdfs[i].parse(dateString);
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (date != null) {
                    return date;
                }
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, null);
            }
        }
        return null;
    }

    @Override
    public String getCreatedBy() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    DetailsProcessorInterface details = (DetailsProcessorInterface)this.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                    if (details != null) {
                        return details.getCreatedBy();
                    }
                    break;
                }
                catch (ServiceException ex) {
                    if (this.isConnectionException((Throwable)((Object)ex))) {
                        this._repository.getServer().reconnect();
                        return this.getCreatedBy();
                    }
                    throw new ServiceException((Throwable)((Object)ex), ex.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getModifyDate() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                if (this._repository == null) {
                    return null;
                }
                String dateString = ((Root)this._repositoryObject).getMetadataUpdated();
                if (dateString.length() > 0 && dateString.indexOf(58) == -1) {
                    try {
                        Date returnDate = this.makeDateFromString(dateString);
                        return returnDate;
                    }
                    catch (ParseException returnDate) {
                        // empty catch block
                    }
                }
                if (this._omrModifyDate != null) {
                    return this._omrModifyDate;
                }
                OMIRepositoryInterface repos = (OMIRepositoryInterface)this._repository;
                this._omrModifyDate = repos.getModifiedDate(this);
                return this._omrModifyDate;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                String dateString = d.getModifyDate();
                if (dateString == null) {
                    return null;
                }
                Date date = null;
                boolean parsedFine = false;
                for (int i = 0; date == null && i < formats.length; ++i) {
                    try {
                        SimpleDateFormat simpleDateFormat = formats[i];
                        synchronized (simpleDateFormat) {
                            date = formats[i].parse(dateString);
                            parsedFine = true;
                            continue;
                        }
                    }
                    catch (ParseException e) {
                        this.logMessage(Level.DEBUG, "ParseException getting modify date.", METADATA_CONTEXT, e);
                    }
                }
                if (parsedFine) {
                    return date;
                }
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, null);
            }
        }
        return null;
    }

    @Override
    public String getModifiedBy() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    DetailsProcessorInterface details = (DetailsProcessorInterface)this.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                    if (details != null) {
                        return details.getModifiedBy();
                    }
                    break;
                }
                catch (ServiceException ex) {
                    if (this.isConnectionException((Throwable)((Object)ex))) {
                        this._repository.getServer().reconnect();
                        return this.getModifiedBy();
                    }
                    throw new ServiceException((Throwable)((Object)ex), ex.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    public List getRemarksList() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList results = new ArrayList(4);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getOMRRemarks();
            }
            case 3: {
                return this.getDAVRemarks();
            }
        }
        return results;
    }

    private List getDAVRemarks() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(4);
        UserContextInterface uc = this._repository.getUserContext();
        InformationServiceInterface _is = Metadata.getInformationService();
        DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
        String[] remarksKeys = d.getRemarksKeys();
        if (uc != null && _is != null) {
            for (int i = 0; i < remarksKeys.length; ++i) {
                MetadataInterface remark = _is.fetchEntityByKey(uc, remarksKeys[i]);
                if (remark == null) continue;
                results.add(remark);
            }
        }
        return results;
    }

    private List getOMRRemarks() throws RemoteException {
        UserContextInterface uc = this._repository.getUserContext();
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(4);
        Root cm = (Root)this._repositoryObject;
        try {
            AssociationList properties = cm.getProperties();
            for (Property nextProperty : properties) {
                String remarkKey;
                MetadataInterface remark;
                if (!"RemarkLocation".equalsIgnoreCase(nextProperty.getPropertyName()) || (remark = _informationService.fetchEntityByKey(uc, remarkKey = nextProperty.getDefaultValue())) == null) continue;
                results.add(remark);
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this._repository.getServer().reconnect();
                    return this.getOMRRemarks();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
        }
        catch (ServiceException ex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, (Throwable)((Object)ex));
        }
        return results;
    }

    @Override
    public void setRemarksList(List remarks) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList properties = cm.getProperties();
                    Iterator propIt = properties.iterator();
                    while (propIt.hasNext()) {
                        Property nextProperty = (Property)propIt.next();
                        if (!"RemarkLocation".equalsIgnoreCase(nextProperty.getPropertyName())) continue;
                        propIt.remove();
                        ((OMIRepositoryInterface)this._repository).deleteEntity((CMetadata)nextProperty);
                    }
                    for (MetadataInterface mi : remarks) {
                        Property newProperty = (Property)((OMIRepositoryInterface)this._repository).createMetadata(mi.getName(), "Property");
                        newProperty.setPropertyName("RemarkLocation");
                        newProperty.setDefaultValue(mi.getEntityKey());
                        PropertyType ptype = (PropertyType)((OMIRepositoryInterface)this._repository).createMetadata("String", "PropertyType");
                        newProperty.setOwningType(ptype);
                        this.addToList((List)properties, newProperty);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        try {
                            this._repository.getServer().reconnect();
                            this.setRemarksList(remarks);
                            return;
                        }
                        catch (ServiceException propIt) {
                            // empty catch block
                        }
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                    break;
                }
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                ArrayList<String> remarksKeys = new ArrayList<String>(4);
                for (MetadataInterface mi : remarks) {
                    remarksKeys.add(mi.getEntityKey());
                }
                d.setRemarksKeys(remarksKeys.toArray(new String[0]));
            }
        }
    }

    @Override
    public PermissionInterface getPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (identity == null || permission == null) {
            return null;
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getv92OMRPermission(identity, permission);
            }
        }
        return null;
    }

    private PermissionInterface getOMRPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        PermissionInterface pi = this.getDirectPermission(identity, permission);
        if (pi != null) {
            return pi;
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        ArrayList<PermissionInterface> permList = new ArrayList<PermissionInterface>(8);
        permList.add(permission);
        try {
            String[][] inheritedperms = omirepository.getInheritedPermissions(identity, this, permList);
            int size = inheritedperms.length;
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    if (!inheritedperms[i][1].equalsIgnoreCase(permission.getType())) continue;
                    return new com.sas.services.security.Permission(permission.getType(), permission.getAction(), null);
                }
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return null;
    }

    private PermissionInterface getDirectPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        Root cm = (Root)this._repositoryObject;
        try {
            AssociationList aci = cm.getAccessControls();
            for (Object o : aci) {
                AccessControlTemplate act;
                AccessControlEntry ace;
                PermissionInterface pi;
                if (!(o instanceof AccessControlEntry ? (pi = this.findPermissionInACE(identity, permission, ace = (AccessControlEntry)o)) != null : o instanceof AccessControlTemplate && (pi = this.findPermissionInACT(identity, permission, act = (AccessControlTemplate)o)) != null)) continue;
                return pi;
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this._repository.getServer().reconnect();
                return this.getDirectPermission(identity, permission);
            }
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
        }
        return null;
    }

    private PermissionInterface findPermissionInACT(IdentityInterface identity, PermissionInterface permission, AccessControlTemplate act) throws ServiceException, RemoteException {
        try {
            AssociationList aces = act.getAccessControlItems();
            for (AccessControlEntry ace : aces) {
                PermissionInterface pi = this.findPermissionInACE(identity, permission, ace);
                if (pi == null) continue;
                return pi;
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return null;
    }

    private PermissionInterface findPermissionInACE(IdentityInterface identity, PermissionInterface permission, AccessControlEntry ace) throws ServiceException, RemoteException {
        try {
            AssociationList ids = ace.getIdentities();
            if (ids.contains(identity.getRepositoryEntity())) {
                AssociationList perms = ace.getPermissions();
                for (Permission cPerm : perms) {
                    if (!cPerm.getName().equalsIgnoreCase(permission.getAction())) continue;
                    if (cPerm.getType().equalsIgnoreCase(permission.getType())) {
                        MetadataInterface mi = this._repository.factoryProcess(ace);
                        return new com.sas.services.security.Permission(permission.getType(), permission.getAction(), mi);
                    }
                    return null;
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return null;
    }

    private PermissionInterface getv92OMRPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        com.sas.services.security.Permission result = null;
        if (identity == null || permission == null) {
            return null;
        }
        ArrayList<IdentityInterface> identList = new ArrayList<IdentityInterface>(1);
        identList.add(identity);
        ArrayList<PermissionInterface> permList = new ArrayList<PermissionInterface>(1);
        permList.add(permission);
        Root cm = (Root)this._repositoryObject;
        OMIRepositoryInterface oi = (OMIRepositoryInterface)this._repository;
        String resourceId = OMSOBJ_STRING + cm.getCMetadataType() + SLASH + cm.getFQID();
        List authList = oi.getAuthorizationsOnObj(resourceId, identList, permList, 0);
        if (authList != null && authList.size() > 0) {
            Authorization auth = (Authorization)authList.get(0);
            String authType = auth.getAuthType();
            String authAction = auth.getAuthAction();
            if (authType.equalsIgnoreCase(permission.getType()) && authAction.equalsIgnoreCase(permission.getAction())) {
                result = new com.sas.services.security.Permission(auth.getAuthType(), auth.getAuthAction(), null);
            }
        }
        return result;
    }

    @Override
    public void setPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                this.setv92OMRPermission(identity, permission);
                break;
            }
        }
    }

    private void setOMRPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        Root cm = (Root)this._repositoryObject;
        Identity who = (Identity)identity.getRepositoryEntity();
        List aces = this.findIdentity(who, cm);
        if (aces.size() > 0) {
            for (AccessControl ac : aces) {
                AccessControlTemplate act;
                AccessControlEntry ace;
                if (!(ac instanceof AccessControlEntry ? this.checkACE(ace = (AccessControlEntry)ac, permission, who) : ac instanceof AccessControlTemplate && this.checkACT(act = (AccessControlTemplate)ac, permission, who))) continue;
                return;
            }
            aces = this.findIdentity(who, cm);
            if (aces.size() == 1) {
                this.repermissionAccessControl(who, aces, permission, identity);
            } else {
                this.rearrangeACES(identity, aces, who, permission);
            }
        } else {
            this.addPermission(identity, permission);
            return;
        }
    }

    private void repermissionAccessControl(Identity who, List aces, PermissionInterface permission, IdentityInterface identity) throws ServiceException, RemoteException {
        AccessControl ac = (AccessControl)aces.get(0);
        if (ac instanceof AccessControlEntry) {
            AccessControlEntry ace = (AccessControlEntry)ac;
            this.adjustOMRACEPermissions(who, null, permission, ace);
        } else if (ac instanceof AccessControlTemplate) {
            AccessControlTemplate act = (AccessControlTemplate)ac;
            List currentPermissions = this.getPermissions(identity, null, false);
            AccessControlTemplate newact = this.copyACT(act);
            aces.remove(act);
            this.removeIdentityFromAct(who, newact);
            aces.add(newact);
            OMRAccessControlEntry acei = new OMRAccessControlEntry(this._repository, who.getName() + '_' + permission.getAction(), null);
            for (PermissionInterface pi : currentPermissions) {
                if (pi.getAction().equalsIgnoreCase(permission.getAction())) continue;
                acei.addPermission(pi);
            }
            acei.addPermission(permission);
            this.addAccessControl(acei);
            return;
        }
    }

    private void rearrangeACES(IdentityInterface identity, List aces, Identity who, PermissionInterface permission) throws ServiceException, RemoteException {
        try {
            List currentPermissions = this.getPermissions(identity);
            for (AccessControl ac : aces) {
                if (ac instanceof AccessControlEntry) {
                    AccessControlEntry ace = (AccessControlEntry)ac;
                    this.removeFromList((List)ace.getIdentities(), who);
                    continue;
                }
                if (!(ac instanceof AccessControlTemplate)) continue;
                AccessControlTemplate act = (AccessControlTemplate)ac;
                AccessControlTemplate newact = this.copyACT(act);
                this.removeIdentityFromAct(who, newact);
                aces.remove(act);
                aces.add(newact);
            }
            OMRAccessControlEntry acei = new OMRAccessControlEntry(this._repository, "ace", null);
            acei.addIdentity(identity);
            for (PermissionInterface pi : currentPermissions) {
                if (pi.getAction().equalsIgnoreCase(permission.getAction())) continue;
                acei.addPermission(pi);
            }
            acei.addPermission(permission);
            this.addAccessControl(acei);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, "");
        }
    }

    private boolean checkACT(AccessControlTemplate act, PermissionInterface permission, Identity who) throws ServiceException, RemoteException {
        Root cm = (Root)this._repositoryObject;
        try {
            if (this.actHasIdentityPermission(who, permission, act)) {
                return true;
            }
            com.sas.services.security.Permission pi = new com.sas.services.security.Permission(permission.getType().equals("GRANT") ? "GRANT" : "DENY", permission.getAction(), permission.getOwningObject());
            if (this.actHasIdentityPermission(who, pi, act)) {
                AccessControlTemplate newact = this.copyACT(act);
                this.removeIdentityFromAct(who, newact);
                this.removeFromList((List)cm.getAccessControls(), act);
                this.addToList((List)cm.getAccessControls(), newact);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return false;
    }

    private boolean checkACE(AccessControlEntry ace, PermissionInterface permission, Identity who) throws ServiceException, RemoteException {
        try {
            for (Permission perm : ace.getPermissions()) {
                if (!perm.getName().equalsIgnoreCase(permission.getAction())) continue;
                if (perm.getType().equalsIgnoreCase(permission.getType())) {
                    return true;
                }
                this.adjustOMRACEPermissions(who, perm, permission, ace);
                return true;
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return false;
    }

    private void adjustOMRACEPermissions(Identity who, Permission perm, PermissionInterface permission, AccessControlEntry ace) throws ServiceException, RemoteException {
        try {
            if (ace.getIdentities().size() > 1) {
                this.removeFromList((List)ace.getIdentities(), who);
                AccessControlEntry newace = this.copyACE(ace);
                newace.getIdentities().clear();
                this.addToList((List)newace.getIdentities(), who);
                if (perm != null) {
                    this.removeFromList((List)newace.getPermissions(), perm);
                }
                AccessControlEntryInterface acei = (AccessControlEntryInterface)this._repository.factoryProcess(newace);
                acei.addPermission(permission);
                this.addAccessControl(acei);
                return;
            }
            if (perm != null) {
                this.removeFromList((List)ace.getPermissions(), perm);
            }
            AccessControlEntryInterface acei = (AccessControlEntryInterface)this._repository.factoryProcess(ace);
            acei.addPermission(permission);
            this.addAccessControl(acei);
            return;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    private void removeIdentityFromAct(Identity identity, AccessControlTemplate act) throws ServiceException {
        try {
            for (AccessControl ac : act.getAccessControlItems()) {
                if (ac instanceof AccessControlEntry) {
                    AccessControlEntry ace = (AccessControlEntry)ac;
                    if (!ace.getIdentities().contains((Object)identity)) continue;
                    this.removeFromList((List)ace.getIdentities(), identity);
                    continue;
                }
                if (!(ac instanceof AccessControlTemplate)) continue;
                this.removeIdentityFromAct(identity, (AccessControlTemplate)ac);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void addPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException {
        try {
            OMRAccessControlEntry acei = new OMRAccessControlEntry(this._repository, identity.getName() + '_' + permission.getAction(), null);
            acei.addPermission(permission);
            acei.addIdentity(identity);
            this.addAccessControl(acei);
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, rex.getMessage());
        }
    }

    private AccessControlEntry copyACE(AccessControlEntry ace) throws ServiceException {
        try {
            AccessControlEntryInterface acei = (AccessControlEntryInterface)((OMIRepositoryInterface)this._repository).newMetadata(null, "ace", "AccessControlEntry");
            AccessControlEntry newAce = (AccessControlEntry)acei.getRepositoryEntity();
            AssociationList idents = ace.getIdentities();
            Iterator identIt = idents.iterator();
            while (identIt.hasNext()) {
                this.addToList((List)newAce.getIdentities(), identIt.next());
            }
            AssociationList perms = ace.getPermissions();
            Iterator permIt = perms.iterator();
            while (permIt.hasNext()) {
                this.addToList((List)newAce.getPermissions(), permIt.next());
            }
            return newAce;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private AccessControlTemplate copyACT(AccessControlTemplate act) throws ServiceException {
        try {
            MetadataInterface mi = ((OMIRepositoryInterface)this._repository).newMetadata(null, "act", "AccessControlTemplate");
            AccessControlTemplate newAct = (AccessControlTemplate)mi.getRepositoryEntity();
            AssociationList aces = act.getAccessControlItems();
            for (Object o : aces) {
                if (o instanceof AccessControlEntry) {
                    AccessControlEntry newace = this.copyACE((AccessControlEntry)o);
                    this.addToList((List)newAct.getAccessControlItems(), newace);
                    continue;
                }
                if (!(o instanceof AccessControlTemplate)) continue;
                AccessControlTemplate newact = this.copyACT((AccessControlTemplate)o);
                this.addToList((List)newAct.getAccessControlItems(), newact);
            }
            return newAct;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private List findIdentity(Identity identity, Root associatedObject) throws ServiceException {
        try {
            ArrayList<AccessControl> results = new ArrayList<AccessControl>(8);
            AssociationList controls = associatedObject.getAccessControls();
            for (AccessControl acc : controls) {
                if (acc instanceof AccessControlEntry && ((AccessControlEntry)acc).getIdentities().contains((Object)identity)) {
                    results.add(acc);
                }
                if (!(acc instanceof AccessControlTemplate) || !this.actHasIdentity(identity, (AccessControlTemplate)acc)) continue;
                results.add(acc);
            }
            return results;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private boolean actHasIdentity(Identity identity, AccessControlTemplate act) throws ServiceException {
        try {
            AssociationList acis = act.getAccessControlItems();
            for (AccessControl acc : acis) {
                if (acc instanceof AccessControlEntry && ((AccessControlEntry)acc).getIdentities().contains((Object)identity)) {
                    return true;
                }
                if (!(acc instanceof AccessControlTemplate) || !this.actHasIdentity(identity, act)) continue;
                return true;
            }
            return false;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void setv92OMRPermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        Root cm = (Root)this._repositoryObject;
        Identity cid = (Identity)identity.getRepositoryEntity();
        Authorization auth = new Authorization(cid.getCMetadataType(), identity.getName(), permission.getAction(), 0, permission.getType(), "");
        OMIRepositoryInterface oi = (OMIRepositoryInterface)this._repository;
        ArrayList<Authorization> authList = new ArrayList<Authorization>();
        authList.add(auth);
        String resourceId = OMSOBJ_STRING + cm.getCMetadataType() + SLASH + cm.getFQID();
        oi.setAuthorizationsOnObj(resourceId, authList, 0);
    }

    @Override
    public List getPermissions(IdentityInterface identity) throws ServiceException, RemoteException {
        return this.getPermissions(identity, null, true);
    }

    @Override
    public List getPermissions(IdentityInterface identity, String[] inheritedPermissions) throws ServiceException, RemoteException {
        return this.getPermissions(identity, inheritedPermissions, true);
    }

    private List getPermissions(IdentityInterface identity, String[] inheritedPermissions, boolean inherited) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getv92OMRPermissions(identity, inheritedPermissions, inherited);
            }
            case 3: {
                if (identity != null) break;
                return this.getDAVEffectivePermissions();
            }
        }
        return new ArrayList(8);
    }

    private List getDAVEffectivePermissions() throws ServiceException, RemoteException {
        ArrayList<com.sas.services.security.Permission> results = new ArrayList<com.sas.services.security.Permission>(8);
        DAVRepositoryInterface ri = (DAVRepositoryInterface)this._repository;
        SharedResourceInterface sri = ri.getSharedResource();
        try {
            DavPropertyItem davPropertyItem;
            DavProperty davProperty;
            Object davPropertyValue;
            DAVResourceInterface r = sri.getConnection();
            String savedPath = r.getPath();
            String path = null;
            try {
                path = new URI(this.getEntityURL()).getPath();
            }
            catch (URISyntaxException e) {
                throw new DAVException(e.getMessage(), (Exception)e);
            }
            r.setPath(path);
            DavPropertyResult davPropertyResult = r.getDavProperties(new PropertyName[]{DAVConstants.PNAME_CURRUSER_PRIV_SET});
            List davPropertyItems = davPropertyResult.getDavProperties();
            if (0 < davPropertyItems.size() && (davPropertyValue = (davProperty = (davPropertyItem = (DavPropertyItem)davPropertyItems.get(0)).getDavProperty()).getValue()) instanceof Element) {
                Element element = davProperty.toXml(XMLUtil.newDocument());
                NodeList nl = element.getElementsByTagNameNS("DAV:", "privilege");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node privNode = nl.item(i);
                    NodeList nl2 = privNode.getChildNodes();
                    for (int j = 0; j < nl2.getLength(); ++j) {
                        Node node = nl2.item(j);
                        if (!(node instanceof Element)) continue;
                        String action = "{" + node.getNamespaceURI() + "}" + node.getLocalName();
                        com.sas.services.security.Permission p = new com.sas.services.security.Permission("GRANT", action, null);
                        results.add(p);
                    }
                }
            }
            r.setPath(savedPath);
        }
        catch (DAVException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException(e, e.getMessage());
        }
        finally {
            sri.releaseConnection();
        }
        return results;
    }

    private List getOMRPermissions(IdentityInterface identity, String[] inheritedPermissions, boolean inherited) throws ServiceException, RemoteException {
        ArrayList results = new ArrayList(8);
        ArrayList permStrings = new ArrayList(8);
        Root cm = (Root)this._repositoryObject;
        try {
            AssociationList aci = cm.getAccessControls();
            for (Object o : aci) {
                if (o instanceof AccessControlEntry) {
                    AccessControlEntry ace = (AccessControlEntry)o;
                    this.getACEPermissions(ace, identity, results, permStrings);
                    continue;
                }
                if (!(o instanceof AccessControlTemplate)) continue;
                AccessControlTemplate act = (AccessControlTemplate)o;
                this.getACTPermissions(act, identity, results, permStrings);
            }
            if (inherited) {
                List inheritedPerms = this.getInheritedPermissions(identity, inheritedPermissions);
                results.addAll(inheritedPerms);
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this._repository.getServer().reconnect();
                return this.getOMRPermissions(identity, inheritedPermissions, inherited);
            }
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
        }
        return results;
    }

    private void getACTPermissions(AccessControlTemplate act, IdentityInterface identity, List results, List permStrings) throws ServiceException, RemoteException {
        try {
            AssociationList aces = act.getAccessControlItems();
            for (AccessControlEntry ace : aces) {
                AssociationList ids = ace.getIdentities();
                if (!ids.contains(identity.getRepositoryEntity())) continue;
                AssociationList perms = ace.getPermissions();
                for (Permission cPerm : perms) {
                    MetadataInterface mi = this._repository.factoryProcess(ace);
                    results.add(new com.sas.services.security.Permission(cPerm.getType(), cPerm.getName(), mi));
                    permStrings.add(cPerm.getName());
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    private void getACEPermissions(AccessControlEntry ace, IdentityInterface identity, List results, List permStrings) throws ServiceException, RemoteException {
        try {
            AssociationList ids = ace.getIdentities();
            if (ids.contains(identity.getRepositoryEntity())) {
                AssociationList perms = ace.getPermissions();
                for (Permission cPerm : perms) {
                    MetadataInterface mi = this._repository.factoryProcess(ace);
                    results.add(new com.sas.services.security.Permission(cPerm.getType(), cPerm.getName(), mi));
                    permStrings.add(cPerm.getName());
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, "");
        }
    }

    private List getInheritedPermissions(IdentityInterface identity, String[] inheritedPermissions) throws ServiceException, RemoteException {
        ArrayList<com.sas.services.security.Permission> results = new ArrayList<com.sas.services.security.Permission>(8);
        ArrayList permStrings = new ArrayList(8);
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        ArrayList<com.sas.services.security.Permission> permList = new ArrayList<com.sas.services.security.Permission>(8);
        if (inheritedPermissions == null) {
            permList.add(new com.sas.services.security.Permission("GRANT", "ReadMetadata", null));
            permList.add(new com.sas.services.security.Permission("GRANT", "WriteMetadata", null));
            permList.add(new com.sas.services.security.Permission("GRANT", "Read", null));
            permList.add(new com.sas.services.security.Permission("GRANT", "Write", null));
            permList.add(new com.sas.services.security.Permission("GRANT", "Administer", null));
        } else {
            for (int i = 0; i < inheritedPermissions.length; ++i) {
                permList.add(new com.sas.services.security.Permission("GRANT", inheritedPermissions[i], null));
            }
        }
        String[][] inheritedperms = omirepository.getInheritedPermissions(identity, this, permList);
        int size = inheritedperms.length;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (permStrings.contains(inheritedperms[i][0])) continue;
                results.add(new com.sas.services.security.Permission(inheritedperms[i][1], inheritedperms[i][0], null));
            }
        }
        return results;
    }

    private List getv92OMRPermissions(IdentityInterface identity, String[] inheritedPermissions, boolean inherited) throws ServiceException, RemoteException {
        if (identity == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<com.sas.services.security.Permission> results = new ArrayList<com.sas.services.security.Permission>(8);
        ArrayList<IdentityInterface> identList = new ArrayList<IdentityInterface>(1);
        identList.add(identity);
        ArrayList<com.sas.services.security.Permission> permList = null;
        if (inheritedPermissions != null && inheritedPermissions.length > 0) {
            permList = new ArrayList<com.sas.services.security.Permission>(inheritedPermissions.length);
            for (int i = 0; i < inheritedPermissions.length; ++i) {
                permList.add(new com.sas.services.security.Permission("Grant", inheritedPermissions[i], null));
            }
        }
        Root cm = (Root)this._repositoryObject;
        OMIRepositoryInterface oi = (OMIRepositoryInterface)this._repository;
        String resourceId = OMSOBJ_STRING + cm.getCMetadataType() + SLASH + cm.getFQID();
        List authList = oi.getAuthorizationsOnObj(resourceId, identList, permList, 0);
        for (Authorization auth : authList) {
            if (!inherited && auth.getAuthSource() != 1 && auth.getAuthSource() != 2) continue;
            com.sas.services.security.Permission perm = new com.sas.services.security.Permission(auth.getAuthType(), auth.getAuthAction(), null);
            results.add(perm);
        }
        return results;
    }

    @Override
    public List getIdentities() throws ServiceException, RemoteException {
        this.checkPulse(true);
        List results = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                String resource = OMSOBJ_STRING + cm.getCMetadataType() + SLASH + cm.getFQID();
                int flags = 0;
                List identStringList = ((OMIRepositoryInterface)this._repository).getIdentitiesOnObj(resource, flags);
                if (identStringList == null || identStringList.size() == 0) {
                    return Collections.EMPTY_LIST;
                }
                Filter filter = new Filter();
                FilterComponent fc = new FilterComponent();
                fc.setAggregation(1);
                for (String nextIdent : identStringList) {
                    int index = nextIdent.indexOf(47);
                    nextIdent = nextIdent.substring(index + 1);
                    fc.addComponent(new FilterComponent("Name", 0, nextIdent));
                }
                filter.setFilterComponent(fc);
                filter.setType("Identity");
                filter.setOMRFlags(16);
                ServerInterface server = this._repository.getServer();
                RepositoryInterface ri = server.getFoundationRepository();
                results = ri.search(filter);
                break;
            }
            case 3: {
                results = Collections.EMPTY_LIST;
            }
        }
        return results;
    }

    @Override
    public void addPermissions(List identities, List permissions) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                this.addV92OMRPermissions(identities, permissions);
                break;
            }
        }
    }

    private void addV92OMRPermissions(List identities, List permissions) throws ServiceException, RemoteException {
        if (identities == null || identities.size() == 0 || permissions == null || permissions.size() == 0) {
            return;
        }
        ArrayList<Authorization> authList = new ArrayList<Authorization>(identities.size() * permissions.size());
        for (IdentityInterface ident : identities) {
            String type = ident.getIdentityType();
            String name = ident.getName();
            for (PermissionInterface pi : permissions) {
                Authorization auth = new Authorization(type, name, pi.getAction(), 0, pi.getType(), "");
                authList.add(auth);
            }
        }
        Root cm = (Root)this._repositoryObject;
        OMIRepositoryInterface oi = (OMIRepositoryInterface)this._repository;
        String resourceId = OMSOBJ_STRING + cm.getCMetadataType() + SLASH + cm.getFQID();
        oi.setAuthorizationsOnObj(resourceId, authList, 0);
    }

    private void removePermission(IdentityInterface identity, PermissionInterface permission) throws ServiceException, RemoteException {
        Identity who = (Identity)identity.getRepositoryEntity();
        Root root = (Root)this._repositoryObject;
        List aces = this.findIdentity(who, root);
        for (AccessControl ac : aces) {
            if (ac instanceof AccessControlEntry) {
                AccessControlEntry ace = (AccessControlEntry)ac;
                this.removePermissionFromACE(ace, permission, who);
                continue;
            }
            if (!(ac instanceof AccessControlTemplate)) continue;
            AccessControlTemplate act = (AccessControlTemplate)ac;
            this.removePermissionFromACT(act, permission, who, identity);
        }
    }

    private void removePermissionFromACT(AccessControlTemplate act, PermissionInterface permission, Identity who, IdentityInterface identity) throws ServiceException, RemoteException {
        try {
            if (this.actHasIdentityPermission(who, permission, act)) {
                List permList = this.getPermissions(identity, null, false);
                AccessControlTemplate newact = this.copyACT(act);
                this.removeFromList((List)((Root)this._repositoryObject).getAccessControls(), act);
                this.removeIdentityFromAct(who, newact);
                this.addToList((List)((Root)this._repositoryObject).getAccessControls(), newact);
                OMRAccessControlEntry acei = new OMRAccessControlEntry(this._repository, "ace", null);
                acei.addIdentity(identity);
                for (PermissionInterface pi : permList) {
                    if (pi.getAction().equalsIgnoreCase(permission.getAction()) && pi.getType().equalsIgnoreCase(permission.getType())) continue;
                    acei.addPermission(pi);
                }
                this.addAccessControl(acei);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    private void removePermissionFromACE(AccessControlEntry ace, PermissionInterface permission, Identity who) throws ServiceException, RemoteException {
        try {
            ArrayList permList = new ArrayList(ace.getPermissions());
            for (Permission perm : permList) {
                if (!perm.getName().equalsIgnoreCase(permission.getAction()) || !perm.getType().equalsIgnoreCase(permission.getType())) continue;
                AssociationList idents = ace.getIdentities();
                if (idents.size() == 1) {
                    this.removeFromList((List)ace.getPermissions(), perm);
                    if (ace.getPermissions().size() != 0) continue;
                    this.deleteRootObject((Root)ace);
                    continue;
                }
                AccessControlEntry newace = this.copyACE(ace);
                this.removeFromList((List)ace.getIdentities(), who);
                newace.getIdentities().clear();
                this.addToList((List)newace.getIdentities(), who);
                for (Permission cperm : newace.getPermissions()) {
                    if (!cperm.getName().equalsIgnoreCase(permission.getAction()) || !cperm.getType().equalsIgnoreCase(permission.getType())) continue;
                    this.removeFromList((List)newace.getPermissions(), cperm);
                }
                if (newace.getPermissions().size() <= 0) continue;
                this.addToList((List)((Root)this._repositoryObject).getAccessControls(), newace);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, "");
        }
    }

    private boolean actHasIdentityPermission(Identity identity, PermissionInterface permission, AccessControlTemplate act) throws ServiceException, RemoteException {
        try {
            for (AccessControl ac : act.getAccessControlItems()) {
                AccessControlTemplate subact;
                if (ac instanceof AccessControlEntry) {
                    AccessControlEntry ace = (AccessControlEntry)ac;
                    if (!ace.getIdentities().contains((Object)identity)) continue;
                    for (Permission cperm : ace.getPermissions()) {
                        if (!cperm.getName().equalsIgnoreCase(permission.getAction()) || !cperm.getType().equalsIgnoreCase(permission.getType())) continue;
                        return true;
                    }
                    continue;
                }
                if (!(ac instanceof AccessControlTemplate) || !this.actHasIdentityPermission(identity, permission, subact = (AccessControlTemplate)ac)) continue;
                return true;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return false;
    }

    @Override
    public void removePermissions(List identities, List permissions) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                this.removeV92OMRPermissions(identities, permissions);
                break;
            }
        }
    }

    private void removeV92OMRPermissions(List identities, List permissions) throws ServiceException, RemoteException {
        HashMap<IdentityInterface, List> identPermMap = new HashMap<IdentityInterface, List>(identities.size() * 4);
        for (IdentityInterface nextIdent : identities) {
            List permList = this.getPermissions(nextIdent);
            if (permList == null) {
                permList = Collections.EMPTY_LIST;
            }
            identPermMap.put(nextIdent, permList);
        }
        ArrayList<Authorization> authList = new ArrayList<Authorization>(identities.size() * permissions.size());
        for (IdentityInterface ident : identities) {
            List permList = (List)identPermMap.get(ident);
            String type = ident.getIdentityType();
            String name = ident.getName();
            for (PermissionInterface pi : permissions) {
                if (!permList.contains(pi)) continue;
                Authorization auth = new Authorization(type, name, pi.getAction(), 0, "Remove", "");
                authList.add(auth);
            }
        }
        Root cm = (Root)this._repositoryObject;
        OMIRepositoryInterface oi = (OMIRepositoryInterface)this._repository;
        String resourceId = OMSOBJ_STRING + cm.getCMetadataType() + SLASH + cm.getFQID();
        if (authList.size() > 0) {
            oi.setAuthorizationsOnObj(resourceId, authList, 0);
        }
    }

    @Override
    public List getAccessControls() throws ServiceException, RemoteException {
        this.checkPulse(true);
        List<MetadataInterface> results = new ArrayList(8);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList aci = cm.getAccessControls();
                    for (Object o : aci) {
                        if (o instanceof AccessControlEntry) {
                            MetadataInterface mi = this._repository.factoryProcess(o);
                            results.add(mi);
                            continue;
                        }
                        if (!(o instanceof AccessControlTemplate)) continue;
                        AccessControlTemplate act = (AccessControlTemplate)o;
                        AssociationList aces = act.getAccessControlItems();
                        for (AccessControlEntry ace : aces) {
                            MetadataInterface mi = this._repository.factoryProcess(ace);
                            results.add(mi);
                        }
                    }
                    break;
                }
                catch (MdException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                    break;
                }
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                results = d.getAccessControlList();
            }
        }
        return results;
    }

    @Override
    public void addAccessControl(AccessControlEntryInterface ace) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList aci = cm.getAccessControls();
                    this.addToList((List)aci, ace.getRepositoryEntity());
                }
                catch (MdException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                d.addAccessControlEntry(ace);
            }
        }
    }

    @Override
    public void removeAccessControl(AccessControlEntryInterface ace) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList aci = cm.getAccessControls();
                    this.removeFromList((List)aci, ace.getRepositoryEntity());
                }
                catch (MdException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
            case 3: {
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                d.removeAccessControlEntry(ace);
            }
        }
    }

    @Override
    public void moveTo(FolderInterface folder) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (folder == null) {
            return;
        }
        FolderInterface currentParent = this.getParent();
        if (currentParent != null && currentParent == folder) {
            return;
        }
        if (folder.hasDuplicate(this.getName(), this.getType())) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.dupitem.ex.fmt.txt", (Object)this.getName(), (Object)this.getType()));
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList parents = cm.getTrees();
                    parents.clear();
                    if (folder == null) break;
                    this.addToList((List)parents, folder.getRepositoryEntity());
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.moveTo(folder);
                        return;
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
            case 3: {
                DAVRepository DAVrepository = (DAVRepository)this._repository;
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                FolderInterface _m = folder;
                if (_m == null) {
                    return;
                }
                DAVFolderInterface f = (DAVFolderInterface)_m.getRepositoryEntity();
                MetadataInterface newMi = DAVrepository.moveTo(d, f, null);
                this._repositoryObject = newMi.getRepositoryEntity();
            }
        }
    }

    @Override
    public MetadataInterface copyTo(FolderInterface folder, String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (folder != null && folder.hasDuplicate(name, this.getType())) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.dupitem.ex.fmt.txt", (Object)name, (Object)this.getType()));
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
                Root cm = (Root)this._repositoryObject;
                Root dest = omirepository.createMetadata(name, cm.getCMetadataType());
                MetadataInterface mi = null;
                Map attrs = cm.getAttrs();
                try {
                    Object trees;
                    attrs.put("Id", dest.getFQID());
                    attrs.remove("Name");
                    MdStoreUtil.setMetaObjectAttributes((CMetadata)cm, (CMetadata)dest, (Map)attrs, (int)1);
                    AssociationList keywords = cm.getKeywords();
                    for (Keyword nextKeyword : keywords) {
                        Keyword newKeyword = (Keyword)omirepository.createMetadata(nextKeyword.getName(), "Keyword");
                        this.addToList((List)dest.getKeywords(), newKeyword);
                    }
                    mi = this._repository.factoryProcess(dest);
                    List promptList = this.getPrompts();
                    for (BaseOMRPromptInterface nextPrompt : promptList) {
                        BaseOMRPromptInterface nextNewPrompt = (BaseOMRPromptInterface)nextPrompt.copyTo(null, nextPrompt.getName());
                        mi.addPrompt(nextNewPrompt);
                    }
                    if (folder != null) {
                        folder.addItem(mi);
                    } else {
                        trees = cm.getTrees();
                        if (trees.size() == 1) {
                            Tree tree = (Tree)trees.get(0);
                            this.addToList((List)dest.getTrees(), tree);
                        }
                    }
                    trees = mi;
                    return trees;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        MetadataInterface it = this.copyTo(folder, name);
                        return it;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
                finally {
                    if (attrs != null) {
                        MapPool.returnMap((Map)attrs);
                    }
                }
            }
            case 3: {
                DAVRepository DAVrepository = (DAVRepository)this._repository;
                DAVEntityInterface d = (DAVEntityInterface)this._repositoryObject;
                FolderInterface _m = folder;
                if (_m != null) {
                    DAVFolderInterface f = (DAVFolderInterface)_m.getRepositoryEntity();
                    return DAVrepository.copyTo(d, f, name);
                }
                return DAVrepository.copyTo(d, null, name);
            }
        }
        return null;
    }

    @Override
    public List getExtensions() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(4);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList extensionList = cm.getExtensions();
                    for (Object o : extensionList) {
                        MetadataInterface mi = this._repository.factoryProcess(o);
                        results.add(mi);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getExtensions();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return results;
    }

    @Override
    public void addExtension(String name, String value, String type) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList extensionList = cm.getExtensions();
                    OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
                    Extension ext = (Extension)omirepos.createMetadata(name, "Extension");
                    ext.setValue(value);
                    ext.setExtensionType(type);
                    this.addToList((List)extensionList, ext);
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addExtension(name, value, type);
                        return;
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
                break;
            }
        }
    }

    @Override
    public void removeExtension(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList extensionList = cm.getExtensions();
                    ArrayList ghostList = new ArrayList(extensionList);
                    for (Extension ext : ghostList) {
                        if (!ext.getName().equals(name)) continue;
                        this.removeFromList((List)extensionList, ext);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeExtension(name);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void setExtensions(List extensionList) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                try {
                    ArrayList extensions = new ArrayList(cm.getExtensions());
                    for (Extension ext : extensions) {
                        ext.delete();
                    }
                    for (ExtensionInterface ex : extensionList) {
                        Extension ext = (Extension)ex.getRepositoryEntity();
                        this.addToList(extensions, ext);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.setExtensions(extensionList);
                        return;
                    }
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                    break;
                }
            }
        }
    }

    @Override
    public boolean isAuthorized(String permission) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
                return omirepos.isAuthorized(this, permission);
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int countAssociatedObjects(String association) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
                IdFilter filter = new IdFilter(this.getReposId());
                String type = ((Root)this._repositoryObject).getCMetadataType();
                filter.setType(type);
                String template = "<Templates><" + type + "><" + association + "/></" + type + "></Templates>";
                filter.setOMRTemplate(template);
                int count = omirepos.getCountNoSecurity(filter, association);
                return count;
            }
        }
        return 0;
    }

    @Override
    public MetadataInterface startTransaction() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ChildRepositoryInterface ri = this._repository.newChild();
        if (ri == null) {
            throw new ServiceException(RB.getStringResource("Metadata.notransaction.ex.txt"));
        }
        MetadataInterface mi = ri.fetch(this.getReposKey());
        this._children.add(mi);
        mi.addTransactionListener(this);
        return mi;
    }

    @Override
    public void commit() throws ServiceException, RemoteException {
        this.checkPulse(false);
        if (this._repository instanceof ChildRepositoryInterface) {
            if (this._children.size() > 0) {
                throw new ServiceException(RB.getStringResource("Metadata.outstchild.ex.txt"));
            }
        } else {
            throw new ServiceException(RB.getStringResource("Metadata.mustchild.ex.txt"));
        }
        ((ChildRepositoryInterface)this._repository).commit();
        this.notifyTransactionListeners();
    }

    @Override
    public void rollback() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!(this._repository instanceof ChildRepositoryInterface)) {
            throw new ServiceException(RB.getStringResource("Metadata.mustchild.ex.txt"));
        }
        ((ChildRepositoryInterface)this._repository).rollback();
        this.notifyTransactionListeners();
    }

    @Override
    public void transactionEvent(MetadataInterface mi) throws RemoteException {
        this.removeFromList(this._children, mi);
    }

    @Override
    public void addTransactionListener(MetadataInterface mi) throws RemoteException {
        this._transactionListeners.add(new WeakReference<MetadataInterface>(mi));
    }

    protected void notifyTransactionListeners() throws RemoteException {
        for (WeakReference wr : this._transactionListeners) {
            MetadataInterface mi = (MetadataInterface)wr.get();
            if (mi == null) continue;
            mi.transactionEvent(this);
        }
    }

    public void logMessage(Level level, String message, String context, Throwable t) throws RemoteException {
        Logger logger;
        this.checkPulse(true);
        if (context == null || context.length() == 0) {
            context = METADATA_CONTEXT;
        }
        if (!(logger = LogManager.getLogger((String)context)).isEnabled(level)) {
            return;
        }
        if (t != null) {
            logger.log(level, message, t);
        } else {
            logger.log(level, message);
        }
    }

    public void logThrowable(Level level, String message, String context, Throwable t) throws RemoteException {
        Logger logger;
        this.checkPulse(true);
        if (t == null) {
            return;
        }
        if (context == null || context.length() == 0) {
            context = METADATA_CONTEXT;
        }
        if ((logger = LogManager.getLogger((String)context)) != null) {
            if (!logger.isEnabled(level)) {
                return;
            }
            while (t != null) {
                logger.log(level, message, t);
                Throwable rootCause = ChainedException.getRootException((Throwable)t);
                if (rootCause != null && !rootCause.equals(t)) {
                    t = rootCause;
                    logger.info("<<<<------------------------------->>>>");
                    continue;
                }
                t = null;
            }
            logger.log(level, message, t);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0) throws RemoteException {
        if (this.isLoggingEnabled(level, context)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0);
            this.logMessage(level, message, context, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0, Object arg1) throws RemoteException {
        if (this.isLoggingEnabled(level, context)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0, (Object)arg1);
            this.logMessage(level, message, context, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0, Object arg1, Object arg2) throws RemoteException {
        if (this.isLoggingEnabled(level, context)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0, (Object)arg1, (Object)arg2);
            this.logMessage(level, message, context, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0, Object arg1, Object arg2, Object arg3) throws RemoteException {
        if (this.isLoggingEnabled(level, context)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0, (Object)arg1, (Object)arg2, (Object)arg3);
            this.logMessage(level, message, context, null);
        }
    }

    public void logMessage(Level level, String message) throws RemoteException {
        this.logMessage(level, message, METADATA_CONTEXT, null);
    }

    @Override
    public void addRemark(RemarksInterface remark) throws ServiceException, RemoteException {
        boolean success = false;
        int attempts = 0;
        do {
            ++attempts;
            try {
                List list = this.getRemarksList();
                list.add(remark);
                this.setRemarksList(list);
                remark.addReferral(this.getEntityKey());
                this.update();
                success = true;
            }
            catch (EntityHasChangedException e) {
                success = false;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.refresh();
            }
        } while (!success && attempts <= 4);
        if (!success) {
            throw new ServiceException(RB.getStringResource("Metadata.update.ex.txt"));
        }
    }

    public boolean isLoggingEnabled(Level level, String context) throws RemoteException {
        this.checkPulse(true);
        if (context == null) {
            context = METADATA_CONTEXT;
        }
        Logger logger = LogManager.getLogger((String)context);
        return logger.isEnabled(level);
    }

    @Override
    public String mapNameToFilesystem(int hostOS, String prefix, String suffix) throws RemoteException, IllegalArgumentException {
        throw new UnsupportedOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"Metadata.notsupp.ex.fmt.txt", (Object)"mapNameToFilesystem"));
    }

    @Override
    public String mapUrlToFilesystem(int hostOS, String prefix, String suffix) throws ServiceException, RemoteException, IllegalArgumentException {
        throw new UnsupportedOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"Metadata.notsupp.ex.fmt.txt", (Object)"mapUrlToFilesystem"));
    }

    @Override
    public PropertyBagInterface getPropertyBag() throws ServiceException, RemoteException {
        this.checkPulse(true);
        PropertyBag result = new PropertyBag(this);
        Object oPut = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                Iterator it = cm.getAttrs().entrySet().iterator();
                Map.Entry mapEntry = null;
                while (it.hasNext()) {
                    mapEntry = it.next();
                    String nextKey = (String)mapEntry.getKey();
                    String o = (String)mapEntry.getValue();
                    if (o == null || o.length() <= 0) continue;
                    oPut = result.put(nextKey, o);
                }
                break;
            }
        }
        oPut = result.put("SmartType", this.getType());
        PathUrl pathUrl = this.getPathUrl();
        if (pathUrl != null) {
            oPut = result.put("PathUrl", pathUrl.toString());
        }
        if ((oPut = result.put("ISEntityKey", this.getEntityKey())) != null) {
            this.logMessage(Level.DEBUG, RB.getStringResource("Metadata.propertybagoverwrite.ex.txt"), METADATA_CONTEXT, null);
        }
        return result;
    }

    @Override
    public void updateFromBag(PropertyBagInterface propertyBag) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root cm = (Root)this._repositoryObject;
                Set simpleSet = propertyBag.keySet();
                for (String nextKey : simpleSet) {
                    PropertyBagValue pbv;
                    String o;
                    if ("SmartType".equals(nextKey) || "PathUrl".equals(nextKey) || "ISEntityKey".equals(nextKey) || "MetadataCreated".equals(nextKey) || "MetadataUpdated".equals(nextKey) || "Id".equals(nextKey) || !((o = (pbv = ((PropertyBag)propertyBag).getValue(nextKey)).getValue()) instanceof String)) continue;
                    String nextVal = o;
                    Class metaClass = cm.getClass();
                    Class[] args = new Class[]{nextKey.getClass()};
                    Object[] parms = new Object[]{nextVal};
                    String methodName = "set" + nextKey;
                    Method setMethod = null;
                    try {
                        setMethod = metaClass.getMethod(methodName, args);
                    }
                    catch (NoSuchMethodException t) {
                        this.logMessage(Level.WARN, RB.getStringResource("Metadata.nosetmethod.ex.txt"), METADATA_CONTEXT, t);
                    }
                    if (setMethod == null) continue;
                    try {
                        setMethod.invoke((Object)cm, parms);
                    }
                    catch (IllegalAccessException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                    catch (InvocationTargetException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                }
                this.update();
                break;
            }
        }
    }

    protected void addToList(List list, Object o) {
        if (list == null || o == null) {
            return;
        }
        if (list.contains(o)) {
            return;
        }
        if (!list.add(o)) {
            try {
                this.logMessage(Level.DEBUG, "", METADATA_CONTEXT, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void removeFromList(List list, Object o) {
        if (list == null || o == null) {
            return;
        }
        if (!list.remove(o)) {
            try {
                this.logMessage(Level.DEBUG, "", METADATA_CONTEXT, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append(this.getType());
            buffer.append(" ");
            buffer.append(this.getName());
            buffer.append(" ");
            buffer.append(this.getReposId());
            return buffer.toString();
        }
        catch (RemoteException rex) {
            return "RemoteException";
        }
    }

    @Override
    public int hashCode() {
        int result = 17;
        String reposId = null;
        try {
            reposId = this.getReposId();
            if (reposId == null) {
                System.err.println("IS: Calling hashCode() with a null repository id");
                System.err.println("IS: The object that has a null id is: " + this.toString());
                if (this._repositoryFlag == 2) {
                    if (this._repositoryObject == null) {
                        System.err.println("IS: The joma object is null");
                    } else {
                        System.err.println("IS: The joma object is not null.  MetadataType = " + ((Root)this._repositoryObject).getCMetadataType() + " and Name = " + ((Root)this._repositoryObject).getName());
                    }
                }
                return super.hashCode();
            }
            result = 37 * this.getReposId().hashCode();
            return result;
        }
        catch (RemoteException ex) {
            System.err.println("RemoteException while calling getReposId");
            reposId = null;
            return super.hashCode();
        }
    }

    protected void checkPulse(boolean dieOnDeleted) throws IllegalStateException {
        if (this._myState == 4) {
            throw new IllegalStateException(RB.getStringResource("Metadata.destroyed.ex.txt"));
        }
        if (dieOnDeleted && this._myState == 3) {
            throw new IllegalStateException(RB.getStringResource("Metadata.deleted.ex.txt"));
        }
    }

    @Override
    public String getAttribute(String key) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                return dei.getAttribute(key);
            }
        }
        return null;
    }

    @Override
    public Map getAttributes() throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                return dei.getAttributes();
            }
        }
        return null;
    }

    @Override
    public void setAttribute(String key, String value) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                dei.setAttribute(key, value);
            }
        }
    }

    @Override
    public void addAttribute(String key, String value) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                dei.setAttribute(key, value);
            }
        }
    }

    @Override
    public void deleteAttribute(String key) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                dei.deleteAttribute(key);
            }
        }
    }

    @Override
    public void setAttributes(Map attributeMap) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                for (Map.Entry me : attributeMap.entrySet()) {
                    dei.setAttribute((String)me.getKey(), me.getValue());
                }
                break;
            }
        }
    }

    @Override
    public void addAttributes(Map attributeMap) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                for (Map.Entry me : attributeMap.entrySet()) {
                    dei.setAttribute((String)me.getKey(), me.getValue());
                }
                break;
            }
        }
    }

    @Override
    public void deleteAttributes(List attributes) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVEntityInterface dei = (DAVEntityInterface)this._repositoryObject;
                Iterator items = attributes.iterator();
                while (items.hasNext()) {
                    dei.deleteAttribute((String)items.next());
                }
                break;
            }
        }
    }

    @Override
    public byte[] toByteArray() throws RemoteException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            String entityKey = this.getEntityKey();
            oos.writeObject(entityKey);
            byte[] blobArray = baos.toByteArray();
            return blobArray;
        }
        catch (IOException ex) {
            return null;
        }
        catch (ServiceException ex) {
            return null;
        }
    }

    public static MetadataInterface fromByteArray(RepositoryInterface ri, byte[] data) throws RemoteException, ServiceException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            String entityKey = (String)ois.readObject();
            MetadataInterface mi = ri.fetch(entityKey);
            return mi;
        }
        catch (IOException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void version() throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVRepositoryInterface ri = (DAVRepositoryInterface)this._repository;
                ri.version(this);
            }
        }
    }

    @Override
    public void checkout() throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVRepositoryInterface ri = (DAVRepositoryInterface)this._repository;
                ri.checkout(this);
            }
        }
    }

    @Override
    public void checkin() throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVRepositoryInterface ri = (DAVRepositoryInterface)this._repository;
                ri.checkin(this, this.getAttribute("{DAV:}comment"));
            }
        }
    }

    @Override
    public void uncheckout() throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVRepositoryInterface ri = (DAVRepositoryInterface)this._repository;
                ri.uncheckout(this);
            }
        }
    }

    @Override
    public List getPreviousVersionNames() throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVRepositoryInterface ri = (DAVRepositoryInterface)this._repository;
                return ri.getPreviousVersionNames(this);
            }
        }
        return null;
    }

    @Override
    public MetadataInterface getVersion(String versionName) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                DAVRepositoryInterface ri = (DAVRepositoryInterface)this._repository;
                return ri.getVersion(this, versionName);
            }
        }
        return null;
    }

    @Override
    public void addDocument(DocumentInterface doc) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                Document mdoc = (Document)doc.getRepositoryEntity();
                try {
                    AssociationList docList = root.getDocuments();
                    docList.add(mdoc);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addDocument(doc);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removeDocument(DocumentInterface doc) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                Document mdoc = (Document)doc.getRepositoryEntity();
                try {
                    AssociationList docList = root.getDocuments();
                    docList.remove(mdoc);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeDocument(doc);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void setDocuments(List docs) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList docList = root.getDocuments();
                    docList.clear();
                    if (docs == null) break;
                    for (DocumentInterface doc : docs) {
                        Document mdoc = (Document)doc.getRepositoryEntity();
                        docList.add(mdoc);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.setDocuments(docs);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public List getDocuments() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList docList = root.getDocuments();
                    for (Document doc : docList) {
                        MetadataInterface mi = this._repository.factoryProcess(doc);
                        results.add(mi);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getDocuments();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return results;
    }

    @Override
    public void addNoteTextStore(TextStoreInterface note) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                TextStoreInterface existingNote = this.getNoteTextStore(note.getName(), note.getTextRole());
                if (existingNote != null) {
                    if (note.getReposId().equals(existingNote.getReposId())) {
                        return;
                    }
                    throw new ServiceException("TextStore note (Name:\"" + note.getName() + "\", Role:" + note.getTextRole() + ") already exists for object " + this.getReposId());
                }
                Root root = (Root)this._repositoryObject;
                TextStore mtextstore = (TextStore)note.getRepositoryEntity();
                try {
                    root.getNotes().add((Object)mtextstore);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addNoteTextStore(note);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public TextStoreInterface addNoteTextStore(String name, String role, String type, String text) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                if (this.getNoteTextStore(name, role) != null) {
                    throw new ServiceException("TextStore note (Name:\"" + name + "\", Role:" + role + ") already exists for object " + this.getReposId());
                }
                Root root = (Root)this._repositoryObject;
                TextStore note = (TextStore)((OMIRepositoryInterface)this._repository).createMetadata(name, "TextStore");
                if (role != null) {
                    note.setTextRole(role);
                }
                if (type != null) {
                    note.setTextType(type);
                }
                if (text != null) {
                    note.setStoredText(text);
                }
                try {
                    root.getNotes().add((Object)note);
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.addNoteTextStore(name, role, type, text);
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
                return (TextStoreInterface)this._repository.factoryProcess(note);
            }
        }
        return null;
    }

    @Override
    public void removeNoteTextStore(TextStoreInterface note) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                TextStore mtextstore = (TextStore)note.getRepositoryEntity();
                try {
                    root.getNotes().remove((Object)mtextstore);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeNoteTextStore(note);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void setNoteTextStores(List<TextStoreInterface> notes) throws ServiceException, RemoteException {
        if (notes == null) {
            return;
        }
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList noteList = root.getNotes();
                    noteList.clear();
                    for (TextStoreInterface note : notes) {
                        noteList.add((TextStore)note.getRepositoryEntity());
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.setNoteTextStores(notes);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public List<TextStoreInterface> getNoteTextStores() throws ServiceException, RemoteException {
        return this.getNoteTextStoresByRole(null);
    }

    @Override
    public List<TextStoreInterface> getNoteTextStoresByRole(String textRoleFilter) throws ServiceException, RemoteException {
        ArrayList<TextStoreInterface> results = new ArrayList<TextStoreInterface>();
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList textStores = root.getNotes();
                    for (TextStore textStore : textStores) {
                        if (textRoleFilter != null && !textRoleFilter.equalsIgnoreCase(textStore.getTextRole())) continue;
                        TextStoreInterface mi = (TextStoreInterface)this._repository.factoryProcess(textStore);
                        results.add(mi);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getNoteTextStoresByRole(textRoleFilter);
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return results;
    }

    @Override
    public TextStoreInterface getNoteTextStore(String name, String textRole) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList textStores = root.getNotes();
                    for (TextStore textStore : textStores) {
                        if (name != null && !name.equalsIgnoreCase(textStore.getName()) || textRole != null && !textRole.equalsIgnoreCase(textStore.getTextRole())) continue;
                        return (TextStoreInterface)this._repository.factoryProcess(textStore);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getNoteTextStore(name, textRole);
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    public void addGroup(GroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                Group mdoc = (Group)group.getRepositoryEntity();
                try {
                    AssociationList groupList = root.getGroups();
                    groupList.add(mdoc);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addGroup(group);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removeGroup(GroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                Group mdoc = (Group)group.getRepositoryEntity();
                try {
                    AssociationList groupList = root.getGroups();
                    groupList.remove(mdoc);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeGroup(group);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void setGroups(List groups) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList docList = root.getGroups();
                    docList.clear();
                    if (groups == null) break;
                    for (GroupInterface group : groups) {
                        Group mgroup = (Group)group.getRepositoryEntity();
                        docList.add(mgroup);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.setGroups(groups);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public List getGroups() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList docList = root.getGroups();
                    for (Group group : docList) {
                        MetadataInterface mi = this._repository.factoryProcess(group);
                        results.add(mi);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getGroups();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return results;
    }

    @Override
    public PropertyGroupInterface getPrimaryPropertyGroup() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    PropertyGroup group = root.getPrimaryPropertyGroup();
                    PropertyGroupInterface pgi = (PropertyGroupInterface)this._repository.factoryProcess(group);
                    return pgi;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    public void setPrimaryPropertyGroup(PropertyGroupInterface pgroup) throws ServiceException, RemoteException {
    }

    private boolean isOkToDeleteProperty(Property property) throws ServiceException, RemoteException {
        boolean answer = true;
        OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
        IdFilter filter = new IdFilter(this.getReposId());
        filter.setType(((Root)this._repositoryObject).getCMetadataType());
        int count = omirepos.getCountNoSecurity(filter, "AssociatedPropertySet");
        if (count > 0) {
            return false;
        }
        count = omirepos.getCountNoSecurity(filter, "AssociatedPropertyGroup");
        if (count > 0) {
            return false;
        }
        count = omirepos.getCountNoSecurity(filter, "AssociatedObject");
        if (count > 1) {
            return false;
        }
        return answer;
    }

    @Override
    public List getImplementors() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList implList = root.getImplementors();
                    if (implList.size() == 0) {
                        results = Collections.EMPTY_LIST;
                        break;
                    }
                    results = new ArrayList<MetadataInterface>(implList.size());
                    for (Object o : implList) {
                        MetadataInterface mi = this._repository.factoryProcess(o);
                        results.add(mi);
                    }
                    break;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return results;
    }

    @Override
    public void addImplementor(SoftwareComponentInterface softwareComponent) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    SoftwareComponent sc = (SoftwareComponent)softwareComponent.getRepositoryEntity();
                    root.getImplementors().add((Object)sc);
                    break;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removeImplementor(SoftwareComponentInterface softwareComponent) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    SoftwareComponent sc = (SoftwareComponent)softwareComponent.getRepositoryEntity();
                    root.getImplementors().remove((Object)sc);
                    break;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public MetadataInterface getUsingPrototype() throws ServiceException, RemoteException {
        this.checkPulse(true);
        MetadataInterface result = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    Root prototype = root.getUsingPrototype();
                    if (prototype == null) break;
                    result = this._repository.factoryProcess(prototype);
                    break;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public void setUsingPrototype(MetadataInterface prototype) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                Root proto = (Root)prototype.getRepositoryEntity();
                root.setUsingPrototype(proto);
            }
        }
    }

    @Override
    public List getUsedByPrototypes() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList protList = root.getUsedByPrototypes();
                    if (protList.size() == 0) {
                        results = Collections.EMPTY_LIST;
                        break;
                    }
                    results = new ArrayList<MetadataInterface>(protList.size());
                    for (Object o : protList) {
                        results.add(this._repository.factoryProcess(o));
                    }
                    break;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return results;
    }

    @Override
    public void addUsedByPrototype(MetadataInterface prototyped) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    Root proto = (Root)prototyped.getRepositoryEntity();
                    root.getUsedByPrototypes().add((Object)proto);
                    break;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removeUsedByPrototype(MetadataInterface prototyped) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    Root proto = (Root)prototyped.getRepositoryEntity();
                    root.getUsedByPrototypes().remove((Object)proto);
                    break;
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public List getPrompts() throws ServiceException, RemoteException {
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList promptList = root.getPrompts();
                    if (promptList.size() == 0) {
                        result = Collections.EMPTY_LIST;
                        break;
                    }
                    result = new ArrayList<MetadataInterface>(promptList.size());
                    for (Object o : promptList) {
                        result.add(this._repository.factoryProcess(o));
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getPrompts();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public void setPrompts(List prompts) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList promptList = root.getPrompts();
                    promptList.clear();
                    for (BaseOMRPromptInterface next : prompts) {
                        AbstractPrompt prompt = (AbstractPrompt)next.getRepositoryEntity();
                        promptList.add(prompt);
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.setPrompts(prompts);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void addPrompt(BaseOMRPromptInterface prompt) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList promptList = root.getPrompts();
                    promptList.add(prompt.getRepositoryEntity());
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addPrompt(prompt);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removePrompt(BaseOMRPromptInterface prompt) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList promptList = root.getPrompts();
                    promptList.remove(prompt.getRepositoryEntity());
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removePrompt(prompt);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public BaseOMRPromptInterface getPrompt() throws ServiceException, RemoteException {
        this.checkPulse(true);
        BaseOMRPromptInterface result = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList promptList = root.getPrompts();
                    if (promptList.size() == 0) {
                        result = null;
                        break;
                    }
                    result = (BaseOMRPromptInterface)this._repository.factoryProcess(promptList.get(0));
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getPrompt();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public void setPrompt(BaseOMRPromptInterface prompt) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (prompt.isPublic()) {
            throw new ServiceException(RB.getStringResource("Metadata.invalidsharedprompt.ex.txt"));
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Root root = (Root)this._repositoryObject;
                try {
                    AssociationList promptList = root.getPrompts();
                    promptList.clear();
                    AbstractPrompt cprompt = (AbstractPrompt)prompt.getRepositoryEntity();
                    promptList.add(cprompt);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.setPrompt(prompt);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void addProcessorInterface(String interfaceClassName, ProcessorInterface actionInterface) throws ServiceException {
        this.checkPulse(true);
        this._actionInterfaces.put(interfaceClassName, actionInterface);
    }

    @Override
    public ProcessorInterface getProcessorInterface(String interfaceClassName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        ProcessorInterface returnValue = null;
        Object action = this._actionInterfaces.get(interfaceClassName);
        if (action instanceof ProcessorInterface) {
            returnValue = (ProcessorInterface)action;
        }
        if (returnValue != null) {
            return returnValue;
        }
        if ("com.sas.services.information.publicobject.DetailsProcessorInterface".equals(interfaceClassName)) {
            returnValue = new DetailsProcessor(this);
            this.addProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface", returnValue);
        }
        if (DisplayProcessorInterface.class.getName().equals(interfaceClassName)) {
            returnValue = new DisplayAdapter(this);
            this.addProcessorInterface(DisplayProcessorInterface.class.getName(), returnValue);
        }
        if (SecurityProcessorInterface.class.getName().equals(interfaceClassName)) {
            returnValue = new SecurityAdapter(this);
            this.addProcessorInterface(SecurityProcessorInterface.class.getName(), returnValue);
        }
        return returnValue;
    }

    @Override
    public String getIdentifier() throws ServiceException, RemoteException {
        return this.getReposId();
    }

    @Override
    public PublicObjectContainerInterface getContainer() throws ServiceException, RemoteException {
        TypeDescriptorInterface tdi = this.getTypeDescriptor();
        if (tdi == null) {
            return null;
        }
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                String containerType = tdi.getContainerType();
                if (!FolderUtil.isFolder(containerType)) break;
                if ("Folder.Virtual".equalsIgnoreCase(containerType) && VirtualFolderManager.isContainedByVirtualFolder(tdi.getTypeName(), (OMIRepositoryInterface)this._repository)) {
                    VirtualFolderManager factory = VirtualFolderManager.getInstance(this._repository.getServer());
                    return factory.getOwningVirtualFolder(this);
                }
                return this.getParent();
            }
        }
        return null;
    }

    @Override
    public TypeDescriptorInterface getTypeDescriptor() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    PrimaryType root = (PrimaryType)this._repositoryObject;
                    String type = root.getPublicType();
                    if (type != null) {
                        if (type.startsWith("Embedded:")) {
                            type = type.substring(9);
                        }
                        TypeDescriptorInterface tdi = ((MetadataServerInterface)this._repository.getServer()).getTypeDescriptor(type);
                        return tdi;
                    }
                    break;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public URI getObjectURI() throws ServiceException {
        return null;
    }

    @Override
    public List getResponsibleParties() throws ServiceException, RemoteException {
        ArrayList<Responsibility> results = null;
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    Root root = (Root)this._repositoryObject;
                    AssociationList parties = root.getResponsibleParties();
                    if (parties.size() > 0) {
                        results = new ArrayList<Responsibility>(parties.size());
                        for (ResponsibleParty rsp : parties) {
                            String role = rsp.getRole();
                            if ("Created By".equalsIgnoreCase(role) || "Modified By".equalsIgnoreCase(role)) continue;
                            AssociationList identsList = rsp.getPersons();
                            Iterator idIt = identsList.iterator();
                            while (idIt.hasNext()) {
                                IdentityInterface ident = (IdentityInterface)this._repository.factoryProcess(idIt.next());
                                Responsibility r = new Responsibility(ident, role);
                                results.add(r);
                            }
                        }
                        break;
                    }
                    results = Collections.EMPTY_LIST;
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getResponsibleParties();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
            case 3: {
                results = Collections.EMPTY_LIST;
            }
        }
        return results;
    }

    @Override
    public void addResponsibleParty(Responsibility newResponsibility) throws ServiceException, RemoteException {
        this.checkPulse(true);
        String role = newResponsibility.getRole();
        IdentityInterface identity = newResponsibility.getPerson();
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    Root root = (Root)this._repositoryObject;
                    MdObjectStore ostore = (MdObjectStore)root.getObjectStore();
                    MdFactory factory = ostore.getFactory();
                    MdOMIUtil util = factory.getOMIUtil();
                    ResponsibleParty rpJoma = util.getResponsibleParty(ostore, newResponsibility.getPerson().getName(), newResponsibility.getRole());
                    AssociationList rpList = root.getResponsibleParties();
                    if (rpList.contains(rpJoma)) break;
                    root.getResponsibleParties().add((Object)rpJoma);
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.addResponsibleParty(newResponsibility);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removeResponsibleParty(Responsibility responsibility) throws ServiceException, RemoteException {
        this.checkPulse(true);
        String role = responsibility.getRole();
        IdentityInterface identity = responsibility.getPerson();
        block1 : switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    Root root = (Root)this._repositoryObject;
                    AssociationList parties = root.getResponsibleParties();
                    if (parties.size() <= 0) break;
                    Iterator assocIter = parties.iterator();
                    while (assocIter.hasNext()) {
                        ResponsibleParty rsp = (ResponsibleParty)assocIter.next();
                        String therole = rsp.getRole();
                        if (!therole.equalsIgnoreCase(role)) continue;
                        assocIter.remove();
                        break block1;
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeResponsibleParty(responsibility);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void removeResponsiblePartyByIdentity(Responsibility responsibility) throws ServiceException, RemoteException {
        this.checkPulse(true);
        String role = responsibility.getRole();
        IdentityInterface identity = responsibility.getPerson();
        String identityId = null;
        if (identity != null) {
            identityId = identity.getReposId();
        }
        block1 : switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    Root root = (Root)this._repositoryObject;
                    AssociationList parties = root.getResponsibleParties();
                    if (parties.size() <= 0) break;
                    Iterator assocIter = parties.iterator();
                    block6: while (assocIter.hasNext()) {
                        ResponsibleParty rsp = (ResponsibleParty)assocIter.next();
                        String therole = rsp.getRole();
                        if (!therole.equalsIgnoreCase(role)) continue;
                        AssociationList rpPersonList = rsp.getPersons(true);
                        if ((rpPersonList == null || rpPersonList.size() == 0) && identityId == null) {
                            assocIter.remove();
                            break block1;
                        }
                        if (identityId == null) continue;
                        for (Root nextRoot : rpPersonList) {
                            if (!nextRoot.getFQID().equals(identityId)) continue;
                            assocIter.remove();
                            continue block6;
                        }
                    }
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeResponsibleParty(responsibility);
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public boolean isCompatible() throws RemoteException {
        return this._isCompatible;
    }

    @Override
    public boolean isReadCompatible() throws RemoteException {
        return this._isReadCompatible;
    }

    @Override
    public UsageVersion getUsageVersion() throws RemoteException {
        UsageVersion result = null;
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                result = UsageVersion.decode((double)((Root)this._repositoryObject).getUsageVersion());
                break;
            }
        }
        return result;
    }

    protected void setCompatibility(UsageVersion oldestVersion, UsageVersion currentVersion) throws RemoteException {
        UsageVersion theversion = UsageVersion.decode((double)((Root)this._repositoryObject).getUsageVersion());
        if (theversion == null) {
            return;
        }
        this._isCompatible = theversion.isCompatible(oldestVersion, currentVersion);
        this._isReadCompatible = theversion.isReadCompatible(oldestVersion, currentVersion);
    }

    protected boolean isConnectionException(Throwable ex) {
        String mexMessage = ex.getMessage();
        return mexMessage != null && (mexMessage.indexOf(EX_MSG_EOFEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_SOCKETEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_CONNECTIONABORT) > -1) || this.ioExceptionInChain(ex);
    }

    private boolean ioExceptionInChain(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return true;
            }
            Throwable t = ex.getCause();
            if (t == ex) break;
            ex = t;
        }
        return false;
    }

    protected PropertyList getDefaultLocalizableProperties() {
        PropertyList list = new PropertyList();
        try {
            list.addProperty("Name", this.getName());
            list.addProperty("Description", this.getDescription());
        }
        catch (RemoteException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    protected void setDefaultLocalizableProperties(PropertyMap map) {
        try {
            if (map.containsProperty("Name")) {
                this.setName(map.getProperty("Name"));
            }
            if (map.containsProperty("Description")) {
                this.setDescription(map.getProperty("Description"));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    @Override
    public boolean isObjectAlive() throws ServiceException, RemoteException {
        RepositoryInterface ri = this._repository;
        switch (this._repositoryFlag) {
            case 2: {
                String fqid = this.getReposId();
                if (fqid == null) {
                    return false;
                }
                if (fqid != null && fqid.indexOf(".$") > -1) {
                    return true;
                }
                OMIRepositoryInterface omirepos = (OMIRepositoryInterface)this._repository;
                IdFilter filter = new IdFilter(fqid);
                String type = ((Root)this._repositoryObject).getCMetadataType();
                filter.setType(type);
                int count = omirepos.getCountNoSecurity(filter, "");
                return count > 0;
            }
        }
        try {
            BrowseMetadataInterface bmi = ri.browseFetch(this.getEntityKey(), null);
            if (bmi == null) {
                return false;
            }
        }
        catch (ServiceException ex) {
            return false;
        }
        return true;
    }

    protected void validateNameAndFolder(FolderInterface targetFolder) throws ServiceException, RemoteException {
        this.validateNameAndFolder(targetFolder, null);
    }

    protected void validateNameAndFolder(FolderInterface targetFolder, MetadataNameConstraint constraint) throws ServiceException, RemoteException {
        String oldName;
        String validName = oldName = this.getName();
        if (targetFolder != null && targetFolder.equals(this.getParent())) {
            targetFolder = null;
        }
        validName = FolderUtil.makeValidObjectName(targetFolder, this, constraint);
        boolean updateFlag = false;
        if (!oldName.equals(validName)) {
            String type;
            String oldPath;
            PathUrl oldPathUrl = this.getPathUrl();
            if (oldPathUrl != null) {
                oldPath = oldPathUrl.getDisplayPath();
                type = oldPathUrl.getType();
            } else {
                oldPath = this.getName();
                type = this.getType();
            }
            if (targetFolder != null) {
                Root cm = (Root)this._repositoryObject;
                try {
                    AssociationList parents = cm.getTrees();
                    parents.clear();
                }
                catch (MdException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), METADATA_CONTEXT, ex);
                }
            }
            this.setName(validName);
            if (targetFolder != null) {
                this.moveTo(targetFolder);
                this.logMessage(Level.WARN, Message.format((ResourceBundle)RB.getResources(), (String)"Metadata.RenameMoveObject.fmt.txt", (Object)type, (Object)oldPath, (Object)(targetFolder.getPathUrl().getDisplayPath() + SLASH + validName)));
            } else {
                this.logMessage(Level.WARN, Message.format((ResourceBundle)RB.getResources(), (String)"Metadata.RenameObject.fmt.txt", (Object)type, (Object)oldPath, (Object)validName));
            }
            updateFlag = true;
        } else if (targetFolder != null) {
            PathUrl oldPathUrl = this.getPathUrl();
            String type = oldPathUrl != null ? oldPathUrl.getType() : this.getType();
            this.moveTo(targetFolder);
            this.logMessage(Level.INFO, Message.format((ResourceBundle)RB.getResources(), (String)"Metadata.MoveObject.fmt.txt", (Object)type, (Object)oldName, (Object)targetFolder.getPathUrl().getDisplayPath()));
            updateFlag = true;
        }
        if (updateFlag) {
            this.update();
        }
    }

    @Override
    public AuthorizationUtilInterface getAuthorizationUtil() throws ServiceException, RemoteException {
        try {
            if (this.ObjectAuthorization == null) {
                this.ObjectAuthorization = new AuthorizationUtil(this, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.ObjectAuthorization;
    }

    static {
        for (int i = 0; i < formats.length; ++i) {
            formats[i].setTimeZone(gmtZone);
        }
    }
}

