/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.AccessControlEntryInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.VirtualMetadata;
import com.sas.services.security.PermissionInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVAccessControlEntry
extends VirtualMetadata
implements AccessControlEntryInterface {
    private static final long serialVersionUID = 3978710592670283056L;
    IdentityInterface _principal = null;
    List _permissions = null;
    boolean _inherited = false;
    boolean _protected = false;
    String _inheritedfrom = null;

    public DAVAccessControlEntry(IdentityInterface principal, List permissions, boolean isprotected, boolean isinherited) {
        this._principal = principal;
        this._permissions = permissions;
        this._inherited = isinherited;
        this._protected = isprotected;
    }

    public void setInheritedFrom(String inheritedfrom) throws IllegalStateException {
        if (!this._inherited) {
            throw new IllegalStateException();
        }
        this._inheritedfrom = inheritedfrom;
    }

    public String getInheritedFrom() {
        if (this._inherited) {
            return this._inheritedfrom;
        }
        return null;
    }

    @Override
    public void addPermission(PermissionInterface permission) throws ServiceException, RemoteException {
        if (!this._inherited && !this._protected) {
            this._permissions.add(permission);
        }
    }

    @Override
    public List getPermissions() throws ServiceException, RemoteException {
        return this._permissions;
    }

    @Override
    public void setIdentities(List identities) throws ServiceException, RemoteException {
    }

    @Override
    public void addIdentity(IdentityInterface identity) throws ServiceException, RemoteException {
    }

    @Override
    public void removePermission(PermissionInterface permission) throws ServiceException, RemoteException {
        if (!this._inherited && !this._protected) {
            Iterator items = this._permissions.iterator();
            while (items.hasNext()) {
                PermissionInterface p = (PermissionInterface)items.next();
                if (!p.equals(permission)) continue;
                items.remove();
            }
        }
    }

    @Override
    public void removeIdentity(IdentityInterface identity) throws ServiceException, RemoteException {
    }

    @Override
    public void setPermissions(List permissions) throws ServiceException, RemoteException {
        if (!this._inherited && !this._protected) {
            this._permissions = permissions;
        }
    }

    @Override
    public List getIdentities() throws ServiceException, RemoteException {
        ArrayList<IdentityInterface> identities = new ArrayList<IdentityInterface>();
        identities.add(this._principal);
        return identities;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public boolean isInherited() {
        return this._inherited;
    }

    @Override
    public List getAccessControlTemplates() throws ServiceException, RemoteException {
        return Collections.EMPTY_LIST;
    }
}

