/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.metadata.KeywordFilter;
import com.sas.services.util.XMLUtil;
import java.util.Iterator;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ChannelFilter
extends KeywordFilter {
    private static final long serialVersionUID = 5332742585854247340L;
    private String _name;
    private String _subject;
    private String _subscriber;
    private static final int SELECTBUFFER_INIT = 128;

    public ChannelFilter() {
        this._name = null;
        this._subject = null;
        this._subscriber = null;
        this.setType("Channel");
    }

    public ChannelFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("Channel");
        this._name = null;
        this._subscriber = null;
    }

    @Override
    public String getOMRType() {
        return "ITChannel";
    }

    public String getLDAPType() {
        return "saschannel";
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public String getSubscriber() {
        return this._subscriber;
    }

    public void setSubscriber(String subscriber) {
        this._subscriber = subscriber;
    }

    @Override
    public String getXMLSelectString() {
        String baseSelect = this.component2Select(this._component);
        if ("UNSUPPORTED".equals(baseSelect)) {
            return baseSelect;
        }
        StringBuffer buffer = new StringBuffer(128);
        if (this._name != null || this._keywords.size() > 0 || baseSelect.length() > 0) {
            buffer.append("<XMLSelect Search=\"*");
            if (this._name != null) {
                buffer.append("[@Name='");
                buffer.append(XMLUtil.normalize(this._name));
                buffer.append('\'');
                buffer.append(baseSelect.length() > 0 ? " and " + baseSelect : "");
                buffer.append(']');
            } else if (baseSelect.length() > 0) {
                buffer.append('[' + baseSelect + ']');
            }
            if (this._subscriber != null) {
                buffer.append("[ChannelSubscriptions/*[@Name='" + XMLUtil.normalize(this._subscriber) + "']");
            }
            if (this._keywords.size() > 0) {
                buffer.append("[Keywords/*[");
                Iterator it = this._keywords.iterator();
                boolean firstName = true;
                while (it.hasNext()) {
                    if (!firstName) {
                        buffer.append(" OR ");
                    }
                    buffer.append("@Name='" + XMLUtil.normalize((String)it.next()) + '\'');
                    firstName = false;
                }
                buffer.append(" ]]");
            }
            buffer.append("\" />\n");
        }
        return buffer.toString();
    }
}

