/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdAuthorizationBase;
import com.sas.metadata.remote.MdAuthorizationExplainedInfo;
import com.sas.metadata.remote.MdAuthorizationIdentityInfo;
import com.sas.metadata.remote.MdAuthorizationIdentityInfoImpl;
import com.sas.metadata.remote.MdAuthorizationInfo;
import com.sas.metadata.remote.MdAuthorizationInfoImpl;
import com.sas.metadata.remote.MdAuthorizationUtil;
import com.sas.metadata.remote.MdIndirectPermissionInfo;
import com.sas.metadata.remote.MdInheritanceInfo;
import com.sas.metadata.remote.MdPermissionExplainedInfo;
import com.sas.metadata.remote.MdPermissionInfo;
import com.sas.metadata.remote.MdPermissionInfoImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.AuthorizationExplainedInfo;
import com.sas.services.information.metadata.AuthorizationExplainedInfoInterface;
import com.sas.services.information.metadata.AuthorizationIdentityInfo;
import com.sas.services.information.metadata.AuthorizationIdentityInfoInterface;
import com.sas.services.information.metadata.AuthorizationInfo;
import com.sas.services.information.metadata.AuthorizationInfoInterface;
import com.sas.services.information.metadata.AuthorizationInheritanceInfo;
import com.sas.services.information.metadata.AuthorizationInheritanceInfoInterface;
import com.sas.services.information.metadata.AuthorizationUtilInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.IndirectPermissionInfo;
import com.sas.services.information.metadata.IndirectPermissionInfoInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PermissionExplainedInfoInterface;
import com.sas.services.information.metadata.PermissionInfo;
import com.sas.services.information.metadata.PermissionInfoInterface;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AuthorizationUtil
implements AuthorizationUtilInterface,
Serializable {
    private static final long serialVersionUID = -284406198236209461L;
    private MetadataInterface targetObject;
    private boolean actDef = false;

    public AuthorizationUtil(MetadataInterface obj, boolean actDef) {
        this.targetObject = obj;
        this.actDef = actDef;
    }

    @Override
    public boolean getCommitOnUpdate() throws ServiceException, RemoteException {
        try {
            if (this.actDef) {
                MdAuthorizationBase mdActDefAuth = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                return mdActDefAuth.getCommitOnUpdate();
            }
            MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
            return mdObjAuthUtil.getCommitOnUpdate();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void setCommitOnUpdate(boolean commitOnUpdate) throws ServiceException, RemoteException {
        try {
            if (this.actDef) {
                MdAuthorizationBase mdActDefAuth = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdActDefAuth.setCommitOnUpdate(commitOnUpdate);
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdObjAuthUtil.setCommitOnUpdate(commitOnUpdate);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<String> getApplicablePermissions() throws ServiceException, RemoteException {
        try {
            if (this.actDef) {
                MdAuthorizationBase mdActDefAuth = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                return mdActDefAuth.getApplicablePermissions();
            }
            MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
            return mdObjAuthUtil.getApplicablePermissions();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<AuthorizationIdentityInfoInterface> getIdentityInfo() throws ServiceException, RemoteException {
        try {
            List mdAuthIdentityInfoList = null;
            if (this.actDef) {
                MdAuthorizationBase mdActDefAuth = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdAuthIdentityInfoList = mdActDefAuth.getIdentityInfo();
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdAuthIdentityInfoList = mdObjAuthUtil.getIdentityInfo();
            }
            ArrayList<AuthorizationIdentityInfoInterface> authIdentityInfoList = new ArrayList<AuthorizationIdentityInfoInterface>(mdAuthIdentityInfoList.size());
            for (MdAuthorizationIdentityInfo mdAuthIdentityInfo : mdAuthIdentityInfoList) {
                authIdentityInfoList.add(this.buildAuthorizationIdentityInfo(mdAuthIdentityInfo));
            }
            return authIdentityInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public AuthorizationInfoInterface getAuthorizations(IdentityInterface identity, List<String> permissions) throws IllegalArgumentException, ServiceException, RemoteException {
        if (identity == null) {
            throw new IllegalArgumentException("A valid IdentityInterface object reference is required");
        }
        try {
            MdAuthorizationInfo mdAuthInfo = null;
            Identity mdIdentity = (Identity)identity.getRepositoryEntity();
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdAuthInfo = mdActDefUtil.getAuthorizations(mdIdentity, permissions);
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdAuthInfo = mdObjAuthUtil.getAuthorizations(mdIdentity, permissions);
            }
            return new AuthorizationInfo(new AuthorizationIdentityInfo(identity), this.buildPermissionInfoList(mdAuthInfo.getPermissionInfoList()));
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<AuthorizationInfoInterface> getAuthorizations(List<IdentityInterface> identities, List<String> permissions) throws ServiceException, RemoteException {
        if (identities == null) {
            identities = new ArrayList<IdentityInterface>(0);
        }
        if (permissions == null) {
            permissions = new ArrayList<String>(0);
        }
        try {
            ArrayList<Identity> mdIdentities = new ArrayList<Identity>(identities.size());
            for (IdentityInterface identity : identities) {
                Identity mdIdentity = (Identity)identity.getRepositoryEntity();
                mdIdentities.add(mdIdentity);
            }
            List mdAuthInfoList = null;
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdAuthInfoList = mdActDefUtil.getAuthorizations(mdIdentities, permissions);
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdAuthInfoList = mdObjAuthUtil.getAuthorizations(mdIdentities, permissions);
            }
            return this.buildAuthorizationInfoList(mdAuthInfoList);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<AuthorizationInfoInterface> getAuthorizationsAll() throws ServiceException, RemoteException {
        try {
            List mdAuthInfoList = null;
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdAuthInfoList = mdActDefUtil.getAuthorizationsAll();
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdAuthInfoList = mdObjAuthUtil.getAuthorizationsAll();
            }
            return this.buildAuthorizationInfoList(mdAuthInfoList);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public AuthorizationInheritanceInfoInterface getInheritanceInfo() throws ServiceException, RemoteException {
        AuthorizationInheritanceInfoInterface authInhInfo = null;
        try {
            if (!this.actDef) {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                MdInheritanceInfo mdAuthInheritanceInfo = mdObjAuthUtil.getInheritanceInfo();
                authInhInfo = this.buildAuthorizationInheritanceInfo(mdAuthInheritanceInfo);
            }
            return authInhInfo;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public AuthorizationExplainedInfoInterface getAuthorizationsExplained(IdentityInterface identity, List<String> permissions) throws IllegalArgumentException, ServiceException, RemoteException {
        if (identity == null) {
            throw new IllegalArgumentException("A valid IdentityInterface object reference is required");
        }
        if (permissions == null) {
            permissions = new ArrayList<String>(0);
        }
        Identity mdIdentity = null;
        MdAuthorizationExplainedInfo mdAuthExplInfo = null;
        try {
            mdIdentity = (Identity)identity.getRepositoryEntity();
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdAuthExplInfo = mdActDefUtil.getAuthorizationsExplained(mdIdentity, permissions);
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdAuthExplInfo = mdObjAuthUtil.getAuthorizationsExplained(mdIdentity, permissions);
            }
            return this.buildAuthorizationExplainedInfo(mdAuthExplInfo);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<AuthorizationExplainedInfoInterface> getAuthorizationsExplained(List<IdentityInterface> identities, List<String> permissions) throws ServiceException, RemoteException {
        if (identities == null) {
            identities = new ArrayList<IdentityInterface>(0);
        }
        if (permissions == null) {
            permissions = new ArrayList<String>(0);
        }
        try {
            ArrayList<Identity> mdIdentities = new ArrayList<Identity>(identities.size());
            for (IdentityInterface identity : identities) {
                Identity mdIdentity = (Identity)identity.getRepositoryEntity();
                mdIdentities.add(mdIdentity);
            }
            List mdAuthExplInfoList = null;
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdAuthExplInfoList = mdActDefUtil.getAuthorizationsExplained(mdIdentities, permissions);
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdAuthExplInfoList = mdObjAuthUtil.getAuthorizationsExplained(mdIdentities, permissions);
            }
            return this.buildAuthorizationExplainedInfoList(mdAuthExplInfoList);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<AuthorizationExplainedInfoInterface> getAuthorizationsExplainedAll() throws ServiceException, RemoteException {
        try {
            List mdAuthExplInfoList = null;
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdAuthExplInfoList = mdActDefUtil.getAuthorizationsExplainedAll();
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdAuthExplInfoList = mdObjAuthUtil.getAuthorizationsExplainedAll();
            }
            return this.buildAuthorizationExplainedInfoList(mdAuthExplInfoList);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void setAuthorizations(IdentityInterface identity, List<PermissionInfoInterface> permissionInfoList) throws IllegalArgumentException, ServiceException, RemoteException {
        if (identity == null) {
            throw new IllegalArgumentException("A valid IdentityInterface object reference is required");
        }
        if (permissionInfoList == null) {
            throw new IllegalArgumentException("A valid List object of PermissionInfoInterface references is required");
        }
        try {
            Identity mdIdentity = null;
            mdIdentity = (Identity)identity.getRepositoryEntity();
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdActDefUtil.setAuthorizations(mdIdentity, this.buildMdPermissionInfoList(permissionInfoList));
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdObjAuthUtil.setAuthorizations(mdIdentity, this.buildMdPermissionInfoList(permissionInfoList));
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void setAuthorizations(List<AuthorizationInfoInterface> authorizations) throws ServiceException, RemoteException {
        if (authorizations == null) {
            throw new IllegalArgumentException("A valid AuthorizationInfoInterface object reference is required");
        }
        try {
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdActDefUtil.setAuthorizations(this.buildMdAuthorizationInfoList(authorizations));
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdObjAuthUtil.setAuthorizations(this.buildMdAuthorizationInfoList(authorizations));
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<AccessControlTemplateInterface> getACTs() throws ServiceException, RemoteException {
        try {
            MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
            List mdActList = mdObjAuthUtil.getACTs();
            ArrayList<AccessControlTemplateInterface> actList = new ArrayList<AccessControlTemplateInterface>(mdActList.size());
            for (AccessControlTemplate mdAct : mdActList) {
                AccessControlTemplateInterface act = (AccessControlTemplateInterface)this.targetObject.getRepository().factoryProcess(mdAct);
                actList.add(act);
            }
            return actList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void applyACT(AccessControlTemplateInterface act) throws IllegalArgumentException, ServiceException, RemoteException {
        if (act == null) {
            throw new IllegalArgumentException("A valid AccessControlTemplateInterface object reference is required");
        }
        try {
            MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
            mdObjAuthUtil.applyACT((AccessControlTemplate)act.getRepositoryEntity());
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void removeACT(AccessControlTemplateInterface act) throws IllegalArgumentException, ServiceException, RemoteException {
        if (act == null) {
            throw new IllegalArgumentException("A valid AccessControlTemplateInterface object reference is required");
        }
        try {
            MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
            mdObjAuthUtil.removeACT((AccessControlTemplate)act.getRepositoryEntity());
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void commit() throws ServiceException, RemoteException {
        try {
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdActDefUtil.commit();
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdObjAuthUtil.commit();
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void discard() throws ServiceException, RemoteException {
        try {
            if (this.actDef) {
                MdAuthorizationBase mdActDefUtil = ((AccessControlTemplate)this.targetObject.getRepositoryEntity()).getAuthorizationDefinitionUtil();
                mdActDefUtil.discard();
            } else {
                MdAuthorizationUtil mdObjAuthUtil = ((CMetadata)this.targetObject.getRepositoryEntity()).getAuthorizationUtil();
                mdObjAuthUtil.discard();
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private List<AuthorizationInfoInterface> buildAuthorizationInfoList(List<MdAuthorizationInfo> mdAuthInfoList) throws ServiceException, RemoteException {
        try {
            ArrayList<AuthorizationInfoInterface> authInfoList = new ArrayList<AuthorizationInfoInterface>(mdAuthInfoList.size());
            for (MdAuthorizationInfo mdAuthInfo : mdAuthInfoList) {
                authInfoList.add(this.buildAuthorizationInfo(mdAuthInfo));
            }
            return authInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private AuthorizationInfoInterface buildAuthorizationInfo(MdAuthorizationInfo mdAuthInfo) throws ServiceException, RemoteException {
        try {
            AuthorizationInfo authInfo = new AuthorizationInfo();
            authInfo.setIdentityInfo(this.buildAuthorizationIdentityInfo(mdAuthInfo.getIdentityInfo()));
            authInfo.setPermissionInfoList(this.buildPermissionInfoList(mdAuthInfo.getPermissionInfoList()));
            return authInfo;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private AuthorizationIdentityInfoInterface buildAuthorizationIdentityInfo(MdAuthorizationIdentityInfo mdAuthIdenityInfo) throws ServiceException, RemoteException {
        try {
            IdentityInterface identity = (IdentityInterface)this.targetObject.getRepository().factoryProcess(mdAuthIdenityInfo.getIdentity());
            return new AuthorizationIdentityInfo(identity, mdAuthIdenityInfo.isNew(), mdAuthIdenityInfo.isDirect(), mdAuthIdenityInfo.isInherited(), mdAuthIdenityInfo.isInUnrestricedRole(), mdAuthIdenityInfo.isInUserAdminsRole(), mdAuthIdenityInfo.isInOperatorsRole());
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private List<PermissionInfoInterface> buildPermissionInfoList(List<MdPermissionInfo> mdPermInfoList) throws ServiceException, RemoteException {
        try {
            ArrayList<PermissionInfoInterface> permInfoList = new ArrayList<PermissionInfoInterface>(mdPermInfoList.size());
            for (MdPermissionInfo mdPermInfo : mdPermInfoList) {
                PermissionInfoInterface.PermissionSource PermSource;
                PermissionInfoInterface.PermissionType permType;
                PermissionInfo permInfo = new PermissionInfo();
                permInfo.setPermission(mdPermInfo.getPermission());
                switch (mdPermInfo.getPermissionType()) {
                    case GRANT: {
                        permType = PermissionInfoInterface.PermissionType.GRANT;
                        break;
                    }
                    case DENY: {
                        permType = PermissionInfoInterface.PermissionType.DENY;
                        break;
                    }
                    case REMOVE: {
                        permType = PermissionInfoInterface.PermissionType.REMOVE;
                        break;
                    }
                    default: {
                        throw new ServiceException("Incorrect MdPermissionInfo PermissionType: " + mdPermInfo.getPermissionType());
                    }
                }
                permInfo.setPermissionType(permType);
                switch (mdPermInfo.getPermissionSource()) {
                    case EXPLICIT: {
                        PermSource = PermissionInfoInterface.PermissionSource.EXPLICIT;
                        break;
                    }
                    case ACT: {
                        PermSource = PermissionInfoInterface.PermissionSource.ACT;
                        break;
                    }
                    case INDIRECT: {
                        PermSource = PermissionInfoInterface.PermissionSource.INDIRECT;
                        break;
                    }
                    default: {
                        throw new ServiceException("Incorrect MdPermInfo PermissionSource: " + mdPermInfo.getPermissionSource());
                    }
                }
                permInfo.setPermissionSource(PermSource);
                permInfo.setPermissionCondition(mdPermInfo.getPermissionCondition());
                permInfoList.add(permInfo);
            }
            return permInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private List<AuthorizationExplainedInfoInterface> buildAuthorizationExplainedInfoList(List<MdAuthorizationExplainedInfo> mdAuthExplInfoList) throws ServiceException, RemoteException {
        try {
            ArrayList<AuthorizationExplainedInfoInterface> authExplInfoList = new ArrayList<AuthorizationExplainedInfoInterface>(mdAuthExplInfoList.size());
            for (MdAuthorizationExplainedInfo mdAuthExplInfo : mdAuthExplInfoList) {
                authExplInfoList.add(this.buildAuthorizationExplainedInfo(mdAuthExplInfo));
            }
            return authExplInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private AuthorizationExplainedInfoInterface buildAuthorizationExplainedInfo(MdAuthorizationExplainedInfo mdAuthExplInfo) throws ServiceException, RemoteException {
        try {
            AuthorizationExplainedInfo authExplInfo = mdAuthExplInfo == null ? null : new AuthorizationExplainedInfo(this.buildAuthorizationIdentityInfo(mdAuthExplInfo.getIdentityInfo()), this.buildPermissionExplainedInfoList(mdAuthExplInfo.getPermissionExplainedInfoList()));
            return authExplInfo;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private List<PermissionExplainedInfoInterface> buildPermissionExplainedInfoList(List<MdPermissionExplainedInfo> mdPermExplInfoList) throws ServiceException, RemoteException {
        try {
            ArrayList<PermissionExplainedInfoInterface> permExplInfoList = new ArrayList<PermissionExplainedInfoInterface>(mdPermExplInfoList.size());
            for (MdPermissionExplainedInfo mdPermExplInfo : mdPermExplInfoList) {
                PermissionInfoInterface.PermissionSource PermSource;
                PermissionInfoInterface.PermissionType permType;
                PermissionInfo permExplInfo = new PermissionInfo();
                permExplInfo.setPermission(mdPermExplInfo.getPermission());
                switch (mdPermExplInfo.getPermissionType()) {
                    case GRANT: {
                        permType = PermissionInfoInterface.PermissionType.GRANT;
                        break;
                    }
                    case DENY: {
                        permType = PermissionInfoInterface.PermissionType.DENY;
                        break;
                    }
                    default: {
                        throw new ServiceException("Incorrect MdPermissionExplainedInfo PermissionType: " + mdPermExplInfo.getPermissionType());
                    }
                }
                permExplInfo.setPermissionType(permType);
                switch (mdPermExplInfo.getPermissionSource()) {
                    case EXPLICIT: {
                        PermSource = PermissionInfoInterface.PermissionSource.EXPLICIT;
                        break;
                    }
                    case ACT: {
                        PermSource = PermissionInfoInterface.PermissionSource.ACT;
                        break;
                    }
                    case INDIRECT: {
                        PermSource = PermissionInfoInterface.PermissionSource.INDIRECT;
                        break;
                    }
                    default: {
                        throw new ServiceException("Incorrect MdPermissionExplainedInfo PermissionSource: " + mdPermExplInfo.getPermissionSource());
                    }
                }
                permExplInfo.setPermissionSource(PermSource);
                permExplInfo.setPermissionCondition(mdPermExplInfo.getPermissionCondition());
                List mdNdirPermInfoList = mdPermExplInfo.getIndirectPermissionInfo();
                permExplInfo.setIndirectPermissionInfo(this.buildIndirectPermissionInfoList(mdNdirPermInfoList));
                permExplInfoList.add(permExplInfo);
            }
            return permExplInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private List<IndirectPermissionInfoInterface> buildIndirectPermissionInfoList(List<MdIndirectPermissionInfo> mdNdirPermInfoList) throws ServiceException, RemoteException {
        if (mdNdirPermInfoList == null) {
            return null;
        }
        try {
            ArrayList<IndirectPermissionInfoInterface> ndirPermInfoList = new ArrayList<IndirectPermissionInfoInterface>(mdNdirPermInfoList.size());
            for (MdIndirectPermissionInfo mdNdirPermInfo : mdNdirPermInfoList) {
                IndirectPermissionInfoInterface.IndirectPermissionSource ndirPermSource;
                IndirectPermissionInfoInterface.IndirectPermissionType ndirPermType;
                IndirectPermissionInfo ndirPermInfo = new IndirectPermissionInfo();
                MetadataInterface ndirObj = this.targetObject.getRepository().factoryProcess(mdNdirPermInfo.getIndirectObject());
                ndirPermInfo.setIndirectObject(ndirObj);
                switch (mdNdirPermInfo.getIndirectPermissionType()) {
                    case GRANT: {
                        ndirPermType = IndirectPermissionInfoInterface.IndirectPermissionType.GRANT;
                        break;
                    }
                    case DENY: {
                        ndirPermType = IndirectPermissionInfoInterface.IndirectPermissionType.DENY;
                        break;
                    }
                    default: {
                        throw new ServiceException("Incorrect MdIndirectPermissionInfo PermissionType: " + mdNdirPermInfo.getIndirectPermissionType());
                    }
                }
                ndirPermInfo.setIndirectPermissionType(ndirPermType);
                switch (mdNdirPermInfo.getIndirectPermissionSource()) {
                    case ACTSPECIFICATION: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.ACTSPECIFICATION;
                        break;
                    }
                    case GRPMBRSHIP: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.GRPMBRSHIP;
                        break;
                    }
                    case INHERITED: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.INHERITED;
                        break;
                    }
                    case EXPLICT_ON_PARENT: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.EXPLICT_ON_PARENT;
                        break;
                    }
                    case GROUP_ON_PARENT: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.GROUP_ON_PARENT;
                        break;
                    }
                    case ACT_ON_PARENT: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.ACT_ON_PARENT;
                        break;
                    }
                    case REPOSITORY_DEFAULT_ACT: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.REPOSITORY_DEFAULT_ACT;
                        break;
                    }
                    case HIDDEN_PARENT: {
                        ndirPermSource = IndirectPermissionInfoInterface.IndirectPermissionSource.HIDDEN_PARENT;
                        break;
                    }
                    default: {
                        throw new ServiceException("Incorrect MdIndirectPermissionInfo PermissionSource: " + mdNdirPermInfo.getIndirectPermissionSource());
                    }
                }
                ndirPermInfo.setIndirectPermissionSource(ndirPermSource);
                ndirPermInfo.setIndirectPermissionCondition(mdNdirPermInfo.getIndirectPermissionCondition());
                ndirPermInfo.setIndirectPermissionInfo(this.buildIndirectPermissionInfoList(mdNdirPermInfo.getIndirectPermissionInfo()));
                ndirPermInfoList.add(ndirPermInfo);
            }
            return ndirPermInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private List<MdAuthorizationInfo> buildMdAuthorizationInfoList(List<AuthorizationInfoInterface> authorizations) throws ServiceException, RemoteException {
        try {
            ArrayList<MdAuthorizationInfo> mdAuthInfoList = new ArrayList<MdAuthorizationInfo>(authorizations.size());
            for (AuthorizationInfoInterface authInfo : authorizations) {
                MdAuthorizationInfoImpl mdAuthInfo = new MdAuthorizationInfoImpl();
                mdAuthInfo.setIdentityInfo((MdAuthorizationIdentityInfo)new MdAuthorizationIdentityInfoImpl((Identity)authInfo.getIdentityInfo().getIdentity().getRepositoryEntity()));
                mdAuthInfo.setPermissionInfoList(this.buildMdPermissionInfoList(authInfo.getPermissionInfoList()));
                mdAuthInfoList.add((MdAuthorizationInfo)mdAuthInfo);
            }
            return mdAuthInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private List<MdPermissionInfo> buildMdPermissionInfoList(List<PermissionInfoInterface> permInfoList) throws ServiceException, RemoteException {
        try {
            ArrayList<MdPermissionInfo> MdPermInfoList = new ArrayList<MdPermissionInfo>(permInfoList.size());
            for (PermissionInfoInterface permInfo : permInfoList) {
                MdPermissionInfo.PermissionType mdPermType;
                MdPermissionInfoImpl MdPermInfo = new MdPermissionInfoImpl();
                MdPermInfo.setPermission(permInfo.getPermission());
                switch (permInfo.getPermissionType()) {
                    case GRANT: {
                        mdPermType = MdPermissionInfo.PermissionType.GRANT;
                        break;
                    }
                    case DENY: {
                        mdPermType = MdPermissionInfo.PermissionType.DENY;
                        break;
                    }
                    case REMOVE: {
                        mdPermType = MdPermissionInfo.PermissionType.REMOVE;
                        break;
                    }
                    default: {
                        throw new ServiceException("Incorrect PermissionInfoInterface PermissionType: " + (Object)((Object)permInfo.getPermissionType()));
                    }
                }
                MdPermInfo.setPermissionType(mdPermType);
                MdPermInfo.setPermissionCondition(permInfo.getPermissionCondition());
                MdPermInfoList.add((MdPermissionInfo)MdPermInfo);
            }
            return MdPermInfoList;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private AuthorizationInheritanceInfoInterface buildAuthorizationInheritanceInfo(MdInheritanceInfo mdAuthInheritanceInfo) throws ServiceException, RemoteException {
        try {
            AuthorizationInheritanceInfo authInheritanceInfo = new AuthorizationInheritanceInfo(mdAuthInheritanceInfo.IsHidden(), this.targetObject.getRepository().factoryProcess(mdAuthInheritanceInfo.getObject()), mdAuthInheritanceInfo.HasDirectPermissions(), mdAuthInheritanceInfo.getInheritanceRoleName());
            ArrayList<AuthorizationInheritanceInfoInterface> authInheritanceInfoList = new ArrayList<AuthorizationInheritanceInfoInterface>(mdAuthInheritanceInfo.getNextLevelParents().size());
            authInheritanceInfo.nextLevelObjList = authInheritanceInfoList;
            authInheritanceInfo.inheritanceRules = new ArrayList<String>(mdAuthInheritanceInfo.getInheritanceRules());
            if (mdAuthInheritanceInfo.HasNextLevelParents()) {
                List mdAuthInheritanceInfoList = mdAuthInheritanceInfo.getNextLevelParents();
                for (MdInheritanceInfo mdAuthInheritanceInfoParent : mdAuthInheritanceInfoList) {
                    authInheritanceInfoList.add(this.buildAuthorizationInheritanceInfo(mdAuthInheritanceInfoParent));
                }
            }
            return authInheritanceInfo;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

