/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.MdFactoryListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.cache.CacheStatistics;
import com.sas.services.cache.impl.BaseCacheStatistics;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.ACTEntry;
import com.sas.services.information.AuthResult;
import com.sas.services.information.ChildRepositoryInterface;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Factory;
import com.sas.services.information.FactoryException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.FilterNotSupportedException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.InformationServiceTimerClient;
import com.sas.services.information.MetadataChangeEvent;
import com.sas.services.information.MetadataChangeListener;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.PartialFolderResultsException;
import com.sas.services.information.PartialListResultsException;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryEvent;
import com.sas.services.information.RepositoryInfo;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import com.sas.services.information.RepositoryUrlMismatchException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.TreeSearchFilter;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.EmbeddedObjectInterface;
import com.sas.services.information.metadata.FilteredFolder;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathFilter;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RepositoryMetadata;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.rules.EvaluatorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.URIUtil;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class OMIServerRepository
extends UnicastRemoteObject
implements OMIRepositoryInterface,
MdObjectListener,
MetadataChangeListener,
InformationServiceTimerClient {
    private static final long serialVersionUID = 7501942435455996838L;
    public static final String ROOT_CLASSIDENTIFIER = "E5F27790-2149-11D6-8828-AA0004006D06";
    public static final String BIP_COMPONENTNAME = "BIP Service";
    public static final String BIP_ROOTNAME = "BIP Tree";
    private static InformationServiceInterface _is;
    private static final int COLLECTION_INIT = 8;
    protected String _url = "omi://";
    private String _principal = null;
    private String _password = null;
    protected String _defaultRepository = null;
    protected String _defaultName;
    protected String _defaultId;
    protected String _desc;
    protected String _path;
    protected String _access;
    protected String _engine;
    protected String _options;
    protected String _effectiveAccess;
    protected String _format;
    protected String _state;
    protected Date _metadataCreated;
    protected Date _metadataUpdated;
    private String _isName = null;
    private UserContextInterface _user;
    protected boolean _isConnected = false;
    private ArrayList _listeners = new ArrayList(8);
    protected boolean _isDestroyed = false;
    protected String _subNum = "0";
    private boolean _reconnecting = false;
    protected String _myType = null;
    private List children = new ArrayList(8);
    private List parents = new ArrayList(8);
    private List projectRepositories = new ArrayList(8);
    private String _uniqueId = null;
    private long _folderItemRefreshInterval = -1L;
    private long _folderSubfolderRefreshInterval = -1L;
    private long _metadataParentRefreshInterval = -1L;
    private Exception closeStack = null;
    private List _permissionList = null;
    private List _propertyTypeList = null;
    protected MetadataServerInterface _omiServer = null;
    private static final int TESTLIST_INIT = 5;

    public static InformationServiceInterface getInformationService() {
        if (_is != null) {
            try {
                boolean isDeactive = ServiceState.isStateDeactivated(_is.getServiceState());
                if (isDeactive) {
                    _is = null;
                }
            }
            catch (RemoteException rex) {
                _is = null;
            }
        }
        if (_is == null) {
            LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
            try {
                _is = (InformationServiceInterface)discoveryService.findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
            }
            catch (ServiceException t) {
                _is = null;
            }
            catch (RemoteException e) {
                _is = null;
            }
        }
        return _is;
    }

    public static void clearInformationService() {
        _is = null;
    }

    public OMIServerRepository() throws RemoteException {
        this(OMIServerRepository.class);
    }

    protected OMIServerRepository(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
        this.getUniqueId();
    }

    OMIServerRepository(OMIServer server, String defaultBase) throws ServiceException, RemoteException {
        this();
        this._defaultName = defaultBase;
        this._defaultRepository = server.getRepositoryId(defaultBase);
        this._defaultId = this._defaultRepository.substring(9);
        this._isConnected = true;
        this._isDestroyed = false;
        this._user = server.getUserContext();
        this._omiServer = server;
        List infoList = server.getRepositoryInfo();
        for (RepositoryInfo nextInfo : infoList) {
            if (!this._defaultName.equals(nextInfo.getName())) continue;
            this.populateAttributes(nextInfo.getFqid(), nextInfo.getName(), nextInfo.getType(), nextInfo.getDescription(), nextInfo.getPath(), nextInfo.getEngine(), nextInfo.getOptions(), nextInfo.getAccess(), nextInfo.getEffectiveAccess(), nextInfo.getFormat(), nextInfo.getState(), nextInfo.getMetadataCreated(), nextInfo.getMetadataUpdated());
        }
        try {
            this._url = server.getUrl() + "/" + URLEncoder.encode(defaultBase, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setUserContext(UserContextInterface user) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (user == null) {
            return;
        }
        this._user = user;
    }

    @Override
    public UserContextInterface getUserContext() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._user;
    }

    @Override
    public void setUser(PersonInterface person) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
    }

    @Override
    public void setISName(String name) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (name != null && name.length() > 0) {
            this._isName = name;
        }
    }

    @Override
    public String getISName() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (this._isName != null) {
            return this._isName;
        }
        InformationServiceInterface is = OMIServerRepository.getInformationService();
        List defs = is.getReposDefs();
        Iterator it = defs.iterator();
        String host = null;
        String port = null;
        try {
            host = this._omiServer.getHost();
            port = String.valueOf(this._omiServer.getPort());
        }
        catch (ServiceException ex) {
            host = "";
            port = "";
        }
        String defaultRepository = this._defaultRepository;
        while (it.hasNext()) {
            RepositoryDef rd = (RepositoryDef)it.next();
            if (this.isEqual(rd)) {
                this._isName = rd.getName();
                return rd.getName();
            }
            boolean host_match = false;
            try {
                InetAddress myAddress = InetAddress.getByName(host);
                InetAddress hisAddress = InetAddress.getByName(rd.getHost());
                host_match = myAddress.equals(hisAddress);
            }
            catch (UnknownHostException uhe) {
                host_match = host.equalsIgnoreCase(rd.getHost());
            }
            if (!rd.getProtocol().equalsIgnoreCase("omi") || !host_match || !rd.getPort().equals(port)) continue;
            if (this._defaultRepository == null) {
                this._isName = rd.getName();
                return rd.getName();
            }
            if (!rd.getBase().equalsIgnoreCase(defaultRepository) && (this._defaultName == null || !rd.getBase().equalsIgnoreCase(this._defaultName))) continue;
            this._isName = rd.getName();
            return rd.getName();
        }
        if (this._omiServer != null) {
            this._isName = this._omiServer.getName() + "." + this._defaultName;
            return this._isName;
        }
        return null;
    }

    @Override
    public PersonInterface getUser() throws RemoteException {
        try {
            this.pulseCheck();
            return this._omiServer.getPerson();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
    }

    @Override
    public IdentityInterface getIdentity() throws ServiceException, RemoteException {
        return this._omiServer.getIdentity();
    }

    @Override
    public IOMI getIOMI() throws IllegalStateException, RemoteException {
        return null;
    }

    @Override
    public ISecurity getISecurity() throws IllegalStateException, RemoteException {
        return null;
    }

    @Override
    public boolean connect(IOMI connection, String base) throws ServiceException, RemoteException {
        throw new ServiceException("Don't do that.");
    }

    @Override
    public synchronized boolean connectWithProxy(String host, int port, String id, String password, String base, String proxy, boolean isSecure) throws ServiceException, RemoteException {
        throw new ServiceException("Don't do that.");
    }

    @Override
    public boolean connect(String user, String password, RepositoryDef config) throws ServiceException, RemoteException {
        String host = config.getHost();
        int port = Integer.parseInt(config.getPort());
        String base = config.getBase();
        return this.connect(host, port, user, password, base);
    }

    @Override
    public synchronized boolean connect(String host, int port, String id, String password, String base) throws ServiceException, RemoteException {
        throw new ServiceException("Don't do that.");
    }

    protected void finalize() throws RemoteException {
        try {
            this.close();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._url;
    }

    @Override
    public void close() throws RemoteException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close(boolean notify) throws RemoteException {
        if (this._isDestroyed) {
            return;
        }
        this.closeStack = new Exception();
        String host = null;
        String port = null;
        try {
            host = this._omiServer.getHost();
            port = String.valueOf(this._omiServer.getPort());
        }
        catch (ServiceException ex) {
            host = "";
            port = "";
        }
        this._omiServer.info("com.sas.services.information.OMIRepository." + this._subNum, RB.getResources(), "OMIRepository.closing.ex.fmt", host, port, null);
        InformationServiceInterface is = OMIServerRepository.getInformationService();
        if (is != null) {
            try {
                is.removeInformationServiceTimerClient(this);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        this._isDestroyed = true;
        if (!this._reconnecting) {
            this._user = null;
        }
        if (this._url != null && (is = OMIServerRepository.getInformationService()) != null) {
            try {
                is.removeMetadataChangeListener(this, this._url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._isConnected = false;
        if (this._listeners != null) {
            if (notify) {
                this.notifyListeners(3);
            }
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.clear();
                this._listeners = null;
            }
        }
        if (!this._reconnecting) {
            this._omiServer = null;
            this._user = null;
            this.children = null;
            this.parents = null;
            this.projectRepositories = null;
            this._url = null;
            this._subNum = null;
            this._password = null;
            try {
                OMIServerRepository.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    @Override
    public MetadataInterface newMetadata(String reposId, String name, String type) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (reposId == null) {
            reposId = this._defaultRepository;
        }
        return this._omiServer.newMetadata(reposId, name, type);
    }

    @Override
    public MetadataInterface newMetadata(MetadataInterface model, String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.newMetadataByModel(model, name);
    }

    @Override
    public MetadataInterface newMetadataByModel(MetadataInterface model, String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            com.sas.metadata.Root root = (com.sas.metadata.Root)model.getRepositoryEntity();
            return this.newMetadata(root.getRepositoryID(), name, root.getCMetadataType());
        }
        catch (ClassCastException cce) {
            try {
                Root root = (Root)model.getRepositoryEntity();
                return this.newMetadata(root.getRepositoryID(), name, root.getCMetadataType());
            }
            catch (ClassCastException cce2) {
                throw new ServiceException(RB.getStringResource("OMIRepository.newwrongtyp.ex.txt"));
            }
        }
    }

    @Override
    public synchronized MetadataInterface fetch(String repositoryKey) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.fetch(repositoryKey, false);
    }

    @Override
    public MetadataInterface fetchByUrl(String entityURL, boolean bypassCache) throws ServiceException, RemoteException {
        URI entityURI = null;
        try {
            entityURI = new URI(entityURL);
        }
        catch (URISyntaxException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        String scheme = entityURI.getScheme().toLowerCase();
        if (!"sas-oma".equals(scheme)) {
            throw new RepositoryUrlMismatchException();
        }
        String host = entityURI.getHost();
        if (!host.equals(this._omiServer.getHost())) {
            throw new RepositoryUrlMismatchException();
        }
        int port = entityURI.getPort();
        if (port != this._omiServer.getPort()) {
            throw new RepositoryUrlMismatchException();
        }
        String path = entityURI.getPath();
        return this.fetch(path, bypassCache);
    }

    @Override
    public MetadataInterface fetch(String repositoryKey, boolean bypassCache) throws ServiceException, RemoteException {
        return this._omiServer.fetch(repositoryKey, bypassCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List search(FilterInterface filter) throws ServiceException, RemoteException {
        String repository = filter.getOMRRepository();
        String origRepository = filter.getOMRRepository();
        if (repository == null) {
            filter.setOMRRepository(this._defaultRepository);
        }
        List results = null;
        try {
            results = this._omiServer.search(filter);
        }
        finally {
            filter.setOMRRepository(origRepository);
        }
        return results;
    }

    public void updateEntity(Object reposId, Object input) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            CMetadata cm = (CMetadata)input;
            cm.updateMetadataAll();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMIRepository.updateexcept.msg.txt"));
        }
    }

    @Override
    public void deleteEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.pulseCheck();
        this._omiServer.deleteEntity(input);
    }

    @Override
    public void deleteEntity(CMetadata metadata) throws ServiceException, RemoteException {
        this.pulseCheck();
        this._omiServer.deleteEntity(metadata);
    }

    @Override
    public void deleteEntities(List metadataObjects) throws ServiceException, RemoteException {
        this.pulseCheck();
        this._omiServer.deleteEntities(metadataObjects);
    }

    @Override
    public void addEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.pulseCheck();
        this.updateEntity(input.getReposId(), input.getRepositoryEntity());
    }

    @Override
    public String getUrl() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._url;
    }

    @Override
    public String getDomain() throws RemoteException {
        try {
            this.pulseCheck();
            return this._omiServer.getDomain();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
    }

    @Override
    public void setDomain(String domain) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
    }

    @Override
    public boolean isEqual(Object o) throws RemoteException {
        block17: {
            int portInt;
            String host;
            try {
                this.pulseCheck();
                host = this._omiServer.getHost();
                portInt = this._omiServer.getPort();
            }
            catch (ServiceException svcEx) {
                return false;
            }
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            try {
                String otherBase;
                RepositoryDef r;
                block18: {
                    if (o instanceof OMIServerRepository) {
                        block16: {
                            OMIServerRepository l = (OMIServerRepository)o;
                            try {
                                InetAddress myAddress = InetAddress.getByName(host);
                                InetAddress hisAddress = InetAddress.getByName(l.getHost());
                                if (!myAddress.equals(hisAddress) || portInt != l.getPort()) {
                                    return false;
                                }
                            }
                            catch (UnknownHostException uhe) {
                                if (host.equalsIgnoreCase(l.getHost()) && portInt == l.getPort()) break block16;
                                return false;
                            }
                        }
                        return true;
                    }
                    if (!(o instanceof RepositoryDef)) break block17;
                    r = (RepositoryDef)o;
                    String protocol = r.getProtocol();
                    if (protocol == null) {
                        return false;
                    }
                    if (!protocol.equalsIgnoreCase("omi")) {
                        return false;
                    }
                    try {
                        InetAddress myAddress = InetAddress.getByName(host);
                        InetAddress hisAddress = InetAddress.getByName(r.getHost());
                        if (!myAddress.equals(hisAddress)) {
                            return false;
                        }
                    }
                    catch (UnknownHostException uhe) {
                        if (host.equalsIgnoreCase(r.getHost()) && portInt == Integer.parseInt(r.getPort())) break block18;
                        return false;
                    }
                }
                if (portInt != Integer.valueOf(r.getPort())) {
                    return false;
                }
                return !(this._defaultRepository == null ? r.getBase() != null : !this._defaultName.equalsIgnoreCase(otherBase = r.getBase()) && !this._defaultId.equals(otherBase));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public String getHost() throws RemoteException {
        try {
            this.pulseCheck();
            return this._omiServer.getHost();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
    }

    @Override
    public int getPort() throws RemoteException {
        try {
            this.pulseCheck();
            return this._omiServer.getPort();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
    }

    @Override
    public String getBase() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._defaultRepository;
    }

    @Override
    public String getPrincipal() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._principal;
    }

    @Override
    public List getRepositories() throws ServiceException, RemoteException {
        ArrayList<RepositoryMetadata> results = new ArrayList<RepositoryMetadata>(5);
        List reposInfoList = this._omiServer.getRepositoryInfo();
        for (RepositoryInfo nextInfo : reposInfoList) {
            RepositoryMetadata rm = new RepositoryMetadata(nextInfo.getName(), nextInfo.getFqid());
            results.add(rm);
        }
        return results;
    }

    @Override
    public MetadataInterface getTrackedObject(int trackingId) throws RemoteException {
        return null;
    }

    @Override
    public Object narrow(RepositoryData entity) throws ServiceException, RemoteException {
        return entity;
    }

    @Override
    public void addRootFolder(FolderInterface folder) throws ServiceException, RemoteException {
        this.pulseCheck();
        throw new ServiceException(RB.getStringResource("OMIServerRepository.noroots.ex.txt"));
    }

    @Override
    public FolderInterface removeRootFolder(String folderName) throws ServiceException, RemoteException {
        this.pulseCheck();
        throw new ServiceException(RB.getStringResource("OMIServerRepository.noroots.ex.txt"));
    }

    @Override
    public FolderInterface makeRootFolder(String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        throw new ServiceException(RB.getStringResource("OMIServerRepository.noroots.ex.txt"));
    }

    @Override
    public FolderInterface getRootFolder(String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        if ("FOUNDATION".equals(this._myType)) {
            if (name == null) {
                name = BIP_ROOTNAME;
            }
            RootFolderInterface root = this._omiServer.getRootFolder();
            return root.getSubfolder(name);
        }
        if (name == null) {
            name = this._defaultName;
        }
        List rootList = this.getRootFolders();
        for (FolderInterface fi : rootList) {
            if (!name.equalsIgnoreCase(fi.getName())) continue;
            return fi;
        }
        return null;
    }

    public FolderInterface getRootFolder(String name, String repository) throws ServiceException, RemoteException {
        this.pulseCheck();
        throw new ServiceException(RB.getStringResource("OMIServerRepository.noroots.ex.txt"));
    }

    @Override
    public List getRootFolders() throws ServiceException, RemoteException {
        this.pulseCheck();
        RootFolderInterface fi = this._omiServer.getRootFolder();
        List subtrees = fi.getSubfolders();
        ArrayList<FolderInterface> rootList = new ArrayList<FolderInterface>();
        for (FolderInterface nextFolder : subtrees) {
            if (!nextFolder.getRepository().equals(this)) continue;
            rootList.add(nextFolder);
        }
        return rootList;
    }

    public List getRootFolders(String repository) throws ServiceException, RemoteException {
        this.pulseCheck();
        throw new ServiceException(RB.getStringResource("OMIServerRepository.noroots.ex.txt"));
    }

    @Override
    public MetadataInterface getObjectByPath(PathUrl url) throws ServiceException, RemoteException {
        String itemName;
        this.pulseCheck();
        if (url == null) {
            return null;
        }
        String itemType = url.getType();
        String rootFolderName = url.getRootTree();
        FolderInterface folder = this.getRootFolder(rootFolderName);
        if (folder == null) {
            return null;
        }
        if ((url.getRootTree() == null || url.getRootTree().trim().length() == 0) && url.getPath() == null && "/".equals(url.getName()) && "Folder".equals(url.getType())) {
            return this._omiServer.getRootFolder();
        }
        String path = url.getPath();
        this._omiServer.debug("com.sas.services.information.OMIRepository." + this._subNum, RB.getResources(), "OMIRepository.getbypath.msg.fmt.txt", path, url.getName(), url.getType());
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, "/", false);
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                List subfolders = folder.getSubfolders();
                boolean gotFolder = false;
                for (MetadataInterface mi : subfolders) {
                    if (!(mi instanceof FolderInterface) || !mi.getName().equalsIgnoreCase(name)) continue;
                    folder = (FolderInterface)mi;
                    gotFolder = true;
                    break;
                }
                if (gotFolder) continue;
                this._omiServer.debug("com.sas.services.information.OMIRepository." + this._subNum, RB.getResources(), "OMIRepository.nofolder.msg.fmt", name, path, null);
                return null;
            }
        }
        if ((itemName = url.getPrimaryName()) != null) {
            if (itemType != null && itemType.equalsIgnoreCase("Folder")) {
                List subfolders = folder.getSubfolders();
                for (MetadataInterface mi : subfolders) {
                    if (!(mi instanceof FolderInterface) || !mi.getName().equalsIgnoreCase(itemName)) continue;
                    folder = (FolderInterface)mi;
                    return folder;
                }
                this._omiServer.debug("com.sas.services.information.OMIRepository." + this._subNum, RB.getResources(), "OMIRepository.nofolder.msg.fmt", itemName, path, null);
                return null;
            }
            MetadataInterface mi = folder.getItemByType(itemName, itemType);
            if (mi != null && url.getExtendedPath() != null && url.getExtendedPath().trim().length() > 0 && mi instanceof EmbeddedObjectInterface) {
                MetadataInterface result = ((EmbeddedObjectInterface)((Object)mi)).getEmbeddedObject(url.getExtendedPath());
                return result;
            }
            return mi;
        }
        return folder;
    }

    @Override
    public MetadataInterface getObjectByPath(String rootFolderName, String path, Class type) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (rootFolderName == null) {
            rootFolderName = BIP_ROOTNAME;
        }
        if (path == null) {
            return null;
        }
        String pathName = null;
        int index = path.lastIndexOf("/");
        if (index < 0) {
            pathName = path;
            path = null;
        } else {
            pathName = path.substring(index + 1);
            path = path.substring(0, index);
        }
        String className = type.getName();
        index = className.lastIndexOf(".");
        className = className.substring(index + 1);
        PathUrl pathurl = new PathUrl(this._defaultRepository, rootFolderName, path, pathName, className);
        return this.getObjectByPath(pathurl);
    }

    @Override
    public MetadataInterface getObjectByPath(String rootFolderName, String path, String type) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.getObjectByPathString(rootFolderName, path, type);
    }

    @Override
    public MetadataInterface getObjectByPathString(String rootFolderName, String path, String type) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (rootFolderName == null) {
            rootFolderName = BIP_ROOTNAME;
        }
        if (path == null) {
            return null;
        }
        String pathName = null;
        int index = path.lastIndexOf("/");
        if (index < 0) {
            pathName = path;
            path = null;
        } else {
            pathName = path.substring(index + 1);
            path = path.substring(0, index);
        }
        PathUrl pathurl = new PathUrl(this._defaultRepository, rootFolderName, path, pathName, type);
        return this.getObjectByPath(pathurl);
    }

    @Override
    public FilteredFolderInterface searchTree(String rootFolderName, FilterInterface filter) throws ServiceException, RemoteException {
        FolderInterface folder;
        this.pulseCheck();
        if (rootFolderName == null) {
            rootFolderName = BIP_ROOTNAME;
        }
        if ((folder = this.getRootFolder(rootFolderName)) == null) {
            return null;
        }
        return this.searchTreeFromBaseWithScope(folder, filter, -1);
    }

    @Override
    public FilteredFolderInterface searchTree(FolderInterface baseFolder, FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.searchTreeFromBaseWithScope(baseFolder, filter, -1);
    }

    @Override
    public FilteredFolderInterface searchTreeFromBase(FolderInterface baseFolder, FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (baseFolder == null) {
            return null;
        }
        return this.searchTreeFromBaseWithScope(baseFolder, filter, -1);
    }

    @Override
    public FilteredFolderInterface searchTreeFromBaseWithScope(FolderInterface baseFolder, FilterInterface filter, int levels) throws ServiceException, RemoteException {
        PartialFolderResultsException pfre = null;
        this.pulseCheck();
        if (baseFolder == null) {
            return null;
        }
        ArrayList<String> treeList = new ArrayList<String>(8);
        HashMap<String, FilteredFolder> map = new HashMap<String, FilteredFolder>(8);
        FilteredFolder ffi = new FilteredFolder(null, baseFolder);
        ffi.setRepository(this);
        if (!(baseFolder instanceof RootFolderInterface)) {
            map.put(baseFolder.getReposId(), ffi);
            treeList.add(baseFolder.getReposId());
        }
        this.buildChildStructure(ffi, levels, treeList, map);
        String[] treeArray = new String[treeList.size()];
        int treeListSize = treeList.size();
        for (int i = 0; i < treeListSize; ++i) {
            treeArray[i] = (String)treeList.get(i);
        }
        String origTemplate = filter.getOMRTemplate();
        String xmlselectString = filter.getXMLSelectString();
        if ("UNSUPPORTED".equals(xmlselectString)) {
            throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (Object)filter.toString()));
        }
        TreeSearchFilter myFilter = new TreeSearchFilter(filter, treeArray);
        myFilter.setOMRTemplate(origTemplate);
        List searchCandidates = null;
        try {
            searchCandidates = this.search(myFilter);
        }
        catch (PartialListResultsException plre) {
            if (pfre == null) {
                pfre = new PartialFolderResultsException(ffi, RB.getStringResource("OMIRepository.geterror.ex.txt"));
            }
            Throwable[] exceptions = plre.getExceptions();
            for (int i = 0; i < exceptions.length; ++i) {
                pfre.addException(exceptions[i]);
            }
            searchCandidates = plre.getResults();
        }
        if (searchCandidates == null || searchCandidates.size() == 0) {
            if (pfre != null) {
                throw pfre;
            }
            return null;
        }
        for (MetadataInterface mi : searchCandidates) {
            List plist = mi.getParents();
            for (FolderInterface parent : plist) {
                String fqid = parent.getReposId();
                FilteredFolderInterface filteredParent = (FilteredFolderInterface)map.get(fqid);
                if (filteredParent == null) continue;
                filteredParent.addLocalItem(mi);
                FilteredFolderInterface grandParent = (FilteredFolderInterface)filteredParent.getParent();
                while (grandParent != null) {
                    grandParent.addSubfolder(filteredParent);
                    filteredParent = grandParent;
                    grandParent = (FilteredFolderInterface)filteredParent.getParent();
                }
            }
        }
        if (pfre != null) {
            throw pfre;
        }
        return ffi;
    }

    private void buildChildStructure(FilteredFolderInterface ffi, int levels, List treeList, Map map) throws ServiceException {
        if (levels == 0) {
            return;
        }
        try {
            FolderInterface folder = ffi.getFolder();
            List subfolders = folder.getSubfolders();
            for (MetadataInterface o : subfolders) {
                try {
                    FolderInterface subfolder = (FolderInterface)o;
                    FilteredFolder sfi = new FilteredFolder(ffi, subfolder);
                    sfi.setRepository(this);
                    map.put(subfolder.getReposId(), sfi);
                    treeList.add(subfolder.getReposId());
                    if (levels <= 0 && levels != -1) continue;
                    this.buildChildStructure(sfi, levels == -1 ? -1 : levels - 1, treeList, map);
                }
                catch (ClassCastException ccex) {
                    this._omiServer.warn("com.sas.services.information.OMIServerRepository", RB.getResources(), "OMIRepository.notfolder.ex.fmt.txt", o.getName(), o.getClass().getName());
                }
            }
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, rex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._listeners != null) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._listeners != null) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int event) throws RemoteException {
        RepositoryEvent repEvent = new RepositoryEvent(this, event);
        ArrayList list = null;
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            list = new ArrayList(this._listeners);
        }
        for (RepositoryListenerInterface next : list) {
            try {
                next.repositoryCallback(repEvent);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void metadataChange(MetadataChangeEvent event) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        String id = event.getRepositoryId();
        MetadataInterface mi = null;
        if (mi != null) {
            try {
                this.refreshEntity(mi);
            }
            catch (ServiceException svcex) {
                this._omiServer.warn("com.sas.services.information.OMIRepository." + this._subNum, RB.getResources(), "OMIRepository.refrshfail.ex.fmt.txt", id, svcex);
            }
        }
    }

    @Override
    public void refreshEntity(MetadataInterface mi) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (mi == null) {
            return;
        }
        this._omiServer.refreshEntity(mi);
    }

    public void MdObjectModified(MdEvent e) throws RemoteException {
        CMetadata cm = (CMetadata)e.getSource();
        MetadataInterface mi = null;
        if (mi != null) {
            InformationServiceInterface is = OMIServerRepository.getInformationService();
            MetadataChangeEvent event = new MetadataChangeEvent(this._url, cm.getFQID());
            is.metadataChange(event);
        } else {
            try {
                mi = this.factoryProcess(cm);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized int trackEntity(MetadataInterface entity) throws RemoteException {
        return -1;
    }

    @Override
    public String getDefaultRepositoryName() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._defaultName;
    }

    @Override
    public String getDefaultRepositoryId() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._defaultRepository;
    }

    public String getRepositoryDescription() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._desc;
    }

    public String getRepositoryPath() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._path;
    }

    public String getRepositoryAccess() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._access;
    }

    public String getRepositoryEngine() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._engine;
    }

    public String getRepositoryOptions() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._options;
    }

    public String getRepositoryEffectiveAccess() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._effectiveAccess;
    }

    public String getRepositoryFormat() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._format;
    }

    public String getRepositoryState() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._state;
    }

    public Date getRepositoryCreatedDate() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._metadataCreated;
    }

    public Date getRepositoryUpdatedDate() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._metadataUpdated;
    }

    @Override
    public synchronized ChildRepositoryInterface newChild() throws ServiceException, RemoteException {
        this.pulseCheck();
        ChildServerInterface csi = this._omiServer.newChild();
        ChildRepositoryInterface ri = (ChildRepositoryInterface)csi.getRepository(this._defaultName);
        ri.setUserContext(this.getUserContext());
        return ri;
    }

    protected void flush() throws ServiceException, RemoteException {
        this._omiServer.flush();
    }

    protected String getSubNum() throws RemoteException {
        return this._subNum;
    }

    @Override
    public String getReposKey(Root reposObject) throws ServiceException, RemoteException {
        return reposObject.getFQID() + '/' + reposObject.getCMetadataType();
    }

    @Override
    public Root createMetadata(String name, String type) throws RemoteException, ServiceException {
        this.pulseCheck();
        return this._omiServer.createMetadata(this._defaultId, name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List browseSearch(FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        List result = null;
        String origRepos = filter.getOMRRepository();
        if (filter.getOMRRepository() == null) {
            filter.setOMRRepository(this._defaultRepository);
        }
        try {
            result = this._omiServer.browseSearch(filter);
        }
        finally {
            filter.setOMRRepository(origRepos);
        }
        return result;
    }

    @Override
    public BrowseMetadataInterface browseFetch(String entityKey, FilterInterface filter) throws ServiceException, RemoteException {
        if (entityKey == null) {
            return null;
        }
        this.pulseCheck();
        return this._omiServer.browseFetch(entityKey, filter);
    }

    @Override
    public List browseFolder(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        ArrayList result = null;
        BrowseMetadataInterface folder = this._omiServer.browseFolder(folderISEntityKey, filter);
        if (folder != null) {
            List memberList = folder.getMembers();
            List subtreeList = folder.getSubfolders();
            if (memberList.size() + subtreeList.size() > 0) {
                result = new ArrayList(memberList.size() + subtreeList.size());
                Iterator it = memberList.iterator();
                while (it.hasNext()) {
                    result.add(it.next());
                }
                it = subtreeList.iterator();
                while (it.hasNext()) {
                    result.add(it.next());
                }
            } else {
                result = Collections.EMPTY_LIST;
            }
        } else {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public List browseFolderRecursive(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        if (folderISEntityKey == null) {
            throw new IllegalArgumentException();
        }
        this.pulseCheck();
        ArrayList result = null;
        BrowseMetadataInterface folder = this._omiServer.browseFolderRecursive(folderISEntityKey, filter);
        if (folder != null) {
            int subtreeSize;
            List memberList = folder.getMembers();
            List subtreeList = folder.getSubfolders();
            int n = subtreeSize = filter != null ? 0 : subtreeList.size();
            if (memberList.size() + subtreeSize > 0) {
                result = new ArrayList(memberList.size() + subtreeSize);
                Iterator it = memberList.iterator();
                while (it.hasNext()) {
                    result.add(it.next());
                }
                if (subtreeSize > 0) {
                    it = subtreeList.iterator();
                    while (it.hasNext()) {
                        result.add(it.next());
                    }
                }
            } else {
                result = Collections.EMPTY_LIST;
            }
        } else {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public BrowseMetadataInterface browseObjectByPath(PathUrl pathurl, FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        PathFilter pf = null;
        try {
            pf = new PathFilter(pathurl, this._omiServer);
        }
        catch (IllegalArgumentException ex) {
            pf = new PathFilter(pathurl);
        }
        if (filter != null) {
            pf.setOMRFlags(filter.getOMRFlags());
            pf.setOMRTemplate(filter.getOMRTemplate());
        }
        pf.setOMRRepository(this._defaultRepository);
        List browseStuff = this._omiServer.browseSearch(pf);
        if (browseStuff != null && browseStuff.size() > 0) {
            BrowseMetadataInterface bmi = (BrowseMetadataInterface)browseStuff.get(0);
            return bmi;
        }
        return null;
    }

    @Override
    public void runInformationServiceTimer() throws RemoteException {
    }

    @Override
    public String getCredentials(String subject) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this._omiServer.getCredentials(subject);
    }

    @Override
    public void freeCredentials(String credential) throws ServiceException, RemoteException {
        this.pulseCheck();
        this._omiServer.freeCredentials(credential);
    }

    @Override
    public boolean isAuthorized(String credential, String resource, String permission) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this._omiServer.isAuthorized(credential, resource, permission);
    }

    @Override
    public List getAuthorizationsOnObj(String resource, List identities, List permissions, int flags) throws ServiceException, RemoteException {
        if (resource == null) {
            return null;
        }
        return this._omiServer.getAuthorizationsOnObj(resource, identities, permissions, flags);
    }

    @Override
    public void setAuthorizationsOnObj(String resource, List authorizations, int flags) throws ServiceException, RemoteException {
        if (authorizations == null || authorizations.size() == 0) {
            return;
        }
        this._omiServer.setAuthorizationsOnObj(resource, authorizations, flags);
    }

    @Override
    public List getIdentitiesOnObj(String resource, int flags) throws ServiceException, RemoteException {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        return this._omiServer.getIdentitiesOnObj(resource, flags);
    }

    @Override
    public List getACTsOnObj(String resource) throws ServiceException, RemoteException {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        return this._omiServer.getACTsOnObj(resource);
    }

    @Override
    public void appyACTToObj(String resource, String act) throws ServiceException, RemoteException {
        if (resource == null || act == null) {
            return;
        }
        this._omiServer.applyACTToObj(resource, act);
    }

    @Override
    public void removeACTFromObj(String resource, String act) throws ServiceException, RemoteException {
        if (resource == null || act == null) {
            return;
        }
        this._omiServer.removeACTFromObj(resource, act);
    }

    @Override
    public List getAccessControlTemplateList(int flags) throws ServiceException, RemoteException {
        return this._omiServer.getAccessControlTemplateList(this, flags);
    }

    @Override
    public void createAccessControTemplate(ACTEntry act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        if (act.getName() == null) {
            return;
        }
        this._omiServer.createAccessControTemplate(this, act);
    }

    @Override
    public void destroyAccessControlTemplate(String act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        this._omiServer.destroyAccessControlTemplate(act);
    }

    @Override
    public void setAccessControlTemplateAttribs(ACTEntry act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        if (act.getName() == null) {
            return;
        }
        this._omiServer.setAccessControlTemplateAttribs(this, act);
    }

    @Override
    public ACTEntry getAccessControlTemplateAttribs(String act) throws ServiceException, RemoteException {
        if (act == null) {
            return null;
        }
        return this._omiServer.getAccessControlTemplateAttribs(act);
    }

    @Override
    public AuthResult isAuthorizedWithConditions(String credential, String resource, String permission) throws ServiceException, RemoteException {
        if (resource == null) {
            return null;
        }
        if (permission == null) {
            return null;
        }
        return this._omiServer.isAuthorizedWithConditions(credential, resource, permission);
    }

    @Override
    public String[][] getAuthorizations(String authType, String credHandle, String resource, String permission) throws ServiceException, RemoteException {
        return this._omiServer.getAuthorizations(authType, credHandle, resource, permission);
    }

    @Override
    public Date getCreateDate(MetadataInterface mi) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this._omiServer.getCreateDate(mi);
    }

    @Override
    public Date getModifiedDate(MetadataInterface mi) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this._omiServer.getModifiedDate(mi);
    }

    @Override
    public String getRepositoryType() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._myType;
    }

    @Override
    public boolean isChild(String repositoryID) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this.children.contains(repositoryID);
    }

    @Override
    public boolean isChild(RepositoryInterface repos) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (repos instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)repos).getDefaultRepositoryId();
            return this.isChild(id);
        }
        return false;
    }

    @Override
    public boolean isInChild(MetadataInterface metadata) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        RepositoryInterface ri = metadata.getRepository();
        if (ri instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)ri).getDefaultRepositoryId();
            boolean result = this.isChild(id);
            return result;
        }
        return false;
    }

    @Override
    public boolean isParent(String repositoryID) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this.parents.contains(repositoryID);
    }

    @Override
    public boolean isParent(RepositoryInterface repos) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (repos instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)repos).getDefaultRepositoryId();
            return this.isParent(id);
        }
        return false;
    }

    @Override
    public boolean isInParent(MetadataInterface metadata) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        RepositoryInterface ri = metadata.getRepository();
        if (ri instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)ri).getDefaultRepositoryId();
            boolean result = this.isParent(id);
            return result;
        }
        return false;
    }

    @Override
    public boolean isInProject(MetadataInterface metadata) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        String id = metadata.getReposId();
        String reposId = "A0000001." + id.substring(id.indexOf(".") + 1);
        return this.projectRepositories.contains(reposId);
    }

    @Override
    public List getParents() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return new ArrayList(this.parents);
    }

    @Override
    public List getChildren() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return new ArrayList(this.children);
    }

    @Override
    public String getUniqueId() throws RemoteException {
        if (this._uniqueId != null) {
            return this._uniqueId;
        }
        this._uniqueId = new VMID().toString() + ':' + this.hashCode();
        return this._uniqueId;
    }

    @Override
    public void setFolderItemRefreshInterval(long msecInterval) throws RemoteException {
        this._folderItemRefreshInterval = msecInterval;
    }

    @Override
    public long getFolderItemRefreshInterval() throws RemoteException {
        return this._folderItemRefreshInterval;
    }

    @Override
    public void setFolderSubfolderRefreshInterval(long msecInterval) throws RemoteException {
        this._folderSubfolderRefreshInterval = msecInterval;
    }

    @Override
    public long getFolderSubfolderRefreshInterval() throws RemoteException {
        return this._folderSubfolderRefreshInterval;
    }

    @Override
    public void setParentRefreshInterval(long msecInterval) throws RemoteException {
        this._metadataParentRefreshInterval = msecInterval;
    }

    @Override
    public long getParentRefreshInterval() throws RemoteException {
        return this._metadataParentRefreshInterval;
    }

    @Override
    public int getCountNoSecurity(Filter filter, String association) throws ServiceException, RemoteException {
        if (filter.getOMRRepository() == null) {
            filter.setOMRRepository(this._defaultRepository);
        }
        return this._omiServer.getCountNoSecurity(filter, association);
    }

    @Override
    public String[][] getInheritedPermissions(IdentityInterface identity, MetadataInterface metadata, List permissions) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public String[][] getInheritedIdentities(MetadataInterface mi) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public boolean isAuthorized(MetadataInterface mi, String permission) throws ServiceException, RemoteException {
        Root cm = (Root)mi.getRepositoryEntity();
        String resource = "OMSOBJ:" + cm.getCMetadataType() + '/' + cm.getFQID();
        return this._omiServer.isAuthorized("", resource, permission);
    }

    @Override
    public MetadataInterface factoryProcess(Object o) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this._omiServer.factoryProcess(o);
    }

    @Override
    public void addToCache(MetadataInterface newMetadata) throws ServiceException, RemoteException {
        this.pulseCheck();
        this._omiServer.addToCache(newMetadata);
    }

    protected final void pulseCheck() throws ServiceException {
        if (this._isDestroyed) {
            if (this.closeStack != null) {
                try {
                    if (this._omiServer != null) {
                        this._omiServer.debug("com.sas.services.information.OMIRepository" + this._subNum, RB.getStringResource("Repository.isdestroyed.ex.txt"), this.closeStack);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            throw new ServiceException(RB.getStringResource("Repository.isdestroyed.ex.txt"));
        }
    }

    public void MdObjectCreated(MdEvent e, String id) throws RemoteException {
    }

    public void MdObjectDeleted(MdEvent e, String id) throws RemoteException {
    }

    public void MdObjectsCreated(MdEvent e, List ids) throws RemoteException {
    }

    @Override
    public byte[] toByteArray() throws RemoteException, ServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this._principal);
            oos.writeObject(this._password);
            oos.writeObject(this._defaultRepository);
            oos.writeObject(this._defaultName);
            oos.writeObject(this._isName);
            byte[] blobArray = baos.toByteArray();
            return blobArray;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void fromByteArry(UserContextInterface uci, byte[] data) throws RemoteException, ServiceException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            this._user = uci;
            String defaultName = (String)ois.readObject();
            String isName = (String)ois.readObject();
            this._defaultName = defaultName;
            this._isName = isName;
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (IOException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public boolean isDestroyed() throws RemoteException {
        return this._isDestroyed;
    }

    @Override
    public CacheStatistics getCacheStatistics() throws ServiceException, RemoteException {
        return new BaseCacheStatistics(0, 0, 0, 0);
    }

    @Override
    public String getFactoryKey(Object o) throws ServiceException, RemoteException {
        try {
            Root root = (Root)o;
            if (root instanceof PrimaryType) {
                TypeDescriptorInterface tdi;
                String publicType = ((PrimaryType)root).getPublicType();
                if (publicType != null && publicType.startsWith("Embedded:")) {
                    publicType = publicType.substring("Embedded:".length());
                }
                if (publicType != null && publicType.length() > 0 && (tdi = this._omiServer.getTypeDescriptor(publicType)) != null && tdi.getClassName() != null && tdi.getClassName().trim().length() > 0) {
                    return "tdi:" + tdi.getClassName();
                }
            }
            String key = "omi:" + root.getCMetadataType().toLowerCase();
            return key;
        }
        catch (ClassCastException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public MetadataInterface produceDefaultMetadata(Object o) throws RemoteException, ServiceException {
        Metadata result = new Metadata(o);
        result.setRepository(this);
        return result;
    }

    @Override
    public boolean factoryTest(Object testObject, String filterString) throws RemoteException, ServiceException {
        ArrayList<Object> testObjects = new ArrayList<Object>(5);
        testObjects.add(testObject);
        StringTokenizer st = new StringTokenizer(filterString, "/", false);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (nextToken.charAt(0) == '@') {
                StringBuffer buffer = new StringBuffer(nextToken);
                while (st.hasMoreTokens()) {
                    buffer.append('/' + st.nextToken());
                }
                nextToken = buffer.toString();
                int index = nextToken.indexOf("=");
                String string = nextToken.substring(1, index);
                index = nextToken.indexOf("'");
                if (index < 0) {
                    throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)nextToken));
                }
                int index2 = nextToken.lastIndexOf("'");
                if (index2 <= index) {
                    throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)nextToken));
                }
                String value = nextToken.substring(index + 1, index2);
                for (Object e : testObjects) {
                    Map testMap;
                    String attrValue;
                    if (e instanceof Root) {
                        Root nextTest = (Root)e;
                        try {
                            Map attrMap = nextTest.getAttrs();
                            String attrValue2 = (String)attrMap.get(string);
                            if (attrValue2 == null || !value.equalsIgnoreCase(attrValue2)) continue;
                            return true;
                        }
                        catch (ClassCastException cce) {
                            cce.printStackTrace(System.out);
                            continue;
                        }
                    }
                    if (!(e instanceof Map) || (attrValue = (String)(testMap = (Map)e).get(string)) == null || !value.equalsIgnoreCase(attrValue)) continue;
                    return true;
                }
                return false;
            }
            if (nextToken.charAt(0) == '*') {
                ArrayList newTestObjects = new ArrayList(5);
                nextToken = nextToken.substring(1);
                if (testObject instanceof Root) {
                    Iterator filterIt = testObjects.iterator();
                    while (filterIt.hasNext()) {
                        try {
                            Root root = (Root)filterIt.next();
                            AssociationList items = root.getAssociatedObjects(nextToken);
                            if (items == null || items.size() <= 0) continue;
                            newTestObjects.addAll(items);
                        }
                        catch (MdException mdException) {
                            throw new ServiceException(mdException, mdException.getMessage());
                        }
                    }
                    testObjects = newTestObjects;
                } else if (testObject instanceof Map) {
                    for (Map map : testObjects) {
                        OMIServerRepository.addToTestObjects(map, nextToken, newTestObjects);
                    }
                    testObjects = newTestObjects;
                }
                if (testObjects.size() != 0) continue;
                return false;
            }
            throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)nextToken));
        }
        return false;
    }

    @Override
    public EvaluatorInterface getEvaluator(Object o) {
        return new OMIEvaluator(o);
    }

    private static void addToTestObjects(Map nextObject, String nextToken, List newTestObjects) {
        List list = (List)nextObject.get(nextToken);
        if (list != null) {
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                Object testObject = list.get(i);
                if (!(testObject instanceof Map)) continue;
                newTestObjects.add(testObject);
            }
        }
    }

    @Override
    public int isProfileRepository(String url) throws RemoteException {
        if (url == null) {
            String type = this.getRepositoryType();
            if ("FOUNDATION".equalsIgnoreCase(type)) {
                return 1;
            }
            return 0;
        }
        if (URIUtil.url1StartsWithUrl2(url, this.getUrl()) != null) {
            String type = this.getRepositoryType();
            if ("FOUNDATION".equalsIgnoreCase(type)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getOMRVersion() throws ServiceException, RemoteException {
        return this._omiServer.getServerVersion();
    }

    @Override
    public List getPermissions() throws ServiceException, RemoteException {
        if (this._permissionList == null) {
            Filter filter = new Filter();
            filter.setType("Permission");
            filter.setOMRFlags(8192);
            this._permissionList = this.search(filter);
        }
        return this._permissionList;
    }

    @Override
    public List getPredefinedPropertyTypes() throws ServiceException, RemoteException {
        if (this._propertyTypeList == null) {
            Filter filter = new Filter("Name", 0, "Entity Property Types");
            filter.setType("Group");
            List groupList = this.search(filter);
            if (groupList.size() > 0) {
                GroupInterface mgroup = (GroupInterface)groupList.get(0);
                Group group = (Group)mgroup.getRepositoryEntity();
                try {
                    AssociationList memberList = group.getMembers();
                    this._propertyTypeList = new ArrayList(memberList.size());
                    for (PropertyType pt : memberList) {
                        MetadataInterface mi = this.factoryProcess(pt);
                        this._propertyTypeList.add(mi);
                    }
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return this._propertyTypeList;
    }

    public void MdObjectsCreated(MdFactoryEvent e) {
    }

    public void MdObjectsDeleted(MdFactoryEvent e) {
    }

    public void MdObjectsModified(MdFactoryEvent e) {
    }

    public void MdObjectsAdded(MdEvent e, List items) throws RemoteException {
    }

    public void MdObjectsRemoved(MdEvent e, List items) throws RemoteException {
    }

    public void MdObjectsModified(MdEvent e, List items) throws RemoteException {
    }

    @Override
    public ServerInterface getServer() throws ServiceException, RemoteException {
        return this._omiServer;
    }

    @Override
    public void refreshAllData() throws ServiceException, RemoteException {
    }

    @Override
    public boolean isUserAuthorizedInRepository(String permission) throws ServiceException, RemoteException {
        return this._omiServer.isUserAuthorized(this._defaultId, permission);
    }

    @Override
    public void populateAttributes(String id, String name, String type, String desc, String path, String engine, String options, String access, String effectiveAccess, String format, String state, Date metadataCreated, Date metadataUpdated) {
        this._defaultRepository = id;
        this._defaultId = this._defaultRepository.substring(9);
        this._defaultName = name;
        this._myType = type;
        this._desc = desc;
        this._path = path;
        this._access = access;
        this._engine = engine;
        this._options = options;
        this._effectiveAccess = effectiveAccess;
        this._format = format;
        this._state = state;
        this._metadataCreated = metadataCreated;
        this._metadataUpdated = metadataUpdated;
    }

    public class OMIEvaluator
    implements EvaluatorInterface {
        Object _theRoot;

        public OMIEvaluator(Object o) {
            this._theRoot = o;
        }

        @Override
        public boolean evaluate(String path, String value) throws RemoteException, ServiceException {
            ArrayList<Object> testObjects = new ArrayList<Object>(5);
            testObjects.add(this._theRoot);
            StringTokenizer st = new StringTokenizer(path, "/", false);
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.charAt(0) == '@') {
                    String attribute = nextToken.substring(1);
                    for (Object e : testObjects) {
                        Map testMap;
                        String attrValue;
                        if (e instanceof Root) {
                            Root nextTest = (Root)e;
                            try {
                                Map attrMap = nextTest.getAttrs();
                                String attrValue2 = (String)attrMap.get(attribute);
                                if (attrValue2 == null || !value.equalsIgnoreCase(attrValue2)) continue;
                                return true;
                            }
                            catch (ClassCastException cce) {
                                cce.printStackTrace(System.out);
                                continue;
                            }
                            catch (RemoteException cce) {
                                continue;
                            }
                        }
                        if (!(e instanceof Map) || (attrValue = (String)(testMap = (Map)e).get(attribute)) == null || !value.equalsIgnoreCase(attrValue)) continue;
                        return true;
                    }
                    return false;
                }
                if (nextToken.charAt(0) != '*') continue;
                ArrayList newTestObjects = new ArrayList(5);
                nextToken = nextToken.substring(1);
                if (this._theRoot instanceof Root) {
                    Iterator filterIt = testObjects.iterator();
                    while (filterIt.hasNext()) {
                        try {
                            Root root = (Root)filterIt.next();
                            AssociationList items = root.getAssociatedObjects(nextToken);
                            if (items == null || items.size() <= 0) continue;
                            newTestObjects.addAll(items);
                        }
                        catch (MdException mdException) {
                            throw new ServiceException(mdException, mdException.getMessage());
                        }
                    }
                    testObjects = newTestObjects;
                } else if (this._theRoot instanceof Map) {
                    for (Map map : testObjects) {
                        OMIServerRepository.addToTestObjects(map, nextToken, newTestObjects);
                    }
                    testObjects = newTestObjects;
                }
                if (testObjects.size() != 0) continue;
                return false;
            }
            return false;
        }

        @Override
        public List setPath(String path) throws ServiceException, RemoteException {
            ArrayList<Object> testObjects = new ArrayList<Object>(5);
            testObjects.add(this._theRoot);
            StringTokenizer st = new StringTokenizer(path, "/", false);
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.charAt(0) == '*') {
                    ArrayList newTestObjects = new ArrayList(5);
                    nextToken = nextToken.substring(1);
                    if (this._theRoot instanceof Root) {
                        Iterator filterIt = testObjects.iterator();
                        while (filterIt.hasNext()) {
                            try {
                                Root root = (Root)filterIt.next();
                                AssociationList items = root.getAssociatedObjects(nextToken);
                                if (items == null || items.size() <= 0) continue;
                                newTestObjects.addAll(items);
                            }
                            catch (MdException mdException) {
                                throw new ServiceException(mdException, mdException.getMessage());
                            }
                        }
                        testObjects = newTestObjects;
                    } else if (this._theRoot instanceof Map) {
                        for (Map map : testObjects) {
                            OMIServerRepository.addToTestObjects(map, nextToken, newTestObjects);
                        }
                        testObjects = newTestObjects;
                    }
                }
                if (testObjects.size() != 0) continue;
                return testObjects;
            }
            return testObjects;
        }

        @Override
        public boolean evaluateObject(Object o, String attribute, String value) throws RemoteException, ServiceException {
            block10: {
                if (attribute == null || value == null) {
                    return false;
                }
                if (attribute.charAt(0) == '@') {
                    attribute = attribute.substring(1);
                }
                if (o instanceof Root) {
                    Root nextTest = (Root)o;
                    try {
                        Map attrMap = nextTest.getAttrs();
                        String attrValue = (String)attrMap.get(attribute);
                        if (attrValue == null) {
                            return false;
                        }
                        if (value.equalsIgnoreCase(attrValue)) {
                            return true;
                        }
                        break block10;
                    }
                    catch (ClassCastException cce) {
                        throw new ServiceException(cce, cce.getMessage());
                    }
                }
                if (o instanceof Map) {
                    Map testMap = (Map)o;
                    String attrValue = (String)testMap.get(attribute);
                    if (attrValue == null) {
                        return false;
                    }
                    if (value.equalsIgnoreCase(attrValue)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    class mdFactoryListener
    implements MdFactoryListener {
        private MdFactoryImpl _mdfactory;

        public mdFactoryListener(MdFactoryImpl mdfactory) throws IllegalArgumentException {
            if (mdfactory == null) {
                throw new IllegalArgumentException();
            }
            this._mdfactory = mdfactory;
        }

        public void MdObjectsCreated(com.sas.metadata.MdFactoryEvent e) {
        }

        public void MdObjectsModified(com.sas.metadata.MdFactoryEvent e) {
        }

        public void MdObjectsDeleted(com.sas.metadata.MdFactoryEvent e) {
            String id = null;
            try {
                String[] idArray = e.getObjectIDs();
                for (int i = 0; i < idArray.length; ++i) {
                    id = idArray[i];
                    this._mdfactory.deleteDetailMetadataObject(id);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static class SmartTypeHelper {
        private static String TRUE = Boolean.TRUE.toString();
        private static String FALSE = Boolean.FALSE.toString();
        private Result _defaultResult;
        private Map _results = Collections.synchronizedMap(new HashMap(8));

        SmartTypeHelper(String defaultSmartType) {
            this._defaultResult = new Result(defaultSmartType, false);
        }

        Result getDefaultResult() {
            return this._defaultResult;
        }

        Result lookup(String className) throws ServiceException {
            Result rval = (Result)this._results.get(className);
            if (rval == null) {
                try {
                    MetadataInterface emptyMd = (MetadataInterface)Factory.getInstance().newInstance(className);
                    String smartType = emptyMd.getType();
                    boolean isFolder = emptyMd instanceof FolderInterface;
                    rval = new Result(smartType, isFolder);
                    this._results.put(className, rval);
                }
                catch (ClassNotFoundException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
                catch (ServiceException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw e;
                }
                catch (RemoteException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
            }
            return rval;
        }

        static class Result {
            private String _smartType;
            private boolean _isFolder;

            public Result(String smartType, boolean isFolder) {
                this._smartType = smartType;
                this._isFolder = isFolder;
            }

            public String getSmartType() {
                return this._smartType;
            }

            public boolean isFolder() {
                return this._isFolder;
            }

            public String isFolderStr() {
                return this._isFolder ? TRUE : FALSE;
            }
        }
    }
}

