/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.DateTimeHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfAnyHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.meta.SASOMI.IPasswordControl;
import com.sas.meta.SASOMI.IPasswordControlHelper;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_ALREADY_EXISTS;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_DOES_NOT_EXIST;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_IN_DEPENDENT_REPOS;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_NOT_REMOVED;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_IDENTITY_DOES_NOT_EXIST;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_ACTION;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_IDENTITY_SPEC;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_PERMISSION_SPEC;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_RESOURCE_SPEC;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_TC_HANDLE;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_NOT_AUTHORIZED;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_OBJECT_NOT_ACT;
import com.sas.meta.SASOMI.ISecurityHelper;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NoCredential;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.meta.SASOMI.ISecurity_1_1Package.AuthDomainDoesNotExist;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidInfoType;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidObjectSpecification;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionName;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionValue;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidPermMask;
import com.sas.meta.SASOMI.ISecurity_1_1Package.ObjectDoesNotExist;
import com.sas.meta.SASOMI.ISecurity_1_1Package.PermissionDoesNotExist;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdConnectionEvent;
import com.sas.metadata.remote.MdConnectionListener;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreIDChangeListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.TypeDefinition;
import com.sas.metadata.remote.UnsupportedPlatformVersionException;
import com.sas.metadata.remote.XMLUtil;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.net.util.DateConverter;
import com.sas.services.ServiceException;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.impl.BaseCacheFactory;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.HostPortPair;
import com.sas.services.connection.HostPortSet;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.deployment.Environment;
import com.sas.services.information.ACTEntry;
import com.sas.services.information.AuthResult;
import com.sas.services.information.Authorization;
import com.sas.services.information.AuthorizationObjectsResult;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Factory;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.FilterNotSupportedException;
import com.sas.services.information.IdentityInfo;
import com.sas.services.information.InformationService;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.InternalLoginSitePolicies;
import com.sas.services.information.InternalLoginUserInfo;
import com.sas.services.information.LoggerStream;
import com.sas.services.information.MetadataConnectionEvent;
import com.sas.services.information.MetadataConnectionListener;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIChildServer;
import com.sas.services.information.OMIRepository;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.PartialListResultsException;
import com.sas.services.information.PartialResultsException;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryInfo;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerDef;
import com.sas.services.information.ServerVersionException;
import com.sas.services.information.SmartDef;
import com.sas.services.information.TreeSearchFilter;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.cache.RepositoryCache;
import com.sas.services.information.metadata.EmbeddedObjectInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathFilter;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RoleInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.publicobject.TypeDescriptorImpl;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.util.ISEntityKey;
import com.sas.services.information.util.OMRFactoryManager;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.security.ApplicationAuthorization;
import com.sas.services.security.BadHostLoginServiceException;
import com.sas.services.security.ConnectRefusedLoginServiceException;
import com.sas.services.security.CredentialLoginServiceException;
import com.sas.services.security.Permission;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.DateUtil;
import com.sas.services.util.Names;
import com.sas.services.util.ServicesConnectionFactoryInterface;
import com.sas.services.util.ServicesConnectionFactoryManager;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OMIServer
extends UnicastRemoteObject
implements MetadataServerInterface,
MdStoreIDChangeListener,
MdFactoryListener,
MdObjectListener,
MdConnectionListener {
    private static final String EX_MSG_CONNECTIONABORT = "connection abort";
    private static final String EX_MSG_EOFEXCEPTION = "EOFException";
    private static final String EX_MSG_SOCKETEXCEPTION = "SocketException";
    private static final double SecondsInTheSixties = 3.156192E8;
    private static final long serialVersionUID = 1L;
    private static final int COLLECTION_INIT = 8;
    private static final int LENGTH_CHAINED_MESSAGE = 240;
    public static final String ROOT_CLASSIDENTIFIER = "E5F27790-2149-11D6-8828-AA0004006D06";
    public static final String BIP_COMPONENTNAME = "BIP Service";
    private static final int REPOSITORY_MAP_INIT = 64;
    protected Map _typeMap = null;
    protected Map _explicitIdGrpsMap = null;
    protected boolean _isDestroyed = false;
    private Exception closeStack = null;
    ServerDef _def = null;
    protected Map _repositories = null;
    protected Map _id2NameMap = null;
    protected Logger _logger = null;
    UserContextInterface _user = null;
    private IOMI _cnxn = null;
    private Factory _factory = null;
    protected MdFactory _mdfactory = null;
    protected MdObjectStore _mdstore = null;
    protected RepositoryCache _cache = null;
    protected String _url = null;
    protected String _name = null;
    protected IdentityInterface _person = null;
    protected ConnectionInterface _cnxnHandle = null;
    private Cluster _cluster = null;
    protected ConnectionFactoryAdminInterface _cnxnAdmin = null;
    private ISecurity_1_1 _iSecurity = null;
    protected Object _cnxnSync = new Object();
    private SoftwareComponent _bipRoot;
    protected String _foundationReposName = null;
    private SmartTypeHelper _myHelper = new SmartTypeHelper("Metadata");
    private HashMap _tempMap = new HashMap(64);
    protected String _subNum = "0";
    private int _childnum = 0;
    private cVetoableChangeListener _myListener = null;
    private String _host = null;
    private long _port;
    private List<MetadataConnectionListener> _metadataConnectionListeners = null;

    public OMIServer() throws RemoteException {
        this(OMIServer.class);
    }

    protected OMIServer(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
        this._factory = Factory.getInstance();
    }

    @Override
    public void connect(IOMI cnxn, ServerDef def, UserContextInterface user, Cluster cluster) throws ServiceException, RemoteException {
        this._def = def;
        this._host = def.getHost();
        this._port = Long.parseLong(def.getPort());
        this._user = user;
        this._name = def.getName();
        this._cnxn = cnxn;
        this._cluster = cluster;
        this._cnxnHandle = ConnectionFactoryUtil.extractConnectionHandle((org.omg.CORBA.Object)cnxn);
        this._cnxnAdmin = ConnectionFactoryUtil.extractConnectionFactoryAdmin((ConnectionInterface)this._cnxnHandle);
        InformationServiceInterface is = OMIRepository.getInformationService();
        boolean isRemote = !is.isIsolated();
        try {
            this._mdfactory = new MdFactoryImpl(isRemote);
        }
        catch (MdException mdex) {
            throw new RuntimeException(RB.getStringResource("OMIReposiotyr.crtfactexcept.ex.txt"));
        }
        this._mdfactory.getConnection().setCMRHandle(this._cnxn);
        this.initializeInstance();
    }

    @Override
    public void connect(IOMI cnxn, ServerDef def, UserContextInterface user) throws ServiceException, RemoteException {
        this.connect(cnxn, def, user, null);
    }

    @Override
    public void connect(ServerDef def, UserContextInterface user) throws ServiceException, RemoteException {
        this.connect(def, user, null);
    }

    @Override
    public void connect(ServerDef def, UserContextInterface user, Cluster cluster) throws ServiceException, RemoteException {
        this._def = def;
        this._host = def.getHost();
        this._port = Long.parseLong(def.getPort());
        this._user = user;
        this._name = def.getName();
        this._cluster = cluster;
        InformationServiceInterface is = OMIRepository.getInformationService();
        boolean isRemote = !is.isIsolated();
        String urkey = "OMIREPOSITORY:" + this._def.getHost() + ':' + this._def.getPort();
        Object o = this._user.getSharedResource(urkey);
        if (o != null) {
            OMRFactoryManager ofm = (OMRFactoryManager)o;
            this._mdfactory = ofm.getFactory();
            this._cnxn = this._mdfactory.getConnection().getCMRHandle();
            this._user.putSharedResource(urkey, null);
        } else {
            this.attemptConnection();
            try {
                this._mdfactory = new MdFactoryImpl(isRemote);
            }
            catch (MdException mdex) {
                throw new RuntimeException(RB.getStringResource("OMIReposiotyr.crtfactexcept.ex.txt"));
            }
            this._mdfactory.getConnection().setCMRHandle(this._cnxn);
            this._mdfactory.addMdFactoryListener((MdFactoryListener)this);
        }
        this.initializeInstance();
    }

    public void flushAllCachedObjects() throws RemoteException, ServiceException {
        this._mdstore.dispose();
        this._cache.clear(true);
        this._bipRoot = null;
        this._person = null;
        this.initializeInstance();
    }

    private void initializeInstance() throws ServiceException, RemoteException {
        this._mdfactory.setMdConnectionListener((MdConnectionListener)this);
        this._repositories = new HashMap(64);
        this._id2NameMap = new HashMap(64);
        this._logger = LogManager.getLogger((String)"com.sas.services.information.OMIServer");
        String userid = this._user.getResolvedUserId();
        if (userid == null) {
            userid = "someone";
        }
        this._mdstore = this._mdfactory.createObjectStore(null, "IS_" + userid);
        this._mdstore.addMdStoreIDChangeListener((MdStoreIDChangeListener)this);
        this._myListener = new cVetoableChangeListener(this._mdstore);
        this._mdstore.addVetoableChangeListener((VetoableChangeListener)this._myListener);
        this.setupJomaLogging();
        try {
            this._mdfactory.getConnection().validatePlatformVersion();
        }
        catch (UnsupportedPlatformVersionException e) {
            throw new ServerVersionException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        this.loadRepositoryData();
        try {
            this._cache = (RepositoryCache)BaseCacheFactory.getCache((String)this.getClass().getName(), (String)this.cachePath(), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (CacheException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        if (this._url == null) {
            this._url = "omi://" + this._def.getHost() + ":" + this._def.getPort();
        }
        this.loadTypes();
        this.loadExplicitIdentityGroups();
        this.getUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRepositoryData() {
        Map reposData = new HashMap();
        int flags = 0x4000001;
        StringHolder outXml = new StringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                this._mdfactory.getConnection().getCMRHandle().GetRepositories(outXml, flags, "");
                String xmlOut = outXml.value;
                reposData = this.buildReposDatafromXML(xmlOut);
            }
        }
        catch (RemoteException rex) {
            return;
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this.reconnect();
                    this.loadRepositoryData();
                }
                catch (RemoteException remoteException) {
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return;
            }
            return;
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                try {
                    this.reconnect();
                    this.loadRepositoryData();
                }
                catch (RemoteException remoteException) {
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return;
            }
            return;
        }
        catch (MdException e) {
            return;
        }
        this._repositories = reposData;
    }

    private Map buildReposDatafromXML(String xmlOut) throws RemoteException, MdException {
        HashMap<String, RepositoryEntry> reposData = new HashMap<String, RepositoryEntry>();
        Document mainDoc = this._mdfactory.getOMIUtil().parseXML(xmlOut);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            String strType = null;
            String strEngine = null;
            String strOptions = null;
            String strMetadataCreated = null;
            String strMetadataUpdated = null;
            Date metadataCreated = null;
            Date metadataUpdated = null;
            NodeList nodeList = firstNode.getChildNodes();
            int reposCnt = nodeList.getLength();
            for (int index = 0; index < reposCnt; ++index) {
                RepositoryEntry e;
                NamedNodeMap childNodeMap = nodeList.item(index).getAttributes();
                String strFQID = childNodeMap.getNamedItem("Id").getNodeValue();
                if (strFQID.equals("A0000001.A0000001")) continue;
                String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                String strDesc = childNodeMap.getNamedItem("Desc").getNodeValue();
                Node typeNode = childNodeMap.getNamedItem("RepositoryType");
                if (typeNode != null && "Foundation".equalsIgnoreCase(strType = typeNode.getNodeValue())) {
                    this._foundationReposName = strName;
                }
                String strPath = childNodeMap.getNamedItem("Path").getNodeValue();
                if (childNodeMap.getNamedItem("Engine") != null) {
                    strEngine = childNodeMap.getNamedItem("Engine").getNodeValue();
                }
                if (childNodeMap.getNamedItem("Options") != null) {
                    strOptions = childNodeMap.getNamedItem("Options").getNodeValue();
                }
                String strReposFormat = childNodeMap.getNamedItem("RepositoryFormat").getNodeValue();
                String strAccess = childNodeMap.getNamedItem("Access").getNodeValue();
                String strEffectiveAccess = childNodeMap.getNamedItem("CurrentAccess").getNodeValue();
                String strState = childNodeMap.getNamedItem("PauseState").getNodeValue();
                if (childNodeMap.getNamedItem("MetadataCreated") != null) {
                    strMetadataCreated = childNodeMap.getNamedItem("MetadataCreated").getNodeValue();
                    metadataCreated = this._mdfactory.getUtil().getDateForDoubleSASDateTimeString(strMetadataCreated);
                }
                if (childNodeMap.getNamedItem("MetadataUpdated") != null) {
                    strMetadataUpdated = childNodeMap.getNamedItem("MetadataUpdated").getNodeValue();
                    metadataUpdated = this._mdfactory.getUtil().getDateForDoubleSASDateTimeString(strMetadataUpdated);
                }
                RepositoryEntry entry = new RepositoryEntry(strFQID, strName, strType, strDesc, strPath, strEngine, strOptions, strAccess, strEffectiveAccess, strReposFormat, strState, metadataCreated, metadataUpdated, null);
                reposData.put(strName.toUpperCase(), entry);
                if (this._repositories != null && (e = (RepositoryEntry)this._repositories.get(strName.toUpperCase())) != null) {
                    entry.repos = e.repos;
                }
                this._id2NameMap.put(strFQID, strName);
            }
        }
        return reposData;
    }

    public void reloadRepositoryData() {
        this.loadRepositoryData();
        if (this._repositories != null) {
            for (RepositoryEntry entry : this._repositories.values()) {
                OMIRepositoryInterface ri = (OMIRepositoryInterface)entry.repos;
                if (ri == null) continue;
                try {
                    ri.populateAttributes(entry.fqid, entry.name, entry.type, entry.desc, entry.path, entry.engine, entry.options, entry.access, entry.effectiveAccess, entry.format, entry.state, entry.metadataCreated, entry.metadataUpdated);
                }
                catch (RemoteException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupJomaLogging() throws RemoteException {
        LoggerStream ls = null;
        Logger metadataLogger = LogManager.getLogger((String)"com.sas.metadata");
        Logger xmlLogger = LogManager.getLogger((String)"com.sas.metadata.xml");
        Logger perfLogger = LogManager.getLogger((String)"com.sas.metadata.perf");
        try {
            if (this._logger != null && this._mdfactory != null && (metadataLogger.isEnabled(Level.DEBUG) || xmlLogger.isEnabled(Level.DEBUG) || perfLogger.isEnabled(Level.DEBUG))) {
                String encoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
                this._mdfactory.getUtil().setDefaultEncoding(encoding);
                if (metadataLogger.isEnabled(Level.DEBUG)) {
                    ls = new LoggerStream("com.sas.metadata", Level.DEBUG);
                    this._mdfactory.setDebug(true);
                    this._mdfactory.getUtil().setOutputStream((OutputStream)ls, encoding);
                }
                if (xmlLogger.isDebugEnabled()) {
                    ls = new LoggerStream("com.sas.metadata.xml", Level.DEBUG);
                    this._mdfactory.setLoggingEnabled(true);
                    this._mdfactory.getUtil().setLogStream((OutputStream)ls, encoding);
                }
                if (perfLogger.isDebugEnabled()) {
                    ls = new LoggerStream("com.sas.metadata.perf", Level.DEBUG);
                    this._mdfactory.setPerf(true);
                    this._mdfactory.getUtil().setPerfStream((OutputStream)ls, encoding);
                }
            } else if (this._mdfactory != null) {
                this._mdfactory.setDebug(false);
                this._mdfactory.setLoggingEnabled(false);
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            if (ls != null) {
                ls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUser() throws ServiceException, RemoteException {
        block17: {
            org.omg.CORBA.Object obj = this._cnxn._duplicate();
            ISecurity isec = ISecurityHelper.narrow((org.omg.CORBA.Object)obj);
            try {
                StringHolder identHolder = new StringHolder();
                Object object = this._cnxnSync;
                synchronized (object) {
                    isec.GetIdentity("", identHolder);
                }
                String identString = identHolder.value;
                if (identString.equals("UNKNOWN:")) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug("The authenticated user is unknown in the server " + this._def.getHost() + ":" + this._def.getPort());
                    }
                    return;
                }
                int index = identString.indexOf(":");
                int index2 = identString.indexOf("/");
                String type = identString.substring(index + 1, index2);
                String personId = identString.substring(index2 + 1);
                int flags = 2056;
                if (this._person != null) break block17;
                try {
                    CMetadata cm = null;
                    Object object2 = this._cnxnSync;
                    synchronized (object2) {
                        cm = this._mdfactory.getOMIUtil().getMetadataAllDepths((MdStore)this._mdstore, type, personId, new Vector(8), new Vector(8), "", flags);
                    }
                    this._person = (IdentityInterface)this.factoryProcess(cm);
                }
                catch (MdException ex) {
                    if (this._logger != null) {
                        this._logger.warn(RB.getStringResource("OMIServer.getuser.ex.txt") + "   " + ex.getMessage());
                    }
                }
            }
            catch (InvalidCredHandle ich) {
                throw new ServiceException(ich, ich.getMessage());
            }
            catch (GenericError ge) {
                throw new ServiceException(ge, ge.getMessage());
            }
            catch (RemoteException ex) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(RB.getStringResource("OMIRepository.persretexcept.ex.txt"), (Throwable)ex);
                }
            }
            catch (SystemException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ServiceException, RemoteException {
        if (this._isDestroyed) {
            return;
        }
        this._isDestroyed = true;
        this.closeStack = new Exception();
        this._bipRoot = null;
        if (this._cache != null) {
            this._cache.clear(true);
        }
        this._cache = null;
        if (this._repositories != null) {
            for (RepositoryEntry entry : this._repositories.values()) {
                RepositoryInterface ri = entry.repos;
                if (ri == null) continue;
                ri.close();
            }
            this._repositories.clear();
        }
        this._repositories = null;
        if (VirtualFolderManager.instanceCreated(this)) {
            VirtualFolderManager vfm = VirtualFolderManager.getInstance(this);
            vfm.destroy();
        }
        if (this._mdstore != null) {
            this._mdstore.removeMdStoreIDChangeListener((MdStoreIDChangeListener)this);
            this._mdstore.dispose();
        }
        this._mdstore = null;
        if (this._mdfactory != null) {
            this._mdfactory.dispose();
        }
        this._myListener = null;
        this._mdfactory = null;
        if (this._metadataConnectionListeners != null) {
            this._metadataConnectionListeners.clear();
            this._metadataConnectionListeners = null;
        }
        if (this._cnxnHandle != null) {
            this._cnxnHandle.close();
            this._cnxnHandle = null;
        }
        if (this._cnxnAdmin != null) {
            this._cnxnAdmin.destroy();
            this._cnxnAdmin = null;
        }
        this._cnxnHandle = null;
        this._cnxnAdmin = null;
        if (this._iSecurity != null) {
            try {
                this._iSecurity._release();
            }
            finally {
                this._iSecurity = null;
            }
        }
        this._cnxn = null;
        this._cnxnSync = null;
        this._factory = null;
        this._logger = null;
        this._person = null;
        this._user = null;
        try {
            OMIServer.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Override
    public boolean isConnected() throws ServiceException, RemoteException {
        return !this._isDestroyed && this._cnxnHandle != null;
    }

    protected String getSubNum() throws RemoteException {
        return this._subNum;
    }

    public MdFactory getMdFactory() {
        return this._mdfactory;
    }

    public MdObjectStore getObjectStore() {
        return this._mdstore;
    }

    RepositoryCache getRepositoryCache() {
        return this._cache;
    }

    Factory getFactory() {
        return this._factory;
    }

    void addFactoryListener(MdFactoryListener newListener) throws RemoteException {
        this._mdfactory.addMdFactoryListener(newListener);
    }

    @Override
    public String getName() throws RemoteException {
        return this._name;
    }

    @Override
    public PersonInterface getPerson() throws ServiceException, RemoteException {
        if (this._person instanceof PersonInterface) {
            return (PersonInterface)this._person;
        }
        return null;
    }

    @Override
    public IdentityInterface getIdentity() throws ServiceException, RemoteException {
        return this._person;
    }

    void setIdentity(IdentityInterface identity) throws RemoteException {
        this._person = identity;
    }

    @Override
    public List getRepositoryNames() throws ServiceException, RemoteException {
        ArrayList<String> result = new ArrayList<String>(this._repositories.size());
        for (RepositoryEntry re : this._repositories.values()) {
            result.add(re.name);
        }
        return result;
    }

    public String getRepositoryId(String name) throws RemoteException {
        String result = null;
        RepositoryEntry entry = (RepositoryEntry)this._repositories.get(name.toUpperCase());
        if (entry != null) {
            result = entry.fqid;
        }
        return result;
    }

    @Override
    public String getRepositoryName(String fqid) throws RemoteException {
        String result = (String)this._id2NameMap.get(fqid);
        return result;
    }

    public String getUrl() throws ServiceException, RemoteException {
        return this._url;
    }

    @Override
    public UserContextInterface getUserContext() throws RemoteException {
        return this._user;
    }

    @Override
    public List getRepositoryInfo() throws RemoteException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>(this._repositories.size());
        for (RepositoryEntry entry : this._repositories.values()) {
            RepositoryInfo info = new RepositoryInfo(entry.name, entry.fqid, entry.type, entry.desc, entry.path, entry.engine, entry.options, entry.access, entry.effectiveAccess, entry.format, entry.state, entry.metadataCreated, entry.metadataUpdated);
            result.add(info);
        }
        return result;
    }

    public RepositoryInfo getRepositoryInfoById(String fqid) throws RemoteException {
        String name = (String)this._id2NameMap.get(fqid);
        if (name == null) {
            return null;
        }
        RepositoryEntry entry = (RepositoryEntry)this._repositories.get(name.toUpperCase());
        if (entry == null) {
            return null;
        }
        return new RepositoryInfo(entry.name, entry.fqid, entry.type, entry.desc, entry.path, entry.engine, entry.options, entry.access, entry.effectiveAccess, entry.format, entry.state, entry.metadataCreated, entry.metadataUpdated);
    }

    @Override
    public RepositoryInterface getRepository(String name) throws ServiceException, RemoteException {
        if (name == null) {
            return null;
        }
        RepositoryInterface result = null;
        RepositoryEntry entry = (RepositoryEntry)this._repositories.get(name.toUpperCase());
        if (entry != null && ((result = entry.repos) == null || result.isDestroyed())) {
            entry.repos = result = new OMIServerRepository(this, name);
        }
        if (result == null) {
            int index = name.indexOf(46);
            if (index > 0) {
                String servername = name.substring(0, index);
                if (!servername.equals(this._name)) {
                    return null;
                }
                name = name.substring(index + 1);
            }
            if ((entry = (RepositoryEntry)this._repositories.get(name.toUpperCase())) != null && ((result = entry.repos) == null || result.isDestroyed())) {
                entry.repos = result = new OMIServerRepository(this, name);
            }
        }
        return result;
    }

    @Override
    public List getRepositories(List repositoryNames) throws ServiceException, RemoteException {
        RepositoryInterface ri = null;
        ArrayList<RepositoryInterface> result = new ArrayList<RepositoryInterface>(repositoryNames.size());
        for (String nextName : repositoryNames) {
            ri = this.getRepository(nextName);
            if (ri == null) continue;
            result.add(ri);
        }
        return result;
    }

    @Override
    public List getRepositories(boolean getAll) throws ServiceException, RemoteException {
        ArrayList<RepositoryInterface> results = new ArrayList<RepositoryInterface>();
        for (RepositoryEntry entry : this._repositories.values()) {
            RepositoryInterface ri = entry.repos;
            if (ri != null) {
                results.add(ri);
                continue;
            }
            if (!getAll) continue;
            entry.repos = ri = new OMIServerRepository(this, entry.name);
            results.add(ri);
        }
        return results;
    }

    public void RepositoryDeleted(String name) throws ServiceException, RemoteException {
        RepositoryEntry entry = (RepositoryEntry)this._repositories.get(name.toUpperCase());
        if (entry == null) {
            return;
        }
        String reposId = entry.fqid.substring(9);
        Map objectMap = this._mdstore.getDetailObjectMap();
        for (String nextId : new HashSet(objectMap.keySet())) {
            if (!nextId.startsWith(reposId)) continue;
            Root root = (Root)objectMap.get(nextId);
            this._mdstore.removeElementFromStore((CMetadata)root);
            this._cache.remove(nextId);
        }
        this._repositories.remove(name.toUpperCase());
    }

    @Override
    public FolderInterface getHomeFolder(String userName, UserFolderType type, Filter filter) throws ServiceException, RemoteException {
        return this.getHomeFolder(userName, type, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderInterface getHomeFolder(String userName, UserFolderType type, Filter filter, boolean createIfNecessary) throws ServiceException, RemoteException {
        block11: {
            String typeString = null;
            if (type == null) {
                type = UserFolderType.MYFOLDER;
            }
            typeString = type.getType();
            if (userName == null && "unknown".equals(userName = this._user.getName())) {
                return null;
            }
            MdOMIUtil util = this._mdfactory.getOMIUtil();
            if (filter == null) {
                filter = new Filter();
            }
            int filterFlags = filter.getOMRFlags();
            if (filter.getOMRTemplate() != null) {
                filterFlags |= 4;
            }
            filterFlags = (filter.getOMRFlags() & Integer.MIN_VALUE) != 0 ? (filterFlags &= Integer.MAX_VALUE) : (filterFlags |= 0x908);
            try {
                Tree userTree = null;
                Object object = this._cnxnSync;
                synchronized (object) {
                    userTree = util.getUserHomeFolder(this._mdstore, userName, typeString, filter.getOMRTemplate(), filterFlags, createIfNecessary);
                }
                if (userTree != null) {
                    FolderInterface userFolder = (FolderInterface)this.factoryProcess(userTree);
                    return userFolder;
                }
            }
            catch (MdException ex) {
                if (this.isConnectionException(ex)) {
                    this.reconnect();
                    return this.getHomeFolder(userName, type, filter, createIfNecessary);
                }
                if (!createIfNecessary) break block11;
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        return null;
    }

    @Override
    public String getProtocol() throws ServiceException, RemoteException {
        return "omi";
    }

    @Override
    public String getHost() throws ServiceException, RemoteException {
        return this._host;
    }

    @Override
    public int getPort() throws ServiceException, RemoteException {
        return (int)this._port;
    }

    @Override
    public String getDomain() throws ServiceException, RemoteException {
        return this._def.getDomain();
    }

    protected final void pulseCheck() throws ServiceException {
        if (this._isDestroyed) {
            if (this.closeStack != null && this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(RB.getStringResource("Repository.isdestroyed.ex.txt"), (Throwable)this.closeStack);
            }
            throw new ServiceException(RB.getStringResource("Repository.isdestroyed.ex.txt"));
        }
    }

    @Override
    public void reconnect() throws ServiceException, RemoteException {
        if (this._logger != null) {
            this._logger.debug("Reconnection to the metadata server being attempted.");
        }
        if (this._cnxnHandle != null) {
            this._cnxnHandle.close();
            this._cnxnHandle = null;
        }
        if (this._cnxnAdmin != null) {
            this._cnxnAdmin.destroy();
            this._cnxnAdmin = null;
        }
        if (this._iSecurity != null) {
            try {
                this._iSecurity._release();
            }
            finally {
                this._iSecurity = null;
            }
        }
        this.attemptConnection();
        this._mdfactory.getConnection().setCMRHandle(this._cnxn);
        this.notifyMetadataConnectionListeners();
    }

    private void setDomainOnCluster(Cluster cluster) {
        if (cluster != null) {
            Server[] servers = cluster.getServerArray();
            if (servers != null && servers.length > 0) {
                for (Server server : servers) {
                    if (server.getDomain() != null && !server.getDomain().isEmpty()) continue;
                    server.setDomain(this._def.getDomain());
                }
            }
            cluster.setServerArray(servers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attemptConnection() throws ServiceException {
        ServicesConnectionFactoryManager cxfManager = new ServicesConnectionFactoryManager();
        Environment environment = null;
        try {
            environment = (Environment)this._user.getSharedResource("ENVIRONMENT");
            cxfManager.setConnectionResources(environment);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        try {
            ManualConnectionFactoryConfiguration cxfConfig;
            if (this._cluster == null) {
                BridgeServer server = this.configureServer(this._def);
                cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
            } else {
                this.setDomainOnCluster(this._cluster);
                cxfConfig = new ManualConnectionFactoryConfiguration(this._cluster);
            }
            ServicesConnectionFactoryInterface cxf = cxfManager.getServicesFactory((ConnectionFactoryConfiguration)cxfConfig);
            try {
                if (this._mdfactory != null) {
                    this._mdfactory.setMdConnectionListener(null);
                }
                this._cnxnHandle = cxf.getConnection(this._user);
            }
            finally {
                if (this._mdfactory != null) {
                    this._mdfactory.setMdConnectionListener((MdConnectionListener)this);
                }
            }
            org.omg.CORBA.Object obj2 = this._cnxnHandle.getObject();
            this._cnxn = IOMIHelper.narrow((org.omg.CORBA.Object)obj2);
            this._cnxnAdmin = cxf.getAdminInterface();
            IServerInformation serverInfo = IServerInformationHelper.narrow((org.omg.CORBA.Object)obj2);
            IFilteredList filtList = serverInfo.UseCategory("Information", "");
            AnySeqHolder anySeqHolder = new AnySeqHolder();
            try {
                filtList.GetAttribute("Server.HostKnownBy", "value", anySeqHolder);
                this._host = anySeqHolder.value[0].extract_string();
            }
            catch (OBJECT_NOT_EXIST e) {
                try {
                    filtList.GetAttribute("Server.FullyQualifiedDNSName", "value", anySeqHolder);
                    this._host = anySeqHolder.value[0].extract_string();
                }
                catch (OBJECT_NOT_EXIST ex) {
                    filtList.GetAttribute("Server.DNSName", "value", anySeqHolder);
                    this._host = anySeqHolder.value[0].extract_string();
                }
            }
            filtList.GetAttribute("IOM.ServerPort", "value", anySeqHolder);
            this._port = anySeqHolder.value[0].extract_long();
            filtList.Close();
            this._url = "omi://" + this._host + ":" + this._port;
        }
        catch (InvalidCredentialsException ice) {
            throw new CredentialLoginServiceException(ice.getMessage());
        }
        catch (FatalConnectionFactoryException fcfe) {
            String eText = this.makeChainedMessage(fcfe);
            for (Throwable t = fcfe.getCause(); t != null; t = t.getCause()) {
                if (t instanceof UnknownHostException) {
                    throw new BadHostLoginServiceException(eText);
                }
                if (t instanceof UnresolvedAddressException) {
                    throw new BadHostLoginServiceException(eText);
                }
                if (!(t instanceof ConnectException)) continue;
                throw new ConnectRefusedLoginServiceException(eText);
            }
            throw new ServiceException(eText);
        }
        catch (Throwable t) {
            String eText = this.makeChainedMessage(t);
            for (Throwable t2 = t.getCause(); t2 != null; t2 = t2.getCause()) {
                if (t2 instanceof UnresolvedAddressException) {
                    throw new BadHostLoginServiceException(eText);
                }
                if (!(t2 instanceof ConnectException)) continue;
                throw new ConnectRefusedLoginServiceException(eText);
            }
            throw new ServiceException(eText);
        }
        return true;
    }

    protected String cachePath() throws RemoteException {
        String id = null;
        try {
            id = this._user.getResolvedUserId();
        }
        catch (ServiceException ex) {
            id = "unknown";
        }
        String cacheNodePath = null;
        String userid = this._user.getUniqueId();
        userid = userid.replace(':', '_');
        cacheNodePath = "/Metadata/omi/" + id + "/" + userid + "/" + this._host + "-" + this._port;
        return cacheNodePath;
    }

    private BridgeServer configureServer(ServerDef def) {
        String idpMechanism;
        String classID = "0217e202-b560-11db-ad91-001083ff6836";
        BridgeServer server = new BridgeServer(classID, def.getHost(), Integer.parseInt(def.getPort()));
        String domain = def.getDomain();
        server.setDomain(domain);
        if (def.getIsSecure()) {
            server.setEncryptionPolicy("optional");
            server.setEncryptionContent("all");
            String encryptionAlgorithms = (String)def.getAdvancedOptions().get("encryptionalgorithms");
            if (encryptionAlgorithms != null && encryptionAlgorithms.length() > 0) {
                server.setEncryptionAlgorithms(encryptionAlgorithms);
            }
        }
        if ((idpMechanism = (String)def.getAdvancedOptions().get("idpropagation")) != null) {
            String spn;
            server.setAuthService("Host");
            server.setSecurityPackage("Negotiate");
            String securityPackageList = (String)def.getAdvancedOptions().get("securitypackagelist");
            if (securityPackageList != null && securityPackageList.length() > 0) {
                server.setSecurityPackageList(securityPackageList);
            }
            if ((spn = (String)def.getAdvancedOptions().get("spn")) != null && spn.length() > 0) {
                server.setSPN(spn);
            }
        }
        return server;
    }

    protected String makeChainedMessage(Throwable t) {
        StringBuffer buffer = new StringBuffer(240);
        while (t != null) {
            buffer.append(t.getClass().getName());
            buffer.append(":");
            buffer.append(t.getMessage());
            buffer.append("  ");
            t = t.getCause();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getLoginsForAuthDomain(String domain) throws ServiceException, RemoteException {
        ArrayList<SimpleUserIdentity> results = null;
        this.pulseCheck();
        try {
            ISecurity_1_1 isec = this.getISecurity();
            String[][] options = new String[4][2];
            options[0][0] = "MaxListLen";
            options[0][1] = "99";
            options[1][0] = "IncludeBlankPasswords";
            options[1][1] = "NO";
            options[2][0] = "PrimaryOnly";
            options[2][1] = "NO";
            options[3][0] = "IdentityInfo";
            options[3][1] = "NO";
            VariableArray2dOfStringHolder output = new VariableArray2dOfStringHolder();
            Object object = this._cnxnSync;
            synchronized (object) {
                isec.GetLoginForAuthDomain("", domain, options, output);
            }
            String[][] value = output.value;
            if (value.length > 0) {
                results = new ArrayList<SimpleUserIdentity>(value.length);
                for (int i = 0; i < value.length; ++i) {
                    SimpleUserIdentity ident = new SimpleUserIdentity(value[i][0], value[i][1], domain);
                    results.add(ident);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (AuthDomainDoesNotExist ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidOptionName ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidOptionValue ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getLoginsForAuthDomain(domain);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (COMM_FAILURE ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getLoginsForAuthDomain(domain);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public RepositoryInterface getFoundationRepository() throws ServiceException, RemoteException {
        RepositoryInterface result = null;
        if (this._foundationReposName != null) {
            result = this.getRepository(this._foundationReposName);
        } else {
            this.loadRepositoryData();
            if (this._foundationReposName != null) {
                result = this.getRepository(this._foundationReposName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentityInterface generatePassword(String user) throws ServiceException, RemoteException {
        if (user == null) {
            user = "";
        }
        StringHolder genuser = new StringHolder();
        StringHolder genpassword = new StringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                this._cnxnHandle.generatePassword(user, genuser, genpassword);
            }
        }
        catch (ConnectionFactoryException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.generatePassword(user);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        SimpleUserIdentity result = new SimpleUserIdentity(genuser.value, genpassword.value, "TRUST", true);
        return result;
    }

    @Override
    public RootFolderInterface getRootFolder() throws ServiceException, RemoteException {
        SoftwareComponent rootComponent = this.getBipRoot();
        RootFolderInterface fi = (RootFolderInterface)this.factoryProcess(rootComponent);
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoftwareComponent getBipRoot() throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._bipRoot == null) {
            OMIRepositoryInterface ri = (OMIRepositoryInterface)this.getFoundationRepository();
            String repository = ri.getDefaultRepositoryId();
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent("ClassIdentifier", 0, ROOT_CLASSIDENTIFIER);
            fc.addComponent(new FilterComponent("Name", 0, BIP_COMPONENTNAME));
            fc.setAggregation(0);
            filter.setFilterComponent(fc);
            String type = "SoftwareComponent";
            int flags = 0;
            String filterString = filter.getXMLSelectString();
            List rootComponents = null;
            try {
                int my_flags = 396;
                if ((flags & Integer.MIN_VALUE) != 0) {
                    flags &= Integer.MAX_VALUE;
                    my_flags = 0;
                }
                Object object = this._cnxnSync;
                synchronized (object) {
                    rootComponents = this._mdfactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._mdstore, repository, type, my_flags | flags, filterString);
                }
            }
            catch (MdException mex) {
                if (this.isConnectionException(mex)) {
                    this.reconnect();
                    return this.getBipRoot();
                }
                throw new ServiceException(mex, mex.getMessage());
            }
            for (SoftwareComponent folder : rootComponents) {
                if (!folder.getName().equals(BIP_COMPONENTNAME)) continue;
                this._bipRoot = folder;
            }
        }
        if (this._bipRoot == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.norootfnd.msg.txt"));
        }
        return this._bipRoot;
    }

    @Override
    public void loadTypes() throws ServiceException, RemoteException {
        this.loadTypes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTypes(boolean force) throws ServiceException, RemoteException {
        InformationServiceInterface iis = OMIServerRepository.getInformationService();
        this._typeMap = force ? null : iis.getTypeMap(this._url);
        if (this._typeMap == null) {
            String reposid = null;
            Collection values = this._repositories.values();
            for (RepositoryEntry entry : values) {
                if (!entry.type.equalsIgnoreCase("Foundation")) continue;
                reposid = entry.fqid;
            }
            if (reposid != null) {
                try {
                    String template = "<Templates>\n  <TypeDefinition>\n    <Properties/>\n    <Notes/>  </TypeDefinition>\n</Templates>";
                    List defList = null;
                    Object object = this._cnxnSync;
                    synchronized (object) {
                        defList = this._mdfactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._mdstore, reposid, "TypeDefinition", 268, template);
                    }
                    if (defList.size() == 0) {
                        this._typeMap = Collections.EMPTY_MAP;
                        return;
                    }
                    this._typeMap = new HashMap(defList.size() * 4);
                    for (TypeDefinition nextDef : defList) {
                        TypeDescriptorImpl tdi = new TypeDescriptorImpl(nextDef);
                        if (tdi.getTypeName() == null || tdi.getTypeName().length() == 0) continue;
                        this._typeMap.put(tdi.getTypeName(), tdi);
                    }
                    iis.addTypeMap(this._url, this._typeMap);
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this.reconnect();
                        this.loadTypes();
                        this.loadExplicitIdentityGroups();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExplicitIdentityGroups() throws ServiceException, RemoteException {
        block10: {
            if (this._explicitIdGrpsMap == null) {
                try {
                    OMIRepositoryInterface ri = (OMIRepositoryInterface)this.getFoundationRepository();
                    if (ri == null) {
                        return;
                    }
                    String reposid = ri.getDefaultRepositoryId();
                    if (reposid == null) break block10;
                    Filter filter = new Filter();
                    FilterComponent fc = new FilterComponent("Name", 0, "SASUSERS");
                    fc.addComponent(new FilterComponent("Name", 0, "PUBLIC"));
                    fc.setAggregation(1);
                    filter.setFilterComponent(fc);
                    String filterString = filter.getXMLSelectString();
                    List idGrpList = null;
                    Iterator iterator = this._cnxnSync;
                    synchronized (iterator) {
                        idGrpList = this._mdfactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._mdstore, reposid, "IdentityGroup", 136, filterString);
                    }
                    if (idGrpList.size() == 0) {
                        this._explicitIdGrpsMap = Collections.EMPTY_MAP;
                        return;
                    }
                    this._explicitIdGrpsMap = new HashMap(idGrpList.size() * 4);
                    for (IdentityGroup explIdGrp : idGrpList) {
                        IdentityGroupInterface smartExplIdGrp = (IdentityGroupInterface)ri.factoryProcess(explIdGrp);
                        this._explicitIdGrpsMap.put(smartExplIdGrp.getName(), smartExplIdGrp);
                    }
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this.reconnect();
                        this.loadTypes();
                        this.loadExplicitIdentityGroups();
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeRequest(String request) throws ServiceException, RemoteException {
        StringHolder outStringHolder = new StringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                this._cnxn.DoRequest(request, outStringHolder);
            }
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.executeRequest(request);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.executeRequest(request);
        }
        return outStringHolder.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationAuthorization> getApplicationActionsAuthorizations(SoftwareComponentInterface app, RoleInterface role, boolean explicitRoleActions) throws ServiceException, RemoteException {
        this.pulseCheck();
        List<ApplicationAuthorization> results = null;
        ISecurity_1_1 isec = this.getISecurity();
        String roleSpec = "ROLE_OBJID:" + role.getReposId();
        String[][] options = explicitRoleActions ? new String[2][1] : new String[1][1];
        options[0][0] = "ALLATTRS";
        if (explicitRoleActions) {
            options[1][0] = "EXPLICITROLEACTIONS";
        }
        VariableArray2dOfStringHolder authHolder = new VariableArray2dOfStringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isec.GetApplicationActionsAuthorizations(roleSpec, app.getReposId(), options, authHolder);
            }
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getApplicationActionsAuthorizations(app, role, explicitRoleActions);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getApplicationActionsAuthorizations(app, role, explicitRoleActions);
        }
        String[][] auths = authHolder.value;
        if (auths.length > 0) {
            results = new ArrayList<ApplicationAuthorization>(auths.length);
            for (int i = 0; i < auths.length; ++i) {
                ApplicationAuthorization newAuth = new ApplicationAuthorization(auths[i][0], auths[i][1], auths[i][2].equalsIgnoreCase("y"), auths[i][3], auths[i][4], auths[i][5]);
                results.add(newAuth);
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getApplicationActionsAuthorizations(SoftwareComponentInterface app) throws ServiceException, RemoteException {
        this.pulseCheck();
        ArrayList<ApplicationAuthorization> results = null;
        ISecurity_1_1 isec = this.getISecurity();
        String[][] options = new String[1][1];
        options[0][0] = "ALLATTRS";
        VariableArray2dOfStringHolder authHolder = new VariableArray2dOfStringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isec.GetApplicationActionsAuthorizations("", app.getReposId(), options, authHolder);
            }
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getApplicationActionsAuthorizations(app);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getApplicationActionsAuthorizations(app);
        }
        String[][] auths = authHolder.value;
        if (auths.length > 0) {
            results = new ArrayList<ApplicationAuthorization>(auths.length);
            for (int i = 0; i < auths.length; ++i) {
                ApplicationAuthorization newAuth = new ApplicationAuthorization(auths[i][0], auths[i][1], auths[i][2].equalsIgnoreCase("y"), auths[i][3], auths[i][4], auths[i][5]);
                results.add(newAuth);
            }
        } else {
            results = Collections.EMPTY_LIST;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getServerVersion() throws ServiceException, RemoteException {
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                int result = this._mdfactory.getConnection().getPlatformVersion();
                return result;
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getServerVersion();
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public MetadataInterface factoryProcess(Object o) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (o == null) {
            return null;
        }
        try {
            MdStore theirStore;
            Root root2;
            Root root = (Root)o;
            if (o instanceof RemoteStub && (root2 = (Root)this._mdstore.getObject(root.getFQID())) != null) {
                root = root2;
            }
            if (!(theirStore = root.getObjectStore()).equals((Object)this._mdstore)) {
                Exception ex = new Exception("I was requested to create a smart object from a foreign store.");
                if (this._logger != null) {
                    this._logger.warn(ex.getMessage(), (Throwable)ex);
                }
            }
            String id = root.getFQID();
            MetadataInterface result = null;
            RepositoryInterface ri = this.getRepositoryForObjectId(id);
            String key = ri.getFactoryKey(o);
            result = (MetadataInterface)this._cache.get(id);
            String action = this._factory.getAction(key, o, ri);
            if (result != null && action != null) {
                int index = action.lastIndexOf(":");
                String className = action.substring(index + 1);
                Class newClass = null;
                try {
                    newClass = this._factory.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (newClass == null || result.getClass().equals(newClass)) {
                    try {
                        Class<Metadata> c = Metadata.class;
                        Field field = c.getDeclaredField("_omrCreateDate");
                        field.setAccessible(true);
                        field.set(result, null);
                        field = c.getDeclaredField("_omrModifyDate");
                        field.setAccessible(true);
                        field.set(result, null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return result;
                }
                this._cache.remove(result);
            }
            if ((result = this._factory.processWithRepository(root, ri)) == null) {
                result = new Metadata(root);
                result.setRepository(ri);
            }
            return result;
        }
        catch (ClassCastException ccex) {
            throw new ServiceException(ccex, RB.getStringResource("Repository.wrongtype.ex.txt"));
        }
    }

    private RepositoryInterface getRepositoryForObjectId(String id) throws ServiceException {
        String fqid = "A0000001." + id.substring(0, 8);
        RepositoryInterface ri = null;
        try {
            ri = this.getRepository(this.getRepositoryName(fqid));
            if (ri == null) {
                this.loadRepositoryData();
                ri = this.getRepository(this.getRepositoryName(fqid));
                if (ri == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIServer.nosuchrepos.ex.fmt.txt", (Object)fqid));
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return ri;
    }

    @Override
    public TypeDescriptorInterface getTypeDescriptor(String typeName) throws ServiceException, RemoteException {
        if (this._typeMap == null) {
            this.loadTypes();
        }
        if (this._typeMap == null) {
            return null;
        }
        return (TypeDescriptorInterface)this._typeMap.get(typeName);
    }

    @Override
    public Collection<TypeDescriptorInterface> getTypeDescriptors() throws RemoteException {
        if (this._typeMap == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this._typeMap.values());
    }

    @Override
    public IdentityGroupInterface getExplicitIdentityGroup(String idGrpName) throws ServiceException, RemoteException {
        if (this._explicitIdGrpsMap == null) {
            this.loadExplicitIdentityGroups();
        }
        if (this._explicitIdGrpsMap == null) {
            return null;
        }
        return (IdentityGroupInterface)this._explicitIdGrpsMap.get(idGrpName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInternalDomain() throws ServiceException, RemoteException {
        String result = null;
        this.pulseCheck();
        ISecurity_1_1 isec = this.getISecurity();
        String[][] options = new String[1][2];
        options[0][0] = "";
        options[0][1] = "";
        VariableArray2dOfStringHolder output = new VariableArray2dOfStringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isec.GetInfo("SASPW_Alias", "", options, output);
            }
            result = output.value[0][1];
        }
        catch (InvalidInfoType ex) {
            result = "";
        }
        catch (InvalidOptionName ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidOptionValue ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getInternalDomain();
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getInternalDomain();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentityInfo getIdentityInfo() throws ServiceException, RemoteException {
        this.pulseCheck();
        IdentityInfo info = new IdentityInfo();
        ISecurity_1_1 isec = this.getISecurity();
        String[][] options = new String[1][2];
        options[0][0] = "ReturnUnrestrictedSource";
        options[0][1] = "";
        VariableArray2dOfStringHolder output = new VariableArray2dOfStringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isec.GetInfo("GetIdentityInfo", "", options, output);
            }
            String[][] value = output.value;
            if (value.length > 0) {
                for (int i = 0; i < value.length; ++i) {
                    String keyword = value[i][0];
                    String result = value[i][1];
                    if ("UserClass".equalsIgnoreCase(keyword)) {
                        info.setUserClass(result);
                        continue;
                    }
                    if ("AuthenticatedUserId".equalsIgnoreCase(keyword)) {
                        info.setAuthenticatedUserId(result);
                        continue;
                    }
                    if ("IdentityName".equalsIgnoreCase(keyword)) {
                        info.setName(result);
                        continue;
                    }
                    if ("IdentityType".equalsIgnoreCase(keyword)) {
                        info.setType(result);
                        continue;
                    }
                    if ("IdentityObjectId".equalsIgnoreCase(keyword)) {
                        info.setReposid(result);
                        continue;
                    }
                    if (!"UnrestrictedSource".equalsIgnoreCase(keyword)) continue;
                    info.setPowerSource(result);
                }
            }
        }
        catch (InvalidInfoType ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidOptionName ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidOptionValue ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getIdentityInfo();
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getIdentityInfo();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getEnterprisePolicies() throws ServiceException, RemoteException {
        HashMap<String, String> results = null;
        this.pulseCheck();
        ISecurity_1_1 isec = this.getISecurity();
        String[][] options = new String[1][2];
        options[0][0] = "All";
        options[0][1] = "";
        VariableArray2dOfStringHolder output = new VariableArray2dOfStringHolder();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isec.GetInfo("EnterprisePolicies", "", options, output);
            }
            String[][] value = output.value;
            if (value.length > 0) {
                results = new HashMap<String, String>(value.length * 4);
                for (int i = 0; i < value.length; ++i) {
                    results.put(value[i][0], value[i][1]);
                }
            } else {
                results = Collections.EMPTY_MAP;
            }
        }
        catch (InvalidInfoType ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidOptionName ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidOptionValue ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getEnterprisePolicies();
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getEnterprisePolicies();
        }
        return results;
    }

    private ISecurity_1_1 getISecurity() throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._mdfactory == null) {
            throw new IllegalStateException(RB.getStringResource("OMIRepository.iomnotset.ex.txt"));
        }
        if (this._iSecurity == null) {
            try {
                IOMI cnxn = this._mdfactory.getConnection().getCMRHandle();
                org.omg.CORBA.Object obj = cnxn._duplicate();
                this._iSecurity = ISecurity_1_1Helper.narrow((org.omg.CORBA.Object)obj);
            }
            catch (COMM_FAILURE ex) {
                if (this.isConnectionException(ex)) {
                    this.reconnect();
                    return this.getISecurity();
                }
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        if (this._iSecurity == null) {
            throw new ServiceException(RB.getStringResource("OMIServer.nosec11.ex.txt"));
        }
        return this._iSecurity;
    }

    private ISecurityAdmin getISecAdmin() throws ServiceException, RemoteException {
        IOMI cnxn = this._mdfactory.getConnection().getCMRHandle();
        org.omg.CORBA.Object obj = cnxn._duplicate();
        try {
            ISecurityAdmin isa = ISecurityAdminHelper.narrow((org.omg.CORBA.Object)obj);
            if (isa == null) {
                throw new ServiceException(RB.getStringResource("OMIServer.nosecacmin.ex.txt"));
            }
            return isa;
        }
        catch (COMM_FAILURE ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getISecAdmin();
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCredentials(String subject) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            ISecurity_1_1 is = this.getISecurity();
            StringHolder stringHolder = new StringHolder();
            Object object = this._cnxnSync;
            synchronized (object) {
                is.GetCredentials(subject, stringHolder);
            }
            return stringHolder.value;
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getCredentials(subject);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NoCredential ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getCredentials(subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeCredentials(String credential) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            ISecurity_1_1 is = this.getISecurity();
            Object object = this._cnxnSync;
            synchronized (object) {
                is.FreeCredentials(credential);
            }
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.freeCredentials(credential);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            this.freeCredentials(credential);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAuthorized(String credential, String resource, String permission) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (credential == null) {
            credential = "";
        }
        try {
            StringHolder stringHolder = new StringHolder();
            BooleanHolder booleanHolder = new BooleanHolder();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("checking authorization for " + credential + " to " + permission + " on " + resource);
            }
            ISecurity_1_1 is = this.getISecurity();
            Object object = this._cnxnSync;
            synchronized (object) {
                is.IsAuthorized(credential, resource, permission, stringHolder, booleanHolder);
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("Authorization check result is " + stringHolder.value + ' ' + booleanHolder.value);
            }
            return booleanHolder.value;
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.isAuthorized(credential, resource, permission);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.isAuthorized(credential, resource, permission);
        }
    }

    @Override
    public boolean isUserAuthorized(String repositoryId, String permission) throws ServiceException, RemoteException {
        if (repositoryId.length() == 17 && repositoryId.charAt(8) == '.') {
            repositoryId = repositoryId.substring(9);
        } else if (this._repositories.get(repositoryId) != null) {
            RepositoryEntry re = (RepositoryEntry)this._repositories.get(repositoryId);
            repositoryId = re.fqid;
            repositoryId = repositoryId.substring(9);
        }
        boolean result = this.isAuthorized("", "REPOSID:" + repositoryId, permission);
        return result;
    }

    @Override
    public List<AuthorizationObjectsResult> getAuthorizationsForObjects(List<MetadataInterface> resources, List<String> permissions) throws ServiceException, RemoteException {
        ArrayList<AuthorizationObjectsResult> result = null;
        ISecurity_1_1 isec = this.getISecurity();
        ArrayList<String> resourceIdList = new ArrayList<String>();
        for (MetadataInterface nextResource : resources) {
            Root root = (Root)nextResource.getRepositoryEntity();
            String resourceId = "OMSOBJ:" + root.getCMetadataType() + "/" + root.getFQID();
            resourceIdList.add(resourceId);
        }
        String[] resourceArray = new String[resourceIdList.size()];
        resourceArray = resourceIdList.toArray(resourceArray);
        String[] permissionArray = new String[permissions.size()];
        permissionArray = permissions.toArray(permissionArray);
        double a = permissions.size();
        int mask = (int)StrictMath.pow(2.0, a) - 1;
        int[] inmask = new int[resources.size()];
        for (int i = 0; i < resources.size(); ++i) {
            inmask[i] = mask;
        }
        LongSeqHolder grants = new LongSeqHolder();
        LongSeqHolder conditionNDX = new LongSeqHolder();
        LongSeqHolder conditionPermMask = new LongSeqHolder();
        StringSeqHolder conditions = new StringSeqHolder();
        try {
            isec.GetAuthorizationsForObjects("", permissionArray, resourceArray, inmask, grants, conditionNDX, conditionPermMask, conditions);
            result = new ArrayList<AuthorizationObjectsResult>();
            int[] grantsArray = grants.value;
            for (int i = 0; i < resources.size(); ++i) {
                ArrayList<String> grantList = new ArrayList<String>();
                MetadataInterface nextResource = resources.get(i);
                int nextGrants = grantsArray[i];
                for (int p = 0; p < permissions.size(); ++p) {
                    int grantMask = 1 << p;
                    if ((grantMask & nextGrants) <= 0) continue;
                    grantList.add(permissions.get(p));
                }
                AuthorizationObjectsResult nextResult = new AuthorizationObjectsResult(nextResource, grantList);
                result.add(nextResult);
            }
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidPermMask ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (ObjectDoesNotExist ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidObjectSpecification ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (PermissionDoesNotExist ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (COMM_FAILURE ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getAuthorizationsForObjects(resources, permissions);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getAuthorizationsForObjects(resources, permissions);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAuthorizationsOnObj(String resource, List identities, List permissions, int flags) throws ServiceException, RemoteException {
        ArrayList<Authorization> results = new ArrayList<Authorization>();
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            try {
                Object it;
                String[][] idArray = new String[0][0];
                if (identities != null) {
                    idArray = new String[identities.size()][2];
                    for (int i = 0; i < identities.size(); ++i) {
                        IdentityInterface ii = (IdentityInterface)identities.get(i);
                        idArray[i][0] = ii.getIdentityType();
                        idArray[i][1] = ii.getName();
                    }
                }
                String permString = "";
                if (permissions != null) {
                    StringBuffer buf = new StringBuffer();
                    it = permissions.iterator();
                    boolean first_perm = true;
                    while (it.hasNext()) {
                        Permission perm = (Permission)it.next();
                        if (!first_perm) {
                            buf.append(",");
                        }
                        buf.append(perm.getAction());
                        first_perm = false;
                    }
                    permString = buf.toString();
                }
                VariableArray2dOfAnyHolder authHolder = new VariableArray2dOfAnyHolder();
                it = this._cnxnSync;
                synchronized (it) {
                    isa.GetAuthorizationsOnObj("", resource, flags, idArray, permString, authHolder);
                }
                Any[][] authValue = authHolder.value;
                for (int i = 0; i < authValue.length; ++i) {
                    String idType = authValue[i][0].extract_string();
                    String idName = authValue[i][1].extract_string();
                    int authSource = authValue[i][2].extract_long();
                    String authType = "";
                    if ((authSource & 3) > 0) {
                        authType = (authSource & 2) > 0 ? "Grant" : "Deny";
                        authSource = 1;
                    } else if ((authSource & 0xC) > 0) {
                        authType = (authSource & 8) > 0 ? "Grant" : "Deny";
                        authSource = 2;
                    } else if ((authSource & 0x30) > 0) {
                        authType = (authSource & 0x20) > 0 ? "Grant" : "Deny";
                        authSource = 3;
                    }
                    String authString = authValue[i][3].extract_string();
                    String condString = authValue[i][4].extract_string();
                    Authorization nextResult = new Authorization(idType, idName, authString, authSource, authType, condString);
                    results.add(nextResult);
                }
            }
            catch (SECAD_INVALID_RESOURCE_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_TC_HANDLE ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_IDENTITY_DOES_NOT_EXIST ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_IDENTITY_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_PERMISSION_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_NOT_AUTHORIZED ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_ACTION ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getAuthorizationsOnObj(resource, identities, permissions, flags);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getAuthorizationsOnObj(resource, identities, permissions, flags);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthorizationsOnObj(String resource, List authorizations, int flags) throws ServiceException, RemoteException {
        if (authorizations == null || authorizations.size() == 0) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            try {
                String[][] authArray = new String[authorizations.size()][5];
                for (int i = 0; i < authorizations.size(); ++i) {
                    Authorization auth = (Authorization)authorizations.get(i);
                    authArray[i][0] = auth.getIdentType();
                    authArray[i][1] = auth.getIdentName();
                    authArray[i][2] = auth.getAuthType().substring(0, 1).toUpperCase();
                    authArray[i][3] = auth.getAuthAction();
                    authArray[i][4] = auth.getConditions();
                }
                Object object = this._cnxnSync;
                synchronized (object) {
                    isa.SetAuthorizationsOnObj("", resource, flags, authArray);
                }
            }
            catch (SECAD_INVALID_RESOURCE_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_TC_HANDLE ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_IDENTITY_DOES_NOT_EXIST ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_IDENTITY_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_PERMISSION_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_NOT_AUTHORIZED ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_ACTION ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.setAuthorizationsOnObj(resource, authorizations, flags);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            this.setAuthorizationsOnObj(resource, authorizations, flags);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getIdentitiesOnObj(String resource, int flags) throws ServiceException, RemoteException {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> results = new ArrayList<String>();
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            VariableArray2dOfStringHolder idList = new VariableArray2dOfStringHolder();
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.GetIdentitiesOnObj("", resource, flags, idList);
            }
            String[][] idArray = idList.value;
            for (int i = 0; i < idArray.length; ++i) {
                results.add(idArray[i][0] + "/" + idArray[i][1]);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getIdentitiesOnObj(resource, flags);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getIdentitiesOnObj(resource, flags);
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getACTsOnObj(String resource) throws ServiceException, RemoteException {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ACTEntry> results = new ArrayList<ACTEntry>();
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.GetACTsOnObj("", resource, 0, actList);
            }
            String[][] actArray = actList.value;
            for (int i = 0; i < actArray.length; ++i) {
                ACTEntry entry = new ACTEntry(actArray[i][0], actArray[i][1], actArray[i][2], null);
                results.add(entry);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getACTsOnObj(resource);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getACTsOnObj(resource);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyACTToObj(String resource, String act) throws ServiceException, RemoteException {
        if (resource == null || act == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.ApplyACTToObj("", resource, 0, act);
            }
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_IN_DEPENDENT_REPOS ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_OBJECT_NOT_ACT ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.applyACTToObj(resource, act);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            this.applyACTToObj(resource, act);
            return;
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeACTFromObj(String resource, String act) throws ServiceException, RemoteException {
        if (resource == null || act == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.RemoveACTFromObj("", resource, 0, act);
            }
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_NOT_REMOVED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.removeACTFromObj(resource, act);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            this.removeACTFromObj(resource, act);
            return;
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAccessControlTemplateList(RepositoryInterface repository, int flags) throws ServiceException, RemoteException {
        ISecurityAdmin isa = this.getISecAdmin();
        ArrayList<ACTEntry> results = null;
        try {
            results = new ArrayList<ACTEntry>();
            String repos = "REPOSID:" + ((OMIRepositoryInterface)repository).getDefaultRepositoryId().substring(9);
            VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.GetAccessControlTemplateList("", repos, flags, actList);
            }
            String[][] actArray = actList.value;
            for (int i = 0; i < actArray.length; ++i) {
                ACTEntry entry = new ACTEntry(actArray[i][1], actArray[i][2], actArray[i][3], actArray[i][4]);
                results.add(entry);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getAccessControlTemplateList(repository, flags);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getAccessControlTemplateList(repository, flags);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAccessControTemplate(RepositoryInterface repository, ACTEntry act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        if (act.getName() == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            int attCnt = 1;
            String repos = "REPOSID:" + ((OMIRepositoryInterface)repository).getDefaultRepositoryId().substring(9);
            String name = act.getName();
            String description = act.getDescription();
            String use = act.getUse();
            if (description != null) {
                ++attCnt;
            }
            if (use != null) {
                ++attCnt;
            }
            String[][] actAttArray = new String[attCnt][2];
            int i = 0;
            actAttArray[i][0] = "NAME";
            actAttArray[i][1] = name;
            ++i;
            if (description != null) {
                actAttArray[i][0] = "DESC";
                actAttArray[i][1] = description;
                ++i;
            }
            if (use != null) {
                actAttArray[i][0] = "USE";
                actAttArray[i][1] = use;
            }
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.CreateAccessControlTemplate("", repos, actAttArray);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_ALREADY_EXISTS ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.createAccessControTemplate(repository, act);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            this.createAccessControTemplate(repository, act);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyAccessControlTemplate(String act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.DestroyAccessControlTemplate("", act);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.destroyAccessControlTemplate(act);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            this.destroyAccessControlTemplate(act);
            return;
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccessControlTemplateAttribs(RepositoryInterface repository, ACTEntry act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        if (act.getName() == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            int attCnt = 1;
            String resourceId = "OMSOBJ:AccessControlTemplate/" + act.getObjId();
            String name = act.getName();
            String description = act.getDescription();
            String use = act.getUse();
            if (description != null) {
                ++attCnt;
            }
            if (use != null) {
                ++attCnt;
            }
            String[][] actAttArray = new String[attCnt][2];
            int i = 0;
            actAttArray[i][0] = "NAME";
            actAttArray[i][1] = name;
            ++i;
            if (description != null) {
                actAttArray[i][0] = "DESC";
                actAttArray[i][1] = description;
                ++i;
            }
            if (use != null) {
                actAttArray[i][0] = "USE";
                actAttArray[i][1] = use;
            }
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.SetAccessControlTemplateAttribs("", resourceId, actAttArray);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_ALREADY_EXISTS ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.setAccessControlTemplateAttribs(repository, act);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            this.setAccessControlTemplateAttribs(repository, act);
            return;
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ACTEntry getAccessControlTemplateAttribs(String act) throws ServiceException, RemoteException {
        if (act == null) {
            return null;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
            Object object = this._cnxnSync;
            synchronized (object) {
                isa.GetAccessControlTemplateAttribs("", act, actList);
            }
            String[][] actArray = actList.value;
            String name = null;
            String description = null;
            String use = null;
            for (int i = 0; i < actArray.length; ++i) {
                String attr = actArray[i][0];
                if ("NAME".equalsIgnoreCase(attr)) {
                    name = actArray[i][1];
                    continue;
                }
                if ("DESCRIPTION".equalsIgnoreCase(attr)) {
                    description = actArray[i][1];
                    continue;
                }
                if (!"USE".equalsIgnoreCase(attr)) continue;
                use = actArray[i][1];
            }
            String objId = act.substring(act.indexOf("/") + 1);
            ACTEntry entry = new ACTEntry(objId, name, description, use);
            return entry;
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getAccessControlTemplateAttribs(act);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getAccessControlTemplateAttribs(act);
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthResult isAuthorizedWithConditions(String credential, String resource, String permission) throws ServiceException, RemoteException {
        if (resource == null) {
            return null;
        }
        if (permission == null) {
            return null;
        }
        try {
            if (credential == null) {
                credential = "";
            }
            StringHolder stringHolder = new StringHolder();
            BooleanHolder booleanHolder = new BooleanHolder();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("checking authorization for " + credential + " to " + permission + " on " + resource);
            }
            ISecurity_1_1 is = this.getISecurity();
            Object object = this._cnxnSync;
            synchronized (object) {
                is.IsAuthorized(credential, resource, permission, stringHolder, booleanHolder);
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("Authorization check result is " + stringHolder.value + " " + booleanHolder.value);
            }
            AuthResult result = new AuthResult(booleanHolder.value, stringHolder.value);
            return result;
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.isAuthorizedWithConditions(credential, resource, permission);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.isAuthorizedWithConditions(credential, resource, permission);
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[][] getAuthorizations(String authType, String credHandle, String resource, String permission) throws ServiceException, RemoteException {
        if (authType == null || resource == null || permission == null) {
            return null;
        }
        if (credHandle == null) {
            credHandle = "";
        }
        try {
            ISecurity_1_1 is = this.getISecurity();
            VariableArray2dOfStringHolder returnAuthorizations = new VariableArray2dOfStringHolder();
            Object object = this._cnxnSync;
            synchronized (object) {
                is.GetAuthorizations(authType, credHandle, resource, permission, returnAuthorizations);
            }
            return returnAuthorizations.value;
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getAuthorizations(authType, credHandle, resource, permission);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            this.reconnect();
            return this.getAuthorizations(authType, credHandle, resource, permission);
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidAuthType ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCountNoSecurity(Filter filter, String association) throws ServiceException, RemoteException {
        Object reposId;
        if (association == null) {
            association = "";
        }
        VariableArray2dOfStringHolder result = new VariableArray2dOfStringHolder();
        String template = filter.getOMRTemplate();
        int flags = 0x184 | filter.getOMRFlags();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<GetMetadataObjects>");
        String repository = filter.getOMRRepository();
        if (repository != null && (repository.length() != 17 || repository.charAt(8) != '.')) {
            RepositoryEntry entry = (RepositoryEntry)this._repositories.get(repository.toUpperCase());
            if (entry == null) {
                this.debug("com.sas.services.information.OMIRepository", "repository " + repository + " wasn't found in the list for this server");
                Iterator coll = this._repositories.values().iterator();
                while (coll.hasNext()) {
                    this.debug("com.sas.services.information.OMIRepository", "It does have: " + ((RepositoryEntry)coll.next()).fqid);
                }
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (Object)repository));
            }
            reposId = entry.fqid;
            repository = reposId;
        }
        if (repository == null) {
            flags |= 0x2000;
            OMIRepositoryInterface ri = (OMIRepositoryInterface)this.getFoundationRepository();
            repository = ri.getDefaultRepositoryId();
        }
        buffer.append("  <Reposid>" + repository + "</Reposid>");
        buffer.append("  <Type>" + filter.getOMRType() + "</Type>");
        buffer.append("  <Objects/>");
        buffer.append("  <NS>SAS</NS>");
        buffer.append("  <Flags>" + flags + "</Flags>");
        buffer.append("  <options>");
        buffer.append(filter.getXMLSelectString());
        if (template != null) {
            buffer.append(template);
        }
        buffer.append("  </options>");
        buffer.append("</GetMetadataObjects>");
        ISecurity_1_1 isec = this.getISecurity();
        try {
            reposId = this._cnxnSync;
            synchronized (reposId) {
                isec.GetAuthorizations("getCountNoSecurity", "", buffer.toString(), association, result);
            }
        }
        catch (GenericError t) {
            if (this.isConnectionException(t)) {
                this.reconnect();
                return this.getCountNoSecurity(filter, association);
            }
            throw new ServiceException(t, t.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getCountNoSecurity(filter, association);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidAuthType t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (InvalidResourceSpec t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (NotTrustedUser t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (InvalidCredHandle ich) {
            throw new ServiceException(ich, ich.getMessage());
        }
        if (result != null) {
            String string = result.value[0][1];
            int count = Integer.parseInt(string);
            return count;
        }
        return 0;
    }

    @Override
    public void setInternalPassword(String username, String password) throws ServiceException, RemoteException {
        ISecurity_1_1 isec = this.getISecurity();
        try {
            isec.SetInternalPassword(username, password);
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.setInternalPassword(username, password);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.setInternalPassword(username, password);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setSelfInternalPassword(String username, String oldPassword, String newPassword) throws ServiceException, RemoteException {
        IPasswordControl iPasswordControl = IPasswordControlHelper.narrow((org.omg.CORBA.Object)this._mdfactory.getConnection().getCMRHandle());
        try {
            iPasswordControl.ChangePassword(username + "@" + this.getInternalDomain(), OMIServer.encodePassword(oldPassword), OMIServer.encodePassword(newPassword));
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.setSelfInternalPassword(username, oldPassword, newPassword);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    public static String encodePassword(String password) {
        if (password == null || password.trim().length() == 0) {
            return password;
        }
        if (SasPasswordString.isEncoded((String)password)) {
            return password;
        }
        try {
            return SasPasswordString.encode((String)"sas002", (String)password);
        }
        catch (SasPasswordEncodingException e) {
            return password;
        }
    }

    @Override
    public void deleteInternalPassword(String username) throws ServiceException, RemoteException {
        ISecurity_1_1 isec = this.getISecurity();
        try {
            isec.DeleteInternalLogin(username);
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.deleteInternalPassword(username);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.deleteInternalPassword(username);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public InternalLoginSitePolicies getInternalLoginSitePolicies() throws ServiceException, RemoteException {
        ISecurity_1_1 isec = this.getISecurity();
        try {
            IntHolder siteMinPasswordLength = new IntHolder();
            BooleanHolder siteIsDigitRequired = new BooleanHolder();
            BooleanHolder siteIsMixedCaseRequired = new BooleanHolder();
            IntHolder siteSizeHistoryList = new IntHolder();
            IntHolder sitePasswordChangeDelayInMinutes = new IntHolder();
            IntHolder siteExpirationDays = new IntHolder();
            IntHolder siteNumFailuresForLockout = new IntHolder();
            IntHolder siteLockoutInMinutes = new IntHolder();
            IntHolder siteDaysToSuspension = new IntHolder();
            isec.GetInternalLoginSitePolicies(siteMinPasswordLength, siteIsDigitRequired, siteIsMixedCaseRequired, siteSizeHistoryList, sitePasswordChangeDelayInMinutes, siteExpirationDays, siteNumFailuresForLockout, siteLockoutInMinutes, siteDaysToSuspension);
            InternalLoginSitePolicies result = new InternalLoginSitePolicies(siteMinPasswordLength.value, siteIsDigitRequired.value, siteIsMixedCaseRequired.value, siteSizeHistoryList.value, sitePasswordChangeDelayInMinutes.value, siteExpirationDays.value, siteNumFailuresForLockout.value, siteLockoutInMinutes.value, siteDaysToSuspension.value);
            return result;
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getInternalLoginSitePolicies();
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getInternalLoginSitePolicies();
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public InternalLoginUserInfo getInternalLoginUserInfo(String username) throws ServiceException, RemoteException {
        ISecurity_1_1 isec = this.getISecurity();
        try {
            BooleanHolder hasInternalLogin = new BooleanHolder();
            BooleanHolder isDisabled = new BooleanHolder();
            BooleanHolder bypassStrength = new BooleanHolder();
            BooleanHolder bypassHistory = new BooleanHolder();
            BooleanHolder useStdPasswordExpirationDays = new BooleanHolder();
            IntHolder passwordExpirationDays = new IntHolder();
            BooleanHolder bypassLockout = new BooleanHolder();
            BooleanHolder bypassInactivitySuspension = new BooleanHolder();
            BooleanHolder doesAccountExpire = new BooleanHolder();
            DateTimeHolder accountExpirationDate = new DateTimeHolder();
            DateTimeHolder lastPasswordChange = new DateTimeHolder();
            DateTimeHolder lastLogin = new DateTimeHolder();
            IntHolder numFailuresSinceLogin = new IntHolder();
            DateTimeHolder lastLockout = new DateTimeHolder();
            BooleanHolder isLockedOut = new BooleanHolder();
            BooleanHolder isPasswordExpired = new BooleanHolder();
            BooleanHolder isSuspended = new BooleanHolder();
            BooleanHolder isAccountExpired = new BooleanHolder();
            isec.GetInternalLoginUserInfo(username, hasInternalLogin, isDisabled, bypassStrength, bypassHistory, useStdPasswordExpirationDays, passwordExpirationDays, bypassLockout, bypassInactivitySuspension, doesAccountExpire, accountExpirationDate, lastPasswordChange, lastLogin, numFailuresSinceLogin, lastLockout, isLockedOut, isPasswordExpired, isSuspended, isAccountExpired);
            InternalLoginUserInfo result = new InternalLoginUserInfo(username, hasInternalLogin.value, isDisabled.value, bypassStrength.value, bypassHistory.value, useStdPasswordExpirationDays.value, passwordExpirationDays.value, bypassLockout.value, bypassInactivitySuspension.value, doesAccountExpire.value, DateConverter.corbaToJavaGMT((long)accountExpirationDate.value), DateConverter.corbaToJavaGMT((long)lastPasswordChange.value), DateConverter.corbaToJavaGMT((long)lastLogin.value), numFailuresSinceLogin.value, DateConverter.corbaToJavaGMT((long)lastLockout.value), isLockedOut.value, isPasswordExpired.value, isSuspended.value, isAccountExpired.value);
            return result;
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getInternalLoginUserInfo(username);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getInternalLoginUserInfo(username);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setInternalLoginUserOptions(String username, boolean isDisabled, boolean bypassStrength, boolean bypassHistory, boolean useStdPasswordExpirationDays, int passwordExpirationDays, boolean bypassLockout, boolean bypassInactivitySuspension, boolean doesAccountExpire, Date accountExpirationDate) throws ServiceException, RemoteException {
        ISecurity_1_1 isec = this.getISecurity();
        long expiry = 0L;
        if (accountExpirationDate != null) {
            expiry = DateConverter.javaToCorbaGMT((Date)accountExpirationDate);
        }
        try {
            isec.SetInternalLoginUserOptions(username, isDisabled, bypassStrength, bypassHistory, useStdPasswordExpirationDays, passwordExpirationDays, bypassLockout, bypassInactivitySuspension, doesAccountExpire, expiry);
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.setInternalLoginUserOptions(username, isDisabled, bypassStrength, bypassHistory, useStdPasswordExpirationDays, passwordExpirationDays, bypassLockout, bypassInactivitySuspension, doesAccountExpire, accountExpirationDate);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.setInternalLoginUserOptions(username, isDisabled, bypassStrength, bypassHistory, useStdPasswordExpirationDays, passwordExpirationDays, bypassLockout, bypassInactivitySuspension, doesAccountExpire, accountExpirationDate);
                return;
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowseMetadataInterface browseFolder(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        HashMap masterMap = new HashMap();
        String type = null;
        String template = null;
        if (folderISEntityKey == null) {
            throw new IllegalArgumentException();
        }
        String origEntityKey = folderISEntityKey;
        this.pulseCheck();
        if (ISEntityKey.isValidEntityKey(folderISEntityKey)) {
            ISEntityKey iseKey = new ISEntityKey(folderISEntityKey);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            type = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        } else {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(folderISEntityKey);
            type = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        }
        if (filter == null || filter.getOMRType() == null && (filter.getXMLSelectString() == null || filter.getXMLSelectString().length() == 0)) {
            template = filter != null && filter.getOMRTemplate() != null ? filter.getOMRTemplate() : "<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
            int flags = 67110925;
            if (filter != null && filter.getOMRFlags() != 0) {
                int more_flags = filter.getOMRFlags();
                flags = (more_flags & Integer.MIN_VALUE) != 0 ? more_flags & Integer.MAX_VALUE : flags | more_flags;
            }
            try {
                BrowseMetadata result = null;
                Map objectMap = null;
                Object object = this._cnxnSync;
                synchronized (object) {
                    objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache(type, folderISEntityKey, template, flags);
                }
                this.updateMap(objectMap, masterMap);
                result = new BrowseMetadata(objectMap);
                return result;
            }
            catch (MdException mex) {
                if (this.isConnectionException(mex)) {
                    this.reconnect();
                    return this.browseFolder(origEntityKey, filter);
                }
                throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
            }
        }
        TreeSearchFilter tFilter = new TreeSearchFilter(filter, folderISEntityKey);
        BrowseMetadata folderBm = (BrowseMetadata)this.browseFetch(origEntityKey, filter);
        String id = (String)folderBm.get("Id");
        RepositoryInterface ri = this.getRepositoryForObjectId(id);
        List memList = ri.browseSearch(tFilter);
        ArrayList<Map> rawList = new ArrayList<Map>(memList.size());
        for (BrowseMetadataInterface membmi : memList) {
            Map memMap = membmi.getRawData();
            rawList.add(memMap);
        }
        Map rawMap = folderBm.getRawData();
        rawMap.put("Members", rawList);
        return folderBm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowseMetadataInterface browseFolderRecursive(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        if (folderISEntityKey == null) {
            throw new IllegalArgumentException();
        }
        HashMap masterMap = new HashMap();
        String origEntityKey = folderISEntityKey;
        this.pulseCheck();
        if (filter == null) {
            filter = new Filter();
        }
        String type = null;
        String keyType = null;
        if (ISEntityKey.isValidEntityKey(folderISEntityKey)) {
            ISEntityKey iseKey = new ISEntityKey(folderISEntityKey);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            keyType = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        } else {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(folderISEntityKey);
            keyType = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        }
        String template = "<Templates>\n  <SoftwareComponent>\n    <SoftwareTrees/>\n  </SoftwareComponent>\n  <Tree>\n    <SubTrees/>\n    <Members/>\n  </Tree>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
        type = filter.getOMRType();
        if (type == null) {
            type = keyType;
            String select = filter.getXMLSelectString();
            if (select == null || select.length() == 0) {
                int flags = 67110924;
                if (filter.getOMRFlags() != 0) {
                    int fflags = filter.getOMRFlags();
                    int n = flags = (fflags & Integer.MIN_VALUE) != 0 ? fflags & Integer.MAX_VALUE : flags | fflags;
                }
                if (filter.getOMRTemplate() != null) {
                    template = filter.getOMRTemplate();
                }
                try {
                    BrowseMetadata result = null;
                    Map objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache(keyType, folderISEntityKey, template, flags);
                    this.updateMap(objectMap, masterMap);
                    result = new BrowseMetadata(objectMap);
                    return result;
                }
                catch (MdException mex) {
                    if (this.isConnectionException(mex)) {
                        this.reconnect();
                        return this.browseFolderRecursive(origEntityKey, filter);
                    }
                    throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
                }
            }
        }
        if (filter.getOMRTemplate() == null || filter.getOMRTemplate().length() == 0) {
            filter.setOMRTemplate(template);
        }
        template = "<Templates>\n  <Tree>\n    <SubTrees/>\n  </Tree>\n  <SoftwareComponent>\n    <SoftwareTrees/>\n  </SoftwareComponent>\n</Templates>";
        int flags = 4;
        try {
            BrowseMetadata folderBm = (BrowseMetadata)this.browseFetch(origEntityKey, filter);
            String id = (String)folderBm.get("Id");
            RepositoryInterface ri = this.getRepositoryForObjectId(id);
            ArrayList treeList = new ArrayList(8);
            Map objectMap = null;
            Object object = this._cnxnSync;
            synchronized (object) {
                objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache(keyType, folderISEntityKey, template, flags);
            }
            this.getSubtreesFromMap(objectMap, treeList);
            if (treeList.size() > 0) {
                String[] trees = treeList.toArray(new String[0]);
                TreeSearchFilter tFilter = new TreeSearchFilter(filter, trees);
                List memList = ri.browseSearch(tFilter);
                ArrayList<Map> rawList = new ArrayList<Map>(memList.size());
                for (BrowseMetadataInterface membmi : memList) {
                    Map memMap = membmi.getRawData();
                    rawList.add(memMap);
                }
                Map rawMap = folderBm.getRawData();
                rawMap.put("Members", rawList);
            }
            return folderBm;
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex)) {
                this.reconnect();
                return this.browseFolderRecursive(origEntityKey, filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowseMetadataInterface browseFetch(String objectURI, FilterInterface filter) throws ServiceException, RemoteException {
        if (objectURI == null) {
            return null;
        }
        String origURI = objectURI;
        HashMap masterMap = new HashMap();
        this.pulseCheck();
        BrowseMetadata result = new BrowseMetadata(new HashMap(8));
        String type = null;
        if (ISEntityKey.isValidEntityKey(objectURI)) {
            ISEntityKey iseKey = new ISEntityKey(objectURI);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            type = omrKey.getType();
            objectURI = omrKey.getId();
        } else {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(objectURI);
            type = omrKey.getType();
            objectURI = omrKey.getId();
        }
        if (objectURI != null && (objectURI.length() != 17 || objectURI.charAt(8) != '.')) {
            String reposId = (String)this._repositories.get(objectURI.toUpperCase());
            if (reposId == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (Object)objectURI));
            }
            objectURI = reposId;
        }
        if (type == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.typereq.ex.txt"));
        }
        String defaultTemplate = null;
        defaultTemplate = "<Templates>\n  <" + type + ">\n    <Keywords/>\n    <ResponsibleParties/>\n  </" + type + ">\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
        String template = null;
        if (filter != null && filter.getOMRTemplate() != null) {
            template = filter.getOMRTemplate();
        }
        int flags = 67110924;
        if (filter != null && filter.getOMRFlags() != 0) {
            int fflags = filter.getOMRFlags();
            int n = flags = (fflags & Integer.MIN_VALUE) != 0 ? fflags & Integer.MAX_VALUE : flags | fflags;
        }
        if (template == null || template.length() == 0) {
            flags |= 1;
            template = defaultTemplate;
        }
        try {
            Map objectMap = null;
            Object object = this._cnxnSync;
            synchronized (object) {
                objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache(type, objectURI, template, flags);
            }
            this.updateMap(objectMap, masterMap);
            result = new BrowseMetadata(objectMap);
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex)) {
                this.reconnect();
                return this.browseFetch(origURI, filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List browseSearch(FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        HashMap masterMap = new HashMap();
        ArrayList<BrowseMetadata> result = new ArrayList<BrowseMetadata>(8);
        int flags = filter.getOMRFlags();
        String type = filter.getOMRType();
        if (type == null) {
            type = "Root";
            flags |= 0x10;
        }
        String defaultTemplate = null;
        defaultTemplate = "<Templates>\n  <" + type + ">\n    <Keywords/>\n    <ResponsibleParties/>\n  </" + type + ">\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
        String filterString = filter.getXMLSelectString();
        if ("UNSUPPORTED".equals(filterString)) {
            throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (Object)filter.toString()));
        }
        filterString = filterString + (filter.getOMRTemplate() == null ? defaultTemplate : filter.getOMRTemplate());
        String repository = filter.getOMRRepository();
        int my_flags = 0x400018C | (repository == null ? 8192 : 0);
        if (repository == null) {
            flags |= 0x2000;
            RepositoryInterface ri = this.getFoundationRepository();
            repository = ((OMIRepositoryInterface)ri).getDefaultRepositoryId();
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            flags &= Integer.MAX_VALUE;
            my_flags = 0;
        }
        try {
            List list = null;
            Object object = this._cnxnSync;
            synchronized (object) {
                list = this._mdfactory.getOMIUtil().getMetadataObjectsNoCache(type, repository, filterString, my_flags | flags);
            }
            for (Map nextMap : list) {
                this.updateMap(nextMap, masterMap);
                BrowseMetadata bm = new BrowseMetadata(nextMap);
                result.add(bm);
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex)) {
                this.reconnect();
                return this.browseSearch(filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        return result;
    }

    @Override
    public List browseSearch(BrowseMetadataInterface browseFolder, FilterInterface filter) throws ServiceException, RemoteException {
        return this.browseSearch(browseFolder.getISEntityKey(), filter);
    }

    @Override
    public List browseSearch(FolderInterface folder, FilterInterface filter) throws ServiceException, RemoteException {
        return this.browseSearch(folder.getEntityKey(), filter);
    }

    @Override
    public List browseSearch(List folderList, FilterInterface filter) throws ServiceException, RemoteException {
        ArrayList results = new ArrayList(20);
        for (FolderInterface nextFolder : folderList) {
            List nextList = this.browseSearch(nextFolder, filter);
            results.addAll(nextList);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List search(FolderInterface folder, FilterInterface filter) throws ServiceException, RemoteException {
        String template = "<Templates>\n  <Tree>\n    <SubTrees/>\n  </Tree>\n</Templates>";
        int flags = 4;
        try {
            String folderId = folder.getReposId();
            ArrayList treeList = new ArrayList(8);
            Map objectMap = null;
            Object object = this._cnxnSync;
            synchronized (object) {
                objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache("Tree", folderId, template, flags);
            }
            this.getSubtreesFromMap(objectMap, treeList);
            if (treeList.size() > 0) {
                String[] trees = treeList.toArray(new String[0]);
                TreeSearchFilter tFilter = new TreeSearchFilter(filter, trees);
                List results = this.search(tFilter);
                return results;
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex)) {
                this.reconnect();
                return this.search(folder, filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List search(List folderList, FilterInterface filter) throws ServiceException, RemoteException {
        ArrayList results = new ArrayList(20);
        for (FolderInterface nextFolder : folderList) {
            List nextList = this.search(nextFolder, filter);
            results.addAll(nextList);
        }
        return results;
    }

    @Override
    public void deleteEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.pulseCheck();
        Object o = input.getRepositoryEntity();
        if (!(o instanceof CMetadata)) {
            throw new ServiceException(RB.getStringResource("OMIRepository.deletebadcls.ex.txt"));
        }
        this.deleteEntity((CMetadata)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntity(CMetadata metadata) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            String fqid = metadata.getFQID();
            Object object = this._cnxnSync;
            synchronized (object) {
                this._mdfactory.deleteMetadataObject(metadata);
                MetadataInterface mi = (MetadataInterface)this._cache.remove(fqid);
                if (mi != null) {
                    mi.setDeleted();
                }
                this._cache.remove(fqid);
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.deleteEntity(metadata);
                return;
            }
            throw new ServiceException(ex, Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.deleteerror.ex.fmt.txt", (Object)metadata.getName(), (Object)metadata.getFQID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntities(List metadataObjects) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                this._mdfactory.deleteMetadataObjects(metadataObjects);
            }
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                this.deleteEntities(metadataObjects);
                return;
            }
            throw new ServiceException(ex, RB.getStringResource("OMIRepository.deleteerlst.ex.txt"));
        }
        for (CMetadata nextMetadata : metadataObjects) {
            String fqid = nextMetadata.getFQID();
            MetadataInterface mi = (MetadataInterface)this._cache.get(fqid);
            if (mi == null) continue;
            mi.setDeleted();
            this._cache.remove(fqid);
        }
    }

    @Override
    public MetadataInterface getObjectByPathFilter(PathUrl url) throws ServiceException, RemoteException {
        List candidates;
        MetadataInterface result = null;
        this.pulseCheck();
        if (url == null) {
            return null;
        }
        String pathType = url.getType();
        PathFilter filter = new PathFilter(url);
        if (pathType != null) {
            TypeDescriptorInterface tdi = this.getTypeDescriptor(pathType);
            if (tdi != null) {
                filter.setType(tdi.getMetadataType());
            } else {
                Map actionMap;
                Object o;
                InformationServiceInterface isi;
                Map smartMap;
                SmartDef def;
                Map typeMap = this.getTypeDictionaryMap();
                for (String nextKey : typeMap.keySet()) {
                    if (!nextKey.startsWith(pathType)) continue;
                    tdi = this.getTypeDescriptor(nextKey);
                    filter.setType(tdi.getMetadataType());
                    break;
                }
                if (filter.getType() == null && (def = (SmartDef)(smartMap = (isi = OMIServerRepository.getInformationService()).getSmartObjectDefinitions()).get(pathType)) != null && (o = (actionMap = def.getActions()).get("omi")) != null) {
                    if (o instanceof List) {
                        List actionList = (List)o;
                        for (SmartDef.ActionDef nextAction : actionList) {
                            filter.setType(nextAction.getType());
                        }
                    } else {
                        SmartDef.ActionDef action = (SmartDef.ActionDef)o;
                        filter.setType(action.getType());
                    }
                }
            }
        }
        if ((candidates = this.search(filter)).size() > 0) {
            if (pathType != null) {
                String pType = pathType;
                int index = pType.indexOf(46);
                if (index > 0) {
                    pType = pType.substring(0, index);
                }
                for (MetadataInterface candidate : candidates) {
                    String cType = candidate.getType();
                    index = cType.indexOf(46);
                    if (index > 0) {
                        cType = cType.substring(0, index);
                    }
                    if (!cType.equals(pType)) continue;
                    result = candidate;
                    break;
                }
            } else {
                result = (MetadataInterface)candidates.get(0);
            }
        }
        if (result != null && url.getExtendedPath() != null && url.getExtendedPath().trim().length() > 0 && result instanceof EmbeddedObjectInterface) {
            MetadataInterface result2 = ((EmbeddedObjectInterface)((Object)result)).getEmbeddedObject(url.getExtendedPath());
            return result2;
        }
        return result;
    }

    public MetadataInterface getObjectByPathNew(PathUrl url) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (url == null) {
            return null;
        }
        if ((url.getRootTree() == null || url.getRootTree().trim().length() == 0) && url.getPath() == null && "/".equals(url.getName()) && "Folder".equals(url.getType())) {
            return this.getRootFolder();
        }
        if (VirtualFolderManager.isVirtualFolderPath(url, this)) {
            return this.getObjectByPath(url);
        }
        String type = url.getType();
        if (type != null && type.equals("Folder")) {
            return this.getObjectByPathFilter(url);
        }
        String objectPath = url.getRootTree() + (url.getPath() == null ? "" : "/" + url.getPath());
        if (objectPath != null && url.getName() != null) {
            String parentUrl = "SBIP://" + this._name + "/" + objectPath + "(Folder)";
            PathUrl parentPath = new PathUrl(parentUrl);
            FolderInterface parentFolder = (FolderInterface)this.getObjectByPathFilter(parentPath);
            if (parentFolder == null) {
                return null;
            }
            MetadataInterface mi = parentFolder.getItemByType(url.getName(), type);
            if (mi != null && url.getExtendedPath() != null && url.getExtendedPath().trim().length() > 0 && mi instanceof EmbeddedObjectInterface) {
                MetadataInterface result = ((EmbeddedObjectInterface)((Object)mi)).getEmbeddedObject(url.getExtendedPath());
                return result;
            }
            return mi;
        }
        return this.getObjectByPath(url);
    }

    @Override
    public MetadataInterface getObjectByPath(PathUrl url) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (url == null) {
            return null;
        }
        String reposName = url.getRepository();
        if (!this._name.equals(reposName)) {
            int index;
            if (reposName.startsWith(this._name) && (index = reposName.indexOf(46)) > -1) {
                reposName = reposName.substring(index + 1);
            }
            List reposList = this.getRepositories(true);
            Iterator it = reposList.iterator();
            RepositoryInterface o = null;
            while (it.hasNext()) {
                RepositoryInterface ri = (RepositoryInterface)it.next();
                if (!reposName.equals(ri.getISName()) && !reposName.equalsIgnoreCase(((OMIRepositoryInterface)ri).getDefaultRepositoryName())) continue;
                o = ri;
            }
            if (o == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIServer.notforme.ex.fmt.txt", (Object)reposName, (Object)this._name));
            }
        }
        try {
            String itemName;
            if ((url.getRootTree() == null || url.getRootTree().trim().length() == 0) && url.getPath() == null && "/".equals(url.getName()) && "Folder".equals(url.getType())) {
                return this.getRootFolder();
            }
            RootFolderInterface serverRoot = this.getRootFolder();
            String itemType = url.getType();
            String rootFolderName = url.getRootTree();
            FolderInterface folder = serverRoot.getSubfolder(rootFolderName);
            if (folder == null) {
                return null;
            }
            String path = url.getPath();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.getbypath.msg.fmt.txt", (Object)path, (Object)url.getName(), (Object)url.getType()));
            }
            if (path != null) {
                StringTokenizer st = new StringTokenizer(path, "/", false);
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    List subfolders = folder.getSubfolders();
                    boolean gotFolder = false;
                    for (MetadataInterface mi : subfolders) {
                        if (!(mi instanceof FolderInterface) || !mi.getName().equalsIgnoreCase(name)) continue;
                        folder = (FolderInterface)mi;
                        gotFolder = true;
                        break;
                    }
                    if (gotFolder) continue;
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.nofolder.msg.fmt", (Object)name, (Object)path));
                    }
                    return null;
                }
            }
            if ((itemName = url.getPrimaryName()) != null) {
                if (itemType != null && itemType.equalsIgnoreCase("Folder")) {
                    List subfolders = folder.getSubfolders();
                    for (MetadataInterface mi : subfolders) {
                        if (!(mi instanceof FolderInterface) || !mi.getName().equalsIgnoreCase(itemName)) continue;
                        folder = (FolderInterface)mi;
                        return folder;
                    }
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.nofolder.msg.fmt", (Object)itemName, (Object)path));
                    }
                    return null;
                }
                MetadataInterface mi = folder.getItemByType(itemName, itemType);
                if (mi != null && url.getExtendedPath() != null && url.getExtendedPath().trim().length() > 0 && mi instanceof EmbeddedObjectInterface) {
                    MetadataInterface result = ((EmbeddedObjectInterface)((Object)mi)).getEmbeddedObject(url.getExtendedPath());
                    return result;
                }
                if (mi == null && itemType == null) {
                    mi = folder.getSubfolder(itemName);
                    return mi;
                }
                return mi;
            }
            return folder;
        }
        catch (ServiceException svcex) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("ServiceException caught, checking for connection problem.");
            }
            if (this.isConnectionException((Throwable)((Object)svcex))) {
                this.reconnect();
                return this.getObjectByPath(url);
            }
            throw svcex;
        }
    }

    private List browseSearch(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (ISEntityKey.isValidEntityKey(folderISEntityKey)) {
            ISEntityKey iseKey = new ISEntityKey(folderISEntityKey);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            folderISEntityKey = omrKey.getId();
        } else {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(folderISEntityKey);
            folderISEntityKey = omrKey.getId();
        }
        int flags = filter.getOMRFlags();
        String type = filter.getOMRType();
        if (type == null) {
            type = "Root";
            flags |= 0x10;
        }
        String template = "<Templates>\n  <Tree>\n    <SubTrees/>\n  </Tree>\n</Templates>";
        flags = 67109132;
        ArrayList treeList = new ArrayList(8);
        try {
            Map objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache("Tree", folderISEntityKey, template, flags);
            this.getSubtreesFromMap(objectMap, treeList);
            if (treeList.size() > 0) {
                RepositoryInterface ri = this.getRepositoryForObjectId(folderISEntityKey);
                String[] trees = treeList.toArray(new String[0]);
                TreeSearchFilter tFilter = new TreeSearchFilter(filter, trees);
                List memList = ri.browseSearch(tFilter);
                return memList;
            }
            return Collections.EMPTY_LIST;
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.browseSearch(folderISEntityKey, filter);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void updateMap(Map rawData, Map masterMap) throws ServiceException, RemoteException {
        String fqid = (String)rawData.get("Id");
        RepositoryInterface ri = this.getRepositoryForObjectId(fqid);
        Set keys = rawData.keySet();
        if (keys.size() == 2) {
            Map otherMap = (Map)masterMap.get(fqid);
            if (otherMap != null) {
                for (Map.Entry entry : otherMap.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    rawData.put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            String idString;
            long result;
            double sasDate;
            String smartType = this.getSmartType(rawData, ri);
            rawData.put("smarttype", smartType);
            try {
                String isek = this.getBrowseEntityKey(smartType, (String)rawData.get("MetadataObjectType"), (String)rawData.get("Id"));
                rawData.put("ISEntityKey", isek);
            }
            catch (ServiceException svcEx) {
                rawData.put("ISEntityKey", "Error getting entity key");
            }
            String dateString = (String)rawData.get("MetadataCreated");
            if (dateString != null) {
                sasDate = 0.0;
                try {
                    sasDate = Double.valueOf(dateString);
                }
                catch (NumberFormatException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
                result = DateUtil.SASDateTimeToJavaDate(sasDate, TimeZone.getTimeZone("GMT"));
                rawData.put("MetadataCreated", Long.toString(result));
            }
            if ((dateString = (String)rawData.get("MetadataUpdated")) != null) {
                sasDate = 0.0;
                try {
                    sasDate = Double.valueOf(dateString);
                }
                catch (NumberFormatException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
                result = DateUtil.SASDateTimeToJavaDate(sasDate, TimeZone.getTimeZone("GMT"));
                rawData.put("MetadataUpdated", Long.toString(result));
            }
            if ((idString = (String)rawData.get("Id")) != null) {
                rawData.put("reposid", idString);
            }
            masterMap.put(fqid, rawData);
        }
        Collection valueCollection = rawData.values();
        for (Object o : valueCollection) {
            if (!(o instanceof List)) continue;
            List nextList = (List)o;
            Iterator listIt = nextList.iterator();
            while (listIt.hasNext()) {
                try {
                    Map nextMap = (Map)listIt.next();
                    this.updateMap(nextMap, masterMap);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    private String getBrowseEntityKey(String smartType, String nativeType, String reposId) throws ServiceException, RemoteException {
        String reposUrl;
        RepositoryInterface ri = this.getRepositoryForObjectId(reposId);
        StringBuffer buffer = new StringBuffer();
        buffer.append(smartType);
        buffer.append("+");
        String reposName = null;
        try {
            reposName = ri.getISName();
        }
        catch (RemoteException rex) {
            reposName = "RemoteException";
        }
        if (reposName == null) {
            reposUrl = null;
            String domain = null;
            try {
                reposUrl = this.getUrl();
                domain = this.getDomain();
            }
            catch (RemoteException rex) {
                throw new ServiceException(rex, RB.getStringResource("OMIRepository.geturlerror.ex.txt"));
            }
            try {
                URI uri = new URI(reposUrl);
                reposUrl = new String(uri.getScheme() + "://" + uri.getAuthority() + (domain != null ? ";domain=" + domain : ""));
                if (uri.getRawPath().length() > 1) {
                    reposUrl = reposUrl + uri.getRawPath();
                }
            }
            catch (URISyntaxException ex) {
                this._logger.warn(RB.getStringResource("OMIRepository.badurlformat.ex.txt"), (Throwable)ex);
            }
            buffer.append(reposUrl);
        } else {
            reposUrl = this._url;
            int index = reposUrl.indexOf(":");
            String protocol = reposUrl.substring(0, index);
            try {
                buffer.append(protocol + "://" + URLEncoder.encode(reposName, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                buffer.append(protocol + "://" + reposName);
            }
        }
        buffer.append("/");
        reposName = ((OMIRepositoryInterface)ri).getDefaultRepositoryName();
        if (reposName != null) {
            try {
                buffer.append("reposname=" + URLEncoder.encode(reposName, "UTF-8") + "/");
            }
            catch (UnsupportedEncodingException ex) {
                throw new ServiceException(ex, RB.getStringResource("OMIRepository.geturlerror.ex.txt"));
            }
        }
        buffer.append(nativeType + ";id=");
        buffer.append(reposId);
        return buffer.toString();
    }

    private void getSubtreesFromMap(Map treeMap, List treeList) {
        treeList.add(treeMap.get("Id"));
        List list = (List)treeMap.get("SubTrees");
        if (list == null) {
            list = (List)treeMap.get("SoftwareTrees");
        }
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    Map nextMap = (Map)it.next();
                    this.getSubtreesFromMap(nextMap, treeList);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    private String getSmartType(Map rawData, RepositoryInterface ri) {
        String key = "omi:" + ((String)rawData.get("MetadataObjectType")).toLowerCase();
        try {
            String action;
            String publicType = (String)rawData.get("PublicType");
            if (publicType != null) {
                TypeDescriptorInterface tdi;
                if (publicType.startsWith("Embedded:")) {
                    publicType = publicType.substring("Embedded:".length());
                }
                if (publicType.length() > 0 && (tdi = this.getTypeDescriptor(publicType)) != null && tdi.getClassName() != null && tdi.getClassName().trim().length() > 0) {
                    key = "tdi:" + tdi.getClassName();
                }
            }
            if ((action = this._factory.getAction(key, rawData, ri)) == null) {
                return "Metadata";
            }
            String classString = action.substring(action.lastIndexOf(":") + 1);
            SmartTypeHelper.Result str = this._myHelper.lookup(classString);
            rawData.put("isAFolder", str.isFolderStr());
            rawData.put("smartclass", classString);
            if (str.getSmartType() != null) {
                return str.getSmartType();
            }
            return "Metadata";
        }
        catch (ServiceException ex) {
            this._logger.info(RB.getStringResource("OMIRepository.smrttypeerr.ex.txt"), (Throwable)((Object)ex));
        }
        catch (RemoteException ex) {
            this._logger.warn(RB.getStringResource("OMIRepository.smrttypeerr.ex.txt"), (Throwable)ex);
        }
        return "Metadata";
    }

    private boolean isConnectionException(Throwable ex) {
        String mexMessage;
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug("Checking exception messages for connection problem.");
        }
        return (mexMessage = ex.getMessage()) != null && (mexMessage.indexOf(EX_MSG_EOFEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_SOCKETEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_CONNECTIONABORT) > -1) || this.ioExceptionInChain(ex);
    }

    private boolean ioExceptionInChain(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return true;
            }
            Throwable t = ex.getCause();
            if (t == ex) break;
            ex = t;
        }
        return false;
    }

    @Override
    public Date getCreateDate(MetadataInterface mi) throws ServiceException, RemoteException {
        int index;
        this.pulseCheck();
        CMetadata cm = (CMetadata)mi.getRepositoryEntity();
        if (this._mdfactory == null) {
            return null;
        }
        String xml = "<GetMetadata><Metadata><" + cm.getCMetadataType() + " Id=\"" + cm.getFQID() + '\"' + " Name=\"\" MetadataCreated=\"\" MetadataUpdated=\"\"/></Metadata><ns>SAS</ns><Flags>67108864</Flags><options/></GetMetadata>";
        Logger xmlLogger = LogManager.getLogger((String)"com.sas.metadata.xml");
        if (xmlLogger.isDebugEnabled()) {
            xmlLogger.debug(xml);
        }
        StringHolder outXml = new StringHolder();
        try {
            IOMI cnxn = this._mdfactory.getConnection().getCMRHandle();
            cnxn.DoRequest(xml, outXml);
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getCreateDate(mi);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getCreateDate(mi);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        String xmlOut = outXml.value;
        if (xmlLogger.isDebugEnabled()) {
            String xmlFout = XMLUtil.formatXML((String)xmlOut);
            xmlLogger.debug(xmlFout);
        }
        if ((index = xmlOut.indexOf("MetadataCreated")) < 0) {
            return null;
        }
        int index2 = xmlOut.indexOf("\"", index += 17);
        String sasCreateString = xmlOut.substring(index, index2);
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        try {
            double time = nf.parse(sasCreateString).doubleValue();
            TimeZone timezone = TimeZone.getTimeZone("GMT");
            long javaDate = (long)((time - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
            Date result = new Date(javaDate);
            return result;
        }
        catch (ParseException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public Date getModifiedDate(MetadataInterface mi) throws ServiceException, RemoteException {
        int index;
        this.pulseCheck();
        CMetadata cm = (CMetadata)mi.getRepositoryEntity();
        if (this._mdfactory == null) {
            return null;
        }
        String xml = "<GetMetadata><Metadata><" + cm.getCMetadataType() + " Id=\"" + cm.getFQID() + '\"' + " Name=\"\" MetadataCreated=\"\" MetadataUpdated=\"\"/></Metadata><ns>SAS</ns><Flags>67108864</Flags><options/></GetMetadata>";
        Logger xmlLogger = LogManager.getLogger((String)"com.sas.metadata.xml");
        if (xmlLogger.isDebugEnabled()) {
            xmlLogger.debug(xml);
        }
        StringHolder outXml = new StringHolder();
        try {
            this._mdfactory.getConnection().getCMRHandle().DoRequest(xml, outXml);
        }
        catch (GenericError ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getModifiedDate(mi);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SystemException ex) {
            if (this.isConnectionException(ex)) {
                this.reconnect();
                return this.getModifiedDate(mi);
            }
            throw new ServiceException(ex, ex.getMessage());
        }
        String xmlOut = outXml.value;
        if (xmlLogger.isDebugEnabled()) {
            String xmlFout = XMLUtil.formatXML((String)xmlOut);
            xmlLogger.debug(xmlFout);
        }
        if ((index = xmlOut.indexOf("MetadataUpdated")) < 0) {
            return null;
        }
        int index2 = xmlOut.indexOf("\"", index += 17);
        String sasCreateString = xmlOut.substring(index, index2);
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        try {
            double time = nf.parse(sasCreateString).doubleValue();
            TimeZone timezone = TimeZone.getTimeZone("GMT");
            long javaDate = (long)((time - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
            Date result = new Date(javaDate);
            return result;
        }
        catch (ParseException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    public HostPortSet getClusterConnections() throws RemoteException, ServiceException {
        String xmlSelect = "<XMLSelect search=\"LogicalServer[@ClassIdentifier='0217e202-b560-11db-ad91-001083ff6836'][UsedByComponents/ServerContext[@Name = 'SASMeta']]\"/>";
        String template = "<Templates><LogicalServer><UsingComponents/></LogicalServer><ServerComponent><SourceConnections/></ServerComponent><TCPIPConnection HostName='' Port=''/></Templates>";
        MdObjectStore store = null;
        try {
            store = this._mdfactory.createObjectStore(null, "OMIServer.getClusterConnections");
            int flags = 388;
            String reposId = this._mdfactory.getOMIUtil().getFoundationReposID();
            List servers = this._mdfactory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposId, "LogicalServer", flags, "<XMLSelect search=\"LogicalServer[@ClassIdentifier='0217e202-b560-11db-ad91-001083ff6836'][UsedByComponents/ServerContext[@Name = 'SASMeta']]\"/><Templates><LogicalServer><UsingComponents/></LogicalServer><ServerComponent><SourceConnections/></ServerComponent><TCPIPConnection HostName='' Port=''/></Templates>");
            if (servers == null || servers.isEmpty()) {
                HostPortSet hostPortSet = null;
                return hostPortSet;
            }
            if (servers.size() > 1) {
                throw new ServiceException("Multiple metadata servers were found for the SASMeta ServerContext.");
            }
            HostPortSet hostPortSet = new HostPortSet();
            LogicalServer server = (LogicalServer)servers.get(0);
            AssociationList comps = server.getUsingComponents();
            for (ServerComponent comp : comps) {
                AssociationList connections = comp.getSourceConnections();
                for (Connection connection : connections) {
                    if (!(connection instanceof TCPIPConnection)) continue;
                    String hostValue = ((TCPIPConnection)connection).getHostName();
                    int portValue = ((TCPIPConnection)connection).getPort();
                    hostPortSet.add((Object)new HostPortPair(hostValue, portValue));
                }
            }
            HostPortSet hostPortSet2 = hostPortSet;
            return hostPortSet2;
        }
        catch (MdException e) {
            throw new ServiceException(e, "Failure reading LogicalServer for metadata server cluster.");
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
    }

    @Override
    public Root createMetadata(String repositoryId, String name, String type) throws RemoteException, ServiceException {
        this.pulseCheck();
        if (repositoryId == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.nodefaultrepos.msg.txt"));
        }
        if (InformationService.IDENTITY_TYPES.contains(type)) {
            Names.validateIdentityName(name, true);
        } else {
            Names.validateOMRObjectName(name, true);
        }
        int index = repositoryId.indexOf(46);
        repositoryId = repositoryId.substring(index + 1);
        Root root = (Root)this._mdfactory.createComplexMetadataObject(this._mdstore, null, name, type, repositoryId);
        if (root == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.objectnotcreated.ex.txt"));
        }
        return root;
    }

    @Override
    public MetadataInterface newMetadata(String reposId, String name, String type) throws ServiceException, RemoteException {
        this.pulseCheck();
        MetadataInterface mi = null;
        if (reposId == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.reposidreq.ex.txt"));
        }
        if (this._repositories.get(reposId.toUpperCase()) != null) {
            RepositoryEntry re = (RepositoryEntry)this._repositories.get(reposId.toUpperCase());
            reposId = re.fqid;
        }
        if (reposId.startsWith("A0000001.")) {
            reposId = reposId.substring(9);
        }
        this.debug("com.sas.services.information.OMIServer.", RB.getResources(), "OMIRepository.newmetadata.msg.fmt", reposId, name, type);
        try {
            Root newRoot = (Root)this._mdfactory.createComplexMetadataObject(this._mdstore, null, name, type, reposId);
            if (newRoot == null) {
                throw new ServiceException(RB.getStringResource("OMIRepository.objectnotcreated.ex.txt"));
            }
            mi = this.factoryProcess(newRoot);
            return mi;
        }
        catch (RemoteException t) {
            throw new ServiceException(t, RB.getStringResource("OMIRepository.newmetadataex.ex.txt"));
        }
    }

    @Override
    public MetadataInterface fetch(String objectURI) throws ServiceException, RemoteException {
        return this.fetch(objectURI, false);
    }

    @Override
    public MetadataInterface fetch(String repositoryKey, boolean bypassCache) throws ServiceException, RemoteException {
        Filter filter = null;
        String originalKey = repositoryKey;
        this.pulseCheck();
        String template = null;
        if (filter != null && filter.getOMRTemplate() != null) {
            template = filter.getOMRTemplate();
        }
        int flags = 2056;
        if (template != null) {
            flags |= 4;
        } else {
            template = "";
        }
        if (filter != null && filter.getOMRFlags() != 0) {
            int fflags = filter.getOMRFlags();
            flags = (fflags & Integer.MIN_VALUE) != 0 ? fflags & Integer.MAX_VALUE : flags | fflags;
        }
        try {
            repositoryKey = URLDecoder.decode(repositoryKey, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        this.debug("com.sas.services.information.OMIServer", RB.getResources(), "OMIRepository.fetchdata.msg.fmt.txt", repositoryKey, null, null);
        CMetadata cm = null;
        MetadataInterface mi = null;
        String type = null;
        if (ISEntityKey.isValidEntityKey(originalKey)) {
            ISEntityKey iseKey = new ISEntityKey(originalKey);
            String protocol = iseKey.getProtocol();
            if (!protocol.equals("omi")) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (Object)repositoryKey));
            }
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(originalKey);
            type = omrKey.getType();
            repositoryKey = omrKey.getId();
        } else {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(repositoryKey);
            type = omrKey.getType();
            repositoryKey = omrKey.getId();
        }
        if (repositoryKey != null && (repositoryKey.length() != 17 || repositoryKey.charAt(8) != '.')) {
            String reposId = (String)this._repositories.get(repositoryKey.toUpperCase());
            if (reposId == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (Object)repositoryKey));
            }
            repositoryKey = reposId;
        }
        if (type == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.typereq.ex.txt"));
        }
        if (!bypassCache) {
            mi = (MetadataInterface)this._cache.get(repositoryKey);
            if (mi != null) {
                cm = (CMetadata)mi.getRepositoryEntity();
            } else {
                String tKey = (String)this._tempMap.get(repositoryKey);
                if (tKey != null && (mi = (MetadataInterface)this._cache.get(tKey)) != null) {
                    cm = (CMetadata)mi.getRepositoryEntity();
                }
            }
        }
        try {
            if (cm == null && !bypassCache) {
                cm = this._mdstore.getObject(repositoryKey, true);
            }
            if (cm == null) {
                VirtualFolderManager instance;
                if ("Tree".equalsIgnoreCase(type) && VirtualFolderManager.isVirtualFolderId(repositoryKey) && (instance = VirtualFolderManager.getInstance(this)).containsVirtualFolder(repositoryKey)) {
                    return instance.getVirtualFolder(repositoryKey);
                }
                cm = this._mdfactory.getOMIUtil().getMetadataAllDepths((MdStore)this._mdstore, type, repositoryKey, null, null, template, flags);
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex)) {
                this.reconnect();
                return this.fetch(originalKey);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        if (cm == null) {
            return null;
        }
        if (bypassCache) {
            this._cache.remove(cm.getFQID());
        }
        mi = this.factoryProcess(cm);
        return mi;
    }

    @Override
    public List search(FilterInterface filter) throws ServiceException, RemoteException {
        PartialListResultsException pre = null;
        this.pulseCheck();
        String filterString = filter.getXMLSelectString();
        this.debug("com.sas.services.information.OMIRepository.", RB.getResources(), "OMIRepository.srchparam.ex.fmt", this._host, this._port, filterString);
        List protocols = filter.getProtocols();
        if (protocols != null && protocols.size() > 0 && !protocols.contains("omi")) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(8);
        int flags = filter.getOMRFlags();
        if ("UNSUPPORTED".equals(filterString)) {
            throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (Object)filter.toString()));
        }
        filterString = filterString + (filter.getOMRTemplate() == null ? "" : filter.getOMRTemplate());
        String type = filter.getOMRType();
        String repository = filter.getOMRRepository();
        ArrayList<String> repositoryList = new ArrayList<String>(8);
        ArrayList<String> typeList = new ArrayList<String>(8);
        if (repository != null && (repository.length() != 17 || repository.charAt(8) != '.')) {
            String reposId;
            RepositoryEntry entry = (RepositoryEntry)this._repositories.get(repository.toUpperCase());
            if (entry == null) {
                this.debug("com.sas.services.information.OMIRepository", "repository " + repository + " wasn't found in the list for this server");
                Iterator coll = this._repositories.values().iterator();
                while (coll.hasNext()) {
                    this.debug("com.sas.services.information.OMIRepository", "It does have: " + ((RepositoryEntry)coll.next()).fqid);
                }
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (Object)repository));
            }
            repository = reposId = entry.fqid;
        }
        if (repository == null) {
            flags |= 0x2000;
            RepositoryInterface ri = this.getFoundationRepository();
            repositoryList.add(((OMIRepositoryInterface)ri).getDefaultRepositoryId());
        } else {
            repositoryList.add(repository);
        }
        if (type == null) {
            typeList.add("Root");
            flags |= 0x10;
        } else {
            typeList.add(type);
        }
        for (String nextRepos : repositoryList) {
            for (String nextType : typeList) {
                this.info("com.sas.services.information.OMIRepository.", RB.getResources(), "OMIRepository.srchrepos.ex.fmt", nextRepos, nextType, filterString);
                try {
                    ArrayList nextResult = this.doSearch(nextType, nextRepos, filterString, flags);
                    if (nextResult == null) continue;
                    result.addAll(nextResult);
                }
                catch (PartialListResultsException plre) {
                    if (pre == null) {
                        pre = new PartialListResultsException(result, plre.getMessage());
                    }
                    Throwable[] exceptions = plre.getExceptions();
                    for (int i = 0; i < exceptions.length; ++i) {
                        pre.addException(exceptions[i]);
                    }
                    List list = plre.getResults();
                    result.addAll(list);
                }
            }
        }
        if (pre != null) {
            throw pre;
        }
        return result;
    }

    private synchronized ArrayList doSearch(String type, String repository, String filter, int flags) throws ServiceException, RemoteException {
        PartialResultsException pre = null;
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(8);
        try {
            int my_flags = 396;
            if ((flags & Integer.MIN_VALUE) != 0) {
                flags &= Integer.MAX_VALUE;
                my_flags = 0;
            }
            List list = this._mdfactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._mdstore, repository, type, my_flags | flags, filter);
            for (CMetadata cm2 : list) {
                MetadataInterface mi = null;
                try {
                    mi = this.factoryProcess(cm2);
                    result.add(mi);
                }
                catch (ServiceException svcEx) {
                    this.info("com.sas.services.information.OMIRepository.", RB.getStringResource("OMIRepository.geterror.ex.txt"), (Throwable)((Object)svcEx));
                    if (pre == null) {
                        pre = new PartialListResultsException(result, RB.getStringResource("OMIRepository.geterror.ex.txt"));
                    }
                    pre.addException((Throwable)((Object)svcEx));
                }
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex)) {
                this.reconnect();
                return this.doSearch(type, repository, filter, flags);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        if (pre != null) {
            throw pre;
        }
        return result;
    }

    @Override
    public void refreshEntity(MetadataInterface mi) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (mi == null) {
            return;
        }
        this.debug("com.sas.services.information.OMIRepository", RB.getResources(), "OMIRepository.refreshing.msg.fmt.txt", mi, null, null);
        CMetadata cm = (CMetadata)mi.getRepositoryEntity();
        try {
            this._mdstore.refreshObjectFromServer(cm, false, true, true);
        }
        catch (MdException mdex) {
            if (this.isConnectionException(mdex)) {
                this.reconnect();
                this.refreshEntity(mi);
                return;
            }
            throw new ServiceException(mdex, Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.refrshfail.ex.fmt.txt", (Object)cm.getFQID()));
        }
    }

    @Override
    public Map getTypeDictionaryMap() throws ServiceException, RemoteException {
        if (this._typeMap == null) {
            return Collections.EMPTY_MAP;
        }
        return new HashMap(this._typeMap);
    }

    @Override
    public void addToCache(MetadataInterface newMetadata) throws ServiceException, RemoteException {
        this.pulseCheck();
        Object o = this._cache.get(newMetadata.getReposId());
        if (o == null) {
            try {
                Root root = (Root)newMetadata.getRepositoryEntity();
                MdStore theirStore = root.getObjectStore();
                String storename = ((MdObjectStore)theirStore).getStoreName();
                String mystorename = this._mdstore.getStoreName();
                if (mystorename.equals(storename)) {
                    this._cache.put(newMetadata);
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized ChildServerInterface newChild() throws ServiceException, RemoteException {
        return this.newChild(false);
    }

    @Override
    public synchronized ChildServerInterface newChild(boolean detached) throws ServiceException, RemoteException {
        this.pulseCheck();
        MdObjectStore newstore = null;
        if (detached) {
            newstore = this._mdfactory.createObjectStore(null, "detached_" + this._childnum);
            newstore.addMdObjectListener((MdObjectListener)this);
            ++this._childnum;
        } else {
            newstore = this._mdfactory.createObjectStore((MdStore)this._mdstore, "child" + this._childnum);
            ++this._childnum;
        }
        try {
            OMIChildServer ri = new OMIChildServer(this._mdfactory, newstore, this, this._childnum);
            return ri;
        }
        catch (SystemException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public synchronized void flush() throws ServiceException, RemoteException {
        try {
            this._mdstore.updatedMetadataAll();
        }
        catch (MdException t) {
            if (this.isConnectionException(t)) {
                this.reconnect();
                this.flush();
                return;
            }
            this.debug("com.sas.services.information.OMIRepository", RB.getStringResource("OMIRepository.updateexcept.msg.txt"), t);
            throw new ServiceException(t, RB.getStringResource("OMIRepository.updateexcept.msg.txt"));
        }
    }

    @Override
    public byte[] toByteArray(boolean copyData) throws RemoteException, ServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this._def);
            oos.writeObject(this._name);
            UserIdentityInterface ident = this.generatePassword(null);
            oos.writeObject(ident);
            ArrayList<String> reposList = new ArrayList<String>();
            for (RepositoryEntry re : this._repositories.values()) {
                if (re.repos == null) continue;
                reposList.add(re.name);
            }
            oos.writeObject(reposList);
            if (copyData) {
                Collection cacheList = this._cache.values();
                ArrayList<String> list = new ArrayList<String>(cacheList.size());
                for (MetadataInterface mi : cacheList) {
                    try {
                        list.add(mi.getEntityKey());
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                oos.writeObject(list);
            } else {
                oos.writeObject(Collections.EMPTY_LIST);
            }
            byte[] blobArray = baos.toByteArray();
            return blobArray;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void fromByteArray(UserContextInterface uci, byte[] data) throws RemoteException, ServiceException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            this._user = uci;
            this._def = (ServerDef)ois.readObject();
            this._name = (String)ois.readObject();
            UserIdentityInterface ident = (UserIdentityInterface)ois.readObject();
            ident.setDomain(this._def.getDomain());
            uci.addIdentity(ident);
            this.connect(this._def, uci);
            uci.removeIdentity(ident);
            List reposList = (List)ois.readObject();
            for (String nextName : reposList) {
                this.getRepository(nextName);
            }
            List cacheList = (List)ois.readObject();
            if (cacheList != null && cacheList.size() > 0) {
                this.loadCache(cacheList);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (IOException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void loadCache(List cacheList) {
        if (cacheList == null || cacheList.size() == 0) {
            return;
        }
        StringBuffer xmlBuffer = new StringBuffer(1024);
        xmlBuffer.append("<GetMetadata>\n");
        xmlBuffer.append("  <Metadata>\n");
        Iterator it = cacheList.iterator();
        ISEntityKey eKey = null;
        OMRRepositoryKey aKey = null;
        while (it.hasNext()) {
            String nextKey = (String)it.next();
            eKey = new ISEntityKey(nextKey);
            aKey = new OMRRepositoryKey(eKey.getRepositoryKey());
            xmlBuffer.append("    <" + aKey.getType() + "Id=\"" + aKey.getId() + "\"/>\n");
        }
        xmlBuffer.append("  </Metadata>\n");
        xmlBuffer.append("  <ns>SAS</ns>\n");
        xmlBuffer.append("  <Flags>8</Flags>\n");
        xmlBuffer.append("  <options/>\n");
        xmlBuffer.append("</GetMetadata>\n");
        StringHolder outXml = new StringHolder();
        try {
            this._mdfactory.getConnection().getCMRHandle().DoRequest(xmlBuffer.toString(), outXml);
            String outString = outXml.value;
            this._mdfactory.getOMIUtil().getOMIUtility().populateStoreFromString((MdStore)this._mdstore, outString, 2, false);
        }
        catch (GenericError ex) {
            return;
        }
        catch (SystemException ex) {
            return;
        }
        catch (RemoteException ex) {
            return;
        }
        catch (MdException ex) {
            return;
        }
    }

    @Override
    public void debug(String context, ResourceBundle rb, String key, Object arg0, Object arg1, Object arg2) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isDebugEnabled() && arg0 != null) {
            if (arg1 != null) {
                if (arg2 != null) {
                    logger.debug(Message.format((ResourceBundle)rb, (String)key, (Object)arg0, (Object)arg1, (Object)arg2));
                } else {
                    logger.debug(Message.format((ResourceBundle)rb, (String)key, (Object)arg0, (Object)arg1));
                }
            } else {
                logger.debug(Message.format((ResourceBundle)rb, (String)key, (Object)arg0));
            }
        }
    }

    @Override
    public void debug(String context, String message) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    @Override
    public void debug(String context, String message, Throwable t) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isDebugEnabled()) {
            logger.debug(message, t);
        }
    }

    @Override
    public void info(String context, ResourceBundle rb, String key, Object arg0, Object arg1, Object arg2) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (this._logger.isInfoEnabled() && arg0 != null) {
            if (arg1 != null) {
                if (arg2 != null) {
                    logger.info(Message.format((ResourceBundle)rb, (String)key, (Object)arg0, (Object)arg1, (Object)arg2));
                } else {
                    logger.info(Message.format((ResourceBundle)rb, (String)key, (Object)arg0, (Object)arg1));
                }
            } else {
                logger.info(Message.format((ResourceBundle)rb, (String)key, (Object)arg0));
            }
        }
    }

    @Override
    public void info(String context, String message) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isInfoEnabled()) {
            logger.info(message);
        }
    }

    @Override
    public void info(String context, String message, Throwable t) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isInfoEnabled()) {
            logger.info(message, t);
        }
    }

    @Override
    public void warn(String context, ResourceBundle rb, String key, Object arg0, Object arg1) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (arg0 != null) {
            if (arg1 != null) {
                logger.warn(Message.format((ResourceBundle)rb, (String)key, (Object)arg0, (Object)arg1));
            } else {
                logger.warn(Message.format((ResourceBundle)rb, (String)key, (Object)arg0));
            }
        }
    }

    @Override
    public void warn(String context, String message) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        logger.warn(message);
    }

    @Override
    public void warn(String context, String message, Throwable t) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        logger.warn(message, t);
    }

    @Override
    public void error(String context, ResourceBundle rb, String key, Object arg0, Object arg1) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (arg0 != null) {
            if (arg1 != null) {
                logger.error(Message.format((ResourceBundle)rb, (String)key, (Object)arg0, (Object)arg1));
            } else {
                logger.error(Message.format((ResourceBundle)rb, (String)key, (Object)arg0));
            }
        }
    }

    @Override
    public void error(String context, String message) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        logger.error(message);
    }

    public void MdStoreIDChange(MdEvent e, List itemsOld, List itemsNew) throws RemoteException {
        if (itemsOld.size() != itemsNew.size()) {
            return;
        }
        for (int i = 0; i < itemsOld.size(); ++i) {
            String oldId = (String)itemsOld.get(i);
            String newId = (String)itemsNew.get(i);
            MetadataInterface mi = (MetadataInterface)this._cache.get(oldId);
            if (mi == null) continue;
            this._cache.remove(oldId);
            this._cache.put(newId, mi);
            this._tempMap.put(oldId, newId);
        }
    }

    public void MdObjectsAdded(MdEvent e, List items) throws RemoteException {
    }

    public void MdObjectsRemoved(MdEvent e, List items) throws RemoteException {
    }

    public void MdObjectsModified(MdEvent e, List items) throws RemoteException {
    }

    @Override
    public void refreshAllData() throws ServiceException, RemoteException {
        ArrayList items = new ArrayList(this._cache.values());
        for (MetadataInterface mi : items) {
            try {
                if (mi.isDeleted() || mi.isDestroyed()) continue;
                this.refreshEntity(mi);
            }
            catch (ServiceException serviceException) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @Override
    public void clearPendingChanges(boolean rollback) throws ServiceException, RemoteException {
        Map deletedMap = this._mdstore.getDeletedObjects();
        for (String nextKey : deletedMap.keySet()) {
            this._mdstore.restoreObject(nextKey);
        }
        if (rollback) {
            Vector changeList = new Vector(this._mdstore.getChangeList());
            for (Root root : changeList) {
                String id = root.getFQID();
                if (id.indexOf(36) > -1) {
                    this.deleteEntity((CMetadata)root);
                    continue;
                }
                try {
                    this._mdstore.refreshObjectFromServer((CMetadata)root, false, true, true);
                }
                catch (MdException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        this._mdstore.clearChangeList();
    }

    public void MdObjectModified(MdEvent e) throws RemoteException {
    }

    public boolean notify(MdConnectionEvent event) throws RemoteException {
        try {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("The connection to the metadata server has been lost.  Attempting to reconnect.");
            }
            this.reconnect();
            return true;
        }
        catch (ServiceException e) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("The reconnection attempt failed.");
            }
            return false;
        }
    }

    @Override
    public void addMetadataConnectionListener(MetadataConnectionListener listener) throws ServiceException, RemoteException {
        if (this._metadataConnectionListeners == null) {
            this._metadataConnectionListeners = new ArrayList<MetadataConnectionListener>();
        }
        if (!this._metadataConnectionListeners.contains(listener)) {
            this._metadataConnectionListeners.add(listener);
        }
    }

    @Override
    public void removeMetadataConnectionListener(MetadataConnectionListener listener) throws ServiceException, RemoteException {
        if (this._metadataConnectionListeners != null && this._metadataConnectionListeners.contains(listener)) {
            this._metadataConnectionListeners.remove(listener);
        }
    }

    void notifyMetadataConnectionListeners() {
        if (this._metadataConnectionListeners == null || this._metadataConnectionListeners.isEmpty()) {
            return;
        }
        MetadataConnectionEvent event = new MetadataConnectionEvent(this, this);
        for (MetadataConnectionListener listener : this._metadataConnectionListeners) {
            try {
                listener.connectionNotification(event);
            }
            catch (Throwable t) {
                this._logger.debug("Exception occurred trying to notify listener about connection event: " + listener, t);
            }
        }
    }

    public void MdObjectsCreated(MdFactoryEvent e) throws RemoteException {
    }

    public void MdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
        try {
            String[] idArray = e.getObjectIDs();
            for (int i = 0; i < idArray.length; ++i) {
                String id = idArray[i];
                MetadataInterface mi = (MetadataInterface)this._cache.get(id);
                if (mi == null) continue;
                mi.setDeleted();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void MdObjectsModified(MdFactoryEvent e) throws RemoteException {
    }

    protected OMIKey makeKey(String repositoryKey) throws ServiceException, RemoteException {
        OMIKey result = null;
        try {
            repositoryKey = URLDecoder.decode(repositoryKey, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        this.debug("com.sas.services.information.OMIServer", RB.getResources(), "OMIRepository.fetchdata.msg.fmt.txt", repositoryKey, null, null);
        Object cm = null;
        Object mi = null;
        Object type = null;
        if (ISEntityKey.isValidEntityKey(repositoryKey)) {
            ISEntityKey iseKey = new ISEntityKey(repositoryKey);
            String protocol = iseKey.getProtocol();
            if (!protocol.equals("omi")) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (Object)repositoryKey));
            }
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            result = new OMIKey(omrKey.getId(), omrKey.getType());
        } else {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(repositoryKey);
            result = new OMIKey(omrKey.getId(), omrKey.getType());
        }
        return result;
    }

    static class SmartTypeHelper {
        private static String TRUE = Boolean.TRUE.toString();
        private static String FALSE = Boolean.FALSE.toString();
        private Result _defaultResult;
        private Map _results = Collections.synchronizedMap(new HashMap(8));

        SmartTypeHelper(String defaultSmartType) {
            this._defaultResult = new Result(defaultSmartType, false);
        }

        Result getDefaultResult() {
            return this._defaultResult;
        }

        Result lookup(String className) throws ServiceException {
            Result rval = (Result)this._results.get(className);
            if (rval == null) {
                try {
                    Class targetClass = Factory.getInstance().loadClass(className);
                    Object obj = targetClass.newInstance();
                    MetadataInterface emptyMd = (MetadataInterface)obj;
                    String smartType = emptyMd.getType();
                    boolean isFolder = emptyMd instanceof FolderInterface;
                    rval = new Result(smartType, isFolder);
                    this._results.put(className, rval);
                }
                catch (ClassNotFoundException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
                catch (InstantiationException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
                catch (IllegalAccessException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
                catch (RemoteException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
                catch (NoClassDefFoundError e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
            }
            return rval;
        }

        static class Result {
            private String _smartType;
            private boolean _isFolder;

            public Result(String smartType, boolean isFolder) {
                this._smartType = smartType;
                this._isFolder = isFolder;
            }

            public String getSmartType() {
                return this._smartType;
            }

            public boolean isFolder() {
                return this._isFolder;
            }

            public String isFolderStr() {
                return this._isFolder ? TRUE : FALSE;
            }
        }
    }

    protected class cVetoableChangeListener
    implements VetoableChangeListener {
        private MdObjectStore store;

        public cVetoableChangeListener(MdObjectStore Store) {
            this.store = Store;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            try {
                String storeName = e.getPropertyName();
                if (storeName == null || !storeName.startsWith("detached")) {
                    return;
                }
                Object newValue = e.getNewValue();
                if (newValue instanceof ArrayList) {
                    ArrayList ids = (ArrayList)e.getNewValue();
                    boolean copysetting = this.store.getIsObjectCopiedFromParentOnCreation();
                    this.store.setIsObjectCopiedFromParentOnCreation(false);
                    try {
                        for (String objectId : ids) {
                            CMetadata updatedObject = this.store.getObject(objectId, false);
                            if (updatedObject == null) continue;
                            updatedObject.setState(4);
                        }
                    }
                    finally {
                        this.store.setIsObjectCopiedFromParentOnCreation(copysetting);
                    }
                }
                throw new PropertyVetoException("Changes rejected by user", e);
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    class RepositoryEntry {
        public String name;
        public String fqid;
        public String type;
        public String desc;
        public String path;
        public String engine;
        public String options;
        public String access;
        public String effectiveAccess;
        public String format;
        public String state;
        public Date metadataCreated;
        public Date metadataUpdated;
        public RepositoryInterface repos;

        public RepositoryEntry(String fqid, String name, String type, String desc, String path, String engine, String options, String access, String effectiveAccess, String format, String state, Date metadataCreated, Date metadataUpdated, RepositoryInterface repos) {
            this.fqid = fqid;
            this.name = name;
            this.type = type;
            this.desc = desc;
            this.path = path;
            this.engine = engine;
            this.options = options;
            this.access = access;
            this.effectiveAccess = effectiveAccess;
            this.format = format;
            this.state = state;
            this.metadataCreated = metadataCreated;
            this.metadataUpdated = metadataUpdated;
            this.repos = repos;
        }
    }

    public class OMIKey {
        private String fqid;
        private String type;

        public OMIKey(String fqid, String type) {
            this.fqid = fqid;
            this.type = type;
        }

        public final String getFqid() {
            return this.fqid;
        }

        public final String getType() {
            return this.type;
        }
    }
}

