/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.impl.BaseCacheFactory;
import com.sas.services.information.ChildRepositoryInterface;
import com.sas.services.information.Factory;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepository;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RB;
import com.sas.services.information.cache.RepositoryCache;
import com.sas.services.information.metadata.MetadataInterface;
import java.io.Serializable;
import java.rmi.RemoteException;

@SASScope
public class OMIChildRepository
extends OMIRepository
implements ChildRepositoryInterface {
    private static final long serialVersionUID = 3632612634631882376L;
    OMIRepositoryInterface _parent;

    public OMIChildRepository() throws RemoteException {
        super(OMIChildRepository.class);
    }

    public OMIChildRepository(MdFactory mdfactory, MdObjectStore mdstore, OMIRepositoryInterface parent, int childnum) throws RemoteException {
        this(mdfactory, mdstore, parent, childnum, OMIChildRepository.class);
    }

    public OMIChildRepository(MdFactory mdfactory, MdObjectStore mdstore, OMIRepositoryInterface parent, int childnum, Class theClass) throws RemoteException {
        super(theClass);
        String parentUrl;
        this._mdfactory = (MdFactoryImpl)mdfactory;
        this._mdstore = mdstore;
        if (parent == null) {
            if (this._logger != null) {
                this._logger.warn(RB.getStringResource("ChildRepository.nullparent.ex.txt"));
            }
            throw new IllegalArgumentException(RB.getStringResource("ChildRepository.nullparent.ex.txt"));
        }
        this._parent = parent;
        this.setISName(parent.getISName());
        this._defaultRepository = parent.getDefaultRepositoryId();
        this._defaultName = parent.getDefaultRepositoryName();
        this._isConnected = true;
        try {
            this._omiServer = (MetadataServerInterface)parent.getServer();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this._subNum = ((OMIRepository)this._parent).getSubNum() + '.' + childnum;
        this._url = parentUrl = this._parent.getUrl();
        int index = parentUrl.indexOf(58);
        int index2 = parentUrl.indexOf(58, index += 3);
        String host = parentUrl.substring(index, index2);
        String port = null;
        index = parentUrl.indexOf(47, ++index2);
        port = index < 0 ? parentUrl.substring(index2) : parentUrl.substring(index2, index);
        String subNumPath = this._subNum.replace('.', '/');
        String defaultRepository = this.getDefaultRepositoryId();
        try {
            this._cache = (RepositoryCache)BaseCacheFactory.getCache((String)this.getClass().getName(), (String)("/Metadata/omi/" + host + "-" + port + "/" + (defaultRepository != null ? defaultRepository + '/' : "") + subNumPath), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (CacheException cex) {
            throw new RuntimeException(cex);
        }
        this.getUniqueId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            OMIRepositoryInterface oMIRepositoryInterface = this._parent;
            synchronized (oMIRepositoryInterface) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug(RB.getStringResource("ChildRepository.commit.msg.txt"));
                }
                this._mdstore.updatedMetadataAll();
                if (!(this._parent instanceof OMIChildRepository)) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(RB.getStringResource("ChildRepository.flush.msg.txt"));
                    }
                    try {
                        ((OMIRepository)this._parent).flush();
                    }
                    catch (ServiceException ex) {
                        Serializable cause = (Exception)ex.getRootException();
                        if (cause == null) {
                            cause = ex;
                        }
                        throw new ServiceException((Throwable)cause, RB.getStringResource("ChildRepository.updexcept.ex.txt"));
                    }
                }
                this.close();
            }
        }
        catch (MdException ex) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(RB.getStringResource("ChildRepository.updexcept.ex.txt"), (Throwable)ex);
            }
            throw new ServiceException(ex, RB.getStringResource("ChildRepository.updexcept.ex.txt"));
        }
    }

    @Override
    public void rollback() throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ChildRepository.rollback.msg.txt"));
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws RemoteException {
        block7: {
            if (this._isDestroyed) {
                return;
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("The child repository is closing");
            }
            try {
                if (this._mdstore == null) break block7;
                OMIRepositoryInterface oMIRepositoryInterface = this._parent;
                synchronized (oMIRepositoryInterface) {
                    this._mdstore.dispose();
                    this._mdstore = null;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this._parent = null;
        this._mdfactory = null;
        super.close();
    }

    @Override
    public MetadataInterface fetch(String repositoryKey) throws ServiceException, RemoteException {
        String localKey = repositoryKey;
        MetadataInterface result = null;
        String type = null;
        this.pulseCheck();
        int index = localKey.indexOf("/");
        if (index > 0) {
            type = localKey.substring(index + 1);
            localKey = localKey.substring(0, index);
        }
        String reposPart = repositoryKey.substring(0, 8);
        if (this._defaultRepository != null && this._defaultRepository.endsWith(reposPart)) {
            MdObjectStore parentStore = (MdObjectStore)this._mdstore.getOwningStore();
            CMetadata c = this._mdfactory.createComplexMetadataObject(this._mdstore, (MdStore)parentStore, "", type, localKey);
            result = Factory.getInstance().processWithRepository(c, this);
            return result;
        }
        return super.fetch(repositoryKey);
    }

    @Override
    public String getDefaultRepositoryName() throws RemoteException {
        if (this._isDestroyed) {
            return "";
        }
        return this._parent.getDefaultRepositoryName();
    }

    @Override
    public String getDefaultRepositoryId() throws RemoteException {
        if (this._isDestroyed) {
            return "";
        }
        return this._parent.getDefaultRepositoryId();
    }

    @Override
    public void addEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.pulseCheck();
    }

    @Override
    public void deleteEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.pulseCheck();
        Object o = input.getRepositoryEntity();
        if (!(o instanceof CMetadata)) {
            throw new ServiceException(RB.getStringResource("OMIRepository.deletebadcls.ex.txt"));
        }
        this.deleteEntity((CMetadata)o);
    }

    @Override
    public void deleteEntity(CMetadata metadata) throws ServiceException, RemoteException {
        this.pulseCheck();
        metadata.delete();
    }

    @Override
    public void updateEntity(Object reposId, Object input) throws ServiceException, RemoteException {
        this.pulseCheck();
    }
}

