/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.DocumentServiceConfigAdapterInterface;
import com.sas.services.InitializationException;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.information.FactoryAction;
import com.sas.services.information.FactoryType;
import com.sas.services.information.InformationServiceInitObject;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryProtocol;
import com.sas.services.information.ServerDef;
import com.sas.services.information.SmartDef;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public final class InformationServiceInitializer
implements DocumentServiceConfigAdapterInterface {
    private static final String XML_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE InformationService><InformationService xmlns=\"urn:sas:InformationService\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:sas:InformationService com_sas_services_information_InformationService_9_2_0_0.xsd\" />";
    private static final String ATTRIBUTE_NAME2 = "Name";
    private static final String ATTRIBUTE_VALUE = "Value";

    InformationServiceInitializer() {
    }

    @Override
    public AbstractServiceComponentConfig createConfigFromDocument(Document document) throws ServiceException {
        return InformationServiceInitializer.parse(document);
    }

    public static InformationServiceInitObject parse(Document document) throws ServiceConfigurationException, InitializationException {
        if (document == null) {
            throw new ServiceConfigurationException(RB.getStringResource("IllegalArgument.specifyDocument.ex.txt"));
        }
        Element docElement = document.getDocumentElement();
        String docElementName = docElement.getNodeName();
        if (!"InformationService".equals(docElementName)) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.invalidConfigDocElement.ex.fmt.txt", (Object)"InformationService", (Object)docElementName));
        }
        InformationServiceInitObject serviceConfig = new InformationServiceInitObject();
        try {
            serviceConfig.setUsageVersion(UsageVersion.parseVersion((String)docElement.getAttribute("version")));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        InformationServiceInitializer.parseContext(document, serviceConfig);
        return serviceConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseContext(Node node, InformationServiceInitObject informationServiceInitObject) throws ServiceConfigurationException {
        NodeList nodeList;
        block42: {
            int optionKidsLength;
            NodeList optionKids;
            boolean secure;
            boolean auto;
            String domain;
            String port;
            String host;
            String protocol;
            String defName;
            String uid;
            ArrayList<String> hibList;
            ArrayList<String> baseList;
            String proxy;
            String description;
            HashMap<String, String> optionMap;
            block44: {
                int optionKidsLength2;
                NodeList optionKids2;
                boolean secure2;
                boolean auto2;
                String dialect;
                String base;
                String domain2;
                String port2;
                String host2;
                String protocol2;
                String defName2;
                String uid2;
                ArrayList<String> hibList2;
                nodeList = null;
                Node child = null;
                Logger logger = LogManager.getLogger(InformationServiceInitializer.class);
                boolean isDebugLogEnabled = logger.isDebugEnabled();
                try {
                    switch (node.getNodeType()) {
                        case 9: 
                        case 11: {
                            nodeList = node.getChildNodes();
                            int nodeListLength = nodeList.getLength();
                            int i = 0;
                            while (i < nodeListLength) {
                                child = nodeList.item(i);
                                InformationServiceInitializer.parseContext(child, informationServiceInitObject);
                                ++i;
                            }
                            return;
                        }
                        case 1: {
                            String secureString;
                            String autoString;
                            String elementName = node.getNodeName();
                            if ("Repository".equalsIgnoreCase(elementName)) {
                                informationServiceInitObject.addRepository(new RepositoryProtocol((Element)node), false);
                                break block42;
                            }
                            if ("ReposDef".equalsIgnoreCase(elementName)) {
                                optionMap = new HashMap<String, String>(2);
                                hibList2 = new ArrayList<String>(2);
                                Element element = (Element)node;
                                uid2 = element.getAttribute("uid");
                                defName2 = element.getAttribute("name");
                                protocol2 = element.getAttribute("protocol");
                                host2 = element.getAttribute("host");
                                port2 = element.getAttribute("port");
                                domain2 = element.getAttribute("domain");
                                base = element.getAttribute("base");
                                description = element.getAttribute("description");
                                autoString = element.getAttribute("auto");
                                proxy = element.getAttribute("proxy");
                                secureString = element.getAttribute("issecure");
                                dialect = element.getAttribute("hibdialect");
                                auto2 = false;
                                if (autoString != null) {
                                    auto2 = Boolean.valueOf(autoString);
                                }
                                secure2 = false;
                                if (secureString != null) {
                                    secure2 = Boolean.valueOf(secureString);
                                }
                                optionKids2 = element.getChildNodes();
                                optionKidsLength2 = optionKids2.getLength();
                                break;
                            }
                            if ("ServerDef".equalsIgnoreCase(elementName)) {
                                optionMap = new HashMap(2);
                                baseList = new ArrayList<String>(5);
                                hibList = new ArrayList<String>(2);
                                Element element = (Element)node;
                                uid = element.getAttribute("uid");
                                defName = element.getAttribute("name");
                                protocol = element.getAttribute("protocol");
                                host = element.getAttribute("host");
                                port = element.getAttribute("port");
                                domain = element.getAttribute("domain");
                                description = element.getAttribute("description");
                                autoString = element.getAttribute("auto");
                                proxy = element.getAttribute("proxy");
                                secureString = element.getAttribute("issecure");
                                auto = false;
                                if (autoString != null) {
                                    auto = Boolean.valueOf(autoString);
                                }
                                secure = false;
                                if (secureString != null) {
                                    secure = Boolean.valueOf(secureString);
                                }
                                optionKids = element.getChildNodes();
                                optionKidsLength = optionKids.getLength();
                                break block44;
                            }
                            if (elementName.equalsIgnoreCase("GroupDef")) {
                                Element element = (Element)node;
                                String groupName = element.getAttribute("name");
                                if (groupName == null || groupName.length() <= 0) break block42;
                                nodeList = node.getChildNodes();
                                int nodelistlength = nodeList.getLength();
                                HashSet<String> repositoryNames = new HashSet<String>(nodelistlength);
                                for (int i = 0; i < nodelistlength; ++i) {
                                    child = nodeList.item(i);
                                    if (child.getNodeType() != 1 || !(elementName = child.getNodeName()).equalsIgnoreCase("Member")) continue;
                                    repositoryNames.add(((Element)child).getAttribute("name"));
                                }
                                if (repositoryNames.size() > 0) {
                                    informationServiceInitObject.addRepositoryGroup(new RepositoryGroup(element.getAttribute("uid"), groupName, element.getAttribute("description"), new ArrayList<String>(repositoryNames)));
                                }
                                break block42;
                            }
                            if ("ConsumerUsage".equals(elementName)) {
                                informationServiceInitObject.parseConsumerUsage((Element)node);
                                break block42;
                            } else if ("Factory".equalsIgnoreCase(elementName)) {
                                nodeList = node.getChildNodes();
                                SmartDef definition = null;
                                int nodelistlength = nodeList.getLength();
                                String factType = null;
                                String factProtocol = null;
                                int i = 0;
                                while (i < nodelistlength) {
                                    child = nodeList.item(i);
                                    if (child.getNodeType() == 1) {
                                        Element element;
                                        elementName = child.getNodeName();
                                        if ("Type".equalsIgnoreCase(elementName)) {
                                            element = (Element)child;
                                            try {
                                                factProtocol = element.getAttribute("protocol");
                                                factType = element.getAttribute("type");
                                                FactoryType factoryType = informationServiceInitObject.getFactoryType(factProtocol, factType);
                                                if (factoryType == null) {
                                                    factoryType = new FactoryType(factProtocol, factType);
                                                    informationServiceInitObject.addFactoryType(factoryType);
                                                }
                                                informationServiceInitObject.addFactoryAction(factoryType, new FactoryAction(element));
                                            }
                                            catch (IllegalArgumentException e) {
                                                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ISI.parseElement.ex.fmt.txt", (Object)element.getNodeName()), (Throwable)e);
                                            }
                                        } else if (elementName.equalsIgnoreCase("SmartObject")) {
                                            element = (Element)child;
                                            String smartType = element.getAttribute("smartType");
                                            if (isDebugLogEnabled) {
                                                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ISI.parsedSmartDef.fmt.log", (Object)smartType));
                                            }
                                            String interfaceClass = element.getAttribute("interface");
                                            definition = new SmartDef(element.getAttribute("uid"), smartType, interfaceClass, null, null);
                                            informationServiceInitObject.addSmartDef(definition);
                                            FactoryAction theAction = null;
                                            NodeList smartKids = element.getChildNodes();
                                            int smartKidsLength = smartKids.getLength();
                                            SmartDef.ActionDef smartDefAction = null;
                                            for (int k = 0; k < smartKidsLength; ++k) {
                                                Node smartChild = smartKids.item(k);
                                                String smartChildName = smartChild.getNodeName();
                                                if (smartChildName.equalsIgnoreCase("Action")) {
                                                    Element smartAction = (Element)smartChild;
                                                    String protocol3 = smartAction.getAttribute("protocol");
                                                    String type = smartAction.getAttribute("type");
                                                    String action = smartAction.getAttribute("action");
                                                    String filter = smartAction.getAttribute("filter");
                                                    theAction = new FactoryAction(smartAction.getAttribute("uid"), action, filter);
                                                    smartDefAction = SmartDef.newAction();
                                                    smartDefAction.setProtocol(protocol3);
                                                    smartDefAction.setType(type);
                                                    smartDefAction.setAction(theAction);
                                                    informationServiceInitObject.addSmartDefAction(definition, smartDefAction);
                                                    continue;
                                                }
                                                if (!smartChildName.equalsIgnoreCase("Filter")) continue;
                                                Element smartFilter = (Element)smartChild;
                                                definition.setFilterClass(smartFilter.getAttribute("class"));
                                            }
                                        }
                                    }
                                    ++i;
                                }
                                return;
                            }
                            break block42;
                        }
                        case 3: {
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ServiceConfigurationException(e, RB.getStringResource("InformationServiceInitializer.parseContext.ex.txt"));
                }
                for (int k = 0; k < optionKidsLength2; ++k) {
                    Node optionChild = optionKids2.item(k);
                    String optionChildName = optionChild.getNodeName();
                    if (optionChildName.equalsIgnoreCase("Option")) {
                        Element optionElement = (Element)optionChild;
                        String optionName = optionElement.getAttribute(ATTRIBUTE_NAME2);
                        String optionValue = optionElement.getAttribute(ATTRIBUTE_VALUE);
                        optionMap.put(optionName, optionValue);
                        continue;
                    }
                    if (!optionChildName.equalsIgnoreCase("Hibernate-class")) continue;
                    Element hibElement = (Element)optionChild;
                    String className = hibElement.getAttribute(ATTRIBUTE_NAME2);
                    hibList2.add(className);
                }
                RepositoryDef def = new RepositoryDef(uid2, host2, port2, domain2, base, protocol2, defName2);
                def.setAuto(auto2);
                def.setDescription(description);
                def.setProxy(proxy);
                def.setIsSecure(secure2);
                def.setHibDialect(dialect);
                if (optionMap.size() > 0) {
                    def.setAdvancedOptions(optionMap);
                }
                if (hibList2.size() > 0) {
                    def.setHibClasses(hibList2);
                }
                informationServiceInitObject.addReposDef(defName2, def);
                break block42;
            }
            for (int k = 0; k < optionKidsLength; ++k) {
                Node optionChild = optionKids.item(k);
                String optionChildName = optionChild.getNodeName();
                if (optionChildName.equalsIgnoreCase("Option")) {
                    Element optionElement = (Element)optionChild;
                    String optionName = optionElement.getAttribute(ATTRIBUTE_NAME2);
                    String optionValue = optionElement.getAttribute(ATTRIBUTE_VALUE);
                    optionMap.put(optionName, optionValue);
                    continue;
                }
                if (optionChildName.equalsIgnoreCase("Base")) {
                    Element baseElement = (Element)optionChild;
                    String path = baseElement.getAttribute("Path");
                    baseList.add(path);
                    continue;
                }
                if (!optionChildName.equalsIgnoreCase("Hibernate-class")) continue;
                Element hibElement = (Element)optionChild;
                String className = hibElement.getAttribute(ATTRIBUTE_NAME2);
                hibList.add(className);
            }
            ServerDef def = new ServerDef(uid, defName, protocol, host, port);
            def.setDomain(domain);
            def.setAuto(auto);
            def.setDescription(description);
            def.setProxy(proxy);
            def.setIsSecure(secure);
            if (optionMap.size() > 0) {
                def.setAdvancedOptions(optionMap);
            }
            if (baseList.size() > 0) {
                def.setBaseLocations(baseList);
            }
            informationServiceInitObject.addServerDef(def);
        }
        nodeList = node.getChildNodes();
        int nodelistlength = nodeList.getLength();
        int i = 0;
        while (i < nodelistlength) {
            InformationServiceInitializer.parseContext(nodeList.item(i), informationServiceInitObject);
            ++i;
        }
    }

    static String getXMLDocument() {
        return XML_DOCUMENT;
    }
}

