/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.InitializationException;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerUsage;
import com.sas.services.information.FactoryAction;
import com.sas.services.information.FactoryActionConsumedResourceAdapter;
import com.sas.services.information.FactoryType;
import com.sas.services.information.InformationServiceFactory;
import com.sas.services.information.InformationServiceInitializer;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryProtocol;
import com.sas.services.information.ServerDef;
import com.sas.services.information.SmartDef;
import com.sas.services.information.SmartDefActionConsumedResourceAdapter;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@SASScope
public class InformationServiceInitObject
extends AbstractServiceComponentConfig {
    private static final String ELEMENT_BASE = "Base";
    private static final String BASE_PATH = "Path";
    static final String ELEMENT_INFORMATIONSERVICE = "InformationService";
    private static final String ELEMENT_OPTION = "Option";
    private static final String OPTION_NAME = "Name";
    private static final String OPTION_VALUE = "Value";
    private static final String ELEMENT_HIBCLASS = "Hibernate-class";
    private static final boolean IS_CONFIGURATION_UPDATEABLE = true;
    public static final String XML_ELEMENT_FACTORY = "Factory";
    private static final String TOKEN_SEPARATOR = ":";
    private static final UsageVersion USAGEVERSION_OLDEST = new UsageVersion(0, 0);
    private static final UsageVersion USAGEVERSION_CURRENT = new UsageVersion(0, 0);
    private Map<String, RepositoryProtocol> _repositoryProtocolMap = new HashMap<String, RepositoryProtocol>(5);
    private Map<String, FactoryType> _factoryTypeMap = new HashMap<String, FactoryType>(5);
    public Map<String, RepositoryDef> reposDefs = new HashMap<String, RepositoryDef>(5);
    public Map<String, ServerDef> serverDefs = new HashMap<String, ServerDef>(5);
    public Map<String, SmartDef> smartDefs = new HashMap<String, SmartDef>(5);
    public Map<String, RepositoryGroup> repositoryGroups = new HashMap<String, RepositoryGroup>(5);

    public InformationServiceInitObject() {
        super(InformationServiceInitializer.getXMLDocument(), true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
    }

    public InformationServiceInitObject(InputStream configInputStream) throws IllegalArgumentException {
        super(configInputStream, true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
    }

    @Override
    protected AbstractServiceComponentConfig createConfiguration(Document document) throws ServiceException {
        return InformationServiceInitializer.parse(document);
    }

    public void changeHost(String oldHost, String newHost) {
        ConsumedResourceInterface nextDef;
        Set<String> keySet = this.serverDefs.keySet();
        for (String nextKey : keySet) {
            nextDef = this.serverDefs.get(nextKey);
            if (!((ServerDef)nextDef).getHost().equalsIgnoreCase(oldHost)) continue;
            ((ServerDef)nextDef).setHost(newHost);
        }
        keySet = this.reposDefs.keySet();
        for (String nextKey : keySet) {
            nextDef = this.reposDefs.get(nextKey);
            if (!((RepositoryDef)nextDef).getHost().equalsIgnoreCase(oldHost)) continue;
            ((RepositoryDef)nextDef).setHost(newHost);
        }
    }

    @Override
    public Set<ConsumedResourceInterface> getUnusedResources(Set<String> removedConsumerNames) {
        Set<ConsumedResourceInterface> unusedConsumedResources = super.getUnusedResources(removedConsumerNames);
        int numItems = unusedConsumedResources.size();
        if (numItems > 0) {
            HashSet<ConsumedResourceInterface> unusedFactoryActions = new HashSet<ConsumedResourceInterface>(5);
            HashSet<ConsumedResourceInterface> unusedRepositoryGroups = new HashSet<ConsumedResourceInterface>(5);
            HashSet<ConsumedResourceInterface> unusedSmartDefs = new HashSet<ConsumedResourceInterface>(5);
            HashSet<ConsumedResourceInterface> unusedSmartActions = new HashSet<ConsumedResourceInterface>(5);
            HashMap<String, RepositoryDef> unusedRepositories = new HashMap<String, RepositoryDef>(numItems);
            HashMap<String, RepositoryProtocol> unusedProtocols = new HashMap<String, RepositoryProtocol>(numItems);
            ConsumedResourceInterface consumedResource = null;
            RepositoryDef repositoryDef = null;
            RepositoryProtocol repositoryProtocol = null;
            Iterator<ConsumedResourceInterface> iter = unusedConsumedResources.iterator();
            block8: while (iter.hasNext()) {
                consumedResource = iter.next();
                switch (consumedResource.getResourceTypeCode()) {
                    case 0: {
                        unusedFactoryActions.add(consumedResource);
                        continue block8;
                    }
                    case 3: {
                        repositoryDef = (RepositoryDef)consumedResource;
                        if (this.isRepositoryUsedByConsumer(repositoryDef, removedConsumerNames)) {
                            iter.remove();
                            continue block8;
                        }
                        unusedRepositories.put(consumedResource.getResourceID(), repositoryDef);
                        continue block8;
                    }
                    case 4: {
                        unusedRepositoryGroups.add(consumedResource);
                        continue block8;
                    }
                    case 2: {
                        repositoryProtocol = (RepositoryProtocol)consumedResource;
                        if (this.isProtocolUsedByRepositoryDefConsumer(repositoryProtocol, removedConsumerNames) || this.isProtocolUsedByFactoryActionConsumer(repositoryProtocol, removedConsumerNames) || this.isProtocolUsedBySmartActionConsumer(repositoryProtocol, removedConsumerNames)) {
                            iter.remove();
                            continue block8;
                        }
                        unusedProtocols.put(consumedResource.getResourceID(), repositoryProtocol);
                        continue block8;
                    }
                    case 6: {
                        unusedSmartActions.add(consumedResource);
                        continue block8;
                    }
                    case 7: {
                        unusedSmartDefs.add(consumedResource);
                        continue block8;
                    }
                }
            }
            this.filterUnusedRepositoryDefs(unusedConsumedResources, unusedRepositoryGroups, unusedRepositories);
            boolean isUsed = false;
            RepositoryProtocol unusedRepositoryProtocol2 = null;
            for (RepositoryProtocol unusedRepositoryProtocol2 : new HashSet(unusedProtocols.values())) {
                isUsed = this.filterUnusedFactoryActions(unusedRepositoryProtocol2, unusedFactoryActions, unusedProtocols);
                if (!isUsed) {
                    isUsed = this.filterUnusedRepositoryDefsForProtocol(unusedRepositoryProtocol2, unusedRepositories, unusedProtocols);
                }
                if (isUsed) continue;
                isUsed = this.filterUnusedSmartActionsForProtocol(unusedRepositoryProtocol2, unusedSmartActions, unusedProtocols);
            }
        }
        return unusedConsumedResources;
    }

    private boolean filterUnusedSmartActionsForProtocol(RepositoryProtocol unusedRepositoryProtocol, Set<ConsumedResourceInterface> unusedSmartActions, Map<String, RepositoryProtocol> unusedProtocols) {
        boolean isUsed = false;
        if (unusedRepositoryProtocol != null) {
            SmartDef.ActionDef smartAction2 = null;
            for (SmartDef.ActionDef smartAction2 : this.getSmartActionsForProtocol(unusedRepositoryProtocol.getProtocol())) {
                if (unusedSmartActions.contains(smartAction2)) continue;
                unusedProtocols.remove(unusedRepositoryProtocol.getResourceID());
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    private boolean filterUnusedFactoryActions(RepositoryProtocol unusedRepositoryProtocol, Set<ConsumedResourceInterface> unusedFactoryActions, Map<String, RepositoryProtocol> unusedProtocols) {
        boolean isUsed = false;
        if (unusedRepositoryProtocol != null) {
            FactoryAction factoryAction2 = null;
            for (FactoryAction factoryAction2 : this.getFactoryActionsForProtocol(unusedRepositoryProtocol.getProtocol())) {
                if (unusedFactoryActions.contains(factoryAction2)) continue;
                unusedProtocols.remove(unusedRepositoryProtocol.getResourceID());
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    private boolean filterUnusedRepositoryDefsForProtocol(RepositoryProtocol unusedRepositoryProtocol, Map<String, RepositoryDef> unusedRepositoryDefs, Map<String, RepositoryProtocol> unusedProtocols) {
        boolean isUsed = false;
        if (unusedRepositoryProtocol != null) {
            for (RepositoryDef repositoryDef : this.getReposDefsForProtocol(unusedRepositoryProtocol.getProtocol())) {
                if (unusedRepositoryDefs.values().contains(repositoryDef)) continue;
                unusedProtocols.remove(unusedRepositoryProtocol.getResourceID());
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    public Set<RepositoryDef> getReposDefsForProtocol(String protocol) {
        HashSet<RepositoryDef> repositoryDefs = new HashSet<RepositoryDef>(this.reposDefs.size());
        for (RepositoryDef repositoryDef : this.reposDefs.values()) {
            if (!protocol.equals(repositoryDef.getProtocol())) continue;
            repositoryDefs.add(repositoryDef);
        }
        return repositoryDefs;
    }

    private void filterUnusedRepositoryDefs(Set<ConsumedResourceInterface> unusedConsumedResources, Set<ConsumedResourceInterface> unusedRepositoryGroups, Map<String, RepositoryDef> unusedRepositories) {
        List<String> groupRepositoryDefs = null;
        for (RepositoryGroup repositoryGroup : this.repositoryGroups.values()) {
            if (unusedRepositoryGroups.contains(repositoryGroup)) continue;
            groupRepositoryDefs = repositoryGroup.getGroupNames();
            int numMembers = groupRepositoryDefs.size();
            int numUnusedMembers = 0;
            HashMap<String, RepositoryDef> usedGroupMembers = new HashMap<String, RepositoryDef>(numMembers);
            String resourceID = null;
            for (String reposDefName : groupRepositoryDefs) {
                RepositoryDef repositoryDef = this.getReposDef(reposDefName);
                if (repositoryDef == null) continue;
                resourceID = repositoryDef.getResourceID();
                usedGroupMembers.put(resourceID, repositoryDef);
                if (unusedRepositories.get(resourceID) == null) continue;
                ++numUnusedMembers;
            }
            if (numUnusedMembers != numMembers) continue;
            for (RepositoryDef repositoryDef : usedGroupMembers.values()) {
                unusedRepositories.remove(repositoryDef.getResourceID());
                unusedConsumedResources.remove(repositoryDef);
            }
        }
    }

    private boolean isProtocolUsedByRepositoryDefConsumer(RepositoryProtocol repositoryProtocol, Set<String> removedConsumerNames) {
        boolean isUsed = false;
        String protocol = repositoryProtocol.getProtocol();
        HashSet<String> consumerIDs = new HashSet<String>(5);
        ConsumerUsage consumerUsage = this.getConsumerUsage();
        RepositoryDef repositoryDef2 = null;
        for (RepositoryDef repositoryDef2 : this.reposDefs.values()) {
            if (!protocol.equals(repositoryDef2.getProtocol())) continue;
            for (Consumer consumer : consumerUsage.getConsumersForResource(repositoryDef2.getResourceID(), true)) {
                if (consumer == null) continue;
                consumerIDs.add(consumer.getID());
            }
        }
        if (consumerIDs.size() > 0) {
            HashSet<String> removedConsumerIDs = new HashSet<String>(removedConsumerNames.size());
            for (String consumerName : removedConsumerNames) {
                Consumer consumer = consumerUsage.getConsumerUsingName(consumerName);
                if (consumer == null) continue;
                removedConsumerIDs.add(consumer.getID());
            }
            for (String consumerID : consumerIDs) {
                if (removedConsumerIDs.contains(consumerID)) continue;
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    private boolean isProtocolUsedByFactoryActionConsumer(RepositoryProtocol repositoryProtocol, Set<String> removedConsumerNames) {
        boolean isUsed = false;
        String protocol = repositoryProtocol.getProtocol();
        HashSet<String> consumerIDs = new HashSet<String>(5);
        ConsumerUsage consumerUsage = this.getConsumerUsage();
        FactoryAction factoryAction2 = null;
        for (FactoryAction factoryAction2 : this.getFactoryActionsForProtocol(protocol)) {
            for (Consumer consumer : consumerUsage.getConsumersForResource(factoryAction2.getResourceID(), true)) {
                if (consumer == null) continue;
                consumerIDs.add(consumer.getID());
            }
        }
        if (consumerIDs.size() > 0) {
            HashSet<String> removedConsumerIDs = new HashSet<String>(removedConsumerNames.size());
            Iterator<String> iter = removedConsumerNames.iterator();
            while (iter.hasNext()) {
                Consumer consumer;
                consumer = consumerUsage.getConsumerUsingName(iter.next());
                if (consumer == null) continue;
                removedConsumerIDs.add(consumer.getID());
            }
            for (String consumerID : consumerIDs) {
                if (removedConsumerIDs.contains(consumerID)) continue;
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    private boolean isProtocolUsedBySmartActionConsumer(RepositoryProtocol repositoryProtocol, Set<String> removedConsumerNames) {
        boolean isUsed = false;
        HashSet<String> consumerIDs = new HashSet<String>(5);
        ConsumerUsage consumerUsage = this.getConsumerUsage();
        SmartDef.ActionDef smartAction2 = null;
        for (SmartDef.ActionDef smartAction2 : this.getSmartActionsForProtocol(repositoryProtocol.getProtocol())) {
            for (Consumer consumer : consumerUsage.getConsumersForResource(smartAction2.getResourceID(), true)) {
                if (consumer == null) continue;
                consumerIDs.add(consumer.getID());
            }
        }
        if (consumerIDs.size() > 0) {
            HashSet<String> removedConsumerIDs = new HashSet<String>(removedConsumerNames.size());
            for (String consumerName : removedConsumerNames) {
                Consumer consumer = consumerUsage.getConsumerUsingName(consumerName);
                if (consumer == null) continue;
                removedConsumerIDs.add(consumer.getID());
            }
            for (String consumerID : consumerIDs) {
                if (removedConsumerIDs.contains(consumerID)) continue;
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    private boolean isRepositoryUsedByConsumer(RepositoryDef repositoryDef, Set<String> removedConsumerNames) {
        boolean isUsed = false;
        String repositoryDefName = repositoryDef.getName();
        HashSet<String> contextConsumerIDs = new HashSet<String>(5);
        ConsumerUsage consumerUsage = this.getConsumerUsage();
        for (RepositoryGroup repositoryGroup : this.repositoryGroups.values()) {
            if (!repositoryGroup.getGroupNames().contains(repositoryDefName)) continue;
            for (Consumer consumer : consumerUsage.getConsumersForResource(repositoryGroup.getResourceID(), true)) {
                if (consumer == null) continue;
                contextConsumerIDs.add(consumer.getID());
            }
        }
        if (contextConsumerIDs.size() > 0) {
            HashSet<String> removedConsumerIDs = new HashSet<String>(removedConsumerNames.size());
            for (String consumerName : removedConsumerNames) {
                Consumer consumer;
                consumer = consumerUsage.getConsumerUsingName(consumerName);
                if (consumer == null) continue;
                removedConsumerIDs.add(consumer.getID());
            }
            for (String consumerID : contextConsumerIDs) {
                if (removedConsumerIDs.contains(consumerID)) continue;
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    final String[] getProtocols() {
        int numItems = this._repositoryProtocolMap.size();
        String[] protocols = new String[numItems];
        int i = 0;
        for (RepositoryProtocol repositoryProtocol : this._repositoryProtocolMap.values()) {
            protocols[i] = repositoryProtocol.getProtocol();
        }
        return protocols;
    }

    public RepositoryProtocol getRepositoryProtocol(String protocol) {
        RepositoryProtocol repositoryProtocol = null;
        if (protocol != null) {
            for (RepositoryProtocol nextRepositoryProtocol : this._repositoryProtocolMap.values()) {
                if (!protocol.equals(nextRepositoryProtocol.getProtocol())) continue;
                repositoryProtocol = nextRepositoryProtocol;
                break;
            }
        }
        return repositoryProtocol;
    }

    public RepositoryProtocol getRepositoryProtocolUsingID(String resourceID) {
        RepositoryProtocol repositoryProtocol = null;
        if (resourceID != null) {
            repositoryProtocol = this._repositoryProtocolMap.get(resourceID);
        }
        return repositoryProtocol;
    }

    public Set<RepositoryProtocol> getRepositoryProtocols() {
        return new HashSet<RepositoryProtocol>(this._repositoryProtocolMap.values());
    }

    final String getProtocolClass(String protocol) {
        RepositoryProtocol repositoryProtocol;
        String protocolClass = null;
        if (protocol != null && (repositoryProtocol = this.getRepositoryProtocol(protocol)) != null) {
            protocolClass = repositoryProtocol.getClassName();
        }
        return protocolClass;
    }

    public final boolean addRepository(String protocol, String className) {
        return this.addRepository(protocol, className, false);
    }

    public final boolean addRepository(String protocol, String className, boolean isOKToReplace) {
        boolean wasAdded = false;
        if (protocol == null || protocol.trim().length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("InformationServiceInitObject.specifyProtocol.ex.txt"));
        }
        if (className == null || className.trim().length() == 0) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.specifyClassForProtocol.ex.fmt.txt", (Object)protocol));
        }
        String protocolKey = protocol.toLowerCase();
        RepositoryProtocol repositoryProtocol = this.getRepositoryProtocol(protocolKey);
        if (repositoryProtocol == null) {
            repositoryProtocol = new RepositoryProtocol(null, protocolKey, className);
            this._repositoryProtocolMap.put(repositoryProtocol.getResourceID(), repositoryProtocol);
            this.addResource(repositoryProtocol);
        } else if (className.equals(repositoryProtocol.getClassName())) {
            wasAdded = true;
        } else if (isOKToReplace) {
            repositoryProtocol.setClassName(className);
            wasAdded = true;
        }
        return wasAdded;
    }

    public final boolean addRepository(RepositoryProtocol repositoryProtocol, boolean isOKToReplace) {
        boolean wasAdded = false;
        boolean isOKToAdd = false;
        if (repositoryProtocol != null) {
            String protocol = repositoryProtocol.getProtocol();
            RepositoryProtocol aRepositoryProtocol = this.getRepositoryProtocol(protocol);
            if (aRepositoryProtocol == null) {
                isOKToAdd = true;
            } else if (isOKToReplace) {
                this.removeRepositoryProtocol(aRepositoryProtocol);
                isOKToAdd = true;
            }
            if (isOKToAdd) {
                this._repositoryProtocolMap.put(repositoryProtocol.getResourceID(), repositoryProtocol);
                this.addResource(repositoryProtocol);
            }
        }
        return wasAdded;
    }

    public final boolean removeRepositoryProtocol(RepositoryProtocol repositoryProtocol) {
        boolean wasRemoved = false;
        if (repositoryProtocol != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                wasRemoved = this.removeResource(repositoryProtocol.getResourceID(), removedConsumedResources) != null;
            }
            catch (ServiceException e) {
                wasRemoved = false;
            }
        }
        return wasRemoved;
    }

    public final boolean removeRepository(String protocol) {
        boolean wasRemoved = false;
        if (protocol != null) {
            try {
                RepositoryProtocol repositoryProtocol = this.getRepositoryProtocol(protocol.toLowerCase());
                if (repositoryProtocol != null) {
                    HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                    wasRemoved = this.removeResource(repositoryProtocol.getResourceID(), removedConsumedResources) != null;
                }
            }
            catch (ServiceException e) {
                wasRemoved = false;
            }
        }
        return wasRemoved;
    }

    private Set<ConsumedResourceInterface> removeFactoryTypesForProtocol(String protocol, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        HashSet<ConsumedResourceInterface> removedItems = new HashSet<ConsumedResourceInterface>(this._factoryTypeMap.size());
        if (protocol != null) {
            ConsumedResourceInterface consumedResource = null;
            FactoryAction factoryAction2 = null;
            for (FactoryType factoryType : new HashSet<FactoryType>(this._factoryTypeMap.values())) {
                if (!protocol.equals(factoryType.getProtocol())) continue;
                for (FactoryAction factoryAction2 : factoryType.getFactoryActionSet()) {
                    consumedResource = this.removeResource(factoryAction2.getResourceID(), removedConsumedResources);
                    if (consumedResource == null) continue;
                    removedItems.add(consumedResource);
                }
            }
        }
        return removedItems;
    }

    public final ServerDef getServerDef(String name) {
        return this.serverDefs.get(name);
    }

    public final ServerDef getServerDefUsingID(String uid) {
        ServerDef serverDef = null;
        if (uid != null) {
            for (ServerDef aServerDef : this.serverDefs.values()) {
                if (!uid.equals(aServerDef.getUID())) continue;
                serverDef = aServerDef;
                break;
            }
        }
        return serverDef;
    }

    public final boolean addServerDef(ServerDef def) {
        boolean serverAdded = false;
        String name = def.getName();
        ServerDef serverDef = this.serverDefs.get(name);
        if (serverDef == null || !serverDef.equals(def)) {
            this.serverDefs.put(name, def);
            serverAdded = true;
            this.addResource(def);
        }
        return serverAdded;
    }

    public final boolean replaceServerDef(String oldServerDefName, ServerDef newServerDef) {
        ServerDef removedServerDef = this.serverDefs.remove(oldServerDefName);
        this.addServerDef(newServerDef);
        return removedServerDef != null;
    }

    public final boolean removeServerDef(String serverDefName) {
        ServerDef serverDef = this.serverDefs.get(serverDefName);
        ConsumedResourceInterface consumedResource = null;
        if (serverDef != null) {
            consumedResource = this.removeServerDefinition(serverDef);
        }
        return consumedResource != null;
    }

    public final ConsumedResourceInterface removeServerDefinition(ServerDef serverDef) {
        ConsumedResourceInterface consumedResource = null;
        if (serverDef != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                consumedResource = this.removeResource(serverDef.getResourceID(), removedConsumedResources);
            }
            catch (ServiceException e) {
                consumedResource = null;
            }
        }
        return consumedResource;
    }

    private final FactoryType removeFactoryTypeAndActions(FactoryType factoryType, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        FactoryType removedObject = null;
        if (factoryType != null) {
            Iterator iterFactoryAction = factoryType.getFactoryActionSet().iterator();
            while (iterFactoryAction.hasNext()) {
                this.removeResource(((FactoryAction)iterFactoryAction.next()).getResourceID(), removedConsumedResources);
            }
            removedObject = this._factoryTypeMap.remove(factoryType.getResourceID());
            removedConsumedResources.add(factoryType);
        }
        return removedObject;
    }

    private final FactoryAction removeFactoryActionForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        FactoryAction removedFactoryAction = null;
        if (resourceID != null) {
            FactoryType nextFactoryType2 = null;
            FactoryAction nextFactoryAction = null;
            block0: for (FactoryType nextFactoryType2 : this._factoryTypeMap.values()) {
                Iterator iterActions = nextFactoryType2.getFactoryActions().values().iterator();
                while (iterActions.hasNext()) {
                    nextFactoryAction = (FactoryAction)iterActions.next();
                    if (!resourceID.equals(nextFactoryAction.getResourceID())) continue;
                    iterActions.remove();
                    removedFactoryAction = nextFactoryAction;
                    removedConsumedResources.add(nextFactoryAction);
                    continue block0;
                }
            }
            if (removedFactoryAction != null && nextFactoryType2.getFactoryActionSet().size() == 0) {
                this._factoryTypeMap.remove(nextFactoryType2.getResourceID());
            }
        }
        return removedFactoryAction;
    }

    private final SmartDef.ActionDef removeSmartActionForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        SmartDef.ActionDef removedActionDef = null;
        if (resourceID != null) {
            Map<String, SmartDef> smartDefMap = this.smartDefs;
            SmartDef nextSmartDef = null;
            SmartDef.ActionDef nextSmartAction = null;
            List smartDefActions = null;
            Map.Entry<String, SmartDef> mapEntry = null;
            Iterator<Map.Entry<String, SmartDef>> iter = smartDefMap.entrySet().iterator();
            while (removedActionDef == null && iter.hasNext()) {
                mapEntry = iter.next();
                nextSmartDef = mapEntry.getValue();
                Map.Entry actionsMapEntry = null;
                Iterator iterActionList = nextSmartDef.getActions().entrySet().iterator();
                block1: while (removedActionDef == null && iterActionList.hasNext()) {
                    actionsMapEntry = iterActionList.next();
                    smartDefActions = (List)actionsMapEntry.getValue();
                    Iterator iterActions = smartDefActions.iterator();
                    while (iterActions.hasNext()) {
                        nextSmartAction = (SmartDef.ActionDef)iterActions.next();
                        if (!resourceID.equals(nextSmartAction.getResourceID())) continue;
                        removedActionDef = nextSmartAction;
                        iterActions.remove();
                        removedConsumedResources.add(nextSmartAction);
                        if (smartDefActions.size() != 0) continue block1;
                        iterActionList.remove();
                        if (nextSmartDef.getActions().size() != 0) continue block1;
                        iter.remove();
                        removedConsumedResources.add(nextSmartDef);
                        continue block1;
                    }
                }
            }
        }
        return removedActionDef;
    }

    private final RepositoryProtocol removeRepositoryForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        RepositoryProtocol removedObject = null;
        if (resourceID != null) {
            String protocol = null;
            RepositoryProtocol nextObject = null;
            Iterator<RepositoryProtocol> iter = this._repositoryProtocolMap.values().iterator();
            while (iter.hasNext()) {
                nextObject = iter.next();
                if (!resourceID.equals(nextObject.getResourceID())) continue;
                protocol = nextObject.getProtocol();
                this.removeReposDefsForProtocol(protocol, removedConsumedResources);
                this.removeFactoryTypesForProtocol(protocol, removedConsumedResources);
                this.removeSmartActions(protocol, removedConsumedResources);
                iter.remove();
                removedObject = nextObject;
                break;
            }
        }
        return removedObject;
    }

    private final RepositoryDef removeRepositoryDefForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        RepositoryDef removedObject = null;
        if (resourceID != null) {
            RepositoryDef nextObject = null;
            Iterator<RepositoryDef> iter = this.reposDefs.values().iterator();
            while (iter.hasNext()) {
                nextObject = iter.next();
                if (!resourceID.equals(nextObject.getResourceID())) continue;
                iter.remove();
                removedObject = nextObject;
                removedConsumedResources.add(nextObject);
                String repositoryDefName = nextObject.getName();
                RepositoryGroup repositoryGroup2 = null;
                for (RepositoryGroup repositoryGroup2 : this.getRepositoryGroupsForRepositoryDef(nextObject)) {
                    repositoryGroup2.removeRepository(repositoryDefName);
                    if (repositoryGroup2.getGroupNames().size() != 0) continue;
                    this.removeResource(repositoryGroup2.getResourceID(), removedConsumedResources);
                }
            }
        }
        return removedObject;
    }

    private Set<RepositoryGroup> getRepositoryGroupsForRepositoryDef(RepositoryDef repositoryDef) {
        HashSet<RepositoryGroup> reposGroups = new HashSet<RepositoryGroup>(this.repositoryGroups.size());
        if (repositoryDef != null) {
            String repositoryDefName = repositoryDef.getName();
            for (RepositoryGroup repositoryGroup : new HashSet<RepositoryGroup>(this.repositoryGroups.values())) {
                if (!repositoryGroup.getGroupNames().contains(repositoryDefName)) continue;
                reposGroups.add(repositoryGroup);
            }
        }
        return reposGroups;
    }

    private final RepositoryGroup removeRepositoryGroupForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        RepositoryGroup removedObject = null;
        if (resourceID != null) {
            RepositoryGroup nextGroup = null;
            Iterator<RepositoryGroup> iter = this.repositoryGroups.values().iterator();
            while (iter.hasNext()) {
                nextGroup = iter.next();
                if (!resourceID.equals(nextGroup.getResourceID())) continue;
                iter.remove();
                removedObject = nextGroup;
                removedConsumedResources.add(nextGroup);
                break;
            }
        }
        return removedObject;
    }

    private final ServerDef removeServerDefForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) {
        ServerDef removedObject = null;
        if (resourceID != null) {
            ServerDef nextServerDef = null;
            Iterator<ServerDef> iter = this.serverDefs.values().iterator();
            while (iter.hasNext()) {
                nextServerDef = iter.next();
                if (!resourceID.equals(nextServerDef.getResourceID())) continue;
                iter.remove();
                removedObject = nextServerDef;
                removedConsumedResources.add(nextServerDef);
                break;
            }
        }
        return removedObject;
    }

    public final RepositoryDef getReposDef(String name) {
        RepositoryDef repositoryDef = null;
        try {
            Set<Map.Entry<String, RepositoryDef>> repositoryDefSet = this.reposDefs.entrySet();
            for (Map.Entry<String, RepositoryDef> nextEntry : repositoryDefSet) {
                String nextKey = nextEntry.getKey();
                RepositoryDef nextValue = nextEntry.getValue();
                if (!nextKey.equalsIgnoreCase(name)) continue;
                repositoryDef = nextValue;
            }
        }
        catch (ClassCastException e) {
            repositoryDef = null;
        }
        return repositoryDef;
    }

    public final RepositoryDef getReposDefUsingID(String uid) {
        RepositoryDef repositoryDef = null;
        if (uid != null) {
            for (RepositoryDef aRepositoryDef : this.reposDefs.values()) {
                if (!uid.equals(aRepositoryDef.getResourceID())) continue;
                repositoryDef = aRepositoryDef;
                break;
            }
        }
        return repositoryDef;
    }

    public final RepositoryGroup getRepositoryGroupUsingID(String id) {
        RepositoryGroup repositoryGroup = null;
        if (id != null) {
            for (RepositoryGroup nextRepositoryGroup : this.repositoryGroups.values()) {
                if (!id.equals(nextRepositoryGroup.getResourceID())) continue;
                repositoryGroup = nextRepositoryGroup;
                break;
            }
        }
        return repositoryGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean addReposDef(String name, RepositoryDef def) throws ServiceConfigurationException {
        boolean wasAdded = false;
        try {
            RepositoryDef repositoryDef = this.reposDefs.get(name);
            if (repositoryDef != null) {
                if (!repositoryDef.equals(def)) throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictReposDef.ex.fmt.txt", (Object)name, (Object)repositoryDef.toString(), (Object)def.toString()));
                return true;
            }
            this.reposDefs.put(name, def);
            this.addResource(def);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public final boolean replaceReposDef(String oldRepositoryDefName, RepositoryDef newRepositoryDef) {
        RepositoryDef removedRepositoryDef = this.reposDefs.remove(oldRepositoryDefName);
        if (removedRepositoryDef != null) {
            this.getConsumerUsage().removeResource(removedRepositoryDef.getResourceID());
        }
        String newRepositoryDefName = newRepositoryDef.getName();
        try {
            this.addReposDef(newRepositoryDefName, newRepositoryDef);
        }
        catch (ServiceConfigurationException e) {
            LogManager.getLogger(InformationServiceInitObject.class).error(e.getLocalizedMessage());
        }
        for (RepositoryGroup repositoryGroup : this.repositoryGroups.values()) {
            if (!repositoryGroup.getGroupNames().contains(oldRepositoryDefName)) continue;
            repositoryGroup.removeRepository(oldRepositoryDefName);
            repositoryGroup.addRepository(newRepositoryDefName);
        }
        return removedRepositoryDef != null;
    }

    public final boolean removeReposDef(String repositoryDefName) {
        RepositoryDef repositoryDef;
        boolean wasRemoved = false;
        if (repositoryDefName != null && (repositoryDef = this.reposDefs.get(repositoryDefName)) != null) {
            wasRemoved = this.removeRepositoryDef(repositoryDef);
        }
        return wasRemoved;
    }

    public final boolean removeRepositoryDef(RepositoryDef repositoryDef) {
        ConsumedResourceInterface consumedResource = null;
        if (repositoryDef != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                consumedResource = this.removeResource(repositoryDef.getResourceID(), removedConsumedResources);
            }
            catch (ServiceException e) {
                consumedResource = null;
            }
        }
        return consumedResource != null;
    }

    private final Set<ConsumedResourceInterface> removeReposDefsForProtocol(String protocol, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        for (RepositoryDef repositoryDef : new HashSet<RepositoryDef>(this.reposDefs.values())) {
            if (!protocol.equals(repositoryDef.getProtocol())) continue;
            this.removeResource(repositoryDef.getResourceID(), removedConsumedResources);
        }
        return removedConsumedResources;
    }

    public final boolean addRepositoryGroup(RepositoryGroup group) {
        if (group == null) {
            throw new IllegalArgumentException();
        }
        String name = group.getName();
        RepositoryGroup repositoryGroup = this.repositoryGroups.get(name);
        if (repositoryGroup != null) {
            return false;
        }
        this.repositoryGroups.put(name, group);
        this.addResource(group);
        return true;
    }

    public final boolean removeRepositoryGroup(String groupName) {
        RepositoryGroup repositoryGroup = this.repositoryGroups.get(groupName);
        HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
        ConsumedResourceInterface consumedResource = null;
        if (repositoryGroup != null) {
            try {
                consumedResource = this.removeResource(repositoryGroup.getResourceID(), removedConsumedResources);
            }
            catch (ServiceException e) {
                consumedResource = null;
            }
        }
        return consumedResource != null;
    }

    public final void addFactory(String protocol, String type, String action) throws ServiceConfigurationException, IllegalArgumentException {
        this.addFactory(protocol, type, action, null);
    }

    public final void addFactory(String protocol, String type, String action, String filter) throws ServiceConfigurationException, IllegalArgumentException {
        this.addFactory(protocol, type, new FactoryAction(action, filter));
    }

    final void addFactory(String protocolTypeKey, FactoryAction factoryAction) throws ServiceConfigurationException, IllegalArgumentException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(protocolTypeKey, TOKEN_SEPARATOR);
            String protocol = tokenizer.nextToken();
            String type = tokenizer.nextToken();
            this.addFactory(protocol, type, factoryAction);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    final void addFactory(String protocolTypeKey, List factoryActions) throws ServiceConfigurationException, IllegalArgumentException {
        FactoryAction[] factoryActionArray = new FactoryAction[factoryActions.size()];
        factoryActionArray = factoryActions.toArray(factoryActionArray);
        this.addFactories(protocolTypeKey, factoryActionArray);
    }

    public final void addFactories(String protocolTypeKey, FactoryAction[] factoryActions) throws ServiceConfigurationException, IllegalArgumentException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(protocolTypeKey, TOKEN_SEPARATOR);
            String protocol = tokenizer.nextToken();
            String type = tokenizer.nextToken();
            int numActions = factoryActions.length;
            for (int i = 0; i < numActions; ++i) {
                this.addFactory(protocol, type, factoryActions[i]);
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    public Collection<FactoryType> getFactoryTypes() {
        return this._factoryTypeMap.values();
    }

    public FactoryAction getFactoryActionUsingID(String id) {
        FactoryAction factoryAction = null;
        if (id != null) {
            for (FactoryType factoryType : this._factoryTypeMap.values()) {
                FactoryAction nextFactoryAction = factoryType.getFactoryActionUsingID(id);
                if (nextFactoryAction == null) continue;
                factoryAction = nextFactoryAction;
                break;
            }
        }
        return factoryAction;
    }

    public FactoryType getFactoryTypeUsingID(String id) {
        FactoryType factoryType = null;
        if (id != null) {
            factoryType = this._factoryTypeMap.get(id);
        }
        return factoryType;
    }

    public Set<FactoryType> getFactoryTypesForProtocol(String protocol) {
        HashSet<FactoryType> factoryTypes = new HashSet<FactoryType>(this._factoryTypeMap.size());
        if (protocol != null) {
            for (FactoryType factoryType : this._factoryTypeMap.values()) {
                if (!protocol.equalsIgnoreCase(factoryType.getProtocol())) continue;
                factoryTypes.add(factoryType);
            }
        }
        return factoryTypes;
    }

    public Set getFactoryActionsForType(String type) {
        HashSet factoryActions = new HashSet(5);
        if (type != null) {
            for (FactoryType factoryType : this._factoryTypeMap.values()) {
                if (!type.equals(factoryType.getType())) continue;
                factoryActions.addAll(factoryType.getFactoryActionSet());
            }
        }
        return factoryActions;
    }

    public Set getFactoryActionsForProtocol(String protocol) {
        HashSet factoryActions = new HashSet(5);
        if (protocol != null) {
            for (FactoryType factoryType : this._factoryTypeMap.values()) {
                if (!protocol.equals(factoryType.getProtocol())) continue;
                factoryActions.addAll(factoryType.getFactoryActionSet());
            }
        }
        return factoryActions;
    }

    public Set getSmartActionsForProtocol(String protocol) {
        HashSet smartActions = new HashSet(5);
        if (protocol != null) {
            for (SmartDef smartDef : this.smartDefs.values()) {
                smartActions.addAll(smartDef.getActionsForProtocol(protocol));
            }
        }
        return smartActions;
    }

    public Set<SmartDef> getSmartDefsForProtocol(String protocol) {
        HashSet<SmartDef> smartObjects = new HashSet<SmartDef>(5);
        if (protocol != null) {
            for (SmartDef smartDef : this.smartDefs.values()) {
                if (smartDef.getActionsForProtocol(protocol).size() <= 0) continue;
                smartObjects.add(smartDef);
            }
        }
        return smartObjects;
    }

    public Set<FactoryType> getFactoryTypesForProtocolAndTypes(String protocol, Set<String> types) {
        Collection<FactoryType> allFactoryTypes = this._factoryTypeMap.values();
        HashSet<FactoryType> factoryTypes = new HashSet<FactoryType>(allFactoryTypes.size());
        if (protocol != null) {
            for (FactoryType factoryType : allFactoryTypes) {
                if (!protocol.equals(factoryType.getProtocol()) || !types.contains(factoryType.getType())) continue;
                factoryTypes.add(factoryType);
            }
        }
        return factoryTypes;
    }

    public FactoryType getFactoryType(String protocol, String type) {
        FactoryType factoryType = null;
        for (FactoryType nextFactoryType : this._factoryTypeMap.values()) {
            if (!protocol.equals(nextFactoryType.getProtocol()) || !type.equals(nextFactoryType.getType())) continue;
            factoryType = nextFactoryType;
            break;
        }
        return factoryType;
    }

    public void addFactoryType(FactoryType factoryType) {
        if (factoryType != null) {
            Iterator iter = factoryType.getFactoryActionSet().iterator();
            while (iter.hasNext()) {
                this.addResource(new FactoryActionConsumedResourceAdapter(factoryType, (FactoryAction)iter.next()));
            }
            this._factoryTypeMap.put(factoryType.getResourceID(), factoryType);
        }
    }

    public void removeFactoryType(FactoryType factoryType) {
        if (factoryType != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                this.removeFactoryTypeAndActions(factoryType, removedConsumedResources);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    public void addFactoryAction(FactoryType factoryType, FactoryAction factoryAction) {
        if (factoryType != null && factoryAction != null) {
            FactoryAction theFactoryAction = factoryType.getFactoryAction(factoryAction);
            if (theFactoryAction == null) {
                factoryType.addFactoryAction(factoryAction);
                this.addResource(new FactoryActionConsumedResourceAdapter(factoryType, factoryAction));
            } else {
                theFactoryAction.setAction(factoryAction.getActionType(), factoryAction.getActionClassName(), factoryAction.getActionMethodName(), factoryAction.getFilter());
            }
            if (null == this.getFactoryType(factoryType.getProtocol(), factoryType.getType())) {
                this.addFactoryType(factoryType);
            }
        }
    }

    public void renameRepositoryProtocol(RepositoryProtocol repositoryProtocol, String newProtocol) {
        if (repositoryProtocol != null) {
            String origProtocol = repositoryProtocol.getProtocol();
            repositoryProtocol.setProtocol(newProtocol);
            for (FactoryType factoryType : this.getFactoryTypesForProtocol(origProtocol)) {
                factoryType.setProtocol(newProtocol);
            }
        }
    }

    public void removeFactoryAction(FactoryAction factoryAction) {
        if (factoryAction != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                this.removeResource(factoryAction.getResourceID(), removedConsumedResources);
            }
            catch (ServiceException e) {
                LogManager.getLogger(InformationServiceInitObject.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.removeFactoryAction.ex.fmt.txt", (Object)factoryAction.getAction()), (Throwable)((Object)e));
            }
        }
    }

    public final void addFactory(String factoryProtocol, String type, FactoryAction factoryAction) throws ServiceConfigurationException, IllegalArgumentException {
        if (factoryAction == null) {
            throw new IllegalArgumentException(RB.getStringResource("InformationServiceInitObject.specifyFactoryAction.ex.txt"));
        }
        String factoryType = type != null ? type.toLowerCase() : "";
        String protocol = factoryProtocol.toLowerCase();
        FactoryType theFactoryType = this.getFactoryType(protocol, factoryType);
        if (theFactoryType == null) {
            theFactoryType = new FactoryType(protocol, factoryType);
            this.addFactoryType(theFactoryType);
        }
        this.addFactoryAction(theFactoryType, factoryAction);
    }

    public final boolean removeFactoryAndActions(String protocol, String type) {
        boolean isOK = false;
        FactoryType factoryType = this.getFactoryType(protocol, type);
        if (factoryType != null) {
            this.removeFactoryType(factoryType);
            isOK = true;
        }
        return isOK;
    }

    public void changeSmartDefType(SmartDef smartDef, String origSmartDefType) {
        if (smartDef != null) {
            String smartDefType = smartDef.getSmartType();
            if (origSmartDefType != null && !origSmartDefType.equals(smartDefType)) {
                this.smartDefs.remove(origSmartDefType);
                this.smartDefs.put(smartDefType, smartDef);
            }
        }
    }

    public boolean addSmartDef(SmartDef smartDef) {
        boolean wasAdded = false;
        SmartDef currentSmartDef = this.smartDefs.get(smartDef.getSmartType());
        if (currentSmartDef != null) {
            if (currentSmartDef.equals(smartDef)) {
                wasAdded = true;
            }
        } else {
            this.smartDefs.put(smartDef.getSmartType(), smartDef);
            ArrayList actionDefs = null;
            Iterator iter = new HashSet(smartDef.getActions().values()).iterator();
            while (iter.hasNext()) {
                actionDefs = new ArrayList((List)iter.next());
                Iterator iterDefs = actionDefs.iterator();
                while (iterDefs.hasNext()) {
                    this.addSmartDefAction(smartDef, (SmartDef.ActionDef)iterDefs.next());
                }
            }
            wasAdded = true;
        }
        return wasAdded;
    }

    public boolean removeSmartDef(SmartDef smartDef) {
        boolean wasRemoved = false;
        HashSet<SmartDef.ActionDef> removedSmartActions = new HashSet<SmartDef.ActionDef>(5);
        HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
        if (smartDef != null) {
            try {
                SmartDef.ActionDef smartAction2 = null;
                Iterator iter = new HashSet(smartDef.getActions().values()).iterator();
                while (iter.hasNext()) {
                    for (SmartDef.ActionDef smartAction2 : new HashSet((List)iter.next())) {
                        if (this.removeResource(smartAction2.getResourceID(), removedConsumedResources) == null) continue;
                        removedSmartActions.add(smartAction2);
                    }
                }
                wasRemoved = removedSmartActions.size() > 0;
            }
            catch (ServiceException e) {
                LogManager.getLogger(InformationServiceInitObject.class).warn(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.removeSmartDef.ex.fmt.txt", (Object)smartDef.getID()), (Throwable)((Object)e));
                wasRemoved = false;
            }
        }
        return wasRemoved;
    }

    public boolean removeSmartDef(String type) {
        SmartDef smartDef;
        boolean wasRemoved = false;
        if (type != null && (smartDef = this.smartDefs.get(type)) != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                wasRemoved = this.removeResource(smartDef.getResourceID(), removedConsumedResources) != null;
            }
            catch (ServiceException e) {
                wasRemoved = false;
            }
        }
        return wasRemoved;
    }

    public boolean addSmartDefAction(SmartDef smartDef, SmartDef.ActionDef smartAction) {
        boolean wasAdded = false;
        if (smartDef != null && smartAction != null) {
            ConsumerUsage consumerUsage = this.getConsumerUsage();
            String smartActionID = smartAction.getResourceID();
            SmartDef.ActionDef smartAction1 = smartDef.getActionUsingID(smartActionID);
            if (smartAction1 == null) {
                wasAdded = smartDef.addAction(smartAction);
                if (wasAdded) {
                    this.addResource(new SmartDefActionConsumedResourceAdapter(smartDef, smartAction));
                }
            } else if (smartActionID.equals(smartAction1.getResourceID())) {
                smartAction1.setAction(smartAction.getAction());
                smartAction1.setType(smartAction.getType());
                smartAction1.setProtocol(smartAction.getProtocol());
                if (consumerUsage.getResourceUsingUID(smartAction1.getResourceID()) == null) {
                    this.addResource(new SmartDefActionConsumedResourceAdapter(smartDef, smartAction1));
                }
                wasAdded = true;
            } else {
                wasAdded = smartAction1.equals(smartAction);
                if (wasAdded && consumerUsage.getResourceUsingUID(smartAction1.getResourceID()) == null) {
                    this.addResource(new SmartDefActionConsumedResourceAdapter(smartDef, smartAction1));
                }
            }
        }
        return wasAdded;
    }

    public Set<ConsumedResourceInterface> removeSmartDefAction(SmartDef.ActionDef smartAction) {
        HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
        if (smartAction != null) {
            try {
                this.removeResource(smartAction.getResourceID(), removedConsumedResources);
            }
            catch (ServiceException e) {
                LogManager.getLogger(InformationServiceInitObject.class).warn(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.removeSmartDefAction.ex.fmt.txt", (Object)smartAction.getAction().toString()), (Throwable)((Object)e));
            }
        }
        return removedConsumedResources;
    }

    public SmartDef getSmartDefUsingID(String id) {
        SmartDef smartDef = null;
        if (id != null) {
            for (SmartDef nextSmartDef : this.smartDefs.values()) {
                if (!id.equals(nextSmartDef.getResourceID())) continue;
                smartDef = nextSmartDef;
                break;
            }
        }
        return smartDef;
    }

    SmartDef getSmartDefUsingType(String smartType) {
        SmartDef smartDef = null;
        if (smartType != null) {
            smartDef = this.smartDefs.get(smartType);
        }
        return smartDef;
    }

    public SmartDef.ActionDef getSmartDefActionUsingID(String id) {
        SmartDef.ActionDef smartDefAction = null;
        if (id != null) {
            SmartDef.ActionDef nextSmartDefAction = null;
            for (SmartDef smartDef : this.smartDefs.values()) {
                nextSmartDefAction = smartDef.getActionUsingID(id);
                if (nextSmartDefAction == null) continue;
                smartDefAction = nextSmartDefAction;
                break;
            }
        }
        return smartDefAction;
    }

    @Override
    public DocumentFragment appendDOM(Document document) {
        return InformationServiceInitObject.appendDOM(document, this);
    }

    @Override
    protected final DocumentFragment appendDOM(Document document, AbstractServiceComponentConfig serviceConfig) throws ServiceConfigurationException, IllegalArgumentException {
        DocumentFragment documentFragment = null;
        try {
            documentFragment = InformationServiceInitObject.appendDOM(document, (InformationServiceInitObject)serviceConfig);
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, e.getLocalizedMessage());
        }
        return documentFragment;
    }

    public static final DocumentFragment appendDOM(Document document, InformationServiceInitObject serviceConfig) {
        DocumentFragment documentFragment = null;
        Element elementInfoService = document.getDocumentElement();
        try {
            Set<Map.Entry<String, RepositoryGroup>> entries;
            documentFragment = document.createDocumentFragment();
            Set<RepositoryProtocol> repositoryProtocolSet = serviceConfig.getRepositoryProtocols();
            if (repositoryProtocolSet.size() > 0) {
                Element elementRepository = null;
                for (RepositoryProtocol repositoryProtocol : repositoryProtocolSet) {
                    elementRepository = repositoryProtocol.createXMLElement(document);
                    if (elementRepository == null) continue;
                    documentFragment.appendChild(elementRepository);
                }
            }
            if (serviceConfig.serverDefs.size() > 0) {
                entries = serviceConfig.serverDefs.entrySet();
                for (Map.Entry<String, ServerDef> entry : entries) {
                    Map optionMap;
                    ServerDef serverDef = entry.getValue();
                    Element elementDef = document.createElement("ServerDef");
                    documentFragment.appendChild(elementDef);
                    elementDef.setAttribute("name", serverDef.getName());
                    elementDef.setAttribute("uid", serverDef.getResourceID());
                    if (serverDef.getDescription() != null) {
                        elementDef.setAttribute("description", serverDef.getDescription().trim());
                    }
                    elementDef.setAttribute("protocol", serverDef.getProtocol());
                    elementDef.setAttribute("host", serverDef.getHost());
                    elementDef.setAttribute("port", serverDef.getPort());
                    elementDef.setAttribute("domain", serverDef.getDomain());
                    elementDef.setAttribute("auto", Boolean.toString(serverDef.getAuto()));
                    elementDef.setAttribute("issecure", Boolean.toString(serverDef.getIsSecure()));
                    String proxy = serverDef.getProxy();
                    if (proxy == null) {
                        proxy = "";
                    }
                    elementDef.setAttribute("proxy", proxy);
                    List baseList = serverDef.getBaseLocations();
                    if (baseList.size() > 0) {
                        for (String nextBase : baseList) {
                            Element baseElement = document.createElement(ELEMENT_BASE);
                            baseElement.setAttribute(BASE_PATH, nextBase);
                            elementDef.appendChild(baseElement);
                        }
                    }
                    if ((optionMap = serverDef.getAdvancedOptions()).size() <= 0) continue;
                    for (Map.Entry nextEntry : optionMap.entrySet()) {
                        Element optionElement = document.createElement(ELEMENT_OPTION);
                        optionElement.setAttribute(OPTION_NAME, (String)nextEntry.getKey());
                        optionElement.setAttribute(OPTION_VALUE, (String)nextEntry.getValue());
                        elementDef.appendChild(optionElement);
                    }
                }
            }
            if (serviceConfig.reposDefs.size() > 0) {
                for (Map.Entry entry : serviceConfig.reposDefs.entrySet()) {
                    List hibList;
                    RepositoryDef repositoryDef = (RepositoryDef)entry.getValue();
                    Element elementDef = document.createElement("ReposDef");
                    documentFragment.appendChild(elementDef);
                    elementDef.setAttribute("name", repositoryDef.getName());
                    elementDef.setAttribute("uid", repositoryDef.getResourceID());
                    if (repositoryDef.getDescription() != null) {
                        elementDef.setAttribute("description", repositoryDef.getDescription().trim());
                    }
                    elementDef.setAttribute("protocol", repositoryDef.getProtocol());
                    elementDef.setAttribute("host", repositoryDef.getHost());
                    elementDef.setAttribute("port", repositoryDef.getPort());
                    elementDef.setAttribute("base", repositoryDef.getBase());
                    elementDef.setAttribute("domain", repositoryDef.getDomain());
                    elementDef.setAttribute("auto", Boolean.toString(repositoryDef.getAuto()));
                    elementDef.setAttribute("issecure", Boolean.toString(repositoryDef.getIsSecure()));
                    elementDef.setAttribute("hibdialect", repositoryDef.getHibDialect());
                    String proxy = repositoryDef.getProxy();
                    if (proxy == null) {
                        proxy = "";
                    }
                    elementDef.setAttribute("proxy", proxy);
                    Map optionMap = repositoryDef.getAdvancedOptions();
                    if (optionMap.size() > 0) {
                        for (Map.Entry nextEntry : optionMap.entrySet()) {
                            Element optionElement = document.createElement(ELEMENT_OPTION);
                            optionElement.setAttribute(OPTION_NAME, (String)nextEntry.getKey());
                            optionElement.setAttribute(OPTION_VALUE, (String)nextEntry.getValue());
                            elementDef.appendChild(optionElement);
                        }
                    }
                    if ((hibList = repositoryDef.getHibClasses()).size() <= 0) continue;
                    for (String nextClass : hibList) {
                        Element classElement = document.createElement(ELEMENT_HIBCLASS);
                        classElement.setAttribute(OPTION_NAME, nextClass);
                        elementDef.appendChild(classElement);
                    }
                }
            }
            if (serviceConfig.repositoryGroups.size() > 0) {
                entries = serviceConfig.repositoryGroups.entrySet();
                for (Map.Entry<String, RepositoryGroup> entry : entries) {
                    RepositoryGroup group = entry.getValue();
                    List<String> groupNames = group.getGroupNames();
                    if (groupNames.size() <= 0) continue;
                    Element elementDef = document.createElement("GroupDef");
                    documentFragment.appendChild(elementDef);
                    elementDef.setAttribute("name", group.getName());
                    elementDef.setAttribute("uid", group.getResourceID());
                    if (group.getDescription() != null) {
                        elementDef.setAttribute("description", group.getDescription());
                    }
                    Iterator<String> memberIt = groupNames.iterator();
                    while (memberIt.hasNext()) {
                        Element memberdef = document.createElement("Member");
                        elementDef.appendChild(memberdef);
                        memberdef.setAttribute("name", memberIt.next());
                    }
                }
            }
            if (serviceConfig.smartDefs.size() > 0 || serviceConfig._factoryTypeMap.size() > 0) {
                Element elementFactory = document.createElement(XML_ELEMENT_FACTORY);
                documentFragment.appendChild(elementFactory);
                if (serviceConfig.smartDefs.size() > 0) {
                    Collection<SmartDef> collection = serviceConfig.smartDefs.values();
                    Iterator<SmartDef> iterator = collection.iterator();
                    SmartDef nextSmart = null;
                    Element smartGuy = null;
                    while (iterator.hasNext()) {
                        nextSmart = iterator.next();
                        smartGuy = document.createElement("SmartObject");
                        elementFactory.appendChild(smartGuy);
                        smartGuy.setAttribute("smartType", nextSmart.getSmartType());
                        smartGuy.setAttribute("interface", nextSmart.getInterfaceClass());
                        smartGuy.setAttribute("uid", nextSmart.getResourceID());
                        Map actionMap = nextSmart.getActions();
                        Collection actionCollection = actionMap.values();
                        Iterator actionIter = actionCollection.iterator();
                        SmartDef.ActionDef actionDef22 = null;
                        while (actionIter.hasNext()) {
                            Object o = actionIter.next();
                            if (o instanceof SmartDef.ActionDef) {
                                actionDef22 = (SmartDef.ActionDef)o;
                                smartGuy.appendChild(actionDef22.createElement(document));
                                continue;
                            }
                            List list = (List)o;
                            for (SmartDef.ActionDef actionDef22 : list) {
                                smartGuy.appendChild(actionDef22.createElement(document));
                            }
                        }
                        String filterClass = nextSmart.getFilterClass();
                        if (filterClass == null) continue;
                        smartGuy.appendChild(SmartDef.createElementFilter(document, filterClass));
                    }
                }
                if (serviceConfig._factoryTypeMap.size() > 0) {
                    for (FactoryType factoryType : serviceConfig._factoryTypeMap.values()) {
                        Iterator iterFactionAction = factoryType.getFactoryActionSet().iterator();
                        while (iterFactionAction.hasNext()) {
                            elementFactory.appendChild(FactoryAction.createXMLElementFactory(document, factoryType.getProtocol(), factoryType.getType(), (FactoryAction)iterFactionAction.next()));
                        }
                    }
                }
            }
            if (documentFragment.hasChildNodes()) {
                elementInfoService.appendChild(documentFragment);
            }
            return documentFragment;
        }
        catch (DOMException ex) {
            LogManager.getLogger(InformationServiceInitObject.class).error(RB.getStringResource("InformationServiceInitObject.createXML.ex.txt"), (Throwable)ex);
            return null;
        }
    }

    public final void removeProtocol(String protocol) throws ServiceException {
        RepositoryProtocol repositoryProtocol;
        if (protocol != null && (repositoryProtocol = this.getRepositoryProtocol(protocol)) != null) {
            HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
            this.removeResource(repositoryProtocol.getResourceID(), removedConsumedResources);
        }
    }

    private final Set<ConsumedResourceInterface> removeSmartActions(String protocol, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        HashSet<ConsumedResourceInterface> removedItems = new HashSet<ConsumedResourceInterface>(5);
        if (protocol != null) {
            ConsumedResourceInterface consumedResource = null;
            SmartDef.ActionDef smartDefAction2 = null;
            for (SmartDef smartDef : new HashSet<SmartDef>(this.smartDefs.values())) {
                for (SmartDef.ActionDef smartDefAction2 : smartDef.getActionsForProtocol(protocol)) {
                    consumedResource = this.removeResource(smartDefAction2.getResourceID(), removedConsumedResources);
                    if (consumedResource == null) continue;
                    removedItems.add(consumedResource);
                }
            }
        }
        return removedItems;
    }

    private Set<ConsumedResourceInterface> removeSmartObjectForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        HashSet<ConsumedResourceInterface> removedItems = new HashSet<ConsumedResourceInterface>(5);
        if (resourceID != null) {
            ConsumedResourceInterface consumedResource = null;
            SmartDef smartDef = null;
            SmartDef.ActionDef action2 = null;
            Iterator<SmartDef> iter = this.smartDefs.values().iterator();
            while (iter.hasNext()) {
                smartDef = iter.next();
                if (!resourceID.equals(smartDef.getResourceID())) continue;
                Iterator iterActionList = smartDef.getActions().values().iterator();
                while (iterActionList.hasNext()) {
                    for (SmartDef.ActionDef action2 : (List)((Object)iterActionList)) {
                        consumedResource = this.removeResource(action2.getResourceID(), removedConsumedResources);
                        if (consumedResource == null) continue;
                        removedItems.add(consumedResource);
                    }
                }
                iter.remove();
                removedItems.add(smartDef);
                break;
            }
        }
        return removedItems;
    }

    @Override
    protected final void validateServiceConfigurationCustom(Document serviceConfiguration) throws ServiceConfigurationException {
    }

    @Override
    protected final String getServiceFactoryClassName() {
        return InformationServiceFactory.class.getName();
    }

    @Override
    protected final void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig) throws ServiceConfigurationException, IllegalArgumentException {
        this.mergeConfiguration(currentConfig, newConfig, this.getDefaultMergePolicy());
    }

    @Override
    protected final void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        InformationServiceInitObject serviceConfig1 = null;
        InformationServiceInitObject serviceConfig2 = null;
        try {
            serviceConfig1 = (InformationServiceInitObject)currentConfig;
            serviceConfig2 = (InformationServiceInitObject)newConfig;
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.invalidConfig.ex.fmt.txt", (Object)InformationServiceInitObject.class.getName()));
        }
        InformationServiceInitObject.mergeConfiguration(serviceConfig1, serviceConfig2, mergePolicy);
    }

    private static final void mergeConfiguration(InformationServiceInitObject thisConfig, InformationServiceInitObject newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        if (mergePolicy == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> resourceIdMap = new HashMap<String, String>(newConfig.reposDefs.size() + newConfig.repositoryGroups.size() + newConfig.serverDefs.size() + newConfig.smartDefs.size() + newConfig.getFactoryTypes().size() + newConfig.getRepositoryProtocols().size());
        InformationServiceInitObject.mergeRepositoryProtocols(thisConfig, newConfig, mergePolicy, resourceIdMap);
        InformationServiceInitObject.mergeServerDefs(thisConfig, newConfig, mergePolicy, resourceIdMap);
        InformationServiceInitObject.mergeRepositoryDefs(thisConfig, newConfig, mergePolicy, resourceIdMap);
        InformationServiceInitObject.mergeSmartDefs(thisConfig, newConfig, mergePolicy, resourceIdMap);
        InformationServiceInitObject.mergeFactoryTypes(thisConfig, newConfig, mergePolicy, resourceIdMap);
        thisConfig.getConsumerUsage().merge(newConfig.getConsumerUsage(), resourceIdMap);
    }

    private static void mergeRepositoryDefs(InformationServiceInitObject thisConfig, InformationServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        try {
            if (newConfig.reposDefs.size() > 0) {
                String newResourceID = null;
                String thisResourceID = null;
                RepositoryDef newRepositoryDef = null;
                RepositoryDef thisRepositoryDef = null;
                Map.Entry<String, RepositoryDef> mapEntry2 = null;
                String alias = null;
                for (Map.Entry<String, RepositoryDef> mapEntry2 : newConfig.reposDefs.entrySet()) {
                    boolean isSame;
                    alias = mapEntry2.getKey();
                    newRepositoryDef = mapEntry2.getValue();
                    newResourceID = newRepositoryDef.getResourceID();
                    thisRepositoryDef = thisConfig.getReposDefUsingID(newResourceID);
                    boolean bl = isSame = thisRepositoryDef != null;
                    if (thisRepositoryDef == null) {
                        thisRepositoryDef = thisConfig.getReposDef(alias);
                    }
                    if (thisRepositoryDef == null) {
                        RepositoryDef repositoryDef = (RepositoryDef)newRepositoryDef.clone();
                        thisConfig.addReposDef(alias, repositoryDef);
                        thisResourceID = repositoryDef.getResourceID();
                    } else {
                        if (isSame) {
                            thisRepositoryDef.replace(newRepositoryDef);
                            thisResourceID = thisRepositoryDef.getResourceID();
                        } else if (!newRepositoryDef.hasConflict(thisRepositoryDef)) {
                            thisRepositoryDef.merge(newRepositoryDef);
                            thisResourceID = thisRepositoryDef.getResourceID();
                        } else if (mergePolicy.isOKToReplace()) {
                            thisRepositoryDef.replace(newRepositoryDef);
                            thisResourceID = thisRepositoryDef.getResourceID();
                        } else {
                            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictRepositoryDef.ex.fmt.txt", (Object)alias));
                        }
                        String oldAlias = thisConfig.getRepositoryDefAlias(thisRepositoryDef);
                        if (!Strings.equal((String)alias, (String)oldAlias, (boolean)false, (boolean)false)) {
                            newConfig.reposDefs.remove(oldAlias);
                            newConfig.reposDefs.put(alias, thisRepositoryDef);
                        }
                    }
                    resourceIdMap.put(newResourceID, thisResourceID);
                }
            }
            InformationServiceInitObject.mergeRepositoryGroups(thisConfig, newConfig, mergePolicy, resourceIdMap);
        }
        catch (CloneNotSupportedException e) {
            throw new ServiceConfigurationException(e);
        }
    }

    private static void mergeRepositoryGroups(InformationServiceInitObject thisConfig, InformationServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        Map<String, RepositoryGroup> newRepositoryGroups = newConfig.repositoryGroups;
        if (newRepositoryGroups.size() > 0) {
            try {
                String newResourceID = null;
                String thisResourceID = null;
                RepositoryGroup newRepositoryGroup = null;
                RepositoryGroup thisRepositoryGroup = null;
                for (Map.Entry<String, RepositoryGroup> mapEntry : newRepositoryGroups.entrySet()) {
                    boolean isSame;
                    String newAlias = mapEntry.getKey();
                    newRepositoryGroup = mapEntry.getValue();
                    newResourceID = newRepositoryGroup.getResourceID();
                    thisRepositoryGroup = thisConfig.getRepositoryGroupUsingID(newResourceID);
                    boolean bl = isSame = thisRepositoryGroup != null;
                    if (thisRepositoryGroup == null) {
                        thisRepositoryGroup = thisConfig.repositoryGroups.get(newAlias);
                    }
                    if (thisRepositoryGroup == null) {
                        RepositoryGroup repositoryGroup = (RepositoryGroup)newRepositoryGroup.clone();
                        for (String repositoryName : repositoryGroup.getGroupNames()) {
                            if (thisConfig.getReposDef(repositoryName) != null) continue;
                            repositoryGroup.removeRepository(repositoryName);
                        }
                        thisConfig.addRepositoryGroup(repositoryGroup);
                        thisResourceID = repositoryGroup.getResourceID();
                    } else {
                        String oldAlias = thisRepositoryGroup.getName();
                        if (isSame) {
                            thisRepositoryGroup.replace(newRepositoryGroup, thisConfig, mergePolicy);
                            thisResourceID = thisRepositoryGroup.getResourceID();
                        } else if (!newRepositoryGroup.hasConflict(thisRepositoryGroup)) {
                            thisRepositoryGroup.merge(newRepositoryGroup, thisConfig, mergePolicy);
                            thisResourceID = thisRepositoryGroup.getResourceID();
                        } else if (mergePolicy.isOKToReplace()) {
                            thisRepositoryGroup.replace(newRepositoryGroup, thisConfig, mergePolicy);
                            thisResourceID = thisRepositoryGroup.getResourceID();
                        } else {
                            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictRepositoryDef.ex.fmt.txt", (Object)oldAlias));
                        }
                        if (!Strings.equal((String)newAlias, (String)oldAlias, (boolean)false, (boolean)false)) {
                            newConfig.repositoryGroups.remove(oldAlias);
                            newConfig.repositoryGroups.put(newAlias, thisRepositoryGroup);
                        }
                    }
                    resourceIdMap.put(newResourceID, thisResourceID);
                }
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceConfigurationException(e);
            }
        }
    }

    private static void mergeRepositoryProtocols(InformationServiceInitObject thisConfig, InformationServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        Set<RepositoryProtocol> newRepositoryProtocols = newConfig.getRepositoryProtocols();
        if (newRepositoryProtocols.size() > 0) {
            try {
                String newResourceID = null;
                String thisResourceID = null;
                RepositoryProtocol newProtocol2 = null;
                RepositoryProtocol thisProtocol = null;
                for (RepositoryProtocol newProtocol2 : newRepositoryProtocols) {
                    boolean isSame;
                    newResourceID = newProtocol2.getResourceID();
                    thisProtocol = thisConfig.getRepositoryProtocolUsingID(newResourceID);
                    boolean bl = isSame = thisProtocol != null;
                    if (thisProtocol == null) {
                        thisProtocol = thisConfig.getRepositoryProtocol(newProtocol2.getProtocol());
                    }
                    if (thisProtocol == null) {
                        RepositoryProtocol repositoryProtocol = (RepositoryProtocol)newProtocol2.clone();
                        thisConfig.addRepository(repositoryProtocol, true);
                        thisResourceID = repositoryProtocol.getResourceID();
                    } else if (isSame || !newProtocol2.hasConflict(thisProtocol)) {
                        thisProtocol.merge(newProtocol2);
                        thisResourceID = thisProtocol.getResourceID();
                    } else if (mergePolicy.isOKToReplace()) {
                        thisProtocol.replace(newProtocol2);
                        thisResourceID = thisProtocol.getResourceID();
                    } else {
                        throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictRepository.ex.fmt.txt", (Object)thisProtocol.getProtocol(), thisProtocol.getClass(), newProtocol2.getClass()));
                    }
                    resourceIdMap.put(newResourceID, thisResourceID);
                }
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceConfigurationException(e);
            }
        }
    }

    private static void mergeServerDefs(InformationServiceInitObject thisConfig, InformationServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        Map<String, ServerDef> newServerDefs = newConfig.serverDefs;
        if (newServerDefs.size() > 0) {
            try {
                String newResourceID = null;
                String thisResourceID = null;
                ServerDef newServerDef = null;
                ServerDef thisServerDef = null;
                String newAlias = null;
                for (Map.Entry<String, ServerDef> mapEntry : newServerDefs.entrySet()) {
                    boolean isSame;
                    newAlias = mapEntry.getKey();
                    newServerDef = mapEntry.getValue();
                    newResourceID = newServerDef.getResourceID();
                    thisServerDef = thisConfig.getServerDefUsingID(newResourceID);
                    boolean bl = isSame = thisServerDef != null;
                    if (thisServerDef == null) {
                        thisServerDef = thisConfig.getServerDef(newAlias);
                    }
                    if (thisServerDef == null) {
                        ServerDef serverDef = (ServerDef)newServerDef.clone();
                        thisConfig.addServerDef(serverDef);
                        thisResourceID = serverDef.getResourceID();
                    } else {
                        String thisAlias = thisServerDef.getName();
                        if (isSame || !newServerDef.hasConflict(thisServerDef)) {
                            thisServerDef.merge(newServerDef);
                            thisResourceID = thisServerDef.getResourceID();
                        } else if (mergePolicy.isOKToReplace()) {
                            thisServerDef.replace(newServerDef);
                            thisResourceID = thisServerDef.getResourceID();
                        } else {
                            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictServerDef.ex.fmt.txt", (Object)thisAlias));
                        }
                        if (!Strings.equal((String)newAlias, (String)thisAlias, (boolean)false, (boolean)false)) {
                            newConfig.serverDefs.remove(thisAlias);
                            newConfig.serverDefs.put(newAlias, thisServerDef);
                        }
                    }
                    resourceIdMap.put(newResourceID, thisResourceID);
                }
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceConfigurationException(e);
            }
        }
    }

    private static void mergeFactoryTypes(InformationServiceInitObject thisConfig, InformationServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        Map<String, FactoryType> newFactoryTypes = newConfig._factoryTypeMap;
        if (newFactoryTypes.size() > 0) {
            try {
                String newResourceID = null;
                FactoryType newFactoryType = null;
                FactoryType thisFactoryType = null;
                String protocol = null;
                String type = null;
                for (Map.Entry<String, FactoryType> mapEntry : newFactoryTypes.entrySet()) {
                    newResourceID = mapEntry.getKey();
                    newFactoryType = mapEntry.getValue();
                    thisFactoryType = thisConfig.getFactoryTypeUsingID(newResourceID);
                    boolean isSame = thisFactoryType != null;
                    protocol = newFactoryType.getProtocol();
                    type = newFactoryType.getType();
                    if (thisFactoryType == null) {
                        thisFactoryType = thisConfig.getFactoryType(protocol, type);
                    }
                    if (thisFactoryType == null) {
                        FactoryType factoryTypeClone = (FactoryType)newFactoryType.clone();
                        thisConfig.addFactoryType(factoryTypeClone);
                        resourceIdMap.put(newFactoryType.getResourceID(), newFactoryType.getResourceID());
                        String factoryActionResourceID2 = null;
                        for (String factoryActionResourceID2 : factoryTypeClone.getFactoryActions().keySet()) {
                            resourceIdMap.put(factoryActionResourceID2, factoryActionResourceID2);
                        }
                        continue;
                    }
                    if (isSame || !thisFactoryType.hasConflict(newFactoryType)) {
                        thisFactoryType.merge(newFactoryType, thisConfig, mergePolicy, resourceIdMap);
                        continue;
                    }
                    if (mergePolicy.isOKToReplace()) {
                        thisFactoryType.replace(newFactoryType, thisConfig, mergePolicy, resourceIdMap);
                        continue;
                    }
                    throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictFactoryType.ex.fmt.txt", (Object)protocol, (Object)type));
                }
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceConfigurationException(e);
            }
        }
    }

    private static void mergeSmartDefs(InformationServiceInitObject thisConfig, InformationServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        Map<String, SmartDef> newSmartDefs = newConfig.smartDefs;
        if (newSmartDefs.size() > 0) {
            String newResourceID = null;
            SmartDef newSmartDef2 = null;
            SmartDef thisSmartDef = null;
            for (SmartDef newSmartDef2 : newSmartDefs.values()) {
                boolean isSame;
                newResourceID = newSmartDef2.getResourceID();
                thisSmartDef = thisConfig.getSmartDefUsingID(newResourceID);
                boolean bl = isSame = thisSmartDef != null;
                if (thisSmartDef == null) {
                    thisSmartDef = thisConfig.getSmartDefUsingType(newSmartDef2.getSmartType());
                }
                if (thisSmartDef == null) {
                    SmartDef smartDefClone = (SmartDef)newSmartDef2.clone();
                    thisConfig.addSmartDef(smartDefClone);
                    resourceIdMap.put(smartDefClone.getResourceID(), smartDefClone.getResourceID());
                    SmartDef.ActionDef smartActionDef2 = null;
                    Iterator iterActionList = smartDefClone.getActions().values().iterator();
                    while (iterActionList.hasNext()) {
                        for (SmartDef.ActionDef smartActionDef2 : (List)iterActionList.next()) {
                            resourceIdMap.put(smartActionDef2.getAction().getResourceID(), smartActionDef2.getAction().getResourceID());
                        }
                    }
                    continue;
                }
                if (isSame) {
                    thisSmartDef.replace(newSmartDef2, thisConfig, mergePolicy, resourceIdMap);
                    continue;
                }
                if (!newSmartDef2.hasConflict(thisSmartDef)) {
                    thisSmartDef.merge(newSmartDef2, thisConfig, mergePolicy, resourceIdMap);
                    continue;
                }
                if (mergePolicy.isOKToReplace()) {
                    thisSmartDef.replace(newSmartDef2, thisConfig, mergePolicy, resourceIdMap);
                    continue;
                }
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictSmartDef.ex.fmt.txt", (Object)thisSmartDef.getSmartType()));
            }
        }
    }

    private String getRepositoryDefAlias(RepositoryDef repositoryDef) {
        String alias = null;
        if (repositoryDef != null) {
            String resourceID = repositoryDef.getResourceID();
            Map.Entry<String, RepositoryDef> mapEntry2 = null;
            for (Map.Entry<String, RepositoryDef> mapEntry2 : this.reposDefs.entrySet()) {
                if (!Strings.equal((String)resourceID, (String)mapEntry2.getValue().getResourceID(), (boolean)false, (boolean)false)) continue;
                alias = mapEntry2.getKey();
                break;
            }
        }
        return alias;
    }

    @Override
    protected final AbstractServiceComponentConfig getConfig(Document serviceConfigDocument) throws ServiceConfigurationException, IllegalArgumentException {
        InformationServiceInitObject config = null;
        try {
            config = serviceConfigDocument != null ? InformationServiceInitializer.parse(serviceConfigDocument) : new InformationServiceInitObject();
        }
        catch (InitializationException e) {
            throw new ServiceConfigurationException((Throwable)((Object)e), e.getLocalizedMessage());
        }
        return config;
    }

    public InformationServiceInitObject cloneConfig() {
        InformationServiceInitObject clone = null;
        try {
            clone = (InformationServiceInitObject)this.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = null;
        }
        return clone;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        InformationServiceInitObject config = (InformationServiceInitObject)super.clone();
        config._repositoryProtocolMap = new HashMap<String, RepositoryProtocol>(this._repositoryProtocolMap.size());
        RepositoryProtocol repositoryProtocolClone = null;
        for (RepositoryProtocol repositoryProtocol : this._repositoryProtocolMap.values()) {
            repositoryProtocolClone = (RepositoryProtocol)repositoryProtocol.clone();
            config._repositoryProtocolMap.put(repositoryProtocolClone.getResourceID(), repositoryProtocolClone);
        }
        config._factoryTypeMap = new HashMap<String, FactoryType>(this._factoryTypeMap.size());
        for (FactoryType factoryType : this._factoryTypeMap.values()) {
            config.addFactoryType((FactoryType)factoryType.clone());
        }
        config.reposDefs = new HashMap<String, RepositoryDef>(this.reposDefs.size());
        RepositoryDef repositoryDef = null;
        for (Map.Entry<String, RepositoryDef> entry : this.reposDefs.entrySet()) {
            repositoryDef = entry.getValue();
            config.reposDefs.put(entry.getKey(), (RepositoryDef)repositoryDef.clone());
        }
        config.serverDefs = new HashMap<String, ServerDef>(this.serverDefs.size());
        Object var4_8 = null;
        for (Map.Entry<String, ServerDef> entry : this.serverDefs.entrySet()) {
            ServerDef serverDef = entry.getValue();
            config.serverDefs.put(entry.getKey(), (ServerDef)serverDef.clone());
        }
        config.smartDefs = new HashMap<String, SmartDef>(this.smartDefs.size());
        Object var5_13 = null;
        for (Map.Entry<String, SmartDef> entry : this.smartDefs.entrySet()) {
            SmartDef smartDef = entry.getValue();
            config.smartDefs.put(entry.getKey(), (SmartDef)smartDef.clone());
        }
        config.repositoryGroups = new HashMap<String, RepositoryGroup>(this.repositoryGroups.size());
        Object var6_18 = null;
        for (Map.Entry<String, RepositoryGroup> mapEntry : this.repositoryGroups.entrySet()) {
            RepositoryGroup repositoryGroup = mapEntry.getValue();
            config.repositoryGroups.put(mapEntry.getKey(), (RepositoryGroup)repositoryGroup.clone());
        }
        return config;
    }

    @Override
    public ConsumedResourceInterface removeResource(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        ConsumedResourceInterface consumedResource = this.getConsumerUsage().getResourceUsingUID(resourceID);
        if (consumedResource != null) {
            switch (consumedResource.getResourceTypeCode()) {
                case 0: {
                    this.removeFactoryActionForID(resourceID, removedConsumedResources);
                    break;
                }
                case 2: {
                    this.removeRepositoryForID(resourceID, removedConsumedResources);
                    break;
                }
                case 3: {
                    this.removeRepositoryDefForID(resourceID, removedConsumedResources);
                    break;
                }
                case 4: {
                    this.removeRepositoryGroupForID(resourceID, removedConsumedResources);
                    break;
                }
                case 6: {
                    this.removeSmartActionForID(resourceID, removedConsumedResources);
                    break;
                }
                case 7: {
                    this.removeSmartObjectForID(resourceID, removedConsumedResources);
                    break;
                }
                case 5: {
                    this.removeServerDefForID(resourceID, removedConsumedResources);
                    break;
                }
            }
        }
        return super.removeResource(resourceID, removedConsumedResources);
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o != null && o.getClass() == this.getClass()) {
            InformationServiceInitObject isio = (InformationServiceInitObject)o;
            isEqual = InformationServiceInitObject.isEqual(new HashSet<RepositoryProtocol>(this._repositoryProtocolMap.values()), new HashSet<RepositoryProtocol>(isio._repositoryProtocolMap.values())) && InformationServiceInitObject.isEqual(this.serverDefs, isio.serverDefs) && InformationServiceInitObject.isEqual(this.reposDefs, isio.reposDefs) && InformationServiceInitObject.isEqual(new HashSet<FactoryType>(this._factoryTypeMap.values()), new HashSet<FactoryType>(isio._factoryTypeMap.values())) && InformationServiceInitObject.isEqual(this.smartDefs, isio.smartDefs) && InformationServiceInitObject.isEqual(this.repositoryGroups, isio.repositoryGroups);
        }
        return isEqual;
    }

    private static final boolean isEqual(Object o1, Object o2) {
        boolean isEqual = false;
        if (o1 != null) {
            isEqual = o1.equals(o2);
        } else if (o2 == null) {
            isEqual = true;
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = this.getPrimeNumber();
        if (this._factoryTypeMap != null) {
            for (FactoryType factoryType : this._factoryTypeMap.values()) {
                hashCode += factoryType.hashCode();
            }
        }
        hashCode = primeNumber * hashCode + (this._repositoryProtocolMap == null ? 0 : this._repositoryProtocolMap.hashCode());
        hashCode = primeNumber * hashCode + (this.serverDefs == null ? 0 : this.serverDefs.hashCode());
        hashCode = primeNumber * hashCode + (this.reposDefs == null ? 0 : this.reposDefs.hashCode());
        hashCode = primeNumber * hashCode + (this.repositoryGroups == null ? 0 : this.repositoryGroups.hashCode());
        hashCode = primeNumber * hashCode + (this.smartDefs == null ? 0 : this.smartDefs.hashCode());
        return hashCode;
    }
}

