/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RB;
import com.sas.services.util.XMLUtil;
import com.sas.services.webdav.Utils;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

@SASScope(value="ALL")
public class Filter
implements FilterInterface,
Serializable {
    private static final int PROTOCOL_LIST_INIT = 1;
    private static final int OPTION_MAP_INIT = 4;
    private static final long serialVersionUID = 3266825809530256139L;
    private static final int STRINGBUFFER_INIT = 64;
    protected FilterComponent _component = null;
    private String _type = null;
    private String _name = null;
    private String _template = null;
    private String _option = null;
    private String _reposid = null;
    private String _base = null;
    private String _DAVbase = null;
    private String _rdbmsTable;
    private int _scope = -1;
    private int _DAVscope = -1;
    private int _flags = 0;
    private Map _options = new HashMap(4);
    private List _protocols = new ArrayList(1);
    private String _searchString = null;

    public Filter() {
    }

    public Filter(String key, int relation, String value) {
        this();
        this._component = new FilterComponent(key, relation, value);
    }

    @Override
    public String getFilterString() {
        String compFilter = this.component2String(this._component);
        if (this._type != null) {
            if (compFilter.length() < 2) {
                return "(type=" + this._type + ')';
            }
            return "(type=" + this._type + ") AND " + compFilter;
        }
        return compFilter;
    }

    private String component2String(FilterComponent component) {
        boolean isFirst = true;
        StringBuffer buffer = new StringBuffer(64);
        if (component == null) {
            return buffer.toString();
        }
        String key = component.getKey();
        int relation = component.getRelation();
        String value = component.getValue();
        int aggregator = component.getAggregation();
        Iterator it = component.getComponents();
        if (key == null && !it.hasNext()) {
            return buffer.toString();
        }
        if (key != null) {
            buffer.append('(' + key);
            switch (relation) {
                case 0: {
                    buffer.append(" = ");
                    break;
                }
                case 1: {
                    buffer.append(' ' + RB.getStringResource("Filter.contains.txt") + ' ');
                    break;
                }
                case 2: {
                    buffer.append(" = ");
                    break;
                }
                case 3: {
                    buffer.append(" = *");
                    break;
                }
            }
            buffer.append(value);
            if (relation == 2) {
                buffer.append("*");
            }
            buffer.append(")");
            isFirst = false;
        }
        while (it.hasNext()) {
            if (!isFirst) {
                if (aggregator == 0) {
                    buffer.append(" AND ");
                } else {
                    buffer.append(" OR ");
                }
            }
            FilterComponent subcom = (FilterComponent)it.next();
            buffer.append(this.component2String(subcom));
            isFirst = false;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getFilterString();
    }

    @Override
    public void setFilterComponent(FilterComponent component) {
        this._component = component;
    }

    @Override
    public FilterComponent getFilterComponent() {
        return this._component;
    }

    @Override
    public void setType(String type) {
        this._type = type;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getOMRType() {
        return this.getType();
    }

    @Override
    public String getDAVType() {
        return this.getType();
    }

    public String getJCRType() {
        return this.getType();
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getOMRSearchString() {
        String xmlSelect = this.getXMLSelectString();
        if (xmlSelect.length() == 0) {
            return "";
        }
        int startIndex = xmlSelect.indexOf("Search=\"");
        int endIndex = xmlSelect.lastIndexOf("\"") + 1;
        if (startIndex > -1 && endIndex > startIndex) {
            return xmlSelect.substring(startIndex, endIndex);
        }
        return "";
    }

    @Override
    public String getXMLSelectString() {
        if (this._searchString != null && this._searchString.trim().length() > 0) {
            return this._searchString;
        }
        FilterComponent compy = this._component;
        if (this._name != null) {
            FilterComponent nameComp = new FilterComponent("Name", 0, this._name);
            if (compy != null) {
                nameComp.addComponent(compy);
                nameComp.setAggregation(0);
            }
            this._component = nameComp;
        }
        StringBuffer buffer = new StringBuffer(64);
        if (this._component == null) {
            return "";
        }
        String componentFilter = this.component2XMLSelect(this._component);
        if ("UNSUPPORTED".equals(componentFilter)) {
            return "UNSUPPORTED";
        }
        if (componentFilter.length() == 0) {
            return "";
        }
        componentFilter = componentFilter.trim();
        buffer.append("<XMLSelect Search=\"");
        buffer.append(componentFilter);
        buffer.append("\" />\n");
        this._component = compy;
        return buffer.toString();
    }

    protected String component2Select(FilterComponent component) {
        if (component == null) {
            return "";
        }
        String attrBuffer = this.getAttributeFilter(component);
        if (attrBuffer != null && attrBuffer.length() > 0) {
            return attrBuffer;
        }
        return "";
    }

    private String component2XMLSelect(FilterComponent component) {
        if (component == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("*");
        String attrFilter = this.component2Select(component);
        if (attrFilter.equals("UNSUPPORTED")) {
            return "UNSUPPORTED";
        }
        if (attrFilter != null && attrFilter.length() > 0) {
            buffer.append("[");
            buffer.append(attrFilter);
            buffer.append("]");
        }
        if (this.containsAssociationPaths(component)) {
            Iterator<AssociationPathComponent> assocIter = component.getAssociationPathComponents();
            while (assocIter.hasNext()) {
                AssociationPathComponent assocComp = assocIter.next();
                this.appendAssociationPath(buffer, assocComp);
            }
            Iterator subIter = component.getComponents();
            while (subIter.hasNext()) {
                FilterComponent comp = (FilterComponent)subIter.next();
                if (!comp.containsAssociationPathComponents()) continue;
                Iterator<AssociationPathComponent> subAssocIter = comp.getAssociationPathComponents();
                while (subAssocIter.hasNext()) {
                    AssociationPathComponent assocComp = subAssocIter.next();
                    this.appendAssociationPath(buffer, assocComp);
                }
            }
        }
        return buffer.toString();
    }

    private boolean containsAssociationPaths(FilterComponent component) {
        if (component.containsAssociationPathComponents()) {
            return true;
        }
        if (component.containsComponents()) {
            Iterator iter = component.getComponents();
            while (iter.hasNext()) {
                FilterComponent subComp = (FilterComponent)iter.next();
                if (!this.containsAssociationPaths(subComp)) continue;
                return true;
            }
        }
        return false;
    }

    private void appendAssociationPath(StringBuffer buffer, AssociationPathComponent assocComp) {
        String assocBuffer = this.getAssociationFilter(assocComp);
        if (assocBuffer != null && assocBuffer.length() > 0) {
            int aggregation = assocComp.getAggregation();
            if (aggregation == 0) {
                buffer.append(" AND ");
            } else if (aggregation == 1) {
                buffer.append(" OR ");
            }
            buffer.append("[");
            buffer.append(assocBuffer);
            buffer.append("]");
        }
    }

    private String getAttributeFilter(FilterComponent component) {
        StringBuffer buffer = new StringBuffer(64);
        boolean doParens = false;
        boolean isFirst = true;
        String key = component.getKey();
        String originalValue = component.getValue();
        String value = XMLUtil.normalize(originalValue);
        Iterator subcom = component.getComponents();
        if (subcom != null && subcom.hasNext()) {
            doParens = true;
        }
        int relation = component.getRelation();
        int aggregation = component.getAggregation();
        if (key == null && subcom == null) {
            return "";
        }
        boolean filterSet = false;
        if (doParens) {
            buffer.append(" (");
        }
        if (key != null && originalValue != null) {
            switch (relation) {
                case 0: {
                    buffer.append(" @" + key + "='" + value + '\'');
                    break;
                }
                case 1: {
                    buffer.append(" @" + key + " ? '" + value + '\'');
                    break;
                }
                case 2: {
                    buffer.append(" @" + key + " =: '" + value + '\'');
                    break;
                }
                case 8: {
                    buffer.append(" @" + key + " GT '" + value + '\'');
                    break;
                }
                case 9: {
                    buffer.append(" @" + key + " GE '" + value + '\'');
                    break;
                }
                case 6: {
                    buffer.append(" @" + key + " LT '" + value + '\'');
                    break;
                }
                case 7: {
                    buffer.append(" @" + key + " LE '" + value + '\'');
                    break;
                }
                case 11: {
                    buffer.append(" @" + key + " NE '" + value + '\'');
                    break;
                }
                default: {
                    return "UNSUPPORTED";
                }
            }
            isFirst = false;
            filterSet = true;
        }
        while (subcom.hasNext()) {
            FilterComponent comp = (FilterComponent)subcom.next();
            String attrFilter = this.getAttributeFilter(comp);
            if (attrFilter == null || attrFilter.length() <= 0) continue;
            if (!isFirst) {
                if (aggregation == 0) {
                    buffer.append(" and");
                } else {
                    buffer.append(" or");
                }
            }
            buffer.append(this.getAttributeFilter(comp));
            isFirst = false;
            filterSet = true;
        }
        if (!filterSet) {
            return "";
        }
        if (doParens) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    private String getAssociationFilter(AssociationPathComponent component) {
        AssociationPathComponent nextAssocComp;
        String attrBuffer;
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(component.getAssociationName());
        buffer.append("/");
        buffer.append(component.getAssociatedType());
        FilterComponent attrComp = component.getAttributeCriteria();
        if (attrComp != null && (attrBuffer = this.getAttributeFilter(attrComp)) != null && attrBuffer.length() > 0) {
            buffer.append("[");
            buffer.append(attrBuffer);
            buffer.append("]");
        }
        if ((nextAssocComp = component.getNextAssociationPath()) != null) {
            buffer.append("/");
            buffer.append(this.getAssociationFilter(nextAssocComp));
        }
        return buffer.toString();
    }

    protected String component2JCRXPath(FilterComponent component) {
        if (component == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(64);
        boolean isFirst = true;
        String key = component.getKey();
        String value = XMLUtil.normalize(component.getValue());
        Iterator subcom = component.getComponents();
        int relation = component.getRelation();
        int aggregation = component.getAggregation();
        if (key == null && subcom == null) {
            return "";
        }
        if (key != null && value != null) {
            switch (relation) {
                case 0: {
                    buffer.append("@" + key + "='" + value + '\'');
                    break;
                }
                case 1: {
                    buffer.append("jcr:like(@" + key + ", '%" + value + "%')");
                    break;
                }
                case 2: {
                    buffer.append("jcr:like(@" + key + ", '%" + value + "')");
                    break;
                }
                case 3: {
                    buffer.append("jcr:like(@" + key + ", '" + value + "%')");
                    break;
                }
                case 10: {
                    if (key == null || key.length() == 0) {
                        buffer.append("jcr:contains(., '" + value + "')");
                        break;
                    }
                    buffer.append("jcr:contains(@" + key + ", '" + value + "')");
                    break;
                }
                case 8: {
                    buffer.append("@" + component.getKey());
                    buffer.append(" > '");
                    buffer.append(component.getValue());
                    buffer.append("'");
                    break;
                }
                case 9: {
                    buffer.append("@" + component.getKey());
                    buffer.append(" >= '");
                    buffer.append(component.getValue());
                    buffer.append("'");
                    break;
                }
                case 6: {
                    buffer.append("@" + component.getKey());
                    buffer.append(" < '");
                    buffer.append(component.getValue());
                    buffer.append("'");
                    break;
                }
                case 7: {
                    buffer.append("@" + component.getKey());
                    buffer.append(" <= '");
                    buffer.append(component.getValue());
                    buffer.append("'");
                    break;
                }
                default: {
                    return "UNSUPPORTED";
                }
            }
            isFirst = false;
        }
        while (subcom.hasNext()) {
            if (!isFirst) {
                if (aggregation == 0) {
                    buffer.append(" and ");
                } else {
                    buffer.append(" or ");
                }
            }
            FilterComponent comp = (FilterComponent)subcom.next();
            buffer.append(this.component2JCRXPath(comp));
            isFirst = false;
        }
        if (aggregation == 1) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public String getXPathString() {
        return "";
    }

    @Override
    public String getJCRXPathString() {
        String componentFilter;
        StringBuffer buffer;
        FilterComponent compy;
        block20: {
            int scope;
            String type;
            String path;
            block19: {
                compy = this._component;
                if (this._name != null) {
                    FilterComponent nameComp = new FilterComponent("Name", 0, this._name);
                    if (compy != null) {
                        nameComp.addComponent(compy);
                        nameComp.setAggregation(0);
                    }
                    this._component = nameComp;
                }
                buffer = new StringBuffer(64);
                componentFilter = "";
                if (this._component != null) {
                    componentFilter = this.component2JCRXPath(this._component);
                    componentFilter = componentFilter.trim();
                }
                path = this.getDAVBase();
                type = this.getJCRType();
                scope = this.getDAVScope();
                if (scope == -1) {
                    scope = 1;
                }
                if (!"".equals(type)) break block19;
                type = type.toLowerCase();
                buffer.append("/jcr:root");
                switch (scope) {
                    case 2: {
                        buffer.append(path);
                        buffer.append("//*");
                        break;
                    }
                    case 1: {
                        buffer.append(path);
                        buffer.append("/*");
                        break;
                    }
                    case 0: {
                        if (type != null && type.length() > 0) {
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block20;
            }
            buffer.append("/jcr:root");
            switch (scope) {
                case 2: {
                    buffer.append(path);
                    buffer.append("//");
                    if (type != null && type.length() > 0) {
                        buffer.append("element(*," + type + ")");
                        break;
                    }
                    buffer.append("element()");
                    break;
                }
                case 1: {
                    buffer.append(path);
                    buffer.append('/');
                    if (type != null && type.length() > 0) {
                        buffer.append("element(*," + type + ")");
                        break;
                    }
                    buffer.append("element()");
                    break;
                }
                case 0: {
                    if (type != null && type.length() > 0) {
                        String name = path.substring(path.lastIndexOf("/") + 1);
                        buffer.append("element(" + name + "," + type + ")");
                        buffer.append(path.substring(0, path.lastIndexOf("/")));
                        buffer.append("/");
                        break;
                    }
                    buffer.append(path);
                    break;
                }
            }
        }
        if (componentFilter != null && componentFilter.length() > 0) {
            buffer.append("[" + componentFilter + "]");
        }
        this._component = compy;
        return buffer.toString();
    }

    @Override
    public String getOMRTemplate() {
        return this._template;
    }

    @Override
    public void setOMRTemplate(String template) {
        this._template = template;
    }

    @Override
    public String getOMROption() {
        return this._option;
    }

    @Override
    public void setOMROption(String option) {
        this._option = option;
    }

    @Override
    public void setOMRFlags(int flags) {
        this._flags = flags;
    }

    @Override
    public int getOMRFlags() {
        return this._flags;
    }

    @Override
    public String getOMRRepository() {
        return this._reposid;
    }

    @Override
    public void setOMRRepository(String reposid) {
        this._reposid = reposid;
    }

    @Override
    public String getDAVBase() {
        return this._DAVbase == null ? "" : this._DAVbase;
    }

    @Override
    public void setDAVBase(String base) {
        this._DAVbase = base;
    }

    @Override
    public void setRdbmsTable(String table) {
        this._rdbmsTable = table;
    }

    @Override
    public String getRdbmsTable() {
        return this._rdbmsTable;
    }

    @Override
    public void setDAVScope(int scope) {
        this._DAVscope = scope;
    }

    @Override
    public int getDAVScope() {
        return this._DAVscope;
    }

    @Override
    public String getDAVBasicSearchString() {
        URI uri;
        String base;
        StringBuffer searchString;
        block22: {
            searchString = new StringBuffer(64);
            searchString.append("<D:basicsearch xmlns:D=\"DAV:\">");
            searchString.append("<D:select><D:allprop/></D:select>");
            searchString.append("<D:from><D:scope><D:href>");
            base = this.getDAVBase();
            URL url = null;
            uri = null;
            try {
                if (base.indexOf("://") > -1) {
                    try {
                        url = new URL(base);
                    }
                    catch (MalformedURLException mue) {
                        mue.printStackTrace();
                    }
                    uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), null, null);
                    break block22;
                }
                uri = new URI(null, null, base, null);
            }
            catch (URISyntaxException use) {
                use.printStackTrace();
            }
        }
        if (uri != null) {
            base = uri.toASCIIString();
        }
        if (base != null && base.length() > 0) {
            searchString.append(base);
        } else {
            searchString.append("/");
        }
        searchString.append("</D:href><D:depth>");
        int scope = this.getDAVScope();
        switch (scope) {
            case 0: {
                searchString.append("0");
                break;
            }
            case 1: {
                searchString.append("1");
                break;
            }
            case 2: {
                searchString.append("infinity");
                break;
            }
            default: {
                searchString.append("infinity");
            }
        }
        searchString.append("</D:depth></D:scope></D:from>");
        String compFilter = this.components2DAVBasic(this._component);
        String type = this.getDAVType();
        if (compFilter.length() > 1 || type != null) {
            searchString.append("<D:where>");
        }
        if (type != null) {
            if (compFilter.length() > 1) {
                searchString.append("<D:and>");
            }
            if (type.indexOf(124) > 0) {
                searchString.append("<D:or>");
                StringTokenizer st = new StringTokenizer(type, "|");
                while (st.hasMoreTokens()) {
                    String _type = st.nextToken();
                    searchString.append("<D:eq><D:prop>");
                    searchString.append("<sas:type xmlns:sas=\"http://www.sas.com/rnd/itech/WebDAV\"/>");
                    searchString.append("</D:prop><D:literal>");
                    searchString.append(_type);
                    searchString.append("</D:literal></D:eq>");
                }
                searchString.append("</D:or>");
            } else {
                searchString.append("<D:eq><D:prop>");
                searchString.append("<sas:type xmlns:sas=\"http://www.sas.com/rnd/itech/WebDAV\"/>");
                searchString.append("</D:prop><D:literal>");
                searchString.append(Utils.CDATA((String)type));
                searchString.append("</D:literal></D:eq>");
            }
            if (compFilter.length() > 1) {
                searchString.append(compFilter);
                searchString.append("</D:and>");
            }
        } else {
            searchString.append(compFilter);
        }
        if (compFilter.length() > 1 || type != null) {
            searchString.append("</D:where>");
        }
        searchString.append("</D:basicsearch>");
        return searchString.toString();
    }

    private String components2DAVBasic(FilterComponent component) {
        if (component == null) {
            return "";
        }
        StringBuffer searchString = new StringBuffer(64);
        Iterator subcomponents = component.getComponents();
        if (subcomponents.hasNext()) {
            if (component.getAggregation() == 0) {
                StringBuffer pString = new StringBuffer(64);
                int nPremise = 0;
                String p = this.component2DAVBasic(component);
                if (p.length() > 0) {
                    ++nPremise;
                    pString.append(p);
                }
                Iterator components = component.getComponents();
                while (components.hasNext()) {
                    p = this.components2DAVBasic((FilterComponent)components.next());
                    if (p.length() <= 0) continue;
                    ++nPremise;
                    pString.append(p);
                }
                if (nPremise > 1) {
                    searchString.append("<D:and>");
                }
                searchString.append(pString);
                if (nPremise > 1) {
                    searchString.append("</D:and>");
                }
            } else if (component.getAggregation() == 1) {
                StringBuffer pString = new StringBuffer(64);
                int nPremise = 0;
                String p = this.component2DAVBasic(component);
                if (p.length() > 0) {
                    ++nPremise;
                    pString.append(p);
                }
                Iterator components = component.getComponents();
                while (components.hasNext()) {
                    p = this.components2DAVBasic((FilterComponent)components.next());
                    if (p.length() <= 0) continue;
                    ++nPremise;
                    pString.append(p);
                }
                if (nPremise > 1) {
                    searchString.append("<D:or>");
                }
                searchString.append(pString);
                if (nPremise > 1) {
                    searchString.append("</D:or>");
                }
            }
        } else {
            searchString.append(this.component2DAVBasic(component));
        }
        return searchString.toString();
    }

    private String component2DAVBasic(FilterComponent component) {
        if (component == null) {
            return "";
        }
        if (component.getKey() == null) {
            return "";
        }
        boolean caseless = (this._flags & 0x200) == 0;
        String caselessString = " casesensitive=\"0\"";
        StringBuffer searchString = new StringBuffer();
        int relation = component.getRelation();
        switch (relation) {
            case 0: {
                searchString.append("<D:eq" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                searchString.append("<D:literal>" + Utils.CDATA((String)component.getValue()) + "</D:literal>");
                searchString.append("</D:eq>");
                break;
            }
            case 2: {
                searchString.append("<D:like" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                searchString.append("<D:literal>" + Utils.CDATA((String)(component.getValue() + '%')) + "</D:literal>");
                searchString.append("</D:like>");
                break;
            }
            case 3: {
                searchString.append("<D:like" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                searchString.append("<D:literal>" + Utils.CDATA((String)('%' + component.getValue())) + "</D:literal>");
                searchString.append("</D:like>");
                break;
            }
            case 1: {
                searchString.append("<D:like" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                String value = component.getValue();
                if (value == null || value.trim().length() == 0 || value.trim().equals("*")) {
                    searchString.append("<D:literal>" + Utils.CDATA((String)"%") + "</D:literal>");
                } else {
                    searchString.append("<D:literal>" + Utils.CDATA((String)('%' + component.getValue() + '%')) + "</D:literal>");
                }
                searchString.append("</D:like>");
                break;
            }
            case 8: {
                searchString.append("<D:gt" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                searchString.append("<D:literal>" + Utils.CDATA((String)component.getValue()) + "</D:literal>");
                searchString.append("</D:gt>");
                break;
            }
            case 9: {
                searchString.append("<D:gte" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                searchString.append("<D:literal>" + Utils.CDATA((String)component.getValue()) + "</D:literal>");
                searchString.append("</D:gte>");
                break;
            }
            case 6: {
                searchString.append("<D:lt" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                searchString.append("<D:literal>" + Utils.CDATA((String)component.getValue()) + "</D:literal>");
                searchString.append("</D:lt>");
                break;
            }
            case 7: {
                searchString.append("<D:lte" + (caseless ? caselessString : "") + '>');
                searchString.append("<D:prop>" + this.nsQualifiedXML(component.getKey()) + "</D:prop>");
                searchString.append("<D:literal>" + Utils.CDATA((String)component.getValue()) + "</D:literal>");
                searchString.append("</D:lte>");
                break;
            }
            case 4: {
                searchString.append(this.genIsDefined(component.getKey()));
                break;
            }
            case 5: {
                searchString.append("<D:not>" + this.genIsDefined(component.getKey()) + "</D:not>");
                break;
            }
            case 10: {
                searchString.append("<D:contains>" + Utils.CDATA((String)component.getValue()) + "</D:contains>");
                break;
            }
            default: {
                return "UNSUPPORTED";
            }
        }
        return searchString.toString();
    }

    private String genIsDefined(String elName) {
        if (elName.equals("D:iscollection") || elName.equals("D:is-collection")) {
            return this.nsQualifiedXML(elName);
        }
        return "<D:is-defined><D:prop>" + this.nsQualifiedXML(elName) + "</D:prop></D:is-defined>";
    }

    private String nsQualifiedXML(String elName) {
        if (elName.equalsIgnoreCase("name")) {
            return "<D:displayname/>";
        }
        String ns = "";
        int ptr2 = elName.indexOf(125);
        if (ptr2 > 0) {
            int ptr1 = elName.indexOf(123);
            ns = elName.substring(ptr1 + 1, ptr2);
            elName = elName.substring(ptr2 + 1);
        }
        if (ns.length() > 0) {
            if ("DAV:".equals(ns)) {
                return "<D:" + elName + "/>";
            }
            return "<ns0:" + elName + " xmlns:ns0=\"" + ns + "\"/>";
        }
        if (ptr2 > 0) {
            return "<" + elName + " xmlns=\"\"/>";
        }
        return "<" + elName + "/>";
    }

    @Override
    public String getDAVSQLString() {
        StringBuffer searchString = new StringBuffer(64);
        searchString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        searchString.append("<D:searchrequest xmlns:D=\"DAV:\"><D:sql>");
        searchString.append("SELECT \"DAV:resourcetype\" ");
        String DAVBase = this.getDAVBase();
        searchString.append("FROM SCOPE(");
        if (DAVBase != null && DAVBase.length() > 0) {
            searchString.append("'");
            if (this.getDAVScope() == 2) {
                searchString.append("DEEP TRAVERSAL OF \"");
            } else {
                searchString.append("SHALLOW TRAVERSAL OF \"");
            }
            searchString.append(DAVBase);
            searchString.append("\"'");
        }
        searchString.append(")");
        String compFilter = this.components2DAVSQL(this._component);
        String type = this.getDAVType();
        if (compFilter.length() > 1 || type != null) {
            searchString.append(" WHERE ");
        }
        if (type != null) {
            String sn = "http://www.sas.com/rnd/itech/WebDAV";
            if (type.indexOf(124) > 0) {
                searchString.append("(");
                StringTokenizer st = new StringTokenizer(type, "|");
                boolean atTheBeginning = true;
                while (st.hasMoreTokens()) {
                    String _type = st.nextToken();
                    if (!atTheBeginning) {
                        searchString.append(" OR ");
                    } else {
                        atTheBeginning = false;
                    }
                    searchString.append('\"' + sn + "#type\" = '" + _type + '\'');
                }
                searchString.append(")");
            } else {
                searchString.append('\"' + sn + "#type\" = '" + type + '\'');
            }
            if (compFilter.length() > 1) {
                searchString.append(" AND ");
                searchString.append(compFilter);
            }
        } else {
            searchString.append(compFilter);
        }
        searchString.append("</D:sql></D:searchrequest>");
        return searchString.toString();
    }

    private String components2DAVSQL(FilterComponent component) {
        StringBuffer searchString;
        block5: {
            Iterator subcomponents;
            block6: {
                if (component == null) {
                    return "";
                }
                searchString = new StringBuffer(this.component2DAVSQL(component));
                subcomponents = component.getComponents();
                if (!subcomponents.hasNext()) break block5;
                if (component.getAggregation() != 0) break block6;
                while (subcomponents.hasNext()) {
                    if (searchString.length() > 0) {
                        searchString.append(" AND ");
                    }
                    searchString.append(this.components2DAVSQL((FilterComponent)subcomponents.next()));
                }
                break block5;
            }
            if (component.getAggregation() != 1) break block5;
            while (subcomponents.hasNext()) {
                if (searchString.length() > 0) {
                    searchString.append(" OR ");
                }
                searchString.append(this.components2DAVSQL((FilterComponent)subcomponents.next()));
            }
        }
        return component.getAggregation() == 1 && searchString.indexOf(" OR ") > 0 ? '(' + searchString.toString() + ')' : searchString.toString();
    }

    private String component2DAVSQL(FilterComponent component) {
        if (component == null) {
            return "";
        }
        if (component.getKey() == null) {
            return "";
        }
        StringBuffer searchString = new StringBuffer(64);
        int relation = component.getRelation();
        switch (relation) {
            case 0: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" = '");
                searchString.append(component.getValue());
                searchString.append("'");
                break;
            }
            case 2: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" LIKE '");
                searchString.append('%' + component.getValue());
                searchString.append("'");
                break;
            }
            case 3: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" LIKE '");
                searchString.append(component.getValue() + '%');
                searchString.append("'");
                break;
            }
            case 1: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" LIKE '");
                searchString.append('%' + component.getValue() + '%');
                searchString.append("'");
                break;
            }
            case 8: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" > '");
                searchString.append(component.getValue());
                searchString.append("'");
                break;
            }
            case 9: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" >= '");
                searchString.append(component.getValue());
                searchString.append("'");
                break;
            }
            case 6: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" < '");
                searchString.append(component.getValue());
                searchString.append("'");
                break;
            }
            case 7: {
                searchString.append('\"' + this.nsQualified(component.getKey()) + '\"');
                searchString.append(" <= '");
                searchString.append(component.getValue());
                searchString.append("'");
                break;
            }
            case 4: {
                if (component.getKey().equalsIgnoreCase("{DAV:}is-collection")) {
                    searchString.append("\"DAV:iscollection\" = true");
                    break;
                }
                searchString.append(this.nsQualified(component.getKey()));
                break;
            }
            case 5: {
                if (component.getKey().equalsIgnoreCase("{DAV:}is-collection")) {
                    searchString.append("\"DAV:iscollection\" = false");
                    break;
                }
                searchString.append("NOT " + this.nsQualified(component.getKey()));
                break;
            }
            case 10: {
                searchString.append("CONTAINS \"" + component.getValue() + '\"');
                break;
            }
        }
        return searchString.toString();
    }

    private String nsQualified(String elName) {
        if (elName.equalsIgnoreCase("name")) {
            return "DAV:displayname";
        }
        String ns = "";
        int ptr2 = elName.indexOf(125);
        if (ptr2 > 0) {
            int ptr1 = elName.indexOf(123);
            ns = elName.substring(ptr1 + 1, ptr2);
            ns = ns.trim();
            elName = elName.substring(ptr2 + 1);
            elName = elName.trim();
        }
        if (ns.length() > 0) {
            if (ns.startsWith("urn")) {
                if (ns.endsWith(":")) {
                    return ns + elName;
                }
                return ns + "#" + elName;
            }
            if (ns.endsWith("/") || ns.endsWith(":")) {
                return ns + elName;
            }
            return ns + "/" + elName;
        }
        return elName;
    }

    @Override
    public void addProtocol(String protocol) {
        this._protocols.add(protocol);
    }

    @Override
    public void removeProtocol(String protocol) {
        this._protocols.remove(protocol);
    }

    @Override
    public void setProtocols(List protocols) {
        this._protocols.addAll(protocols);
    }

    @Override
    public List getProtocols() {
        return this._protocols;
    }

    @Override
    public void setExplicitSearchString(String protocol, String searchString) {
        this._protocols.clear();
        this._protocols.add(protocol);
        this._searchString = searchString;
    }

    @Override
    public String getExplicitSearchString() {
        return this._searchString;
    }

    @Override
    public void addSearchOption(String name, Object option) {
        this._options.put(name, option);
    }

    @Override
    public void removeSearchOption(String name) {
        this._options.remove(name);
    }

    @Override
    public Map getSearchOptions() {
        return this._options;
    }
}

