/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.information.FactoryAction;
import com.sas.services.information.InformationServiceInitObject;
import com.sas.services.information.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

@SASScope
public final class FactoryType
implements Cloneable,
ConsumedResourceInterface {
    private String _protocol;
    private String _type;
    private String _id = GUID.newGUID();
    private Map _factoryActions = new HashMap(5);

    public FactoryType(String protocol, String type) {
        this.setProtocol(protocol);
        this.setType(type);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException();
        }
        this._protocol = protocol;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this._type = type;
    }

    public FactoryAction getFactoryAction(FactoryAction factoryAction) {
        FactoryAction theFactoryAction = null;
        String resourceName = factoryAction.getResourceValue();
        FactoryAction nextFactoryAction2 = null;
        for (FactoryAction nextFactoryAction2 : this._factoryActions.values()) {
            if (!resourceName.equals(nextFactoryAction2.getResourceValue())) continue;
            theFactoryAction = nextFactoryAction2;
            break;
        }
        return theFactoryAction;
    }

    public FactoryAction getFactoryActionUsingID(String id) {
        return (FactoryAction)this._factoryActions.get(id);
    }

    public Map getFactoryActions() {
        return this._factoryActions;
    }

    public Set getFactoryActionSet() {
        return new HashSet(this._factoryActions.values());
    }

    public boolean addFactoryAction(FactoryAction factoryAction) {
        this._factoryActions.put(factoryAction.getResourceID(), factoryAction);
        return true;
    }

    boolean removeFactoryAction(FactoryAction factoryAction) {
        this._factoryActions.remove(factoryAction.getResourceID());
        return true;
    }

    boolean hasConflict(FactoryType other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else if (other != null) {
            String otherProtocol = other.getProtocol();
            String otherType = other.getType();
            String thisProtocol = this.getProtocol();
            String thisType = this.getType();
            boolean bl = isEqual = !(otherProtocol != null && !"".equals(otherProtocol) && thisProtocol != null && !Strings.equal((String)otherProtocol, (String)thisProtocol, (boolean)false, (boolean)false) || otherType != null && !"".equals(otherType) && thisType != null && !Strings.equal((String)otherType, (String)thisType, (boolean)false, (boolean)false));
            if (isEqual) {
                FactoryAction factoryActionThis2 = null;
                FactoryAction factoryActionOther2 = null;
                String filter = null;
                HashMap<String, FactoryAction> filter2ActionThis = new HashMap<String, FactoryAction>(this._factoryActions.size());
                HashMap<String, FactoryAction> filter2ActionOther = new HashMap<String, FactoryAction>(other._factoryActions.size());
                for (FactoryAction factoryActionThis2 : this._factoryActions.values()) {
                    filter = factoryActionThis2.getFilter();
                    filter2ActionThis.put(filter == null ? "" : filter, factoryActionThis2);
                }
                for (FactoryAction factoryActionOther2 : other._factoryActions.values()) {
                    filter = factoryActionOther2.getFilter();
                    filter2ActionOther.put(filter == null ? "" : filter, factoryActionOther2);
                }
                Map.Entry mapEntry2 = null;
                for (Map.Entry mapEntry2 : filter2ActionOther.entrySet()) {
                    factoryActionOther2 = (FactoryAction)mapEntry2.getValue();
                    filter = (String)mapEntry2.getKey();
                    factoryActionThis2 = (FactoryAction)filter2ActionThis.get(filter);
                    if (factoryActionThis2 == null || !factoryActionThis2.hasConflict(factoryActionOther2)) continue;
                    isEqual = false;
                    break;
                }
            }
        }
        return !isEqual;
    }

    public boolean equals(Object other) {
        boolean isEqual;
        block6: {
            isEqual = false;
            try {
                if (other == this) {
                    isEqual = true;
                    break block6;
                }
                if (other == null) {
                    isEqual = false;
                    break block6;
                }
                FactoryType otherFactoryType = (FactoryType)other;
                if (!Strings.equal((String)this.getProtocol(), (String)otherFactoryType.getProtocol(), (boolean)false, (boolean)false) || !Strings.equal((String)this.getType(), (String)otherFactoryType.getType(), (boolean)false, (boolean)false)) break block6;
                isEqual = true;
                String action = null;
                Iterator iter = this._factoryActions.values().iterator();
                while (iter.hasNext()) {
                    action = ((FactoryAction)iter.next()).getAction();
                    boolean wasFound = false;
                    Iterator iterOther = otherFactoryType._factoryActions.values().iterator();
                    while (iterOther.hasNext()) {
                        if (!action.equals(((FactoryAction)iterOther.next()).getAction())) continue;
                        wasFound = true;
                        break;
                    }
                    if (wasFound) continue;
                    isEqual = false;
                    break;
                }
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 7;
        if (this._protocol != null) {
            hashCode ^= this._protocol.hashCode();
        }
        if (this._type != null) {
            hashCode ^= this._type.hashCode();
        }
        if (this._factoryActions != null) {
            Iterator iter = this._factoryActions.values().iterator();
            while (iter.hasNext()) {
                hashCode ^= ((FactoryAction)iter.next()).hashCode();
            }
        }
        return hashCode;
    }

    void merge(FactoryType factoryType, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy, Map resourceIdMap) throws ServiceConfigurationException {
        if (factoryType != null) {
            String value = factoryType.getType();
            if (value != null) {
                this.setType(value);
            }
            if ((value = factoryType.getProtocol()) != null) {
                this.setProtocol(value);
            }
            this.mergeFactoryActions(factoryType, serviceConfig, mergePolicy, resourceIdMap);
        }
    }

    void replace(FactoryType factoryType, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy, Map resourceIdMap) throws ServiceConfigurationException {
        if (factoryType != null) {
            this.setProtocol(factoryType.getProtocol());
            this.setType(factoryType.getType());
            this.mergeFactoryActions(factoryType, serviceConfig, mergePolicy, resourceIdMap);
        }
    }

    private void mergeFactoryActions(FactoryType factoryType, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy, Map resourceIdMap) throws ServiceConfigurationException {
        try {
            if (factoryType != null && mergePolicy != null) {
                FactoryAction newFactoryAction2 = null;
                FactoryAction thisFactoryAction = null;
                String thisResourceID = null;
                String newResourceID = null;
                for (FactoryAction newFactoryAction2 : factoryType._factoryActions.values()) {
                    boolean isSame;
                    newResourceID = newFactoryAction2.getResourceID();
                    thisFactoryAction = (FactoryAction)this._factoryActions.get(newResourceID);
                    boolean bl = isSame = thisFactoryAction != null;
                    if (thisFactoryAction == null) {
                        thisFactoryAction = this.getFactoryAction(newFactoryAction2);
                    }
                    if (thisFactoryAction == null) {
                        serviceConfig.addFactoryAction(this, (FactoryAction)newFactoryAction2.clone());
                    } else if (isSame || !thisFactoryAction.hasConflict(newFactoryAction2)) {
                        thisFactoryAction.merge(newFactoryAction2);
                        thisResourceID = thisFactoryAction.getResourceID();
                    } else if (mergePolicy.isOKToReplace()) {
                        thisFactoryAction.replace(newFactoryAction2);
                        thisResourceID = thisFactoryAction.getResourceID();
                    } else {
                        throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictFactoryAction.ex.fmt.txt", (Object)thisFactoryAction.getAction(), (Object)newFactoryAction2.getAction()));
                    }
                    resourceIdMap.put(newResourceID, thisResourceID == null ? newResourceID : thisResourceID);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            throw new ServiceConfigurationException(e);
        }
    }

    @Override
    public String getResourceID() {
        return this._id;
    }

    @Override
    public String getResourceValue() {
        return this._protocol + "::" + this._type;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("FactoryType.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.factoryType.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "FactoryType";
    }

    @Override
    public int getResourceTypeCode() {
        return 1;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FactoryType clone = (FactoryType)super.clone();
        if (this._factoryActions == null) {
            clone._factoryActions = new HashMap(0);
        } else {
            clone._factoryActions = new HashMap(this._factoryActions.size());
            FactoryAction nextFactoryAction = null;
            Iterator iter = this._factoryActions.values().iterator();
            while (iter.hasNext()) {
                nextFactoryAction = (FactoryAction)((FactoryAction)iter.next()).clone();
                clone._factoryActions.put(nextFactoryAction.getResourceID(), nextFactoryAction);
            }
        }
        return clone;
    }
}

