/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.io.InputStreamAdapter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceException;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.CacheStatistics;
import com.sas.services.cache.impl.BaseCacheEntry;
import com.sas.services.cache.impl.BaseCacheFactory;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.ChildRepositoryInterface;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.EntityHasChangedException;
import com.sas.services.information.Factory;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.FilterNotSupportedException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.InformationServiceTimerClient;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.MetadataChangeEvent;
import com.sas.services.information.MetadataChangeListener;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryEvent;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import com.sas.services.information.RepositoryUrlMismatchException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.cache.DAVRepositoryCache;
import com.sas.services.information.metadata.Content;
import com.sas.services.information.metadata.DAVAccessControlEntry;
import com.sas.services.information.metadata.FilteredFolder;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.information.metadata.ReferenceIdentity;
import com.sas.services.information.metadata.dav.DAVEntity;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFactory;
import com.sas.services.information.metadata.dav.DAVFolder;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.information.metadata.dav.DAVItem;
import com.sas.services.information.metadata.dav.DAVItemInterface;
import com.sas.services.information.rules.EvaluatorInterface;
import com.sas.services.information.util.ISEntityKey;
import com.sas.services.security.Permission;
import com.sas.services.user.GlobalProfileInterface;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.URIUtil;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DAVResourceInterface;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.SharedResource;
import com.sas.services.webdav.SharedResourceInterface;
import com.sas.services.webdav.TransformerFactoryFactory;
import com.sas.services.webdav.Utils;
import com.sas.services.webdav.Version;
import com.sas.services.webdav.XMLUtil;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVRepository
extends UnicastRemoteObject
implements DAVRepositoryInterface,
MetadataChangeListener,
InformationServiceTimerClient {
    private static final long serialVersionUID = 92000001L;
    private static final int CONNECT_UNTRIED = 0;
    private static final int CONNECT_FAILED = 1;
    private static final int CONNECT_SUCCEEDED = 2;
    private static final int CONNECT_STILL_TRYING = 3;
    private int connectStatus = 0;
    private boolean connectCalled = false;
    private static InformationServiceInterface _is;
    private static final String XML_DOCUMENT_HEADER = "<?xml version=\"1.0\"?>";
    private static final String UPDATE_ID_PROPERTYNAME = "{http://www.sas.com/xml/namespace/services.webdav-1.1}updateId";
    private static final String DAV_COMMENT = "{DAV:}comment";
    private static final String DAV_CREATOR_DISPLAYNAME = "{DAV:}creator-displayname";
    private boolean _https = false;
    private String _proxy = null;
    private Factory _factory = Factory.getInstance();
    private IdentityInterface _person;
    private UserContextInterface _user;
    private String _domain = null;
    @SASScope
    protected String _url = null;
    @SASScope
    protected String _DAVurl = null;
    private String _host = null;
    private int _port;
    private String _isName = null;
    @SASScope
    protected DAVResource _rootResource;
    private URL _rootURL = null;
    private String _rootpw = null;
    private String _rootid = null;
    @SASScope
    protected Properties _OptHdrs = null;
    private String _DAVServer;
    private String _defaultBase;
    @SASScope
    protected DAVRepositoryCache _cache = null;
    private List _listeners;
    private boolean _supportsACL = false;
    private boolean _supportsSEARCH = false;
    @SASScope
    protected ConnectionInfo hostInfo = null;
    @SASScope
    protected boolean _isDestroyed = false;
    private static final String GENERATED_PASSWORD_DOMAIN = "@!*(generatedpassworddomain)*!";
    private static String USERS_PATH;
    private String _uniqueId = null;
    private PersonalRepositoryInterface _pr = null;
    private String userBase = "";
    private Map _factoryMap;
    private SharedResourceInterface sharedResource;
    private boolean _credsWereGenerated = false;
    private static final String P_DESCRIPTION = "{http://www.sas.com/xml/namespace/services.webdav-1.1}description";
    @SASScope
    protected static final TimeZone gmtZone;
    @SASScope
    public static final SimpleDateFormat[] formats;

    public DAVRepository() throws RemoteException {
        this(DAVRepository.class);
    }

    protected DAVRepository(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
        try {
            this._cache = (DAVRepositoryCache)BaseCacheFactory.getCache((String)this.getClass().getName(), (String)"/DAVNode", (ClassLoader)this.getClass().getClassLoader());
        }
        catch (CacheException cex) {
            throw new RuntimeException(cex.getMessage());
        }
        this._defaultBase = null;
        this._listeners = new ArrayList();
        this._factoryMap = new HashMap();
    }

    public static InformationServiceInterface getInformationService() {
        if (_is == null) {
            LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
            try {
                _is = (InformationServiceInterface)discoveryService.findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return _is;
    }

    public static void clearInformationService() {
        _is = null;
    }

    private static String getUserPath(UserContextInterface user) throws RemoteException {
        if (user != null) {
            return user.getName();
        }
        return "Unknown";
    }

    public static String getUrlFromEntityKey(String entityKey) {
        try {
            String s = entityKey.substring(entityKey.indexOf("+") + 1);
            if (s.substring(0, 3).equalsIgnoreCase("dav")) {
                String hostport;
                String testUrl;
                String reposUrl;
                block17: {
                    int ptr = s.lastIndexOf(47);
                    s = "http" + s.substring(3, ptr);
                    reposUrl = null;
                    testUrl = s;
                    hostport = null;
                    try {
                        URI entityURI = new URI(s);
                        String authority = entityURI.getAuthority();
                        int index = authority.indexOf(";");
                        if (index > 0) {
                            try {
                                hostport = URLDecoder.decode(authority.substring(0, index), "UTF-8");
                            }
                            catch (UnsupportedEncodingException usee) {
                                hostport = authority.substring(0, index);
                            }
                            testUrl = entityURI.getScheme() + "://" + hostport + entityURI.getPath();
                            break block17;
                        }
                        try {
                            hostport = URLDecoder.decode(authority, "UTF-8");
                        }
                        catch (UnsupportedEncodingException usee) {
                            hostport = authority;
                        }
                        testUrl = s;
                    }
                    catch (URISyntaxException use) {
                        use.printStackTrace();
                        testUrl = s;
                    }
                }
                reposUrl = DAVRepository.getInformationService().getRepositoryUrl(hostport);
                if (reposUrl != null) {
                    Iterator rdefs = DAVRepository.getInformationService().getReposDefs().iterator();
                    String scheme = null;
                    boolean found = false;
                    while (!found && rdefs.hasNext()) {
                        RepositoryDef rdef = (RepositoryDef)rdefs.next();
                        if (!hostport.equals(rdef.getName())) continue;
                        found = true;
                        scheme = rdef.getIsSecure() ? "https" : "http";
                    }
                    try {
                        String p;
                        URI entityURI = new URI(s);
                        URI repos = new URI(reposUrl);
                        testUrl = scheme + "://" + repos.getHost() + ':' + repos.getPort();
                        String base = repos.getPath();
                        if (base != null && base.length() > 0) {
                            testUrl = URIUtil.addSegment(testUrl, base);
                        }
                        if ((p = entityURI.getPath()) != null && p.length() > 0) {
                            testUrl = URIUtil.addSegment(testUrl, p);
                        }
                    }
                    catch (URISyntaxException use) {
                        use.printStackTrace();
                        testUrl = s;
                    }
                }
                return testUrl;
            }
            return null;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getUserPRInbox(String userid, UserContextInterface uc) throws ServiceException, RemoteException {
        FolderInterface myInbox;
        GlobalProfileInterface gp;
        PersonalRepositoryInterface pr;
        ProfileInterface prf = uc.getProfile();
        if (prf instanceof GlobalProfileInterface && (pr = (gp = (GlobalProfileInterface)prf).getPersonalRepository()) != null && (myInbox = pr.getApplicationManager(1)) != null) {
            MetadataInterface mi;
            RepositoryInterface ri = myInbox.getRepository();
            String userSegment = DAVRepository.getUserPath(uc);
            int p = userSegment.lastIndexOf(47);
            if (p > -1) {
                userSegment = userSegment.substring(p + 1);
            }
            String userPath = myInbox.getPath();
            int p2 = userPath.indexOf("/PR/");
            int p1 = (userPath = userPath.substring(0, p2)).lastIndexOf("/");
            userPath = p1 > -1 ? userPath.substring(0, p1) + '/' + userSegment : userSegment;
            String inboxPath = userPath + "/PR/" + myInbox.getName();
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            permissions.add(new Permission("GRANT", "{DAV:}all", null));
            String principalID = ((DAVRepository)ri).getPrincipalID(null, userid);
            DAVAccessControlEntry ace = null;
            if (principalID != null) {
                ace = new DAVAccessControlEntry(new ReferenceIdentity(principalID), permissions, false, false);
            }
            if ((mi = ri.fetch(inboxPath + "/folder")) == null) {
                mi = ri.fetch(userPath + "/person");
                if (mi == null) {
                    mi = DAVRepository.make(ri, userPath + "/person", userPath, "person");
                    if (mi != null) {
                        if (((DAVRepositoryInterface)ri).supportsACL() && ace != null) {
                            mi.addAccessControl(ace);
                            mi.update();
                        }
                        if (mi != null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/personalrepository", "PR", "personalrepository");
                        }
                        if (mi != null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyResults/folder", "MyResults", "folder");
                        }
                        if (mi != null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyDocuments/folder", "MyDocuments", "folder");
                        }
                        if (mi != null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyInbox/folder", "MyInbox", "folder");
                        }
                    } else {
                        userPath = "PR-Storage/" + userPath;
                        mi = ri.fetch(userPath + "/person");
                        if (mi == null) {
                            mi = DAVRepository.make(ri, userPath + "/person", userPath, "person");
                            if (mi != null) {
                                mi = DAVRepository.make(ri, userPath + "/PR/personalrepository", "PR", "personalrepository");
                            }
                            if (mi != null) {
                                mi = DAVRepository.make(ri, userPath + "/PR/MyResults/folder", "MyResults", "folder");
                            }
                            if (mi != null) {
                                mi = DAVRepository.make(ri, userPath + "/PR/MyDocuments/folder", "MyDocuments", "folder");
                            }
                            if (mi != null) {
                                mi = DAVRepository.make(ri, userPath + "/PR/MyInbox/folder", "MyInbox", "folder");
                            }
                        } else {
                            mi = ri.fetch(userPath + "/PR/MyInbox/folder");
                        }
                    }
                } else {
                    mi = ri.fetch(userPath + "/PR/personalrepository");
                    if (mi == null) {
                        mi = DAVRepository.make(ri, userPath + "/PR/personalrepository", "PR", "personalrepository");
                        if (mi != null && ((DAVRepositoryInterface)ri).supportsACL() && ace != null) {
                            mi.addAccessControl(ace);
                            mi.update();
                        }
                        if (mi != null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyResults/folder", "MyResults", "folder");
                        }
                        if (mi != null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyDocuments/folder", "MyDocuments", "folder");
                        }
                        if (mi != null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyInbox/folder", "MyInbox", "folder");
                        }
                    } else {
                        mi = ri.fetch(userPath + "/PR/MyResults/folder");
                        if (mi == null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyResults/folder", "MyResults", "folder");
                        }
                        if (mi != null && ((DAVRepositoryInterface)ri).supportsACL() && ace != null) {
                            mi.addAccessControl(ace);
                            mi.update();
                        }
                        if ((mi = ri.fetch(userPath + "/PR/MyDocuments/folder")) == null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyDocuments/folder", "MyDocuments", "folder");
                        }
                        if (mi != null && ((DAVRepositoryInterface)ri).supportsACL() && ace != null) {
                            mi.addAccessControl(ace);
                            mi.update();
                        }
                        if ((mi = ri.fetch(userPath + "/PR/MyInbox/folder")) == null) {
                            mi = DAVRepository.make(ri, userPath + "/PR/MyInbox/folder", "MyInbox", "folder");
                        }
                        if (mi != null && ((DAVRepositoryInterface)ri).supportsACL() && ace != null) {
                            mi.addAccessControl(ace);
                            mi.update();
                        }
                    }
                }
            }
            if (mi != null) {
                return mi.getEntityURL();
            }
        }
        return null;
    }

    private static MetadataInterface make(RepositoryInterface ri, String path, String name, String type) throws RemoteException {
        MetadataInterface mi = null;
        try {
            mi = ri.newMetadata(path, name, type);
            ri.addEntity(mi);
        }
        catch (ServiceException se) {
            mi = null;
        }
        return mi;
    }

    @Override
    public void setISName(String name) throws RemoteException {
        if (name != null && name.length() > 0) {
            this._isName = name;
        }
    }

    @Override
    public String getISName() throws RemoteException {
        if (this._isName != null) {
            return this._isName;
        }
        InformationServiceInterface is = DAVRepository.getInformationService();
        List defs = is.getReposDefs();
        for (RepositoryDef rd : defs) {
            if (!rd.getProtocol().equalsIgnoreCase("dav") || !rd.getHost().equalsIgnoreCase(this._host) || !rd.getPort().equals(String.valueOf(this._port)) || this._defaultBase == null || !rd.getBase().equalsIgnoreCase(this._defaultBase)) continue;
            return rd.getName();
        }
        return null;
    }

    @Override
    public void setUserContext(UserContextInterface user) throws RemoteException {
        this._user = user;
    }

    @Override
    public UserContextInterface getUserContext() throws RemoteException {
        return this._user;
    }

    @Override
    public void setUser(PersonInterface person) throws RemoteException {
        this._person = person;
    }

    @Override
    public PersonInterface getUser() throws RemoteException {
        if (this._person instanceof PersonInterface) {
            return (PersonInterface)this._person;
        }
        return null;
    }

    @Override
    public IdentityInterface getIdentity() throws RemoteException {
        return this._person;
    }

    @Override
    public MetadataInterface newMetadata(String repositoryId, String name, String type) throws ServiceException, RemoteException {
        this.checkConnect();
        MetadataInterface mi = null;
        DAVEntityInterface de = DAVFactory.newDAVEntity(type, repositoryId, this);
        try {
            mi = this._factory.processWithRepository(de, this);
            if (mi == null) {
                mi = de instanceof DAVItem ? new Content(de) : new Folder(de);
                mi.setRepository(this);
            }
        }
        catch (ServiceException se) {
            se.printStackTrace(System.err);
        }
        mi.setName(name);
        return mi;
    }

    @Override
    @Deprecated
    public MetadataInterface newMetadata(MetadataInterface model, String name) throws ServiceException, RemoteException {
        return this.newMetadataByModel(model, name);
    }

    @Override
    public MetadataInterface newMetadataByModel(MetadataInterface model, String name) throws ServiceException, RemoteException {
        this.checkConnect();
        try {
            DAVEntityInterface de = (DAVEntityInterface)model.getRepositoryEntity();
            String objectType = de.getType();
            String reposId = de.getReposId();
            int index = reposId.lastIndexOf("/");
            String reposIdwoType = reposId.substring(0, index);
            String reposType = reposId.substring(index + 1);
            index = reposIdwoType.lastIndexOf("/");
            String parentReposIdwoType = reposIdwoType.substring(0, index + 1);
            String newReposIdwoType = parentReposIdwoType + name;
            return this.newMetadata(newReposIdwoType + '/' + reposType, name, objectType);
        }
        catch (ClassCastException cce) {
            throw new ServiceException(RB.getStringResource("DAVRepository.newwrongtyp.ex.txt"));
        }
        catch (Throwable t) {
            if (t instanceof ServiceException) {
                throw (ServiceException)((Object)t);
            }
            throw new ServiceException(t, RB.getStringResource("DAVRepository.newmetadataex.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataInterface fetch(String repositoryKey, boolean bypassCache) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        MetadataInterface mi = null;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.fetchmsg.fmt.txt", (Object)repositoryKey, (Object)this.getUrl()));
        }
        if (repositoryKey == null) {
            return null;
        }
        if (repositoryKey.length() > 0 && repositoryKey.charAt(0) == '$') {
            repositoryKey = this.expand(repositoryKey);
        }
        if (!bypassCache && (mi = this._cache.get(repositoryKey)) != null) {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.cacheused.fmt.txt", (Object)repositoryKey));
            }
            return mi;
        }
        String entityUrl = this.reposId2EntityUrl(repositoryKey);
        if (entityUrl != null) {
            DAVResourceInterface _r = null;
            HashMap<String, PropertyMap> resourceMap = new HashMap<String, PropertyMap>();
            try {
                _r = this.connectToResource(entityUrl);
                if (_r == null) {
                    MetadataInterface metadataInterface = null;
                    return metadataInterface;
                }
                entityUrl = this.fetchProperties(_r, resourceMap, 0);
            }
            finally {
                this.freeResource();
            }
            PropertyMap pmap = (PropertyMap)resourceMap.get(entityUrl);
            if (pmap == null) {
                return null;
            }
            Map<String, String> mpmap = this.extractPropertyStrings(pmap);
            String resourceType = mpmap.get("{http://www.sas.com/rnd/itech/WebDAV}type");
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.resourcetype.fmt.txt", (Object)resourceType));
            }
            RepositoryData tmpEntity = new RepositoryData(mpmap);
            tmpEntity.setReposId(repositoryKey);
            tmpEntity.setRepository(this);
            DAVEntityInterface entity = (DAVEntityInterface)DAVFactory.narrow(tmpEntity);
            Object aclProperty = pmap.get((Object)"{DAV:}acl");
            if (aclProperty != null) {
                try {
                    Element acl = ((DavPropertyItem)aclProperty).getDavProperty().toXml(XMLUtil.newDocument());
                    entity.setACL(XML_DOCUMENT_HEADER + com.sas.services.util.XMLUtil.node2String(acl));
                }
                catch (ParserConfigurationException e) {
                    throw new ServiceException(e, RB.getStringResource("DAVRepository.parsererr.ex.txt"));
                }
            }
            try {
                mi = this._factory.processWithRepository(entity, this);
                if (mi != null) {
                    this._cache.put(mi);
                    return mi;
                }
            }
            catch (ServiceException e) {
                if (logger != null) {
                    logger.info(RB.getStringResource("DAVRepository.facterr.ex.txt"), (Throwable)((Object)e));
                }
                mi = new Folder(entity);
                mi.setRepository(this);
                this._cache.put(mi);
                return mi;
            }
        }
        return null;
    }

    @Override
    public MetadataInterface fetchByUrl(String entityURL, boolean bypassCache) throws ServiceException, RemoteException {
        this.checkConnect();
        URI entityURI = null;
        try {
            entityURI = new URI(entityURL);
        }
        catch (URISyntaxException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        String scheme = entityURI.getScheme().toLowerCase();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            String relpath = URIUtil.url1StartsWithUrl2(entityURL, this._url);
            if (relpath == null) {
                throw new RepositoryUrlMismatchException();
            }
            String key = null;
            key = relpath.startsWith("/") ? relpath.substring(1) + "/type" : relpath + "/type";
            return this.fetch(key, bypassCache);
        }
        throw new RepositoryUrlMismatchException();
    }

    @Override
    public MetadataInterface fetch(String repositoryKey) throws ServiceException, RemoteException {
        return this.fetch(repositoryKey, false);
    }

    @Override
    public List search(FilterInterface filter) throws ServiceException, RemoteException {
        List protocols = filter.getProtocols();
        if (protocols != null && protocols.size() > 0 && !protocols.contains("dav")) {
            return Collections.EMPTY_LIST;
        }
        this.checkConnect();
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        URL thisURL = null;
        try {
            thisURL = new URL(this.getHttpUrl());
        }
        catch (MalformedURLException e) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.badUrl.ex.fmt", (Object)this.getHttpUrl()));
        }
        Map resultMap = this.doSearch(filter);
        for (Map.Entry me : resultMap.entrySet()) {
            String reposId;
            String tempurl;
            String newurl;
            String resultUrl = (String)me.getKey();
            Object o = me.getValue();
            if (o == null) continue;
            if (o instanceof String) {
                MetadataInterface mi;
                newurl = (String)o;
                if (newurl.indexOf("://") < 0) {
                    tempurl = thisURL.getProtocol() + "://" + thisURL.getHost();
                    if (thisURL.getPort() != -1 && thisURL.getPort() != 80) {
                        tempurl = tempurl + (58 + thisURL.getPort());
                    }
                    newurl = tempurl + newurl;
                }
                if ((mi = this.fetch(Utils.addSegment((String)(reposId = this.getReposIdwoTypeFromUrl(newurl)), (String)"entity"))) == null) continue;
                results.add(mi);
                continue;
            }
            newurl = resultUrl;
            if (newurl.indexOf("://") < 0) {
                tempurl = thisURL.getProtocol() + "://" + thisURL.getHost();
                if (thisURL.getPort() != -1 && thisURL.getPort() != 80) {
                    tempurl = tempurl + (58 + thisURL.getPort());
                }
                newurl = tempurl + newurl;
            }
            reposId = Utils.addSegment((String)this.getReposIdwoTypeFromUrl(newurl), (String)"type");
            PropertyMap pMap = (PropertyMap)o;
            Map<String, String> mpMap = this.extractPropertyStrings(pMap);
            RepositoryData tmpEntity = new RepositoryData(mpMap);
            tmpEntity.setReposId(reposId);
            tmpEntity.setRepository(this);
            DAVEntityInterface entity = (DAVEntityInterface)DAVFactory.narrow(tmpEntity);
            MetadataInterface mi = this._factory.processWithRepository(entity, this);
            if (mi == null) {
                mi = entity instanceof DAVItem ? new Content(entity) : new Folder(entity);
                mi.setRepository(this);
            }
            mi.setName(entity.getName());
            this._cache.put(mi);
            results.add(mi);
        }
        return results;
    }

    @Override
    public boolean connect(String user, String password, RepositoryDef config) throws ServiceException, RemoteException {
        boolean isSecure;
        String proxy;
        String base;
        int port;
        String host = config.getHost();
        boolean success = this.connectWithProxy(host, port = Integer.parseInt(config.getPort()), user, password, base = config.getBase(), proxy = config.getProxy(), isSecure = config.getIsSecure());
        if (success) {
            this._domain = config.getDomain();
        }
        return success;
    }

    @Override
    public boolean connectWithProxy(String host, int port, String id, String password, String base, String proxy, boolean isSecure) throws ServiceException, RemoteException {
        block17: {
            Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
            this.connectCalled = true;
            this._rootid = id;
            if (this._rootid != null && this._rootid.indexOf(GENERATED_PASSWORD_DOMAIN) > 0) {
                this._credsWereGenerated = true;
            }
            this._rootpw = password;
            this._host = host;
            this._port = port;
            this._pr = null;
            this._https = isSecure;
            this._proxy = proxy;
            String string = this._url = this._https ? "https://" + host + ':' + port + '/' : "http://" + host + ':' + port + '/';
            if (base == null || base.equals("/")) {
                base = "";
            }
            if (base.length() > 0) {
                this._url = URIUtil.addSegment(this._url, base);
            }
            try {
                this._rootURL = new URL(this._url);
            }
            catch (MalformedURLException mue) {
                if (logger != null) {
                    logger.warn(RB.getStringResource("DAVRepository.invaliduri.txt"));
                }
                return false;
            }
            this._DAVurl = "dav://" + host + ':' + port + '/';
            if (base.length() > 0) {
                if (base.charAt(0) == '/') {
                    base = base.length() > 1 ? base.substring(1) : "";
                }
                try {
                    URI _uri = new URI("dav", null, host, port, '/' + base, null, null);
                    this._DAVurl = _uri.toString();
                }
                catch (URISyntaxException use) {
                    if (logger != null) {
                        logger.warn(RB.getStringResource("DAVRepository.invaliduri.txt"));
                    }
                    this._DAVurl = URIUtil.addSegment(this._DAVurl, base);
                }
            }
            try {
                this._cache = (DAVRepositoryCache)BaseCacheFactory.getCache((String)this.getClass().getName(), (String)"/DAVNode", (ClassLoader)this.getClass().getClassLoader());
            }
            catch (CacheException cex) {
                throw new RuntimeException(cex.getMessage());
            }
            this._defaultBase = base;
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.cncntohst.ex.fmt.txt", (Object)this._url, (Object)id));
            }
            this.hostInfo = new ConnectionInfo(this._url, id, password);
            if (proxy != null && proxy.length() > 0) {
                try {
                    URL proxyURL = new URL(proxy);
                    this.hostInfo.setProxyHost(proxyURL.getHost());
                    this.hostInfo.setProxyPort(proxyURL.getPort());
                }
                catch (MalformedURLException e) {
                    if (logger == null) break block17;
                    logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.badproxyurl.fmt.txt", (Object)proxy));
                }
            }
        }
        return true;
    }

    @Override
    public boolean connect(String host, int port, String id, String password, String base) throws ServiceException, RemoteException {
        return this.connectWithProxy(host, port, id, password, base, null, false);
    }

    @Override
    public void deleteEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        Object o = input.getRepositoryEntity();
        if (!(o instanceof DAVEntity)) {
            return;
        }
        DAVEntityInterface d = (DAVEntityInterface)o;
        String reposId = d.getReposId();
        if (reposId.startsWith("$")) {
            reposId = this.expand(reposId);
        }
        String deleteUrl = this.reposId2EntityUrl(reposId);
        if (input instanceof FolderInterface) {
            this.removeChildren((FolderInterface)input);
        }
        this._cache.remove(reposId);
        try {
            DAVResourceInterface _r = this.connectToResource(deleteUrl);
            if (_r == null) {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.delerr.fmt.txt", (Object)deleteUrl));
                }
                return;
            }
            _r.delete();
            if (!_r.SUCCEEDED()) {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.delerr.fmt.txt", (Object)deleteUrl));
                }
            } else if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.deldone.fmt.txt", (Object)deleteUrl));
            }
        }
        catch (DAVException e) {
            throw new ServiceException(e, RB.getStringResource("DAVRepository.delexch.ex.txt"));
        }
        finally {
            this.freeResource();
        }
    }

    @Override
    public void addEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        Object o = input.getRepositoryEntity();
        if (!(o instanceof DAVEntity)) {
            return;
        }
        DAVEntityInterface de = (DAVEntityInterface)o;
        String reposId = de.getReposId();
        if (reposId.length() > 0 && reposId.charAt(0) == '$') {
            reposId = this.expand(reposId);
            de.setReposId(reposId);
        }
        String addUrl = this.reposId2EntityUrl(reposId);
        try {
            int _status;
            this.hostInfo.setUrl(addUrl);
            DAVResourceInterface _r = this.connectToResource(addUrl);
            if (de instanceof DAVFolder) {
                _r.makeCollection();
                _status = _r.getStatusCode();
                if (_status != 201) {
                    if (_status == 405) {
                        throw new ServiceException((Throwable)((Object)new ItemAlreadyExistsException("")), Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.alreadyexists.ex.fmt.txt", (Object)addUrl));
                    }
                    String errText = "HTTP status code " + _status;
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.adderr.ex.fmt.txt", (Object)addUrl, (Object)errText));
                }
            } else {
                _status = _r.getStatusCode();
                if (_status != 404) {
                    if (_status == 200) {
                        throw new ServiceException((Throwable)((Object)new ItemAlreadyExistsException("")), Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.alreadyexists.ex.fmt.txt", (Object)addUrl));
                    }
                    String errText = "HTTP status code " + _status;
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.adderr.ex.fmt.txt", (Object)addUrl, (Object)errText));
                }
                DAVItemInterface di = (DAVItemInterface)de;
                String contentType = di.getContentType();
                InputStream in = di.getContents();
                _r.setContentType(contentType);
                _r.setContents(in);
                if (415 == _r.getStatusCode()) {
                    String errText = " HTTP status code 415";
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.adderr.ex.fmt.txt", (Object)addUrl, (Object)errText));
                }
                di.setContentsStatus(2);
            }
            String eType = de.getType();
            if (!"unknown".equals(eType) && !"folder".equalsIgnoreCase(eType)) {
                de.setAttribute("{http://www.sas.com/rnd/itech/WebDAV}type", de.getType());
            }
            Map _setUpdates = de.getSetUpdates();
            Map _removeUpdates = de.getRemoveUpdates();
            this.processChanges(_r, _setUpdates, true);
            this.processChanges(_r, _removeUpdates, false);
            String aclDocument = de.getUpdateableACL();
            if (aclDocument != null) {
                try {
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.addacl.fmt.txt", (Object)_r.getURL().toString(), (Object)aclDocument));
                    }
                    _r.setACL(aclDocument);
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.addaclresult.fmt.txt", (Object)_r.getStatusCode()));
                    }
                }
                catch (DAVException e) {
                    throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.addaclresult.fmt.txt", (Object)e.getStatusCode()));
                }
            }
            ((DAVEntity)de).clearLocalLists();
        }
        catch (DAVException e) {
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.adderr.ex.fmt.txt", (Object)addUrl, (Object)""));
        }
        finally {
            this.freeResource();
        }
    }

    @Override
    public String getUrl() throws RemoteException {
        return this._DAVurl;
    }

    @Override
    public String getDomain() throws RemoteException {
        return this._domain;
    }

    @Override
    public void setDomain(String domain) throws RemoteException {
        this._domain = domain;
    }

    @Override
    public String getHost() throws RemoteException {
        return this._host;
    }

    @Override
    public int getPort() throws RemoteException {
        return this._port;
    }

    @Override
    public String getPrincipal() throws RemoteException {
        return this._rootid;
    }

    @Override
    public String getBase() throws RemoteException {
        return this._defaultBase;
    }

    @Override
    @Deprecated
    public MetadataInterface getTrackedObject(int trackingId) throws RemoteException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws RemoteException {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        InformationServiceInterface is = DAVRepository.getInformationService();
        if (is != null) {
            is.removeMetadataChangeListener(this, this._url);
            try {
                is.removeInformationServiceTimerClient(this);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        if (logger != null) {
            logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.closing.ex.fmt", (Object)this._rootURL));
        }
        this._rootURL = null;
        this._rootid = null;
        this._rootpw = null;
        this._proxy = null;
        this._https = false;
        this._pr = null;
        if (this._rootResource != null) {
            this._cache.printStats();
            this._rootResource.close();
        }
        if (this._cache != null) {
            this._cache.clear(true);
            this._cache = null;
        }
        this._rootResource = null;
        this.sharedResource = null;
        this._user = null;
        this._person = null;
        if (this._listeners != null) {
            this.notifyListeners(3);
            List list = this._listeners;
            synchronized (list) {
                this._listeners.clear();
                this._listeners = null;
            }
        }
        try {
            DAVRepository.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.connectCalled = false;
        this.connectStatus = 0;
    }

    @Override
    public void addRootFolder(FolderInterface folder) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("DAVRepository.adminroot.msg.txt"));
    }

    @Override
    public FolderInterface removeRootFolder(String folderName) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("DAVRepository.adminroot.msg.txt"));
    }

    @Override
    public FolderInterface getRootFolder(String name) throws ServiceException, RemoteException {
        return (FolderInterface)this.fetch(Utils.addSegment((String)name, (String)"folder"));
    }

    @Override
    public List getRootFolders() throws ServiceException, RemoteException {
        this.checkConnect();
        ArrayList<FolderInterface> results = new ArrayList<FolderInterface>();
        FolderInterface f2 = (FolderInterface)this.fetch("/top");
        for (FolderInterface f2 : f2.getSubfolders()) {
            results.add(f2);
        }
        return results;
    }

    @Override
    public MetadataInterface getObjectByPath(PathUrl url) throws ServiceException, RemoteException {
        this.checkConnect();
        String reposId = Utils.addSegment((String)url.getRootTree(), (String)url.getPath());
        reposId = Utils.addSegment((String)reposId, (String)url.getName());
        reposId = Utils.addSegment((String)reposId, (String)"type");
        return this.fetch(reposId);
    }

    @Override
    @Deprecated
    public MetadataInterface getObjectByPath(String rootFolderName, String path, Class type) throws ServiceException, RemoteException {
        String className = type.getName();
        int index = className.lastIndexOf(".");
        className = className.substring(index + 1);
        return this.getObjectByPathString(rootFolderName, path, className);
    }

    @Override
    @Deprecated
    public MetadataInterface getObjectByPath(String rootFolderName, String path, String type) throws ServiceException, RemoteException {
        return this.getObjectByPathString(rootFolderName, path, type);
    }

    @Override
    public MetadataInterface getObjectByPathString(String rootFolderName, String path, String type) throws ServiceException, RemoteException {
        String pathName = null;
        int index = path.lastIndexOf("/");
        if (index < 0) {
            pathName = path;
            path = null;
        } else {
            pathName = path.substring(index + 1);
            path = path.substring(0, index);
        }
        PathUrl purl = new PathUrl(this.getISName(), rootFolderName, path, pathName, type);
        return this.getObjectByPath(purl);
    }

    @Override
    public FilteredFolderInterface searchTree(String rootFolderName, FilterInterface filter) throws ServiceException, RemoteException {
        String TOPLEVEL_FOLDER = "/type";
        MetadataInterface mi = this.fetch(TOPLEVEL_FOLDER);
        if (mi == null) {
            return null;
        }
        DAVFolderInterface folder = (DAVFolderInterface)mi.getRepositoryEntity();
        return this.searchTree(folder, filter, -1);
    }

    @Override
    @Deprecated
    public FilteredFolderInterface searchTree(FolderInterface baseFolder, FilterInterface filter) throws ServiceException, RemoteException {
        return this.searchTreeFromBase(baseFolder, filter);
    }

    @Override
    public FilteredFolderInterface searchTreeFromBase(FolderInterface baseFolder, FilterInterface filter) throws ServiceException, RemoteException {
        if (baseFolder == null) {
            return null;
        }
        DAVFolderInterface folder = (DAVFolderInterface)baseFolder.getRepositoryEntity();
        return this.searchTree(folder, filter, -1);
    }

    @Override
    public FilteredFolderInterface searchTreeFromBaseWithScope(FolderInterface baseFolder, FilterInterface filter, int levels) throws ServiceException, RemoteException {
        if (baseFolder == null) {
            return null;
        }
        DAVFolderInterface folder = (DAVFolderInterface)baseFolder.getRepositoryEntity();
        return this.searchTree(folder, filter, levels);
    }

    public FilteredFolderInterface searchTree(DAVFolderInterface folder, FilterInterface filter, int levels) throws ServiceException, RemoteException {
        this.checkConnect();
        FolderInterface realFolder = (FolderInterface)this._factory.processWithRepository(folder, this);
        FilteredFolder results = new FilteredFolder(null, realFolder);
        results.setRepository(this);
        List protocols = filter.getProtocols();
        if (protocols != null && protocols.size() > 0 && !protocols.contains("omi")) {
            return results;
        }
        if (folder == null) {
            return null;
        }
        if (filter == null) {
            return null;
        }
        if (levels < 0) {
            filter.setDAVScope(2);
        } else if (levels == 0) {
            filter.setDAVScope(0);
        } else if (levels == 1) {
            filter.setDAVScope(1);
        } else {
            filter.setDAVScope(2);
        }
        String folderUrl = folder.getUrl();
        filter.setDAVBase(folderUrl);
        List searchCandidates = this.search(filter);
        TreeMap sortedCandidates = new TreeMap();
        Iterator<Object> it = searchCandidates.iterator();
        String ridfolder = null;
        while (it.hasNext()) {
            List<MetadataInterface> scItems;
            String ridpath;
            int p;
            MetadataInterface mi = (MetadataInterface)it.next();
            String rid = mi.getReposId();
            String itemUrl = ((DAVEntityInterface)mi.getRepositoryEntity()).getUrl();
            if (itemUrl != null && itemUrl.equals(folderUrl) || (p = (ridpath = rid.substring(0, rid.lastIndexOf(47))).lastIndexOf(47)) <= 0) continue;
            ridfolder = ridpath.substring(0, ridpath.lastIndexOf(47));
            if (sortedCandidates.containsKey(ridfolder)) {
                scItems = (List)sortedCandidates.get(ridfolder);
                scItems.add(mi);
                continue;
            }
            scItems = new ArrayList();
            scItems.add(mi);
            sortedCandidates.put(ridfolder, scItems);
        }
        HashMap<String, FilteredFolder> ffMap = new HashMap<String, FilteredFolder>();
        String folderpath = realFolder.getReposId();
        folderpath = folderpath.substring(0, folderpath.lastIndexOf(47));
        ffMap.put(folderpath, results);
        String resultsFolderPath = folderpath;
        for (Map.Entry entry : sortedCandidates.entrySet()) {
            folderpath = (String)entry.getKey();
            MetadataInterface mi = this.fetch(folderpath + "/type");
            if (!(mi instanceof FolderInterface)) continue;
            realFolder = (FolderInterface)mi;
            Iterator items = ffMap.keySet().iterator();
            int l = 0;
            String keyfound = null;
            while (items.hasNext()) {
                String f = (String)items.next();
                if (!folderpath.startsWith(f) || f.length() < l) continue;
                l = f.length();
                keyfound = f;
            }
            FilteredFolderInterface parent = (FilteredFolderInterface)ffMap.get(keyfound);
            FilteredFolder ffi = null;
            if (!folderpath.equals(resultsFolderPath)) {
                ffi = new FilteredFolder(parent, realFolder);
                ffi.setRepository(this);
                parent.addSubfolder(ffi);
                ffMap.put(folderpath, ffi);
            } else {
                ffi = results;
            }
            List resultsInFolder = (List)entry.getValue();
            Iterator resultItems = resultsInFolder.iterator();
            while (resultItems.hasNext()) {
                ffi.addLocalItem((MetadataInterface)resultItems.next());
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List browseSearch(FilterInterface filter) throws ServiceException, RemoteException {
        this.checkConnect();
        ArrayList<BrowseMetadata> result = new ArrayList<BrowseMetadata>();
        Map results = this.doSearch(filter);
        for (Map.Entry me : results.entrySet()) {
            PropertyMap rMap;
            String resultUrl = (String)me.getKey();
            Object o = me.getValue();
            if (o instanceof String) {
                if (resultUrl.indexOf("://") == -1) {
                    resultUrl = (this.getHttps() ? "https://" : "http://") + this.getHost() + ':' + this.getPort() + resultUrl;
                }
                HashMap<String, PropertyMap> _map = new HashMap<String, PropertyMap>();
                try {
                    DAVResourceInterface r = this.connectToResource(resultUrl);
                    resultUrl = this.fetchProperties(r, _map, 0);
                }
                finally {
                    this.freeResource();
                }
                rMap = (PropertyMap)_map.get(resultUrl);
            } else {
                rMap = (PropertyMap)o;
            }
            Map<String, String> rawData = this.extractPropertyStrings(rMap);
            rawData.put("Url", resultUrl);
            this.updateMap(rawData);
            result.add(new BrowseMetadata(rawData));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowseMetadataInterface browseFetch(String entityKey, FilterInterface filter) throws ServiceException, RemoteException {
        String realUrl;
        this.checkConnect();
        if (entityKey == null) {
            return null;
        }
        BrowseMetadata result = new BrowseMetadata(new HashMap());
        String reposId = null;
        try {
            String reposKey;
            ISEntityKey iseKey = new ISEntityKey(entityKey);
            String repository = iseKey.getRepository();
            if (!repository.equalsIgnoreCase(this.getISName())) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.wrongrepos.ex.fmt.txt", (Object)entityKey));
            }
            reposId = reposKey = iseKey.getRepositoryKey();
        }
        catch (IllegalArgumentException iaex) {
            reposId = entityKey;
        }
        String path = this.reposId2EntityUrl(reposId);
        HashMap<String, PropertyMap> rMap = new HashMap<String, PropertyMap>();
        try {
            DAVResourceInterface r = this.connectToResource(path);
            realUrl = this.fetchProperties(r, rMap, 0);
        }
        finally {
            this.freeResource();
        }
        Map<String, String> rawData = this.extractPropertyStrings((PropertyMap)rMap.get(realUrl));
        rawData.put("Url", realUrl);
        this.updateMap(rawData);
        result = new BrowseMetadata(rawData);
        return result;
    }

    @Override
    public List browseFolder(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        this.checkConnect();
        String reposId = null;
        if (folderISEntityKey == null) {
            throw new IllegalArgumentException();
        }
        FilterInterface _filter = filter;
        if (_filter == null) {
            _filter = new Filter();
        }
        try {
            String reposKey;
            ISEntityKey iseKey = new ISEntityKey(folderISEntityKey);
            String repository = iseKey.getRepository();
            if (!repository.equalsIgnoreCase(this.getISName())) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.wrongrepos.ex.fmt.txt", (Object)folderISEntityKey));
            }
            reposId = reposKey = iseKey.getRepositoryKey();
        }
        catch (IllegalArgumentException iaex) {
            reposId = folderISEntityKey;
        }
        String path = this.reposId2EntityUrl(reposId);
        _filter.setDAVBase(path);
        _filter.setDAVScope(1);
        List results = this.browseSearch(_filter);
        ListIterator _items = results.listIterator();
        while (_items.hasNext()) {
            BrowseMetadataInterface b = (BrowseMetadataInterface)_items.next();
            if (!Utils.isSameUrl((String)((String)b.get("Url")), (String)path)) continue;
            _items.remove();
            break;
        }
        return results;
    }

    @Override
    public List browseFolderRecursive(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        this.checkConnect();
        String reposId = null;
        if (folderISEntityKey == null) {
            throw new IllegalArgumentException();
        }
        FilterInterface _filter = filter;
        if (_filter == null) {
            _filter = new Filter();
        }
        try {
            String reposKey;
            ISEntityKey iseKey = new ISEntityKey(folderISEntityKey);
            String repository = iseKey.getRepository();
            if (!repository.equalsIgnoreCase(this.getISName())) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.wrongrepos.ex.fmt.txt", (Object)folderISEntityKey));
            }
            reposId = reposKey = iseKey.getRepositoryKey();
        }
        catch (IllegalArgumentException iaex) {
            reposId = folderISEntityKey;
        }
        String path = this.reposId2EntityUrl(reposId);
        _filter.setDAVBase(path);
        _filter.setDAVScope(2);
        List results = this.browseSearch(_filter);
        if (filter == null) {
            TreeMap<String, BrowseMetadataInterface> treeMap = new TreeMap<String, BrowseMetadataInterface>();
            for (int i = 0; i < results.size(); ++i) {
                BrowseMetadataInterface bmi = (BrowseMetadataInterface)results.get(i);
                String _ek = bmi.getISEntityKey();
                String _reposId = new ISEntityKey(_ek).getRepositoryKey();
                String _reposPath = _reposId.substring(0, _reposId.lastIndexOf("/"));
                treeMap.put(_reposPath, bmi);
            }
            Iterator items = treeMap.entrySet().iterator();
            ArrayList<BrowseMetadataInterface> _results = new ArrayList<BrowseMetadataInterface>();
            if (items.hasNext()) {
                Map.Entry me = items.next();
                BrowseMetadataInterface bmi = (BrowseMetadataInterface)me.getValue();
                _results.add(bmi);
            }
            while (items.hasNext()) {
                List<Map> members;
                Map parent;
                BrowseMetadataInterface bmiParent;
                Map.Entry me = items.next();
                String _reposId = (String)me.getKey();
                BrowseMetadataInterface bmiCurrent = (BrowseMetadataInterface)me.getValue();
                Map rawData = bmiCurrent.getRawData();
                String _parent = _reposId.substring(0, _reposId.lastIndexOf("/"));
                if (_parent.length() == 0) {
                    _parent = "/";
                }
                if (!treeMap.containsKey(_parent)) continue;
                if (bmiCurrent.isAFolder()) {
                    List<Map> folders;
                    bmiParent = (BrowseMetadataInterface)treeMap.get(_parent);
                    parent = bmiParent.getRawData();
                    if (parent.containsKey("SubTrees")) {
                        folders = (List)parent.get("SubTrees");
                    } else {
                        folders = new ArrayList();
                        parent.put("SubTrees", folders);
                    }
                    folders.add(rawData);
                    continue;
                }
                bmiParent = (BrowseMetadataInterface)treeMap.get(_parent);
                parent = bmiParent.getRawData();
                if (parent.containsKey("Members")) {
                    members = (List)parent.get("Members");
                } else {
                    members = new ArrayList();
                    parent.put("Members", members);
                }
                members.add(rawData);
            }
            BrowseMetadataInterface bmi = (BrowseMetadataInterface)_results.get(0);
            _results.clear();
            List entities = (List)bmi.get("Members");
            if (entities != null) {
                for (int i = 0; i < entities.size(); ++i) {
                    _results.add((BrowseMetadataInterface)entities.get(i));
                }
            }
            if ((entities = (List)bmi.get("SubTrees")) != null) {
                for (int i = 0; i < entities.size(); ++i) {
                    _results.add((BrowseMetadataInterface)entities.get(i));
                }
            }
            return _results;
        }
        ListIterator _items = results.listIterator();
        while (_items.hasNext()) {
            BrowseMetadataInterface b = (BrowseMetadataInterface)_items.next();
            if (!Utils.isSameUrl((String)((String)b.get("Url")), (String)path)) continue;
            _items.remove();
            break;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowseMetadataInterface browseObjectByPath(PathUrl pathUrl, FilterInterface filter) throws ServiceException, RemoteException {
        this.checkConnect();
        BrowseMetadata result = null;
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        if (this.isEqualNotNull(pathUrl.getRepository(), this.getISName())) {
            String realUrl;
            String _name;
            String _path;
            String _rootTree = pathUrl.getRootTree();
            if (_rootTree == null) {
                _rootTree = "";
            }
            if ((_path = pathUrl.getPath()) == null) {
                _path = "";
            }
            if ((_name = pathUrl.getName()) == null) {
                _name = "";
            }
            String reposPath = Utils.addSegment((String)_rootTree, (String)_path);
            reposPath = Utils.addSegment((String)reposPath, (String)_name);
            String path = Utils.addSegment((String)this.getHttpUrl(), (String)reposPath);
            HashMap<String, PropertyMap> rMap = new HashMap<String, PropertyMap>();
            try {
                DAVResourceInterface r = this.connectToResource(path);
                realUrl = this.fetchProperties(r, rMap, 0);
            }
            finally {
                this.freeResource();
            }
            Map<String, String> rawData = this.extractPropertyStrings((PropertyMap)rMap.get(realUrl));
            rawData.put("Url", realUrl);
            this.updateMap(rawData);
            result = new BrowseMetadata(rawData);
        } else {
            Object[] args = new Object[]{this.getISName(), pathUrl};
            logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.badPathUrl.ex.fmt", (Object[])args));
        }
        return result;
    }

    @Override
    public void addListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this._listeners.remove(listener);
    }

    @Override
    public ChildRepositoryInterface newChild() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public String getUniqueId() throws RemoteException {
        if (this._uniqueId != null) {
            return this._uniqueId;
        }
        this._uniqueId = new VMID().toString() + ':' + this.hashCode();
        return this._uniqueId;
    }

    @Override
    public MetadataInterface factoryProcess(Object o) throws ServiceException, RemoteException {
        try {
            DAVEntity root = (DAVEntity)o;
            String id = root.getReposId();
            MetadataInterface result = this._cache.get(id);
            if (result == null) {
                result = this._factory.processWithRepository(root, this);
                this._cache.put(result);
            }
            return result;
        }
        catch (ClassCastException ccex) {
            throw new ServiceException(ccex, "Wrong type of object for this repository");
        }
    }

    @Override
    public boolean isDestroyed() throws RemoteException {
        return this._isDestroyed;
    }

    @Override
    public byte[] toByteArray() throws RemoteException, ServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this._domain);
            oos.writeObject(this._host);
            oos.writeInt(this._port);
            if (this._credsWereGenerated) {
                UserIdentityInterface uid = ((MetadataServerInterface)this._user.getAuthServer()).generatePassword(null);
                oos.writeObject(uid.getPrincipal());
                oos.writeObject(uid.getCredential());
            } else {
                oos.writeObject(this._rootid);
                oos.writeObject(this._rootpw);
            }
            oos.writeObject(this._defaultBase);
            oos.writeObject(this._isName);
            oos.writeObject(this._proxy);
            oos.writeObject(this._https);
            byte[] blobArray = baos.toByteArray();
            return blobArray;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void fromByteArry(UserContextInterface uci, byte[] data) throws RemoteException, ServiceException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            this._user = uci;
            String domain = (String)ois.readObject();
            String host = (String)ois.readObject();
            int portInt = ois.readInt();
            String principal = (String)ois.readObject();
            String password = (String)ois.readObject();
            String defaultBase = (String)ois.readObject();
            String isName = (String)ois.readObject();
            String proxy = (String)ois.readObject();
            boolean https = (Boolean)ois.readObject();
            this.setDomain(domain);
            this.connectWithProxy(host, portInt, principal, password, defaultBase, proxy, https);
            this._isName = isName;
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public CacheStatistics getCacheStatistics() throws ServiceException, RemoteException {
        return this._cache.getCacheStatistics();
    }

    @Override
    public String getFactoryKey(Object o) throws RemoteException, ServiceException {
        try {
            DAVEntity de = (DAVEntity)o;
            String key = "dav:" + de.getType().toLowerCase();
            return key;
        }
        catch (ClassCastException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public MetadataInterface produceDefaultMetadata(Object o) throws RemoteException, ServiceException {
        this.checkConnect();
        Metadata result = null;
        result = o instanceof DAVItem ? new Content(o) : new Folder(o);
        if (result != null) {
            result.setRepository(this);
        }
        return result;
    }

    @Override
    public boolean factoryTest(Object testObject, String filterString) throws RemoteException, ServiceException {
        String myValue;
        this.checkConnect();
        DAVEntity de = (DAVEntity)testObject;
        if (!filterString.startsWith("@")) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)filterString));
        }
        int index = filterString.indexOf(61);
        if (index == -1) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)filterString));
        }
        String attribute = filterString.substring(1, index);
        String value = filterString.substring(index + 1);
        return value.equals(myValue = de.getAttribute(attribute));
    }

    @Override
    public int isProfileRepository(String url) throws RemoteException {
        return 0;
    }

    @Override
    public EvaluatorInterface getEvaluator(Object o) {
        return new DAVEvaluator(o);
    }

    @Override
    public ServerInterface getServer() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public void refreshAllData() throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.refreshingrepos.fmt.txt", (Object)this.getUrl()));
        }
        List items = this._cache.getCacheItems();
        for (BaseCacheEntry entry : items) {
            MetadataInterface mi = (MetadataInterface)entry.getValue();
            if (mi.getName().equalsIgnoreCase("trash")) continue;
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.refreshingobj.fmt.txt", (Object)mi.getEntityKey()));
            }
            this.refreshEntity(mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream fetchContents(String repositoryId) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        InputStream contents = null;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.fetchmsg.fmt.txt", (Object)repositoryId, (Object)this.getUrl()));
        }
        if (repositoryId.length() > 0 && repositoryId.charAt(0) == '$') {
            repositoryId = this.expand(repositoryId);
        }
        DAVResourceInterface _r = null;
        String entityUrl = this.reposId2EntityUrl(repositoryId);
        if (entityUrl != null) {
            try {
                _r = this.connectToResource(entityUrl);
                if (_r == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                try {
                    if (!_r.isCollection()) {
                        contents = _r.getContentsInputStream();
                    }
                }
                catch (DAVException e) {
                    if (logger != null) {
                        logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.contenterr.fmt.txt", (Object)entityUrl));
                    }
                }
            }
            finally {
                this.freeResource();
            }
        }
        return new InputStreamAdapter(contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchContents(String repositoryId, File fout) throws ServiceException, RemoteException {
        block11: {
            this.checkConnect();
            Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
            try {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.fetchmsg.fmt.txt", (Object)repositoryId, (Object)this.getUrl()));
                }
                if (repositoryId.length() > 0 && repositoryId.charAt(0) == '$') {
                    repositoryId = this.expand(repositoryId);
                }
                DAVResourceInterface _r = null;
                String entityUrl = this.reposId2EntityUrl(repositoryId);
                if (entityUrl == null) break block11;
                try {
                    _r = this.connectToResource(entityUrl);
                    if (_r != null && _r.getStatusCode() != 404 && !_r.isCollection()) {
                        try {
                            _r.getContents(fout);
                        }
                        catch (DAVException e) {
                            if (logger != null) {
                                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.contenterr.fmt.txt", (Object)entityUrl));
                            }
                        }
                    }
                }
                finally {
                    this.freeResource();
                }
            }
            catch (DAVException dAVException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getHttpUrl() throws RemoteException {
        return this._url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntity(DAVEntityInterface input) throws ServiceException, RemoteException {
        String reposId;
        block40: {
            this.checkConnect();
            Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
            DAVResourceInterface _r = null;
            String lockToken = null;
            Map _setUpdates = input.getSetUpdates();
            Map _removeUpdates = input.getRemoveUpdates();
            boolean anythingToDo = input.isUpdatePending();
            if (!anythingToDo) {
                return;
            }
            reposId = input.getReposId();
            if (reposId.startsWith("$")) {
                reposId = this.expand(reposId);
            }
            input.setReposId(reposId);
            String updateUrl = this.reposId2EntityUrl(reposId);
            try {
                String aclDocument;
                DAVItemInterface inputItem;
                this.hostInfo.setUrl(updateUrl);
                _r = this.connectToResource(updateUrl);
                try {
                    if (_r == null || _r.getStatusCode() == 404) {
                        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.notthere.ex.fmt.txt", (Object)updateUrl));
                    }
                    int savedDepth = _r.getDepth();
                    _r.setDepth(0);
                    lockToken = _r.lock();
                    _r.setDepth(savedDepth);
                    if (_r.getStatusCode() == 423) {
                        throw new EntityHasChangedException(RB.getStringResource("DAVRepository.updlock.txt"));
                    }
                }
                catch (DAVException e) {
                    logger.debug(e.getMessage());
                    throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.updterr.ex.fmt.txt", (Object)updateUrl));
                }
                List updatepp = null;
                try {
                    PropertyName[] propertyName = new PropertyName[]{new PropertyName(UPDATE_ID_PROPERTYNAME)};
                    updatepp = _r.getDavProperties(propertyName, _r.getDepth()).getDavProperties();
                }
                catch (DAVException propertyName) {
                    // empty catch block
                }
                boolean changed = false;
                if (updatepp != null && updatepp.size() == 1) {
                    try {
                        changed = this.isDifferentNotNull(XMLUtil.getPropertyAsString((DavPropertyItem)((DavPropertyItem)updatepp.get(0))), input.getAttribute(UPDATE_ID_PROPERTYNAME));
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw new ServiceException(parserConfigurationException, RB.getStringResource("DAVRepository.parsererr.ex.txt"));
                    }
                    if (changed) {
                        try {
                            _r.unlock();
                        }
                        catch (DAVException parserConfigurationException) {
                            // empty catch block
                        }
                        throw new EntityHasChangedException(RB.getStringResource("DAVRepository.updchg.txt"));
                    }
                }
                input.setAttribute(UPDATE_ID_PROPERTYNAME, GUID.newGUID());
                this.processChanges(_r, _setUpdates, true);
                this.processChanges(_r, _removeUpdates, false);
                if (input instanceof DAVItemInterface && (inputItem = (DAVItemInterface)input).hasContentsUpdates()) {
                    InputStream in = null;
                    try {
                        in = inputItem.getContents();
                        String contentType = inputItem.getContentType();
                        if (contentType != null && contentType.length() > 0) {
                            _r.setContentType(contentType);
                        }
                        _r.setContents(in);
                        if (415 == _r.getStatusCode()) {
                            DAVException cause = new DAVException("HTTP status code = 415");
                            cause.setStatusCode(415);
                            throw new ServiceException(cause, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.updterr.ex.fmt.txt", (Object)updateUrl));
                        }
                    }
                    catch (DAVException e) {
                        throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.updterr.ex.fmt.txt", (Object)updateUrl));
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if ((aclDocument = input.getUpdateableACL()) == null) break block40;
                try {
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.addacl.fmt.txt", (Object)_r.getURL().toString(), (Object)aclDocument));
                    }
                    _r.setACL(aclDocument);
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.addaclresult.fmt.txt", (Object)new Integer(_r.getStatusCode())));
                    }
                }
                catch (DAVException e) {
                    throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.addaclresult.fmt.txt", (Object)new Integer(e.getStatusCode())));
                }
            }
            finally {
                try {
                    if (_r != null && lockToken != null) {
                        _r.unlock();
                    }
                }
                catch (DAVException e) {
                    e.printStackTrace();
                }
                this.freeResource();
            }
        }
        InformationServiceInterface is = DAVRepository.getInformationService();
        MetadataChangeEvent event = new MetadataChangeEvent(this._url, reposId);
        is.metadataChange(event);
    }

    @Override
    public String getReposIdwoTypeFromUrl(String fullUrl) {
        String p1 = null;
        String scheme2 = null;
        scheme2 = this.getHttps() ? "https" : "http";
        p1 = this._DAVurl;
        p1 = scheme2 + p1.substring(3);
        URI _uri = null;
        try {
            URL _url = new URL(fullUrl);
            _uri = new URI(_url.getProtocol(), _url.getAuthority(), _url.getPath() + (_url.getQuery() == null ? "" : "?" + _url.getQuery()) + (_url.getRef() == null ? "" : "#" + _url.getRef()), null, null);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
        }
        String reposId = URIUtil.url1StartsWithUrl2(_uri.toString(), p1);
        if (reposId != null) {
            if (reposId.length() > 0 && reposId.charAt(0) == '/') {
                reposId = reposId.equals("/") ? "" : reposId.substring(1);
            }
            return reposId;
        }
        return null;
    }

    @Override
    public PersonInterface makePersonalAnchor() throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        PersonInterface p = null;
        p = this.getUser();
        if (p != null) {
            return p;
        }
        MetadataInterface mi = null;
        if (this._rootid != null && this._rootid.length() > 0) {
            String personReposId;
            String rootidPath = DAVRepository.getUserPath(this._user);
            if (this.userBase.length() > 0 && USERS_PATH.length() == 0) {
                rootidPath = Utils.addSegment((String)this.userBase, (String)rootidPath);
            }
            if ((mi = this.fetch(personReposId = rootidPath + "/person")) == null) {
                block26: {
                    String adminUser = null;
                    String adminPW = null;
                    if (this._isName != null) {
                        adminUser = AccessController.doPrivileged(new GetPropertyAction("sysadmin." + this._isName));
                        adminPW = AccessController.doPrivileged(new GetPropertyAction("sysadminpw." + this._isName));
                    }
                    if (adminUser == null) {
                        adminUser = AccessController.doPrivileged(new GetPropertyAction("sysadmin.dav"));
                        adminPW = AccessController.doPrivileged(new GetPropertyAction("sysadminpw.dav"));
                    }
                    if (adminUser == null) {
                        adminUser = this._rootid;
                        adminPW = this._rootpw;
                    }
                    String usersUrl = Utils.addSegment((String)this._url, (String)rootidPath);
                    try {
                        NodeList nl;
                        try {
                            new URL(usersUrl);
                        }
                        catch (MalformedURLException e) {
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.badUrl.ex.fmt", (Object)usersUrl));
                        }
                        ConnectionInfo host = new ConnectionInfo(this.hostInfo);
                        host.setUrl(usersUrl);
                        host.setUser(adminUser);
                        host.setPW(adminPW);
                        DAVResourceInterface _t = this.connectToResource(usersUrl);
                        if (_t.getStatusCode() != 404) break block26;
                        _t.makeCollection();
                        if (!_t.SUCCEEDED()) {
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.createusers.ex.fmt.txt", (Object)new Integer(_t.getStatusCode()), (Object)usersUrl));
                        }
                        _t.setProperty(new PropertyName("type", "sas", "http://www.sas.com/rnd/itech/WebDAV"), "person");
                        if (!this._supportsACL) break block26;
                        String PREFIX = "D:";
                        Document aclDoc = null;
                        try {
                            DocumentBuilderFactory documentBuilderFactory = TransformerFactoryFactory.newDocumentBuilderFactory();
                            documentBuilderFactory.setNamespaceAware(true);
                            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                            aclDoc = documentBuilder.newDocument();
                        }
                        catch (ParserConfigurationException e) {
                            throw new ServiceException(e, RB.getStringResource("DAVRepository.parsererr.ex.txt"));
                        }
                        Element newacl = aclDoc.createElementNS("DAV:", PREFIX + "acl");
                        newacl.setAttribute("xmlns:D", "DAV:");
                        aclDoc.appendChild(newacl);
                        String principalID = this.getPrincipalID(_t, this._rootid);
                        DavPropertyItem aclProperty = null;
                        _t.setDepth(0);
                        DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
                        davPropertyNameSet.add(DavPropertyName.createFromXml((Element)newacl));
                        List davPropertyItems = _t.getDavProperties(davPropertyNameSet, 0).getDavProperties();
                        if (davPropertyItems.size() > 0) {
                            aclProperty = (DavPropertyItem)davPropertyItems.get(0);
                        }
                        if (aclProperty == null) break block26;
                        try {
                            Element acl = aclProperty.getDavProperty().toXml(XMLUtil.newDocument());
                            nl = acl.getElementsByTagNameNS("DAV:", "ace");
                        }
                        catch (ParserConfigurationException e) {
                            throw new ServiceException(e, RB.getStringResource("DAVRepository.parsererr.ex.txt"));
                        }
                        if (null != nl && nl.getLength() > 0) {
                            for (int i = 0; i < nl.getLength(); ++i) {
                                boolean isProtected;
                                Element ace = (Element)nl.item(i);
                                NodeList _n = ace.getElementsByTagNameNS("DAV:", "inherited");
                                boolean isInherited = _n.getLength() > 0;
                                _n = ace.getElementsByTagNameNS("DAV:", "protected");
                                boolean bl = isProtected = _n.getLength() > 0;
                                if (isInherited || isProtected) continue;
                                newacl.appendChild(aclDoc.importNode(ace, true));
                            }
                        }
                        Element userACE = aclDoc.createElementNS("DAV:", PREFIX + "ace");
                        Element hrefE = aclDoc.createElementNS("DAV:", PREFIX + "href");
                        hrefE.appendChild(aclDoc.createTextNode(principalID));
                        Element principalE = aclDoc.createElementNS("DAV:", PREFIX + "principal");
                        principalE.appendChild(hrefE);
                        Element grant = aclDoc.createElementNS("DAV:", PREFIX + "grant");
                        Element privilegeE = aclDoc.createElementNS("DAV:", PREFIX + "privilege");
                        Element writePrivilegeE = aclDoc.createElementNS("DAV:", PREFIX + "all");
                        privilegeE.appendChild(writePrivilegeE);
                        grant.appendChild(privilegeE);
                        userACE.appendChild(principalE);
                        userACE.appendChild(grant);
                        newacl.appendChild(userACE);
                    }
                    catch (DAVException e) {
                        throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.createusers.ex.fmt.txt", (Object)new Integer(500), (Object)usersUrl));
                    }
                    finally {
                        this.freeResource();
                    }
                }
                mi = this.fetch(personReposId);
            }
            if (mi instanceof PersonInterface) {
                this.setUser((PersonInterface)mi);
                p = (PersonInterface)mi;
            }
            if (logger != null && logger.isDebugEnabled() && mi != null) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.resourcetype.fmt.txt", (Object)mi.getClass().getName()));
            }
        } else if (logger != null && logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("DAVRepository.noperson.txt"));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersonalRepositoryInterface getPersonalRepository() throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        if (this._pr != null) {
            return this._pr;
        }
        IdentityInterface p = this.getIdentity();
        if (p == null) {
            p = this.makePersonalAnchor();
        }
        if (p != null) {
            String reposId = p.getReposId();
            String entityName = reposId.substring(0, reposId.lastIndexOf("/"));
            String prId = Utils.addSegment((String)entityName, (String)"PR");
            MetadataInterface mi = this.fetch(prId + "/personalrepository");
            if (mi == null) {
                String prUrl = Utils.addSegment((String)this._url, (String)prId);
                try {
                    DAVResourceInterface r = this.connectToResource(prUrl);
                    r.makeCollection();
                    r.setProperty(new PropertyName("{http://www.sas.com/rnd/itech/WebDAV}type"), "personalrepository");
                    URL url = null;
                    try {
                        url = new URL(prUrl);
                        r.setPath(Utils.addSegment((String)url.getPath(), (String)"MyInbox"));
                        r.makeCollection();
                        r.setPath(Utils.addSegment((String)url.getPath(), (String)"MyDocuments"));
                        r.makeCollection();
                        r.setPath(Utils.addSegment((String)url.getPath(), (String)"MyResults"));
                        r.makeCollection();
                    }
                    catch (MalformedURLException e) {
                        url = null;
                    }
                }
                catch (DAVException e) {
                    e.printStackTrace();
                }
                finally {
                    this.freeResource();
                }
                mi = this.fetch(prId + "/personalrepository");
            }
            if (mi instanceof PersonalRepositoryInterface) {
                this._pr = (PersonalRepositoryInterface)mi;
                return this._pr;
            }
            if (logger != null) {
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.invalidpr.fmt.txt", (Object)mi.getEntityURL()));
            }
        }
        return null;
    }

    @Override
    public boolean getHttps() {
        return this._https;
    }

    @Override
    public boolean supportsACL() {
        try {
            this.checkConnect();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this._supportsACL;
    }

    @Override
    public boolean supportsSEARCH() {
        try {
            this.checkConnect();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this._supportsSEARCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List getItems(DAVFolderInterface d) {
        try {
            this.checkConnect();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        ArrayList<DAVEntityInterface> results = new ArrayList<DAVEntityInterface>();
        HashMap<String, PropertyMap> resourceMap = new HashMap<String, PropertyMap>();
        try {
            String url;
            try {
                DAVResourceInterface _r = this.connectToResource(d.getUrl());
                if (_r == null) {
                    ArrayList<DAVEntityInterface> arrayList = results;
                    return arrayList;
                }
                url = this.fetchProperties(_r, resourceMap, 1);
            }
            finally {
                this.freeResource();
            }
            DAVEntityInterface newEntity = null;
            if (resourceMap.size() <= 1) return results;
            Iterator iterator = resourceMap.keySet().iterator();
            while (iterator.hasNext()) {
                String reskey = (String)iterator.next();
                if (reskey.equals(url)) continue;
                String repositoryId = this.getReposIdwoTypeFromUrl(reskey);
                PropertyMap _pm = (PropertyMap)resourceMap.get(reskey);
                HashMap<String, String> _pm2 = new HashMap<String, String>();
                Iterator _pmItems = _pm.entrySet().iterator();
                String resourcetype = "";
                while (_pmItems.hasNext()) {
                    Map.Entry me = (Map.Entry)_pmItems.next();
                    String pName = (String)me.getKey();
                    String pVal = (String)me.getValue();
                    _pm2.put(pName, pVal);
                    if (pName.equals("{http://www.sas.com/rnd/itech/WebDAV}type")) {
                        resourcetype = pVal;
                    }
                    if (pName.equals("{DAV:}resourcetype") && resourcetype.length() == 0) {
                        resourcetype = pVal;
                    }
                    if (!"".equals(resourcetype)) continue;
                    resourcetype = "item";
                }
                RepositoryData tmpEntity = new RepositoryData(_pm2);
                tmpEntity.setReposId(Utils.addSegment((String)repositoryId, (String)resourcetype));
                tmpEntity.setRepository(this);
                newEntity = (DAVEntityInterface)DAVFactory.narrow(tmpEntity);
                DavPropertyItem aclProperty = (DavPropertyItem)_pm.get((Object)"{DAV:}acl");
                if (aclProperty != null) {
                    Element acl = aclProperty.getDavProperty().toXml(XMLUtil.newDocument());
                    newEntity.setACL(com.sas.services.util.XMLUtil.node2String(acl));
                }
                results.add(newEntity);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryData fetchRepositoryData(String repositoryKey) throws ServiceException, RemoteException {
        this.checkConnect();
        if (repositoryKey == null) {
            return null;
        }
        if (repositoryKey.length() > 0 && repositoryKey.charAt(0) == '$') {
            repositoryKey = this.expand(repositoryKey);
        }
        boolean badUrl = false;
        DAVResourceInterface _r = null;
        String entityUrl = this.reposId2EntityUrl(repositoryKey);
        try {
            new URL(entityUrl);
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
            badUrl = true;
        }
        if (!badUrl) {
            HashMap<String, PropertyMap> resourceMap = new HashMap<String, PropertyMap>();
            try {
                _r = this.connectToResource(entityUrl);
                if (_r == null) {
                    RepositoryData repositoryData = null;
                    return repositoryData;
                }
                entityUrl = this.fetchProperties(_r, resourceMap, 0);
            }
            finally {
                this.freeResource();
            }
            PropertyMap pmap = (PropertyMap)resourceMap.get(entityUrl);
            if (pmap == null) {
                return null;
            }
            HashMap<String, String> mpmap = new HashMap<String, String>();
            for (Map.Entry me : pmap.entrySet()) {
                mpmap.put((String)me.getKey(), (String)me.getValue());
            }
            RepositoryData entity = new RepositoryData(mpmap);
            entity.setReposId(repositoryKey);
            entity.setRepository(this);
            return entity;
        }
        return null;
    }

    @Override
    @Deprecated
    public MetadataInterface copyTo(DAVEntityInterface de, DAVFolderInterface f) throws ServiceException, RemoteException {
        this.checkConnect();
        String reposId = de.getReposId();
        if (reposId.length() > 0 && reposId.charAt(0) == '$') {
            reposId = this.expand(reposId);
            de.setReposId(reposId);
        }
        String entityPath = reposId.substring(0, reposId.lastIndexOf("/"));
        String entityUrl = Utils.addSegment((String)this._url, (String)entityPath);
        reposId = f.getReposId();
        if (reposId.length() > 0 && reposId.charAt(0) == '$') {
            reposId = this.expand(reposId);
            de.setReposId(reposId);
        }
        String targetPathOffset = reposId.substring(0, reposId.lastIndexOf("/"));
        targetPathOffset = Utils.addSegment((String)targetPathOffset, (String)de.getName());
        String targetPath = Utils.addSegment((String)this._defaultBase, (String)targetPathOffset);
        try {
            DAVResourceInterface _r = this.connectToResource(entityUrl);
            if (_r == null) {
                MetadataInterface metadataInterface = null;
                return metadataInterface;
            }
            _r.copy(targetPath);
        }
        catch (DAVException d) {
            throw new ServiceException(d, RB.getStringResource("DAVRepository.copyerr.ex.fmt.txt"));
        }
        finally {
            this.freeResource();
        }
        reposId = Utils.addSegment((String)targetPathOffset, (String)"/type");
        return this.fetch(reposId);
    }

    @Override
    @Deprecated
    public MetadataInterface moveTo(DAVEntityInterface de, DAVFolderInterface f) throws ServiceException, RemoteException {
        this.checkConnect();
        String reposId = de.getReposId();
        if (reposId.length() > 0 && reposId.charAt(0) == '$') {
            reposId = this.expand(reposId);
            de.setReposId(reposId);
        }
        String entityPath = reposId.substring(0, reposId.lastIndexOf("/"));
        String entityUrl = Utils.addSegment((String)this._url, (String)entityPath);
        reposId = f.getReposId();
        if (reposId.length() > 0 && reposId.charAt(0) == '$') {
            reposId = this.expand(reposId);
            de.setReposId(reposId);
        }
        String targetPathOffset = reposId.substring(0, reposId.lastIndexOf("/"));
        targetPathOffset = Utils.addSegment((String)targetPathOffset, (String)de.getName());
        String targetPath = Utils.addSegment((String)this._defaultBase, (String)targetPathOffset);
        try {
            DAVResourceInterface _r = this.connectToResource(entityUrl);
            if (_r == null) {
                MetadataInterface metadataInterface = null;
                return metadataInterface;
            }
            _r.move(targetPath);
        }
        catch (DAVException d) {
            throw new ServiceException(d, RB.getStringResource("DAVRepository.moveerr.ex.fmt.txt"));
        }
        finally {
            this.freeResource();
        }
        reposId = Utils.addSegment((String)targetPathOffset, (String)"/type");
        return this.fetch(reposId);
    }

    @Override
    public MetadataInterface copyTo(DAVEntityInterface de, DAVFolderInterface f, String name) throws ServiceException, RemoteException {
        String targetPathOffset;
        this.checkConnect();
        String reposId = de.getReposId();
        if (reposId.length() > 0 && reposId.charAt(0) == '$') {
            reposId = this.expand(reposId);
            de.setReposId(reposId);
        }
        String entityPath = reposId.substring(0, reposId.lastIndexOf("/"));
        String entityUrl = Utils.addSegment((String)this._url, (String)entityPath);
        if (f != null) {
            reposId = f.getReposId();
            if (reposId.length() > 0 && reposId.charAt(0) == '$') {
                reposId = this.expand(reposId);
            }
            targetPathOffset = reposId.substring(0, reposId.lastIndexOf("/"));
        } else {
            reposId = de.getReposId();
            targetPathOffset = reposId.substring(0, reposId.lastIndexOf("/"));
            int p = targetPathOffset.lastIndexOf("/");
            targetPathOffset = p > -1 ? targetPathOffset.substring(0, p) : "/";
        }
        targetPathOffset = name == null || name.length() == 0 ? Utils.addSegment((String)targetPathOffset, (String)de.getName()) : Utils.addSegment((String)targetPathOffset, (String)name);
        String targetPath = Utils.addSegment((String)this._defaultBase, (String)targetPathOffset);
        if (!targetPath.startsWith("/")) {
            targetPath = '/' + targetPath;
        }
        try {
            DAVResourceInterface _r = this.connectToResource(entityUrl);
            if (_r == null) {
                MetadataInterface metadataInterface = null;
                return metadataInterface;
            }
            _r.copy(targetPath);
            if (_r.getStatusCode() == 412) {
                throw new ItemAlreadyExistsException(RB.getStringResource("DAVRepository.copyerr.ex.fmt.txt"));
            }
            if (!_r.SUCCEEDED()) {
                throw new ServiceException(RB.getStringResource("DAVRepository.copyerr.ex.fmt.txt"));
            }
        }
        catch (DAVException d) {
            throw new ServiceException(d, RB.getStringResource("DAVRepository.copyerr.ex.fmt.txt"));
        }
        finally {
            this.freeResource();
        }
        reposId = Utils.addSegment((String)targetPathOffset, (String)"/type");
        return this.fetch(reposId, true);
    }

    @Override
    public MetadataInterface moveTo(DAVEntityInterface de, DAVFolderInterface f, String name) throws ServiceException, RemoteException {
        String targetPathOffset;
        this.checkConnect();
        String reposId = de.getReposId();
        if (reposId.length() > 0 && reposId.charAt(0) == '$') {
            reposId = this.expand(reposId);
            de.setReposId(reposId);
        }
        String entityPath = reposId.substring(0, reposId.lastIndexOf("/"));
        String entityUrl = Utils.addSegment((String)this._url, (String)entityPath);
        if (f != null) {
            reposId = f.getReposId();
            if (reposId.length() > 0 && reposId.charAt(0) == '$') {
                reposId = this.expand(reposId);
            }
            targetPathOffset = reposId.substring(0, reposId.lastIndexOf("/"));
        } else {
            reposId = de.getReposId();
            targetPathOffset = reposId.substring(0, reposId.lastIndexOf("/"));
            int p = targetPathOffset.lastIndexOf("/");
            if (p > -1) {
                targetPathOffset.substring(0, p);
            } else {
                targetPathOffset = "/";
            }
        }
        targetPathOffset = name == null || name.length() == 0 ? Utils.addSegment((String)targetPathOffset, (String)de.getName()) : Utils.addSegment((String)targetPathOffset, (String)name);
        String targetPath = Utils.addSegment((String)this._defaultBase, (String)targetPathOffset);
        if (!targetPath.startsWith("/")) {
            targetPath = '/' + targetPath;
        }
        try {
            DAVResourceInterface _r = this.connectToResource(entityUrl);
            if (_r == null) {
                MetadataInterface metadataInterface = null;
                return metadataInterface;
            }
            _r.move(targetPath);
            if (_r.getStatusCode() == 412) {
                throw new ItemAlreadyExistsException(RB.getStringResource("DAVRepository.moveerr.ex.fmt.txt"));
            }
            if (!_r.SUCCEEDED()) {
                throw new ServiceException(RB.getStringResource("DAVRepository.moveerr.ex.fmt.txt"));
            }
        }
        catch (DAVException d) {
            throw new ServiceException(d, RB.getStringResource("DAVRepository.moveerr.ex.fmt.txt"));
        }
        finally {
            this.freeResource();
        }
        reposId = Utils.addSegment((String)targetPathOffset, (String)"/type");
        return this.fetch(reposId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setACLFromStore(DAVEntityInterface entity) throws RemoteException {
        try {
            this.checkConnect();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        DavPropertyItem aclProperty = null;
        try {
            DAVResourceInterface r = this.connectToResource(entity.getURL());
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(DavPropertyName.create((String)"acl", (Namespace)DavConstants.NAMESPACE));
            List davPropertyItems = r.getDavProperties(davPropertyNameSet, 0).getDavProperties();
            if (davPropertyItems.size() > 0) {
                aclProperty = (DavPropertyItem)davPropertyItems.get(0);
            }
        }
        catch (DAVException davPropertyNameSet) {
        }
        catch (RemoteException davPropertyNameSet) {
        }
        finally {
            this.freeResource();
        }
        if (aclProperty != null) {
            try {
                Element acl = aclProperty.getDavProperty().toXml(XMLUtil.newDocument());
                entity.setACL(XML_DOCUMENT_HEADER + com.sas.services.util.XMLUtil.node2String(acl));
            }
            catch (ParserConfigurationException e) {
                Logger logger = LogManager.getLogger((String)DAVRepository.class.getName());
                logger.error(RB.getStringResource("DAVRepository.parsererr.ex.txt"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void version(MetadataInterface entity) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String reposId = entity.getReposId();
        String tempUrl = this.reposId2EntityUrl(reposId);
        try {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("VERSION-CONTROL for " + reposId);
            }
            try {
                DAVResourceInterface _r = this.connectToResource(tempUrl);
                _r.doControl();
                if (_r.getStatusCode() == 404) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.notthere.ex.fmt.txt", (Object)tempUrl));
                }
                if (!_r.SUCCEEDED()) {
                    int sc = _r.getStatusCode();
                    String msg = sc + " Error during VERSION-CONTROL";
                    throw new ServiceException(msg);
                }
            }
            catch (DAVException e) {
                logger.debug(e.getMessage());
                throw new ServiceException(e, "Error during VERSION-CONTROL for" + tempUrl);
            }
        }
        finally {
            this.freeResource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkout(MetadataInterface entity) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String reposId = entity.getReposId();
        String tempUrl = this.reposId2EntityUrl(reposId);
        try {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("CHECKOUT for " + reposId);
            }
            try {
                DAVResourceInterface _r = this.connectToResource(tempUrl);
                _r.doCheckout();
                if (_r.getStatusCode() == 404) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.notthere.ex.fmt.txt", (Object)tempUrl));
                }
                if (!_r.SUCCEEDED()) {
                    int sc = _r.getStatusCode();
                    String msg = sc + " Error during CHECKOUT";
                    throw new ServiceException(msg);
                }
            }
            catch (DAVException e) {
                logger.debug(e.getMessage());
                throw new ServiceException(e, "Error during CHECKOUT for" + tempUrl);
            }
        }
        finally {
            this.freeResource();
        }
    }

    @Override
    public void checkin(MetadataInterface entity) throws ServiceException, RemoteException {
        this.checkin(entity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkin(MetadataInterface entity, String comment) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String reposId = entity.getReposId();
        String tempUrl = this.reposId2EntityUrl(reposId);
        try {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("CHECKIN for " + reposId);
            }
            try {
                DAVResourceInterface _r = this.connectToResource(tempUrl);
                if (comment == null || comment.length() == 0) {
                    comment = "DAVRepository update " + new Date();
                }
                _r.setProperty(new PropertyName(DAV_COMMENT), comment);
                _r.doCheckin();
                if (_r.getStatusCode() == 404) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.notthere.ex.fmt.txt", (Object)tempUrl));
                }
                if (!_r.SUCCEEDED()) {
                    int sc = _r.getStatusCode();
                    String msg = sc + " Error during CHECKIN";
                    throw new ServiceException(msg);
                }
            }
            catch (DAVException e) {
                logger.debug(e.getMessage());
                throw new ServiceException(e, "Error during CHECKIN for" + tempUrl);
            }
        }
        finally {
            this.freeResource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncheckout(MetadataInterface entity) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String reposId = entity.getReposId();
        String tempUrl = this.reposId2EntityUrl(reposId);
        try {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("UNCHECKOUT for " + reposId);
            }
            try {
                DAVResourceInterface _r = this.connectToResource(tempUrl);
                _r.doUncheckout();
                if (_r.getStatusCode() == 404) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.notthere.ex.fmt.txt", (Object)tempUrl));
                }
                if (!_r.SUCCEEDED()) {
                    int sc = _r.getStatusCode();
                    String msg = sc + " Error during UNCHECKOUT";
                    throw new ServiceException(msg);
                }
            }
            catch (DAVException e) {
                logger.debug(e.getMessage());
                throw new ServiceException(e, "Error during UNCHECKOUT for" + tempUrl);
            }
        }
        finally {
            this.freeResource();
        }
    }

    @Override
    public synchronized int trackEntity(MetadataInterface entity) throws RemoteException {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToCache(MetadataInterface mi) throws RemoteException {
        DAVRepositoryCache dAVRepositoryCache = this._cache;
        synchronized (dAVRepositoryCache) {
            this._cache.put(mi);
        }
    }

    @Override
    public SharedResourceInterface getSharedResource() throws RemoteException {
        return this.sharedResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPreviousVersionNames(MetadataInterface entity) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        List results = new ArrayList();
        String reposId = entity.getReposId();
        String tempUrl = this.reposId2EntityUrl(reposId);
        try {
            try {
                DAVResourceInterface _r = this.connectToResource(tempUrl);
                results = _r.getPreviousVersionNames();
                if (_r.getStatusCode() == 404) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.notthere.ex.fmt.txt", (Object)tempUrl));
                }
                if (!_r.SUCCEEDED()) {
                    int sc = _r.getStatusCode();
                    String msg = sc + " Error during getPreviousVersionNames";
                    throw new ServiceException(msg);
                }
            }
            catch (DAVException e) {
                logger.debug(e.getMessage());
                throw new ServiceException(e, "Error during getPreviousVersionNames for " + tempUrl);
            }
        }
        finally {
            this.freeResource();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataInterface getVersion(MetadataInterface entity, String versionName) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        MetadataInterface result = null;
        String href = null;
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        String reposId = entity.getReposId();
        String tempUrl = this.reposId2EntityUrl(reposId);
        try {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("GetVersion for " + reposId);
            }
            try {
                DAVResourceInterface _r = this.connectToResource(tempUrl);
                Version version = _r.getVersion(versionName);
                href = version.getHref();
                extraProperties.put(DAV_COMMENT, version.getComment());
                extraProperties.put(DAV_CREATOR_DISPLAYNAME, version.getCreatorDisplayName());
                if (_r.getStatusCode() == 404) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.notthere.ex.fmt.txt", (Object)tempUrl));
                }
                if (!_r.SUCCEEDED()) {
                    int sc = _r.getStatusCode();
                    String msg = sc + " Error during getVersion";
                    throw new ServiceException(msg);
                }
            }
            catch (DAVException e) {
                logger.debug(e.getMessage());
                throw new ServiceException(e, "Error during getVersion for" + tempUrl);
            }
        }
        finally {
            this.freeResource();
        }
        if (href != null) {
            result = this.fetchUsingUrl(Utils.URIDecode((String)href), extraProperties);
        }
        DAVEntityInterface dei = (DAVEntityInterface)result.getRepositoryEntity();
        dei.setReposId("/" + dei.getReposId());
        return result;
    }

    @Override
    public void metadataChange(MetadataChangeEvent event) throws RemoteException {
        if (this._cache == null) {
            return;
        }
        String id = event.getRepositoryId();
        this._cache.remove(id);
    }

    @Override
    public void runInformationServiceTimer() {
        this._cache.evict();
    }

    private synchronized void removeChildren(FolderInterface folder) throws ServiceException, RemoteException {
        this.checkConnect();
        List itemList = folder.getItems();
        for (MetadataInterface mi : itemList) {
            this._cache.remove(mi.getReposId());
        }
        List subfolderList = folder.getSubfolders();
        for (FolderInterface subfolder : subfolderList) {
            this.removeChildren(subfolder);
            this._cache.remove(subfolder.getReposId());
        }
    }

    private Map doSearch(FilterInterface filter) throws ServiceException, RemoteException {
        HashMap<String, PropertyMap> rMap = new HashMap<String, PropertyMap>();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String allowedMethods = (String)this._OptHdrs.get("Allow");
        String searchGrammars = (String)this._OptHdrs.get("DASL");
        String[] searchResults = null;
        String searchString = "";
        String arbiter = "";
        arbiter = this.getHttpUrl();
        String XythosServer = (String)this._OptHdrs.get("Xythos-WFS-Version");
        boolean fullScopeRequired = XythosServer != null;
        String base = filter.getDAVBase();
        List davPropertyItems = null;
        if (fullScopeRequired) {
            if (!base.startsWith("http")) {
                String fullbase = Utils.addSegment((String)arbiter, (String)base);
                filter.setDAVBase(fullbase);
            }
        } else if (base.startsWith("http")) {
            try {
                URL url2 = new URL(arbiter);
                URL url1 = new URL(base);
                URI uri2 = new URI(url2.getProtocol(), url2.getAuthority(), url2.getPath(), null, null);
                URI uri1 = new URI(url1.getProtocol(), url1.getAuthority(), url1.getPath(), null, null);
                String relpath = URIUtil.url1StartsWithUrl2(uri1.toString(), uri2.toString());
                if (relpath != null) {
                    if (relpath.length() > 0 && relpath.charAt(0) == '/') {
                        relpath = relpath.substring(1);
                    }
                    filter.setDAVBase(relpath);
                } else {
                    filter.setDAVBase(base);
                }
            }
            catch (MalformedURLException e) {
                filter.setDAVBase(base);
            }
            catch (URISyntaxException e) {
                filter.setDAVBase(base);
            }
        }
        if (allowedMethods == null || allowedMethods.indexOf("SEARCH") < 0) {
            searchResults = this.doOurOwnSearch(filter);
        } else if (searchGrammars != null && (searchGrammars.indexOf("DAV:sql") > 0 || searchGrammars.indexOf("DAV:basicsearch") > 0)) {
            if (searchGrammars.indexOf("DAV:sql") > 0) {
                searchString = filter.getDAVSQLString();
                if ("UNSUPPORTED".equals(searchString)) {
                    throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (Object)filter.toString()));
                }
                if (logger != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.sqlsearch.fmt.txt", (Object)arbiter));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(searchString);
                    }
                }
            } else if (searchGrammars.indexOf("DAV:basicsearch") > 0) {
                String newVersion;
                int p;
                String serverString;
                String version;
                searchString = filter.getDAVBasicSearchString();
                if ("UNSUPPORTED".equals(searchString)) {
                    throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (Object)filter.toString()));
                }
                if (XythosServer != null && (version = (serverString = XythosServer.trim()).substring((p = serverString.lastIndexOf(32)) + 1)).compareTo(newVersion = "4.2") < 0) {
                    searchString = searchString.replaceAll("<d:is-collection/>", "<d:eq><d:prop><d:iscollection/></d:prop><d:literal>1</d:literal></d:eq>");
                }
                if (logger != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.davsearch.fmt.txt", (Object)arbiter));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(searchString);
                    }
                }
            }
            if (fullScopeRequired) {
                filter.setDAVBase(base);
            }
            int ssc = 0;
            try {
                DAVResourceInterface _r = this.connectToResource(this.getHttpUrl());
                String language = "basicsearch";
                Namespace languageNamespace = Namespace.DAV_NAMESPACE;
                SearchInfo searchInfo = new SearchInfo(language, languageNamespace, searchString);
                davPropertyItems = _r.doSearch(searchInfo).getDavProperties();
                if (logger != null) {
                    logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.searchstatus.fmt.txt", (Object)_r.getStatusCode()));
                }
                ssc = _r.getStatusCode();
            }
            catch (DAVException e) {
                throw new ServiceException(e, "WebDAV exception occurred during SEARCH");
            }
            finally {
                this.freeResource();
            }
            if (ssc != 422) {
                String arbiterUrl = arbiter;
                this.transformProperties(davPropertyItems, rMap, arbiterUrl);
                return rMap;
            }
            searchResults = this.doOurOwnSearch(filter);
        } else {
            searchResults = this.doOurOwnSearch(filter);
        }
        for (int i = 0; i < searchResults.length; ++i) {
            rMap.put(searchResults[i], (PropertyMap)searchResults[i]);
        }
        return rMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] doOurOwnSearch(FilterInterface filter) throws RemoteException {
        Map pmap;
        String[] prop;
        int DAVscope;
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        ArrayList ppList = new ArrayList();
        List davProperties = new ArrayList();
        if (logger != null) {
            logger.info(RB.getStringResource("DAVRepository.localsearch.txt"));
        }
        String searchStr = filter.getDAVBasicSearchString();
        Document searchDoc = null;
        try {
            DocumentBuilderFactory factory = null;
            DocumentBuilder builder = null;
            factory = TransformerFactoryFactory.newDocumentBuilderFactory();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            searchDoc = builder.parse(new ByteArrayInputStream(searchStr.getBytes("UTF-8")));
            searchDoc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return ppList.toArray(new String[0]);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return ppList.toArray(new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ppList.toArray(new String[0]);
        }
        NodeList _n = searchDoc.getElementsByTagNameNS("DAV:", "basicsearch");
        if (_n == null || _n.getLength() == 0 || !_n.item(0).hasChildNodes()) {
            return ppList.toArray(new String[0]);
        }
        switch (filter.getDAVScope()) {
            case 0: {
                DAVscope = 0;
                break;
            }
            case 1: {
                DAVscope = 1;
                break;
            }
            case 2: {
                DAVscope = Integer.MAX_VALUE;
                break;
            }
            default: {
                DAVscope = Integer.MAX_VALUE;
            }
        }
        NodeList propElems = searchDoc.getElementsByTagNameNS("DAV:", "prop");
        StringBuffer pBuffer = new StringBuffer();
        ArrayList<String> props = new ArrayList<String>();
        for (int p = 0; p < propElems.getLength(); ++p) {
            NodeList propitems = propElems.item(p).getChildNodes();
            for (int p2 = 0; p2 < propitems.getLength(); ++p2) {
                prop = propitems.item(p2);
                String nsURI = prop.getNamespaceURI();
                String propName = nsURI == null ? "{}" + prop.getLocalName() : "{" + nsURI + "}" + prop.getLocalName();
                if (props.contains(propName)) continue;
                props.add(propName);
                if (nsURI != null) {
                    pBuffer.append("<");
                    pBuffer.append(prop.getPrefix());
                    pBuffer.append(":");
                    pBuffer.append(prop.getLocalName());
                    pBuffer.append(" ");
                    pBuffer.append("xmlns:");
                    pBuffer.append(prop.getPrefix());
                    pBuffer.append("=\"");
                    pBuffer.append(prop.getNamespaceURI());
                    pBuffer.append("\"/>");
                    continue;
                }
                pBuffer.append("<");
                pBuffer.append(prop.getLocalName());
                pBuffer.append("/>");
            }
        }
        if (pBuffer.length() == 0) {
            pBuffer.append("<D:resourcetype/>");
        }
        String propString = pBuffer.toString();
        String base = filter.getDAVBase();
        if (base == null) {
            return ppList.toArray(new String[0]);
        }
        try {
            this.hostInfo.setUrl(Utils.addSegment((String)this.getHttpUrl(), (String)base));
            DAVResourceInterface baseRes = this.connectToResource(this.hostInfo.getUrl());
            if (baseRes == null) {
                prop = ppList.toArray(new String[0]);
                return prop;
            }
            davProperties = baseRes.getDavProperties(DAVscope).getDavProperties();
            int rc = baseRes.getStatusCode();
            if (!baseRes.SUCCEEDED() && logger != null) {
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.searcherr.fmt.txt", (Object)rc));
            }
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        finally {
            this.freeResource();
        }
        HashMap<String, Map> resourceMap = new HashMap<String, Map>();
        for (DavPropertyItem davPropertyItem : davProperties) {
            String url = Utils.URIDecode((String)davPropertyItem.getDavResourceHref(), (boolean)true);
            pmap = (Map)resourceMap.get(url);
            if (pmap == null) {
                pmap = new PropertyMap();
                resourceMap.put(url, pmap);
            }
            String nsURI = davPropertyItem.getDavProperty().getName().getNamespace().getURI();
            try {
                String pName = nsURI != null ? "{" + nsURI + "}" + XMLUtil.getElementLocalName((Node)davPropertyItem.getDavProperty().toXml(XMLUtil.newDocument())) : "{}" + XMLUtil.getElementLocalName((Node)davPropertyItem.getDavProperty().toXml(XMLUtil.newDocument()));
                if (200 != davPropertyItem.getStatusCode()) continue;
                String pValue = XMLUtil.getPropertyAsString((DavPropertyItem)davPropertyItem);
                if ("{DAV:}displayname".equals(pName) && (pValue == null || pValue.length() == 0)) {
                    url = URIUtil.stripTrailingSlashes(url);
                    int p = url.lastIndexOf("/");
                    pValue = url.substring(p + 1);
                }
                pmap.put(pName, pValue);
            }
            catch (ParserConfigurationException e) {
                if (logger == null) continue;
                logger.error(RB.getStringResource("DAVRepository.parsererr.ex.txt"), (Throwable)e);
            }
        }
        NodeList nl = searchDoc.getElementsByTagNameNS("DAV:", "where");
        Node whElem = null;
        if (nl.getLength() > 0) {
            whElem = nl.item(0).getFirstChild();
        }
        for (Map.Entry me : resourceMap.entrySet()) {
            pmap = (Map)me.getValue();
            if (!this.evalFilter(whElem, pmap)) continue;
            ppList.add(me.getKey());
        }
        return ppList.toArray(new String[0]);
    }

    private boolean evalFilter(Node component, Map properties) {
        if (component == null) {
            return true;
        }
        if (component.getNodeType() != 1) {
            return false;
        }
        String op = component.getLocalName();
        if (op.equals("eq")) {
            Element prop;
            String casesensitive;
            NamedNodeMap attr;
            Node n;
            boolean caseless = true;
            if (component.hasAttributes() && (n = (attr = component.getAttributes()).getNamedItem("casesensitive")) != null && "1".equals(casesensitive = n.getNodeValue())) {
                caseless = false;
            }
            String propName = (prop = (Element)component.getFirstChild().getFirstChild()).getNamespaceURI() == null ? "{}" + prop.getLocalName() : "{" + prop.getNamespaceURI() + "}" + prop.getLocalName();
            String propVal = (String)properties.get(propName);
            String literal = component.getLastChild().getFirstChild().getNodeValue();
            if (propName.equals("{DAV:}iscollection")) {
                propName = "{DAV:}resourcetype";
                propVal = (String)properties.get(propName);
                boolean iscollection = propVal.equals("COLLECTION");
                if (literal.equals("0")) {
                    return !iscollection;
                }
                return iscollection;
            }
            if (propVal == null) {
                return false;
            }
            if (caseless) {
                return literal.equalsIgnoreCase(propVal);
            }
            return literal.equals(propVal);
        }
        if (op.equals("like")) {
            Element prop;
            String propName;
            String propVal;
            String casesensitive;
            NamedNodeMap attr;
            Node n;
            boolean caseless = true;
            if (component.hasAttributes() && (n = (attr = component.getAttributes()).getNamedItem("casesensitive")) != null && "1".equals(casesensitive = n.getNodeValue())) {
                caseless = false;
            }
            if ((propVal = (String)properties.get(propName = (prop = (Element)component.getFirstChild().getFirstChild()).getNamespaceURI() == null ? "{}" + prop.getLocalName() : "{" + prop.getNamespaceURI() + "}" + prop.getLocalName())) == null) {
                return false;
            }
            String literal = component.getLastChild().getFirstChild().getNodeValue();
            boolean startsWithWildcard = literal.length() > 0 && literal.charAt(0) == '%';
            boolean endsWithWildcard = literal.endsWith("%");
            if (startsWithWildcard && endsWithWildcard) {
                if (literal.length() > 2) {
                    if (caseless) {
                        return propVal.toLowerCase().indexOf(literal.substring(1, literal.length() - 1).toLowerCase()) >= 0;
                    }
                    return propVal.indexOf(literal.substring(1, literal.length() - 1)) >= 0;
                }
                return true;
            }
            if (startsWithWildcard) {
                if (caseless) {
                    return propVal.toLowerCase().endsWith(literal.substring(1).toLowerCase());
                }
                return propVal.endsWith(literal.substring(1));
            }
            if (endsWithWildcard) {
                if (caseless) {
                    return propVal.toLowerCase().startsWith(literal.substring(0, literal.length() - 1).toLowerCase());
                }
                return propVal.startsWith(literal.substring(0, literal.length() - 1));
            }
            return false;
        }
        if (op.equals("and")) {
            NodeList nl = component.getChildNodes();
            boolean resultsTrue = true;
            for (int nlitem = 0; nlitem < nl.getLength() && (resultsTrue = this.evalFilter(nl.item(nlitem), properties)); ++nlitem) {
            }
            return resultsTrue;
        }
        if (op.equals("or")) {
            NodeList nl = component.getChildNodes();
            boolean resultsTrue = false;
            for (int nlitem = 0; nlitem < nl.getLength() && !(resultsTrue = this.evalFilter(nl.item(nlitem), properties)); ++nlitem) {
            }
            return resultsTrue;
        }
        if (op.equals("not")) {
            NodeList nl = component.getChildNodes();
            return !this.evalFilter(nl.item(0), properties);
        }
        if (op.equals("is-collection")) {
            String propVal = (String)properties.get("{DAV:}resourcetype");
            return propVal.equals("COLLECTION");
        }
        if (op.equals("lt")) {
            Element prop = (Element)component.getFirstChild().getFirstChild();
            String propName = prop.getNamespaceURI() == null ? "{}" + prop.getLocalName() : "{" + prop.getNamespaceURI() + "}" + prop.getLocalName();
            String propVal_s = (String)properties.get(propName);
            String literal_s = component.getLastChild().getFirstChild().getNodeValue();
            try {
                int propVal_n = Integer.parseInt((String)properties.get(propName));
                int literal_n = Integer.parseInt(component.getLastChild().getFirstChild().getNodeValue());
                return propVal_n < literal_n;
            }
            catch (NumberFormatException e) {
                return propVal_s.compareTo(literal_s) < 0;
            }
        }
        if (op.equals("lte")) {
            Element prop = (Element)component.getFirstChild().getFirstChild();
            String propName = prop.getNamespaceURI() == null ? "{}" + prop.getLocalName() : "{" + prop.getNamespaceURI() + "}" + prop.getLocalName();
            String propVal_s = (String)properties.get(propName);
            String literal_s = component.getLastChild().getFirstChild().getNodeValue();
            try {
                int propVal_n = Integer.parseInt((String)properties.get(propName));
                int literal_n = Integer.parseInt(component.getLastChild().getFirstChild().getNodeValue());
                return propVal_n <= literal_n;
            }
            catch (NumberFormatException e) {
                return propVal_s.compareTo(literal_s) <= 0;
            }
        }
        if (op.equals("gt")) {
            Element prop = (Element)component.getFirstChild().getFirstChild();
            String propName = prop.getNamespaceURI() == null ? "{}" + prop.getLocalName() : "{" + prop.getNamespaceURI() + "}" + prop.getLocalName();
            String propVal_s = (String)properties.get(propName);
            String literal_s = component.getLastChild().getFirstChild().getNodeValue();
            try {
                int propVal_n = Integer.parseInt((String)properties.get(propName));
                int literal_n = Integer.parseInt(component.getLastChild().getFirstChild().getNodeValue());
                return propVal_n > literal_n;
            }
            catch (NumberFormatException e) {
                return propVal_s.compareTo(literal_s) > 0;
            }
        }
        if (op.equals("gte")) {
            Element prop = (Element)component.getFirstChild().getFirstChild();
            String propName = prop.getNamespaceURI() == null ? "{}" + prop.getLocalName() : "{" + prop.getNamespaceURI() + "}" + prop.getLocalName();
            String propVal_s = (String)properties.get(propName);
            String literal_s = component.getLastChild().getFirstChild().getNodeValue();
            try {
                int propVal_n = Integer.parseInt((String)properties.get(propName));
                int literal_n = Integer.parseInt(component.getLastChild().getFirstChild().getNodeValue());
                return propVal_n >= literal_n;
            }
            catch (NumberFormatException e) {
                return propVal_s.compareTo(literal_s) > 0;
            }
        }
        return false;
    }

    @Override
    public Object narrow(RepositoryData entity) throws RemoteException {
        return DAVFactory.narrow(entity);
    }

    @Override
    public boolean isEqual(Object o) throws RemoteException {
        return this._DAVurl.equals(((RepositoryDef)o).getUrl());
    }

    @Override
    public FolderInterface makeRootFolder(String name) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("DAVRepository.adminroot.msg.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshEntity(MetadataInterface mi) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.refreshing.msg.fmt.txt", (Object)mi.getReposId()));
        }
        DAVEntityInterface de = (DAVEntityInterface)mi.getRepositoryEntity();
        this._cache.remove(mi.getReposId());
        MetadataInterface _mi = this.fetch(mi.getReposId());
        if (_mi == null) {
            return;
        }
        if (de instanceof DAVFolderInterface) {
            DAVFolderInterface def = (DAVFolderInterface)de;
            def.refresh((DAVFolderInterface)_mi.getRepositoryEntity());
        } else {
            DAVItemInterface dei = (DAVItemInterface)de;
            dei.refresh((DAVItemInterface)_mi.getRepositoryEntity());
            try {
                DAVResource _r = de.getDAVResource();
                if (_r == null) {
                    _r = this.connectToResource(de.getURL());
                }
                dei.setContentsfromStore((DAVResourceInterface)_r);
            }
            finally {
                this.freeResource();
            }
        }
    }

    private DAVResourceInterface connectToResource(String entityUrl) throws RemoteException {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        DAVResourceInterface r = null;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Acquiring connection to resource " + entityUrl);
        }
        if ((r = this.sharedResource.getConnection()) == null) {
            if (logger != null) {
                logger.warn(RB.getStringResource("DAVRepository.nocnctresource.txt"));
            }
            return null;
        }
        String path = null;
        int p = entityUrl.indexOf("://");
        path = p > 0 ? ((p = entityUrl.indexOf("/", p + 3)) > 0 ? entityUrl.substring(p) : "") : entityUrl;
        r.setPath(path);
        return r;
    }

    private String fetchProperties(DAVResourceInterface _r, Map<String, PropertyMap> resourceMap, int depth) throws RemoteException, ServiceException {
        String entityUrl = null;
        try {
            entityUrl = _r.getURL().toString();
            List davProperties = _r.getDavProperties(depth).getDavProperties();
            entityUrl = this.transformProperties(davProperties, resourceMap, entityUrl);
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        return entityUrl;
    }

    private String normalizeURL(String urlString) {
        try {
            URI uri;
            if (urlString.indexOf("://") != -1) {
                URL url = new URL(urlString);
                String path = url.getPath();
                if (url.getRef() != null) {
                    path = path + '#' + url.getRef();
                }
                uri = new URI(url.getProtocol(), null, url.getHost(), url.getPort(), path, null, null);
            } else {
                uri = new URI(null, null, null, -1, urlString, null, null);
            }
            URI _uri = uri.normalize();
            StringBuffer sb = new StringBuffer(45);
            if (_uri.getScheme() != null) {
                sb.append(_uri.getScheme() + "://" + _uri.getHost());
                if (_uri.getPort() != -1) {
                    sb.append(":" + _uri.getPort());
                }
            }
            sb.append(_uri.getPath());
            return sb.toString();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private String transformProperties(List<DavPropertyItem> davPropertyItems, Map<String, PropertyMap> rMap, String entityUrl) throws ServiceException {
        entityUrl = this.normalizeURL(entityUrl);
        int ptr = entityUrl.indexOf("://");
        String hostport = "";
        if (ptr != -1) {
            int index = entityUrl.indexOf("/", ptr + 3);
            hostport = index == -1 ? entityUrl : entityUrl.substring(0, index);
        }
        PropertyMap pmap = null;
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            String decodedEntityUrl;
            String path;
            if (200 != davPropertyItem.getStatusCode()) continue;
            try {
                URI uri = new URI(davPropertyItem.getDavResourceHref());
                path = uri.getPath();
            }
            catch (URISyntaxException e1) {
                throw new IllegalArgumentException(e1);
            }
            try {
                decodedEntityUrl = URLDecoder.decode(entityUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                decodedEntityUrl = entityUrl;
            }
            String url = hostport + path;
            if (Utils.isSameUrl((String)decodedEntityUrl, (String)url)) {
                entityUrl = url;
            }
            if ((pmap = rMap.get(url)) == null) {
                pmap = new PropertyMap();
                rMap.put(url, pmap);
            }
            String namespaceURI = davPropertyItem.getDavProperty().getName().getNamespace().getURI();
            try {
                String propertyValue = XMLUtil.getPropertyAsString((DavPropertyItem)davPropertyItem);
                StringBuilder key = new StringBuilder().append('{');
                if (namespaceURI != null) {
                    key.append(namespaceURI);
                }
                key.append('}').append(XMLUtil.getElementLocalName((Node)davPropertyItem.getDavProperty().toXml(XMLUtil.newDocument())));
                pmap.put((Object)key.toString(), (Object)propertyValue);
            }
            catch (ParserConfigurationException e) {
                throw new ServiceException(e, RB.getStringResource("DAVRepository.parsererr.ex.txt"));
            }
        }
        return entityUrl;
    }

    private String expand(String reposId) throws RemoteException {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String fullId = null;
        fullId = reposId;
        IdentityInterface user = this.getIdentity();
        if (user != null) {
            if (reposId.startsWith("$PR")) {
                fullId = (this.userBase.length() > 0 ? this.userBase + '/' : "") + user.getName() + "/PR" + reposId.substring(3);
            } else if (reposId.startsWith("$INBOX")) {
                fullId = (this.userBase.length() > 0 ? this.userBase + '/' : "") + user.getName() + "/PR/MyInbox" + reposId.substring(6);
            } else if (reposId.startsWith("$DOCS")) {
                fullId = (this.userBase.length() > 0 ? this.userBase + '/' : "") + user.getName() + "/PR/MyDocuments" + reposId.substring(5);
            } else if (reposId.startsWith("$RESULTS")) {
                fullId = (this.userBase.length() > 0 ? this.userBase + '/' : "") + user.getName() + "/PR/MyResults" + reposId.substring(5);
            }
        } else if (logger != null) {
            logger.warn(RB.getStringResource("DAVRepository.noperson.txt"));
        }
        return fullId;
    }

    private void processChanges(DAVResourceInterface r, Map changesMap, boolean isUpdates) throws ServiceException, RemoteException {
        String url = null;
        Iterator changes = changesMap.entrySet().iterator();
        ArrayList<PropertyName> pNameList = new ArrayList<PropertyName>();
        ArrayList<String> pValueList = new ArrayList<String>();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        while (changes.hasNext()) {
            Map.Entry me = changes.next();
            String name = (String)me.getKey();
            String value = (String)me.getValue();
            if (name == null || name.length() == 0) continue;
            pNameList.add(new PropertyName(name));
            pValueList.add(value);
            if (logger == null || !logger.isDebugEnabled()) continue;
            if (isUpdates) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.setprop.fmt.txt", (Object)name, (Object)value));
                continue;
            }
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.delprop.fmt.txt", (Object)name));
        }
        if (pNameList.size() > 0) {
            try {
                url = r.getURL().toString();
                PropertyName[] pNames = pNameList.toArray(new PropertyName[0]);
                if (isUpdates) {
                    String[] pValues = pValueList.toArray(new String[0]);
                    r.setProperties(pNames, pValues);
                } else {
                    r.removeProperties(pNames);
                }
            }
            catch (DAVException e) {
                if (isUpdates) {
                    throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.updterr.ex.fmt.txt", (Object)url));
                }
                throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.updterr.ex.fmt.txt", (Object)url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPrincipalID(DAVResourceInterface r, String id) {
        String property = "<D:displayname/>";
        if (this._OptHdrs.get("Xythos-WFS-Version") != null) {
            property = "<Z:userid/>";
        }
        String ppsReport = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><D:principal-property-search xmlns:D=\"DAV:\" xmlns:Z=\"http://www.xythos.com/namespaces/StorageServer\"><D:property-search><D:prop>" + property + "</D:prop><D:caseless-substring>" + id + "</D:caseless-substring></D:property-search><D:prop><D:displayname/><D:resourcetype/></D:prop><D:apply-to-principal_collection-set/></D:principal-property-search>";
        try {
            try {
                String owningURL;
                if (r == null && this._rootURL != null) {
                    r = this.connectToResource(this._rootURL.getPath());
                }
                if (r == null) {
                    String string = null;
                    return string;
                }
                Document document = com.sas.services.util.XMLUtil.convertStringToDocument(ppsReport);
                ReportInfo reportInfo = new ReportInfo(document.getDocumentElement(), 0);
                DavPropertyResult davPropertyResult = r.doReport(reportInfo);
                List davPropertyItems = davPropertyResult.getDavProperties();
                if (davPropertyItems.isEmpty()) {
                    String string = null;
                    return string;
                }
                DavPropertyItem davPropertyItem = (DavPropertyItem)davPropertyItems.get(0);
                String string = owningURL = davPropertyItem.getDavResourceHref();
                return string;
            }
            catch (DavException davException) {
                return null;
            }
            finally {
                this.freeResource();
            }
        }
        catch (DAVException dAVException) {
            return null;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public void freeResource() throws RemoteException {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Freeing connection to resource");
        }
        this.sharedResource.releaseConnection();
    }

    private boolean isDifferentNotNull(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return !s1.equals(s2);
        }
        return false;
    }

    private boolean isEqualNotNull(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    private String getSmartType(Map rawData) {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String key = "dav:" + ((String)rawData.get("MetadataObjectType")).toLowerCase();
        try {
            String action = this._factory.getAction(key, rawData, this);
            if (action == null) {
                return "Metadata";
            }
            String classString = action.substring(action.lastIndexOf(":") + 1);
            rawData.put("smartclass", classString);
            MetadataInterface mi = (MetadataInterface)this._factoryMap.get(action);
            if (mi == null) {
                mi = (MetadataInterface)this._factory.newInstance(classString);
                this._factoryMap.put(action, mi);
            }
            String smartType = mi.getType();
            if (mi instanceof FolderInterface) {
                rawData.put("isAFolder", "True");
            } else {
                rawData.put("isAFolder", "False");
            }
            if (smartType == null) {
                smartType = (String)rawData.get("MetadataObjectType");
            }
            return smartType;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.warn(RB.getStringResource("OMIRepository.smrttypeerr.ex.txt"), (Throwable)ex);
            return "Metadata";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMap(Map rawData) throws RemoteException {
        String resourcetype = null;
        String _type = (String)rawData.get("{http://www.sas.com/rnd/itech/WebDAV}type");
        if (_type == null || _type.equals("unknown")) {
            resourcetype = (String)rawData.get("{DAV:}resourcetype");
            _type = resourcetype.equals("COLLECTION") ? "folder" : "item";
        }
        rawData.put("MetadataObjectType", _type);
        String smartType = this.getSmartType(rawData);
        String reposIdwoType = this.getReposIdwoTypeFromUrl((String)rawData.get("Url"));
        String reposId = Utils.addSegment((String)reposIdwoType, (String)_type);
        rawData.put("reposid", reposId);
        rawData.put("smarttype", smartType);
        String isek = smartType + "+dav://" + this.getISName() + '/' + reposId;
        try {
            URI uri = new URI("dav", this.getISName(), '/' + reposId, null);
            isek = smartType + '+' + uri.toASCIIString();
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        rawData.put("ISEntityKey", isek);
        String name = (String)rawData.get("{DAV:}displayname");
        if (name == null || name.length() == 0) {
            int p = reposIdwoType.lastIndexOf("/");
            if (reposIdwoType.endsWith("/")) {
                reposIdwoType = reposIdwoType.substring(0, p);
                p = reposIdwoType.lastIndexOf("/");
            }
            name = p > -1 ? reposIdwoType.substring(p + 1) : reposIdwoType;
        }
        rawData.put("Name", name);
        String descString = (String)rawData.get(P_DESCRIPTION);
        if (descString == null && (descString = (String)rawData.get("{http://www.sas.com/rnd/itech/WebDAV}description")) == null) {
            descString = "";
        }
        rawData.put("Desc", descString);
        ArrayList keywordList = new ArrayList();
        String keywords = (String)rawData.get("{http://www.sas.com/rnd/itech/WebDAV}saskeyword");
        if (keywords != null) {
            StringTokenizer st = new StringTokenizer(keywords, " ");
            while (st.hasMoreTokens()) {
                String keyword = st.nextToken();
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("Name", keyword);
                keywordList.add(m);
            }
        }
        if (keywordList.size() > 0) {
            rawData.put("Keywords", keywordList);
        }
        long result = -1L;
        String dateString = (String)rawData.get("{DAV:}creationdate");
        SimpleDateFormat[] sdfs = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ")};
        Date date = null;
        sdfs[0].setTimeZone(TimeZone.getTimeZone("UTC"));
        sdfs[2].setTimeZone(TimeZone.getTimeZone("UTC"));
        for (int i = 0; date == null && i < sdfs.length; ++i) {
            try {
                date = sdfs[i].parse(dateString);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date != null) {
            result = date.getTime();
        }
        rawData.put("MetadataCreated", Long.toString(result));
        result = -1L;
        dateString = (String)rawData.get("{DAV:}getlastmodified");
        date = null;
        boolean parsedFine = false;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i];
                synchronized (simpleDateFormat) {
                    date = formats[i].parse(dateString);
                    parsedFine = true;
                    continue;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (parsedFine) {
            result = date.getTime();
        }
        rawData.put("MetadataUpdated", Long.toString(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetadataInterface fetchUsingUrl(String url, Map<String, String> extraProperties) throws ServiceException, RemoteException {
        this.checkConnect();
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        MetadataInterface mi = null;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.fetchmsg.fmt.txt", (Object)url, (Object)this.getUrl()));
        }
        boolean badUrl = false;
        DAVResourceInterface _r = null;
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            badUrl = true;
        }
        if (!badUrl) {
            HashMap<String, PropertyMap> resourceMap = new HashMap<String, PropertyMap>();
            try {
                _r = this.connectToResource(url);
                if (_r == null) {
                    MetadataInterface metadataInterface = null;
                    return metadataInterface;
                }
                url = this.fetchProperties(_r, resourceMap, 0);
            }
            finally {
                this.freeResource();
            }
            PropertyMap pmap = (PropertyMap)resourceMap.get(url);
            if (pmap == null) {
                return null;
            }
            Map<String, String> mpmap = this.extractPropertyStrings(pmap);
            for (String key : extraProperties.keySet()) {
                mpmap.put(key, extraProperties.get(key));
            }
            String resourceType = mpmap.get("{http://www.sas.com/rnd/itech/WebDAV}type");
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.resourcetype.fmt.txt", (Object)resourceType));
            }
            RepositoryData tmpEntity = new RepositoryData(mpmap);
            tmpEntity.setReposId(this.getPath(url) + "/type");
            tmpEntity.setRepository(this);
            DAVEntityInterface entity = (DAVEntityInterface)DAVFactory.narrow(tmpEntity);
            Object aclProperty = pmap.get((Object)"{DAV:}acl");
            if (aclProperty != null) {
                try {
                    Element acl = ((DavPropertyItem)aclProperty).getDavProperty().toXml(XMLUtil.newDocument());
                    entity.setACL(XML_DOCUMENT_HEADER + com.sas.services.util.XMLUtil.node2String(acl));
                }
                catch (ParserConfigurationException e) {
                    throw new ServiceException(e, RB.getStringResource("DAVRepository.parsererr.ex.txt"));
                }
            }
            try {
                mi = this._factory.processWithRepository(entity, this);
                if (mi != null) {
                    this._cache.put(mi);
                    return mi;
                }
            }
            catch (ServiceException e) {
                if (logger != null) {
                    logger.info(RB.getStringResource("DAVRepository.facterr.ex.txt"), (Throwable)((Object)e));
                }
                mi = new Folder(entity);
                mi.setRepository(this);
                this._cache.put(mi);
                return mi;
            }
        }
        return null;
    }

    private synchronized void checkConnect() throws ServiceException, RemoteException {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        if (this.connectCalled) {
            switch (this.connectStatus) {
                case 0: 
                case 3: {
                    this.internalConnect();
                    break;
                }
                case 1: {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.cnctfailed.ex.fmt.txt", (Object)this._url, (Object)this._rootid);
                    logger.info("Connect failed", new Throwable());
                    throw new ServiceException(msg);
                }
                case 2: {
                    return;
                }
            }
        } else {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.noprevcnct.ex.fmt.txt", (Object)this._url, (Object)this._rootid);
            logger.info("Connect failed", new Throwable());
            throw new ServiceException(msg);
        }
    }

    private void internalConnect() throws ServiceException, RemoteException {
        InformationServiceInterface is;
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepository");
        String errMsg = Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.cnctfail.ex.fmt.txt", (Object)this._url, (Object)this._rootid);
        this.connectStatus = 1;
        try {
            if (this.isTrustedAuth()) {
                this.hostInfo.setCredentialsProvider((CredentialsProvider)new OneTimePasswordCredentialsProvider(this._rootid));
            }
            this._rootResource = new DAVResource(this.hostInfo);
            if (this._rootResource == null || !this._rootResource.SUCCEEDED()) {
                if (logger != null) {
                    logger.warn(errMsg);
                }
                if (this._rootResource != null && this._rootResource.getStatusCode() == 503) {
                    this.connectStatus = 3;
                }
                throw new ServiceException(errMsg);
            }
        }
        catch (DAVException e) {
            Exception ex = e.getException();
            if (ex != null && ex instanceof ConnectException) {
                this.connectStatus = 3;
            }
            if (e.getStatusCode() == 401 && (this.isTrustedAuth() || this.isIWA())) {
                if (this.isIWA()) {
                    this.setupIWAAsTrustedAuth();
                } else if (logger != null) {
                    logger.debug("Re-attempting authentication with OTP - previous OTP rejected (expired?)");
                }
                UserIdentityInterface uii = null;
                uii = this.isIWA() ? this._user.getAuthServer().generatePassword(null) : this._user.getIdentityByDomain(this._domain);
                if (uii == null) {
                    if (logger != null) {
                        logger.debug("No identity returned for domain '" + this._domain + "'");
                    }
                    throw new ServiceException(errMsg);
                }
                this._rootpw = (String)uii.getCredential();
                this.hostInfo = new ConnectionInfo(this.hostInfo.getUrl(), this._rootid, this._rootpw);
                try {
                    if (this.isTrustedAuth()) {
                        this.hostInfo.setCredentialsProvider((CredentialsProvider)new OneTimePasswordCredentialsProvider(this._rootid));
                    }
                    this._rootResource = new DAVResource(this.hostInfo);
                    if (this._rootResource == null || !this._rootResource.SUCCEEDED()) {
                        if (logger != null) {
                            logger.warn(errMsg);
                        }
                        throw new ServiceException(errMsg);
                    }
                }
                catch (DAVException e2) {
                    if (logger != null) {
                        logger.warn(errMsg);
                        logger.warn(e2.getMessage());
                    }
                    throw new ServiceException(e2, errMsg);
                }
            }
            if (logger != null) {
                logger.warn(errMsg);
                logger.warn(e.getMessage());
            }
            throw new ServiceException(e, errMsg);
        }
        this.sharedResource = new SharedResource((DAVResourceInterface)this._rootResource);
        if (this._rootid != null && this._rootid.endsWith(GENERATED_PASSWORD_DOMAIN)) {
            this._rootid = this._rootid.substring(0, this._rootid.indexOf(GENERATED_PASSWORD_DOMAIN));
            this._rootpw = null;
        }
        boolean DAVClass1 = false;
        boolean DAVClass2 = false;
        String DAVEnabled = null;
        try {
            this._OptHdrs = this._rootResource.doOptions();
            if (this._OptHdrs != null) {
                this._DAVServer = (String)this._OptHdrs.get("Server");
                if (this._OptHdrs.containsKey("Xythos-WFS-Version")) {
                    this._DAVServer = (String)this._OptHdrs.get("Xythos-WFS-Version");
                }
                if (logger != null) {
                    logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DAVRepository.cnctpass.fmt.txt", (Object)this._DAVServer, (Object)this._url));
                    Enumeration<?> hdrNames = this._OptHdrs.propertyNames();
                    while (hdrNames.hasMoreElements()) {
                        String hdrName = (String)hdrNames.nextElement();
                        String hdrValue = this._OptHdrs.getProperty(hdrName);
                        logger.debug(hdrName + " -- " + hdrValue);
                    }
                }
                if ((DAVEnabled = (String)this._OptHdrs.get("DAV")) != null) {
                    StringTokenizer st = new StringTokenizer(DAVEnabled, ", \t\n\r\f");
                    while (st.hasMoreTokens()) {
                        String nt = st.nextToken();
                        DAVClass1 = DAVClass1 || nt.equals("1");
                        boolean bl = DAVClass2 = DAVClass2 || nt.equals("2");
                        if (!nt.equalsIgnoreCase("access-control")) continue;
                        this._supportsACL = true;
                    }
                }
                this._supportsSEARCH = this._OptHdrs.get("DASL") != null;
            }
        }
        catch (DAVException de) {
            de.printStackTrace();
        }
        if (DAVEnabled == null || !DAVClass1 || !DAVClass2) {
            String msg = RB.getStringResource("DAVRepository.nodav.txt");
            if (logger != null) {
                logger.warn(msg);
            }
            throw new ServiceException(msg);
        }
        DAVResourceInterface _r = this.connectToResource(Utils.addSegment((String)this._url, (String)"Users"));
        if (_r.exists()) {
            this.userBase = "Users";
        }
        this.freeResource();
        this.connectStatus = 2;
        MetadataInterface mi = null;
        if (this._rootid != null && this._rootid.length() > 0) {
            DAVEntityInterface d;
            String entityId = DAVRepository.getUserPath(this._user);
            if (this.userBase.length() > 0) {
                entityId = Utils.addSegment((String)this.userBase, (String)entityId);
            }
            if ((mi = this.fetch(entityId + "/person")) != null && !"person".equals((d = (DAVEntityInterface)mi.getRepositoryEntity()).getAttribute("{http://www.sas.com/rnd/itech/WebDAV}type"))) {
                d.setAttribute("{http://www.sas.com/rnd/itech/WebDAV}type", "person");
                d.update();
                this._cache.remove(mi.getReposId());
                mi = this.fetch(mi.getReposId());
            }
            if (mi instanceof PersonInterface) {
                this.setUser((PersonInterface)mi);
            }
        }
        if ((is = DAVRepository.getInformationService()) != null) {
            is.addMetadataChangeListener(this, this._url);
            is.addInformationServiceTimerClient(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int event) throws RemoteException {
        RepositoryEvent repEvent = new RepositoryEvent(this, event);
        ArrayList list = null;
        List list2 = this._listeners;
        synchronized (list2) {
            list = new ArrayList(this._listeners);
        }
        for (RepositoryListenerInterface next : list) {
            next.repositoryCallback(repEvent);
        }
    }

    @Override
    public String toString() {
        return this._DAVurl;
    }

    private String reposId2EntityUrl(String rId) {
        int p;
        String entityUrl = null;
        String hostport = "";
        if (rId.startsWith("//")) {
            int p2;
            int p1 = this._url.indexOf("://");
            if (p1 != -1) {
                int p22 = this._url.indexOf("/", p1 + 3);
                hostport = p22 != -1 ? this._url.substring(0, p22) : this._url;
            }
            rId = (p2 = rId.lastIndexOf("/")) != -1 ? rId.substring(0, p2) : "";
            entityUrl = hostport + "/" + Utils.stripLeadingSlashes((String)rId);
            return entityUrl;
        }
        if (rId.indexOf(47) != rId.lastIndexOf(47)) {
            rId = Utils.stripLeadingSlashes((String)rId);
        }
        rId = (p = rId.lastIndexOf("/")) != -1 ? rId.substring(0, p) : "";
        entityUrl = Utils.addSegment((String)this._url, (String)rId);
        return entityUrl;
    }

    private Map<String, String> extractPropertyStrings(PropertyMap pMap) throws ServiceException {
        HashMap<String, String> mpmap = new HashMap<String, String>(pMap.size());
        for (Map.Entry me : pMap.entrySet()) {
            mpmap.put((String)me.getKey(), (String)me.getValue());
        }
        return mpmap;
    }

    private String getPath(String url) {
        int p2;
        String result = url;
        int p = url.indexOf("://");
        if (p > 0 && (p2 = url.indexOf("/", p + 3)) != -1) {
            result = url.substring(p2);
        }
        return result;
    }

    @Override
    public String getServerString() {
        return this._DAVServer;
    }

    private boolean isIWA() throws RemoteException, ServiceException {
        String idPropagation = this._user.getIDPropagation();
        return this._rootpw == null && idPropagation != null && idPropagation.equalsIgnoreCase("sspi");
    }

    private void setupIWAAsTrustedAuth() throws RemoteException, ServiceException {
        ServerInterface server = this._user.getAuthServer();
        UserIdentityInterface identity = server.generatePassword(null);
        this._rootid = (String)identity.getPrincipal();
    }

    private boolean isTrustedAuth() {
        return this._rootid != null && this._rootid.endsWith(GENERATED_PASSWORD_DOMAIN);
    }

    static {
        USERS_PATH = AccessController.doPrivileged(new GetPropertyAction("com.sas.services.information.DAVRepository.user.home", ""));
        gmtZone = TimeZone.getTimeZone("GMT");
        formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US)};
    }

    @SASScope
    public class DAVEvaluator
    implements EvaluatorInterface {
        Object _theRoot;

        public DAVEvaluator(Object o) {
            this._theRoot = o;
        }

        @Override
        public boolean evaluate(String path, String value) throws RemoteException, ServiceException {
            DAVEntity de = (DAVEntity)this._theRoot;
            if (!path.startsWith("@")) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)path));
            }
            String attribute = path.substring(1);
            String myValue = de.getAttribute(attribute);
            return value.equals(myValue);
        }

        @Override
        public List setPath(String path) throws ServiceException, RemoteException {
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean evaluateObject(Object o, String attribute, String value) throws RemoteException, ServiceException {
            DAVEntity de = (DAVEntity)o;
            String attrName = attribute.substring(1);
            String myValue = de.getAttribute(attrName);
            return value.equals(myValue);
        }
    }

    final class OneTimePasswordCredentialsProvider
    implements CredentialsProvider {
        private String _userName;

        public OneTimePasswordCredentialsProvider(String userName) {
            this._userName = userName;
        }

        public Credentials getCredentials(AuthScope authScope) throws IllegalStateException {
            UsernamePasswordCredentials credentials = null;
            if (null == DAVRepository.this._user) {
                throw new IllegalStateException("Unable to get credentials since there is no user context.");
            }
            try {
                UserIdentityInterface uii;
                UserIdentityInterface userIdentityInterface = uii = DAVRepository.this.isIWA() ? DAVRepository.this._user.getAuthServer().generatePassword(null) : DAVRepository.this._user.getIdentityByDomain(DAVRepository.this._domain);
                if (null == uii) {
                    throw new IllegalStateException("No identity returned for domain '" + DAVRepository.this._domain + "'");
                }
                credentials = new UsernamePasswordCredentials(this._userName, (String)uii.getCredential());
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Failure during getCredentials", e);
            }
            catch (ServiceException e) {
                throw new IllegalStateException("Failure during getCredentials", (Throwable)((Object)e));
            }
            return credentials;
        }

        public void clear() {
        }

        public void setCredentials(AuthScope authScope, Credentials credentials) {
        }
    }
}

