/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.discovery.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
final class ServiceAttributeMatcher {
    private static final int EXCLUDED_FIELD_MODIFIERS = 152;

    private ServiceAttributeMatcher() {
    }

    static boolean matches(ServiceAttributeInterface[] attributesQuery, ServiceAttributeInterface[] attributesService) {
        boolean isMatch = true;
        Logger logger = LogManager.getLogger(ServiceAttributeMatcher.class);
        if (attributesQuery != null) {
            if (attributesService == null) {
                isMatch = false;
                ServiceAttributeMatcher.logServiceDoesNotHaveAnyAttributes(logger, attributesQuery);
            } else {
                int numAttributesQuery = attributesQuery.length;
                ServiceAttributeInterface attributeQuery = null;
                for (int i = 0; i < numAttributesQuery; ++i) {
                    attributeQuery = attributesQuery[i];
                    if (ServiceAttributeMatcher.isAttributeSatisfiedByService(attributeQuery, attributesService)) continue;
                    isMatch = false;
                    ServiceAttributeMatcher.logServiceDoesNotSatisfyAttribute(logger, attributeQuery);
                    break;
                }
            }
        }
        return isMatch;
    }

    private static boolean isAttributeSatisfiedByService(ServiceAttributeInterface attributeQuery, ServiceAttributeInterface[] attributesService) {
        boolean foundMatch = false;
        if (attributeQuery == null) {
            foundMatch = true;
        } else {
            int numServiceAttributes = attributesService != null ? attributesService.length : 0;
            ServiceAttributeInterface attributeService = null;
            for (int j = 0; j < numServiceAttributes; ++j) {
                attributeService = attributesService[j];
                if (attributeService == null || !ServiceAttributeMatcher.isMatch(attributeQuery, attributeService)) continue;
                foundMatch = true;
                break;
            }
        }
        return foundMatch;
    }

    private static boolean isMatch(Object obj1, Object obj2) {
        boolean isMatch = false;
        if (ServiceAttributeMatcher.isAssignableFrom(obj1.getClass(), obj2.getClass())) {
            Field[] obj1Fields = ServiceAttributeMatcher.getFields(obj1, 152);
            Field[] obj2Fields = ServiceAttributeMatcher.getFields(obj2, obj1, obj1Fields);
            try {
                int fieldIndex = obj1Fields != null ? obj1Fields.length : 0;
                isMatch = true;
                while (--fieldIndex >= 0) {
                    Object val = obj1Fields[fieldIndex].get(obj1);
                    if (val == null || ServiceAttributeMatcher.isMarshalledObjectEqual(val, obj2Fields[fieldIndex].get(obj2))) continue;
                    isMatch = false;
                    break;
                }
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException();
            }
        }
        return isMatch;
    }

    private static boolean isMarshalledObjectEqual(Object obj1, Object obj2) {
        boolean isEqual = false;
        if (obj1 == obj2) {
            isEqual = true;
        } else if (obj1 == null || obj2 == null) {
            isEqual = false;
        } else {
            Class<?> objClass = obj1.getClass();
            if (objClass == String.class || objClass == Integer.class || objClass == Boolean.class || objClass == Character.class || objClass == Byte.class || objClass == Short.class || objClass == Long.class || objClass == Float.class || objClass == Double.class) {
                isEqual = obj1.equals(obj2);
            } else {
                try {
                    isEqual = new MarshalledObject<Object>(obj1).equals(new MarshalledObject<Object>(obj2));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException();
                }
            }
        }
        return isEqual;
    }

    private static Field[] getFields(Object objThis, Object objOther, Field[] otherFields) {
        Field[] fields = null;
        if (objThis.getClass().equals(objOther.getClass())) {
            fields = otherFields;
        } else {
            fields = ServiceAttributeMatcher.getFields(objThis, 152);
            if (fields.length < otherFields.length) {
                throw new IllegalArgumentException();
            }
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        return fields;
    }

    private static boolean isAssignableFrom(Class thisClass, Class thatClass) {
        boolean isAssignable = false;
        if (thisClass.isAssignableFrom(thatClass)) {
            isAssignable = true;
        } else {
            String className = thisClass.getName();
            for (Class aClass = thatClass; aClass != null; aClass = aClass.getSuperclass()) {
                if (!className.equals(aClass.getName())) continue;
                isAssignable = true;
                break;
            }
        }
        return isAssignable;
    }

    private static Field[] getFields(Object object, int excludedModifiers) {
        Field[] fields = object.getClass().getFields();
        Arrays.sort(fields, new ClassFieldComparator());
        int len = 0;
        int numFields = fields.length;
        for (int i = 0; i < numFields; ++i) {
            if ((fields[i].getModifiers() & excludedModifiers) != 0) continue;
            fields[len++] = fields[i];
        }
        if (len < fields.length) {
            Field[] theFields = new Field[len];
            System.arraycopy(fields, 0, theFields, 0, len);
            fields = theFields;
        }
        return fields;
    }

    private static void logServiceDoesNotHaveAnyAttributes(Logger logger, ServiceAttributeInterface[] attributesQuery) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceAttributeMatcher.noMatchBecauseServiceHasNoAttributes.fmt.txt", (Object[])attributesQuery));
        }
    }

    private static void logServiceDoesNotSatisfyAttribute(Logger logger, ServiceAttributeInterface attributeQuery) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceAttributeMatcher.noMatchServiceDoesNotSatisfyAttribute.fmt.txt", (Object)attributeQuery));
        }
    }

    @SASScope
    private static class ClassFieldComparator
    implements Comparator<Field>,
    Serializable {
        private static final long serialVersionUID = -7123470329539415299L;

        private ClassFieldComparator() {
        }

        @Override
        public int compare(Field field1, Field field2) {
            int value = 0;
            if (null != field1 && null != field2) {
                value = field1 == field2 ? 0 : (field1.getDeclaringClass() == field2.getDeclaringClass() ? field1.getName().compareTo(field2.getName()) : (field1.getDeclaringClass().isAssignableFrom(field2.getDeclaringClass()) ? -1 : 1));
            }
            return value;
        }
    }
}

