/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.discovery.LookupPolicyInterface;
import com.sas.services.discovery.RB;
import com.sas.text.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class LookupPolicyTimeout
implements LookupPolicyInterface {
    private final Map<String, Long> _lookupRequestMap = new HashMap<String, Long>(5);
    private static final long DEFAULT_TIMEOUT_MSEC = 60000L;
    private long _timeoutInMsec = 60000L;

    public LookupPolicyTimeout() {
        this(60000L);
    }

    public LookupPolicyTimeout(long timeoutInMsec) {
        this.setTimeout(timeoutInMsec);
    }

    public final void setTimeout(long timeoutInMsec) {
        this._timeoutInMsec = timeoutInMsec > 0L ? timeoutInMsec : 0L;
    }

    @Override
    public final void serviceLookupInitiated(String serviceLookupRequestId) {
        if (serviceLookupRequestId != null) {
            Long startTime = System.currentTimeMillis();
            this._lookupRequestMap.put(serviceLookupRequestId, startTime);
        }
    }

    @Override
    public final void serviceLookupTerminated(String serviceLookupRequestId) {
        if (serviceLookupRequestId != null) {
            this._lookupRequestMap.remove(serviceLookupRequestId);
        }
    }

    @Override
    public final boolean isOKToRetryLookup(String serviceLookupRequestId) {
        boolean isOKToRetryLookup = false;
        if (serviceLookupRequestId != null) {
            try {
                long startTime = this._lookupRequestMap.get(serviceLookupRequestId);
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime < this._timeoutInMsec) {
                    isOKToRetryLookup = true;
                }
            }
            catch (ClassCastException e) {
                isOKToRetryLookup = false;
            }
        }
        return isOKToRetryLookup;
    }

    public final String toString() {
        String value = "";
        try {
            value = Message.format((ResourceBundle)RB.getResources(), (String)"LookupPolicyTimeout.toString.fmt.txt", (Object)this._timeoutInMsec);
        }
        catch (MissingResourceException e) {
            value = "";
        }
        return value;
    }
}

