/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentImportFile;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class URLMetadataSource
extends AbstractMetadataSource
implements MetadataSourceInterface {
    private static final long serialVersionUID = 487646172453168374L;
    private URL _url;
    private transient InputStream _inputStream;

    public URLMetadataSource(URL url) {
        this.setURL(url);
    }

    public URLMetadataSource(URL url, String softwareComponentName) throws InitializationException {
        this(url, softwareComponentName, new HashSet<String>(0));
    }

    public URLMetadataSource(InputStream inputStream, String softwareComponentName) throws InitializationException {
        this(inputStream, softwareComponentName, new HashSet<String>(0));
    }

    public URLMetadataSource(URL url, String softwareComponentName, String serviceGroupName) throws InitializationException {
        super(softwareComponentName, serviceGroupName);
        this.setURL(url);
    }

    public URLMetadataSource(InputStream inputStream, String softwareComponentName, String serviceGroupName) throws InitializationException {
        super(softwareComponentName, serviceGroupName);
        this.setInputStream(inputStream);
    }

    public URLMetadataSource(URL url, Set<String> serviceGroupNames) throws InitializationException {
        super(serviceGroupNames);
        this.setURL(url);
    }

    public URLMetadataSource(URL url, String softwareComponentName, Set<String> serviceGroupNames) throws InitializationException {
        super(softwareComponentName, serviceGroupNames);
        this.setURL(url);
    }

    public URLMetadataSource(InputStream inputStream, String softwareComponentName, Set<String> serviceGroupNames) throws InitializationException {
        super(softwareComponentName, serviceGroupNames);
        this.setInputStream(inputStream);
    }

    private void setInputStream(InputStream inputStream) throws IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException(RB.getStringResource("URLMetadataSource.mustSpecifyInputStream.ex.txt"));
        }
        this._inputStream = inputStream;
    }

    private void setURL(URL url) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException(RB.getStringResource("URLMetadataSource.mustSpecifyURL.ex.txt"));
        }
        this._url = url;
        InputStream inputStream = null;
        ServiceDeploymentImportFile importFile = null;
        try {
            inputStream = url.openStream();
            importFile = new ServiceDeploymentImportFile(inputStream);
            this.setApplicationServiceDeployment(importFile.getServiceDeploymentName());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"URLMetadataSource.ioException.ex.fmt.txt", (Object)e.getLocalizedMessage()));
        }
        finally {
            block13: {
                if (importFile != null) {
                    importFile.destroy();
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        Logger logger = LogManager.getLogger(URLMetadataSource.class);
                        if (logger == null) break block13;
                        logger.error(e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    public URL getURL() {
        return this._url;
    }

    @Override
    public String toString() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"URLMetadataSource.toString.fmt.txt", (Object)AccessController.doPrivileged(new GetPropertyAction("line.separator")), (Object)super.toString(), this._url == null ? null : this._url.toString());
    }

    @Override
    public String getMetadata() throws ServiceException {
        Logger logger = LogManager.getLogger(URLMetadataSource.class);
        String metadataXml = null;
        InputStream inputStream = null;
        try {
            if (this._url == null && this._inputStream == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"URLMetadataSource.unableToObtainMetadataFromURL.ex.fmt.txt", (Object)this._url);
                if (logger != null) {
                    logger.error(msg);
                }
                throw new ServiceException(msg);
            }
            if (this._url != null) {
                URLConnection urlConnection = this._url.openConnection();
                urlConnection.connect();
                inputStream = urlConnection.getInputStream();
            } else if (this._inputStream != null) {
                inputStream = this._inputStream;
            }
            metadataXml = AbstractMetadataSource.getStringFromInputSource(inputStream);
        }
        catch (FileNotFoundException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"URLMetadataSource.unableToObtainMetadataFromURLFileNotFound.ex.fmt.txt", (Object)this._url);
            if (logger != null) {
                logger.error(msg);
            }
            throw new ServiceException(e, msg);
        }
        catch (IOException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"URLMetadataSource.unableToObtainMetadataFromURL.ex.fmt.txt", (Object)this._url, (Object)e.getLocalizedMessage());
            if (logger != null) {
                logger.error(msg);
            }
            throw new ServiceException(e, msg);
        }
        finally {
            block19: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (logger == null) break block19;
                        logger.error(e.getLocalizedMessage());
                    }
                }
            }
        }
        return metadataXml;
    }

    @Override
    protected String getDeployFailureMessage() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.unableToObtainServicesFromURLMetadataSource.ex.fmt.txt", (Object)this.getURL());
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (this._url != null) {
            hashCode ^= this._url.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object other) {
        boolean isEqual = false;
        try {
            URLMetadataSource another = (URLMetadataSource)other;
            isEqual = this._url != null && another._url != null ? this._url.equals(another._url) && super.equals(other) : super.equals(other);
        }
        catch (ClassCastException e) {
            isEqual = false;
        }
        return isEqual;
    }
}

