/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.entities.GUID;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMIUtilImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.NamedService;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.net.ssl.SSLRMIConfiguration;
import com.sas.net.ssl.SSLRMIConfigurationException;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.DeployableService;
import com.sas.services.deployment.DeployableServiceFactory;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceConfiguration;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RMIBinding;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.services.deployment.RMIDeployableService;
import com.sas.services.deployment.ServiceDependencyComparator;
import com.sas.services.deployment.ServiceDeploymentException;
import com.sas.services.deployment.ServiceLookupFailedException;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.FindServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.LookupPolicyInterface;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.COMM_FAILURE;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceLoader {
    private static final String NEW_LINE = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private static final String CLASS_NAME = ServiceLoader.class.getName();
    private static final int MSEC_PER_SECOND = 1000;
    private static final String[] SERVICE_TYPES = new String[]{"com.sas.services.RemoteServiceInterface"};
    private static final String[] SERVICE_TYPES_DISCOVERY = new String[]{"com.sas.services.discovery.FindServiceInterface", "com.sas.services.RemoteServiceInterface"};
    private static final Object SYNCH_OBJECT = new Object();
    private static final Logger LOGGER = LogManager.getLogger(ServiceLoader.class);

    private ServiceLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<DeployableService> getDeployableServices(String xml, String[] serviceTypes, boolean isRemoteDiscoveryService, MetadataSourceInterface metadataSource, Environment environment) throws ServiceException {
        TreeSet<DeployableService> serviceComponents;
        block22: {
            boolean isDebugLogEnabled = LOGGER.isDebugEnabled();
            serviceComponents = new TreeSet<DeployableService>(new ServiceDependencyComparator());
            Throwable ex = null;
            MdObjectStore mdStore = null;
            try {
                int numGroupRestrictions;
                Set<String> deploymentGroupNames = metadataSource.getServiceDeploymentNames();
                mdStore = metadataSource.getMdObjectStore();
                MdOMIUtil mdOMIUtil = mdStore.getFactory().getOMIUtil();
                ((MdOMIUtilImpl)mdOMIUtil).populateStoreFromString((MdStore)mdStore, xml, 1, false);
                Map map = mdStore.getDetailObjectMap();
                Iterator iter = map.values().iterator();
                Object o = null;
                SoftwareComponent softwareComponent = null;
                int n = numGroupRestrictions = deploymentGroupNames != null ? deploymentGroupNames.size() : 0;
                while (iter.hasNext()) {
                    o = iter.next();
                    try {
                        DeployedComponent deployedComponent = o;
                        if (deployedComponent == null) continue;
                    }
                    catch (ClassCastException e) {
                        try {
                            softwareComponent = o;
                            for (Tree tree : softwareComponent.getSoftwareTrees(false)) {
                                Iterator memberIter = tree.getMembers(false).iterator();
                                while (memberIter.hasNext()) {
                                    try {
                                        ServiceComponent serviceComponent = (ServiceComponent)memberIter.next();
                                        if (numGroupRestrictions > 0 && !deploymentGroupNames.contains(tree.getName())) {
                                            if (!isDebugLogEnabled) continue;
                                            LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.serviceComponentNotInDeployableGroup.fmt.txt", (Object)serviceComponent.getName(), (Object)serviceComponent.getFQID(), (Object)tree.getName()));
                                            continue;
                                        }
                                        if (!ServiceLoader.satisfiesServiceType(serviceComponent, serviceTypes)) continue;
                                        if (!isRemoteDiscoveryService) {
                                            DeployableService deployableService = DeployableServiceFactory.getDeployableService(serviceComponent, serviceTypes, softwareComponent, metadataSource, environment);
                                            if (deployableService == null) continue;
                                            serviceComponents.add(deployableService);
                                            continue;
                                        }
                                        try {
                                            ServiceLoader.addRemoteDiscoveryService(serviceComponent, serviceComponents, metadataSource instanceof AbstractMetadataSource ? (AbstractMetadataSource)metadataSource : null);
                                        }
                                        catch (ServiceException se) {
                                            LOGGER.error(se.getLocalizedMessage());
                                        }
                                    }
                                    catch (ClassCastException cce1) {}
                                }
                            }
                        }
                        catch (ClassCastException cce2) {}
                    }
                }
            }
            catch (MdException e) {
                ex = e;
                return ex;
            }
            catch (RemoteException e) {
                ex = e;
                return ex;
            }
            catch (ClassCastException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block22;
                throw new ServiceException(ex, RB.getStringResource("ServiceLoader.getDeployableServices.ex.txt"));
            }
        }
        return serviceComponents;
    }

    private static final void addRemoteDiscoveryService(ServiceComponent serviceComponent, Set<DeployableService> deployableServices, AbstractMetadataSource metadataSource) throws ServiceException {
        try {
            Set<RMIBinding> rmiBindings;
            if (serviceComponent != null && (rmiBindings = ServiceLoader.getRMIBindings(serviceComponent)).size() > 0) {
                Iterator<RMIBinding> iterRmiBindings = rmiBindings.iterator();
                RMIBinding rmiBinding = null;
                HashSet<RMIBinding> bindings = null;
                while (iterRmiBindings.hasNext()) {
                    rmiBinding = iterRmiBindings.next();
                    try {
                        ServiceConfigurationInterface serviceConfiguration = DeployableServiceFactory.getServiceConfiguration(serviceComponent, LOGGER);
                        bindings = new HashSet<RMIBinding>(1);
                        bindings.add(rmiBinding);
                        deployableServices.add(new RMIDeployableService(serviceComponent.getFQID(), serviceConfiguration, null, bindings, metadataSource));
                    }
                    catch (ServiceException e) {
                        LOGGER.error(RB.getStringResource("ServiceLoader.invalidRmiDeployableService.ex.txt"), (Throwable)((Object)e));
                    }
                }
            }
        }
        catch (RemoteException e) {
            String msg = RB.getStringResource("ServiceLoader.invalidRmiDeployableService.ex.txt");
            LOGGER.warn(msg, (Throwable)e);
            throw new ServiceException(e, msg);
        }
    }

    public static final List<FindServiceInterface> lookupRemoteDiscoveryServices(MetadataSourceInterface metadataSource, DiscoveryServiceInterface discoveryService) throws ServiceException, ServiceLookupFailedException {
        LookupPolicyInterface lookupPolicy = null;
        if (discoveryService instanceof LocalDiscoveryServiceInterface) {
            lookupPolicy = ((LocalDiscoveryServiceInterface)discoveryService).getLookupPolicy();
        }
        return ServiceLoader.lookupRemoteDiscoveryServices(metadataSource, discoveryService, lookupPolicy);
    }

    public static final List<FindServiceInterface> lookupRemoteDiscoveryServices(MetadataSourceInterface metadataSource) throws ServiceException, ServiceLookupFailedException {
        return ServiceLoader.lookupRemoteDiscoveryServices(metadataSource, DiscoveryService.defaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<FindServiceInterface> lookupRemoteDiscoveryServices(MetadataSourceInterface metadataSourceLookup, DiscoveryServiceInterface discoveryService, LookupPolicyInterface lookupPolicy) throws ServiceException, ServiceLookupFailedException {
        int numServicesToDeploy = 0;
        if (metadataSourceLookup == null) {
            throw new ServiceException(RB.getStringResource("ServiceLoader.metadataSourceMustBeSpecified.ex.txt"));
        }
        ArrayList<RemoteServiceInterface> deployedServices = new ArrayList<RemoteServiceInterface>(5);
        MetadataSourceInterface metadataSource = metadataSourceLookup;
        Object object = SYNCH_OBJECT;
        synchronized (object) {
            try {
                DiscoveryService.defaultInstance();
                discoveryService.setServiceState(new ServiceState(1));
                boolean isRemoteDiscoveryService = true;
                Set<DeployableService> deployableServices = ServiceLoader.getDeployableServices(OMRMetadataSource.class.getName().equals(metadataSource.getClass().getName()) ? ((OMRMetadataSource)metadataSource).getMetadataToLocateRemoteDiscoveryServices() : metadataSource.getMetadata(), SERVICE_TYPES_DISCOVERY, true, metadataSource, null);
                if (deployableServices == null || deployableServices.size() == 0) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.lookupRDSInvalidConfiguration.ex.fmt.txt", (Object)metadataSource));
                }
                numServicesToDeploy = deployableServices.size();
                if (lookupPolicy != null) {
                    String lookupId = GUID.newGUID();
                    lookupPolicy.serviceLookupInitiated(lookupId);
                    do {
                        ServiceLoader.deploy(deployableServices, discoveryService, deployedServices);
                    } while ((numServicesToDeploy = deployableServices.size()) > 0 && lookupPolicy.isOKToRetryLookup(lookupId));
                } else {
                    ServiceLoader.deploy(deployableServices, discoveryService, deployedServices);
                }
                int numFailures = deployableServices.size();
                if (numFailures > 0) {
                    DeployableService[] deployableServiceArray = new DeployableService[numFailures];
                    Object[] arr = deployableServices.toArray();
                    System.arraycopy(arr, 0, deployableServiceArray, 0, numFailures);
                    throw new ServiceLookupFailedException(deployableServiceArray);
                }
            }
            catch (ServiceException e) {
                ServiceLoader.logDeployFailure(metadataSource);
                throw e;
            }
            catch (RemoteException e) {
                ServiceLoader.logDeployFailure(metadataSource);
                throw new ServiceException(e, RB.getStringResource("ServiceLoader.unableToLookupDiscoveryServices.ex.txt"));
            }
            finally {
                if (metadataSource != null) {
                    metadataSource.destroy();
                }
            }
        }
        ArrayList<FindServiceInterface> serviceFinders = new ArrayList<FindServiceInterface>(deployedServices.size());
        for (RemoteServiceInterface service : deployedServices) {
            if (!(service instanceof FindServiceInterface)) continue;
            serviceFinders.add((FindServiceInterface)((Object)service));
        }
        return serviceFinders;
    }

    public static final List<RemoteServiceInterface> deployServices(MetadataSourceInterface metadataSource) throws ServiceDeploymentException, ServiceException {
        return ServiceLoader.deployServices(metadataSource, DiscoveryService.defaultInstance());
    }

    public static final List<RemoteServiceInterface> deployServices(MetadataSourceInterface metadataSource, DiscoveryServiceInterface discoveryService) throws ServiceDeploymentException, ServiceException {
        return ServiceLoader.deployServices(metadataSource, null, discoveryService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<RemoteServiceInterface> deployServices(MetadataSourceInterface metadataSource, Environment environment, DiscoveryServiceInterface discoveryService) throws ServiceDeploymentException, ServiceException {
        if (metadataSource == null) {
            throw new ServiceException(RB.getStringResource("ServiceLoader.metadataSourceMustBeSpecified.ex.txt"));
        }
        ArrayList<RemoteServiceInterface> deployedServices = new ArrayList<RemoteServiceInterface>(10);
        Object object = SYNCH_OBJECT;
        synchronized (object) {
            block17: {
                Serializable exception = null;
                try {
                    DiscoveryService.defaultInstance();
                    Set<DeployableService> deployableServices = null;
                    discoveryService.setServiceState(new ServiceState(1));
                    String metadataXml = null;
                    try {
                        metadataXml = ((OMRMetadataSource)metadataSource).getMetadataToDeployServices();
                    }
                    catch (ClassCastException e) {
                        metadataXml = metadataSource.getMetadata();
                    }
                    boolean isRemoteDiscoveryService = false;
                    deployableServices = ServiceLoader.getDeployableServices(metadataXml, SERVICE_TYPES, false, metadataSource, environment);
                    if (deployableServices == null || deployableServices.size() == 0) {
                        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.noServicesToDeploy.ex.fmt.txt", (Object)metadataSource));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        StringBuilder sb = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.deploymentOrder.fmt.txt", (Object)NEW_LINE));
                        int i = 1;
                        String item = null;
                        for (DeployableService deployableService : deployableServices) {
                            if (deployableService == null) continue;
                            item = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.deploymentOrderItem.fmt.txt", (Object)i++, (Object)deployableService.getId(), (Object)deployableService.getServiceFactory(), (Object)NEW_LINE);
                            sb.append(item);
                        }
                        LOGGER.debug(sb.toString());
                    }
                    if (deployableServices != null && deployableServices.size() > 0) {
                        ServiceLoader.deploy(deployableServices, discoveryService, deployedServices);
                    }
                }
                catch (ServiceException e) {
                    exception = e;
                    return exception;
                }
                catch (RemoteException e) {
                    exception = e;
                    return exception;
                }
                finally {
                    if (exception == null) break block17;
                    ServiceLoader.logDeployFailure(metadataSource);
                    throw new ServiceDeploymentException((Exception)exception, RB.getStringResource("ServiceLoader.deployFailed.ex.txt"), deployedServices, null);
                }
            }
        }
        return deployedServices;
    }

    private static String logDeployFailure(MetadataSourceInterface metadataSource) {
        String msg = metadataSource instanceof AbstractMetadataSource ? ((AbstractMetadataSource)metadataSource).getDeployFailureMessage() : Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.unableToObtainServicesFromMetadata.ex.fmt.txt", (Object)metadataSource);
        LOGGER.error(msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void determineServicesForMetadataObject(MetadataSourceInterface metadataSource, Set<DeployableService> deployableServices, CMetadata object, String[] serviceTypes, SoftwareComponent softwareComponent) throws ServiceException {
        block18: {
            ServiceComponent aServiceComponent = null;
            Throwable ex = null;
            try {
                if (object instanceof ServiceComponent) {
                    DeployableService deployableService;
                    aServiceComponent = (ServiceComponent)object;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.manufactureDeployableService.fmt.txt", (Object)aServiceComponent.getFQID(), (Object)aServiceComponent.getName()));
                    }
                    if ((deployableService = DeployableServiceFactory.getDeployableService(aServiceComponent, serviceTypes, softwareComponent, metadataSource)) == null) break block18;
                    try {
                        ServiceConfigurationInterface serviceConfiguration = deployableService.getServiceConfiguration();
                        MetadataSourceConfiguration msf = new MetadataSourceConfiguration(metadataSource);
                        serviceConfiguration.addServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_METADATA_SOURCE, msf);
                    }
                    catch (InitializationException e) {
                        LOGGER.warn(RB.getStringResource("ServiceLoader.unableToAddMetadataSourceConfiguration.ex.txt"));
                    }
                    deployableServices.add(deployableService);
                    break block18;
                }
                if (object instanceof SoftwareComponent) {
                    SoftwareComponent sc = (SoftwareComponent)object;
                    String softwareComponentClassId = sc != null ? sc.getClassIdentifier() : "";
                    String softwareComponentName = sc != null ? sc.getName() : "";
                    boolean isDeployable = metadataSource.isServiceDeploymentDeployable(softwareComponentName);
                    if (isDeployable && "ABC1234567890".equals(softwareComponentClassId)) {
                        Iterator iteratorObjects = sc.getSoftwareTrees().iterator();
                        while (iteratorObjects.hasNext()) {
                            ServiceLoader.determineServicesForMetadataObject(metadataSource, deployableServices, (CMetadata)iteratorObjects.next(), serviceTypes, sc);
                        }
                    }
                } else if (object instanceof Tree) {
                    Tree tree = (Tree)object;
                    boolean isDeployable = metadataSource.isServiceDeploymentDeployable(metadataSource.getApplicationServiceDeployment(), tree);
                    if (isDeployable) {
                        Iterator iteratorObjects = tree.getMembers().iterator();
                        while (iteratorObjects.hasNext()) {
                            ServiceLoader.determineServicesForMetadataObject(metadataSource, deployableServices, (CMetadata)iteratorObjects.next(), serviceTypes, softwareComponent);
                        }
                    }
                }
            }
            catch (MdException e) {
                ex = e;
            }
            catch (RemoteException e) {
                ex = e;
            }
            finally {
                if (ex == null) break block18;
                String msg = ex.getLocalizedMessage();
                LOGGER.error(msg, ex);
                throw new ServiceException(ex, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<RMIBinding> getRMIBindings(ServiceComponent serviceComponent) throws ServiceException {
        HashSet<RMIBinding> rmiBindings;
        block10: {
            rmiBindings = new HashSet<RMIBinding>(1);
            Throwable ex = null;
            try {
                NamedService namedService = null;
                Object object222 = null;
                DeployedComponent namingService = null;
                for (Object object222 : serviceComponent.getServiceNames()) {
                    if (!(object222 instanceof NamedService)) continue;
                    namedService = object222;
                    for (Object object222 : namedService.getNamingServices()) {
                        if (!(object222 instanceof DeployedComponent)) continue;
                        namingService = object222;
                        for (Object object222 : namingService.getSourceConnections()) {
                            if (!(object222 instanceof TCPIPConnection)) continue;
                            TCPIPConnection tcpipConnection = object222;
                            rmiBindings.add(new RMIBinding(new RMIConfiguration(tcpipConnection.getHostName(), tcpipConnection.getPort()), namedService.getServiceName(), 2));
                        }
                    }
                }
            }
            catch (MdException e) {
                ex = e;
                return ex;
            }
            catch (RemoteException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block10;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.unableToDetermineRMIBindings.ex.fmt.txt", (Object)serviceComponent);
                LOGGER.warn(msg, ex);
                throw new ServiceException(ex, msg);
            }
        }
        return rmiBindings;
    }

    private static final boolean satisfiesServiceType(ServiceComponent serviceComponent, String[] serviceTypes) throws MdException, RemoteException {
        boolean satisfiesServiceTypes;
        boolean bl = satisfiesServiceTypes = serviceComponent != null;
        if (satisfiesServiceTypes && serviceTypes != null && serviceTypes.length > 0) {
            satisfiesServiceTypes = false;
            int numServiceTypes = serviceTypes.length;
            int numMatches = 0;
            for (int i = 0; i < numServiceTypes; ++i) {
                String desiredService = serviceTypes[i];
                for (ServiceType serviceType : serviceComponent.getServiceTypes()) {
                    String interfaceName = serviceType.getInterfaceName();
                    if (!interfaceName.equals(desiredService)) continue;
                    ++numMatches;
                    break;
                }
                if (numMatches == i) break;
            }
            satisfiesServiceTypes = numMatches == numServiceTypes;
        }
        return satisfiesServiceTypes;
    }

    private static void deploy(Set<DeployableService> deployableServices, DiscoveryServiceInterface discoveryService, List<RemoteServiceInterface> deployedServices) throws ServiceException {
        if (deployableServices != null) {
            boolean isDebugLogEnabled = LOGGER.isDebugEnabled();
            int initialNumServicesToDeploy = deployableServices.size();
            Iterator<DeployableService> iterator = deployableServices.iterator();
            DeployableService deployableService = null;
            RemoteServiceInterface deployedObject = null;
            while (iterator.hasNext()) {
                deployableService = iterator.next();
                if (!ServiceLoader.isOkToDeploy(deployableService, discoveryService)) continue;
                try {
                    deployedObject = deployableService.deploy(discoveryService);
                    if (deployedObject != null) {
                        deployedServices.add(deployedObject);
                        iterator.remove();
                    }
                    if (!isDebugLogEnabled || deployedObject == null) continue;
                    LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.deployedService.fmt.txt", (Object)deployedObject, (Object)deployableService.getId()));
                }
                catch (ServiceException e) {
                    if (LOGGER == null) continue;
                    String errorMsg = e.getMessage();
                    String msg = errorMsg != null ? Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.unableToDeployBecause.fmt.txt", (Object)deployableService.getId(), (Object)errorMsg) : Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.unableToDeploy.fmt.txt", (Object)deployableService.getId());
                    LOGGER.error(msg, (Throwable)((Object)e));
                    throw e;
                }
            }
            int numberOfServicesToDeploy = deployableServices.size();
            if (initialNumServicesToDeploy > numberOfServicesToDeploy && numberOfServicesToDeploy > 0) {
                ServiceLoader.deploy(deployableServices, discoveryService, deployedServices);
            }
        }
    }

    private static boolean isOkToDeploy(DeployableService deployableService, DiscoveryServiceInterface discoveryService) {
        boolean isOkToDeploy = true;
        boolean isDebugLogEnabled = LOGGER.isDebugEnabled();
        String neededId = null;
        Set<String> dependencySet = deployableService.getDependencies();
        Iterator<String> iteratorDependencies = dependencySet.iterator();
        ServiceTemplate serviceTemplate = null;
        if (iteratorDependencies.hasNext()) {
            MetadataAttribute serviceAttribute = new MetadataAttribute(null, null, "ServiceComponent", "ABC1212121212");
            try {
                serviceTemplate = new ServiceTemplate(new Class[]{RemoteServiceInterface.class}, new ServiceAttributeInterface[]{serviceAttribute});
                while (iteratorDependencies.hasNext()) {
                    serviceAttribute.id = neededId = iteratorDependencies.next();
                    serviceTemplate.clearPassport();
                    try {
                        discoveryService.findService(serviceTemplate);
                        if (!isDebugLogEnabled) continue;
                        LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.discoveredServiceId.fmt.txt", (Object)neededId));
                    }
                    catch (ServiceNotAvailableException e) {
                        isOkToDeploy = false;
                        if (isDebugLogEnabled) {
                            LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.didNotDiscoverServiceId.fmt.txt", (Object)neededId), (Throwable)((Object)e));
                        }
                        break;
                    }
                    catch (ServiceException e) {
                        isOkToDeploy = false;
                        break;
                    }
                    catch (RemoteException e) {
                        isOkToDeploy = false;
                        break;
                    }
                }
            }
            catch (InitializationException e) {
                LOGGER.error("ServiceLoader.unableToConstructServiceTemplate.txt", (Throwable)((Object)e));
            }
        }
        if (isDebugLogEnabled) {
            LOGGER.debug(isOkToDeploy ? Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.isOkToDeploy.fmt.txt", (Object)deployableService.getId()) : Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.notOkToDeploySinceDependsOn.fmt.txt", (Object)deployableService.getId(), neededId));
        }
        return isOkToDeploy;
    }

    @SASScope
    public static void main(String[] args) {
        ServiceLoader.test(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test(String[] args) {
        block132: {
            boolean isDebugLogEnabled = LOGGER.isDebugEnabled();
            boolean isInfoLogEnabled = LOGGER.isInfoEnabled();
            long startTime = System.currentTimeMillis();
            boolean testCaseLoadServices = false;
            boolean testCaseLookupDiscoveryServices = true;
            LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
            InputStream sslRMIConfigurationInputStream = null;
            MetadataSourceInterface metadataSource = null;
            try {
                Properties properties;
                String propertiesFile;
                String softwareComponentName = null;
                String serviceDeploymentName = null;
                int testCase = -1;
                if (args.length == 2) {
                    testCase = Integer.parseInt(args[0]);
                    propertiesFile = args[1];
                    properties = new Properties();
                    properties.load(new FileInputStream(propertiesFile));
                    metadataSource = MetadataSourceFactory.newMetadataSource(properties);
                } else if (args.length == 3) {
                    testCase = Integer.parseInt(args[0]);
                    propertiesFile = args[1];
                    properties = new Properties();
                    properties.load(new FileInputStream(propertiesFile));
                    String sslRMIConfigurationFile = args[2];
                    sslRMIConfigurationInputStream = new FileInputStream(sslRMIConfigurationFile);
                    SSLRMISocketFactories.getInstance().setConfiguration(new SSLRMIConfiguration(sslRMIConfigurationInputStream));
                    metadataSource = MetadataSourceFactory.newMetadataSource(properties);
                } else if (args.length > 3) {
                    testCase = Integer.parseInt(args[0]);
                    softwareComponentName = args[1];
                    serviceDeploymentName = args[2];
                }
                switch (args.length) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        String fileUrl = args[3];
                        URL metadataUrl = new URL(fileUrl);
                        metadataSource = new URLMetadataSource(metadataUrl, softwareComponentName, serviceDeploymentName);
                        if (!isDebugLogEnabled) break;
                        LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.obtainMetadataFromUrl.fmt.txt", (Object)fileUrl));
                        break;
                    }
                    case 8: {
                        String omrHost = args[3];
                        String omrPort = args[4];
                        String string = args[5];
                        String omrIdentityPassword = args[6];
                        String omrRepositoryId = args[7];
                        HashSet<String> repositoryIds = new HashSet<String>(1);
                        repositoryIds.add(omrRepositoryId);
                        metadataSource = new OMRMetadataSource(omrHost, omrPort, string, omrIdentityPassword, omrRepositoryId, softwareComponentName, serviceDeploymentName);
                        if (!isDebugLogEnabled) break;
                        LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.obtainMetadataFromOmr.fmt.txt", (Object)omrHost, (Object)omrPort, (Object)omrRepositoryId));
                        break;
                    }
                    default: {
                        metadataSource = null;
                    }
                }
                if (metadataSource != null) {
                    switch (testCase) {
                        case 1: {
                            List<Remote> deployedServices;
                            if (isDebugLogEnabled) {
                                LOGGER.debug(RB.getStringResource("ServiceLoader.lookingUpRemoteDiscoveryServices.txt"));
                            }
                            LookupPolicyInterface lookupPolicyIf = null;
                            InformationServiceInterface infoService = null;
                            InformationServiceInterface infoService2 = null;
                            try {
                                ServiceConfigurationInterface serviceDiscoveryConfig;
                                short state;
                                deployedServices = ServiceLoader.lookupRemoteDiscoveryServices(metadataSource, discoveryService, lookupPolicyIf);
                                if (isDebugLogEnabled) {
                                    Object var17_51 = null;
                                    for (Remote remote : deployedServices) {
                                        LOGGER.debug(ServiceLoader.getServiceDeployedMessage(remote.getClass(), remote instanceof EntityKeyInterface ? ((EntityKeyInterface)remote).getEntityKey() : null));
                                    }
                                }
                                Class[] classArray = new Class[]{UserServiceInterface.class};
                                ServiceAttributeInterface[] serviceAttributes = new ServiceAttributeInterface[]{new MetadataAttribute(null, metadataSource.getApplicationServiceDeployment(), "SoftwareComponent", "ABC1234567890")};
                                ServiceTemplate userSvcTemplate = new ServiceTemplate(classArray, serviceAttributes);
                                UserServiceInterface aUserService = (UserServiceInterface)discoveryService.findService(userSvcTemplate);
                                try {
                                    state = aUserService.getServiceState();
                                    if (isDebugLogEnabled) {
                                        LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.serviceState.fmt.txt", (Object)aUserService.getClass().getName(), (Object)state));
                                    }
                                }
                                catch (RemoteException e) {
                                    LOGGER.error(e.getLocalizedMessage());
                                }
                                try {
                                    state = aUserService.getServiceState();
                                    if (isDebugLogEnabled) {
                                        LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.serviceState.fmt.txt", (Object)aUserService.getClass().getName(), (Object)state));
                                    }
                                }
                                catch (RemoteException e) {
                                    LOGGER.error(e.getLocalizedMessage());
                                }
                                ServiceTemplate infoSvcTemplate = new ServiceTemplate(new Class[]{InformationServiceInterface.class});
                                infoService = (InformationServiceInterface)discoveryService.findService(infoSvcTemplate);
                                infoService.getReposDefs();
                                if (AccessController.doPrivileged(new GetPropertyAction("com.sas.services.deployment.pauseServiceLoader")) != null) {
                                    ServiceLoader.pauseApplication(LOGGER);
                                }
                                infoService.getReposDefs();
                                infoSvcTemplate.clearPassport();
                                infoService2 = (InformationServiceInterface)discoveryService.findService(infoSvcTemplate);
                                if (isDebugLogEnabled) {
                                    LOGGER.debug((Object)infoService2);
                                }
                                infoService2 = null;
                                String serviceDiscoveryId = null;
                                ServiceConfigurationInterface serviceConfig = infoService.getServiceConfiguration();
                                infoService = null;
                                if (serviceConfig != null && (serviceDiscoveryConfig = serviceConfig.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY)) != null && serviceDiscoveryConfig instanceof ServiceDiscoveryConfigurationInterface) {
                                    serviceDiscoveryId = ((ServiceDiscoveryConfigurationInterface)((Object)serviceDiscoveryConfig)).getDiscoveryId();
                                }
                                infoService2 = (InformationServiceInterface)discoveryService.findServiceUsingId(serviceDiscoveryId);
                                infoService2 = null;
                                infoSvcTemplate.clearPassport();
                                infoService2 = (InformationServiceInterface)discoveryService.findService(infoSvcTemplate);
                                if (!isDebugLogEnabled) break;
                                LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.discoveredServiceId.fmt.txt", (Object)infoService2.getEntityKey()));
                                LOGGER.debug(discoveryService.toString());
                                break;
                            }
                            catch (ServiceLookupFailedException e) {
                                LOGGER.error(e.getMessage());
                                break;
                            }
                            finally {
                                infoService = null;
                                infoService2 = null;
                            }
                        }
                        case 0: {
                            if (isDebugLogEnabled) {
                                LOGGER.debug(RB.getStringResource("ServiceLoader.deployingServices.txt"));
                            }
                            if (isDebugLogEnabled) {
                                LOGGER.debug((Object)metadataSource);
                            }
                            List<Remote> deployedServices = ServiceLoader.deployServices(metadataSource, null, discoveryService);
                            if (!isDebugLogEnabled) break;
                            LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.elapsedTime.fmt.txt", (Object)((System.currentTimeMillis() - startTime) / 1000L)));
                            Object var17_56 = null;
                            for (RemoteServiceInterface remoteServiceInterface : deployedServices) {
                                LOGGER.debug(ServiceLoader.getServiceDeployedMessage(remoteServiceInterface.getClass(), remoteServiceInterface.getEntityKey()));
                            }
                            break;
                        }
                        default: {
                            LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.invalidTestCaseSpecified.ex.fmt.txt", (Object)testCase));
                        }
                    }
                    if (isInfoLogEnabled) {
                        LOGGER.info((Object)DiscoveryService.defaultInstance());
                    }
                    boolean keyEnterToExit = true;
                    if (testCase != 0) break block132;
                    BufferedReader in = null;
                    try {
                        if (isInfoLogEnabled) {
                            LOGGER.info(RB.getStringResource("ServiceLoader.keyEnterToExitApplication.txt"));
                        }
                        in = new BufferedReader(new InputStreamReader(System.in));
                        in.readLine();
                        if (isInfoLogEnabled) {
                            LOGGER.info(RB.getStringResource("ServiceLoader.returningFromApplication.txt"));
                        }
                        break block132;
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getLocalizedMessage());
                        break block132;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                LOGGER.error(e.getLocalizedMessage());
                            }
                            finally {
                                in = null;
                            }
                        }
                    }
                }
                LOGGER.log(Level.ALL, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.usageLoadServicesFromUrl.fmt.txt", (Object)CLASS_NAME));
                LOGGER.log(Level.ALL, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.usageLookupDiscoveryServicesFromUrl.fmt.txt", (Object)CLASS_NAME));
                LOGGER.log(Level.ALL, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.usageLoadServicesFromOmr.fmt.txt", (Object)CLASS_NAME));
                LOGGER.log(Level.ALL, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.usageLookupDiscoveryServicesFromOmr.fmt.txt", (Object)CLASS_NAME));
            }
            catch (COMM_FAILURE e) {
                LOGGER.error(RB.getStringResource("ServiceLoader.unableToConnectToOmr.txt"), (Throwable)e);
            }
            catch (ServiceDeploymentException e) {
                ServiceLoader.handleDeploymentFailure(e);
            }
            catch (ServiceException e) {
                LOGGER.error(e.getMessage());
            }
            catch (SSLRMIConfigurationException e) {
                LOGGER.error(e.getMessage());
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
            finally {
                if (sslRMIConfigurationInputStream != null) {
                    try {
                        sslRMIConfigurationInputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn(e.getMessage());
                    }
                }
                if (metadataSource != null) {
                    metadataSource.destroy();
                    metadataSource = null;
                }
                if (discoveryService != null) {
                    try {
                        discoveryService.destroy();
                        if (isDebugLogEnabled) {
                            LOGGER.debug((Object)discoveryService);
                        }
                    }
                    catch (ServiceException e) {
                        LOGGER.error(e.getMessage());
                    }
                    catch (RemoteException e) {
                        LOGGER.error(e.getMessage());
                    }
                    finally {
                        discoveryService = null;
                    }
                }
            }
        }
        boolean isExit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void pauseApplication(Logger logger) {
        BufferedReader in = null;
        try {
            if (logger != null) {
                logger.info(RB.getStringResource("ServiceLoader.restartApplication.log"));
            }
            in = new BufferedReader(new InputStreamReader(System.in));
            in.readLine();
            return;
        }
        catch (IOException e) {
            if (logger == null) return;
            logger.error(e.getLocalizedMessage());
            return;
        }
        finally {
            try {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    if (logger != null) {
                        logger.error(e.getLocalizedMessage());
                    }
                    in = null;
                }
            }
            catch (Throwable throwable) {
                in = null;
                throw throwable;
            }
        }
    }

    private static final void handleDeploymentFailure(ServiceDeploymentException e) {
        LOGGER.error(e.getLocalizedMessage());
        for (RemoteServiceInterface service : e.getDeployedServices()) {
            try {
                LOGGER.warn(ServiceLoader.getServiceDeployedMessage(service.getClass(), service.getEntityKey()));
            }
            catch (RemoteException re) {
                LOGGER.error(re.getLocalizedMessage());
            }
        }
        for (FindServiceInterface serviceFinder : e.getDeployedRemoteDiscoveryServices()) {
            LOGGER.debug(ServiceLoader.getServiceDeployedMessage(serviceFinder.getClass(), null));
        }
    }

    private static final String getServiceDeployedMessage(Class serviceClass, String entityKey) {
        return entityKey == null ? Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.serviceDeployed.fmt.txt", (Object)serviceClass.getName()) : Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.serviceEntityDeployed.fmt.txt", (Object)serviceClass.getName(), (Object)entityKey);
    }
}

