/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractImporter;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.CLIOptionsConfig;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.CLIOptionsServiceDeployment;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.NameNotUniqueImportException;
import com.sas.services.deployment.OperationMonitorInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentDeleter;
import com.sas.services.deployment.ServiceDeploymentImportException;
import com.sas.services.deployment.ServiceDeploymentImportFile;
import com.sas.services.deployment.ServiceDeployments;
import com.sas.services.deployment.SoftwareComponentRemoteImporter;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceDeploymentImporter
extends Thread {
    private AbstractImporter _importer;
    private static final Object SYNC_OBJECT = new Object();
    private boolean _isDestroyed;

    public ServiceDeploymentImporter(String repositoryId, ServiceDeploymentImportFile serviceDeploymentImportFile, OperationMonitorInterface operationMonitor, MdFactory mdFactory) throws IllegalArgumentException {
        super(RB.getStringResource("ServiceDeploymentImporter.threadName.txt"));
        this._importer = new SoftwareComponentRemoteImporter(repositoryId, serviceDeploymentImportFile, operationMonitor, mdFactory);
    }

    @Override
    public void run() {
        if (this._isDestroyed) {
            throw new IllegalStateException(RB.getStringResource("ServiceDeploymentImporter.isDestroyed.ex.txt"));
        }
        this._importer.importServiceDeployment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importServiceDeploymentFromFile(ServiceDeploymentImportFile serviceDeploymentImportFile, String metadataRepositoryID, MdStore mdStore) throws ServiceDeploymentImportException {
        Document document;
        block11: {
            document = null;
            Throwable exception = null;
            try {
                String serviceDeploymentName = serviceDeploymentImportFile.getServiceDeploymentName();
                Object object = SYNC_OBJECT;
                synchronized (object) {
                    ServiceDeploymentImporter.verifyDeploymentIsImportable(metadataRepositoryID, serviceDeploymentName, mdStore);
                    document = mdStore.getFactory().getOMIUtil().DoRequest(AbstractImporter.getMetadataToImport(serviceDeploymentImportFile, metadataRepositoryID));
                }
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block11;
                throw new ServiceDeploymentImportException(exception, RB.getStringResource("ServiceDeploymentImporter.unableToImport.ex.txt"));
            }
        }
        if (document == null) {
            throw new ServiceDeploymentImportException(RB.getStringResource("ServiceDeploymentImporter.unableToImport.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importServiceDeployment(String metadata, MdStore mdStore, boolean isWellFormed) throws ServiceDeploymentImportException {
        block8: {
            if (mdStore == null) {
                throw new IllegalArgumentException();
            }
            Throwable exception = null;
            try {
                mdStore.getFactory().getOMIUtil().populateStoreFromString(mdStore, isWellFormed ? metadata : "<Metadata>" + metadata + "</Metadata>", 1, true);
                mdStore.updatedMetadataAll();
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block8;
                throw new ServiceDeploymentImportException(exception, RB.getStringResource("ServiceDeploymentImporter.unableToImport.ex.txt"));
            }
        }
    }

    public static void verifyDeploymentIsImportable(String repositoryId, String serviceDeploymentName, MdStore mdStore) throws ServiceDeploymentImportException {
        if (repositoryId == null) {
            throw new IllegalArgumentException(RB.getStringResource("ServiceDeploymentImporter.mustSpecifyRepositoryId.ex.txt"));
        }
        if (mdStore == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyObjectStore.ex.txt"));
        }
        String escapedName = XMLUtil.normalize(ServiceDeployments.validateServiceDeploymentName(serviceDeploymentName));
        HashSet<String> serviceDeploymentsToImport = new HashSet<String>(1);
        serviceDeploymentsToImport.add(escapedName);
        ServiceDeploymentImporter.verifyServiceDeploymentsAreImportable(repositoryId, serviceDeploymentsToImport, mdStore);
    }

    public static void verifyServiceDeploymentsAreImportable(String repositoryId, Set<String> serviceDeploymentsToImport, MdStore mdStore) throws ServiceDeploymentImportException {
        try {
            int numDuplicateDeployments;
            Set<String> currentlyInstalledServiceDeployments = ServiceDeploymentImporter.getInstalledServiceDeployments(repositoryId, serviceDeploymentsToImport, mdStore);
            if (currentlyInstalledServiceDeployments != null && (numDuplicateDeployments = currentlyInstalledServiceDeployments.size()) > 0) {
                String[] duplicateDeploymentNames = new String[numDuplicateDeployments];
                Iterator<String> iter = currentlyInstalledServiceDeployments.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    duplicateDeploymentNames[index++] = iter.next();
                }
                throw new NameNotUniqueImportException(duplicateDeploymentNames);
            }
        }
        catch (ClassCastException e) {
            throw new ServiceDeploymentImportException(e);
        }
        catch (ServiceException e) {
            throw new ServiceDeploymentImportException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getInstalledServiceDeployments(String repositoryId, Set<String> serviceDeploymentsToImport, MdStore mdStore) throws ServiceException {
        Set<String> serviceDeploymentNames;
        block15: {
            if (mdStore == null) {
                throw new IllegalArgumentException();
            }
            serviceDeploymentNames = null;
            Exception exception = null;
            try {
                List<SoftwareComponent> installedServiceDeployments = ServiceDeployments.getServiceDeployments(mdStore, repositoryId, serviceDeploymentsToImport);
                if (installedServiceDeployments != null) {
                    serviceDeploymentNames = new HashSet<String>(installedServiceDeployments.size());
                    for (SoftwareComponent deployment : installedServiceDeployments) {
                        serviceDeploymentNames.add(deployment.getName());
                    }
                }
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (NullPointerException e) {
                exception = e;
                return exception;
            }
            catch (UnsupportedOperationException e) {
                exception = e;
                return exception;
            }
            catch (ClassCastException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block15;
                throw new ServiceException(exception, RB.getStringResource("ServiceDeploymentImporter.getInstalledDeployments.ex.txt"));
            }
        }
        if (serviceDeploymentNames == null) {
            serviceDeploymentNames = Collections.emptySet();
        }
        return serviceDeploymentNames;
    }

    public void dispose() {
        this._isDestroyed = true;
        if (this._importer != null) {
            this._importer.destroy();
            this._importer = null;
        }
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtRuntimeExceptionHandler(true));
        ServiceException exception = null;
        try {
            ServiceDeploymentImporter.importDeployment(args);
        }
        catch (ServiceException e) {
            exception = e;
            LogManager.getLogger(ServiceDeploymentImporter.class).error("Unable to import foundation services deployment.", (Throwable)((Object)e));
        }
        System.exit(exception == null ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importDeployment(String[] args) throws ServiceException {
        Logger logger;
        block31: {
            logger = LogManager.getLogger(ServiceDeploymentImporter.class);
            MdStore mdStore = null;
            CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
            Option cliOptionMetaServer = cliOptionsMeta.createOptionMetaServer();
            Option cliOptionMetaPort = cliOptionsMeta.createOptionPort();
            Option cliOptionMetaRepository = cliOptionsMeta.createOptionRepository();
            Option cliOptionIsPrompting = new CLIOptionsConfig().createOptionIsPrompting();
            CLIOptionsServiceDeployment cliDeployment = new CLIOptionsServiceDeployment();
            Option optionDeploymentName = cliDeployment.createOptionDeploymentName();
            Option optionDeploymentFile = cliDeployment.createOptionDeploymentFile();
            optionDeploymentFile.setRequired(true);
            Option cliOptionMetaUser = cliOptionsMeta.createOptionUser();
            Option cliOptionMetaPassword = cliOptionsMeta.createOptionPassword();
            Option cliOptionMetaPasswordOnStdin = cliOptionsMeta.createOptionPasswordOnStdin();
            Option cliOptionSecPackageList = cliOptionsMeta.createOptionSecPackageList();
            Option cliOptionSPN = cliOptionsMeta.createOptionSPN();
            String serviceDeploymentFile = null;
            String serviceDeploymentName = null;
            ServiceException exception = null;
            try {
                Options options = new Options();
                options.addOption(cliOptionMetaServer);
                options.addOption(cliOptionMetaPort);
                options.addOption(cliOptionMetaRepository);
                options.addOption(cliOptionIsPrompting);
                options.addOption(optionDeploymentFile);
                options.addOption(optionDeploymentName);
                OptionGroup optionGroupCx = new OptionGroup();
                optionGroupCx.setRequired(true);
                optionGroupCx.addOption(cliOptionMetaUser);
                optionGroupCx.addOption(cliOptionSecPackageList);
                options.addOptionGroup(optionGroupCx);
                options.addOption(cliOptionMetaPassword);
                options.addOption(cliOptionMetaPasswordOnStdin);
                options.addOption(cliOptionSPN);
                String metaPass = null;
                boolean isValid = false;
                CommandLine cmdLine = null;
                try {
                    cmdLine = new DefaultParser().parse(options, args);
                    String metaHost = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionServer());
                    String metaPort = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPort());
                    String secPackageList = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSecPackageList());
                    String metaSPN = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSPN());
                    String metaUser = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionUser());
                    boolean isPasswordOnStdin = Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPasswordOnStdin()));
                    metaPass = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPassword());
                    serviceDeploymentFile = cmdLine.getOptionValue(optionDeploymentFile.getOpt());
                    serviceDeploymentName = cmdLine.getOptionValue(optionDeploymentName.getOpt());
                    boolean bl = isValid = cmdLine.hasOption(cliOptionsMeta.getNameOfOptionServer()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionPort()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionRepository()) && serviceDeploymentFile != null && (metaUser != null && (isPasswordOnStdin || metaPass != null) || secPackageList != null);
                    if (isValid) {
                        HashMap<String, String> metaOptions = new HashMap<String, String>(7);
                        String optionName = cliOptionsMeta.getNameOfOptionServer();
                        metaOptions.put(optionName, metaHost);
                        optionName = cliOptionsMeta.getNameOfOptionPort();
                        metaOptions.put(optionName, metaPort);
                        optionName = cliOptionsMeta.getNameOfOptionRepository();
                        String repositoryName = cmdLine.getOptionValue(optionName);
                        metaOptions.put(optionName, repositoryName);
                        if (secPackageList != null) {
                            optionName = cliOptionsMeta.getNameOfOptionSecPackageList();
                            metaOptions.put(optionName, secPackageList);
                            optionName = cliOptionsMeta.getNameOfOptionSPN();
                            metaOptions.put(optionName, metaSPN);
                        } else {
                            String dashOptionName;
                            optionName = cliOptionsMeta.getNameOfOptionUser();
                            metaOptions.put(optionName, metaUser);
                            if (isPasswordOnStdin && (metaPass = CLIOptionsConfig.getOptionValueFromSystemIn(dashOptionName = '-' + cliOptionsMeta.getNameOfOptionPassword(), Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionIsPrompting.getOpt())) ? Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.fmt.txt", (Object)dashOptionName) : null, null)) == null) {
                                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.ex.fmt.txt", (Object)cliOptionsMeta.getNameOfOptionPassword()));
                            }
                        }
                        if (metaPass != null) {
                            metaOptions.put(cliOptionsMeta.getNameOfOptionPassword(), metaPass);
                        }
                        mdStore = AbstractMetadataSource.createMdStore(false, metaOptions, new Environment());
                        ServiceDeploymentImportFile serviceDeploymentImportFile = new ServiceDeploymentImportFile(new File(serviceDeploymentFile));
                        if (serviceDeploymentName != null) {
                            serviceDeploymentImportFile.setServiceDeploymentName(serviceDeploymentName);
                        }
                        ServiceDeploymentImporter.importServiceDeployment(mdStore, serviceDeploymentImportFile, repositoryName);
                    }
                }
                finally {
                    metaPass = null;
                    if (!isValid) {
                        StringBuilder sb = new StringBuilder();
                        String nextOption = "> -";
                        sb.append(ServiceDeploymentImporter.class.getName());
                        sb.append(" -");
                        sb.append(cliOptionMetaServer.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaServer.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaPort.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPort.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaRepository.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaRepository.getArgName());
                        sb.append("> -");
                        sb.append(optionDeploymentFile.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentFile.getArgName());
                        sb.append("> -");
                        sb.append(optionDeploymentName.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentName.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionMetaUser.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaUser.getArgName());
                        sb.append("> [[-");
                        sb.append(cliOptionMetaPassword.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPassword.getArgName());
                        sb.append(">] | [-");
                        sb.append(cliOptionMetaPasswordOnStdin.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPasswordOnStdin.getArgName());
                        sb.append(">]] | [-");
                        sb.append(cliOptionSecPackageList.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSecPackageList.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionSPN.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSPN.getArgName());
                        sb.append(">]]");
                        new HelpFormatter().printHelp(sb.toString(), options);
                    }
                }
            }
            catch (ParseException e) {
                exception = new ServiceException(e);
            }
            catch (IllegalArgumentException e) {
                exception = new ServiceException(e);
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                cliOptionMetaPassword = null;
                cliOptionMetaUser = null;
                if (mdStore != null) {
                    try {
                        mdStore.getFactory().dispose();
                    }
                    catch (RemoteException e) {
                        logger.error(RB.getStringResource("ServiceConfigurationFactory.disposeFactory.ex.log"), (Throwable)e);
                    }
                }
                if (exception == null) break block31;
                logger.error(RB.getStringResource("ServiceDeploymentImporter.main.ex.txt"), (Throwable)((Object)exception));
                throw exception;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("ServiceConfigInstaller.returningFromMain.log"));
        }
    }

    public static void importServiceDeployment(MdStore mdStore, ServiceDeploymentImportFile serviceDeploymentImportFile, String repositoryName) throws ServiceException {
        try {
            String metadataRepositoryID = AbstractServiceDeployment.getRepositoryID(mdStore.getFactory(), repositoryName);
            ServiceDeploymentImporter.importServiceDeploymentFromFile(serviceDeploymentImportFile, metadataRepositoryID, mdStore);
            Logger logger = LogManager.getLogger(ServiceDeploymentDeleter.class);
            if (logger.isInfoEnabled()) {
                logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentImporter.import.fmt.txt", (Object)serviceDeploymentImportFile.getServiceDeploymentName(), (Object)serviceDeploymentImportFile.getFile().getAbsolutePath(), (Object)repositoryName, (Object)metadataRepositoryID));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }
}

