/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentImportException;
import com.sas.services.deployment.ServiceDeployments;
import com.sas.services.util.IOUtil;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceDeploymentImportFile {
    private static final String XSL_GET_SERVICE_DEPLOYMENT_NAMES_METADATA = "XSL_importServiceDeploymentGetNamesMetadata.xsl";
    private static final String XSL_TOKEN_SOFTWARECOMPONENT_NAME = "%SoftwareComponent.Name%";
    private File _importFile;
    private boolean _isTemporaryFile;
    private String _origName;
    private String _newName;
    private Set<String> _serviceDeployments;
    private boolean _hasBeenProcessed;
    private String _metadata;

    public ServiceDeploymentImportFile(File importFile) throws IllegalArgumentException {
        this.setFile(importFile, false);
    }

    public ServiceDeploymentImportFile(InputStream inputStream) throws IllegalArgumentException {
        this.setInputStream(inputStream);
    }

    public final File getFile() {
        return this._importFile;
    }

    public void destroy() {
        if (this._isTemporaryFile && this._importFile != null) {
            try {
                this._importFile.delete();
            }
            finally {
                this._importFile = null;
            }
        }
    }

    private final void setInputStream(InputStream inputStream) throws IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException(RB.getStringResource("ServiceDeploymentImportFile.mustSpecifyInputStream.ex.txt"));
        }
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            File file = File.createTempFile("svc_import_file", ".xml");
            file.deleteOnExit();
            String metadataXML = IOUtil.getStringUsingEncoding(inputStream, "utf-8");
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(metadataXML);
            bufferedWriter.flush();
            this.setFile(file, true);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    bufferedWriter = null;
                    ServiceDeploymentImportFile.logIOCloseException(Level.ERROR, e);
                }
            } else if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException e) {
                    outputStreamWriter = null;
                    ServiceDeploymentImportFile.logIOCloseException(Level.ERROR, e);
                }
            }
        }
    }

    private final void setFile(File importFile, boolean isOKToDeleteFile) throws IllegalArgumentException {
        if (importFile == null) {
            throw new IllegalArgumentException(RB.getStringResource("ServiceDeploymentImportFile.nullFile.ex.txt"));
        }
        if (!importFile.canRead()) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentImportFile.canNotRead.ex.fmt.txt", (Object)importFile.getAbsolutePath()));
        }
        ServiceException exception = ServiceDeploymentImportFile.validateFile(importFile);
        if (exception != null) {
            throw new IllegalArgumentException(exception.getLocalizedMessage());
        }
        this._isTemporaryFile = isOKToDeleteFile;
        this._importFile = importFile;
        String name = this.getServiceDeploymentNameFromFile();
        if (name == null) {
            this._importFile = null;
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentImportFile.noNameInFile.ex.fmt.txt", (Object)this._importFile.getAbsolutePath()));
        }
    }

    /*
     * Exception decompiling
     */
    public final String getMetadata() throws ServiceDeploymentImportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final String renameServiceDeployment(String inputXML, String newServiceDeploymentName) throws IllegalArgumentException, ServiceException {
        if (inputXML == null || inputXML.trim().length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("ServiceDeploymentImportFile.invalidXML.ex.txt"));
        }
        String newName = ServiceDeployments.validateServiceDeploymentName(newServiceDeploymentName);
        String outputXML = null;
        try {
            String escapedName = XMLUtil.normalize(newName);
            String xsl = IOUtil.getStringFromResourceUsingEncoding(ServiceDeploymentImportFile.class, "XSL_replaceSoftwareComponentName.xsl", "utf-8");
            xsl = xsl.replaceFirst(XSL_TOKEN_SOFTWARECOMPONENT_NAME, escapedName);
            outputXML = XMLUtil.applyXSL(inputXML, xsl);
        }
        catch (TransformerException e) {
            throw new ServiceException(e, RB.getStringResource("ServiceDeploymentImportFile.renameServiceDeployment.ex.txt"));
        }
        return outputXML;
    }

    public final String getServiceDeploymentName() {
        return this._newName == null ? this._origName : this._newName;
    }

    private final String getServiceDeploymentNameFromFile() {
        String name = null;
        Set<String> set = this.getServiceDeploymentSet();
        Object[] names = set.toArray();
        if (names.length != 1) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentImportFile.moreThanOneServiceDeploymentInFile.ex.fmt.txt", (Object)this._importFile.getAbsolutePath()));
        }
        name = this._origName = ServiceDeployments.validateServiceDeploymentName((String)names[0]);
        return name;
    }

    public final void setServiceDeploymentName(String name) {
        this._newName = ServiceDeployments.validateServiceDeploymentName(name);
    }

    public static final ServiceException validateFile(File file) {
        ServiceException exception = null;
        try {
            Set<String> set = ServiceDeploymentImportFile.getServiceDeployments(file);
            if (set.size() == 1) {
                ServiceDeployments.validateServiceDeploymentName(set.iterator().next());
            } else {
                exception = new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentImportFile.invalidFile.ex.fmt.txt", (Object)file));
            }
            set.clear();
            set = null;
        }
        catch (IllegalArgumentException e) {
            exception = new ServiceException(e, e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            exception = new ServiceException(e, e.getLocalizedMessage());
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<String> getServiceDeployments(File importFile) throws IllegalArgumentException, FileNotFoundException {
        Set<String> serviceDeploymentNames = null;
        if (importFile == null) {
            throw new IllegalArgumentException();
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(importFile);
            serviceDeploymentNames = ServiceDeploymentImportFile.getServiceDeployments(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    ServiceDeploymentImportFile.logIOCloseException(Level.WARN, e);
                }
            }
        }
        return serviceDeploymentNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<String> getServiceDeployments(InputStream inputStream) throws IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> serviceDeployments = new HashSet<String>(1);
        InputStream resourceInputStream = null;
        Serializable exception = null;
        try {
            String inputXml = IOUtil.getStringUsingEncoding(inputStream, "utf-8");
            resourceInputStream = ServiceDeploymentImportFile.class.getResourceAsStream(XSL_GET_SERVICE_DEPLOYMENT_NAMES_METADATA);
            if (resourceInputStream != null) {
                String xsl = IOUtil.getStringUsingEncoding(resourceInputStream, "utf-8");
                resourceInputStream.close();
                resourceInputStream = null;
                String names = XMLUtil.applyXSL(inputXml, xsl);
                StringTokenizer tokenizer = new StringTokenizer(names, "%");
                while (tokenizer.hasMoreTokens()) {
                    serviceDeployments.add(ServiceDeployments.validateServiceDeploymentName(tokenizer.nextToken()));
                }
            }
        }
        catch (ServiceException e) {
            exception = e;
        }
        catch (TransformerException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                serviceDeployments.removeAll(serviceDeployments);
            }
            if (resourceInputStream != null) {
                try {
                    resourceInputStream.close();
                }
                catch (IOException e) {
                    ServiceDeploymentImportFile.logIOCloseException(Level.WARN, e);
                }
            }
        }
        return serviceDeployments;
    }

    private final Set<String> getServiceDeploymentSet() {
        Exception exception = null;
        try {
            if (!this._hasBeenProcessed && this._importFile != null) {
                this._serviceDeployments = ServiceDeploymentImportFile.getServiceDeployments(this._importFile);
                this._hasBeenProcessed = true;
            }
        }
        catch (FileNotFoundException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                if (this._serviceDeployments != null) {
                    this._serviceDeployments.clear();
                } else {
                    this._serviceDeployments = Collections.emptySet();
                }
            }
        }
        return this._serviceDeployments;
    }

    private static final void logIOCloseException(Level logLevel, IOException exception) {
        LogManager.getLogger(ServiceDeploymentImportFile.class).log(logLevel, RB.getStringResource("IOStream.close.ex.log"), (Throwable)exception);
    }
}

