/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.services.deployment.ServiceDeployments;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public final class ServiceConsumerUtil {
    private ServiceDeployment _serviceDeployment;

    public ServiceConsumerUtil(SoftwareComponent softwareComponent) throws ServiceException {
        if (softwareComponent == null) {
            throw new IllegalArgumentException("A SoftwareComponent must be specified.");
        }
        try {
            this._serviceDeployment = new ServiceDeployment(softwareComponent);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    public Set<ServiceComponent> renameConsumer(String oldConsumerName, String newConsumerName) throws ServiceException {
        return this._serviceDeployment.renameConsumer(oldConsumerName, newConsumerName);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtRuntimeExceptionHandler(true));
        ServiceException exception = null;
        try {
            ServiceConsumerUtil.renameConsumer(args);
        }
        catch (ServiceException e) {
            exception = e;
            LogManager.getLogger(ServiceConsumerUtil.class).error("Unable to rename foundation services consumer.", (Throwable)((Object)e));
        }
        System.exit(exception == null ? 0 : -1);
    }

    /*
     * Exception decompiling
     */
    public static void renameConsumer(String[] args) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Set<ServiceComponent> renameConsumers(MdStore mdStore, String repositoryName, String serviceDeploymentName, Map<String, String> consumerNameToNewConsumerNameMap) throws ServiceException {
        HashSet<ServiceComponent> serviceComponents = new HashSet<ServiceComponent>(10);
        Logger logger = LogManager.getLogger(ServiceConsumerUtil.class);
        try {
            MdFactory mdFactory;
            String metadataRepositoryID;
            if (logger.isInfoEnabled()) {
                String lineSeparator = System.getProperty("line.separator");
                StringBuilder buffer = new StringBuilder();
                buffer.append("Updating service configurations in SAS Foundation Services deployment \"");
                buffer.append(serviceDeploymentName);
                buffer.append("\" to rename the following service configuration consumers.");
                for (Map.Entry<String, String> mapEntry : consumerNameToNewConsumerNameMap.entrySet()) {
                    buffer.append(lineSeparator);
                    buffer.append("\"");
                    buffer.append(mapEntry.getKey());
                    buffer.append("\" to \"");
                    buffer.append(mapEntry.getValue());
                    buffer.append("\"");
                }
                logger.info(buffer.toString());
            }
            if ((metadataRepositoryID = AbstractServiceDeployment.getRepositoryID(mdFactory = mdStore.getFactory(), repositoryName)) == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.repositoryName.ex.fmt.txt", (Object)repositoryName));
            }
            SoftwareComponent softwareComponent = ServiceDeployments.getServiceDeployment(mdStore, metadataRepositoryID, serviceDeploymentName);
            if (softwareComponent == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.setSoftwareComponent.ex.fmt.txt", (Object)serviceDeploymentName, (Object)repositoryName));
            }
            ServiceConsumerUtil serviceConsumerRenamer = new ServiceConsumerUtil(softwareComponent);
            Set<ServiceComponent> updatedServiceComponents = null;
            String consumerName = null;
            String consumerNameNew = null;
            for (Map.Entry<String, String> entry : consumerNameToNewConsumerNameMap.entrySet()) {
                consumerName = entry.getKey();
                updatedServiceComponents = serviceConsumerRenamer.renameConsumer(consumerName, consumerNameNew = entry.getValue());
                if (updatedServiceComponents.size() <= 0) continue;
                serviceComponents.addAll(updatedServiceComponents);
                if (!logger.isInfoEnabled()) continue;
                for (ServiceComponent service : updatedServiceComponents) {
                    logger.info("The \"" + service.getName() + "\" service configuration consumer \"" + consumerName + "\" has been renamed to \"" + consumerNameNew + "\" in the SAS Foundation Services deployment \"" + serviceDeploymentName + "\" in SAS Metadata Server repository \"" + repositoryName + "\" (" + metadataRepositoryID + ").");
                }
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return serviceComponents;
    }
}

