/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CLIOptionsRMIRegistry;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RMIRegistryValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitCode = 0;
        CLIOptionsRMIRegistry cliRegistry = new CLIOptionsRMIRegistry();
        Option optionHost = cliRegistry.createOptionHost();
        optionHost.setRequired(true);
        Option optionPort = cliRegistry.createOptionPort();
        optionPort.setRequired(true);
        Options options = new Options();
        options.addOption(optionHost);
        options.addOption(optionPort);
        CommandLine cmdLine = null;
        boolean isPrintUsage = false;
        try {
            cmdLine = new DefaultParser().parse(options, args);
            String host = cmdLine.getOptionValue(cliRegistry.getNameOfOptionHost());
            String portString = cmdLine.getOptionValue(cliRegistry.getNameOfOptionPort());
            Integer port = null;
            try {
                port = Integer.parseInt(portString);
                exitCode = RMIRegistryValidator.test(host, port);
            }
            catch (NumberFormatException e) {
                isPrintUsage = true;
                exitCode = 1;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            isPrintUsage = true;
            exitCode = 2;
        }
        finally {
            if (isPrintUsage) {
                System.out.println(RMIRegistryValidator.getUsage(cliRegistry));
            }
            System.exit(exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int test(String host, Integer port) {
        int rv = 0;
        Serializable exception = null;
        try {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.title.fmt.txt", (Object)host, (Object)port));
            RMIConfiguration rmiConfiguration = new RMIConfiguration(host, port);
            Registry registry = rmiConfiguration.getRMIRegistry(false);
            String[] names = registry.list();
            if (0 < names.length) {
                for (String name : names) {
                    RMIRegistryValidator.validate(registry, name);
                }
            } else {
                rv = 3;
            }
        }
        catch (InitializationException e) {
            rv = 4;
            exception = e;
        }
        catch (ServiceException e) {
            rv = 5;
            exception = e;
        }
        catch (AccessException e) {
            rv = 6;
            exception = e;
        }
        catch (RemoteException e) {
            rv = 7;
            exception = e;
        }
        finally {
            if (null != exception) {
                ((Throwable)exception).printStackTrace();
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int validate(Registry registry, String name) {
        int rv = 0;
        Exception exception = null;
        try {
            Remote remote = registry.lookup(name);
            if (remote instanceof RemoteServiceInterface) {
                RMIRegistryValidator.logService(name, (RemoteServiceInterface)remote);
            } else {
                System.out.println();
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.item.name.fmt.txt", (Object)name));
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.item.class.fmt.txt", (Object)remote.getClass().getName()));
            }
        }
        catch (AccessException e) {
            rv = 10;
            exception = e;
        }
        catch (RemoteException e) {
            rv = 11;
            exception = e;
        }
        catch (NotBoundException e) {
            rv = 12;
            exception = e;
        }
        finally {
            if (null != exception) {
                exception.printStackTrace();
            }
        }
        return rv;
    }

    private static int logService(String name, RemoteServiceInterface service) {
        int rv = 20;
        short serviceState = 0;
        try {
            serviceState = service.getServiceState();
            rv = 21;
            String entityKey = service.getEntityKey();
            rv = 22;
            System.out.println();
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.service.item.name.fmt.txt", (Object)name));
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.service.item.class.fmt.txt", (Object)service.getClass().getName()));
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.service.item.ID.fmt.txt", (Object)entityKey));
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.service.item.status.fmt.txt", (Object)RMIRegistryValidator.getServiceStatus(serviceState)));
            rv = 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return rv;
    }

    private static String getServiceStatus(int serviceState) {
        String status = null;
        switch (serviceState) {
            case 0: {
                status = RB.getStringResource("ServiceState.uninitialized.txt");
                break;
            }
            case 1: {
                status = RB.getStringResource("ServiceState.initialized.txt");
                break;
            }
            case 2: {
                status = RB.getStringResource("ServiceState.deactivated.txt");
                break;
            }
        }
        return status;
    }

    private static final String getUsage(CLIOptionsRMIRegistry cliOptionsRMIRegistry) {
        return Message.format((ResourceBundle)RB.getResources(), (String)"RMIRegistryValidator.usage.fmt.txt", (Object)RMIRegistryValidator.class.getName(), (Object)cliOptionsRMIRegistry.getNameOfOptionHost(), (Object)cliOptionsRMIRegistry.getNameOfOptionPort());
    }
}

