/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.MetadataSourceProperties;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.text.Message;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class MetadataSourceFactory {
    private static final int MAX_NUM_GROUPS = 50;
    public static final String PROPERTY_SOFTWARECOMPONENT = "software_component";
    public static final String PROPERTY_DEPLOYMENTGROUP = "deployment_group_";
    private static final CLIOptionsMeta CLI_OPTIONS_META = new CLIOptionsMeta();
    public static final String PROPERTY_METADATASERVER_HOST = "omr_host";
    public static final String PROPERTY_METADATASERVER_PORT = "omr_port";
    public static final String PROPERTY_METADATASERVER_USERID = "omr_user";
    public static final String PROPERTY_SSO_SECPACKAGELIST = CLI_OPTIONS_META.getNameOfOptionSecPackageList();
    public static final String PROPERTY_SSO_SPN = CLI_OPTIONS_META.getNameOfOptionSPN();
    public static final String PROPERTY_METADATASERVER_USERPASSWORD = "omr_password";
    public static final String PROPERTY_METADATASERVER_REPOSITORY = "omr_repository";
    public static final String PROPERTY_CONNECTION = ConnectionInterface.class.getName();
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_MODE = "metadatasource_mode";

    private MetadataSourceFactory() {
    }

    public static String getServiceGroupName(int index) {
        if (index < 1 || index > 50) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataSourceFactory.getServiceGroupName.ex.fmt.txt", (java.lang.Object)50));
        }
        return PROPERTY_DEPLOYMENTGROUP + index;
    }

    public static int getMaxNumberOfGroups() {
        return 50;
    }

    public static MetadataSourceInterface createMetadataSource(MetadataSourceProperties metadataSourceProperties, Environment environment) throws ServiceException {
        if (metadataSourceProperties == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.metadataSourceProperties.ex.txt"));
        }
        return MetadataSourceFactory.newMetadataSource(metadataSourceProperties.getProperties(), environment);
    }

    public static MetadataSourceInterface newMetadataSource(Properties properties, Environment environment) throws ServiceException {
        MetadataSourceInterface metadataSource = null;
        try {
            boolean isURLMetadataSource;
            HashSet<String> serviceDeploymentNames = new HashSet<String>(1);
            String serviceDeploymentName = null;
            int maxNumGroups = MetadataSourceFactory.getMaxNumberOfGroups();
            for (int i = 1; i < maxNumGroups && (serviceDeploymentName = properties.getProperty(MetadataSourceFactory.getServiceGroupName(i))) != null; ++i) {
                serviceDeploymentNames.add(serviceDeploymentName.trim());
            }
            String mode = properties.getProperty(PROPERTY_MODE);
            java.lang.Object url = properties.get(PROPERTY_URL);
            boolean bl = isURLMetadataSource = PROPERTY_URL.equals(mode) || url != null;
            if (isURLMetadataSource) {
                metadataSource = MetadataSourceFactory.getURLMetadataSource(properties, serviceDeploymentNames);
            } else {
                String host = properties.getProperty(PROPERTY_METADATASERVER_HOST);
                if (host == null) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataSourceFactory.specifyHost.ex.fmt.txt", (java.lang.Object)PROPERTY_METADATASERVER_HOST));
                }
                String softwareComponentName = properties.getProperty(PROPERTY_SOFTWARECOMPONENT);
                if (softwareComponentName == null) {
                    throw new IllegalArgumentException(RB.getStringResource("MetadataSourceFactory.softwarecomponentMustBeSpecified.ex.txt"));
                }
                ConnectionInterface connection = (ConnectionInterface)properties.get(PROPERTY_CONNECTION);
                IOMI omi = connection == null ? null : IOMIHelper.narrow((Object)connection.getObject());
                metadataSource = omi == null ? MetadataSourceFactory.getMetadataServerSource(properties, softwareComponentName, serviceDeploymentNames, host, environment) : MetadataSourceFactory.getMetadataServerSourceUsingOMI(properties, softwareComponentName, serviceDeploymentNames, omi, environment);
            }
        }
        catch (IllegalArgumentException e) {
            String cause = e.getLocalizedMessage();
            if (cause == null) {
                cause = "";
            }
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"MetadataSourceFactory.unableToCreateMetadataSource.ex.fmt.txt", (java.lang.Object)cause));
        }
        return metadataSource;
    }

    public static MetadataSourceInterface newMetadataSource(Properties properties) throws ServiceException {
        return MetadataSourceFactory.newMetadataSource(properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetadataSourceInterface getURLMetadataSource(Properties properties, Set<String> serviceDeploymentNames) throws ServiceException {
        URLMetadataSource metadataSource;
        block13: {
            metadataSource = null;
            URL metadataUrl = null;
            Serializable exception = null;
            try {
                java.lang.Object urlObj = properties.get(PROPERTY_URL);
                if (urlObj != null && URL.class.getName().equals(urlObj.getClass().getName())) {
                    metadataUrl = (URL)urlObj;
                } else {
                    String urlString = properties.getProperty(PROPERTY_URL);
                    if (urlString != null) {
                        metadataUrl = new URL(urlString.trim());
                    }
                }
                if (metadataUrl == null) {
                    throw new ServiceException(RB.getStringResource("MetadataSourceFactory.metadataUrlMustBeSpecified.ex.txt"));
                }
                metadataSource = new URLMetadataSource(metadataUrl, serviceDeploymentNames);
                metadataSource.setProperties(properties);
            }
            catch (InitializationException e) {
                exception = e;
                return exception;
            }
            catch (IllegalArgumentException e) {
                exception = e;
                return exception;
            }
            catch (MalformedURLException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block13;
                throw new ServiceException((Throwable)exception, RB.getStringResource("MetadataSourceFactory.unableToCreateUrlMetadataSource.ex.txt"));
            }
        }
        return metadataSource;
    }

    private static MetadataSourceInterface getMetadataServerSource(Properties properties, String softwareComponentName, Set<String> serviceDeploymentNames, String host, Environment environment) throws ServiceException {
        String secPackageList;
        OMRMetadataSource metadataSource = null;
        String port = properties.getProperty(PROPERTY_METADATASERVER_PORT);
        if (port == null) {
            throw new ServiceException(RB.getStringResource("MetadataSourceFactory.omrPortMustBeSpecified.ex.txt"));
        }
        port = port.trim();
        String reposName = properties.getProperty(PROPERTY_METADATASERVER_REPOSITORY);
        if (reposName != null) {
            reposName = reposName.trim();
        }
        if ((secPackageList = properties.getProperty(PROPERTY_SSO_SECPACKAGELIST)) != null) {
            secPackageList = secPackageList.trim();
        }
        try {
            if (secPackageList != null) {
                String spn = properties.getProperty(PROPERTY_SSO_SPN);
                if (spn != null) {
                    spn = spn.trim();
                }
                metadataSource = new OMRMetadataSource(reposName, softwareComponentName, serviceDeploymentNames, host, port, spn, secPackageList, environment);
            } else {
                String ident = properties.getProperty(PROPERTY_METADATASERVER_USERID);
                if (ident != null) {
                    ident = ident.trim();
                }
                char[] passwordArray = null;
                if (properties.getProperty(PROPERTY_METADATASERVER_USERPASSWORD) != null) {
                    passwordArray = properties.getProperty(PROPERTY_METADATASERVER_USERPASSWORD).trim().toCharArray();
                }
                metadataSource = new OMRMetadataSource(host, port, ident, passwordArray == null ? null : new String(passwordArray), reposName, softwareComponentName, serviceDeploymentNames, environment);
                Arrays.fill(passwordArray, '\u0000');
                passwordArray = null;
            }
            if (reposName == null || reposName.length() == 0) {
                properties.setProperty(PROPERTY_METADATASERVER_REPOSITORY, metadataSource.getRepositoryId());
            }
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e, RB.getStringResource("MetadataSourceFactory.unableToCreateOmrMetadataSource.ex.txt"));
        }
        metadataSource.setProperties(properties);
        return metadataSource;
    }

    private static MetadataSourceInterface getMetadataServerSourceUsingOMI(Properties properties, String softwareComponentName, Set<String> serviceDeploymentNames, IOMI omi, Environment environment) throws ServiceException {
        OMRMetadataSource metadataSource = null;
        String reposName = properties.getProperty(PROPERTY_METADATASERVER_REPOSITORY);
        if (reposName == null) {
            throw new ServiceException(RB.getStringResource("MetadataSourceFactory.omrRepositioryIdMustBeSpecified.ex.txt"));
        }
        try {
            metadataSource = new OMRMetadataSource(omi, reposName.trim(), softwareComponentName, serviceDeploymentNames, environment);
            metadataSource.setProperties(properties);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e, RB.getStringResource("MetadataSourceFactory.unableToCreateOmrMetadataSource.ex.txt"));
        }
        return metadataSource;
    }
}

