/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.deployment.RB;
import com.sas.services.logging.util.LoggerMonitor2;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DeploymentApplicationMonitor {
    public static final String CATEGORY = "ApplicationMonitor.com.sas.services.deployment";
    public static final String COLUMN_ACTION = "Action";
    public static final String COLUMN_SERVICE_NAME = "ServiceName";
    public static final String COLUMN_ENTITY_ID = "EntityID";
    public static final String ACTION_STARTING = RB.getStringResource("DeploymentApplicationMonitor.actionStarting.txt");
    public static final String ACTION_CONFIGURED = RB.getStringResource("DeploymentApplicationMonitor.actionConfigured.txt");
    public static final String ACTION_STARTED = RB.getStringResource("DeploymentApplicationMonitor.actionStarted.txt");
    public static final String ACTION_TERMINATED = RB.getStringResource("DeploymentApplicationMonitor.actionTerminated.txt");

    private DeploymentApplicationMonitor() {
    }

    public static final void log(RemoteServiceInterface service, String action) {
        Logger logger = LogManager.getLogger(DeploymentApplicationMonitor.class);
        if (logger.isDebugEnabled()) {
            String entityID = "";
            try {
                entityID = service.getEntityKey();
            }
            catch (RemoteException e) {
                entityID = "";
            }
            logger.debug(LoggerMonitor2.createLogMessage(new String[]{COLUMN_ACTION, action, COLUMN_SERVICE_NAME, service.getClass().getName(), COLUMN_ENTITY_ID, entityID}));
        }
    }
}

