/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceFactoryInterface;
import com.sas.services.deployment.DeployInterface;
import com.sas.services.deployment.RB;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.logging.LoggingServiceFactory2;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DeployableService
implements Serializable,
Comparable<DeployableService>,
DeployInterface {
    private static final long serialVersionUID = 1457736784494895240L;
    private static final Integer INTEGER_FALSE = 0;
    private static final Integer INTEGER_TRUE = 1;
    private static final int HASH_CODE_PRIME_NUMBER = 7;
    private static final String FACTORY_GET_SERVICE_METHOD = "getService";
    private static final String COM_SAS_SERVICES_LOGGING_LOGGINGSERVICEFACTORY = "com.sas.services.logging.LoggingServiceFactory";
    private String _id;
    private Class _factory;
    private Set<String> _dependencies;
    private ServiceConfigurationInterface _configuration;

    protected DeployableService() {
        this.setId(GUID.newGUID());
    }

    protected DeployableService(String id, ServiceConfigurationInterface serviceConfiguration) throws ServiceException {
        this.setId(id);
        this.setConfiguration(serviceConfiguration);
    }

    public DeployableService(String id, ServiceConfigurationInterface serviceConfiguration, String[] dependencies) throws ServiceException {
        this.setId(id);
        this.setDependencies(dependencies);
        this.setConfiguration(serviceConfiguration);
    }

    public final ServiceConfigurationInterface getServiceConfiguration() {
        return this._configuration;
    }

    private final void setConfiguration(ServiceConfigurationInterface configuration) throws InitializationException {
        boolean configurationInitialized = false;
        if (configuration != null) {
            this._configuration = configuration;
            ServiceDiscoveryConfigurationInterface sdc = (ServiceDiscoveryConfigurationInterface)((Object)this._configuration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY));
            if (sdc != null) {
                Class[] serviceTypes;
                String serviceFactory = sdc.getServiceFactory();
                String theServiceFactory = this.setFactory(serviceFactory);
                if (COM_SAS_SERVICES_LOGGING_LOGGINGSERVICEFACTORY.equals(serviceFactory) && LoggingServiceFactory2.class.getName().equals(theServiceFactory)) {
                    this._configuration.setInitializationObject(null);
                }
                if ((serviceTypes = sdc.getServiceTypes()) == null || serviceTypes.length == 0) {
                    throw new InitializationException(RB.getStringResource("DeployableService.serviceMustImplementServiceType.ex.txt"));
                }
                configurationInitialized = true;
            }
        }
        if (!configurationInitialized) {
            throw new InitializationException(RB.getStringResource("DeployableService.unableInitializeServiceConfiguration.ex.txt"));
        }
    }

    private final void setDependencies(String[] dependencies) {
        int numDeps;
        if (dependencies != null && (numDeps = dependencies.length) > 0) {
            this._dependencies = new HashSet<String>(numDeps);
            String dependency = null;
            for (int i = 0; i < numDeps; ++i) {
                dependency = dependencies[i];
                if (dependency == null) continue;
                this._dependencies.add(dependency);
            }
        }
    }

    public final Set<String> getDependencies() {
        if (this._dependencies == null) {
            this._dependencies = new HashSet<String>(0);
        }
        return this._dependencies;
    }

    public final void setDependencies(Set<String> dependencies) {
        this._dependencies = dependencies;
    }

    private final String setFactory(String serviceFactory) throws InitializationException {
        Logger logger = LogManager.getLogger(DeployableService.class);
        String factory = COM_SAS_SERVICES_LOGGING_LOGGINGSERVICEFACTORY.equals(serviceFactory) ? LoggingServiceFactory2.class.getName() : serviceFactory;
        try {
            if (factory == null) {
                throw new InitializationException(RB.getStringResource("DeployableService.nonNullServiceFactoryIsRequired.ex.txt"));
            }
            this._factory = this.getClass().getClassLoader().loadClass(factory.trim());
        }
        catch (ClassNotFoundException e) {
            String reason = e.getLocalizedMessage();
            String msg = reason != null && reason.trim().length() > 0 ? Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.unableToObtainServiceFactoryBecause.ex.fmt.txt", (Object)factory, (Object)reason) : Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.unableToObtainServiceFactory.ex.fmt.txt", (Object)factory);
            logger.error(msg);
            throw new InitializationException(e, msg);
        }
        return factory;
    }

    private final void setId(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException(RB.getStringResource("DeployableService.nonNullIdIsRequired.ex.txt"));
        }
        this._id = id.trim();
        if (this._id.length() == 0) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.invalidIdSpecified.ex.fmt.txt", (Object)id));
        }
    }

    public final String getId() {
        return this._id;
    }

    public String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        StringBuilder buffer = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.deployableServiceOpeningBrace.fmt.txt", (Object)lineSeparator));
        buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.deployableService.fmt.txt", (Object)this._id, (Object)lineSeparator, (Object)this._factory, (Object)lineSeparator, (Object)this._configuration, (Object)lineSeparator));
        Iterator<String> iterator = this.getDependencies().iterator();
        int index = 1;
        if (iterator.hasNext()) {
            buffer.append(lineSeparator);
            while (iterator.hasNext()) {
                buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.dependencyNewLine.fmt.txt", (Object)index++, (Object)iterator.next(), (Object)lineSeparator));
            }
        } else {
            buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.noneNewLine.fmt.txt", (Object)lineSeparator));
        }
        buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.closingBraceNewLine.fmt.txt", (Object)lineSeparator));
        return buffer.toString();
    }

    @Override
    public RemoteServiceInterface deploy() throws ServiceException {
        return this.deploy(DiscoveryService.defaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteServiceInterface deploy(DiscoveryServiceInterface discoveryService) throws ServiceException {
        RemoteServiceInterface deployedService;
        block19: {
            Logger logger = LogManager.getLogger(DeployableService.class);
            deployedService = null;
            Throwable throwable = null;
            boolean isDebugLogEnabled = logger.isDebugEnabled();
            try {
                RemoteServiceInterface serviceProxy;
                if (isDebugLogEnabled) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.instantiateServiceFactory.fmt.txt", (Object)this._factory));
                }
                ServiceFactoryInterface factory = (ServiceFactoryInterface)this._factory.newInstance();
                if (isDebugLogEnabled) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.getServiceFromFactory.fmt.txt", (Object)factory));
                }
                RemoteServiceInterface service = null;
                Method method = this._factory.getMethod(FACTORY_GET_SERVICE_METHOD, ServiceConfigurationInterface.class, DiscoveryServiceInterface.class);
                if (method == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.unableToObtainGetServiceMethod.ex.fmt.txt", (Object)FACTORY_GET_SERVICE_METHOD));
                }
                long startTimeMsec = System.currentTimeMillis();
                Object object = method.invoke((Object)factory, this._configuration, discoveryService);
                Long svcConfigureTimeMsec = System.currentTimeMillis() - startTimeMsec;
                if (!(object instanceof RemoteServiceInterface)) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.factoryGetServiceReturnedWrongType.ex.fmt.txt", (Object)FACTORY_GET_SERVICE_METHOD));
                }
                service = (RemoteServiceInterface)object;
                if (isDebugLogEnabled) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.timeToConfigureService.fmt.txt", (Object)svcConfigureTimeMsec, (Object)factory));
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.serviceObtainedFromFactory.fmt.txt", (Object)service, (Object)factory));
                }
                RemoteServiceInterface remoteServiceInterface = deployedService = (serviceProxy = service.getServiceProxy()) == null ? service : serviceProxy;
                if (isDebugLogEnabled) {
                    boolean isRemotelyAccessible = deployedService.isAccessibleToRemoteClients();
                    String msg = isRemotelyAccessible ? Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.remoteableServiceDeployed.fmt.txt", (Object)deployedService.getClass().getName(), (Object)(deployedService.isExported() ? INTEGER_TRUE : INTEGER_FALSE), (Object)(isRemotelyAccessible ? INTEGER_TRUE : INTEGER_FALSE)) : Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.localServiceDeployed.fmt.txt", (Object)deployedService.getClass().getName());
                    logger.debug(msg);
                }
            }
            catch (IllegalAccessException e) {
                throwable = e;
                return throwable;
            }
            catch (InstantiationException e) {
                throwable = e;
                return throwable;
            }
            catch (RemoteException e) {
                throwable = e;
                return throwable;
            }
            catch (NoSuchMethodException e) {
                throwable = e;
                return throwable;
            }
            catch (InvocationTargetException e) {
                throwable = e.getTargetException();
                return throwable;
            }
            finally {
                if (throwable == null) break block19;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.unableToObtainServiceFromFactory.ex.fmt.txt", (Object)this._factory);
                throw new ServiceException(throwable, msg);
            }
        }
        return deployedService;
    }

    public final String getServiceFactory() {
        String factory = "";
        if (this._factory != null) {
            factory = this._factory.toString();
        }
        return factory;
    }

    public final int hashCode() {
        return 7 ^ this._id.hashCode();
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other != null) {
            try {
                DeployableService otherDs = (DeployableService)other;
                isEqual = Strings.equal((String)this._id, (String)otherDs.getId(), (boolean)false, (boolean)false);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    @Override
    public final int compareTo(DeployableService otherService) {
        int value = 0;
        Logger logger = LogManager.getLogger(DeployableService.class);
        String otherId = null;
        try {
            if (null != otherService) {
                if (this.dependsOn(this._id, otherService)) {
                    value = -1;
                }
                otherId = otherService.getId();
                if (value == 0 && otherId != null && this.dependsOn(otherId, this)) {
                    value = 1;
                }
                if (value == 0) {
                    int numDepsOther;
                    int numDeps = this.getDependencies().size();
                    value = numDeps < (numDepsOther = otherService.getDependencies().size()) ? -1 : 1;
                }
            }
        }
        catch (ClassCastException e) {
            value = 1;
        }
        if (logger.isDebugEnabled()) {
            DeployableService.logServiceDependencies(logger, this._id, otherId, value);
        }
        return value;
    }

    private static final void logServiceDependencies(Logger logger, String idThis, String idOther, int value) {
        if (logger != null) {
            String msg = null;
            switch (value) {
                case -1: {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.dependsOn.fmt.txt", (Object)idOther, (Object)idThis);
                    break;
                }
                case 1: {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.dependsOn.fmt.txt", (Object)idThis, (Object)idOther);
                    break;
                }
                default: {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.noDependency.fmt.txt", (Object)idOther, (Object)idThis);
                }
            }
            logger.debug(msg);
        }
    }

    private final boolean dependsOn(String id, DeployableService service) {
        boolean dependsOn = false;
        if (service != null && this._id != null) {
            for (String dependsOnId : service.getDependencies()) {
                if (!id.equals(dependsOnId)) continue;
                dependsOn = true;
                break;
            }
        }
        return dependsOn;
    }
}

