/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServices;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceLookupFailedException;
import com.sas.services.deployment.ServicesDeploymentEvent;
import com.sas.services.deployment.ServicesDeploymentEventListenerInterface;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.ConnectionProfile;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.util.UncheckedException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class CorePlatformServices {
    private static AuthenticationServiceInterface _authenticationService = null;
    private static InformationServiceInterface _informationService = null;
    private static SessionServiceInterface _sessionService = null;
    private static UserServiceInterface _userService = null;
    private static PlatformServicesConfiguration _servicesConfiguration = null;

    public static final void setServicesConfiguration(PlatformServicesConfiguration servicesConfiguration) throws ServiceException {
        _servicesConfiguration = servicesConfiguration;
        PlatformServices.setServicesConfiguration(servicesConfiguration);
    }

    public static final void setEnvironment(Environment environment) {
        PlatformServices.setEnvironment(environment);
    }

    public static final boolean setJAASAppConfigurationEntry(AppConfigurationEntry[] appConfigurationEntries) throws ServiceException {
        return PlatformServices.setJAASAppConfigurationEntry(appConfigurationEntries);
    }

    public static void startServices() throws ServiceException, ServiceLookupFailedException {
        if (_servicesConfiguration == null) {
            CorePlatformServices.setDefaultServicesConfiguration();
        }
        PlatformServices.startServices();
        CorePlatformServices.discoverServices();
    }

    public static void startLocalServices() throws ServiceException {
        if (_servicesConfiguration == null) {
            CorePlatformServices.setDefaultServicesConfiguration();
        }
        PlatformServices.startLocalServices();
        CorePlatformServices.discoverServices();
    }

    public static void lookupRemoteServices() throws ServiceException, ServiceLookupFailedException {
        PlatformServices.lookupRemoteServices();
        CorePlatformServices.discoverServices();
    }

    public static void terminateServices() throws ServiceException {
        _sessionService = null;
        _informationService = null;
        _authenticationService = null;
        _userService = null;
        PlatformServices.terminateServices();
    }

    public static DiscoveryServiceInterface getDiscoveryService() {
        return PlatformServices.getDiscoveryService();
    }

    public static InformationServiceInterface getInformationService() {
        return _informationService;
    }

    public static SessionServiceInterface getSessionService() {
        return _sessionService;
    }

    public static UserServiceInterface getUserService() {
        return _userService;
    }

    public static AuthenticationServiceInterface getAuthenticationService() {
        return _authenticationService;
    }

    private static final void discoverServices() {
        ServiceTemplate serviceTemplate = null;
        try {
            serviceTemplate = new ServiceTemplate(new Class[]{AuthenticationServiceInterface.class});
            _authenticationService = (AuthenticationServiceInterface)PlatformServices.findService(serviceTemplate);
        }
        catch (ServiceException e) {
            _authenticationService = null;
        }
        try {
            serviceTemplate = new ServiceTemplate(new Class[]{UserServiceInterface.class});
            _userService = (UserServiceInterface)PlatformServices.findService(serviceTemplate);
        }
        catch (ServiceException e) {
            _userService = null;
        }
        try {
            serviceTemplate = new ServiceTemplate(new Class[]{InformationServiceInterface.class});
            _informationService = (InformationServiceInterface)PlatformServices.findService(serviceTemplate);
        }
        catch (ServiceException e) {
            _informationService = null;
        }
        try {
            serviceTemplate = new ServiceTemplate(new Class[]{SessionServiceInterface.class});
            _sessionService = (SessionServiceInterface)PlatformServices.findService(serviceTemplate);
        }
        catch (ServiceException e) {
            _sessionService = null;
        }
        try {
            PlatformServices.notifyServicesDeploymentListeners(new ServicesDeploymentEvent(32));
        }
        catch (ServiceException e) {
            LogManager.getLogger(CorePlatformServices.class).error(RB.getStringResource("CorePlatformServices.notifyFacadeInitialized.ex.log"), (Throwable)((Object)e));
        }
    }

    public static final void addServicesDeploymentListener(ServicesDeploymentEventListenerInterface listener) throws ServiceException {
        if (listener != null) {
            PlatformServices.addServicesDeploymentListener(listener);
        }
    }

    public static final void removeServicesDeploymentListener(ServicesDeploymentEventListenerInterface listener) {
        if (listener != null) {
            PlatformServices.removeServicesDeploymentListener(listener);
        }
    }

    public static final Services getServices() throws ServiceException {
        return PlatformServices.getServices();
    }

    public static void validateServices() throws ServiceException {
        CorePlatformServices.discoverServices();
        if (_authenticationService == null) {
            throw new ServiceException("Authentication Service not found.");
        }
        if (_userService == null) {
            throw new ServiceException("User Service not found.");
        }
        if (_sessionService == null) {
            throw new ServiceException("Session Service not found.");
        }
        if (_informationService == null) {
            throw new ServiceException("Information Service not found.");
        }
    }

    private static void setDefaultServicesConfiguration() throws ServiceException {
        URL serviceDeploymentURL = CorePlatformServices.class.getResource("core_foundation_services.xml");
        MetadataSourceInterface[] servicesToDeploy = new MetadataSourceInterface[]{new URLMetadataSource(serviceDeploymentURL)};
        PlatformServicesConfiguration servicesConfiguration = new PlatformServicesConfiguration(servicesToDeploy, null);
        CorePlatformServices.setServicesConfiguration(servicesConfiguration);
    }

    public static void setDefaultServicesConfigurationWithMinimumLogging() throws ServiceException {
        URL serviceDeploymentURL = CorePlatformServices.class.getResource("core_foundation_services2.xml");
        MetadataSourceInterface[] servicesToDeploy = new MetadataSourceInterface[]{new URLMetadataSource(serviceDeploymentURL)};
        PlatformServicesConfiguration servicesConfiguration = new PlatformServicesConfiguration(servicesToDeploy, null);
        CorePlatformServices.setServicesConfiguration(servicesConfiguration);
    }

    public static boolean addContentServerRepository(UserContextInterface user) throws ServiceException {
        if (_informationService == null) {
            throw new IllegalStateException("Information service has not started.  Unable to add content server repository.");
        }
        try {
            Filter filter = new Filter();
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"SoftwareComponent[@ClassIdentifier='webinfpltfm' and @Name=:'Web Infrastructure Platform' and @PublicType='Application']\"/>");
            filter.setType("SoftwareComponent");
            List results = _informationService.search(user, filter);
            if (results == null || results.size() <= 0) {
                return false;
            }
            SoftwareComponentInterface contentServer = (SoftwareComponentInterface)results.get(0);
            Map<String, String> properties = contentServer.getPublicConfigurableProperties();
            String host = properties.get("iomsrv.httpserver.host");
            String port = properties.get("iomsrv.httpserver.port");
            String domain = properties.get("iomsrv.httpserver.authdomain");
            String base = properties.get("iomsrv.httpserver.basepath.dir");
            String name = properties.get("dav.repository.name");
            RepositoryDef davRepos = new RepositoryDef(host, port, domain, base, "dav", name);
            davRepos.setAuto(true);
            _informationService.addRepositoryDef(davRepos);
            _informationService.connect(user, davRepos);
        }
        catch (RemoteException e) {
            throw new UncheckedException((Throwable)e, "Unexpected remote exception.");
        }
        return true;
    }

    public static SessionContextInterface startAndConnect(String clientApplication, ConnectionProfile connectionProfile) throws ServiceException {
        try {
            CorePlatformServices.setEnvironment(connectionProfile.getEnvironment());
            CorePlatformServices.setDefaultServicesConfigurationWithMinimumLogging();
            CorePlatformServices.startLocalServices();
            InformationServiceInterface infoService = CorePlatformServices.getInformationService();
            if (infoService != null) {
                infoService.setIsolated();
            }
            UserServiceInterface userService = CorePlatformServices.getUserService();
            userService.setGroupLoginEnabled(true);
            UserContextInterface user = null;
            try {
                String userName = connectionProfile.getProperty("userid");
                if (userName == null || userName.length() == 0) {
                    user = userService.newUser(null, clientApplication);
                } else {
                    String domain = connectionProfile.getDomain();
                    user = userService.newUser(connectionProfile.getProperty("userid"), connectionProfile.getProperty("password"), domain, null, clientApplication);
                }
            }
            catch (UserInitializationException e) {
                user = e.getUser();
            }
            if (user == null) {
                throw new ServiceException(RB.getStringResource("LocalServicesBatchUtility.InitError.NoUser.txt"));
            }
            return CorePlatformServices.getSessionService().newSessionContext(user);
        }
        catch (RemoteException e) {
            throw new UncheckedException((Throwable)e, "Unexpected remote exception.");
        }
    }
}

