/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@SASScope
final class ConsumerServiceConfigurations {
    private File _directory;
    private final Map<String, String> _consumerId2NameMap = new HashMap<String, String>(5);
    private final Map<String, Map<String, String>> _ifaceName2ConsumerFilenameMap = new HashMap<String, Map<String, String>>(5);
    private static final String[] INTERFACE_NAMES = new String[]{"com.sas.services.authentication.AuthenticationServiceInterface", "com.sas.services.information.InformationServiceInterface", "com.sas.services.session.SessionServiceInterface", "com.sas.services.user.UserServiceInterface"};

    ConsumerServiceConfigurations(File directory, Properties properties) throws ServiceException {
        if (null == directory) {
            throw new IllegalArgumentException("A directory must be specified.");
        }
        if (null == properties) {
            throw new IllegalArgumentException("Configuration properties must be specified.");
        }
        this._directory = directory;
        for (Object object : properties.keySet()) {
            String propertyName = (String)object;
            if (!propertyName.startsWith("consumer_ID_")) continue;
            String id = propertyName.substring(propertyName.lastIndexOf(95) + 1);
            this._consumerId2NameMap.put(id, properties.getProperty("consumer_name_" + id));
        }
        for (String interfaceName : INTERFACE_NAMES) {
            for (Object propertyNameObj : properties.keySet()) {
                String propertyName = (String)propertyNameObj;
                if (!propertyName.startsWith(interfaceName + "_")) continue;
                String suffix = propertyName.substring(propertyName.lastIndexOf(95) + 1);
                try {
                    Integer.valueOf(suffix);
                    String consumerName = this._consumerId2NameMap.get(suffix);
                    String fileName = properties.getProperty(propertyName);
                    Map<String, String> map = this._ifaceName2ConsumerFilenameMap.get(interfaceName);
                    if (null == map) {
                        map = new HashMap<String, String>(5);
                        this._ifaceName2ConsumerFilenameMap.put(interfaceName, map);
                    }
                    map.put(consumerName, fileName);
                }
                catch (NumberFormatException e) {}
            }
        }
        for (Map.Entry entry : this._ifaceName2ConsumerFilenameMap.entrySet()) {
            String interfaceName = (String)entry.getKey();
            System.out.println("");
            System.out.println("interface=" + interfaceName);
            for (Map.Entry consumerFileEntry : ((Map)entry.getValue()).entrySet()) {
                String consumerName = (String)consumerFileEntry.getKey();
                String filePath = (String)consumerFileEntry.getValue();
                System.out.println("[consumerName=" + consumerName + "][file=" + filePath + ']');
            }
        }
    }

    Set<String> getServiceInterfaces() {
        return new HashSet<String>(this._ifaceName2ConsumerFilenameMap.keySet());
    }

    Map<String, File> getConsumerName2FileMap(String serviceInterface) {
        Map<String, String> map = this._ifaceName2ConsumerFilenameMap.get(serviceInterface);
        int numConfigs = map.size();
        HashMap<String, File> nameFileMap = new HashMap<String, File>(numConfigs > 0 ? numConfigs : 0);
        if (numConfigs > 0) {
            for (Map.Entry<String, String> mapEntry : map.entrySet()) {
                nameFileMap.put(mapEntry.getKey(), new File(this._directory, mapEntry.getValue()));
            }
        }
        return nameFileMap;
    }
}

